'Harlan Brumm, Global Technical Lead Revit Architecture - Product Support
'Autodesk, Inc.  2010
'This Script resets the a Revit 2011 Product User Interface by renaming or deleting UIState.dat (based on user choice) and deletes the Project Browser Regristy key.
Option Explicit
On Error Resume Next 
DIM objFSO
DIM objFLO
DIM strFilePath
Dim objShell
Dim regLogonUserName
Dim LogonUserName
DIM strComputer
DIM objReg
DIm strKeyPath
DIM objRegistry
DIM arrSubkeys
DIM strpromptRQAT
DIM strTitleRQAT
DIM intBTNRQAT
DIM intRTNRQAT
DIM strpromptPB
DIM strTitlePB
DIM intBTNPB
DIM intRTNPB
Dim strPromptRQAT1
Dim strTitleRQAT1 
DIM intBTNRQAT1
DIM intRTNRQAT1
DIM strPromptRQAT2
DIM strTitleRQAT2
DIM intBTNRQAT2
DIM intRTNRQAT2
DIM strPromptStart
DIM strTitleStart
DIM intBTNStart
DIM intRTNStart
DIM strNewFile
DIM objWMI
DIM objFile
DIM intRC
DIM objWMIService
DIM colProcesses
DIM objProcess
DIM strPromptRun
DIM strTitleRun
DIM intRTNRun
DIM strSubkey
DIM WshNetwork
DIM fname
DIM RevitName
DIM filesys
DIM RevitShortName
DIM strNoRevit
DIM strNoRevitTitle
DIM intNoRevit

'Setting up Presets and determine using login name
strComputer = "."
strPromptStart = "WARNING!! You are about to reset your " & RevitName & " User Interface.  Ensure that you run this script with ADMIN privileges. Do You Wish to Continue?"
strTitleStart = "Reset Ribbon, Quick Access Toolbar and Project Browser"


intRTNStart = MsgBox(strpromptStart,vbYesNo+VBExclamation,strTitleStart)

If intRTNStart = vbYes Then

'Determine Login UserName
Set WshNetwork = WScript.CreateObject("WScript.Network")
LogonUserName = WshNetwork.UserName
'WScript.Echo "Current User Name: " & LogonUserName

Set objFLO = CreateObject("Scripting.FileSystemObject")

Do
fname = inputbox("Enter the Name of Revit product to fix.               Type either: Architecture, Structure, or MEP below ")

If fname = "Architecture" then
Wscript.Echo "Autodesk Revit Architecture 2011 will be reset"
RevitName = "Autodesk Revit Architecture 2011"
RevitShortName = "Revit Architecture 2011"
Exit Do
ElseIf fname = "Structure" then
Wscript.Echo "Autodesk Revit Structure 2011 will be reset"
RevitName = "Autodesk Revit Structure 2011"
RevitShortName = "Revit Structure 2011"
Exit Do
ElseIf fname = "MEP" then
Wscript.Echo "Autodesk Revit MEP 2011 will be reset"
RevitName = "Autodesk Revit MEP 2011"
RevitShortName = "Revit MEP 2011"
Exit Do
ElseIf fname = "" then 
Wscript.Quit
Else 
Wscript.Echo "Product Not recongized. Try again."
End If
Loop

'Determine if Revit.exe exists for Revit 2011
Set filesys = CreateObject("Scripting.FileSystemObject") 
If filesys.FileExists ("C:\Program Files\Autodesk\" & RevitShortName & "\Program\Revit.exe") Then
   Wscript.Echo RevitName & " is Installed. Can proceed with resetting UI"
   Else
   strNoRevit = "Autodesk " & RevitShortName & " is NOT Installed.  This Script is to be run when " & RevitName & " is Installed."
   strNoRevitTitle = RevitName & " Not Installed"
   intNoRevit = msgbox(strNoRevit,vbOkOnly+VBExclamation,strNoRevitTitle)
   Wscript.Quit
End If 

'Verifying Vista or XP and setting correct paths for UIState.dat
If objFLO.FolderExists ("c:\Users") Then
strFilePath = "C:\Users\" & LogonUserName & "\AppData\Local\Autodesk\Revit\" & RevitName & "\UIState.dat" 
Else
strFilePath = "C:\Documents and Settings\" & LogonUserName & "\Local Settings\Application Data\Autodesk\Revit\" & RevitName & "\UIState.dat"
End If

'Setting name for renamed UIState.dat
If strFilePath = "C:\Users\" & LogonUserName & "\AppData\Local\Autodesk\Revit\" & RevitName & "\UIState.dat" then
strNewFile = "C:\Users\" & LogonUserName & "\AppData\Local\Autodesk\Revit\" & RevitName & "\UIState.dat." & Year(Now()) & Month(Now()) & Day(Now()) & Hour(Now()) & Minute(Now()) & Second(Now())
Else
strNewFile = "C:\Documents and Settings\" & LogonUserName & "\Local Settings\Application Data\Autodesk\Revit\" & RevitName & "\UIState.dat." & Year(Now()) & Month(Now()) & Day(Now()) & Hour(Now()) & Minute(Now()) & Second(Now())
End If

'Checking to make sure that Revit.exe process is not running
Set objWMIService = GetObject("winmgmts:\\" & strComputer & "\root\cimv2")
Set colProcesses = objWMIService.ExecQuery("Select * from Win32_Process")

For Each objProcess in colProcesses
    If Right(objProcess.Name, 9) = "Revit.exe" Then
     
	strPromptRun = "This script can only be run when Autodesk Revit based products are closed.  Please close Autodesk Revit based products and run this tool again.  There may occur a delay between closing Autodesk Revit based products and being allowed to run this script"
	strTitleRun = "Revit.exe is running..."

	intRTNRun = MsgBox(strPromptRun, vbOkonly+VBCritical,strTitleRun)
        Wscript.Quit
    End If

Next

'Renaming UIState.dat

strPromptRQAT = "You can now reset your Ribbon and Quick Access Toolbar.  Are you sure you wish to continue?"
strTitleRQAT = "Reset the " & RevitName & " Ribbon and Quick Access Toolbar"
intBTNRQAT = 4 '4 is yes/no 3 is yes/no/cancel

intRTNRQAT = MsgBox(strpromptRQAT, vbYesNo+VBQuestion,strTitleRQAT)

If intRTNRQAT = vbYes Then

	strPromptRQAT1 = "Do you wish to create a Backup of your existing User Interface?  Selecting Yes will rename your User Interface file with todays date and time.  Selecting No will delete your User Interface file."
	strTitleRQAT1 = "Reset " & RevitName & " Ribbon and Quick Access Toolbar"
	intBTNRQAT1 = 4 '4 is yes/no 3 is yes/no/cancel	
	
	intRTNRQAT1 = MsgBox(strpromptRQAT1, vbYesNo+VBQuestion,strTitleRQAT1)	
	
		If intRTNRQAT1 = vbYes Then
			set objWMI = GetObject("winmgmts:\\" & strComputer & "\root\cimv2")
			set objFile = objWMI.Get("Cim_Datafile='" & strFilePath & "'")
			WScript.Echo "Renaming " & strFilePath
			intRC = objFile.Rename(strNewFile)
			if intRC <> 0 then
 				WScript.Echo "There was an error renaming the file: " & intRC
			else
 				WScript.Echo "Successfully reset " & RevitName & " Ribbon and Quick Access Toolbar"
			end if
		Else 
			WScript.Echo "Deleting " & strFilePath
			set objFSO = CreateObject("Scripting.FileSystemObject")
			objFSO.DeleteFile(strFilePath)
			WScript.Echo "Successfully reset " & RevitName & " Ribbon and Quick Access Toolbar"  
		End If
	
Else
	WScript.Echo   RevitName & " Ribbon and Quick Access Toolbar have not been reset"
End If

'Resetting location of browsers back to OOTB.
strPromptPB = "You can now reset the location of your Project Browser.  Are you sure you wish to continue? This will delete a registry key on your computer."
strTitlePB = "Reset the " & RevitName & " Project Browser"


intRTNPB = MsgBox(strpromptPB, vbYesNo+VBQuestion,strTitlePB)

If intRTNPB = vbYes Then

		Const HKEY_CURRENT_USER = &H80000001 
		strKeyPath = "Software\Autodesk\Revit\" & RevitName & "\Components\Panels" 
		Set objRegistry = GetObject("winmgmts:\\" & _
		strComputer & "\root\default:StdRegProv") 
		WScript.Echo "Deleting HKEY_CURRENT_USER\Software\Autodesk\Revit\" & RevitName & "\Components\Panels"		
		DeleteSubkeys HKEY_CURRENT_USER, strKeypath 

		Sub DeleteSubkeys(HKEY_CURRENT_USER, strKeyPath) 
		objRegistry.EnumKey HKEY_CURRENT_USER, strKeyPath, arrSubkeys 
		If IsArray(arrSubkeys) Then 
			For Each strSubkey In arrSubkeys 
			DeleteSubkeys HKEY_CURRENT_USER, strKeyPath & "\" & strSubkey 
			Next 
		End If 
		objRegistry.DeleteKey HKEY_CURRENT_USER, strKeyPath 
		End Sub
	WScript.Echo "Successfully Reset " & RevitName & " Project Browser"

	Else
		WScript.Echo RevitName & " Project Browser has not been reset"
End If
	
	WScript.Echo "Script Complete"
Else
	WScript.Echo "Script Canceled"
End If