;;
;;  Copyright 1991, 1992, 1993, 1994, 1996 by Autodesk, Inc.
;;  AutoCAD Hatch Patterns
;;
;%UNITS=INCH
;%VERSION=3.0

;; Note: Dummy pattern description used for 'Solid fill'.
*SOLID, Solid fill
45, 0,0, 0,.125
*ANGLE, Angle steel
0, 0,0, 0,.275, .2,-.075
90, 0,0, 0,.275, .2,-.075
*ANSI31, ANSI Iron, Brick, Stone masonry
45, 0,0, 0,.125
*ANSI32, ANSI Steel
45, 0,0, 0,.375
45, .176776695,0, 0,.375
*ANSI33, ANSI Bronze, Brass, Copper
45, 0,0, 0,.25
45, .176776695,0, 0,.25, .125,-.0625
*ANSI34, ANSI Plastic, Rubber
45, 0,0, 0,.75
45, .176776695,0, 0,.75
45, .353553391,0, 0,.75
45, .530330086,0, 0,.75
*ANSI35, ANSI Fire brick, Refractory material
45, 0,0, 0,.25
45, .176776695,0, 0,.25, .3125,-.0625,0,-.0625
*ANSI36, ANSI Marble, Slate, Glass
45, 0,0, .21875,.125, .3125,-.0625,0,-.0625
*ANSI37, ANSI Lead, Zinc, Magnesium, Sound/Heat/Elec Insulation
45, 0,0, 0,.125
135, 0,0, 0,.125
*ANSI38, ANSI Aluminum
45, 0,0, 0,.125
135, 0,0, .25,.125, .3125,-.1875
;;
;;  The following hatch patterns AR-xxxxx
;;  come from AEC/Architectural
;;
*AR-B816, 8x16 Block elevation stretcher bond
;%TYPE=MODEL
0,       0,0,      0,8
90,      0,0,      8,8,                          8,-8
*AR-B816 STACKED, 8x16 Block elevation stacked bond
;%TYPE=MODEL
0,       0,0,      0,8
90,      0,0,     0,16                       
*AR-B816C, 8x16 Block elevation stretcher bond with mortar joints
;%TYPE=MODEL
0,       0,0,      8,8,                         15.625,-.375
0,      -8,.375,   8,8,                         15.625,-.375
90,      0,0,      8,8,                        -8.375,7.625
90,     -0.375,0,  8,8,                        -8.375,7.625
*AR-B88, 8x8 Block elevation stretcher bond
;%TYPE=MODEL
0,       0,0,      0,8
90,      0,0,      8,4,                          8,-8
*2x5 tile, 2x5 tile elevation stretcher bond
;%TYPE=MODEL
0,       0,0,      0,24
90,      0,0,      0,60,                         60,0
*AR-BRICK SOLDIER, 8x8 Block elevation stretcher bond
;%TYPE=MODEL
0,       0,0,      0,8
90,      0,0,      8,2.667,                          8,0
*AR-BRELM, Standard brick elevation english bond with mortar joints
;%TYPE=MODEL
0,      0,0,       0,5.334,                      7.625,-.375
0,      0,2.25,    0,5.334,                      7.625,-.375
0,      2,2.667,   0,5.334,                      3.625,-.375
0,      2,4.917,   0,5.334,                      3.625,-.375
90,     0,0,       0,8,                          2.25,-3.084
90,    -0.375,0,   0,8,                          2.25,-3.084
90,     2,2.667,   0,4,                          2.25,-3.084
90,     1.625,2.667,  0,4,                       2.25,-3.084
*AR-BRSTD, Standard brick elevation stretcher bond
;%TYPE=MODEL
0,       0,0,      0,2.667
90,      0,0,      2.667,4,                      2.667,-2.667
*AR-CONC, Random dot and stone pattern
50,      0,0,      4.12975034,-5.89789472,       0.75,-8.25
355,     0,0,     -2.03781207,7.37236840,        0.60,-6.6
100.4514, 0.5977168,-0.0522934, 5.7305871,-6.9397673, 0.6374019,-7.01142112
46.1842, 0,2,      6.19462551,-8.84684208,       1.125,-12.375
96.6356, 0.88936745,1.86206693, 8.59588071,-10.40965104, 0.95610288,-10.51713
351.1842, 0,2,     7.74328189,11.0585526,        0.9,-9.9
21,      1,1.5,    4.12975034,-5.89789472,       0.75,-8.25
326,     1,1.5,   -2.03781207,7.37236840,        0.60,-6.6
71.4514, 1.49742233,1.16448394, 5.7305871,-6.9397673, 0.6374019,-7.01142112
37.5,    0,0,      2.123,2.567,                  0,-6.52,0,-6.7,0,-6.625
7.5,     0,0,      3.123,3.567,                  0,-3.82,0,-6.37,0,-2.525
-32.5,  -2.23,0,   4.6234,2.678,                 0,-2.5,0,-7.8,0,-10.35
-42.5,  -3.23,0,   3.6234,4.678,                 0,-3.25,0,-5.18,0,-7.35
*AR-HBONE, Standard brick herringbone pattern @ 45 degrees
;%TYPE=MODEL
45,      0,0,      4,4,                          12,-4
135,     2.828427125,2.828427125,  4,-4,         12,-4
*AR-PARQ1, 2x12 Parquet flooring: pattern of 12x12
;%TYPE=MODEL
90,      0,0,      12,12,                        12,-12
90,      2,0,      12,12,                        12,-12
90,      4,0,      12,12,                        12,-12
90,      6,0,      12,12,                        12,-12
90,      8,0,      12,12,                        12,-12
90,     10,0,      12,12,                        12,-12
90,     12,0,      12,12,                        12,-12
0,      0,12,      12,-12,                       12,-12
0,      0,14,      12,-12,                       12,-12
0,      0,16,      12,-12,                       12,-12
0,      0,18,      12,-12,                       12,-12
0,      0,20,      12,-12,                       12,-12
0,      0,22,      12,-12,                       12,-12
0,      0,24,      12,-12,                       12,-12
*AR-RROOF, Roof shingle texture
;%TYPE=MODEL
0, 0,0, 2.2,1, 15,-2,5,-1
0, 1.33,0.5, -1,1.33, 3,-0.33,6,-0.75
0, 0.5,0.85, 5.2,0.67, 8,-1.4,4,-1
*AR-RSHKE, Roof wood shake texture
;%TYPE=MODEL
0,       0,0,      25.5,12,                        6,-5,7,-3,9,-4
0,       6,.5,     25.5,12,                        5,-19,4,-6
0,       18,-.75,  25.5,12,                        3,-31
90,      0,0,      12,8.5,                       11.5,-36.5
90,      6,0,      12,8.5,                       11.25,-36.75
90,      11,0,     12,8.5,                       10.5,-37.5
90,      18,-0.75, 12,8.5,                       11.5,-36.5
90,      21,-0.75, 12,8.5,                       11.5,-36.5
90,      30,0,     12,8.5,                       11,-37
*AR-SAND, Random dot pattern
37.5,   0,0,       1.123,1.567,                  0,-1.52,0,-1.7,0,-1.625
7.5,    0,0,       2.123,2.567,                  0,-.82,0,-1.37,0,-.525
-32.5, -1.23,0,    2.6234,1.678,                 0,-.5,0,-1.8,0,-2.35
-42.5, -1.23,0,    1.6234,2.678,                 0,-.25,0,-1.18,0,-1.35
*BOX, Box steel
90, 0,0, 0,1
90, .25,0, 0,1
0, 0,0, 0,1, -.25,.25
0, 0,.25, 0,1, -.25,.25
0, 0,.5, 0,1, .25,-.25
0, 0,.75, 0,1, .25,-.25
90, .5,0, 0,1, .25,-.25
90, .75,0, 0,1, .25,-.25
*BRASS, Brass material
0, 0,0, 0,.25
0, 0,.125, 0,.25, .125,-.0625
*BRICK, Brick or masonry-type surface
0, 0,0, 0,.25
90, 0,0, 0,.5, .25,-.25
90, .25,0, 0,.5, -.25,.25
*BRSTONE, Brick and stone
;%TYPE=MODEL
0, 0,0, 0,.33
90, .9,0,  .33,.5,    .33,-.33
90, .8,0,  .33,.5,    .33,-.33  
0, .9,.055,  .5,.33,  -.9, .1
0, .9,.11,  .5,.33,  -.9, .1
0, .9,.165,  .5,.33,  -.9, .1
0, .9,.22,  .5,.33,  -.9, .1
0, .9,.275,  .5,.33,  -.9, .1
*CLAY, Clay material
0, 0,0, 0,.1875
0, 0,.03125, 0,.1875
0, 0,.0625, 0,.1875
0, 0,.125, 0,.1875, .1875,-.125
*CORK, Cork material
0, 0,0, 0,.125
135, .0625,-.0625, 0,.35355339, .176776696,-.176776696
135, .09375,-.0625, 0,.35355339, .176776696,-.176776696
135, .125,-.0625, 0,.35355339, .176776696,-.176776696
*CROSS, A series of crosses
0, 0,0, .25,.25, .125,-.375
90, .0625,-.0625, .25,.25, .125,-.375
*DASH, Dashed lines
0, 0,0, .125,.125, .125,-.125
*DOLMIT, Geological rock layering
0, 0,0, 0,.25
45, 0,0, 0,.70710678, .35355339,-.70710768
*DOTS, A series of dots
0, 0,0, .03125,.0625, 0,-.0625
*EARTH, Earth or ground (subterranean)
0, 0,0, .25,.25, .25,-.25
0, 0,.09375, .25,.25, .25,-.25
0, 0,.1875, .25,.25, .25,-.25
90, .03125,.21875, .25,.25, .25,-.25
90, .125,.21875, .25,.25, .25,-.25
90, .21875,.21875, .25,.25, .25,-.25
*ESCHER, Escher pattern
60, 0,0, -.6,1.039230484, 1.1,-.1
180, 0,0, -.6,1.039230484, 1.1,-.1
300, 0,0, .6,1.039230484, 1.1,-.1
60, .1,0, -.6,1.039230484, .2,-1
300, .1,0, .6,1.039230484, .2,-1
60, -.05,.08660254, -.6,1.039230484, .2,-1
180, -.05,.08660254, -.6,1.039230484, .2,-1
300, -.05,-.08660254, .6,1.039230484, .2,-1
180, -.05,-.08660254, -.6,1.039230484, .2,-1
60, -.4,0, -.6,1.039230484, .2,-1
300, -.4,0, .6,1.039230484, .2,-1
60, .2,-.346410161, -.6,1.039230484, .2,-1
180, .2,-.346410161, -.6,1.039230484, .2,-1
300, .2,.346410161, .6,1.039230484, .2,-1
180, .2,.346410161, -.6,1.039230484, .2,-1
0, .2,.173205081, -.6,1.039230484, .7,-.5
0, .2,-.173205081, -.6,1.039230484, .7,-.5
120, .05,.259807621, .6,1.039230484, .7,-.5
120, -.25,.08660254, .6,1.039230484, .7,-.5
240, -.25,-.08660254, .6,1.039230484, .7,-.5
240, .05,-.259807621, .6,1.039230484, .7,-.5
*FLEX, Flexible material
0, 0,0, 0,.25, .25,-.25
45, .25,0, .176776695,.176776695, .0625,-.228553391,.0625,-.353553391
*GRASS, Grass area
90, 0,0, .707106781,.707106781, .1875,-1.226713563
45, 0,0, 0,1, .1875,-.8125
135, 0,0, 0,1, .1875,-.8125
*GRATE, Grated area
0, 0,0, 0,.03125
90, 0,0, 0,.125
*HEX, Hexagons
0, 0,0, 0,.216506351, .125,-.25
120, 0,0, 0,.216506351, .125,-.25
60, .125,0, 0,.216506351, .125,-.25
*HONEY, Honeycomb pattern
0, 0,0, .1875,.108253175, .125,-.25
120, 0,0, .1875,.108253175, .125,-.25
60, 0,0, .1875,.108253175, -.25,.125
*HOUND, Houndstooth check
0, 0,0, .25,.0625, 1,-.5
90, 0,0, -.25,.0625, 1,-.5
*INSUL, Insulation material
0, 0,0, 0,.375
0, 0,.125, 0,.375, .125,-.125
0, 0,.25, 0,.375, .125,-.125
;;
;;  Hatch Pattern Definition related to ISO/DIS 12011 line types
;;
;;  (Width * 5 = Distance between lines)
;;
;;  The size of the line segments related to the ISO/DIS 12011 linetypes
;;  define the following hatch pattern. 
;;  The pen width of 1 mm is the base of the definition. To use them with
;;  the other ISO/DIS 12011 predefined pen widths, the line has to be scaled
;;  with the appropriate value (e.g. pen width 0,5 mm -> ltscale 0.5).
;;
*ACAD_ISO02W100, dashed line
0, 0,0, 0,5, 12,-3
*ACAD_ISO03W100, dashed space line
0, 0,0, 0,5, 12,-18
*ACAD_ISO04W100, long dashed dotted line
0, 0,0, 0,5, 24,-3,.5,-3
*ACAD_ISO05W100, long dashed double dotted line
0, 0,0, 0,5, 24,-3,.5,-3,.5,-3
*ACAD_ISO06W100, long dashed triplicate dotted line
0, 0,0, 0,5, 24,-3,.5,-3,.5,-6.5
0, 0,0, 0,5, -34,.5,-3
*ACAD_ISO07W100, dotted line
0, 0,0, 0,5, .5,-3
*ACAD_ISO08W100, long dashed short dashed line
0, 0,0, 0,5, 24,-3,6,-3
*ACAD_ISO09W100, long dashed double-short-dashed line
0, 0,0, 0,5, 24,-3,6,-3,6,-3
*ACAD_ISO10W100, dashed dotted line
0, 0,0, 0,5, 12,-3,.5,-3
*ACAD_ISO11W100, double-dashed dotted line
0, 0,0, 0,5, 12,-3,12,-3,.5,-3
*ACAD_ISO12W100, dashed double-dotted line
0, 0,0, 0,5, 12,-3,.5,-3,.5,-3
*ACAD_ISO13W100, double-dashed double-dotted line
0, 0,0, 0,5, 12,-3,12,-3,.5,-6.5
0, 0,0, 0,5, -33.5,.5,-3
*ACAD_ISO14W100, dashed triplicate-dotted line
0, 0,0, 0,5, 12,-3,.5,-3,.5,-6.5
0, 0,0, 0,5, -22,.5,-3
*ACAD_ISO15W100, double-dashed triplicate-dotted line
0, 0,0, 0,5, 12,-3,12,-3,.5,-10
0, 0,0, 0,5, -33.5,.5,-3,.5,-3
;;
;; end of ACAD_ISO hatch pattern definition
;;
*LINE, Parallel horizontal lines
0, 0,0, 0,.125
*MUDST, Mud and sand
0, 0,0, .5,.25, .25,-.25,0,-.25,0,-.25
*NET, Horizontal / vertical grid
0, 0,0, 0,.125
90, 0,0, 0,.125
*NET3, Network pattern 0-60-120
0, 0,0, 0,.125
60, 0,0, 0,.125
120, 0,0, 0,.125
*PLAST, Plastic material
0, 0,0, 0,.25
0, 0,.03125, 0,.25
0, 0,.0625, 0,.25
*PLASTI, Plastic material
0, 0,0, 0,.25
0, 0,.03125, 0,.25
0, 0,.0625, 0,.25
0, 0,.15625, 0,.25
*SACNCR, Concrete
45, 0,0, 0,.09375
45, .066291261,0, 0,.09375, 0,-.09375
*SQUARE,Small aligned squares
0, 0,0, 0,.125, .125,-.125
90, 0,0, 0,.125, .125,-.125
*STARS, Star of David
0, 0,0, 0,.216506351, .125,-.125
60, 0,0, 0,.216506351, .125,-.125
120, .0625,.108253176, 0,.216506351, .125,-.125
*STEEL, Steel material
45, 0,0, 0,.125
45, 0,.0625, 0,.125
*SWAMP, Swampy area
0, 0,0, .5,.866025403, .125,-.875
90, .0625,0, .866025403,.5, .0625,-1.669550806
90, .078125,0, .866025403,.5, .05,-1.682050806
90, .046875,0, .866025403,.5, .05,-1.682050806
60, .09375,0, .5,.866025403, .04,-.96
120, .03125,0, .5,.866025403, .04,-.96
*TRANS, Heat transfer material
0, 0,0, 0,.25
0, 0,.125, 0,.25, .125,-.125
*TRIANG, Equilateral triangles
60, 0,0, .1875,.324759526, .1875,-.1875
120, 0,0, .1875,.324759526, .1875,-.1875
0, -.09375,.162379763, .1875,.324759526, .1875,-.1875
*ZIGZAG, Staircase effect
0, 0,0, .125,.125, .125,-.125
90, .125,0, .125,.125, .125,-.125

*ARCHT01, ARCHT Wall pouche
45, 0,0, 0,.71
135, 0,0, 0,.71
*ARCHT02, ARCHT Wall pouche
45, 0,0, 0,1.42
135, 0,0, 0,1.42
*ARCHT03, ARCHT Wall pouche
45, 0,0, 0,.5
*ARCHT04, ARCHT Wall pouche
90, 0,0, 0,.5
*ARCHT05, ARCHT Wall insulation pouche
66.422,.33093,.05,.91652,.4,.17267,-.09109,.45446,-.09109,.17267,-.10911
113.578,.06907,.05,.17457,.4,.17267,-.09109,.45446,-.09109,.17267,-.10911
0, 0.06907,0.05, 0,1.0, 0.26186,-0.17457
0, 0.28729,0.95, 0,1.0, 0.26186,-0.17457
90, 0,0.20826, 0,0.43644, 0.08348,-0.91652
90, 0.21822,0.70826, 0,0.43644, 0.08348,-0.91652
90, 0.4,0.20826, 0,0.43644, 0.08348,-0.91652
90, 0.61822,0.70826, 0,0.43644, 0.08348,-0.91652
*ARCHT06, ARCHT Wall concrete pouche
35,0,0,.3,.7,0,-1
0,0,0,4,6.928,.5,-7.5
60,0,0,4,6.928,.5,-7.5
120,.5,0,4,6.928,.5,-7.5
70,0,0,0,1.4,.125,-1.59
130,.125,0,0,1.7,.125,-1.48
*ARCHT07, ARCHT Wall concrete pouche
000, 0.50,0.50, 0.00,2.50, 0.25,-2.25
000, 1.25,1.00, 0.00,2.50, 0.25,-2.25
000, 0.75,2.00, 0.00,2.50, 0.25,-1.00,0.25,-1.00
090, 0.50,0.50, 0.00,2.50, 0.25,-2.25
090, 0.75,2.00, 0.00,2.50, 0.25,-2.25
090, 1.50,1.00, 0.00,2.50, 0.25,-2.25
090, 2.00,1.75, 0.00,2.50, 0.25,-2.25
135, 0.75,0.50, 1.7678,1.7678, 0.3536,-3.1820
135, 1.00,2.00, 1.7678,1.7678, 0.3536,-3.1820
045, 1.25,1.00, 1.7678,1.7678, 0.3536,-.7071,0.3536,-2.1213
000, -0.50,0.00, 0.25,0.25, -0.50,0
*ARCHT08, ARCHT Wall pouche
90, .05,0, 0,2
90, .23,0, 0,2
90, .41,0, 0,2
90, .59,0, 0,2
90, .77,0, 0,2
90, .95,0, 0,2
*ARCHT09, ARCHT Wall pouche
90, .05,0, 0,2
90, .23,0, 0,2
90, .41,0, 0,2
90, .59,0, 0,2
90, .77,0, 0,2
90, .95,0, 0,2
0, 1.45,.25, 0,1, .1,-1.9
0, 1.3,.35, 0,1, .4,-1.6
0, 1.25,.45, 0,1, .5,-1.5
0, 1.25,.55, 0,1, .5,-1.5
0, 1.3,.65, 0,1, .4,-1.6
0, 1.45,.75, 0,1, .1,-1.9
*ARCHT10, ARCHT Wall pouche
0, .1,.1, 0,1, .25,-1.75
0, .1,.9, 0,1, .25,-1.75
90, .1,.1, 1,2, .8,-.2
*ARCHT11, ARCHT Wall pouche
0, 0,.25, 0,1
0, 0,.5, 0,1
0, 0,.75, 0,1
*ARCHT12, ARCHT Wall pouche
90, .05,0, 0,2
90, .23,0, 0,2
90, .41,0, 0,2
90, .59,0, 0,2
90, .77,0, 0,2
90, .95,0, 0,2
0, 1,.05, 0,1, 1,-1
0, 1,.23, 0,1, 1,-1
0, 1,.41, 0,1, 1,-1
0, 1,.59, 0,1, 1,-1
0, 1,.77, 0,1, 1,-1
0, 1,.95, 0,1, 1,-1
*BRICK00,temp
;%TYPE=MODEL
0.00000, 0.00000,0.00000, 0.00000,16.00000
270.00000, 8.00000,8.00000, 0.00000,16.00000, 8.00000,-8.00000
90.00000, 0.00000,8.00000, 0.00000,16.00000, 8.00000,-8.00000
270.00000, 16.00000,16.00000, 0.00000,16.00000, 8.00000,-8.00000
180.00000, 16.00000,8.00000, 0.00000,16.00000
*BRICK01,temp
;%TYPE=MODEL
90.00000, 4.25000,4.00000, 0.00000,8.00000, 4.00000,-4.00000
180.00000, 8.00000,8.00000, 0.00000,8.00000
180.00000, 8.00000,4.00000, 0.00000,8.00000
90.00000, 0.00000,0.00000, 0.00000,8.00000, 4.00000,-4.00000
*BRICK02,running
;%TYPE=MODEL
180.00000, 12.25000,7.75000, 0.00000,8.00000, 7.75000,-0.25000
180.00000, 8.00000,3.75000, 0.00000,8.00000, 7.75000,-0.25000
90.00000, 0.25000,0.00000, 0.00000,8.00000, 3.75000,-4.25000
90.00000, 4.50000,4.00000, 0.00000,8.00000, 3.75000,-4.25000
90.00000, 4.25000,4.00000, 0.00000,8.00000, 3.75000,-4.25000
180.00000, 8.00000,8.00000, 0.00000,8.00000, 7.75000,-0.25000
0.00000, 4.50000,4.00000, 0.00000,8.00000, 7.75000,-0.25000
90.00000, 0.00000,0.00000, 0.00000,8.00000, 3.75000,-4.25000
*BRICK03,temp
;%TYPE=MODEL
180.00000, 8.00000,8.00000, 0.00000,12.00000
270.00000, 8.00000,12.00000, 0.00000,8.00000, 4.00000,-8.00000
180.00000, 8.00000,0.00000, 0.00000,12.00000
270.00000, 6.00000,8.00000, 0.00000,8.00000, 8.00000,-4.00000
270.00000, 2.00000,8.00000, 0.00000,8.00000, 8.00000,-4.00000
*BRICK04,Running stack
;%TYPE=MODEL
180.00000, 5.75000,0.25000, 0.00000,12.00000, 3.75000,-4.25000
180.00000, 5.75000,8.00000, 0.00000,12.00000, 3.75000,-4.25000
180.00000, 9.75000,8.00000, 0.00000,12.00000, 3.75000,-4.25000
270.00000, 1.75000,8.00000, 0.00000,8.00000, 7.75000,-4.25000
270.00000, 5.75000,8.00000, 0.00000,8.00000, 7.75000,-4.25000
270.00000, 7.75000,12.00000, 0.00000,8.00000, 3.75000,-8.25000
180.00000, 7.75000,8.25000, 0.00000,12.00000, 7.75000,-0.25000
0.00000, 6.00000,0.25000, 0.00000,12.00000, 3.75000,-4.25000
270.00000, 2.00000,8.00000, 0.00000,8.00000, 7.75000,-4.25000
270.00000, 6.00000,8.00000, 0.00000,8.00000, 7.75000,-4.25000
180.00000, 7.75000,0.00000, 0.00000,12.00000, 7.75000,-0.25000
270.00000, 8.00000,12.00000, 0.00000,8.00000, 3.75000,-8.25000
*BRICK05, TEMP
;%TYPE=MODEL
270.00000, 0.00000,4.00000, 0.00000,8.00000, 4.00000,-20.00000
270.00000, 4.00000,8.00000, 0.00000,8.00000, 4.00000,-20.00000
270.00000, 4.00000,16.00000, 0.00000,8.00000, 4.00000,-20.00000
270.00000, 0.00000,12.00000, 0.00000,8.00000, 4.00000,-20.00000
180.00000, 8.00000,4.00000, 0.00000,24.00000
180.00000, 8.00000,8.00000, 0.00000,24.00000
180.00000, 8.00000,12.00000, 0.00000,24.00000
180.00000, 8.00000,16.00000, 0.00000,24.00000
180.00000, 8.00000,20.00000, 0.00000,24.00000
0.00000, 0.00000,24.00000, 0.00000,24.00000
270.00000, 0.00000,20.00000, 0.00000,8.00000, 4.00000,-20.00000
270.00000, 2.00000,24.00000, 0.00000,8.00000, 4.00000,-20.00000
270.00000, 6.00000,24.00000, 0.00000,8.00000, 4.00000,-20.00000
*BRICK06,temp
;%TYPE=MODEL
0.00000, 2.25000,24.00000, 0.00000,24.25000, 3.75000,-4.25000
180.00000, 6.00000,20.25000, 0.00000,24.25000, 3.75000,-4.25000
180.00000, 4.00000,12.25000, 0.00000,24.25000, 7.75000,-0.25000
180.00000, 4.00000,4.25000, 0.00000,24.25000, 7.75000,-0.25000
270.00000, 0.25000,4.00000, 0.00000,8.00000, 4.00000,-20.25000
270.00000, 4.25000,8.00000, 0.00000,8.00000, 3.75000,-20.50000
270.00000, 0.25000,12.00000, 0.00000,8.00000, 3.75000,-20.50000
270.00000, 0.25000,20.00000, 0.00000,8.00000, 3.75000,-20.50000
270.00000, 4.25000,16.00000, 0.00000,8.00000, 3.75000,-20.50000
270.00000, 6.25000,24.00000, 0.00000,8.00000, 3.75000,-20.50000
270.00000, 2.25000,24.00000, 0.00000,8.00000, 3.75000,-20.50000
0.00000, 0.25000,24.25000, 0.00000,24.25000, 7.75000,-0.25000
0.00000, -1.75000,20.25000, 0.00000,24.25000, 3.75000,-4.25000
180.00000, 8.00000,16.25000, 0.00000,24.25000, 7.75000,-0.25000
180.00000, 8.00000,8.25000, 0.00000,24.25000, 7.75000,-0.25000
270.00000, 6.00000,24.00000, 0.00000,8.00000, 3.75000,-20.50000
270.00000, 2.00000,24.00000, 0.00000,8.00000, 3.75000,-20.50000
270.00000, 0.00000,20.00000, 0.00000,8.00000, 3.75000,-20.50000
180.00000, 2.00000,24.00000, 0.00000,24.25000, 3.75000,-4.25000
180.00000, 8.00000,20.00000, 0.00000,24.25000, 7.75000,-0.25000
0.00000, -3.75000,16.00000, 0.00000,24.25000, 7.75000,-0.25000
180.00000, 8.00000,12.00000, 0.00000,24.25000, 7.75000,-0.25000
0.00000, -3.75000,8.00000, 0.00000,24.25000, 7.75000,-0.25000
180.00000, 8.00000,4.00000, 0.00000,24.25000, 7.75000,-0.25000
270.00000, 0.00000,12.00000, 0.00000,8.00000, 3.75000,-20.50000
270.00000, 4.00000,16.00000, 0.00000,8.00000, 3.75000,-20.50000
270.00000, 4.00000,8.00000, 0.00000,8.00000, 3.75000,-20.50000
270.00000, 0.00000,4.00000, 0.00000,8.00000, 4.00000,-20.25000
*BRICK07,temp
;%TYPE=MODEL
270.00000, 10.00000,4.00000, 0.00000,24.00000, 4.00000,-20.00000
270.00000, 18.00000,4.00000, 0.00000,24.00000, 4.00000,-20.00000
270.00000, 2.00000,4.00000, 0.00000,24.00000, 4.00000,-20.00000
270.00000, 6.00000,8.00000, 0.00000,24.00000, 4.00000,-20.00000
270.00000, 14.00000,8.00000, 0.00000,24.00000, 4.00000,-20.00000
270.00000, 22.00000,8.00000, 0.00000,24.00000, 4.00000,-20.00000
270.00000, 10.00000,12.00000, 0.00000,24.00000, 4.00000,-20.00000
270.00000, 18.00000,12.00000, 0.00000,24.00000, 4.00000,-20.00000
270.00000, 2.00000,12.00000, 0.00000,24.00000, 4.00000,-20.00000
270.00000, 22.00000,16.00000, 0.00000,24.00000, 4.00000,-20.00000
270.00000, 14.00000,16.00000, 0.00000,24.00000, 4.00000,-20.00000
270.00000, 6.00000,16.00000, 0.00000,24.00000, 4.00000,-20.00000
270.00000, 2.00000,20.00000, 0.00000,24.00000, 4.00000,-20.00000
270.00000, 18.00000,20.00000, 0.00000,24.00000, 4.00000,-20.00000
270.00000, 10.00000,20.00000, 0.00000,24.00000, 4.00000,-20.00000
270.00000, 24.00000,24.00000, 0.00000,24.00000, 4.00000,-20.00000
270.00000, 20.00000,24.00000, 0.00000,24.00000, 4.00000,-20.00000
270.00000, 12.00000,24.00000, 0.00000,24.00000, 4.00000,-20.00000
270.00000, 8.00000,24.00000, 0.00000,24.00000, 4.00000,-20.00000
0.00000, 0.00000,4.00000, 0.00000,24.00000
0.00000, 0.00000,8.00000, 0.00000,24.00000
0.00000, 0.00000,12.00000, 0.00000,24.00000
0.00000, 0.00000,16.00000, 0.00000,24.00000
0.00000, 0.00000,20.00000, 0.00000,24.00000
0.00000, 0.00000,24.00000, 0.00000,24.00000
*BRICK08,temp
;%TYPE=MODEL
0.00000, 22.00000,20.00000, 0.00000,24.00000, 3.75000,-20.25000
270.00000, 12.00000,3.75000, 0.00000,24.00000, 3.75000,-20.25000
270.00000, 20.00000,3.75000, 0.00000,24.00000, 3.75000,-20.25000
270.00000, 4.00000,3.75000, 0.00000,24.00000, 3.75000,-20.25000
270.00000, 8.00000,7.75000, 0.00000,24.00000, 3.75000,-20.25000
270.00000, 16.00000,7.75000, 0.00000,24.00000, 3.75000,-20.25000
270.00000, 24.00000,7.75000, 0.00000,24.00000, 3.75000,-20.25000
270.00000, 12.00000,11.75000, 0.00000,24.00000, 3.75000,-20.25000
270.00000, 20.00000,11.75000, 0.00000,24.00000, 3.75000,-20.25000
270.00000, 4.00000,11.75000, 0.00000,24.00000, 3.75000,-20.25000
270.00000, 24.00000,15.75000, 0.00000,24.00000, 3.75000,-20.25000
270.00000, 16.00000,15.75000, 0.00000,24.00000, 3.75000,-20.25000
270.00000, 8.00000,15.75000, 0.00000,24.00000, 3.75000,-20.25000
270.00000, 4.00000,19.75000, 0.00000,24.00000, 3.75000,-20.25000
270.00000, 20.00000,19.75000, 0.00000,24.00000, 3.75000,-20.25000
270.00000, 12.00000,19.75000, 0.00000,24.00000, 3.75000,-20.25000
270.00000, 2.00000,23.75000, 0.00000,24.00000, 3.75000,-20.25000
270.00000, 22.00000,23.75000, 0.00000,24.00000, 3.75000,-20.25000
270.00000, 14.00000,23.75000, 0.00000,24.00000, 3.75000,-20.25000
270.00000, 10.00000,23.75000, 0.00000,24.00000, 3.75000,-20.25000
180.00000, 3.75000,8.00000, 0.00000,24.00000, 7.75000,-16.25000
180.00000, 7.75000,12.00000, 0.00000,24.00000, 7.75000,-16.25000
180.00000, 3.75000,16.00000, 0.00000,24.00000, 7.75000,-16.25000
0.00000, 2.00000,20.00000, 0.00000,24.00000, 7.75000,-16.25000
0.00000, 2.00000,24.00000, 0.00000,24.00000, 1.75000,-22.25000
270.00000, 9.75000,23.75000, 0.00000,24.00000, 3.75000,-20.25000
270.00000, 13.75000,23.75000, 0.00000,24.00000, 3.75000,-20.25000
270.00000, 21.75000,23.75000, 0.00000,24.00000, 3.75000,-20.25000
270.00000, 1.75000,23.75000, 0.00000,24.00000, 3.75000,-20.25000
270.00000, 19.75000,19.75000, 0.00000,24.00000, 3.75000,-20.25000
270.00000, 11.75000,19.75000, 0.00000,24.00000, 3.75000,-20.25000
270.00000, 3.75000,19.75000, 0.00000,24.00000, 3.75000,-20.25000
270.00000, 23.75000,15.75000, 0.00000,24.00000, 3.75000,-20.25000
270.00000, 15.75000,15.75000, 0.00000,24.00000, 3.75000,-20.25000
270.00000, 7.75000,15.75000, 0.00000,24.00000, 3.75000,-20.25000
270.00000, 19.75000,11.75000, 0.00000,24.00000, 3.75000,-20.25000
270.00000, 11.75000,11.75000, 0.00000,24.00000, 3.75000,-20.25000
270.00000, 3.75000,11.75000, 0.00000,24.00000, 3.75000,-20.25000
270.00000, 23.75000,7.75000, 0.00000,24.00000, 3.75000,-20.25000
270.00000, 15.75000,7.75000, 0.00000,24.00000, 3.75000,-20.25000
270.00000, 7.75000,7.75000, 0.00000,24.00000, 3.75000,-20.25000
270.00000, 19.75000,3.75000, 0.00000,24.00000, 3.75000,-20.25000
270.00000, 11.75000,3.75000, 0.00000,24.00000, 3.75000,-20.25000
270.00000, 3.75000,3.75000, 0.00000,24.00000, 3.75000,-20.25000
0.00000, 2.00000,23.75000, 0.00000,24.00000, 7.75000,-16.25000
180.00000, 7.75000,15.75000, 0.00000,24.00000, 7.75000,-16.25000
180.00000, 3.75000,3.75000, 0.00000,24.00000, 7.75000,-16.25000
0.00000, 4.00000,3.75000, 0.00000,24.00000, 7.75000,-16.25000
0.00000, 8.00000,4.00000, 0.00000,24.00000, 7.75000,-16.25000
0.00000, 16.00000,4.00000, 0.00000,24.00000, 7.75000,-16.25000
0.00000, 16.00000,7.75000, 0.00000,24.00000, 7.75000,-16.25000
0.00000, 12.00000,8.00000, 0.00000,24.00000, 7.75000,-16.25000
0.00000, 8.00000,7.75000, 0.00000,24.00000, 7.75000,-16.25000
0.00000, 4.00000,8.00000, 0.00000,24.00000, 7.75000,-16.25000
0.00000, 4.00000,11.75000, 0.00000,24.00000, 7.75000,-16.25000
0.00000, 8.00000,12.00000, 0.00000,24.00000, 7.75000,-16.25000
0.00000, 12.00000,11.75000, 0.00000,24.00000, 7.75000,-16.25000
0.00000, 16.00000,12.00000, 0.00000,24.00000, 7.75000,-16.25000
0.00000, 0.00000,7.75000, 0.00000,24.00000, 7.75000,-16.25000
0.00000, 0.00000,4.00000, 0.00000,24.00000, 7.75000,-16.25000
0.00000, -4.00000,11.75000, 0.00000,24.00000, 7.75000,-16.25000
180.00000, 19.75000,3.75000, 0.00000,24.00000, 7.75000,-16.25000
0.00000, 10.00000,23.75000, 0.00000,24.00000, 3.75000,-20.25000
0.00000, 14.00000,23.75000, 0.00000,24.00000, 7.75000,-16.25000
0.00000, 4.00000,19.75000, 0.00000,24.00000, 7.75000,-16.25000
0.00000, 10.00000,20.00000, 0.00000,24.00000, 3.75000,-20.25000
0.00000, 14.00000,20.00000, 0.00000,24.00000, 7.75000,-16.25000
0.00000, 12.00000,19.75000, 0.00000,24.00000, 7.75000,-16.25000
0.00000, 12.00000,16.00000, 0.00000,24.00000, 7.75000,-16.25000
0.00000, 4.00000,16.00000, 0.00000,24.00000, 7.75000,-16.25000
0.00000, 8.00000,15.75000, 0.00000,24.00000, 7.75000,-16.25000
0.00000, 16.00000,15.75000, 0.00000,24.00000, 7.75000,-16.25000
0.00000, 22.00000,23.75000, 0.00000,24.00000, 3.75000,-20.25000
0.00000, -4.00000,19.75000, 0.00000,24.00000, 7.75000,-16.25000
0.00000, 4.00000,24.00000, 0.00000,24.00000, 7.75000,-16.25000
0.00000, 12.00000,24.00000, 0.00000,24.00000, 7.75000,-16.25000
0.00000, 20.00000,24.00000, 0.00000,24.00000, 6.00000,-18.00000
*BRICK09,temp
;%TYPE=MODEL
270.00000, 6.00000,8.00000, 0.00000,8.00000, 4.00000,-4.00000
270.00000, 2.00000,8.00000, 0.00000,8.00000, 4.00000,-4.00000
270.00000, 0.00000,4.00000, 0.00000,8.00000, 4.00000,-4.00000
0.00000, 0.00000,8.00000, 0.00000,8.00000
0.00000, 0.00000,4.00000, 0.00000,8.00000
*BRICK10,English brick pattern
;%TYPE=MODEL
0.00000, 2.25000,4.00000, 0.00000,8.00000, 3.75000,-4.25000
0.00000, 6.25000,4.00000, 0.00000,8.00000, 1.75000,-6.25000
0.00000, 6.25000,7.75000, 0.00000,8.00000, 1.75000,-6.25000
0.00000, 2.25000,7.75000, 0.00000,8.00000, 3.75000,-4.25000
270.00000, 6.25000,7.75000, 0.00000,8.00000, 3.75000,-4.25000
270.00000, 2.25000,7.75000, 0.00000,8.00000, 3.75000,-4.25000
270.00000, 0.25000,3.75000, 0.00000,8.00000, 3.75000,-4.25000
0.00000, 0.25000,3.75000, 0.00000,8.00000, 7.75000,-0.25000
0.00000, 0.00000,7.75000, 0.00000,8.00000, 2.00000,-6.00000
0.00000, 0.00000,4.00000, 0.00000,8.00000, 2.00000,-6.00000
0.00000, 0.25000,8.00000, 0.00000,8.00000, 7.75000,-0.25000
270.00000, 0.00000,3.75000, 0.00000,8.00000, 3.75000,-4.25000
270.00000, 2.00000,7.75000, 0.00000,8.00000, 3.75000,-4.25000
270.00000, 6.00000,7.75000, 0.00000,8.00000, 3.75000,-4.25000
*BRICK11,temp
;%TYPE=MODEL
90.00000, 2.00000,0.00000, 0.00000,12.00000, 4.00000,-4.00000
0.00000, 0.00000,4.00000, 0.00000,8.00000
90.00000, 8.00000,4.00000, 0.00000,12.00000, 4.00000,-4.00000
90.00000, 0.00000,4.00000, 0.00000,12.00000, 4.00000,-4.00000
90.00000, 6.00000,0.00000, 0.00000,12.00000, 4.00000,-4.00000
0.00000, 0.00000,8.00000, 0.00000,8.00000
*BRICK12,flemmish pattern
;%TYPE=MODEL
0.00000, 2.25000,0.00000, 0.00000,8.00000, 3.75000,-8.25000
0.00000, 6.25000,0.00000, 0.00000,8.00000, 5.75000,-6.25000
0.00000, 8.25000,7.75000, 0.00000,8.00000, 3.75000,-8.25000
0.00000, 8.25000,4.00000, 0.00000,8.00000, 3.75000,-8.25000
0.00000, 6.25000,3.75000, 0.00000,8.00000, 5.75000,-6.25000
0.00000, 2.25000,3.75000, 0.00000,8.00000, 3.75000,-8.25000
0.00000, 0.00000,3.75000, 0.00000,8.00000, 2.00000,-10.00000
0.00000, 0.25000,7.75000, 0.00000,8.00000, 7.75000,-4.25000
90.00000, 8.25000,4.00000, 0.00000,12.00000, 3.75000,-4.25000
90.00000, 6.25000,0.00000, 0.00000,12.00000, 3.75000,-4.25000
90.00000, 2.25000,0.00000, 0.00000,12.00000, 3.75000,-4.25000
90.00000, 0.25000,4.00000, 0.00000,12.00000, 3.75000,-4.25000
0.00000, 0.00000,0.00000, 0.00000,8.00000, 2.00000,-10.00000
90.00000, 6.00000,0.00000, 0.00000,12.00000, 3.75000,-4.25000
90.00000, 0.00000,4.00000, 0.00000,12.00000, 3.75000,-4.25000
90.00000, 8.00000,4.00000, 0.00000,12.00000, 3.75000,-4.25000
0.00000, 0.25000,4.00000, 0.00000,8.00000, 7.75000,-4.25000
90.00000, 2.00000,0.00000, 0.00000,12.00000, 3.75000,-4.25000
*BRICK13,temp
;%TYPE=MODEL
0.00000, 0.00000,0.00000, 0.00000,8.00000
90.00000, 8.00000,-8.00000, 0.00000,28.00000, 4.00000,-4.00000
90.00000, 24.00000,-8.00000, 0.00000,28.00000, 4.00000,-4.00000
90.00000, 28.00000,-8.00000, 0.00000,28.00000, 4.00000,-4.00000
90.00000, 16.00000,-8.00000, 0.00000,28.00000, 4.00000,-4.00000
90.00000, 2.00000,-4.00000, 0.00000,28.00000, 4.00000,-4.00000
90.00000, 22.00000,-4.00000, 0.00000,28.00000, 4.00000,-4.00000
90.00000, 14.00000,-4.00000, 0.00000,28.00000, 4.00000,-4.00000
90.00000, 10.00000,-4.00000, 0.00000,28.00000, 4.00000,-4.00000
0.00000, 0.00000,-4.00000, 0.00000,8.00000
*BRICK14,garden pattern
;%TYPE=MODEL
0.00000, 0.00000,0.00000, 0.00000,8.00000, 7.75000,-20.25000
90.00000, 8.00000,0.00000, 0.00000,28.00000, 3.75000,-4.25000
90.00000, 24.00000,0.00000, 0.00000,28.00000, 3.75000,-4.25000
90.00000, 28.00000,0.00000, 0.00000,28.00000, 3.75000,-4.25000
90.00000, 16.00000,0.00000, 0.00000,28.00000, 3.75000,-4.25000
90.00000, 2.00000,4.00000, 0.00000,28.00000, 3.75000,-4.25000
90.00000, 22.00000,4.00000, 0.00000,28.00000, 3.75000,-4.25000
90.00000, 14.00000,4.00000, 0.00000,28.00000, 3.75000,-4.25000
90.00000, 10.00000,4.00000, 0.00000,28.00000, 3.75000,-4.25000
180.00000, 1.75000,4.00000, 0.00000,8.00000, 7.75000,-20.25000
90.00000, 21.75000,4.00000, 0.00000,28.00000, 3.75000,-4.25000
90.00000, 13.75000,4.00000, 0.00000,28.00000, 3.75000,-4.25000
90.00000, 9.75000,4.00000, 0.00000,28.00000, 3.75000,-4.25000
90.00000, 1.75000,4.00000, 0.00000,28.00000, 3.75000,-4.25000
90.00000, 27.75000,0.00000, 0.00000,28.00000, 3.75000,-4.25000
90.00000, 23.75000,0.00000, 0.00000,28.00000, 3.75000,-4.25000
90.00000, 15.75000,0.00000, 0.00000,28.00000, 3.75000,-4.25000
90.00000, 7.75000,0.00000, 0.00000,28.00000, 3.75000,-4.25000
0.00000, 0.00000,3.75000, 0.00000,8.00000, 7.75000,-20.25000
0.00000, 2.00000,7.75000, 0.00000,8.00000, 7.75000,-20.25000
0.00000, 2.00000,4.00000, 0.00000,8.00000, 7.75000,-20.25000
0.00000, 8.00000,3.75000, 0.00000,8.00000, 7.75000,-20.25000
0.00000, 10.00000,4.00000, 0.00000,8.00000, 3.75000,-24.25000
0.00000, 10.00000,7.75000, 0.00000,8.00000, 3.75000,-24.25000
0.00000, 14.00000,4.00000, 0.00000,8.00000, 7.75000,-20.25000
0.00000, 14.00000,7.75000, 0.00000,8.00000, 7.75000,-20.25000
0.00000, -6.00000,7.75000, 0.00000,8.00000, 7.75000,-20.25000
0.00000, 24.00000,3.75000, 0.00000,8.00000, 3.75000,-24.25000
0.00000, 16.00000,3.75000, 0.00000,8.00000, 7.75000,-20.25000
0.00000, 24.00000,0.00000, 0.00000,8.00000, 3.75000,-24.25000
0.00000, 8.00000,0.00000, 0.00000,8.00000, 7.75000,-20.25000
0.00000, 16.00000,0.00000, 0.00000,8.00000, 7.75000,-20.25000
*BRICK15,temp
;%TYPE=MODEL
0.00000, 0.00000,0.00000, 0.00000,8.00000
90.00000, 0.00000,0.00000, 0.00000,8.00000, 4.00000,-4.00000
90.00000, 5.33333,4.00000, 0.00000,8.00000, 4.00000,-4.00000
180.00000, 8.00000,4.00000, 0.00000,8.00000
*BRICK16,temp
;%TYPE=MODEL
0.00000, 5.58333,4.25000, 0.00000,8.00000, 7.75000,-0.25000
0.00000, 0.25000,0.25000, 0.00000,8.00000, 7.75000,-0.25000
90.00000, 0.25000,0.25000, 0.00000,8.00000, 3.75000,-4.25000
90.00000, 5.58333,4.25000, 0.00000,8.00000, 3.75000,-4.25000
180.00000, 8.00000,4.00000, 0.00000,8.00000, 7.75000,-0.25000
90.00000, 5.33333,4.25000, 0.00000,8.00000, 3.75000,-4.25000
90.00000, 0.00000,0.25000, 0.00000,8.00000, 3.75000,-4.25000
180.00000, 5.33333,0.00000, 0.00000,8.00000, 7.75000,-0.25000
*BRICK17,temp
;%TYPE=MODEL
180.00000, 8.00000,4.00000, 0.00000,8.00000
180.00000, 8.00000,0.00000, 0.00000,8.00000
90.00000, 6.00000,4.00000, 0.00000,8.00000, 4.00000,-4.00000
90.00000, 0.00000,0.00000, 0.00000,8.00000, 4.00000,-4.00000
*BRICK18,temp
;%TYPE=MODEL
180.00000, 6.00000,4.25000, 0.00000,8.00000, 7.75000,-0.25000
180.00000, 8.00000,0.25000, 0.00000,8.00000, 7.75000,-0.25000
90.00000, 6.25000,4.25000, 0.00000,8.00000, 3.75000,-4.25000
90.00000, 0.25000,0.25000, 0.00000,8.00000, 3.75000,-4.25000
90.00000, 0.00000,0.25000, 0.00000,8.00000, 3.75000,-4.25000
90.00000, 6.00000,4.25000, 0.00000,8.00000, 3.75000,-4.25000
0.00000, -1.75000,0.00000, 0.00000,8.00000, 7.75000,-0.25000
180.00000, 8.00000,4.00000, 0.00000,8.00000, 7.75000,-0.25000
*BRICK19,temp
;%TYPE=MODEL
180.00000, 8.00000,0.00000, 0.00000,3.00000
90.00000, 8.00000,0.00000, 0.00000,8.00000
*BRICK20,stacked bond
;%TYPE=MODEL
180.00000, 7.80687,0.25000, 0.00000,3.00000, 7.75000,-0.30687
90.00000, 7.80687,0.25000, 0.00000,8.05687, 2.75000,-0.25000
90.00000, 8.05687,0.25000, 0.00000,8.05687, 2.75000,-0.25000
180.00000, 7.80687,0.00000, 0.00000,3.00000, 7.75000,-0.30687
*BRICK21,temp
;%TYPE=MODEL
270.00000, 8.00000,8.00000, 0.00000,16.00000, 8.00000,-8.00000
0.00000, 0.00000,0.00000, 0.00000,16.00000
270.00000, 4.00000,8.00000, 0.00000,16.00000, 8.00000,-8.00000
0.00000, 8.00000,4.00000, 0.00000,16.00000, 8.00000,-8.00000
180.00000, 8.00000,12.00000, 0.00000,16.00000, 8.00000,-8.00000
270.00000, 16.00000,16.00000, 0.00000,16.00000
270.00000, 12.00000,16.00000, 0.00000,16.00000, 8.00000,-8.00000
180.00000, 16.00000,8.00000, 0.00000,16.00000
270.00000, 8.00000,16.00000, 0.00000,16.00000, 8.00000,-8.00000
*BRICK22,temp
;%TYPE=MODEL
0.00000, 8.25000,0.00000, 0.00000,16.00000, 3.75000,-12.50000
0.00000, 12.25000,0.00000, 0.00000,16.00000, 3.75000,-12.50000
270.00000, 16.25000,8.00000, 0.00000,16.25000, 7.75000,-8.25000
270.00000, 16.25000,12.00000, 0.00000,16.25000, 3.75000,-12.25000
270.00000, 8.00000,12.00000, 0.00000,16.25000, 3.75000,-12.25000
180.00000, 4.00000,8.00000, 0.00000,16.00000, 4.00000,-12.25000
270.00000, 16.00000,8.00000, 0.00000,16.25000, 3.75000,-12.25000
180.00000, 12.00000,8.25000, 0.00000,16.00000, 3.75000,-12.50000
180.00000, 8.00000,8.00000, 0.00000,16.00000, 3.75000,-12.50000
180.00000, 8.00000,8.25000, 0.00000,16.00000, 8.00000,-8.25000
270.00000, 8.25000,4.00000, 0.00000,16.25000, 3.75000,-12.25000
0.00000, 4.25000,0.25000, 0.00000,16.00000, 3.75000,-12.50000
0.00000, 8.25000,0.25000, 0.00000,16.00000, 7.75000,-8.50000
270.00000, 16.00000,4.00000, 0.00000,16.25000, 3.75000,-12.25000
270.00000, 16.25000,16.00000, 0.00000,16.25000, 3.75000,-12.25000
270.00000, 8.25000,16.00000, 0.00000,16.25000, 7.75000,-8.25000
270.00000, 12.25000,16.00000, 0.00000,16.25000, 7.75000,-8.25000
270.00000, 8.25000,8.00000, 0.00000,16.25000, 3.75000,-12.25000
270.00000, 4.25000,8.00000, 0.00000,16.25000, 7.75000,-8.25000
0.00000, 8.25000,4.25000, 0.00000,16.00000, 7.75000,-8.50000
180.00000, 8.00000,12.25000, 0.00000,16.00000, 8.00000,-8.25000
180.00000, 16.00000,8.25000, 0.00000,16.00000, 3.75000,-12.50000
0.00000, 0.00000,0.25000, 0.00000,16.00000, 4.00000,-12.25000
270.00000, 8.00000,16.00000, 0.00000,16.25000, 3.75000,-12.25000
180.00000, 16.00000,8.00000, 0.00000,16.00000, 7.75000,-8.50000
270.00000, 12.00000,16.00000, 0.00000,16.25000, 7.75000,-8.25000
270.00000, 16.00000,16.00000, 0.00000,16.25000, 7.75000,-8.25000
180.00000, 8.00000,12.00000, 0.00000,16.00000, 8.00000,-8.25000
0.00000, 8.25000,4.00000, 0.00000,16.00000, 7.75000,-8.50000
270.00000, 4.00000,8.00000, 0.00000,16.25000, 7.75000,-8.25000
0.00000, 0.00000,0.00000, 0.00000,16.00000, 8.00000,-8.25000
270.00000, 8.00000,8.00000, 0.00000,16.25000, 7.75000,-8.25000
*BRICK23,temp
;%TYPE=MODEL
180.00000, 8.00000,8.00000, 0.00000,12.00000, 8.00000,-8.00000
270.00000, 8.00000,12.00000, 0.00000,16.00000
0.00000, 0.00000,0.00000, 0.00000,12.00000
270.00000, 4.00000,8.00000, 0.00000,16.00000, 8.00000,-4.00000
270.00000, 16.00000,12.00000, 0.00000,16.00000
0.00000, 8.00000,4.00000, 0.00000,12.00000, 8.00000,-8.00000
90.00000, 12.00000,4.00000, 0.00000,16.00000, 8.00000,-4.00000
*BRICK24,temp
;%TYPE=MODEL
0.00000, 12.00000,0.00000, 0.00000,12.00000, 3.75000,-12.25000
270.00000, 16.00000,8.00000, 0.00000,16.00000, 7.75000,-4.25000
270.00000, 7.75000,8.00000, 0.00000,16.00000, 7.75000,-4.25000
0.00000, 8.00000,0.00000, 0.00000,12.00000, 3.75000,-12.25000
270.00000, 15.75000,4.00000, 0.00000,16.00000, 3.75000,-8.25000
0.00000, 12.00000,4.25000, 0.00000,12.00000, 3.75000,-12.25000
270.00000, 8.00000,4.00000, 0.00000,16.00000, 3.75000,-8.25000
0.00000, 8.00000,0.25000, 0.00000,12.00000, 7.75000,-8.25000
0.00000, 4.00000,0.25000, 0.00000,12.00000, 3.75000,-12.25000
180.00000, 3.75000,8.00000, 0.00000,12.00000, 3.75000,-12.25000
270.00000, 15.75000,12.00000, 0.00000,16.00000, 7.75000,-4.25000
90.00000, 11.75000,4.25000, 0.00000,16.00000, 7.75000,-4.25000
270.00000, 7.75000,12.00000, 0.00000,16.00000, 3.75000,-8.25000
270.00000, 3.75000,8.00000, 0.00000,16.00000, 7.75000,-4.25000
180.00000, 7.75000,8.25000, 0.00000,12.00000, 7.75000,-8.25000
0.00000, 8.00000,4.25000, 0.00000,12.00000, 3.75000,-12.25000
0.00000, 0.00000,0.25000, 0.00000,12.00000, 3.75000,-12.25000
90.00000, 12.00000,4.25000, 0.00000,16.00000, 7.75000,-4.25000
0.00000, 8.00000,4.00000, 0.00000,12.00000, 7.75000,-8.25000
270.00000, 16.00000,12.00000, 0.00000,16.00000, 3.75000,-8.25000
270.00000, 4.00000,8.00000, 0.00000,16.00000, 7.75000,-4.25000
0.00000, 0.00000,0.00000, 0.00000,12.00000, 7.75000,-8.25000
270.00000, 8.00000,12.00000, 0.00000,16.00000, 7.75000,-4.25000
180.00000, 7.75000,8.00000, 0.00000,12.00000, 3.75000,-12.25000
*BRICK25,temp
;%TYPE=MODEL
0.00000, 4.00000,0.00000, 0.00000,24.00000, 8.00000,-4.00000
90.00000, 8.00000,16.00000, 0.00000,12.00000, 8.00000,-16.00000
0.00000, 0.00000,18.00000, 0.00000,24.00000, 4.00000,-8.00000
90.00000, 0.00000,0.00000, 0.00000,12.00000
90.00000, 4.00000,0.00000, 0.00000,12.00000
90.00000, 8.00000,4.00000, 0.00000,12.00000, 8.00000,-16.00000
0.00000, 4.00000,4.00000, 0.00000,24.00000, 8.00000,-4.00000
0.00000, 0.00000,2.00000, 0.00000,24.00000, 4.00000,-8.00000
0.00000, 4.00000,12.00000, 0.00000,24.00000, 8.00000,-4.00000
0.00000, 0.00000,10.00000, 0.00000,24.00000, 4.00000,-8.00000
0.00000, 4.00000,16.00000, 0.00000,24.00000, 8.00000,-4.00000
*BRICK26,temp
;%TYPE=MODEL
0.00000, 8.25000,0.00000, 0.00000,24.00000, 3.75000,-8.25000
90.00000, 0.00000,12.25000, 0.00000,12.00000, 3.75000,-20.25000
90.00000, 0.00000,16.25000, 0.00000,12.00000, 7.75000,-16.25000
90.00000, 0.00000,4.25000, 0.00000,12.00000, 7.75000,-16.25000
90.00000, 4.25000,16.25000, 0.00000,12.00000, 7.75000,-16.25000
0.00000, 8.25000,16.25000, 0.00000,24.00000, 3.75000,-8.25000
0.00000, 8.25000,12.00000, 0.00000,24.00000, 3.75000,-8.25000
90.00000, 4.25000,12.25000, 0.00000,12.00000, 3.75000,-20.25000
90.00000, 0.25000,10.25000, 0.00000,12.00000, 7.75000,-16.25000
90.00000, 0.25000,18.25000, 0.00000,12.00000, 5.75000,-18.25000
90.00000, 4.00000,18.25000, 0.00000,12.00000, 5.75000,-18.25000
90.00000, 0.25000,2.25000, 0.00000,12.00000, 7.75000,-16.25000
90.00000, 4.00000,2.25000, 0.00000,12.00000, 15.75000,-8.25000
0.00000, 8.25000,4.25000, 0.00000,24.00000, 3.75000,-8.25000
90.00000, 4.25000,4.25000, 0.00000,12.00000, 7.75000,-16.25000
0.00000, 4.25000,16.25000, 0.00000,24.00000, 3.75000,-8.25000
0.00000, 4.25000,12.25000, 0.00000,24.00000, 7.75000,-4.25000
0.00000, 4.25000,4.25000, 0.00000,24.00000, 3.75000,-8.25000
0.00000, 4.25000,0.25000, 0.00000,24.00000, 7.75000,-4.25000
0.00000, 0.25000,18.25000, 0.00000,24.00000, 3.75000,-8.25000
0.00000, 0.25000,10.25000, 0.00000,24.00000, 3.75000,-8.25000
0.00000, 0.25000,2.25000, 0.00000,24.00000, 3.75000,-8.25000
90.00000, 8.25000,4.25000, 0.00000,12.00000, 7.75000,-16.25000
90.00000, 8.25000,16.25000, 0.00000,12.00000, 7.75000,-16.25000
90.00000, 4.25000,0.25000, 0.00000,12.00000, 3.75000,-20.25000
90.00000, 0.25000,0.00000, 0.00000,12.00000, 2.00000,-22.00000
0.00000, 4.25000,16.00000, 0.00000,24.00000, 7.75000,-4.25000
0.00000, 0.25000,10.00000, 0.00000,24.00000, 3.75000,-8.25000
0.00000, 4.25000,12.00000, 0.00000,24.00000, 3.75000,-8.25000
0.00000, 0.25000,2.00000, 0.00000,24.00000, 3.75000,-8.25000
0.00000, 4.25000,4.00000, 0.00000,24.00000, 7.75000,-4.25000
90.00000, 8.00000,4.25000, 0.00000,12.00000, 7.75000,-16.25000
90.00000, 4.00000,0.00000, 0.00000,12.00000, 2.00000,-22.00000
90.00000, 0.00000,0.25000, 0.00000,12.00000, 3.75000,-20.25000
0.00000, 0.25000,18.00000, 0.00000,24.00000, 3.75000,-8.25000
90.00000, 8.00000,16.25000, 0.00000,12.00000, 7.75000,-16.25000
0.00000, 4.25000,0.00000, 0.00000,24.00000, 3.75000,-8.25000
*BRICK27,temp
;%TYPE=MODEL
90.00000, 12.00000,-0.00000, 0.00000,16.00000, 8.00000,-4.00000
180.00000, 16.00000,12.00000, 0.00000,12.00000, 16.00000,-0.00000
270.00000, 4.00000,8.00000, 0.00000,16.00000, 8.00000,-4.00000
270.00000, 0.00000,12.00000, 0.00000,16.00000, 12.00000,0.00000
180.00000, 16.00000,8.00000, 0.00000,12.00000, 16.00000,0.00000
90.00000, 8.00000,8.00000, 0.00000,16.00000, 4.00000,-8.00000
*BRICK28,temp
;%TYPE=MODEL
180.00000, 12.00000,12.25000, 0.00000,12.25000, 7.75000,-8.25000
180.00000, 4.00000,12.25000, 0.00000,12.25000, 3.75000,-12.25000
270.00000, 0.00000,8.00000, 0.00000,16.00000, 8.00000,-4.25000
270.00000, 0.25000,8.00000, 0.00000,16.00000, 8.00000,-4.25000
270.00000, 12.00000,8.00000, 0.00000,16.00000, 8.00000,-4.25000
180.00000, 12.00000,8.00000, 0.00000,12.25000, 7.75000,-8.25000
180.00000, 4.00000,8.00000, 0.00000,12.25000, 3.75000,-12.25000
180.00000, 8.00000,8.25000, 0.00000,12.25000, 7.75000,-8.25000
180.00000, 8.00000,12.00000, 0.00000,12.25000, 7.75000,-8.25000
180.00000, 16.00000,12.25000, 0.00000,12.25000, 3.75000,-12.25000
180.00000, 16.00000,8.25000, 0.00000,12.25000, 7.75000,-8.25000
90.00000, 12.25000,-0.00000, 0.00000,16.00000, 8.00000,-4.25000
270.00000, 4.25000,8.00000, 0.00000,16.00000, 8.00000,-4.25000
90.00000, 8.25000,8.25000, 0.00000,16.00000, 3.75000,-8.50000
270.00000, 0.25000,12.00000, 0.00000,16.00000, 3.75000,-8.50000
180.00000, 16.00000,12.00000, 0.00000,12.25000, 7.75000,-8.25000
270.00000, 4.00000,8.00000, 0.00000,16.00000, 8.00000,-4.25000
270.00000, 0.00000,12.00000, 0.00000,16.00000, 3.75000,-8.50000
180.00000, 16.00000,8.00000, 0.00000,12.25000, 3.75000,-12.25000
90.00000, 8.00000,8.25000, 0.00000,16.00000, 3.75000,-8.50000
*BRICK29,temp
;%TYPE=MODEL
270.00000, 0.00000,12.00000, 0.00000,12.00000, 9.00000,-3.00000
0.00000, -3.00000,3.00000, 0.00000,12.00000, 9.00000,-3.00000
270.00000, 3.00000,15.00000, 0.00000,12.00000, 9.00000,-3.00000
180.00000, 15.00000,0.00000, 0.00000,12.00000, 9.00000,-3.00000
0.00000, 0.00000,6.00000, 0.00000,12.00000, 9.00000,-3.00000
270.00000, 9.00000,9.00000, 0.00000,12.00000, 9.00000,-3.00000
90.00000, 6.00000,9.00000, 0.00000,12.00000, 9.00000,-3.00000
180.00000, 12.00000,9.00000, 0.00000,12.00000, 9.00000,-3.00000
*BRICK30,temp
;%TYPE=MODEL
270.00000, 8.00000,12.00000, 0.00000,12.00000, 8.00000,-4.00000
0.00000, 4.00000,4.00000, 0.00000,12.00000, 8.00000,-4.00000
0.00000, 0.00000,8.00000, 0.00000,12.00000, 8.00000,-4.00000
270.00000, 12.00000,12.00000, 0.00000,12.00000, 12.00000,0.00000
270.00000, 4.00000,8.00000, 0.00000,12.00000, 8.00000,-4.00000
0.00000, 0.00000,0.00000, 0.00000,12.00000
*BRICK31,temp
;%TYPE=MODEL
180.00000, 8.00000,8.50000, 0.00000,16.50000, 16.00000,-0.50000
270.00000, 8.50000,8.50000, 0.00000,16.50000, 8.00000,-8.50000
180.00000, 16.25000,9.00000, 0.00000,16.50000, 16.00000,-0.50000
0.00000, 0.25000,0.00000, 0.00000,16.50000, 16.00000,-0.50000
270.00000, 16.25000,16.50000, 0.00000,16.50000, 7.50000,-9.00000
90.00000, 0.25000,9.00000, 0.00000,16.50000, 7.50000,-9.00000
270.00000, 8.00000,8.50000, 0.00000,16.50000, 8.00000,-8.50000
180.00000, 8.00000,0.50000, 0.00000,16.50000, 16.00000,-0.50000
*BRICK32,temp
;%TYPE=MODEL
270.00000, 2.00000,7.00000, 0.00000,16.00000, 3.00000,-4.00000
270.00000, 6.00000,7.00000, 0.00000,16.00000, 3.00000,-4.00000
270.00000, 10.00000,7.00000, 0.00000,16.00000, 3.00000,-4.00000
270.00000, 14.00000,7.00000, 0.00000,16.00000, 3.00000,-4.00000
0.00000, 0.00000,4.00000, 0.00000,7.00000
270.00000, 16.00000,4.00000, 0.00000,16.00000, 4.00000,-3.00000
180.00000, 16.00000,0.00000, 0.00000,7.00000
270.00000, 8.00000,4.00000, 0.00000,16.00000, 4.00000,-3.00000
*BRICK33,temp
;%TYPE=MODEL
270.00000, 12.25000,8.00000, 0.00000,12.25000, 7.75000,-4.25000
0.00000, 8.25000,0.00000, 0.00000,12.00000, 3.75000,-8.50000
0.00000, 4.25000,0.25000, 0.00000,12.00000, 7.75000,-4.50000
270.00000, 12.00000,4.00000, 0.00000,12.25000, 3.75000,-8.25000
0.00000, 8.25000,4.25000, 0.00000,12.00000, 3.75000,-8.50000
270.00000, 4.25000,4.00000, 0.00000,12.25000, 3.75000,-8.25000
0.00000, 4.25000,8.00000, 0.00000,12.00000, 3.75000,-8.50000
270.00000, 8.00000,8.00000, 0.00000,12.25000, 3.75000,-8.25000
270.00000, 12.25000,12.00000, 0.00000,12.25000, 3.75000,-8.25000
270.00000, 8.25000,12.00000, 0.00000,12.25000, 7.75000,-4.25000
270.00000, 4.25000,8.00000, 0.00000,12.25000, 3.75000,-8.25000
0.00000, 0.00000,8.25000, 0.00000,12.00000, 8.00000,-4.25000
0.00000, 4.25000,4.25000, 0.00000,12.00000, 3.75000,-8.50000
0.00000, 0.00000,0.25000, 0.00000,12.00000, 4.00000,-8.25000
0.00000, 0.00000,0.00000, 0.00000,12.00000, 8.00000,-4.25000
270.00000, 4.00000,8.00000, 0.00000,12.25000, 7.75000,-4.25000
270.00000, 12.00000,12.00000, 0.00000,12.25000, 7.75000,-4.25000
0.00000, 0.00000,8.00000, 0.00000,12.00000, 4.00000,-8.25000
0.00000, 4.25000,4.00000, 0.00000,12.00000, 7.75000,-4.50000
270.00000, 8.00000,12.00000, 0.00000,12.25000, 3.75000,-8.25000
*BRICK34,Herringbone pattern
;%TYPE=MODEL
270.00000, 0.00000,3.75000, 0.00000,16.00000, 3.75000,-12.25000
180.00000, 3.75000,15.75000, 0.00000,16.00000, 7.75000,-8.25000
270.00000, 8.00000,11.75000, 0.00000,16.00000, 3.75000,-12.25000
270.00000, 3.75000,11.75000, 0.00000,16.00000, 7.75000,-8.25000
0.00000, 8.00000,3.75000, 0.00000,16.00000, 3.75000,-12.25000
270.00000, 11.75000,19.75000, 0.00000,16.00000, 7.75000,-8.25000
0.00000, 12.00000,7.75000, 0.00000,16.00000, 3.75000,-12.25000
0.00000, 8.00000,8.00000, 0.00000,16.00000, 7.75000,-8.25000
270.00000, 4.00000,7.75000, 0.00000,16.00000, 3.75000,-12.25000
0.00000, 4.00000,4.00000, 0.00000,16.00000, 7.75000,-8.25000
270.00000, 8.00000,19.75000, 0.00000,16.00000, 7.75000,-8.25000
270.00000, 12.00000,7.75000, 0.00000,16.00000, 7.75000,-8.25000
90.00000, 12.00000,12.00000, 0.00000,16.00000, 3.75000,-12.25000
270.00000, 4.00000,15.75000, 0.00000,16.00000, 7.75000,-8.25000
270.00000, 0.00000,11.75000, 0.00000,16.00000, 7.75000,-8.25000
180.00000, 7.75000,0.00000, 0.00000,16.00000, 7.75000,-8.25000
0.00000, 12.00000,0.00000, 0.00000,16.00000, 3.75000,-12.25000
0.00000, 8.00000,12.00000, 0.00000,16.00000, 3.75000,-12.25000
180.00000, 19.75000,12.00000, 0.00000,16.00000, 7.75000,-8.25000
0.00000, 4.00000,8.00000, 0.00000,16.00000, 3.75000,-12.25000
0.00000, 0.00000,4.00000, 0.00000,16.00000, 3.75000,-12.25000
270.00000, 3.75000,15.75000, 0.00000,16.00000, 3.75000,-12.25000
0.00000, 0.00000,3.75000, 0.00000,16.00000, 7.75000,-8.25000
270.00000, 7.75000,3.75000, 0.00000,16.00000, 3.75000,-12.25000
180.00000, 7.75000,15.75000, 0.00000,16.00000, 3.75000,-12.25000
0.00000, 4.00000,7.75000, 0.00000,16.00000, 7.75000,-8.25000
270.00000, 15.75000,7.75000, 0.00000,16.00000, 7.75000,-8.25000
270.00000, 11.75000,7.75000, 0.00000,16.00000, 3.75000,-12.25000
270.00000, 7.75000,15.75000, 0.00000,16.00000, 7.75000,-8.25000
0.00000, 8.00000,11.75000, 0.00000,16.00000, 7.75000,-8.25000
180.00000, 3.75000,11.75000, 0.00000,16.00000, 3.75000,-12.25000
270.00000, 15.75000,11.75000, 0.00000,16.00000, 3.75000,-12.25000
*BRICK35
;%TYPE=MODEL
0, 0,0, 0,4
90, 0,0, 504,32, 4,-84
90, 8,0, 504,32, 4,-84
90, 16,0, 504,32, 4,-84
90, 24,0, 504,32, 4,-84
90, 4,4, 504,32, 4,-84
90, 12,4, 504,32, 4,-84
90, 20,4, 504,32, 4,-84
90, 8,8, 504,32, 4,-84
90, 12,-4, 504,32, 4,-84
90, 20,-4, 504,32, 4,-84
90, 240,80, 504,32, 4,-108
90, 248,80, 504,32, 4,-108
90, 256,80, 504,32, 4,-108
90, 264,80, 504,32, 4,-108
90, 244,84, 504,32, 4,-108
90, 252,84, 504,32, 4,-108
90, 260,84, 504,32, 4,-108
90, 248,88, 504,32, 4,-108
90, 252,76, 504,32, 4,-108
90, 260,76, 504,32, 4,-108
90, 380,124, 504,32, 4,-76
90, 388,124, 504,32, 4,-76
90, 396,124, 504,32, 4,-76
90, 404,124, 504,32, 4,-76
90, 384,128, 504,32, 4,-76
90, 392,128, 504,32, 4,-76
90, 400,128, 504,32, 4,-76
90, 388,132, 504,32, 4,-76
90, 392,120, 504,32, 4,-76
90, 400,120, 504,32, 4,-76
*CONC1,Concrete
35,0,0,.3,.7,0,-1
0,0,0,4,6.928,.5,-7.5
60,0,0,4,6.928,.5,-7.5
120,.5,0,4,6.928,.5,-7.5
70,0,0,0,1.4,.125,-1.59
130,.125,0,0,1.7,.125,-1.48
*CONC2,Concrete pattern
7,0,0,.3,.7,0,-1
243.43495, 5.00000,5.00000, 4.47214,2.23607
*CONC3,Concrete
000, 0.50,0.50, 0.00,2.50, 0.25,-2.25
000, 1.25,1.00, 0.00,2.50, 0.25,-2.25
000, 0.75,2.00, 0.00,2.50, 0.25,-1.00,0.25,-1.00
090, 0.50,0.50, 0.00,2.50, 0.25,-2.25
090, 0.75,2.00, 0.00,2.50, 0.25,-2.25
090, 1.50,1.00, 0.00,2.50, 0.25,-2.25
090, 2.00,1.75, 0.00,2.50, 0.25,-2.25
135, 0.75,0.50, 1.7678,1.7678, 0.3536,-3.1820
135, 1.00,2.00, 1.7678,1.7678, 0.3536,-3.1820
045, 1.25,1.00, 1.7678,1.7678, 0.3536,-.7071,0.3536,-2.1213
000, -0.50,0.00, 0.25,0.25, -0.50,0
*MAT00,glass
63.43495, 9.39771,0.54769, 7.15542,3.57771, 2.79508,-15.09346
63.43495, 1.39771,0.54769, 7.15542,3.57771, 2.79508,-15.09346
63.43495, 13.22734,2.09326, 7.15542,3.57771, 2.79508,-15.09346
63.43495, 5.22734,2.09326, 7.15542,3.57771, 2.79508,-15.09346
63.43495, 12.64771,1.54769, 7.15542,3.57771, 2.79508,-15.09346
63.43495, 4.64771,1.54769, 7.15542,3.57771, 2.79508,-15.09346
63.43495, 12.05686,4.67228, 7.15542,3.57771, 1.35854,-16.53000
63.43495, 4.05686,4.67228, 7.15542,3.57771, 1.35854,-16.53000
63.43495, 11.67044,4.18871, 7.15542,3.57771, 2.79508,-15.09346
63.43495, 3.67044,4.18871, 7.15542,3.57771, 2.79508,-15.09346
63.43495, 11.73863,4.53589, 7.15542,3.57771, 2.79508,-15.09346
63.43495, 3.73863,4.53589, 7.15542,3.57771, 2.79508,-15.09346
63.43495, 8.51102,3.01281, 7.15542,3.57771, 2.79508,-15.09346
63.43495, 0.51102,3.01281, 7.15542,3.57771, 2.79508,-15.09346
63.43495, 8.57922,3.42198, 7.15542,3.57771, 2.79508,-15.09346
63.43495, 0.57922,3.42198, 7.15542,3.57771, 2.79508,-15.09346
63.43495, 8.59758,3.71700, 7.15542,3.57771, 2.79508,-15.09346
63.43495, 0.59758,3.71700, 7.15542,3.57771, 2.79508,-15.09346
*MAT01,insulation
270.00000, 1.74966,1.67858, 0.00000,2.00000, 0.20071,-1.79929
270.00000, 0.25131,1.67858, 0.00000,2.00000, 0.20071,-1.79929
90.00000, 1.27178,0.32142, 0.00000,2.00000, 0.20071,-1.79929
90.00000, 0.72918,0.32142, 0.00000,2.00000, 0.20071,-1.79929
180.00000, 2.00097,-0.00000, 0.00000,2.00000, 2.00097,0.00097
135.00000, 1.44268,0.10035, 1.41421,-1.41421, 0.17072,-2.65771
116.56505, 3.32196,0.22107, 1.78885,-0.89443, 0.11220,-4.35994
116.56505, 1.32196,0.22107, 1.78885,-0.89443, 0.11220,-4.35994
153.43495, 3.64338,-0.00000, 0.89443,-1.78885, 0.22440,-4.24774
153.43495, 1.64338,-0.00000, 0.89443,-1.78885, 0.22440,-4.24774
63.43495, 3.27178,0.52213, 1.78885,0.89443, 1.06856,-3.40358
63.43495, 1.27178,0.52213, 1.78885,0.89443, 1.06856,-3.40358
116.56505, 3.74966,1.67858, 1.78885,-0.89443, 0.11220,-4.35994
116.56505, 1.74966,1.67858, 1.78885,-0.89443, 0.11220,-4.35994
135.00000, 1.69948,1.77893, 1.41421,-1.41421, 0.17072,-2.65771
153.43495, 3.57876,1.89965, 0.89443,-1.78885, 0.22440,-4.24774
153.43495, 1.57876,1.89965, 0.89443,-1.78885, 0.22440,-4.24774
45.00000, 0.30149,1.77893, 1.41421,1.41421, 0.17072,-2.65771
63.43495, 2.25131,1.67858, 1.78885,0.89443, 0.11220,-4.35994
63.43495, 0.25131,1.67858, 1.78885,0.89443, 0.11220,-4.35994
26.56505, 2.42220,1.89965, 0.89443,1.78885, 0.22440,-4.24774
26.56505, 0.42220,1.89965, 0.89443,1.78885, 0.22440,-4.24774
116.56505, 2.72918,0.52213, 1.78885,-0.89443, 1.06856,-3.40358
116.56505, 0.72918,0.52213, 1.78885,-0.89443, 1.06856,-3.40358
45.00000, 0.55829,0.10035, 1.41421,1.41421, 0.17072,-2.65771
63.43495, 2.67901,0.22107, 1.78885,0.89443, 0.11220,-4.35994
63.43495, 0.67901,0.22107, 1.78885,0.89443, 0.11220,-4.35994
26.56505, 2.35758,0.00000, 0.89443,1.78885, 0.22440,-4.24774
26.56505, 0.35758,0.00000, 0.89443,1.78885, 0.22440,-4.24774
*MAT02,Rigid insulation
0.00000, 0.00000,0.66667, 0.00000,2.00000
0.00000, 0.00000,1.33333, 0.00000,2.00000
270.00000, 1.74966,1.67858, 0.00000,2.00000, 0.20071,-1.79929
270.00000, 0.25131,1.67858, 0.00000,2.00000, 0.20071,-1.79929
90.00000, 1.27178,0.32142, 0.00000,2.00000, 0.20071,-1.79929
90.00000, 0.72918,0.32142, 0.00000,2.00000, 0.20071,-1.79929
180.00000, 2.00097,-0.00000, 0.00000,2.00000, 2.00097,0.00097
135.00000, 1.44268,0.10035, 1.41421,-1.41421, 0.17072,-2.65771
116.56505, 3.32196,0.22107, 1.78885,-0.89443, 0.11220,-4.35994
116.56505, 1.32196,0.22107, 1.78885,-0.89443, 0.11220,-4.35994
153.43495, 3.64338,0.00000, 0.89443,-1.78885, 0.22440,-4.24774
153.43495, 1.64338,0.00000, 0.89443,-1.78885, 0.22440,-4.24774
63.43495, 3.27178,0.52213, 1.78885,0.89443, 1.06856,-3.40358
63.43495, 1.27178,0.52213, 1.78885,0.89443, 1.06856,-3.40358
116.56505, 3.74966,1.67858, 1.78885,-0.89443, 0.11220,-4.35994
116.56505, 1.74966,1.67858, 1.78885,-0.89443, 0.11220,-4.35994
135.00000, 1.69948,1.77893, 1.41421,-1.41421, 0.17072,-2.65771
153.43495, 3.57876,1.89965, 0.89443,-1.78885, 0.22440,-4.24774
153.43495, 1.57876,1.89965, 0.89443,-1.78885, 0.22440,-4.24774
45.00000, 0.30149,1.77893, 1.41421,1.41421, 0.17072,-2.65771
63.43495, 2.25131,1.67858, 1.78885,0.89443, 0.11220,-4.35994
63.43495, 0.25131,1.67858, 1.78885,0.89443, 0.11220,-4.35994
26.56505, 2.42220,1.89965, 0.89443,1.78885, 0.22440,-4.24774
26.56505, 0.42220,1.89965, 0.89443,1.78885, 0.22440,-4.24774
116.56505, 2.72918,0.52213, 1.78885,-0.89443, 1.06856,-3.40358
116.56505, 0.72918,0.52213, 1.78885,-0.89443, 1.06856,-3.40358
45.00000, 0.55829,0.10035, 1.41421,1.41421, 0.17072,-2.65771
63.43495, 2.67901,0.22107, 1.78885,0.89443, 0.11220,-4.35994
63.43495, 0.67901,0.22107, 1.78885,0.89443, 0.11220,-4.35994
26.56505, 2.35758,0.00000, 0.89443,1.78885, 0.22440,-4.24774
26.56505, 0.35758,0.00000, 0.89443,1.78885, 0.22440,-4.24774
*MAT03, ARCHT insulation hatch pattern
66.422,.33093,.05,.91652,.4,.17267,-.09109,.45446,-.09109,.17267,-.10911
113.578,.06907,.05,.17457,.4,.17267,-.09109,.45446,-.09109,.17267,-.10911
0, 0.06907,0.05, 0,1.0, 0.26186,-0.17457
0, 0.28729,0.95, 0,1.0, 0.26186,-0.17457
90, 0,0.20826, 0,0.43644, 0.08348,-0.91652
90, 0.21822,0.70826, 0,0.43644, 0.08348,-0.91652
90, 0.4,0.20826, 0,0.43644, 0.08348,-0.91652
90, 0.61822,0.70826, 0,0.43644, 0.08348,-0.91652
*MAT04,BATT Insulation
161.57,1,1,7.59,2.53,-56.92,6.32
18.43,-1,1,-7.59,2.53,-56.92,6.23
108.43,1,1,-20.24,2.53,18.97,-44.27
71.57,-1,1,20.24,2.53,18.97,-44.27
*MISC00,Cane pattern
;%TYPE=MODEL
270.00000, 3.75000,4.25000, 0.00000,4.00000, 1.64645,-2.35355
270.00000, 3.25000,4.25000, 0.00000,4.00000, 1.14645,-2.85355
135.00000, 5.60355,0.75000, 2.82843,-2.82843, 3.53553,-2.12132
135.00000, 4.89645,0.75000, 2.82843,-2.82843, 3.53553,-2.12132
270.00000, 3.25000,2.39645, 0.00000,4.00000, 1.64645,-2.35355
270.00000, 3.75000,1.89645, 0.00000,4.00000, 1.14645,-2.85355
135.00000, 4.89645,0.75000, 2.82843,-2.82843, 3.53553,-2.12132
135.00000, 5.60355,0.75000, 2.82843,-2.82843, 3.53553,-2.12132
45.00000, 3.75000,1.39645, 2.82843,2.82843, 0.35355,-5.30330
45.00000, 0.00000,2.35355, 2.82843,2.82843, 0.35355,-5.30330
180.00000, 4.25000,0.25000, 0.00000,4.00000, 1.64645,-2.35355
180.00000, 4.25000,0.75000, 0.00000,4.00000, 1.14645,-2.85355
180.00000, 2.39645,0.75000, 0.00000,4.00000, 1.64645,-2.35355
180.00000, 1.89645,0.25000, 0.00000,4.00000, 1.14645,-2.85355
90.00000, 0.25000,-0.25000, 0.00000,4.00000, 1.64645,-2.35355
90.00000, 0.75000,-0.25000, 0.00000,4.00000, 1.14645,-2.85355
90.00000, 0.75000,1.60355, 0.00000,4.00000, 1.64645,-2.35355
90.00000, 0.25000,2.10355, 0.00000,4.00000, 1.14645,-2.85355
135.00000, 1.64645,0.00000, 2.82843,-2.82843, 0.35355,-5.30330
135.00000, 2.60355,3.75000, 2.82843,-2.82843, 0.35355,-5.30330
45.00000, 0.75000,3.10355, 2.82843,2.82843, 3.53553,-2.12132
45.00000, 0.75000,2.39645, 2.82843,2.82843, 3.53553,-2.12132
0.00000, 2.10355,3.75000, 0.00000,4.00000, 1.14645,-2.85355
0.00000, 1.60355,3.25000, 0.00000,4.00000, 1.64645,-2.35355
45.00000, 0.75000,2.39645, 2.82843,2.82843, 3.53553,-2.12132
45.00000, 0.75000,3.10355, 2.82843,2.82843, 3.53553,-2.12132
0.00000, -0.25000,3.25000, 0.00000,4.00000, 1.14645,-2.85355
0.00000, -0.25000,3.75000, 0.00000,4.00000, 1.64645,-2.35355
*MISC01,Circles
270.00000, 0.81250,2.39597, 0.00000,4.00000, 0.41695,-3.58305
270.00000, 2.81250,2.39597, 0.00000,4.00000, 0.41695,-3.58305
153.43495, 6.39763,2.99917, 1.78885,-3.57771, 0.42111,-8.52316
153.43495, 2.39763,2.99917, 1.78885,-3.57771, 0.42111,-8.52316
116.56505, 6.81250,2.39597, 3.57771,-1.78885, 0.42111,-8.52316
116.56505, 2.81250,2.39597, 3.57771,-1.78885, 0.42111,-8.52316
135.00000, 2.62417,2.77263, 2.82843,-2.82843, 0.32038,-5.33647
0.00000, 1.60403,3.18750, 0.00000,4.00000, 0.41695,-3.58305
26.56505, 5.22737,2.99917, 1.78885,3.57771, 0.42111,-8.52316
26.56505, 1.22737,2.99917, 1.78885,3.57771, 0.42111,-8.52316
45.00000, 1.00083,2.77263, 2.82843,2.82843, 0.32038,-5.33647
63.43495, 4.81250,2.39597, 3.57771,1.78885, 0.42111,-8.52316
63.43495, 0.81250,2.39597, 3.57771,1.78885, 0.42111,-8.52316
153.43495, 5.60403,1.18750, 1.78885,-3.57771, 0.42111,-8.52316
153.43495, 1.60403,1.18750, 1.78885,-3.57771, 0.42111,-8.52316
116.56505, 5.00083,1.60237, 3.57771,-1.78885, 0.42111,-8.52316
116.56505, 1.00083,1.60237, 3.57771,-1.78885, 0.42111,-8.52316
0.00000, 1.60403,1.18750, 0.00000,4.00000, 0.41695,-3.58305
135.00000, 1.22737,1.37583, 2.82843,-2.82843, 0.32038,-5.33647
45.00000, 2.39763,1.37583, 2.82843,2.82843, 0.32038,-5.33647
63.43495, 6.62417,1.60237, 3.57771,1.78885, 0.42111,-8.52316
63.43495, 2.62417,1.60237, 3.57771,1.78885, 0.42111,-8.52316
26.56505, 6.02097,1.18750, 1.78885,3.57771, 0.42111,-8.52316
26.56505, 2.02097,1.18750, 1.78885,3.57771, 0.42111,-8.52316
153.43495, 4.39763,0.99917, 1.78885,-3.57771, 0.42111,-8.52316
153.43495, 0.39763,0.99917, 1.78885,-3.57771, 0.42111,-8.52316
135.00000, 0.62417,0.77263, 2.82843,-2.82843, 0.32038,-5.33647
116.56505, 4.81250,0.39597, 3.57771,-1.78885, 0.42111,-8.52316
116.56505, 0.81250,0.39597, 3.57771,-1.78885, 0.42111,-8.52316
270.00000, 0.81250,0.39597, 0.00000,4.00000, 0.41695,-3.58305
270.00000, 2.81250,0.39597, 0.00000,4.00000, 0.41695,-3.58305
63.43495, 6.81250,0.39597, 3.57771,1.78885, 0.42111,-8.52316
63.43495, 2.81250,0.39597, 3.57771,1.78885, 0.42111,-8.52316
45.00000, 3.00083,0.77263, 2.82843,2.82843, 0.32038,-5.33647
26.56505, 7.22737,0.99917, 1.78885,3.57771, 0.42111,-8.52316
26.56505, 3.22737,0.99917, 1.78885,3.57771, 0.42111,-8.52316
0.00000, 3.60403,1.18750, 0.00000,4.00000, 0.41695,-3.58305
116.56505, 7.00083,3.60237, 3.57771,-1.78885, 0.42111,-8.52316
116.56505, 3.00083,3.60237, 3.57771,-1.78885, 0.42111,-8.52316
135.00000, 3.22737,3.37583, 2.82843,-2.82843, 0.32038,-5.33647
153.43495, 7.60403,3.18750, 1.78885,-3.57771, 0.42111,-8.52316
153.43495, 3.60403,3.18750, 1.78885,-3.57771, 0.42111,-8.52316
26.56505, 4.02097,3.18750, 1.78885,3.57771, 0.42111,-8.52316
26.56505, 0.02097,3.18750, 1.78885,3.57771, 0.42111,-8.52316
45.00000, 0.39763,3.37583, 2.82843,2.82843, 0.32038,-5.33647
63.43495, 4.62417,3.60237, 3.57771,1.78885, 0.42111,-8.52316
63.43495, 0.62417,3.60237, 3.57771,1.78885, 0.42111,-8.52316
180.00000, 4.02097,3.18750, 0.00000,4.00000, 0.41695,-3.58305
*MISC02,fish pattern
26.56505, 9.60051,0.00000, 2.68328,5.36656, 1.26334,-12.15307
26.56505, 3.60051,0.00000, 2.68328,5.36656, 1.26334,-12.15307
63.43495, 11.41010,1.24461, 5.36656,2.68328, 1.20763,-12.20878
63.43495, 5.41010,1.24461, 5.36656,2.68328, 1.20763,-12.20878
45.00000, 4.73047,0.56498, 4.24264,4.24264, 0.96114,-7.52414
135.00000, 1.21970,0.56498, 4.24264,-4.24264, 0.96114,-7.52414
0.00000, 2.34966,0.00000, 0.00000,6.00000, 1.25085,-4.74915
116.56505, 6.54007,1.24461, 5.36656,-2.68328, 1.20763,-12.20878
116.56505, 0.54007,1.24461, 5.36656,-2.68328, 1.20763,-12.20878
153.43495, 8.34966,0.00000, 2.68328,-5.36656, 1.26334,-12.15307
153.43495, 2.34966,0.00000, 2.68328,-5.36656, 1.26334,-12.15307
270.00000, 3.72508,6.00000, 0.00000,6.00000, 1.37542,-4.62458
135.00000, 4.96970,2.81498, 4.24264,-4.24264, 0.96114,-7.52414
153.43495, 11.95017,2.32475, 2.68328,-5.36656, 1.09620,-12.32020
153.43495, 5.95017,2.32475, 2.68328,-5.36656, 1.09620,-12.32020
116.56505, 10.29007,3.49461, 5.36656,-2.68328, 1.26334,-12.15307
116.56505, 4.29007,3.49461, 5.36656,-2.68328, 1.26334,-12.15307
63.43495, 7.66010,3.49461, 5.36656,2.68328, 1.26334,-12.15307
63.43495, 1.66010,3.49461, 5.36656,2.68328, 1.26334,-12.15307
45.00000, 0.98047,2.81498, 4.24264,4.24264, 0.96114,-7.52414
270.00000, 2.22508,6.00000, 0.00000,6.00000, 1.37542,-4.62458
26.56505, 6.00000,2.32475, 2.68328,5.36656, 1.09620,-12.32020
26.56505, 0.00000,2.32475, 2.68328,5.36656, 1.09620,-12.32020
*MISC03,temp
0.00000, 0.00000,0.00000, 0.00000,4.00000
153.43495, 4.65322,1.78976, 1.78885,-3.57771, 0.47012,-8.47415
153.43495, 0.65322,1.78976, 1.78885,-3.57771, 0.47012,-8.47415
116.56505, 5.11637,1.11637, 3.57771,-1.78885, 0.47012,-8.47415
116.56505, 1.11637,1.11637, 3.57771,-1.78885, 0.47012,-8.47415
135.00000, 0.90612,1.53685, 2.82843,-2.82843, 0.35766,-5.29919
0.00000, 0.00000,2.00000, 0.00000,4.00000
116.56505, 6.00000,0.23273, 3.57771,-1.78885, 0.47012,-8.47415
116.56505, 2.00000,0.23273, 3.57771,-1.78885, 0.47012,-8.47415
153.43495, 5.53685,0.90612, 1.78885,-3.57771, 0.47012,-8.47415
153.43495, 1.53685,0.90612, 1.78885,-3.57771, 0.47012,-8.47415
135.00000, 1.78976,0.65322, 2.82843,-2.82843, 0.35766,-5.29919
90.00000, 4.00000,0.00000, 0.00000,4.00000
90.00000, 2.88363,0.00000, 0.00000,4.00000, 4.00000,-0.00000
180.00000, 4.00000,1.11637, 0.00000,4.00000
45.00000, 3.09388,1.53685, 2.82843,2.82843, 0.35766,-5.29919
63.43495, 6.88363,1.11637, 3.57771,1.78885, 0.47012,-8.47415
63.43495, 2.88363,1.11637, 3.57771,1.78885, 0.47012,-8.47415
26.56505, 7.34678,1.78976, 1.78885,3.57771, 0.47012,-8.47415
26.56505, 3.34678,1.78976, 1.78885,3.57771, 0.47012,-8.47415
45.00000, 2.21024,0.65322, 2.82843,2.82843, 0.35766,-5.29919
26.56505, 6.46315,0.90612, 1.78885,3.57771, 0.47012,-8.47415
26.56505, 2.46315,0.90612, 1.78885,3.57771, 0.47012,-8.47415
63.43495, 6.00000,0.23273, 3.57771,1.78885, 0.47012,-8.47415
63.43495, 2.00000,0.23273, 3.57771,1.78885, 0.47012,-8.47415
0.00000, 0.00000,2.88363, 0.00000,4.00000, 4.00000,0.00000
270.00000, 1.11637,4.00000, 0.00000,4.00000, 4.00000,-0.00000
45.00000, 0.65322,2.21024, 2.82843,2.82843, 0.35766,-5.29919
63.43495, 4.90612,2.46315, 3.57771,1.78885, 0.47012,-8.47415
63.43495, 0.90612,2.46315, 3.57771,1.78885, 0.47012,-8.47415
26.56505, 4.23273,2.00000, 1.78885,3.57771, 0.47012,-8.47415
26.56505, 0.23273,2.00000, 1.78885,3.57771, 0.47012,-8.47415
45.00000, 1.53685,3.09388, 2.82843,2.82843, 0.35766,-5.29919
26.56505, 5.11637,2.88363, 1.78885,3.57771, 0.47012,-8.47415
26.56505, 1.11637,2.88363, 1.78885,3.57771, 0.47012,-8.47415
63.43495, 5.78976,3.34678, 3.57771,1.78885, 0.47012,-8.47415
63.43495, 1.78976,3.34678, 3.57771,1.78885, 0.47012,-8.47415
270.00000, 2.00000,4.00000, 0.00000,4.00000
153.43495, 7.76727,2.00000, 1.78885,-3.57771, 0.47012,-8.47415
153.43495, 3.76727,2.00000, 1.78885,-3.57771, 0.47012,-8.47415
116.56505, 7.09388,2.46315, 3.57771,-1.78885, 0.47012,-8.47415
116.56505, 3.09388,2.46315, 3.57771,-1.78885, 0.47012,-8.47415
135.00000, 3.34678,2.21024, 2.82843,-2.82843, 0.35766,-5.29919
116.56505, 6.21024,3.34678, 3.57771,-1.78885, 0.47012,-8.47415
116.56505, 2.21024,3.34678, 3.57771,-1.78885, 0.47012,-8.47415
153.43495, 6.88363,2.88363, 1.78885,-3.57771, 0.47012,-8.47415
153.43495, 2.88363,2.88363, 1.78885,-3.57771, 0.47012,-8.47415
135.00000, 2.46315,3.09388, 2.82843,-2.82843, 0.35766,-5.29919
*MISC04,temp
270.00000, 1.00000,4.00000, 0.00000,4.00000, 4.00000,0.00000
270.00000, 3.00000,4.00000, 0.00000,4.00000, 4.00000,0.00000
0.00000, 0.00000,1.00000, 0.00000,4.00000, 4.00000,-0.00000
0.00000, 0.00000,3.00000, 0.00000,4.00000, 4.00000,-0.00000
90.00000, 2.00000,0.00000, 0.00000,4.00000, 4.00000,0.00000
180.00000, 4.00000,2.00000, 0.00000,4.00000, 4.00000,-0.00000
90.00000, 4.00000,0.00000, 0.00000,4.00000, 4.00000,0.00000
0.00000, 0.00000,0.00000, 0.00000,4.00000
63.43495, 5.78976,1.34678, 3.57771,1.78885, 0.47012,-8.47415
63.43495, 1.78976,1.34678, 3.57771,1.78885, 0.47012,-8.47415
116.56505, 6.00000,2.23273, 3.57771,-1.78885, 0.47012,-8.47415
116.56505, 2.00000,2.23273, 3.57771,-1.78885, 0.47012,-8.47415
26.56505, 5.11637,0.88363, 1.78885,3.57771, 0.47012,-8.47415
26.56505, 1.11637,0.88363, 1.78885,3.57771, 0.47012,-8.47415
45.00000, 1.53685,1.09388, 2.82843,2.82843, 0.35766,-5.29919
135.00000, 1.78976,2.65322, 2.82843,-2.82843, 0.35766,-5.29919
153.43495, 5.53685,2.90612, 1.78885,-3.57771, 0.47012,-8.47415
153.43495, 1.53685,2.90612, 1.78885,-3.57771, 0.47012,-8.47415
26.56505, 4.23273,0.00000, 1.78885,3.57771, 0.47012,-8.47415
26.56505, 0.23273,0.00000, 1.78885,3.57771, 0.47012,-8.47415
63.43495, 4.90612,0.46315, 3.57771,1.78885, 0.47012,-8.47415
63.43495, 0.90612,0.46315, 3.57771,1.78885, 0.47012,-8.47415
45.00000, 0.65322,0.21024, 2.82843,2.82843, 0.35766,-5.29919
135.00000, 0.90612,3.53685, 2.82843,-2.82843, 0.35766,-5.29919
116.56505, 5.11637,3.11637, 3.57771,-1.78885, 0.47012,-8.47415
116.56505, 1.11637,3.11637, 3.57771,-1.78885, 0.47012,-8.47415
153.43495, 4.65322,3.78976, 1.78885,-3.57771, 0.47012,-8.47415
153.43495, 0.65322,3.78976, 1.78885,-3.57771, 0.47012,-8.47415
116.56505, 8.00000,0.23273, 3.57771,-1.78885, 0.47012,-8.47415
116.56505, 4.00000,0.23273, 3.57771,-1.78885, 0.47012,-8.47415
135.00000, 3.78976,0.65322, 2.82843,-2.82843, 0.35766,-5.29919
153.43495, 7.53685,0.90612, 1.78885,-3.57771, 0.47012,-8.47415
153.43495, 3.53685,0.90612, 1.78885,-3.57771, 0.47012,-8.47415
135.00000, 2.90612,1.53685, 2.82843,-2.82843, 0.35766,-5.29919
116.56505, 7.11637,1.11637, 3.57771,-1.78885, 0.47012,-8.47415
116.56505, 3.11637,1.11637, 3.57771,-1.78885, 0.47012,-8.47415
153.43495, 6.65322,1.78976, 1.78885,-3.57771, 0.47012,-8.47415
153.43495, 2.65322,1.78976, 1.78885,-3.57771, 0.47012,-8.47415
45.00000, 2.65322,2.21024, 2.82843,2.82843, 0.35766,-5.29919
63.43495, 6.90612,2.46315, 3.57771,1.78885, 0.47012,-8.47415
63.43495, 2.90612,2.46315, 3.57771,1.78885, 0.47012,-8.47415
26.56505, 6.23273,2.00000, 1.78885,3.57771, 0.47012,-8.47415
26.56505, 2.23273,2.00000, 1.78885,3.57771, 0.47012,-8.47415
45.00000, 3.53685,3.09388, 2.82843,2.82843, 0.35766,-5.29919
26.56505, 7.11637,2.88363, 1.78885,3.57771, 0.47012,-8.47415
26.56505, 3.11637,2.88363, 1.78885,3.57771, 0.47012,-8.47415
63.43495, 7.78976,3.34678, 3.57771,1.78885, 0.47012,-8.47415
63.43495, 3.78976,3.34678, 3.57771,1.78885, 0.47012,-8.47415
*MISC05,temp
180.00000, 4.20847,3.00000, 0.00000,4.00000, 0.41695,-3.58305
0.00000, 0.00000,2.00000, 0.00000,4.00000
90.00000, 2.00000,0.00000, 0.00000,4.00000
63.43495, 4.81167,3.41487, 3.57771,1.78885, 0.42111,-8.52316
63.43495, 0.81167,3.41487, 3.57771,1.78885, 0.42111,-8.52316
45.00000, 0.58513,3.18833, 2.82843,2.82843, 0.32038,-5.33647
26.56505, 4.20847,3.00000, 1.78885,3.57771, 0.42111,-8.52316
26.56505, 0.20847,3.00000, 1.78885,3.57771, 0.42111,-8.52316
153.43495, 7.79153,3.00000, 1.78885,-3.57771, 0.42111,-8.52316
153.43495, 3.79153,3.00000, 1.78885,-3.57771, 0.42111,-8.52316
135.00000, 3.41487,3.18833, 2.82843,-2.82843, 0.32038,-5.33647
116.56505, 7.18833,3.41487, 3.57771,-1.78885, 0.42111,-8.52316
116.56505, 3.18833,3.41487, 3.57771,-1.78885, 0.42111,-8.52316
0.00000, 3.79153,1.00000, 0.00000,4.00000, 0.41695,-3.58305
26.56505, 7.41487,0.81167, 1.78885,3.57771, 0.42111,-8.52316
26.56505, 3.41487,0.81167, 1.78885,3.57771, 0.42111,-8.52316
45.00000, 3.18833,0.58513, 2.82843,2.82843, 0.32038,-5.33647
63.43495, 7.00000,0.20847, 3.57771,1.78885, 0.42111,-8.52316
63.43495, 3.00000,0.20847, 3.57771,1.78885, 0.42111,-8.52316
270.00000, 3.00000,0.20847, 0.00000,4.00000, 0.41695,-3.58305
270.00000, 1.00000,0.20847, 0.00000,4.00000, 0.41695,-3.58305
116.56505, 5.00000,0.20847, 3.57771,-1.78885, 0.42111,-8.52316
116.56505, 1.00000,0.20847, 3.57771,-1.78885, 0.42111,-8.52316
135.00000, 0.81167,0.58513, 2.82843,-2.82843, 0.32038,-5.33647
153.43495, 4.58513,0.81167, 1.78885,-3.57771, 0.42111,-8.52316
153.43495, 0.58513,0.81167, 1.78885,-3.57771, 0.42111,-8.52316
0.00000, 0.00000,0.00000, 0.00000,4.00000
90.00000, 4.00000,0.00000, 0.00000,4.00000
26.56505, 6.20847,1.00000, 1.78885,3.57771, 0.42111,-8.52316
26.56505, 2.20847,1.00000, 1.78885,3.57771, 0.42111,-8.52316
63.43495, 6.81167,1.41487, 3.57771,1.78885, 0.42111,-8.52316
63.43495, 2.81167,1.41487, 3.57771,1.78885, 0.42111,-8.52316
45.00000, 2.58513,1.18833, 2.82843,2.82843, 0.32038,-5.33647
135.00000, 1.41487,1.18833, 2.82843,-2.82843, 0.32038,-5.33647
0.00000, 1.79153,1.00000, 0.00000,4.00000, 0.41695,-3.58305
116.56505, 5.18833,1.41487, 3.57771,-1.78885, 0.42111,-8.52316
116.56505, 1.18833,1.41487, 3.57771,-1.78885, 0.42111,-8.52316
153.43495, 5.79153,1.00000, 1.78885,-3.57771, 0.42111,-8.52316
153.43495, 1.79153,1.00000, 1.78885,-3.57771, 0.42111,-8.52316
63.43495, 5.00000,2.20847, 3.57771,1.78885, 0.42111,-8.52316
63.43495, 1.00000,2.20847, 3.57771,1.78885, 0.42111,-8.52316
45.00000, 1.18833,2.58513, 2.82843,2.82843, 0.32038,-5.33647
26.56505, 5.41487,2.81167, 1.78885,3.57771, 0.42111,-8.52316
26.56505, 1.41487,2.81167, 1.78885,3.57771, 0.42111,-8.52316
0.00000, 1.79153,3.00000, 0.00000,4.00000, 0.41695,-3.58305
135.00000, 2.81167,2.58513, 2.82843,-2.82843, 0.32038,-5.33647
116.56505, 7.00000,2.20847, 3.57771,-1.78885, 0.42111,-8.52316
116.56505, 3.00000,2.20847, 3.57771,-1.78885, 0.42111,-8.52316
153.43495, 6.58513,2.81167, 1.78885,-3.57771, 0.42111,-8.52316
153.43495, 2.58513,2.81167, 1.78885,-3.57771, 0.42111,-8.52316
270.00000, 3.00000,2.20847, 0.00000,4.00000, 0.41695,-3.58305
270.00000, 1.00000,2.20847, 0.00000,4.00000, 0.41695,-3.58305
*MISC06,temp
135.00000, 0.82974,1.35859, 2.82843,-2.82843, 0.64076,-5.01610
116.56505, 5.20640,0.60528, 3.57771,-1.78885, 0.84223,-8.10205
116.56505, 1.20640,0.60528, 3.57771,-1.78885, 0.84223,-8.10205
153.43495, 4.37666,1.81167, 1.78885,-3.57771, 0.42111,-8.52316
153.43495, 0.37666,1.81167, 1.78885,-3.57771, 0.42111,-8.52316
270.00000, 1.20640,0.60528, 0.00000,4.00000, 0.60528,-3.39472
26.56505, 4.82974,0.00000, 1.78885,3.57771, 0.84223,-8.10205
26.56505, 0.82974,0.00000, 1.78885,3.57771, 0.84223,-8.10205
153.43495, 7.17026,0.00000, 1.78885,-3.57771, 0.84223,-8.10205
153.43495, 3.17026,0.00000, 1.78885,-3.57771, 0.84223,-8.10205
0.00000, 1.58305,0.37666, 0.00000,4.00000, 0.83390,-3.16610
63.43495, 6.79360,0.60528, 3.57771,1.78885, 0.84223,-8.10205
63.43495, 2.79360,0.60528, 3.57771,1.78885, 0.84223,-8.10205
45.00000, 3.17026,1.35859, 2.82843,2.82843, 0.64076,-5.01610
26.56505, 7.62334,1.81167, 1.78885,3.57771, 0.42111,-8.52316
26.56505, 3.62334,1.81167, 1.78885,3.57771, 0.42111,-8.52316
270.00000, 2.79360,0.60528, 0.00000,4.00000, 0.60528,-3.39472
135.00000, 3.62334,2.18833, 2.82843,-2.82843, 0.64076,-5.01610
116.56505, 7.17026,2.64141, 3.57771,-1.78885, 0.84223,-8.10205
116.56505, 3.17026,2.64141, 3.57771,-1.78885, 0.84223,-8.10205
153.43495, 8.00000,2.00000, 1.78885,-3.57771, 0.42111,-8.52316
153.43495, 4.00000,2.00000, 1.78885,-3.57771, 0.42111,-8.52316
270.00000, 2.79360,4.00000, 0.00000,4.00000, 0.60528,-3.39472
26.56505, 6.41695,-0.00000, 1.78885,3.57771, 0.84223,-8.10205
26.56505, 2.41695,-0.00000, 1.78885,3.57771, 0.84223,-8.10205
63.43495, 7.62334,0.82974, 3.57771,1.78885, 0.84223,-8.10205
63.43495, 3.62334,0.82974, 3.57771,1.78885, 0.84223,-8.10205
45.00000, 3.17026,0.37666, 2.82843,2.82843, 0.64076,-5.01610
135.00000, 0.82974,0.37666, 2.82843,-2.82843, 0.64076,-5.01610
116.56505, 4.37666,0.82974, 3.57771,-1.78885, 0.84223,-8.10205
116.56505, 0.37666,0.82974, 3.57771,-1.78885, 0.84223,-8.10205
153.43495, 5.58305,-0.00000, 1.78885,-3.57771, 0.84223,-8.10205
153.43495, 1.58305,-0.00000, 1.78885,-3.57771, 0.84223,-8.10205
63.43495, 4.00000,2.41695, 3.57771,1.78885, 0.84223,-8.10205
63.43495, 0.00000,2.41695, 3.57771,1.78885, 0.84223,-8.10205
45.00000, 0.37666,3.17026, 2.82843,2.82843, 0.64076,-5.01610
26.56505, 4.82974,3.62334, 1.78885,3.57771, 0.84223,-8.10205
26.56505, 0.82974,3.62334, 1.78885,3.57771, 0.84223,-8.10205
135.00000, 3.62334,3.17026, 2.82843,-2.82843, 0.64076,-5.01610
116.56505, 8.00000,2.41695, 3.57771,-1.78885, 0.84223,-8.10205
116.56505, 4.00000,2.41695, 3.57771,-1.78885, 0.84223,-8.10205
153.43495, 7.17026,3.62334, 1.78885,-3.57771, 0.84223,-8.10205
153.43495, 3.17026,3.62334, 1.78885,-3.57771, 0.84223,-8.10205
0.00000, 1.58305,4.00000, 0.00000,4.00000, 0.83390,-3.16610
270.00000, 0.00000,2.41695, 0.00000,4.00000, 0.83390,-3.16610
0.00000, 1.58305,3.62334, 0.00000,4.00000, 0.83390,-3.16610
153.43495, 5.58305,3.62334, 1.78885,-3.57771, 0.84223,-8.10205
153.43495, 1.58305,3.62334, 1.78885,-3.57771, 0.84223,-8.10205
26.56505, 6.41695,3.62334, 1.78885,3.57771, 0.84223,-8.10205
26.56505, 2.41695,3.62334, 1.78885,3.57771, 0.84223,-8.10205
26.56505, 4.00000,2.00000, 1.78885,3.57771, 0.42111,-8.52316
26.56505, 0.00000,2.00000, 1.78885,3.57771, 0.42111,-8.52316
63.43495, 4.82974,2.64141, 3.57771,1.78885, 0.84223,-8.10205
63.43495, 0.82974,2.64141, 3.57771,1.78885, 0.84223,-8.10205
45.00000, 0.37666,2.18833, 2.82843,2.82843, 0.64076,-5.01610
270.00000, 1.20640,4.00000, 0.00000,4.00000, 0.60528,-3.39472
*MISC07,Triangular Pattern
0,0,0,.5,.8660,1,-2
60,1,0,.5,.8660,1,-2
120,0,0,.5,.8660,1,-2
*MISC08,lines
0.00000, 0.75000,3.00000, 0.00000,3.87500, 4.87500,-0.75000
90.00000, 0.75000,0.75000, 0.00000,5.62500, 2.25000,-1.62500
180.00000, 3.62500,0.75000, 0.00000,3.87500, 2.87500,-2.75000
270.00000, 3.62500,1.62500, 0.00000,5.62500, 0.87500,-3.00000
0.00000, 1.37500,1.62500, 0.00000,3.87500, 2.25000,-3.37500
270.00000, 1.37500,2.50000, 0.00000,5.62500, 0.87500,-3.00000
180.00000, 4.62500,2.50000, 0.00000,3.87500, 3.25000,-2.37500
90.00000, 4.62500,0.00000, 0.00000,5.62500, 2.50000,-1.37500
0.00000, 0.00000,0.00000, 0.00000,3.87500, 4.62500,-1.00000
270.00000, 0.00000,3.00000, 0.00000,5.62500, 3.00000,-0.87500
*MISC09,Tweed pattern
60,0,0,.21650635,.125,2,-2
120,0,0,-.21650635,.125,2,-2
90,0,0,0,1
*MISC10,Weave
0.00000, -0.00000,2.00000, 0.00000,4.00000, 2.00000,-2.00000
0.00000, -0.00000,0.60000, 0.00000,4.00000, 2.00000,-2.00000
270.00000, 0.00000,0.60000, 0.00000,4.00000, 0.60000,-3.40000
270.00000, 1.40000,0.60000, 0.00000,4.00000, 0.60000,-3.40000
270.00000, 1.40000,4.00000, 0.00000,4.00000, 2.00000,-2.00000
0.00000, 1.40000,2.60000, 0.00000,4.00000, 2.60000,-1.40000
270.00000, 2.00000,2.60000, 0.00000,4.00000, 2.60000,-1.40000
0.00000, 1.40000,-0.00000, 0.00000,4.00000, 2.60000,-1.40000
270.00000, 3.40000,2.60000, 0.00000,4.00000, 2.60000,-1.40000
0.00000, 3.40000,0.60000, 0.00000,4.00000, 0.60000,-3.40000
0.00000, 3.40000,2.00000, 0.00000,4.00000, 0.60000,-3.40000
270.00000, 4.00000,4.00000, 0.00000,4.00000, 2.00000,-2.00000
*MISC11,wow
90.00000, 2.40000,1.60000, 0.00000,4.00000, 0.80000,-3.20000
0.00000, 1.60000,1.60000, 0.00000,4.00000, 0.80000,-3.20000
270.00000, 1.60000,2.40000, 0.00000,4.00000, 0.80000,-3.20000
180.00000, 2.40000,2.40000, 0.00000,4.00000, 0.80000,-3.20000
126.86990, 6.00000,0.40000, 3.20000,-2.40000, 2.00000,-18.00000
126.86990, 10.00000,0.40000, 3.20000,-2.40000, 2.00000,-18.00000
126.86990, 14.00000,0.40000, 3.20000,-2.40000, 2.00000,-18.00000
126.86990, 6.00000,0.40000, 3.20000,-2.40000, 2.00000,-18.00000
126.86990, 10.00000,0.40000, 3.20000,-2.40000, 2.00000,-18.00000
126.86990, 2.00000,0.40000, 3.20000,-2.40000, 2.00000,-18.00000
53.13010, 6.00000,0.40000, 3.20000,2.40000, 2.00000,-18.00000
53.13010, 10.00000,0.40000, 3.20000,2.40000, 2.00000,-18.00000
53.13010, 14.00000,0.40000, 3.20000,2.40000, 2.00000,-18.00000
53.13010, 6.00000,0.40000, 3.20000,2.40000, 2.00000,-18.00000
53.13010, 10.00000,0.40000, 3.20000,2.40000, 2.00000,-18.00000
53.13010, 2.00000,0.40000, 3.20000,2.40000, 2.00000,-18.00000
126.86990, 7.20000,2.00000, 3.20000,-2.40000, 2.00000,-18.00000
126.86990, 11.20000,2.00000, 3.20000,-2.40000, 2.00000,-18.00000
126.86990, 15.20000,2.00000, 3.20000,-2.40000, 2.00000,-18.00000
126.86990, 7.20000,2.00000, 3.20000,-2.40000, 2.00000,-18.00000
126.86990, 11.20000,2.00000, 3.20000,-2.40000, 2.00000,-18.00000
126.86990, 3.20000,2.00000, 3.20000,-2.40000, 2.00000,-18.00000
53.13010, 4.80000,2.00000, 3.20000,2.40000, 2.00000,-18.00000
53.13010, 8.80000,2.00000, 3.20000,2.40000, 2.00000,-18.00000
53.13010, 12.80000,2.00000, 3.20000,2.40000, 2.00000,-18.00000
53.13010, 4.80000,2.00000, 3.20000,2.40000, 2.00000,-18.00000
53.13010, 8.80000,2.00000, 3.20000,2.40000, 2.00000,-18.00000
53.13010, 0.80000,2.00000, 3.20000,2.40000, 2.00000,-18.00000
146.30993, 5.20000,2.00000, 2.21880,-3.32820, 1.44222,-12.97998
146.30993, 5.20000,2.00000, 2.21880,-3.32820, 1.44222,-12.97998
146.30993, 9.20000,2.00000, 2.21880,-3.32820, 1.44222,-12.97998
146.30993, 1.20000,2.00000, 2.21880,-3.32820, 1.44222,-12.97998
33.69007, 4.00000,1.20000, 2.21880,3.32820, 1.44222,-12.97998
33.69007, 4.00000,1.20000, 2.21880,3.32820, 1.44222,-12.97998
33.69007, 8.00000,1.20000, 2.21880,3.32820, 1.44222,-12.97998
33.69007, 0.00000,1.20000, 2.21880,3.32820, 1.44222,-12.97998
45.00000, 1.20000,0.00000, 2.82843,2.82843, 1.13137,-4.52548
135.00000, 2.80000,0.00000, 2.82843,-2.82843, 1.13137,-4.52548
45.00000, 2.00000,3.20000, 2.82843,2.82843, 1.13137,-4.52548
135.00000, 2.00000,3.20000, 2.82843,-2.82843, 1.13137,-4.52548
146.30993, 8.00000,1.20000, 2.21880,-3.32820, 1.44222,-12.97998
146.30993, 8.00000,1.20000, 2.21880,-3.32820, 1.44222,-12.97998
146.30993, 12.00000,1.20000, 2.21880,-3.32820, 1.44222,-12.97998
146.30993, 4.00000,1.20000, 2.21880,-3.32820, 1.44222,-12.97998
33.69007, 6.80000,2.00000, 2.21880,3.32820, 1.44222,-12.97998
33.69007, 6.80000,2.00000, 2.21880,3.32820, 1.44222,-12.97998
33.69007, 10.80000,2.00000, 2.21880,3.32820, 1.44222,-12.97998
33.69007, 2.80000,2.00000, 2.21880,3.32820, 1.44222,-12.97998
135.00000, 0.25000,0.25000, 2.82843,-2.82843, 0.35355,-5.30330
135.00000, 0.37500,0.37500, 2.82843,-2.82843, 0.53033,-5.12652
90.00000, 0.12500,0.00000, 0.00000,4.00000, 0.12500,-3.87500
180.00000, 0.12500,0.12500, 0.00000,4.00000, 0.12500,-3.87500
135.00000, 0.50000,0.00000, 2.82843,-2.82843, 0.35355,-5.30330
135.00000, 0.75000,0.00000, 2.82843,-2.82843, 0.53033,-5.12652
45.00000, 3.25000,0.00000, 2.82843,2.82843, 0.53033,-5.12652
45.00000, 3.50000,0.00000, 2.82843,2.82843, 0.35355,-5.30330
0.00000, 3.87500,0.12500, 0.00000,4.00000, 0.12500,-3.87500
90.00000, 3.87500,0.00000, 0.00000,4.00000, 0.12500,-3.87500
45.00000, 3.62500,0.37500, 2.82843,2.82843, 0.53033,-5.12652
45.00000, 3.75000,0.25000, 2.82843,2.82843, 0.35355,-5.30330
135.00000, 4.00000,3.50000, 2.82843,-2.82843, 0.35355,-5.30330
135.00000, 4.00000,3.25000, 2.82843,-2.82843, 0.53033,-5.12652
270.00000, 3.87500,4.00000, 0.00000,4.00000, 0.12500,-3.87500
0.00000, 3.87500,3.87500, 0.00000,4.00000, 0.12500,-3.87500
135.00000, 3.75000,3.75000, 2.82843,-2.82843, 0.35355,-5.30330
135.00000, 3.62500,3.62500, 2.82843,-2.82843, 0.53033,-5.12652
45.00000, 0.37500,3.62500, 2.82843,2.82843, 0.53033,-5.12652
45.00000, 0.25000,3.75000, 2.82843,2.82843, 0.35355,-5.30330
180.00000, 0.12500,3.87500, 0.00000,4.00000, 0.12500,-3.87500
270.00000, 0.12500,4.00000, 0.00000,4.00000, 0.12500,-3.87500
45.00000, 0.00000,3.25000, 2.82843,2.82843, 0.53033,-5.12652
45.00000, 0.00000,3.50000, 2.82843,2.82843, 0.35355,-5.30330
*MISC12,Rigid Insulation
90, 0,0, 3,3, 3,-3
*MISC13
90, 0,0, 1,1, .5,-1.5
90, .1,0, 1,1, .5,-1.5
90, .3,0, 1,1, .5,-1.5
90, .6,0, 1,1, .5,-1.5
90, .7,0, 1,1, .5,-1.5
90, .85,0, 1,1, .5,-1.5
90, .5,.5, 1,1, .5,-1.5
90, .25,.5, 1,1, .5,-1.5
90, .5,.5, 1,1, .5,-1.5
90, .65,.5, 1,1, .5,-1.5
90, .9,.5, 1,1, .5,-1.5
90, .15,1, 1,1, .5,-1.5
90, .35,1, 1,1, .5,-1.5
90, .45,1, 1,1, .5,-1.5
90, .6,1, 1,1, .5,-1.5
90, .75,1, 1,1, .5,-1.5
90, .95,1, 1,1, .5,-1.5
90, .05,1.5, 1,1, .5,-1.5
90, .15,1.5, 1,1, .5,-1.5
90, .4,1.5, 1,1, .5,-1.5
90, .65,1.5, 1,1, .5,-1.5
90, .72,1.5, 1,1, .5,-1.5
90, .86,1.5, 1,1, .5,-1.5
90, .98,1.5, 1,1, .5,-1.5
*MSCFLR00,Basket weave
90.00000, 2.50000,2.50000, 0.00000,5.00000, 1.25000,-3.75000
135.00000, 5.00000,1.25000, 3.53553,-3.53553, 1.76777,-5.30330
45.00000, 1.25000,1.25000, 3.53553,3.53553, 1.76777,-5.30330
270.00000, 3.75000,3.75000, 0.00000,5.00000, 1.25000,-3.75000
0.00000, 2.50000,3.75000, 0.00000,5.00000, 1.25000,-3.75000
180.00000, 3.75000,2.50000, 0.00000,-5.00000, 1.25000,-3.75000
0.00000, 0.00000,1.25000, 0.00000,5.00000, 1.25000,-3.75000
270.00000, 1.25000,1.25000, 0.00000,5.00000, 1.25000,-3.75000
180.00000, 1.25000,0.00000, 0.00000,5.00000, 1.25000,-3.75000
90.00000, 0.00000,0.00000, 0.00000,5.00000, 1.25000,-3.75000
135.00000, 2.50000,3.75000, 3.53553,-3.53553, 1.76777,-5.30330
45.00000, 3.75000,3.75000, 3.53553,3.53553, 1.76777,-5.30330
*MSCFLR01,temp
270.00000, 5.60000,2.43113, 0.00000,8.00000, 2.43113,-1.60000
270.00000, 5.20000,2.43113, 0.00000,8.00000, 2.43113,-1.60000
270.00000, 4.80000,2.43113, 0.00000,8.00000, 2.43113,-1.60000
270.00000, 4.40000,2.43113, 0.00000,8.00000, 2.43113,-1.60000
270.00000, 4.00000,2.43113, 0.00000,8.00000, 2.43113,-1.60000
180.00000, 8.00000,4.03113, 0.00000,4.03113, 6.40000,-1.60000
0.00000, 1.60000,3.63113, 0.00000,4.03113, 6.40000,-1.60000
0.00000, 1.60000,3.23113, 0.00000,4.03113, 6.40000,-1.60000
0.00000, 1.60000,2.83113, 0.00000,4.03113, 6.40000,-1.60000
0.00000, 1.60000,2.43113, 0.00000,4.03113, 6.40000,-1.60000
90.00000, 6.00000,0.43113, 0.00000,8.00000, 1.60000,-2.43113
180.00000, 7.60000,0.43113, 0.00000,4.03113, 1.60000,-6.40000
270.00000, 7.60000,2.03113, 0.00000,8.00000, 1.60000,-2.43113
0.00000, 6.00000,2.03113, 0.00000,4.03113, 1.60000,-6.40000
90.00000, 2.00000,0.43113, 0.00000,8.00000, 1.60000,-2.43113
180.00000, 3.60000,0.43113, 0.00000,4.03113, 1.60000,-6.40000
270.00000, 3.60000,2.03113, 0.00000,8.00000, 1.60000,-2.43113
0.00000, 2.00000,2.03113, 0.00000,4.03113, 1.60000,-6.40000
270.00000, 1.60000,4.03113, 0.00000,8.00000
270.00000, 1.20000,4.03113, 0.00000,8.00000
270.00000, 0.80000,4.03113, 0.00000,8.00000
270.00000, 0.40000,4.03113, 0.00000,8.00000
270.00000, 0.00000,4.03113, 0.00000,8.00000
*MSCFLR02,temp
0.00000, 0.00000,4.00000, 0.00000,12.00000
270.00000, 4.00000,12.00000, 0.00000,12.00000, 12.00000,-0.00000
0.00000, 0.00000,12.00000, 0.00000,12.00000
270.00000, 0.00000,12.00000, 0.00000,12.00000
*ROOF00,shake
;%TYPE=MODEL
270.00000, 31.50000,20.00000, 0.00000,35.00000, 5.25000,-18.75000
270.00000, 29.75000,22.00000, 0.00000,35.00000, 4.25000,-19.75000
270.00000, 28.75000,19.50000, 0.00000,35.00000, 3.50000,-20.50000
270.00000, 22.75000,21.25000, 0.00000,35.00000, 3.75000,-20.25000
270.00000, 21.50000,24.00000, 0.00000,35.00000, 8.25000,-15.75000
270.00000, 20.00000,19.75000, 0.00000,35.00000, 7.75000,-16.25000
270.00000, 15.00000,22.50000, 0.00000,35.00000, 7.25000,-16.75000
270.00000, 11.50000,19.25000, 0.00000,35.00000, 5.25000,-18.75000
270.00000, 5.50000,23.00000, 0.00000,35.00000, 6.50000,-17.50000
270.00000, 3.75000,20.00000, 0.00000,35.00000, 4.75000,-19.25000
270.00000, 21.25000,11.50000, 0.00000,35.00000, 5.50000,-18.50000
270.00000, 20.25000,6.00000, 0.00000,35.00000, 4.75000,-19.25000
270.00000, 23.25000,9.50000, 0.00000,35.00000, 5.25000,-18.75000
90.00000, 25.75000,0.00000, 0.00000,35.00000, 5.00000,-19.00000
90.00000, 27.50000,0.00000, 0.00000,35.00000, 8.00000,-16.00000
90.00000, 17.25000,0.00000, 0.00000,35.00000, 7.00000,-17.00000
270.00000, 14.50000,9.50000, 0.00000,35.00000, 4.75000,-19.25000
270.00000, 6.75000,10.75000, 0.00000,35.00000, 3.00000,-21.00000
270.00000, 2.25000,9.50000, 0.00000,35.00000, 2.75000,-21.25000
270.00000, 1.50000,12.00000, 0.00000,35.00000, 6.25000,-17.75000
90.00000, 10.00000,0.00000, 0.00000,35.00000, 4.25000,-19.75000
90.00000, 4.25000,1.25000, 0.00000,35.00000, 4.25000,-19.75000
270.00000, 10.50000,12.00000, 0.00000,35.00000, 4.00000,-20.00000
270.00000, 12.50000,12.00000, 0.00000,35.00000, 8.00000,-16.00000
270.00000, 16.00000,12.00000, 0.00000,35.00000, 12.00000,-12.00000
270.00000, 32.00000,12.00000, 0.00000,35.00000, 12.00000,-12.00000
270.00000, 35.00000,24.00000, 0.00000,35.00000, 12.00000,-12.00000
270.00000, 19.00000,24.00000, 0.00000,35.00000, 12.00000,-12.00000
0.00000, 0.00000,0.00000, 0.00000,24.00000
0.00000, 0.00000,12.00000, 0.00000,24.00000
*ROOF01,shingle
;%TYPE=MODEL
90.00000, 0.12500,0.00000, 0.00000,8.00000, 3.00000,-3.00000
90.00000, 3.52500,3.00000, 0.00000,8.00000, 3.00000,-3.00000
270.00000, 3.92500,6.00000, 0.00000,8.00000, 3.00000,-3.00000
90.00000, 7.72500,0.00000, 0.00000,8.00000, 3.00000,-3.00000
0.00000, 0.12500,0.00000, 0.00000,6.00000, 7.60000,-0.40000
180.00000, 11.52500,3.00000, 0.00000,6.00000, 7.60000,-0.40000
*ROOF02,45 shingle
;%TYPE=MODEL
45.00000, 5.52132,2.52757, 7.15946,7.15946, 3.58493,-10.73398
45.00000, 5.92132,2.52757, 7.15946,7.15946, 3.58493,-10.73398
45.00000, 0.40000,0.00000, 7.15946,7.15946, 3.58493,-10.73398
45.00000, 0.00000,0.00000, 7.15946,7.15946, 3.58493,-10.73398
45.00000, 0.00000,5.06250, 7.15946,7.15946, 3.58493,-10.73398
45.00000, 0.40000,5.06250, 7.15946,7.15946, 3.58493,-10.73398
45.00000, 5.92132,7.59007, 7.15946,7.15946, 3.58493,-10.73398
45.00000, 5.52132,7.59007, 7.15946,7.15946, 3.58493,-10.73398
0.00000, 0.40000,5.06250, 0.00000,10.12500, 7.65625,-2.46875
0.00000, 0.40000,0.00000, 0.00000,10.12500, 9.72500,-0.40000
0.00000, 5.92132,7.59007, 0.00000,10.12500, 9.72500,-0.40000
0.00000, 5.92132,2.52757, 0.00000,10.12500, 9.72500,-0.40000
0.00000, 8.45625,5.06250, 0.00000,10.12500, 1.66875,-8.45625
*ROOF03,spanish tile
;%TYPE=MODEL
90.00000, 0.16667,2.16667, 0.00000,8.00000, 7.50000,-0.50000
90.00000, 3.83333,2.16667, 0.00000,8.00000, 7.50000,-0.50000
45.00000, 0.00000,2.00000, 5.65685,5.65685, 0.23570,-11.07801
116.56505, 16.37666,1.24669, 7.15542,-3.57771, 1.68445,-16.20409
116.56505, 8.37666,1.24669, 7.15542,-3.57771, 1.68445,-16.20409
63.43495, 11.83333,2.16667, 7.15542,3.57771, 0.76117,-17.12738
63.43495, 3.83333,2.16667, 7.15542,3.57771, 0.76117,-17.12738
135.00000, 4.00000,2.00000, 5.65685,-5.65685, 0.23570,-11.07801
45.00000, 3.17026,0.79360, 5.65685,5.65685, 0.64076,-10.67295
26.56505, 12.82974,3.20640, 3.57771,7.15542, 0.84223,-17.04632
26.56505, 4.82974,3.20640, 3.57771,7.15542, 0.84223,-17.04632
63.43495, 11.62334,1.24669, 7.15542,3.57771, 1.68445,-16.20409
63.43495, 3.62334,1.24669, 7.15542,3.57771, 1.68445,-16.20409
0.00000, 5.58305,3.58305, 0.00000,8.00000, 0.83390,-7.16610
45.00000, 4.37666,2.75331, 5.65685,5.65685, 0.64076,-10.67295
135.00000, 7.62334,2.75331, 5.65685,-5.65685, 0.64076,-10.67295
153.43495, 15.17026,3.20640, 3.57771,-7.15542, 0.84223,-17.04632
153.43495, 7.17026,3.20640, 3.57771,-7.15542, 0.84223,-17.04632
153.43495, 15.31654,3.35719, 3.57771,-7.15542, 0.94751,-16.94104
153.43495, 7.31654,3.35719, 3.57771,-7.15542, 0.94751,-16.94104
116.56505, 16.16667,2.16667, 7.15542,-3.57771, 0.76117,-17.12738
116.56505, 8.16667,2.16667, 7.15542,-3.57771, 0.76117,-17.12738
135.00000, 7.82626,2.84747, 5.65685,-5.65685, 0.72085,-10.59285
45.00000, 4.17374,2.84747, 5.65685,5.65685, 0.72085,-10.59285
0.00000, 5.53093,3.78093, 0.00000,8.00000, 0.93814,-7.06186
26.56505, 12.68346,3.35719, 3.57771,7.15542, 0.94751,-16.94104
26.56505, 4.68346,3.35719, 3.57771,7.15542, 0.94751,-16.94104
153.43495, 9.58305,0.41695, 3.57771,-7.15542, 0.84223,-17.04632
153.43495, 1.58305,0.41695, 3.57771,-7.15542, 0.84223,-17.04632
0.00000, 1.58305,0.41695, 0.00000,8.00000, 0.83390,-7.16610
135.00000, 0.82974,0.79360, 5.65685,-5.65685, 0.64076,-10.67295
26.56505, 10.41695,0.41695, 3.57771,7.15542, 0.84223,-17.04632
26.56505, 2.41695,0.41695, 3.57771,7.15542, 0.84223,-17.04632
135.00000, 0.68346,0.64281, 5.65685,-5.65685, 0.72085,-10.59285
153.43495, 9.53093,0.21907, 3.57771,-7.15542, 0.94751,-16.94104
153.43495, 1.53093,0.21907, 3.57771,-7.15542, 0.94751,-16.94104
180.00000, 2.46907,0.21907, 0.00000,8.00000, 0.93814,-7.06186
26.56505, 10.46907,0.21907, 3.57771,7.15542, 0.94751,-16.94104
26.56505, 2.46907,0.21907, 3.57771,7.15542, 0.94751,-16.94104
45.00000, 3.31654,0.64281, 5.65685,5.65685, 0.72085,-10.59285
*STONE00,Gravel Pattern
0.00000, 1.49094,1.36963, 0.00000,2.50000, 0.17856,-2.32144
270.00000, 1.35522,1.23391, 0.00000,2.50000, 0.19725,-2.30275
45.00000, 1.35522,1.23391, 1.76777,1.76777, 0.19194,-3.34360
135.00000, 1.49094,0.90094, 1.76777,-1.76777, 0.19194,-3.34360
0.00000, 1.49094,0.90094, 0.00000,2.50000, 0.17856,-2.32144
90.00000, 1.80522,1.03666, 0.00000,2.50000, 0.19725,-2.30275
45.00000, 1.66950,0.90094, 1.76777,1.76777, 0.19194,-3.34360
135.00000, 1.80522,1.23391, 1.76777,-1.76777, 0.19194,-3.34360
0.00000, 0.07598,1.19426, 0.00000,2.50000, 0.09920,-2.40080
270.00000, 0.00058,1.11886, 0.00000,2.50000, 0.10958,-2.39042
45.00000, 0.00058,1.11886, 1.76777,1.76777, 0.10663,-3.42890
135.00000, 0.07598,0.93388, 1.76777,-1.76777, 0.10663,-3.42890
0.00000, 0.07598,0.93388, 0.00000,2.50000, 0.09920,-2.40080
90.00000, 0.25058,1.00928, 0.00000,2.50000, 0.10958,-2.39042
45.00000, 0.17518,0.93388, 1.76777,1.76777, 0.10663,-3.42890
135.00000, 0.25058,1.11886, 1.76777,-1.76777, 0.10663,-3.42890
0.00000, 1.88806,0.87381, 0.00000,2.50000, 0.25792,-2.24208
270.00000, 1.69202,0.67777, 0.00000,2.50000, 0.28491,-2.21509
45.00000, 1.69202,0.67777, 1.76777,1.76777, 0.27724,-3.25829
135.00000, 1.88806,0.19682, 1.76777,-1.76777, 0.27724,-3.25829
0.00000, 1.88806,0.19682, 0.00000,2.50000, 0.25792,-2.24208
90.00000, 2.34202,0.39286, 0.00000,2.50000, 0.28491,-2.21509
45.00000, 2.14598,0.19682, 1.76777,1.76777, 0.27724,-3.25829
135.00000, 2.34202,0.67777, 1.76777,-1.76777, 0.27724,-3.25829
0.00000, 1.29445,2.37882, 0.00000,2.50000, 0.19840,-2.30160
270.00000, 1.14365,2.22802, 0.00000,2.50000, 0.21916,-2.28084
45.00000, 1.14365,2.22802, 1.76777,1.76777, 0.21326,-3.32227
135.00000, 1.29445,1.85805, 1.76777,-1.76777, 0.21326,-3.32227
0.00000, 1.29445,1.85805, 0.00000,2.50000, 0.19840,-2.30160
90.00000, 1.64365,2.00885, 0.00000,2.50000, 0.21916,-2.28084
45.00000, 1.49285,1.85805, 1.76777,1.76777, 0.21326,-3.32227
135.00000, 1.64365,2.22802, 1.76777,-1.76777, 0.21326,-3.32227
0.00000, 2.03565,1.92761, 0.00000,2.50000, 0.24800,-2.25200
270.00000, 1.84715,1.73912, 0.00000,2.50000, 0.27395,-2.22605
45.00000, 1.84715,1.73912, 1.76777,1.76777, 0.26658,-3.26896
135.00000, 2.03565,1.27666, 1.76777,-1.76777, 0.26658,-3.26896
0.00000, 2.03565,1.27666, 0.00000,2.50000, 0.24800,-2.25200
90.00000, 2.47215,1.46516, 0.00000,2.50000, 0.27395,-2.22605
45.00000, 2.28365,1.27666, 1.76777,1.76777, 0.26658,-3.26896
135.00000, 2.47215,1.73912, 1.76777,-1.76777, 0.26658,-3.26896
0.00000, 1.31861,0.42767, 0.00000,2.50000, 0.13888,-2.36112
270.00000, 1.21305,0.32211, 0.00000,2.50000, 0.15341,-2.34659
45.00000, 1.21305,0.32211, 1.76777,1.76777, 0.14928,-3.38625
135.00000, 1.31861,0.06314, 1.76777,-1.76777, 0.14928,-3.38625
0.00000, 1.31861,0.06314, 0.00000,2.50000, 0.13888,-2.36112
90.00000, 1.56305,0.16870, 0.00000,2.50000, 0.15341,-2.34659
45.00000, 1.45749,0.06314, 1.76777,1.76777, 0.14928,-3.38625
135.00000, 1.56305,0.32211, 1.76777,-1.76777, 0.14928,-3.38625
0.00000, 0.44463,2.20352, 0.00000,2.50000, 0.39680,-2.10320
270.00000, 0.14303,1.90192, 0.00000,2.50000, 0.43833,-2.06167
45.00000, 0.14303,1.90192, 1.76777,1.76777, 0.42653,-3.10901
135.00000, 0.44463,1.16199, 1.76777,-1.76777, 0.42653,-3.10901
0.00000, 0.44463,1.16199, 0.00000,2.50000, 0.39680,-2.10320
90.00000, 1.14303,1.46359, 0.00000,2.50000, 0.43833,-2.06167
45.00000, 0.84143,1.16199, 1.76777,1.76777, 0.42653,-3.10901
135.00000, 1.14303,1.90192, 1.76777,-1.76777, 0.42653,-3.10901
0.00000, 0.29445,0.62882, 0.00000,2.50000, 0.19840,-2.30160
270.00000, 0.14365,0.47802, 0.00000,2.50000, 0.21916,-2.28084
45.00000, 0.14365,0.47802, 1.76777,1.76777, 0.21326,-3.32227
135.00000, 0.29445,0.10805, 1.76777,-1.76777, 0.21326,-3.32227
0.00000, 0.29445,0.10805, 0.00000,2.50000, 0.19840,-2.30160
90.00000, 0.64365,0.25885, 0.00000,2.50000, 0.21916,-2.28084
45.00000, 0.49285,0.10805, 1.76777,1.76777, 0.21326,-3.32227
135.00000, 0.64365,0.47802, 1.76777,-1.76777, 0.21326,-3.32227
*STONE01,rock
;%TYPE=MODEL
270.00000, 2.50000,5.00000, 0.00000,5.00000, 2.50000,-2.50000
270.00000, 2.00000,5.00000, 0.00000,5.00000, 2.50000,-2.50000
270.00000, 1.50000,5.00000, 0.00000,5.00000, 2.50000,-2.50000
0.00000, 0.00000,4.50000, 0.00000,5.00000, 1.00000,-4.00000
0.00000, 0.00000,4.00000, 0.00000,5.00000, 0.75000,-4.25000
0.00000, 0.00000,3.50000, 0.00000,5.00000, 0.50000,-4.50000
0.00000, 0.00000,3.00000, 0.00000,5.00000, 0.25000,-4.75000
0.00000, 2.75000,4.50000, 0.00000,5.00000, 2.25000,-2.75000
0.00000, 3.00000,4.00000, 0.00000,5.00000, 2.00000,-3.00000
0.00000, 3.25000,3.50000, 0.00000,5.00000, 1.75000,-3.25000
0.00000, 3.50000,3.00000, 0.00000,5.00000, 1.50000,-3.50000
116.56505, 8.75000,2.50000, 4.47214,-2.23607, 2.79508,-8.38525
116.56505, 3.75000,2.50000, 4.47214,-2.23607, 2.79508,-8.38525
63.43495, 5.00000,2.50000, 4.47214,2.23607, 2.79508,-8.38525
63.43495, 0.00000,2.50000, 4.47214,2.23607, 2.79508,-8.38525
270.00000, 1.00000,4.50000, 0.00000,5.00000, 2.50000,-2.50000
270.00000, 0.50000,3.50000, 0.00000,5.00000, 2.50000,-2.50000
90.00000, 3.00000,1.50000, 0.00000,5.00000, 2.50000,-2.50000
90.00000, 3.50000,0.50000, 0.00000,5.00000, 2.50000,-2.50000
90.00000, 4.00000,0.00000, 0.00000,5.00000, 2.50000,-2.50000
90.00000, 4.50000,0.00000, 0.00000,5.00000, 2.50000,-2.50000
90.00000, 5.00000,0.00000, 0.00000,5.00000, 2.50000,-2.50000
180.00000, 5.00000,5.00000, 0.00000,5.00000
0.00000, 0.25000,0.50000, 0.00000,5.00000, 3.25000,-1.75000
180.00000, 3.25000,1.00000, 0.00000,-5.00000, 2.75000,-2.25000
0.00000, 0.75000,1.50000, 0.00000,5.00000, 2.25000,-2.75000
0.00000, 1.00000,2.00000, 0.00000,5.00000, 1.75000,-3.25000
116.56505, 8.75000,0.00000, 4.47214,-2.23607, 2.79508,-8.38525
116.56505, 3.75000,0.00000, 4.47214,-2.23607, 2.79508,-8.38525
63.43495, 5.00000,0.00000, 4.47214,2.23607, 2.79508,-8.38525
63.43495, 0.00000,0.00000, 4.47214,2.23607, 2.79508,-8.38525
0.00000, 0.00000,2.50000, 0.00000,5.00000
0.00000, 1.25000,2.50000, 0.00000,5.00000, 1.25000,-3.75000
*STONE03,stones
;%TYPE=MODEL
90.00000, 3.25000,0.50000, 0.00000,3.25000, 0.50000,-1.50000
90.00000, 2.75000,0.75000, 0.00000,3.25000, 0.25000,-1.75000
0.00000, 1.75000,0.75000, 0.00000,2.00000, 1.50000,-1.75000
90.00000, 1.75000,0.75000, 0.00000,3.25000, 0.25000,-1.75000
180.00000, 3.75000,0.50000, 0.00000,2.00000, 1.50000,-1.75000
90.00000, 2.25000,0.50000, 0.00000,3.25000, 0.25000,-1.75000
270.00000, 1.75000,0.75000, 0.00000,3.25000, 0.50000,-1.50000
0.00000, 2.25000,0.00000, 0.00000,2.00000
90.00000, 2.25000,0.00000, 0.00000,3.25000, 0.50000,-1.50000
90.00000, 3.00000,0.00000, 0.00000,3.25000, 0.50000,-1.50000
180.00000, 5.50000,0.25000, 0.00000,2.00000, 2.50000,-0.75000
0.00000, 1.00000,0.50000, 0.00000,2.00000, 0.75000,-2.50000
90.00000, 1.25000,0.25000, 0.00000,3.25000, 0.25000,-1.75000
270.00000, 1.50000,0.50000, 0.00000,3.25000, 0.25000,-1.75000
90.00000, 2.75000,1.25000, 0.00000,3.25000, 0.25000,-1.75000
270.00000, 0.50000,1.50000, 0.00000,3.25000, 0.25000,-1.75000
90.00000, 0.25000,1.25000, 0.00000,3.25000, 0.25000,-1.75000
0.00000, 0.00000,1.50000, 0.00000,2.00000, 0.75000,-2.50000
180.00000, 4.50000,1.25000, 0.00000,2.00000, 2.50000,-0.75000
90.00000, 2.00000,1.00000, 0.00000,3.25000, 0.50000,-1.50000
90.00000, 1.25000,1.00000, 0.00000,3.25000, 0.50000,-1.50000
0.00000, 1.75000,1.00000, 0.00000,2.00000
270.00000, 0.75000,1.75000, 0.00000,3.25000, 0.50000,-1.50000
90.00000, 1.25000,1.50000, 0.00000,3.25000, 0.25000,-1.75000
180.00000, 2.75000,1.50000, 0.00000,2.00000, 1.50000,-1.75000
90.00000, 0.75000,1.75000, 0.00000,3.25000, 0.25000,-1.75000
0.00000, 0.75000,1.75000, 0.00000,2.00000, 1.50000,-1.75000
90.00000, 1.75000,1.75000, 0.00000,3.25000, 0.25000,-1.75000
90.00000, 2.25000,1.50000, 0.00000,3.25000, 0.50000,-1.50000
270.00000, 3.25000,2.00000, 0.00000,3.25000, 0.75000,-1.25000
*STONE04,stones
;%TYPE=MODEL
180.00000, 16.12500,5.00000, 0.00000,11.50000, 16.12500,4.12500
180.00000, 16.12500,11.50000, 0.00000,11.50000
270.00000, 6.25000,8.25000, 0.00000,12.00000, 3.25000,-8.25000
270.00000, 9.12500,8.25000, 0.00000,12.00000, 3.25000,-8.25000
180.00000, 10.25000,8.25000, 0.00000,11.50000, 6.12500,-5.87500
270.00000, 10.25000,11.50000, 0.00000,12.00000, 6.50000,-5.00000
90.00000, 4.12500,5.00000, 0.00000,12.00000, 6.50000,-5.00000
270.00000, 5.62500,5.00000, 0.00000,12.00000, 5.00000,-6.50000
0.00000, 0.00000,3.12500, 0.00000,11.50000, 5.62500,-6.37500
270.00000, 0.00000,5.00000, 0.00000,12.00000, 5.00000,-6.50000
90.00000, 12.00000,0.00000, 0.00000,12.00000, 5.00000,-6.50000
0.00000, 0.00000,0.00000, 0.00000,11.50000
*STONE05,stones
;%TYPE=MODEL
180.00000, 5.12500,4.75000, 0.00000,11.50000, 5.12500,-6.87500
180.00000, 10.00000,11.25000, 0.00000,11.50000, 5.87500,-6.12500
0.00000, 5.37500,0.00000, 0.00000,11.50000, 6.37500,-5.62500
90.00000, 4.12500,8.25000, 0.00000,12.00000, 3.00000,-8.50000
180.00000, 6.00000,8.00000, 0.00000,11.50000, 1.87500,-10.12500
180.00000, 8.87500,8.00000, 0.00000,11.50000, 2.62500,-9.37500
270.00000, 10.00000,8.00000, 0.00000,12.00000, 3.00000,-8.50000
180.00000, 10.00000,5.00000, 0.00000,11.50000, 0.87500,-11.12500
180.00000, 8.87500,5.00000, 0.00000,11.50000, 2.62500,-9.37500
180.00000, 6.00000,5.00000, 0.00000,11.50000, 1.87500,-10.12500
270.00000, 5.12500,2.87500, 0.00000,12.00000, 2.87500,-8.62500
270.00000, 0.00000,2.87500, 0.00000,12.00000, 2.87500,-8.62500
180.00000, 10.00000,8.25000, 0.00000,11.50000, 5.87500,-6.12500
270.00000, 10.25000,11.25000, 0.00000,12.00000, 6.25000,-5.25000
270.00000, 9.12500,8.00000, 0.00000,12.00000, 3.00000,-8.50000
270.00000, 6.25000,8.00000, 0.00000,12.00000, 3.00000,-8.50000
90.00000, 4.12500,5.00000, 0.00000,12.00000, 3.00000,-8.50000
180.00000, 15.87500,5.00000, 0.00000,11.50000, 5.62500,-6.37500
0.00000, 0.00000,0.00000, 0.00000,11.50000, 5.12500,-6.87500
270.00000, 5.12500,4.75000, 0.00000,12.00000, 1.62500,-9.87500
0.00000, 0.00000,3.12500, 0.00000,11.50000, 5.12500,-6.87500
270.00000, 0.00000,4.75000, 0.00000,12.00000, 1.62500,-9.87500
90.00000, 11.75000,0.00000, 0.00000,12.00000, 4.75000,-6.75000
0.00000, 0.00000,2.87500, 0.00000,11.50000, 5.12500,-6.87500
270.00000, 5.37500,4.75000, 0.00000,12.00000, 4.75000,-6.75000
90.00000, 3.87500,5.00000, 0.00000,12.00000, 6.25000,-5.25000
270.00000, 10.00000,11.25000, 0.00000,12.00000, 3.00000,-8.50000
180.00000, 10.00000,8.00000, 0.00000,11.50000, 0.87500,-11.12500
270.00000, 8.87500,8.00000, 0.00000,12.00000, 3.00000,-8.50000
270.00000, 6.00000,8.00000, 0.00000,12.00000, 3.00000,-8.50000
180.00000, 15.87500,11.25000, 0.00000,11.50000, 5.62500,-6.37500
180.00000, 11.75000,4.75000, 0.00000,11.50000, 6.37500,-5.62500
*STONE06,stones
;%TYPE=MODEL
0.00000, 2.87500,0.00000, 0.00000,11.50000, 1.87500,-10.12500
270.00000, 2.62500,1.87500, 0.00000,12.00000, 1.87500,-9.62500
270.00000, 5.00000,2.87500, 0.00000,12.00000, 2.87500,-8.62500
0.00000, 5.00000,3.12500, 0.00000,11.50000, 1.00000,-11.00000
180.00000, 4.75000,4.75000, 0.00000,11.50000, 1.87500,-10.12500
180.00000, 2.62500,4.75000, 0.00000,11.50000, 2.62500,-9.37500
270.00000, 2.62500,4.75000, 0.00000,12.00000, 2.62500,-8.87500
270.00000, 2.87500,4.75000, 0.00000,12.00000, 4.75000,-6.75000
180.00000, 15.87500,11.25000, 0.00000,11.50000, 5.62500,-6.37500
270.00000, 6.00000,8.00000, 0.00000,12.00000, 3.00000,-8.50000
270.00000, 8.87500,8.00000, 0.00000,12.00000, 4.87500,-6.62500
180.00000, 10.00000,8.00000, 0.00000,11.50000, 0.87500,-11.12500
270.00000, 10.00000,11.25000, 0.00000,12.00000, 3.00000,-8.50000
90.00000, 3.87500,5.00000, 0.00000,12.00000, 6.25000,-5.25000
270.00000, 4.75000,4.75000, 0.00000,12.00000, 4.75000,-6.75000
0.00000, 0.00000,1.87500, 0.00000,11.50000, 2.62500,-9.37500
90.00000, 11.75000,0.00000, 0.00000,12.00000, 2.87500,-8.62500
0.00000, 0.00000,0.00000, 0.00000,11.50000, 2.62500,-9.37500
180.00000, 15.87500,5.00000, 0.00000,11.50000, 5.62500,-6.37500
180.00000, 10.00000,8.25000, 0.00000,11.50000, 5.87500,-6.12500
270.00000, 0.00000,4.75000, 0.00000,12.00000, 2.62500,-8.87500
0.00000, 0.00000,2.12500, 0.00000,11.50000, 2.62500,-9.37500
270.00000, 5.00000,4.75000, 0.00000,12.00000, 1.62500,-9.87500
90.00000, 4.12500,5.00000, 0.00000,12.00000, 3.00000,-8.50000
270.00000, 6.25000,8.00000, 0.00000,12.00000, 4.87500,-6.62500
270.00000, 9.12500,8.00000, 0.00000,12.00000, 3.00000,-8.50000
270.00000, 10.25000,11.25000, 0.00000,12.00000, 6.25000,-5.25000
180.00000, 11.75000,4.75000, 0.00000,11.50000, 2.62500,-9.37500
0.00000, 5.00000,0.00000, 0.00000,11.50000, 6.75000,-5.25000
270.00000, 0.00000,1.87500, 0.00000,12.00000, 1.87500,-9.62500
90.00000, 4.12500,8.25000, 0.00000,12.00000, 3.00000,-8.50000
180.00000, 6.00000,8.00000, 0.00000,11.50000, 1.87500,-10.12500
180.00000, 8.87500,8.00000, 0.00000,11.50000, 2.62500,-9.37500
270.00000, 10.00000,8.00000, 0.00000,12.00000, 3.00000,-8.50000
180.00000, 6.00000,5.00000, 0.00000,11.50000, 1.87500,-10.12500
180.00000, 10.00000,5.00000, 0.00000,11.50000, 0.87500,-11.12500
180.00000, 10.00000,11.25000, 0.00000,11.50000, 5.87500,-6.12500
180.00000, 6.00000,4.75000, 0.00000,11.50000, 1.00000,-11.00000
0.00000, 6.25000,3.12500, 0.00000,11.50000, 2.62500,-9.37500
0.00000, 9.12500,3.12500, 0.00000,11.50000, 2.62500,-9.37500
270.00000, 9.12500,4.75000, 0.00000,12.00000, 1.62500,-9.87500
270.00000, 6.00000,4.75000, 0.00000,12.00000, 1.62500,-9.87500
90.00000, 11.75000,3.12500, 0.00000,12.00000, 1.62500,-9.87500
0.00000, 5.00000,2.87500, 0.00000,11.50000, 6.75000,-5.25000
*TILE00,temp
;%TYPE=MODEL
270.00000, 8.00000,2.00000, 0.00000,10.00000, 2.00000,-8.00000
270.00000, 6.00000,2.00000, 0.00000,10.00000, 2.00000,-8.00000
270.00000, 4.00000,2.00000, 0.00000,10.00000, 2.00000,-8.00000
0.00000, 0.00000,4.00000, 0.00000,10.00000, 2.00000,-8.00000
0.00000, 0.00000,6.00000, 0.00000,10.00000, 2.00000,-8.00000
0.00000, 0.00000,8.00000, 0.00000,10.00000, 2.00000,-8.00000
180.00000, 10.00000,2.00000, 0.00000,10.00000
270.00000, 2.00000,10.00000, 0.00000,10.00000, 10.00000,-0.00000
270.00000, 10.00000,10.00000, 0.00000,10.00000
180.00000, 10.00000,0.00000, 0.00000,10.00000
*TILE01,temp
;%TYPE=MODEL
63.43495, 7.78976,3.34678, 3.57771,1.78885, 0.47012,-8.47415
63.43495, 3.78976,3.34678, 3.57771,1.78885, 0.47012,-8.47415
26.56505, 7.11637,2.88363, 1.78885,3.57771, 0.47012,-8.47415
26.56505, 3.11637,2.88363, 1.78885,3.57771, 0.47012,-8.47415
45.00000, 3.53685,3.09388, 2.82843,2.82843, 0.35766,-5.29919
26.56505, 6.23273,2.00000, 1.78885,3.57771, 0.47012,-8.47415
26.56505, 2.23273,2.00000, 1.78885,3.57771, 0.47012,-8.47415
63.43495, 6.90612,2.46315, 3.57771,1.78885, 0.47012,-8.47415
63.43495, 2.90612,2.46315, 3.57771,1.78885, 0.47012,-8.47415
45.00000, 2.65322,2.21024, 2.82843,2.82843, 0.35766,-5.29919
153.43495, 6.65322,1.78976, 1.78885,-3.57771, 0.47012,-8.47415
153.43495, 2.65322,1.78976, 1.78885,-3.57771, 0.47012,-8.47415
116.56505, 7.11637,1.11637, 3.57771,-1.78885, 0.47012,-8.47415
116.56505, 3.11637,1.11637, 3.57771,-1.78885, 0.47012,-8.47415
135.00000, 2.90612,1.53685, 2.82843,-2.82843, 0.35766,-5.29919
0.00000, 2.00000,2.00000, 0.00000,4.00000, 0.23273,-3.76727
153.43495, 7.53685,0.90612, 1.78885,-3.57771, 0.47012,-8.47415
153.43495, 3.53685,0.90612, 1.78885,-3.57771, 0.47012,-8.47415
135.00000, 3.78976,0.65322, 2.82843,-2.82843, 0.35766,-5.29919
116.56505, 8.00000,0.23273, 3.57771,-1.78885, 0.47012,-8.47415
116.56505, 4.00000,0.23273, 3.57771,-1.78885, 0.47012,-8.47415
153.43495, 4.65322,3.78976, 1.78885,-3.57771, 0.47012,-8.47415
153.43495, 0.65322,3.78976, 1.78885,-3.57771, 0.47012,-8.47415
116.56505, 5.11637,3.11637, 3.57771,-1.78885, 0.47012,-8.47415
116.56505, 1.11637,3.11637, 3.57771,-1.78885, 0.47012,-8.47415
135.00000, 0.90612,3.53685, 2.82843,-2.82843, 0.35766,-5.29919
45.00000, 0.65322,0.21024, 2.82843,2.82843, 0.35766,-5.29919
63.43495, 4.90612,0.46315, 3.57771,1.78885, 0.47012,-8.47415
63.43495, 0.90612,0.46315, 3.57771,1.78885, 0.47012,-8.47415
26.56505, 4.23273,0.00000, 1.78885,3.57771, 0.47012,-8.47415
26.56505, 0.23273,0.00000, 1.78885,3.57771, 0.47012,-8.47415
153.43495, 5.53685,2.90612, 1.78885,-3.57771, 0.47012,-8.47415
153.43495, 1.53685,2.90612, 1.78885,-3.57771, 0.47012,-8.47415
135.00000, 1.78976,2.65322, 2.82843,-2.82843, 0.35766,-5.29919
45.00000, 1.53685,1.09388, 2.82843,2.82843, 0.35766,-5.29919
26.56505, 5.11637,0.88363, 1.78885,3.57771, 0.47012,-8.47415
26.56505, 1.11637,0.88363, 1.78885,3.57771, 0.47012,-8.47415
116.56505, 6.00000,2.23273, 3.57771,-1.78885, 0.47012,-8.47415
116.56505, 2.00000,2.23273, 3.57771,-1.78885, 0.47012,-8.47415
63.43495, 5.78976,1.34678, 3.57771,1.78885, 0.47012,-8.47415
63.43495, 1.78976,1.34678, 3.57771,1.78885, 0.47012,-8.47415
90.00000, 2.00000,1.76727, 0.00000,4.00000, 0.46547,-3.53453
0.00000, 0.00000,4.00000, 0.00000,4.00000, 0.23273,-3.76727
0.00000, 0.00000,0.00000, 0.00000,4.00000, 0.23273,-3.76727
270.00000, 4.00000,4.00000, 0.00000,4.00000, 0.23273,-3.76727
90.00000, 4.00000,0.00000, 0.00000,4.00000, 0.23273,-3.76727
*TILE02,tile
;%TYPE=MODEL
135.00000, 4.00000,0.00000, 2.82843,-2.82843
45.00000, 0.00000,0.00000, 2.82843,2.82843, 5.65685,-0.00000
180.00000, 4.20847,3.00000, 0.00000,4.00000, 0.41695,-3.58305
0.00000, 0.00000,2.00000, 0.00000,4.00000
90.00000, 2.00000,0.00000, 0.00000,4.00000
63.43495, 4.81167,3.41487, 3.57771,1.78885, 0.42111,-8.52316
63.43495, 0.81167,3.41487, 3.57771,1.78885, 0.42111,-8.52316
45.00000, 0.58513,3.18833, 2.82843,2.82843, 0.32038,-5.33647
26.56505, 4.20847,3.00000, 1.78885,3.57771, 0.42111,-8.52316
26.56505, 0.20847,3.00000, 1.78885,3.57771, 0.42111,-8.52316
153.43495, 7.79153,3.00000, 1.78885,-3.57771, 0.42111,-8.52316
153.43495, 3.79153,3.00000, 1.78885,-3.57771, 0.42111,-8.52316
135.00000, 3.41487,3.18833, 2.82843,-2.82843, 0.32038,-5.33647
116.56505, 7.18833,3.41487, 3.57771,-1.78885, 0.42111,-8.52316
116.56505, 3.18833,3.41487, 3.57771,-1.78885, 0.42111,-8.52316
0.00000, 3.79153,1.00000, 0.00000,4.00000, 0.41695,-3.58305
26.56505, 7.41487,0.81167, 1.78885,3.57771, 0.42111,-8.52316
26.56505, 3.41487,0.81167, 1.78885,3.57771, 0.42111,-8.52316
45.00000, 3.18833,0.58513, 2.82843,2.82843, 0.32038,-5.33647
63.43495, 7.00000,0.20847, 3.57771,1.78885, 0.42111,-8.52316
63.43495, 3.00000,0.20847, 3.57771,1.78885, 0.42111,-8.52316
270.00000, 3.00000,0.20847, 0.00000,4.00000, 0.41695,-3.58305
270.00000, 1.00000,0.20847, 0.00000,4.00000, 0.41695,-3.58305
116.56505, 5.00000,0.20847, 3.57771,-1.78885, 0.42111,-8.52316
116.56505, 1.00000,0.20847, 3.57771,-1.78885, 0.42111,-8.52316
135.00000, 0.81167,0.58513, 2.82843,-2.82843, 0.32038,-5.33647
153.43495, 4.58513,0.81167, 1.78885,-3.57771, 0.42111,-8.52316
153.43495, 0.58513,0.81167, 1.78885,-3.57771, 0.42111,-8.52316
0.00000, 0.00000,0.00000, 0.00000,4.00000
90.00000, 4.00000,0.00000, 0.00000,4.00000
26.56505, 6.20847,1.00000, 1.78885,3.57771, 0.42111,-8.52316
26.56505, 2.20847,1.00000, 1.78885,3.57771, 0.42111,-8.52316
63.43495, 6.81167,1.41487, 3.57771,1.78885, 0.42111,-8.52316
63.43495, 2.81167,1.41487, 3.57771,1.78885, 0.42111,-8.52316
45.00000, 2.58513,1.18833, 2.82843,2.82843, 0.32038,-5.33647
135.00000, 1.41487,1.18833, 2.82843,-2.82843, 0.32038,-5.33647
0.00000, 1.79153,1.00000, 0.00000,4.00000, 0.41695,-3.58305
116.56505, 5.18833,1.41487, 3.57771,-1.78885, 0.42111,-8.52316
116.56505, 1.18833,1.41487, 3.57771,-1.78885, 0.42111,-8.52316
153.43495, 5.79153,1.00000, 1.78885,-3.57771, 0.42111,-8.52316
153.43495, 1.79153,1.00000, 1.78885,-3.57771, 0.42111,-8.52316
63.43495, 5.00000,2.20847, 3.57771,1.78885, 0.42111,-8.52316
63.43495, 1.00000,2.20847, 3.57771,1.78885, 0.42111,-8.52316
45.00000, 1.18833,2.58513, 2.82843,2.82843, 0.32038,-5.33647
26.56505, 5.41487,2.81167, 1.78885,3.57771, 0.42111,-8.52316
26.56505, 1.41487,2.81167, 1.78885,3.57771, 0.42111,-8.52316
0.00000, 1.79153,3.00000, 0.00000,4.00000, 0.41695,-3.58305
135.00000, 2.81167,2.58513, 2.82843,-2.82843, 0.32038,-5.33647
116.56505, 7.00000,2.20847, 3.57771,-1.78885, 0.42111,-8.52316
116.56505, 3.00000,2.20847, 3.57771,-1.78885, 0.42111,-8.52316
153.43495, 6.58513,2.81167, 1.78885,-3.57771, 0.42111,-8.52316
153.43495, 2.58513,2.81167, 1.78885,-3.57771, 0.42111,-8.52316
270.00000, 3.00000,2.20847, 0.00000,4.00000, 0.41695,-3.58305
270.00000, 1.00000,2.20847, 0.00000,4.00000, 0.41695,-3.58305
*TILE03,Herringbone
;%TYPE=MODEL
270.00000, 2.00000,8.00000, 0.00000,8.00000, 6.00000,-2.00000
0.00000, 0.00000,2.00000, 0.00000,8.00000, 6.00000,-2.00000
270.00000, 4.00000,2.00000, 0.00000,8.00000, 2.00000,-6.00000
180.00000, 4.00000,0.00000, 0.00000,8.00000, 4.00000,-4.00000
0.00000, 2.00000,4.00000, 0.00000,8.00000, 6.00000,-2.00000
270.00000, 8.00000,4.00000, 0.00000,8.00000, 4.00000,-4.00000
270.00000, 6.00000,4.00000, 0.00000,8.00000, 4.00000,-4.00000
0.00000, 6.00000,0.00000, 0.00000,8.00000, 2.00000,-6.00000
270.00000, 4.00000,8.00000, 0.00000,8.00000, 4.00000,-4.00000
0.00000, 4.00000,6.00000, 0.00000,8.00000, 4.00000,-4.00000
90.00000, 6.00000,6.00000, 0.00000,8.00000, 2.00000,-6.00000
180.00000, 2.00000,6.00000, 0.00000,8.00000, 2.00000,-6.00000
270.00000, 0.00000,6.00000, 0.00000,8.00000, 2.00000,-6.00000
*TILE04,Octagonal
;%TYPE=MODEL
45.00000, 3.65625,0.00000, 3.57973,3.57973, 1.98874,-5.17072
135.00000, 1.40625,0.00000, 3.57973,-3.57973, 1.98874,-5.17072
135.00000, 1.59927,0.28125, 3.57973,-3.57973, 1.86396,-5.29550
0.00000, 1.59927,0.28125, 0.00000,5.06250, 1.86396,-3.19854
45.00000, 3.46323,0.28125, 3.57973,3.57973, 1.86396,-5.29550
90.00000, 4.78125,1.59927, 0.00000,5.06250, 0.93198,-4.13052
270.00000, 0.28125,2.53125, 0.00000,5.06250, 0.93198,-4.13052
90.00000, 0.28125,2.53125, 0.00000,5.06250, 0.93198,-4.13052
270.00000, 4.78125,3.46323, 0.00000,5.06250, 0.93198,-4.13052
135.00000, 4.78125,3.46323, 3.57973,-3.57973, 1.86396,-5.29550
0.00000, 1.59927,4.78125, 0.00000,5.06250, 1.86396,-3.19854
45.00000, 0.28125,3.46323, 3.57973,3.57973, 1.86396,-5.29550
45.00000, 0.00000,3.65625, 3.57973,3.57973, 1.98874,-5.17072
135.00000, 5.06250,3.65625, 3.57973,-3.57973, 1.98874,-5.17072
*TILE05,Ocatagonal 2
;%TYPE=MODEL
45.00000, 5.13826,5.13826, 4.43817,4.43817, 1.60975,-7.26660
45.00000, 0.00000,0.00000, 4.43817,4.43817, 1.60975,-7.26660
135.00000, 6.27652,0.00000, 4.43817,-4.43817, 1.60975,-7.26660
135.00000, 1.13826,5.13826, 4.43817,-4.43817, 1.60975,-7.26660
180.00000, 5.13826,5.13826, 0.00000,6.27652, 4.00000,-2.27652
270.00000, 1.13826,5.13826, 0.00000,6.27652, 4.00000,-2.27652
0.00000, 1.13826,1.13826, 0.00000,6.27652, 4.00000,-2.27652
90.00000, 5.13826,1.13826, 0.00000,6.27652, 4.00000,-2.27652
*TILE06,temp
;%TYPE=MODEL
45.00000, 14.00000,14.00000, 14.14214,14.14214, 2.82843,-25.45584
45.00000, 0.00000,4.00000, 14.14214,14.14214, 2.82843,-25.45584
135.00000, 4.00000,4.00000, 14.14214,-14.14214, 2.82843,-25.45584
90.00000, 4.00000,0.00000, 0.00000,20.00000, 4.00000,-16.00000
45.00000, 4.00000,4.00000, 14.14214,14.14214, 2.82843,-25.45584
135.00000, 8.00000,4.00000, 14.14214,-14.14214, 2.82843,-25.45584
90.00000, 8.00000,-0.00000, 0.00000,20.00000, 4.00000,-16.00000
45.00000, 8.00000,4.00000, 14.14214,14.14214, 2.82843,-25.45584
135.00000, 12.00000,4.00000, 14.14214,-14.14214, 2.82843,-25.45584
90.00000, 12.00000,-0.00000, 0.00000,20.00000, 4.00000,-16.00000
45.00000, 12.00000,4.00000, 14.14214,14.14214, 2.82843,-25.45584
90.00000, 16.00000,-0.00000, 0.00000,20.00000, 4.00000,-16.00000
135.00000, 20.00000,4.00000, 14.14214,-14.14214, 2.82843,-25.45584
90.00000, 20.00000,-0.00000, 0.00000,20.00000, 4.00000,-16.00000
45.00000, 18.00000,14.00000, 14.14214,14.14214, 2.82843,-25.45584
270.00000, 18.00000,14.00000, 0.00000,20.00000, 8.00000,-12.00000
270.00000, 20.00000,20.00000, 0.00000,20.00000, 4.00000,-16.00000
270.00000, 16.00000,20.00000, 0.00000,20.00000, 4.00000,-16.00000
270.00000, 4.00000,20.00000, 0.00000,20.00000, 4.00000,-16.00000
45.00000, 2.00000,14.00000, 14.14214,14.14214, 2.82843,-25.45584
135.00000, 2.00000,14.00000, 14.14214,-14.14214, 2.82843,-25.45584
270.00000, 8.00000,20.00000, 0.00000,20.00000, 4.00000,-16.00000
270.00000, 12.00000,20.00000, 0.00000,20.00000, 4.00000,-16.00000
135.00000, 16.00000,4.00000, 14.14214,-14.14214, 2.82843,-25.45584
45.00000, 16.00000,4.00000, 14.14214,14.14214, 2.82843,-25.45584
135.00000, 18.00000,14.00000, 14.14214,-14.14214, 2.82843,-25.45584
45.00000, 10.00000,14.00000, 14.14214,14.14214, 2.82843,-25.45584
135.00000, 14.00000,14.00000, 14.14214,-14.14214, 2.82843,-25.45584
90.00000, 14.00000,6.00000, 0.00000,20.00000, 8.00000,-12.00000
270.00000, 10.00000,14.00000, 0.00000,20.00000, 8.00000,-12.00000
135.00000, 10.00000,14.00000, 14.14214,-14.14214, 2.82843,-25.45584
45.00000, 6.00000,14.00000, 14.14214,14.14214, 2.82843,-25.45584
90.00000, 2.00000,6.00000, 0.00000,20.00000, 8.00000,-12.00000
135.00000, 6.00000,14.00000, 14.14214,-14.14214, 2.82843,-25.45584
90.00000, 6.00000,6.00000, 0.00000,20.00000, 8.00000,-12.00000
*TILE07,temp
;%TYPE=MODEL
0.00000, 0.18750,0.18750, 0.00000,3.37500, 6.00000,-0.37500
90.00000, 6.18750,0.18750, 0.00000,6.37500, 3.00000,-0.37500
180.00000, 6.18750,3.18750, 0.00000,3.37500, 6.00000,-0.37500
270.00000, 0.18750,3.18750, 0.00000,6.37500, 3.00000,-0.37500
*TILE08,temp
;%TYPE=MODEL
270.00000, -6.25000,-0.25000, 0.00000,6.56250, 6.00000,-0.50000
180.00000, -0.25000,-0.25000, 0.00000,6.50000, 6.00000,-0.56250
90.00000, -0.25000,-6.25000, 0.00000,6.56250, 6.00000,-0.50000
0.00000, -6.25000,-6.25000, 0.00000,6.50000, 6.00000,-0.56250
*TILE09,temp
;%TYPE=MODEL
90.00000, 1.15149,1.47362, 0.00000,8.00000, 1.05276,-6.94724
116.56505, 8.27985,3.13052, 7.15542,-3.57771, 0.62576,-17.26279
116.56505, 0.27985,3.13052, 7.15542,-3.57771, 0.62576,-17.26279
153.43495, 9.15149,2.52638, 3.57771,-7.15542, 0.59816,-17.29038
153.43495, 1.15149,2.52638, 3.57771,-7.15542, 0.59816,-17.29038
135.00000, 0.61648,2.79389, 5.65685,-5.65685, 0.47607,-10.83764
45.00000, 5.68650,2.79389, 5.65685,5.65685, 0.47607,-10.83764
26.56505, 13.15149,2.52638, 3.57771,7.15542, 0.59816,-17.29038
26.56505, 5.15149,2.52638, 3.57771,7.15542, 0.59816,-17.29038
63.43495, 14.02314,3.13052, 7.15542,3.57771, 0.62576,-17.26279
63.43495, 6.02314,3.13052, 7.15542,3.57771, 0.62576,-17.26279
90.00000, 5.15149,1.47362, 0.00000,8.00000, 1.05276,-6.94724
90.00000, 2.30298,0.00000, 0.00000,8.00000, 0.30978,-7.69022
135.00000, 2.02314,0.86948, 5.65685,-5.65685, 0.47607,-10.83764
153.43495, 9.68650,1.20611, 3.57771,-7.15542, 0.59816,-17.29038
153.43495, 1.68650,1.20611, 3.57771,-7.15542, 0.59816,-17.29038
116.56505, 10.30298,0.30978, 7.15542,-3.57771, 0.62576,-17.26279
116.56505, 2.30298,0.30978, 7.15542,-3.57771, 0.62576,-17.26279
63.43495, 12.00000,0.30978, 7.15542,3.57771, 0.62576,-17.26279
63.43495, 4.00000,0.30978, 7.15542,3.57771, 0.62576,-17.26279
26.56505, 12.61648,1.20611, 3.57771,7.15542, 0.59816,-17.29038
26.56505, 4.61648,1.20611, 3.57771,7.15542, 0.59816,-17.29038
45.00000, 4.27985,0.86948, 5.65685,5.65685, 0.47607,-10.83764
90.00000, 4.00000,0.00000, 0.00000,8.00000, 0.30978,-7.69022
180.00000, 8.00000,4.00000, 0.00000,8.00000, 1.69702,-6.30298
180.00000, 4.00000,8.00000, 0.00000,8.00000, 1.69702,-6.30298
270.00000, 4.00000,8.00000, 0.00000,8.00000, 0.30978,-7.69022
135.00000, 4.61648,6.79389, 5.65685,-5.65685, 0.47607,-10.83764
153.43495, 13.15149,6.52638, 3.57771,-7.15542, 0.59816,-17.29038
153.43495, 5.15149,6.52638, 3.57771,-7.15542, 0.59816,-17.29038
116.56505, 12.27985,7.13052, 7.15542,-3.57771, 0.62576,-17.26279
116.56505, 4.27985,7.13052, 7.15542,-3.57771, 0.62576,-17.26279
63.43495, 10.02314,7.13052, 7.15542,3.57771, 0.62576,-17.26279
63.43495, 2.02314,7.13052, 7.15542,3.57771, 0.62576,-17.26279
26.56505, 9.15149,6.52638, 3.57771,7.15542, 0.59816,-17.29038
26.56505, 1.15149,6.52638, 3.57771,7.15542, 0.59816,-17.29038
45.00000, 1.68650,6.79389, 5.65685,5.65685, 0.47607,-10.83764
270.00000, 2.30298,8.00000, 0.00000,8.00000, 0.30978,-7.69022
270.00000, 5.15149,6.52638, 0.00000,8.00000, 1.05276,-6.94724
116.56505, 14.30298,4.30978, 7.15542,-3.57771, 0.62576,-17.26279
116.56505, 6.30298,4.30978, 7.15542,-3.57771, 0.62576,-17.26279
153.43495, 13.68650,5.20611, 3.57771,-7.15542, 0.59816,-17.29038
153.43495, 5.68650,5.20611, 3.57771,-7.15542, 0.59816,-17.29038
135.00000, 6.02314,4.86948, 5.65685,-5.65685, 0.47607,-10.83764
90.00000, 6.30298,3.69022, 0.00000,8.00000, 0.61957,-7.38043
90.00000, 0.00000,3.69022, 0.00000,8.00000, 0.61957,-7.38043
45.00000, 0.27985,4.86948, 5.65685,5.65685, 0.47607,-10.83764
26.56505, 8.61648,5.20611, 3.57771,7.15542, 0.59816,-17.29038
26.56505, 0.61648,5.20611, 3.57771,7.15542, 0.59816,-17.29038
63.43495, 8.00000,4.30978, 7.15542,3.57771, 0.62576,-17.26279
63.43495, 0.00000,4.30978, 7.15542,3.57771, 0.62576,-17.26279
270.00000, 1.15149,6.52638, 0.00000,8.00000, 1.05276,-6.94724
*TILE10,temp
;%TYPE=MODEL
270.00000, 4.00000,4.00000, 0.00000,4.00000
153.43495, 5.17026,1.62334, 1.78885,-3.57771, 0.84223,-8.10205
153.43495, 1.17026,1.62334, 1.78885,-3.57771, 0.84223,-8.10205
116.56505, 6.00000,0.41695, 3.57771,-1.78885, 0.84223,-8.10205
116.56505, 2.00000,0.41695, 3.57771,-1.78885, 0.84223,-8.10205
135.00000, 1.62334,1.17026, 2.82843,-2.82843, 0.64076,-5.01610
26.56505, 6.82974,1.62334, 1.78885,3.57771, 0.84223,-8.10205
26.56505, 2.82974,1.62334, 1.78885,3.57771, 0.84223,-8.10205
45.00000, 2.37666,1.17026, 2.82843,2.82843, 0.64076,-5.01610
63.43495, 6.00000,0.41695, 3.57771,1.78885, 0.84223,-8.10205
63.43495, 2.00000,0.41695, 3.57771,1.78885, 0.84223,-8.10205
90.00000, 2.00000,0.00000, 0.00000,4.00000, 4.00000,0.00000
116.56505, 6.37666,2.82974, 3.57771,-1.78885, 0.84223,-8.10205
116.56505, 2.37666,2.82974, 3.57771,-1.78885, 0.84223,-8.10205
135.00000, 2.82974,2.37666, 2.82843,-2.82843, 0.64076,-5.01610
153.43495, 7.58305,2.00000, 1.78885,-3.57771, 0.84223,-8.10205
153.43495, 3.58305,2.00000, 1.78885,-3.57771, 0.84223,-8.10205
180.00000, 4.00000,2.00000, 0.00000,-4.00000, 4.00000,-0.00000
45.00000, 1.17026,2.37666, 2.82843,2.82843, 0.64076,-5.01610
63.43495, 5.62334,2.82974, 3.57771,1.78885, 0.84223,-8.10205
63.43495, 1.62334,2.82974, 3.57771,1.78885, 0.84223,-8.10205
26.56505, 4.41695,2.00000, 1.78885,3.57771, 0.84223,-8.10205
26.56505, 0.41695,2.00000, 1.78885,3.57771, 0.84223,-8.10205
26.56505, 6.41695,0.00000, 1.78885,3.57771, 0.84223,-8.10205
26.56505, 2.41695,0.00000, 1.78885,3.57771, 0.84223,-8.10205
63.43495, 7.62334,0.82974, 3.57771,1.78885, 0.84223,-8.10205
63.43495, 3.62334,0.82974, 3.57771,1.78885, 0.84223,-8.10205
45.00000, 3.17026,0.37666, 2.82843,2.82843, 0.64076,-5.01610
135.00000, 0.82974,0.37666, 2.82843,-2.82843, 0.64076,-5.01610
0.00000, 0.00000,0.00000, 0.00000,4.00000, 4.00000,0.00000
116.56505, 4.37666,0.82974, 3.57771,-1.78885, 0.84223,-8.10205
116.56505, 0.37666,0.82974, 3.57771,-1.78885, 0.84223,-8.10205
153.43495, 5.58305,0.00000, 1.78885,-3.57771, 0.84223,-8.10205
153.43495, 1.58305,0.00000, 1.78885,-3.57771, 0.84223,-8.10205
63.43495, 4.00000,2.41695, 3.57771,1.78885, 0.84223,-8.10205
63.43495, 0.00000,2.41695, 3.57771,1.78885, 0.84223,-8.10205
45.00000, 0.37666,3.17026, 2.82843,2.82843, 0.64076,-5.01610
26.56505, 4.82974,3.62334, 1.78885,3.57771, 0.84223,-8.10205
26.56505, 0.82974,3.62334, 1.78885,3.57771, 0.84223,-8.10205
135.00000, 3.62334,3.17026, 2.82843,-2.82843, 0.64076,-5.01610
116.56505, 8.00000,2.41695, 3.57771,-1.78885, 0.84223,-8.10205
116.56505, 4.00000,2.41695, 3.57771,-1.78885, 0.84223,-8.10205
153.43495, 7.17026,3.62334, 1.78885,-3.57771, 0.84223,-8.10205
153.43495, 3.17026,3.62334, 1.78885,-3.57771, 0.84223,-8.10205
*TILE11,1"x 1" tile
;%TYPE=MODEL
90.00000, 1.00000,0.00000, 0.00000,1.00000
0.00000, 0.00000,0.00000, 0.00000,1.00000
*WDFLR00,hardwood floor
;%TYPE=MODEL
270.00000, 5.25000,2.00000, 0.00000,29.25000, 2.00000,-4.00000
270.00000, 20.75000,4.00000, 0.00000,29.25000, 2.00000,-4.00000
270.00000, 0.00000,6.00000, 0.00000,29.25000, 2.00000,-4.00000
0.00000, 0.00000,0.00000, 0.00000,6.00000
0.00000, 0.00000,2.00000, 0.00000,6.00000
0.00000, 0.00000,4.00000, 0.00000,6.00000
*WDFLR01,canterbury pattern
;%TYPE=MODEL
270.00000, 2.83929,9.07226, 0.00000,13.25000, 1.50083,-11.74917
270.00000, 3.78571,8.12583, 0.00000,13.25000, 0.55441,-12.69559
270.00000, 9.46429,2.44726, 0.00000,13.25000, 1.50083,-11.74917
270.00000, 10.41071,1.50083, 0.00000,13.25000, 0.55441,-12.69559
135.00000, 10.96512,0.94643, 9.36916,-9.36916, 4.79940,-13.93893
135.00000, 12.30357,2.28488, 9.36916,-9.36916, 4.79940,-13.93893
135.00000, 5.67857,8.90988, 9.36916,-9.36916, 4.79940,-13.93893
135.00000, 4.34012,7.57143, 9.36916,-9.36916, 4.79940,-13.93893
45.00000, 7.57143,8.90988, 9.36916,9.36916, 4.79940,-13.93893
45.00000, 8.90988,7.57143, 9.36916,9.36916, 4.79940,-13.93893
180.00000, 5.67857,2.83929, 0.00000,-13.25000, 1.50083,-11.74917
0.00000, 5.12417,3.78571, 0.00000,13.25000, 0.55441,-12.69559
0.00000, 10.80274,9.46429, 0.00000,13.25000, 1.50083,-11.74917
0.00000, 11.74917,10.41071, 0.00000,13.25000, 0.55441,-12.69559
45.00000, 2.28488,0.94643, 9.36916,9.36916, 4.79940,-13.93893
45.00000, 0.94643,2.28488, 9.36916,9.36916, 4.79940,-13.93893
270.00000, 12.30357,5.67857, 0.00000,13.25000, 4.73214,-8.51786
270.00000, 12.30357,12.30357, 0.00000,13.25000, 4.73214,-8.51786
0.00000, 0.00000,6.62500, 0.00000,13.25000, 13.25000,0.00000
270.00000, 6.62500,13.25000, 0.00000,13.25000
0.00000, 0.00000,13.25000, 0.00000,13.25000, 13.25000,0.00000
270.00000, 0.00000,13.25000, 0.00000,13.25000
270.00000, 0.94643,12.30357, 0.00000,13.25000, 4.73214,-8.51786
270.00000, 1.89286,10.01869, 0.00000,13.25000, 2.44726,-10.80274
270.00000, 2.83929,12.30357, 0.00000,13.25000, 0.55441,-12.69559
270.00000, 3.78571,12.30357, 0.00000,13.25000, 1.50083,-11.74917
270.00000, 4.73214,12.30357, 0.00000,13.25000, 2.44726,-10.80274
270.00000, 5.67857,12.30357, 0.00000,13.25000, 4.73214,-8.51786
0.00000, 0.94643,12.30357, 0.00000,13.25000, 4.73214,-8.51786
0.00000, 0.94643,7.57143, 0.00000,13.25000, 4.73214,-8.51786
180.00000, 5.67857,5.67857, 0.00000,-13.25000, 4.73214,-8.51786
0.00000, 0.94643,4.73214, 0.00000,13.25000, 2.44726,-10.80274
180.00000, 2.44726,3.78571, 0.00000,-13.25000, 1.50083,-11.74917
0.00000, 0.94643,2.83929, 0.00000,13.25000, 0.55441,-12.69559
0.00000, 3.23131,1.89286, 0.00000,13.25000, 2.44726,-10.80274
180.00000, 5.67857,0.94643, 0.00000,-13.25000, 4.73214,-8.51786
270.00000, 5.67857,5.67857, 0.00000,13.25000, 4.73214,-8.51786
270.00000, 0.94643,5.67857, 0.00000,13.25000, 4.73214,-8.51786
0.00000, 7.57143,0.94643, 0.00000,13.25000, 4.73214,-8.51786
0.00000, 7.57143,5.67857, 0.00000,13.25000, 4.73214,-8.51786
270.00000, 11.35714,5.67857, 0.00000,13.25000, 2.44726,-10.80274
270.00000, 10.41071,5.67857, 0.00000,13.25000, 1.50083,-11.74917
270.00000, 9.46429,5.67857, 0.00000,13.25000, 0.55441,-12.69559
270.00000, 8.51786,3.39369, 0.00000,13.25000, 2.44726,-10.80274
270.00000, 7.57143,5.67857, 0.00000,13.25000, 4.73214,-8.51786
270.00000, 7.57143,12.30357, 0.00000,13.25000, 4.73214,-8.51786
180.00000, 12.30357,7.57143, 0.00000,-13.25000, 4.73214,-8.51786
0.00000, 9.85631,8.51786, 0.00000,13.25000, 2.44726,-10.80274
0.00000, 7.57143,9.46429, 0.00000,13.25000, 0.55441,-12.69559
180.00000, 9.07226,10.41071, 0.00000,-13.25000, 1.50083,-11.74917
0.00000, 7.57143,11.35714, 0.00000,13.25000, 2.44726,-10.80274
180.00000, 12.30357,12.30357, 0.00000,-13.25000, 4.73214,-8.51786
45.00000, 0.94643,0.94643, 9.36916,9.36916, 18.73833,-0.00000
135.00000, 12.30357,0.94643, 9.36916,-9.36916, 18.73833,-0.00000
135.00000, 7.57143,12.30357, 9.36916,-9.36916, 2.67690,-16.06143
45.00000, 5.67857,12.30357, 9.36916,9.36916, 2.67690,-16.06143
135.00000, 0.94643,5.67857, 9.36916,-9.36916, 2.67690,-16.06143
45.00000, -0.94643,5.67857, 9.36916,9.36916, 2.67690,-16.06143
*WDFLR02,Chaucer pattern
;%TYPE=MODEL
135.00000, 6.75893,0.04018, 9.54594,-9.54594, 9.50175,-9.59014
45.00000, 6.75893,0.04018, 9.54594,9.54594, 9.50175,-9.59014
45.00000, 0.04018,6.75893, 9.54594,9.54594, 9.50175,-9.59014
135.00000, 13.47768,6.75893, 9.54594,-9.54594, 9.50175,-9.59014
135.00000, 4.03390,4.03390, 9.54594,-9.54594, 4.75087,-14.34101
135.00000, 4.71516,4.71516, 9.54594,-9.54594, 4.75087,-14.34101
135.00000, 5.39641,5.39641, 9.54594,-9.54594, 4.75087,-14.34101
135.00000, 6.07767,6.07767, 9.54594,-9.54594, 4.75087,-14.34101
45.00000, 4.08081,2.71830, 9.54594,9.54594, 4.75087,-14.34101
45.00000, 4.76207,2.03704, 9.54594,9.54594, 4.75087,-14.34101
45.00000, 5.44333,1.35578, 9.54594,9.54594, 4.75087,-14.34101
45.00000, 6.12458,0.67452, 9.54594,9.54594, 4.75087,-14.34101
45.00000, 4.03390,9.48396, 9.54594,9.54594, 4.75087,-14.34101
45.00000, 5.39641,8.12144, 9.54594,9.54594, 4.75087,-14.34101
45.00000, 6.07767,7.44019, 9.54594,9.54594, 4.75087,-14.34101
135.00000, 12.84333,6.12458, 9.54594,-9.54594, 4.75087,-14.34101
135.00000, 12.16208,5.44333, 9.54594,-9.54594, 4.75087,-14.34101
135.00000, 11.48082,4.76207, 9.54594,-9.54594, 4.75087,-14.34101
135.00000, 10.79956,4.08081, 9.54594,-9.54594, 4.75087,-14.34101
135.00000, 10.11830,3.39955, 9.54594,-9.54594, 9.50175,-9.59014
45.00000, 3.39955,3.39955, 9.54594,9.54594, 9.50175,-9.59014
45.00000, 12.51786,12.51786, 9.54594,9.54594, 2.71478,-16.37710
135.00000, 14.43750,12.51786, 9.54594,-9.54594, 2.71478,-16.37710
180.00000, 5.79911,12.51786, 0.00000,13.50000, 4.79911,-8.70089
180.00000, 4.13190,11.55804, 0.00000,13.50000, 3.13190,-10.36810
180.00000, 3.17208,10.59821, 0.00000,13.50000, 2.17208,-11.32792
180.00000, 2.21226,9.63839, 0.00000,13.50000, 1.21226,-12.28774
180.00000, 1.25244,8.67857, 0.00000,13.50000, 0.25244,-13.24756
270.00000, 4.83929,1.25244, 0.00000,13.50000, 0.25244,-13.24756
270.00000, 3.87946,2.21226, 0.00000,13.50000, 1.21226,-12.28774
270.00000, 2.91964,3.17208, 0.00000,13.50000, 2.17208,-11.32792
270.00000, 1.95982,4.13190, 0.00000,13.50000, 3.13190,-10.36810
180.00000, 5.79911,1.00000, 0.00000,13.50000, 4.79911,-8.70089
270.00000, 12.51786,5.79911, 0.00000,13.50000, 4.79911,-8.70089
180.00000, 12.51786,1.00000, 0.00000,13.50000, 4.79911,-8.70089
180.00000, 12.51786,1.95982, 0.00000,13.50000, 3.13190,-10.36810
180.00000, 12.51786,2.91964, 0.00000,13.50000, 2.17208,-11.32792
180.00000, 12.51786,3.87946, 0.00000,13.50000, 1.21226,-12.28774
180.00000, 12.51786,4.83929, 0.00000,13.50000, 0.25244,-13.24756
180.00000, 12.51786,12.51786, 0.00000,13.50000, 4.79911,-8.70089
270.00000, 8.67857,12.51786, 0.00000,13.50000, 0.25244,-13.24756
270.00000, 9.63839,12.51786, 0.00000,13.50000, 1.21226,-12.28774
270.00000, 10.59821,12.51786, 0.00000,13.50000, 2.17208,-11.32792
270.00000, 11.55804,12.51786, 0.00000,13.50000, 3.13190,-10.36810
270.00000, 12.51786,12.51786, 0.00000,13.50000, 4.79911,-8.70089
270.00000, 13.47768,13.47768, 0.00000,13.50000, 13.43750,-0.06250
180.00000, 13.47768,13.47768, 0.00000,13.50000, 13.43750,-0.06250
270.00000, 1.00000,12.51786, 0.00000,13.50000, 4.79911,-8.70089
270.00000, 1.00000,5.79911, 0.00000,13.50000, 4.79911,-8.70089
45.00000, 4.71516,8.80270, 9.54594,9.54594, 4.75087,-14.34101
135.00000, 12.51786,8.42613, 9.54594,-9.54594, 5.78657,-13.30531
45.00000, 1.00000,8.42613, 9.54594,9.54594, 5.78657,-13.30531
135.00000, 5.09173,1.00000, 9.54594,-9.54594, 5.78657,-13.30531
45.00000, 8.42613,1.00000, 9.54594,9.54594, 5.78657,-13.30531
*WDFLR03,temp
;%TYPE=MODEL
0.00000, 0.00000,-2.25000, 0.00000,2.25000
270.00000, 0.00000,0.00000, 0.00000,2.25000
*WDFLR04,temp
;%TYPE=MODEL
0.00000, 0.00000,0.00000, 0.00000,14.25000
90.00000, 14.25000,0.00000, 0.00000,14.25000
90.00000, 7.12500,0.00000, 0.00000,14.25000
0.00000, 0.00000,7.12500, 0.00000,14.25000
90.00000, 0.79170,7.12500, 0.00000,14.25000, 4.74990,-9.50010
90.00000, 1.58340,7.12500, 0.00000,14.25000, 4.74990,-9.50010
90.00000, 2.37510,7.12500, 0.00000,14.25000, 4.74990,-9.50010
90.00000, 3.16680,9.50010, 0.00000,14.25000, 2.37480,-11.87520
90.00000, 3.95850,9.50010, 0.00000,14.25000, 2.37480,-11.87520
90.00000, 4.75020,9.50010, 0.00000,14.25000, 4.74990,-9.50010
90.00000, 5.54190,9.50010, 0.00000,14.25000, 4.74990,-9.50010
90.00000, 6.33360,9.50010, 0.00000,14.25000, 4.74990,-9.50010
0.00000, 0.00000,13.45830, 0.00000,14.25000, 4.75020,-9.49980
0.00000, 0.00000,12.66660, 0.00000,14.25000, 4.75020,-9.49980
0.00000, 0.00000,11.87490, 0.00000,14.25000, 4.75020,-9.49980
0.00000, 2.37510,7.91670, 0.00000,14.25000, 4.74990,-9.50010
0.00000, 2.37510,8.70840, 0.00000,14.25000, 4.74990,-9.50010
0.00000, 2.37510,9.50010, 0.00000,14.25000, 4.74990,-9.50010
0.00000, 9.50010,2.37510, 0.00000,14.25000, 4.74990,-9.50010
0.00000, 9.50010,1.58340, 0.00000,14.25000, 4.74990,-9.50010
0.00000, 9.50010,0.79170, 0.00000,14.25000, 4.74990,-9.50010
0.00000, 7.12500,4.74990, 0.00000,14.25000, 4.75020,-9.49980
0.00000, 7.12500,5.54160, 0.00000,14.25000, 4.75020,-9.49980
0.00000, 7.12500,6.33330, 0.00000,14.25000, 4.75020,-9.49980
90.00000, 12.66690,2.37510, 0.00000,14.25000, 4.74990,-9.50010
90.00000, 11.87520,2.37510, 0.00000,14.25000, 4.74990,-9.50010
90.00000, 11.08350,2.37510, 0.00000,14.25000, 2.37480,-11.87520
90.00000, 10.29180,2.37510, 0.00000,14.25000, 2.37480,-11.87520
90.00000, 9.50010,0.00000, 0.00000,14.25000, 4.74990,-9.50010
90.00000, 8.70840,0.00000, 0.00000,14.25000, 4.74990,-9.50010
90.00000, 7.91670,0.00000, 0.00000,14.25000, 4.74990,-9.50010
90.00000, 13.45860,2.37510, 0.00000,14.25000, 4.74990,-9.50010
90.00000, 13.45860,9.50010, 0.00000,14.25000, 4.74990,-9.50010
90.00000, 7.91670,7.12500, 0.00000,14.25000, 4.74990,-9.50010
90.00000, 8.70840,7.12500, 0.00000,14.25000, 4.74990,-9.50010
90.00000, 9.50010,7.12500, 0.00000,14.25000, 4.74990,-9.50010
90.00000, 11.87520,9.50010, 0.00000,14.25000, 4.74990,-9.50010
90.00000, 12.66690,9.50010, 0.00000,14.25000, 4.74990,-9.50010
0.00000, 7.12500,13.45830, 0.00000,14.25000, 4.75020,-9.49980
0.00000, 7.12500,12.66660, 0.00000,14.25000, 4.75020,-9.49980
0.00000, 7.12500,11.87490, 0.00000,14.25000, 4.75020,-9.49980
0.00000, 9.50010,7.91670, 0.00000,14.25000, 4.74990,-9.50010
0.00000, 9.50010,8.70840, 0.00000,14.25000, 4.74990,-9.50010
0.00000, 9.50010,9.50010, 0.00000,14.25000, 4.74990,-9.50010
0.00000, 9.50010,11.08320, 0.00000,14.25000, 2.37510,-11.87490
0.00000, 9.50010,10.29150, 0.00000,14.25000, 2.37510,-11.87490
0.00000, 2.37510,3.16650, 0.00000,14.25000, 2.37510,-11.87490
0.00000, 2.37510,3.95820, 0.00000,14.25000, 2.37510,-11.87490
0.00000, 2.37510,2.37510, 0.00000,14.25000, 4.74990,-9.50010
0.00000, 2.37510,1.58340, 0.00000,14.25000, 4.74990,-9.50010
0.00000, 2.37510,0.79170, 0.00000,14.25000, 4.74990,-9.50010
0.00000, 0.00000,4.74990, 0.00000,14.25000, 4.75020,-9.49980
0.00000, 0.00000,5.54160, 0.00000,14.25000, 4.75020,-9.49980
0.00000, 0.00000,6.33330, 0.00000,14.25000, 4.75020,-9.49980
90.00000, 5.54190,2.37510, 0.00000,14.25000, 4.74990,-9.50010
90.00000, 4.75020,2.37510, 0.00000,14.25000, 4.74990,-9.50010
90.00000, 2.37510,0.00000, 0.00000,14.25000, 4.74990,-9.50010
90.00000, 1.58340,0.00000, 0.00000,14.25000, 4.74990,-9.50010
90.00000, 0.79170,0.00000, 0.00000,14.25000, 4.74990,-9.50010
90.00000, 6.33360,2.37510, 0.00000,14.25000, 4.74990,-9.50010
*WDFLR05,Monticello pattern
;%TYPE=MODEL
45.00000, -0.94643,5.67857, 9.36916,9.36916, 2.67690,-16.06143
135.00000, 0.94643,5.67857, 9.36916,-9.36916, 2.67690,-16.06143
45.00000, 5.67857,12.30357, 9.36916,9.36916, 2.67690,-16.06143
135.00000, 7.57143,12.30357, 9.36916,-9.36916, 2.67690,-16.06143
135.00000, 0.94643,12.30357, 9.36916,-9.36916, 2.67690,-16.06143
45.00000, -0.94643,12.30357, 9.36916,9.36916, 2.67690,-16.06143
0.00000, 7.57143,12.30357, 0.00000,13.25000, 4.73214,-8.51786
0.00000, 7.57143,11.35714, 0.00000,13.25000, 4.73214,-8.51786
0.00000, 7.57143,10.41071, 0.00000,13.25000, 4.73214,-8.51786
0.00000, 7.57143,9.46429, 0.00000,13.25000, 4.73214,-8.51786
0.00000, 7.57143,8.51786, 0.00000,13.25000, 4.73214,-8.51786
180.00000, 12.30357,7.57143, 0.00000,-13.25000, 4.73214,-8.51786
270.00000, 7.57143,12.30357, 0.00000,13.25000, 4.73214,-8.51786
270.00000, 7.57143,5.67857, 0.00000,13.25000, 4.73214,-8.51786
270.00000, 8.51786,5.67857, 0.00000,13.25000, 4.73214,-8.51786
270.00000, 9.46429,5.67857, 0.00000,13.25000, 4.73214,-8.51786
270.00000, 10.41071,5.67857, 0.00000,13.25000, 4.73214,-8.51786
270.00000, 11.35714,5.67857, 0.00000,13.25000, 4.73214,-8.51786
0.00000, 7.57143,5.67857, 0.00000,13.25000, 4.73214,-8.51786
0.00000, 7.57143,0.94643, 0.00000,13.25000, 4.73214,-8.51786
45.00000, 5.67857,5.67857, 9.36916,9.36916, 2.67690,-16.06143
135.00000, 7.57143,5.67857, 9.36916,-9.36916, 2.67690,-16.06143
270.00000, 0.94643,5.67857, 0.00000,13.25000, 4.73214,-8.51786
270.00000, 5.67857,5.67857, 0.00000,13.25000, 4.73214,-8.51786
180.00000, 5.67857,0.94643, 0.00000,-13.25000, 4.73214,-8.51786
0.00000, 0.94643,1.89286, 0.00000,13.25000, 4.73214,-8.51786
0.00000, 0.94643,2.83929, 0.00000,13.25000, 4.73214,-8.51786
0.00000, 0.94643,3.78571, 0.00000,13.25000, 4.73214,-8.51786
0.00000, 0.94643,4.73214, 0.00000,13.25000, 4.73214,-8.51786
180.00000, 5.67857,5.67857, 0.00000,-13.25000, 4.73214,-8.51786
0.00000, 0.94643,7.57143, 0.00000,13.25000, 4.73214,-8.51786
0.00000, 0.94643,12.30357, 0.00000,13.25000, 4.73214,-8.51786
270.00000, 5.67857,12.30357, 0.00000,13.25000, 4.73214,-8.51786
270.00000, 4.73214,12.30357, 0.00000,13.25000, 4.73214,-8.51786
270.00000, 3.78571,12.30357, 0.00000,13.25000, 4.73214,-8.51786
270.00000, 2.83929,12.30357, 0.00000,13.25000, 4.73214,-8.51786
270.00000, 1.89286,12.30357, 0.00000,13.25000, 4.73214,-8.51786
270.00000, 0.94643,12.30357, 0.00000,13.25000, 4.73214,-8.51786
270.00000, 0.00000,13.25000, 0.00000,13.25000
0.00000, 0.00000,13.25000, 0.00000,13.25000
270.00000, 6.62500,13.25000, 0.00000,13.25000
0.00000, 0.00000,6.62500, 0.00000,13.25000
270.00000, 12.30357,12.30357, 0.00000,13.25000, 4.73214,-8.51786
270.00000, 12.30357,5.67857, 0.00000,13.25000, 4.73214,-8.51786
*WDFLR06,temp
;%TYPE=MODEL
270.00000, 1.58000,9.50000, 0.00000,1.58000
180.00000, 1.58000,0.00000, 0.00000,9.50000
*WDFLR07,Saxony
;%TYPE=MODEL
135.00000, 17.64286,9.50000, 13.43503,-13.43503, 4.79822,-22.07183
135.00000, 12.89286,14.25000, 13.43503,-13.43503, 4.79822,-22.07183
45.00000, 0.00000,-0.00000, 13.43503,13.43503, 26.87006,-0.00000
135.00000, 19.00000,-0.00000, 13.43503,-13.43503, 26.87006,-0.00000
45.00000, -0.00000,9.50000, 13.43503,13.43503, 13.43503,-13.43503
135.00000, 9.50000,-0.00000, 13.43503,-13.43503, 13.43503,-13.43503
135.00000, 4.75000,6.10714, 13.43503,-13.43503, 4.79822,-22.07183
135.00000, 5.42857,6.78571, 13.43503,-13.43503, 4.79822,-22.07183
135.00000, 6.10714,7.46429, 13.43503,-13.43503, 4.79822,-22.07183
135.00000, 6.78571,8.14286, 13.43503,-13.43503, 4.79822,-22.07183
135.00000, 7.46429,8.82143, 13.43503,-13.43503, 4.79822,-22.07183
135.00000, 8.14286,9.50000, 13.43503,-13.43503, 4.79822,-22.07183
45.00000, 1.35714,9.50000, 13.43503,13.43503, 4.79822,-22.07183
45.00000, 4.75000,6.10714, 13.43503,13.43503, 4.79822,-22.07183
45.00000, 6.10714,4.75000, 13.43503,13.43503, 4.79822,-22.07183
45.00000, 6.78571,4.07143, 13.43503,13.43503, 4.79822,-22.07183
45.00000, 7.46429,3.39286, 13.43503,13.43503, 4.79822,-22.07183
45.00000, 8.14286,2.71429, 13.43503,13.43503, 4.79822,-22.07183
45.00000, 8.82143,2.03571, 13.43503,13.43503, 4.79822,-22.07183
45.00000, 9.50000,1.35714, 13.43503,13.43503, 4.79822,-22.07183
135.00000, 12.89286,4.75000, 13.43503,-13.43503, 4.79822,-22.07183
135.00000, 9.50000,1.35714, 13.43503,-13.43503, 4.79822,-22.07183
180.00000, 10.85714,9.50000, 0.00000,-19.00000, 2.71429,-16.28571
270.00000, 9.50000,10.85714, 0.00000,19.00000, 2.71429,-16.28571
45.00000, 14.25000,6.10714, 13.43503,13.43503, 4.79822,-22.07183
45.00000, 10.85714,9.50000, 13.43503,13.43503, 4.79822,-22.07183
135.00000, 16.96429,8.82143, 13.43503,-13.43503, 4.79822,-22.07183
135.00000, 16.28571,8.14286, 13.43503,-13.43503, 4.79822,-22.07183
135.00000, 15.60714,7.46429, 13.43503,-13.43503, 4.79822,-22.07183
135.00000, 14.92857,6.78571, 13.43503,-13.43503, 4.79822,-22.07183
135.00000, 14.25000,6.10714, 13.43503,-13.43503, 4.79822,-22.07183
135.00000, 9.50000,10.85714, 13.43503,-13.43503, 4.79822,-22.07183
45.00000, 9.50000,10.85714, 13.43503,13.43503, 4.79822,-22.07183
45.00000, 8.82143,11.53571, 13.43503,13.43503, 4.79822,-22.07183
45.00000, 8.14286,12.21429, 13.43503,13.43503, 4.79822,-22.07183
45.00000, 7.46429,12.89286, 13.43503,13.43503, 4.79822,-22.07183
45.00000, 6.78571,13.57143, 13.43503,13.43503, 4.79822,-22.07183
45.00000, 6.10714,14.25000, 13.43503,13.43503, 4.79822,-22.07183
270.00000, -0.00000,19.00000, 0.00000,19.00000, 19.00000,-0.00000
180.00000, 6.10714,14.25000, 0.00000,-19.00000, 2.71429,-16.28571
270.00000, 4.75000,15.60714, 0.00000,19.00000, 2.71429,-16.28571
180.00000, 6.10714,4.75000, 0.00000,-19.00000, 2.71429,-16.28571
270.00000, 4.75000,6.10714, 0.00000,19.00000, 2.71429,-16.28571
45.00000, 9.50000,-0.00000, 13.43503,13.43503, 13.43503,-13.43503
135.00000, 19.00000,9.50000, 13.43503,-13.43503, 13.43503,-13.43503
180.00000, 19.00000,19.00000, 0.00000,19.00000, 19.00000,-0.00000
0.00000, 12.89286,14.25000, 0.00000,19.00000, 2.71429,-16.28571
270.00000, 14.25000,15.60714, 0.00000,19.00000, 2.71429,-16.28571
135.00000, 19.00000,10.85714, 13.43503,-13.43503, 4.79822,-22.07183
45.00000, -0.00000,10.85714, 13.43503,13.43503, 4.79822,-22.07183
135.00000, 3.39286,4.75000, 13.43503,-13.43503, 4.79822,-22.07183
45.00000, 15.60714,4.75000, 13.43503,13.43503, 4.79822,-22.07183
180.00000, 15.60714,4.75000, 0.00000,-19.00000, 2.71429,-16.28571
270.00000, 14.25000,6.10714, 0.00000,19.00000, 2.71429,-16.28571
135.00000, 4.75000,15.60714, 13.43503,-13.43503, 4.79822,-22.07183
135.00000, 3.39286,14.25000, 13.43503,-13.43503, 4.79822,-22.07183
45.00000, 1.35714,-0.00000, 13.43503,13.43503, 4.79822,-22.07183
45.00000, -0.00000,1.35714, 13.43503,13.43503, 4.79822,-22.07183
135.00000, 19.00000,1.35714, 13.43503,-13.43503, 4.79822,-22.07183
135.00000, 17.64286,-0.00000, 13.43503,-13.43503, 4.79822,-22.07183
45.00000, 15.60714,14.25000, 13.43503,13.43503, 4.79822,-22.07183
45.00000, 14.25000,15.60714, 13.43503,13.43503, 4.79822,-22.07183
45.00000, 10.85714,-0.00000, 13.43503,13.43503, 4.79822,-22.07183
135.00000, 14.25000,15.60714, 13.43503,-13.43503, 4.79822,-22.07183
45.00000, 4.75000,15.60714, 13.43503,13.43503, 4.79822,-22.07183
135.00000, 8.14286,-0.00000, 13.43503,-13.43503, 4.79822,-22.07183
90.00000, 18.23953,2.11762, 0.00000,19.00000, 5.26477,-13.73523
180.00000, 16.88238,18.23953, 0.00000,19.00000, 5.26477,-13.73523
270.00000, 0.76047,16.88238, 0.00000,19.00000, 5.26477,-13.73523
0.00000, 2.11762,0.76047, 0.00000,19.00000, 5.26477,-13.73523
180.00000, 7.38238,18.23953, 0.00000,19.00000, 5.26477,-13.73523
270.00000, 0.76047,7.38238, 0.00000,19.00000, 5.26477,-13.73523
0.00000, 11.61762,0.76047, 0.00000,19.00000, 5.26477,-13.73523
90.00000, 18.23953,11.61762, 0.00000,19.00000, 5.26477,-13.73523
135.00000, 14.92857,16.28571, 13.43503,-13.43503, 2.76311,-24.10695
135.00000, 15.60714,16.96429, 13.43503,-13.43503, 1.80346,-25.06659
135.00000, 16.28571,17.64286, 13.43503,-13.43503, 0.84382,-26.02624
45.00000, 16.28571,13.57143, 13.43503,13.43503, 2.76311,-24.10695
45.00000, 16.96429,12.89286, 13.43503,13.43503, 1.80346,-25.06659
45.00000, 17.64286,12.21429, 13.43503,13.43503, 0.84382,-26.02624
45.00000, 16.28571,4.07143, 13.43503,13.43503, 2.76311,-24.10695
45.00000, 16.96429,3.39286, 13.43503,13.43503, 1.80346,-25.06659
45.00000, 17.64286,2.71429, 13.43503,13.43503, 0.84382,-26.02624
135.00000, 15.52524,0.76047, 13.43503,-13.43503, 2.76311,-24.10695
135.00000, 14.16810,0.76047, 13.43503,-13.43503, 1.80346,-25.06659
135.00000, 12.81096,0.76047, 13.43503,-13.43503, 0.84382,-26.02624
135.00000, 6.02524,0.76047, 13.43503,-13.43503, 2.76311,-24.10695
135.00000, 4.66810,0.76047, 13.43503,-13.43503, 1.80346,-25.06659
135.00000, 3.31096,0.76047, 13.43503,-13.43503, 0.84382,-26.02624
45.00000, 0.76047,3.47476, 13.43503,13.43503, 2.76311,-24.10695
45.00000, 0.76047,4.83190, 13.43503,13.43503, 1.80346,-25.06659
45.00000, 0.76047,6.18904, 13.43503,13.43503, 0.84382,-26.02624
45.00000, 0.76047,12.97476, 13.43503,13.43503, 2.76311,-24.10695
45.00000, 0.76047,14.33190, 13.43503,13.43503, 1.80346,-25.06659
45.00000, 0.76047,15.68904, 13.43503,13.43503, 0.84382,-26.02624
135.00000, 5.42857,16.28571, 13.43503,-13.43503, 2.76311,-24.10695
135.00000, 6.10714,16.96429, 13.43503,-13.43503, 1.80346,-25.06659
135.00000, 6.78571,17.64286, 13.43503,-13.43503, 0.84382,-26.02624
*WDFLR08,temp
;%TYPE=MODEL
180.00000, 9.50000,0.95000, 0.00000,9.50000, 4.75000,-4.75000
180.00000, 9.50000,1.90000, 0.00000,9.50000, 4.75000,-4.75000
180.00000, 9.50000,2.85000, 0.00000,9.50000, 4.75000,-4.75000
180.00000, 9.50000,3.80000, 0.00000,9.50000, 4.75000,-4.75000
90.00000, 3.80000,0.00000, 0.00000,9.50000, 4.75000,-4.75000
90.00000, 2.85000,0.00000, 0.00000,9.50000, 4.75000,-4.75000
90.00000, 1.90000,0.00000, 0.00000,9.50000, 4.75000,-4.75000
90.00000, 0.95000,0.00000, 0.00000,9.50000, 4.75000,-4.75000
90.00000, 8.55000,4.75000, 0.00000,9.50000, 4.75000,-4.75000
90.00000, 7.60000,4.75000, 0.00000,9.50000, 4.75000,-4.75000
90.00000, 6.65000,4.75000, 0.00000,9.50000, 4.75000,-4.75000
90.00000, 5.70000,4.75000, 0.00000,9.50000, 4.75000,-4.75000
180.00000, 4.75000,8.55000, 0.00000,9.50000, 4.75000,-4.75000
180.00000, 4.75000,7.60000, 0.00000,9.50000, 4.75000,-4.75000
180.00000, 4.75000,6.65000, 0.00000,9.50000, 4.75000,-4.75000
180.00000, 4.75000,5.70000, 0.00000,9.50000, 4.75000,-4.75000
180.00000, 9.50000,4.75000, 0.00000,9.50000
90.00000, 4.75000,0.00000, 0.00000,9.50000
180.00000, 9.50000,0.00000, 0.00000,9.50000
270.00000, 9.50000,9.50000, 0.00000,9.50000
*WDFLR09,temp
;%TYPE=MODEL
180.00000, 11.00000,0.00000, 0.00000,11.00000
270.00000, 11.00000,11.00000, 0.00000,11.00000
90.00000, 5.50000,0.00000, 0.00000,11.00000
180.00000, 11.00000,5.50000, 0.00000,11.00000
180.00000, 5.50000,6.60000, 0.00000,11.00000, 5.50000,-5.50000
180.00000, 5.50000,7.70000, 0.00000,11.00000, 5.50000,-5.50000
180.00000, 5.50000,8.80000, 0.00000,11.00000, 5.50000,-5.50000
180.00000, 5.50000,9.90000, 0.00000,11.00000, 5.50000,-5.50000
90.00000, 6.60000,5.50000, 0.00000,11.00000, 5.50000,-5.50000
90.00000, 7.70000,5.50000, 0.00000,11.00000, 5.50000,-5.50000
90.00000, 8.80000,5.50000, 0.00000,11.00000, 5.50000,-5.50000
90.00000, 9.90000,5.50000, 0.00000,11.00000, 5.50000,-5.50000
90.00000, 1.10000,0.00000, 0.00000,11.00000, 5.50000,-5.50000
90.00000, 2.20000,0.00000, 0.00000,11.00000, 5.50000,-5.50000
90.00000, 3.30000,0.00000, 0.00000,11.00000, 5.50000,-5.50000
90.00000, 4.40000,0.00000, 0.00000,11.00000, 5.50000,-5.50000
180.00000, 11.00000,4.40000, 0.00000,11.00000, 5.50000,-5.50000
180.00000, 11.00000,3.30000, 0.00000,11.00000, 5.50000,-5.50000
180.00000, 11.00000,2.20000, 0.00000,11.00000, 5.50000,-5.50000
180.00000, 11.00000,1.10000, 0.00000,11.00000, 5.50000,-5.50000
*WDFLR10,temp
;%TYPE=MODEL
90.00000, 0.91670,0.00000, 0.00000,0.91670
0.00000, 0.00000,0.00000, 0.00000,5.50000
*WDFLR11,temp
;%TYPE=MODEL
45.00000, 6.44975,1.50000, 10.07627,10.07627, 0.95495,-19.19759
45.00000, 5.74264,1.50000, 10.07627,10.07627, 1.95495,-18.19759
45.00000, 5.03553,1.50000, 10.07627,10.07627, 2.95495,-17.19759
45.00000, 4.32843,1.50000, 10.07627,10.07627, 3.95495,-16.19759
45.00000, 3.62132,1.50000, 10.07627,10.07627, 4.95495,-15.19759
45.00000, 2.91421,1.50000, 10.07627,10.07627, 5.95495,-14.19759
45.00000, 2.20711,1.50000, 10.07627,10.07627, 6.95495,-13.19759
45.00000, 1.50000,6.44975, 10.07627,10.07627, 0.95495,-19.19759
45.00000, 1.50000,5.74264, 10.07627,10.07627, 1.95495,-18.19759
45.00000, 1.50000,5.03553, 10.07627,10.07627, 2.95495,-17.19759
45.00000, 1.50000,4.32843, 10.07627,10.07627, 3.95495,-16.19759
45.00000, 1.50000,3.62132, 10.07627,10.07627, 4.95495,-15.19759
45.00000, 1.50000,2.91421, 10.07627,10.07627, 5.95495,-14.19759
45.00000, 1.50000,2.20711, 10.07627,10.07627, 6.95495,-13.19759
45.00000, 1.50000,1.50000, 10.07627,10.07627, 15.90990,-4.24264
45.00000, 7.83211,7.12500, 10.07627,10.07627, 6.95495,-13.19759
45.00000, 8.53921,7.12500, 10.07627,10.07627, 5.95495,-14.19759
45.00000, 9.24632,7.12500, 10.07627,10.07627, 4.95495,-15.19759
45.00000, 9.95343,7.12500, 10.07627,10.07627, 3.95495,-16.19759
45.00000, 10.66053,7.12500, 10.07627,10.07627, 2.95495,-17.19759
45.00000, 11.36764,7.12500, 10.07627,10.07627, 1.95495,-18.19759
45.00000, 12.07475,7.12500, 10.07627,10.07627, 0.95495,-19.19759
45.00000, 7.12500,7.83211, 10.07627,10.07627, 6.95495,-13.19759
45.00000, 7.12500,8.53921, 10.07627,10.07627, 5.95495,-14.19759
45.00000, 7.12500,9.24632, 10.07627,10.07627, 4.95495,-15.19759
45.00000, 7.12500,9.95343, 10.07627,10.07627, 3.95495,-16.19759
45.00000, 7.12500,10.66053, 10.07627,10.07627, 2.95495,-17.19759
45.00000, 7.12500,11.36764, 10.07627,10.07627, 1.95495,-18.19759
45.00000, 7.12500,12.07475, 10.07627,10.07627, 0.95495,-19.19759
135.00000, 6.41789,7.12500, 10.07627,-10.07627, 6.95495,-13.19759
135.00000, 5.71079,7.12500, 10.07627,-10.07627, 5.95495,-14.19759
135.00000, 5.00368,7.12500, 10.07627,-10.07627, 4.95495,-15.19759
135.00000, 4.29657,7.12500, 10.07627,-10.07627, 3.95495,-16.19759
135.00000, 3.58947,7.12500, 10.07627,-10.07627, 2.95495,-17.19759
135.00000, 2.88236,7.12500, 10.07627,-10.07627, 1.95495,-18.19759
135.00000, 2.17525,7.12500, 10.07627,-10.07627, 0.95495,-19.19759
135.00000, 7.12500,7.83211, 10.07627,-10.07627, 6.95495,-13.19759
135.00000, 7.12500,8.53921, 10.07627,-10.07627, 5.95495,-14.19759
135.00000, 7.12500,9.24632, 10.07627,-10.07627, 4.95495,-15.19759
135.00000, 7.12500,9.95343, 10.07627,-10.07627, 3.95495,-16.19759
135.00000, 7.12500,10.66053, 10.07627,-10.07627, 2.95495,-17.19759
135.00000, 7.12500,11.36764, 10.07627,-10.07627, 1.95495,-18.19759
135.00000, 7.12500,12.07475, 10.07627,-10.07627, 0.95495,-19.19759
135.00000, 7.80025,1.50000, 10.07627,-10.07627, 0.95495,-19.19759
135.00000, 8.50736,1.50000, 10.07627,-10.07627, 1.95495,-18.19759
135.00000, 9.21447,1.50000, 10.07627,-10.07627, 2.95495,-17.19759
135.00000, 9.92157,1.50000, 10.07627,-10.07627, 3.95495,-16.19759
135.00000, 10.62868,1.50000, 10.07627,-10.07627, 4.95495,-15.19759
135.00000, 11.33579,1.50000, 10.07627,-10.07627, 5.95495,-14.19759
135.00000, 12.04289,1.50000, 10.07627,-10.07627, 6.95495,-13.19759
135.00000, 12.75000,6.44975, 10.07627,-10.07627, 0.95495,-19.19759
135.00000, 12.75000,5.74264, 10.07627,-10.07627, 1.95495,-18.19759
135.00000, 12.75000,5.03553, 10.07627,-10.07627, 2.95495,-17.19759
135.00000, 12.75000,4.32843, 10.07627,-10.07627, 3.95495,-16.19759
135.00000, 12.75000,3.62132, 10.07627,-10.07627, 4.95495,-15.19759
135.00000, 12.75000,2.91421, 10.07627,-10.07627, 5.95495,-14.19759
135.00000, 12.75000,2.20711, 10.07627,-10.07627, 6.95495,-13.19759
135.00000, 12.75000,1.50000, 10.07627,-10.07627, 15.90990,-4.24264
0.00000, 1.50000,7.12500, 0.00000,14.25000, 11.25000,-3.00000
90.00000, 7.12500,1.50000, 0.00000,14.25000, 11.25000,-3.00000
0.00000, 1.50000,1.50000, 0.00000,14.25000, 11.75000,-2.50000
0.00000, 1.00000,1.00000, 0.00000,14.25000, 12.75000,-1.50000
0.00000, 0.50000,0.50000, 0.00000,14.25000, 13.75000,-0.50000
270.00000, 1.50000,12.75000, 0.00000,14.25000, 11.75000,-2.50000
270.00000, 1.00000,13.25000, 0.00000,14.25000, 12.75000,-1.50000
270.00000, 0.50000,13.75000, 0.00000,14.25000, 13.75000,-0.50000
180.00000, 12.75000,12.75000, 0.00000,14.25000, 11.75000,-2.50000
180.00000, 13.25000,13.25000, 0.00000,14.25000, 12.75000,-1.50000
180.00000, 13.75000,13.75000, 0.00000,14.25000, 13.75000,-0.50000
90.00000, 12.75000,1.50000, 0.00000,14.25000, 11.75000,-2.50000
90.00000, 13.25000,1.00000, 0.00000,14.25000, 12.75000,-1.50000
90.00000, 13.75000,0.50000, 0.00000,14.25000, 13.75000,-0.50000
90.00000, 14.25000,0.00000, 0.00000,14.25000
0.00000, 0.00000,0.00000, 0.00000,14.25000
*WOOD00,temp
180.00000, 0.00000,-12.00000, 0.00000,12.00000
90.00000, -12.00000,-12.00000, 0.00000,12.00000
270.00000, -6.00000,0.00000, 0.00000,12.00000
0.00000, -12.00000,-6.00000, 0.00000,12.00000
135.00000, -5.20417,-6.00000, 8.48528,-8.48528, 1.12548,-15.84509
135.00000, -3.78995,-6.00000, 8.48528,-8.48528, 3.12548,-13.84509
135.00000, -3.50711,-6.00000, 8.48528,-8.48528, 3.52548,-13.44509
135.00000, -2.09290,-6.00000, 8.48528,-8.48528, 5.52548,-11.44509
135.00000, -0.39584,-6.00000, 8.48528,-8.48528, 7.92548,-9.04509
135.00000, -1.81006,-6.00000, 8.48528,-8.48528, 5.92548,-11.04509
135.00000, 0.00000,-4.41594, 8.48528,-8.48528, 6.24509,-10.72548
135.00000, 0.00000,-3.00173, 8.48528,-8.48528, 4.24509,-12.72548
135.00000, 0.00000,-4.69879, 8.48528,-8.48528, 6.64509,-10.32548
135.00000, -0.11300,-6.00000, 8.48528,-8.48528, 8.32548,-8.64509
135.00000, 0.00000,-1.30467, 8.48528,-8.48528, 1.84509,-15.12548
135.00000, 0.00000,-1.02183, 8.48528,-8.48528, 1.44509,-15.52548
135.00000, 0.00000,-2.71889, 8.48528,-8.48528, 3.84509,-13.12548
135.00000, -5.48701,-6.00000, 8.48528,-8.48528, 0.72548,-16.24509
45.00000, -6.51299,-6.00000, 8.48528,8.48528, 0.72548,-16.24509
45.00000, -6.79583,-6.00000, 8.48528,8.48528, 1.12548,-15.84509
45.00000, -12.00000,-2.71889, 8.48528,8.48528, 3.84509,-13.12548
45.00000, -12.00000,-1.02183, 8.48528,8.48528, 1.44509,-15.52548
45.00000, -12.00000,-1.30467, 8.48528,8.48528, 1.84509,-15.12548
45.00000, -11.88700,-6.00000, 8.48528,8.48528, 8.32548,-8.64509
45.00000, -12.00000,-4.69879, 8.48528,8.48528, 6.64509,-10.32548
45.00000, -12.00000,-3.00173, 8.48528,8.48528, 4.24509,-12.72548
45.00000, -12.00000,-4.41594, 8.48528,8.48528, 6.24509,-10.72548
45.00000, -10.18994,-6.00000, 8.48528,8.48528, 5.92548,-11.04509
45.00000, -11.60416,-6.00000, 8.48528,8.48528, 7.92548,-9.04509
45.00000, -9.90710,-6.00000, 8.48528,8.48528, 5.52548,-11.44509
45.00000, -8.49289,-6.00000, 8.48528,8.48528, 3.52548,-13.44509
45.00000, -8.21005,-6.00000, 8.48528,8.48528, 3.12548,-13.84509
45.00000, -6.00000,-6.51299, 8.48528,8.48528, 0.72548,-16.24509
45.00000, -2.71889,-12.00000, 8.48528,8.48528, 3.84509,-13.12548
45.00000, -1.02183,-12.00000, 8.48528,8.48528, 1.44509,-15.52548
45.00000, -1.30467,-12.00000, 8.48528,8.48528, 1.84509,-15.12548
45.00000, -6.00000,-11.88700, 8.48528,8.48528, 8.32548,-8.64509
45.00000, -4.69879,-12.00000, 8.48528,8.48528, 6.64509,-10.32548
45.00000, -3.00173,-12.00000, 8.48528,8.48528, 4.24509,-12.72548
45.00000, -4.41594,-12.00000, 8.48528,8.48528, 6.24509,-10.72548
45.00000, -6.00000,-10.18994, 8.48528,8.48528, 5.92548,-11.04509
45.00000, -6.00000,-11.60416, 8.48528,8.48528, 7.92548,-9.04509
45.00000, -6.00000,-9.90710, 8.48528,8.48528, 5.52548,-11.44509
45.00000, -6.00000,-8.49289, 8.48528,8.48528, 3.52548,-13.44509
45.00000, -6.00000,-8.21005, 8.48528,8.48528, 3.12548,-13.84509
45.00000, -6.00000,-6.79583, 8.48528,8.48528, 1.12548,-15.84509
135.00000, -6.00000,-8.21005, 8.48528,-8.48528, 3.12548,-13.84509
135.00000, -6.00000,-8.49289, 8.48528,-8.48528, 3.52548,-13.44509
135.00000, -6.00000,-9.90710, 8.48528,-8.48528, 5.52548,-11.44509
135.00000, -6.00000,-11.60416, 8.48528,-8.48528, 7.92548,-9.04509
135.00000, -6.00000,-10.18994, 8.48528,-8.48528, 5.92548,-11.04509
135.00000, -7.58406,-12.00000, 8.48528,-8.48528, 6.24509,-10.72548
135.00000, -8.99827,-12.00000, 8.48528,-8.48528, 4.24509,-12.72548
135.00000, -7.30121,-12.00000, 8.48528,-8.48528, 6.64509,-10.32548
135.00000, -6.00000,-11.88700, 8.48528,-8.48528, 8.32548,-8.64509
135.00000, -10.69533,-12.00000, 8.48528,-8.48528, 1.84509,-15.12548
135.00000, -10.97817,-12.00000, 8.48528,-8.48528, 1.44509,-15.52548
135.00000, -9.28111,-12.00000, 8.48528,-8.48528, 3.84509,-13.12548
135.00000, -6.00000,-6.79583, 8.48528,-8.48528, 1.12548,-15.84509
135.00000, -6.00000,-6.51299, 8.48528,-8.48528, 0.72548,-16.24509
*WOOD01,hardboard
26.56505, 9.27991,0.00000, 2.23607,4.47214, 0.80509,-10.37525
26.56505, 4.27991,0.00000, 2.23607,4.47214, 0.80509,-10.37525
26.56505, 8.11715,0.00000, 2.23607,4.47214, 2.10509,-9.07525
26.56505, 3.11715,0.00000, 2.23607,4.47214, 2.10509,-9.07525
26.56505, 6.95439,0.00000, 2.23607,4.47214, 3.40509,-7.77525
26.56505, 1.95439,0.00000, 2.23607,4.47214, 3.40509,-7.77525
26.56505, 6.65833,0.43334, 2.23607,4.47214, 3.73610,-7.44424
26.56505, 1.65833,0.43334, 2.23607,4.47214, 3.73610,-7.44424
153.43495, 6.01393,2.75000, 2.23607,-4.47214, 0.76612,-10.41422
153.43495, 1.01393,2.75000, 2.23607,-4.47214, 0.76612,-10.41422
153.43495, 7.57918,4.76246, 2.23607,-4.47214, 0.53115,-10.64919
153.43495, 2.57918,4.76246, 2.23607,-4.47214, 0.53115,-10.64919
153.43495, 6.68475,2.97361, 2.23607,-4.47214, 1.88361,-9.29673
153.43495, 1.68475,2.97361, 2.23607,-4.47214, 1.88361,-9.29673
153.43495, 7.35557,4.31525, 2.23607,-4.47214, 1.53115,-9.64919
153.43495, 2.35557,4.31525, 2.23607,-4.47214, 1.53115,-9.64919
153.43495, 7.13197,3.86803, 2.23607,-4.47214, 2.38361,-8.79673
153.43495, 2.13197,3.86803, 2.23607,-4.47214, 2.38361,-8.79673
153.43495, 6.90836,3.42082, 2.23607,-4.47214, 2.13361,-9.04673
153.43495, 1.90836,3.42082, 2.23607,-4.47214, 2.13361,-9.04673
63.43495, 6.57295,2.75000, 4.47214,2.23607, 2.51558,-8.66476
63.43495, 1.57295,2.75000, 4.47214,2.23607, 2.51558,-8.66476
63.43495, 7.13197,2.75000, 4.47214,2.23607, 2.51558,-8.66476
63.43495, 2.13197,2.75000, 4.47214,2.23607, 2.51558,-8.66476
63.43495, 7.69098,2.75000, 4.47214,2.23607, 1.80902,-9.37132
63.43495, 2.69098,2.75000, 4.47214,2.23607, 1.80902,-9.37132
63.43495, 8.25000,2.75000, 4.47214,2.23607, 0.55902,-10.62132
63.43495, 3.25000,2.75000, 4.47214,2.23607, 0.55902,-10.62132
90.00000, 3.50000,2.75000, 0.00000,5.00000, 2.25000,-2.75000
90.00000, 4.00000,2.75000, 0.00000,5.00000, 2.25000,-2.75000
90.00000, 4.50000,2.75000, 0.00000,5.00000, 2.25000,-2.75000
90.00000, 5.00000,3.48941, 0.00000,5.00000, 1.51059,-3.48941
0.00000, 0.50000,2.75000, 0.00000,5.00000, 4.50000,-0.50000
0.00000, 0.75000,2.25000, 0.00000,5.00000, 3.37888,-1.62112
0.00000, 1.00000,1.75000, 0.00000,5.00000, 2.12888,-2.87112
0.00000, 1.25000,1.25000, 0.00000,5.00000, 0.87888,-4.12112
26.56505, 6.42578,0.89845, 2.23607,4.47214, 3.99610,-7.18424
26.56505, 1.42578,0.89845, 2.23607,4.47214, 3.99610,-7.18424
116.56505, 5.75697,0.00000, 4.47214,-2.23607, 1.69263,-9.48771
116.56505, 0.75697,0.00000, 4.47214,-2.23607, 1.69263,-9.48771
116.56505, 6.31598,0.00000, 4.47214,-2.23607, 2.94263,-8.23771
116.56505, 1.31598,0.00000, 4.47214,-2.23607, 2.94263,-8.23771
90.00000, 5.00000,2.75000, 0.00000,5.00000, 2.25000,-2.75000
116.56505, 6.87500,0.00000, 4.47214,-2.23607, 4.19263,-6.98771
116.56505, 1.87500,0.00000, 4.47214,-2.23607, 4.19263,-6.98771
116.56505, 5.19795,-0.00000, 4.47214,-2.23607, 0.44263,-10.73771
116.56505, 0.19795,-0.00000, 4.47214,-2.23607, 0.44263,-10.73771
*WOOD02,Horizontal siding
;%TYPE=MODEL
0.00000, 0.00000,6.00000, 0.00000,6.00000, 7.50000,-0.00000
*WOOD03,lattice
;%TYPE=MODEL
135.00000, 4.24264,0.00000, 3.00000,-3.00000, 1.50000,-4.50000
135.00000, 1.06066,1.06066, 3.00000,-3.00000, 1.50000,-4.50000
135.00000, 2.12132,2.12132, 3.00000,-3.00000, 1.50000,-4.50000
135.00000, 3.18198,3.18198, 3.00000,-3.00000, 1.50000,-4.50000
225.00000, 4.24264,2.12132, 3.00000,3.00000
225.00000, 4.24264,4.24264, 3.00000,3.00000
225.00000, 2.12132,4.24264, 3.00000,3.00000
*WOOD04,vsiding
;%TYPE=MODEL
270.00000, 6.00000,7.50000, 0.00000,6.00000
*WOOD05,plywood end
53.13010, 5.88314,0.00000, 8.70000,6.52500
53.13010, 6.25814,0.00000, 8.70000,6.52500
53.13010, 6.63314,0.00000, 8.70000,6.52500
53.13010, 1.12500,0.00000, 8.70000,6.52500
53.13010, 0.75000,0.00000, 8.70000,6.52500
53.13010, 0.37500,0.00000, 8.70000,6.52500
53.13010, 0.00000,0.00000, 8.70000,6.52500
0.00000, 0.00000,0.50000, 0.00000,0.50000
*WOOD06,plywood
180.00000, 4.00000,2.00000, 0.00000,4.00000
45.00000, 2.00000,2.00000, 2.82843,2.82843, 2.82843,-2.82843
135.00000, 4.00000,0.00000, 2.82843,-2.82843, 2.82843,-2.82843
135.00000, 2.00000,0.00000, 2.82843,-2.82843, 2.82843,-2.82843
45.00000, 0.00000,2.00000, 2.82843,2.82843, 2.82843,-2.82843
0.00000, 0.00000,0.00000, 0.00000,4.00000
*WOOD07,Woodgrain
000.00, 0.5625,0.0000, 03.2500,1.0833, 0.5000,-6.0000
000.00, 0.5625,0.5000, 03.2500,1.0833, 0.5000,-6.0000
000.00, 2.2813,0.0625, 03.2500,1.0833, 3.5625,-2.9376
000.00, 2.2813,0.4375, 03.2500,1.0833, 3.5625,-2.9376
000.00, 0.6875,0.1250, 03.2500,1.0833, 0.2500,-6.2500
000.00, 0.6875,0.3750, 03.2500,1.0833, 0.2500,-6.2500
000.00, 0.7500,0.1875, 03.2500,1.0833, 0.1250,-6.3750
000.00, 0.7500,0.3125, 03.2500,1.0833, 0.1250,-6.3750
018.43, 0.1875,0.3750, 00.6852,2.0555, 0.3953,-3.0305
018.43, 0.3125,0.2500, 00.6852,2.0555, 0.3953,-3.0305
018.43, 0.5625,0.2500, 00.6852,2.0555, 0.1976,-3.2282
018.43, 0.8750,0.1875, 00.6852,2.0555, 0.1976,-3.2282
018.43, 0.9375,0.1250, 00.6852,2.0555, 0.3953,-3.0305
018.43, 1.0625,0.0000, 00.6852,2.0555, 0.3953,-3.0305
341.57, 0.1875,0.1250, 02.7406,2.0555, 0.3953,-3.0305
341.57, 0.3125,0.2500, 02.7406,2.0555, 0.3953,-3.0305
341.57, 0.5625,0.2500, 02.7406,2.0555, 0.1976,-3.2282
341.57, 0.8750,0.3125, 02.7406,2.0555, 0.1976,-3.2282
341.57, 0.9375,0.3750, 02.7406,2.0555, 0.3953,-3.0305
341.57, 1.0625,0.5000, 02.7406,2.0555, 0.3953,-3.0305
033.69, 0.0000,0.2500, -3.3051,0.9014, 0.2253,-7.5867
033.69, 1.4375,0.1250, -3.3051,0.9014, 0.2253,-7.5867
326.31, 0.0000,0.2500, 03.3051,0.9014, 0.2253,-7.5867
326.31, 1.4375,0.3750, 03.3051,0.9014, 0.2253,-7.5867
000.00, 2.8125,0.6667, 00.0000,2.1667, 2.5000,-1.2188,1.5625,-1.2188
000.00, 3.4063,0.8750, 00.0000,2.1667, 1.3125,-1.2187,2.7500,-1.2187
000.00, 3.4063,1.7917, 00.0000,2.1667, 1.3125,-1.2187,2.7500,-1.2187
000.00, 2.8125,2.0000, 00.0000,2.1667, 2.5000,-1.2188,1.5625,-1.2188
018.43, 1.5937,2.0000, 00.6857,2.0555, 0.7247,-6.1269
018.43, 2.1875,1.7917, 00.6852,2.0555, 0.6588,-6.1928
018.43, 2.5938,1.5208, 00.6852,2.0555, 0.8565,-5.9952
018.43, 4.7187,0.8750, 00.6852,2.0555, 0.8565,-5.9952
018.43, 5.3125,0.6667, 00.6852,2.0555, 0.6588,-6.1928
018.43, 5.8438,0.4375, 00.6852,2.0555, 0.7247,-6.1269
341.57, 1.5937,0.6667, 06.1664,2.0555, 0.7247,-6.1269
341.57, 2.1875,0.8750, 06.1664,2.0555, 0.6588,-6.1928
341.57, 2.5937,1.1458, 06.1664,2.0555, 0.8565,-5.9952
341.57, 4.7187,1.7917, 06.1664,2.0555, 0.8565,-5.9952
341.57, 5.3125,2.0000, 06.1664,2.0555, 0.6588,-6.1928
341.57, 5.8438,2.2292, 06.1664,2.0555, 0.7247,-6.1269
;; (c)1997 STONE PRODUCTS CORPORATION
*CBLFLD, COBBLEFIELD
;%TYPE=MODEL
0, 0.5054,2.8462, 0,2.66, 0.0266,-2.6334
0, 0.665,2.6866, 0,2.66, 0.0266,-2.6334
0, 0.6916,2.7132, 0,2.66, 0.0532,-2.6068
0, 1.7822,0.6384, 0,2.66, 0.0532,-2.6068
0, 1.1704,0.6916, 0,2.66, 0.0532,-2.6068
0, 1.4896,0.532, 0,2.66, 0.0532,-2.6068
180, 1.5162,0.5586, 0,2.66, 0.0798,-2.5802
0, 0.1596,0.931, 0,2.66, 0.0532,-2.6068
0, 0.133,0.9044, 0,2.66, 0.0266,-2.6334
0, 0.399,1.064, 0,2.66, 0.0532,-2.6068
0, 1.2236,1.0108, 0,2.66, 0.0532,-2.6068
0, 1.463,1.2502, 0,2.66, 0.0532,-2.6068
0, 1.4098,1.2768, 0,2.66, 0.0532,-2.6068
0, 1.9418,2.6068, 0,2.66, 0.0266,-2.6334
0, 1.8886,2.6334, 0,2.66, 0.0798,-2.5802
0, 1.7556,2.793, 0,2.66, 0.0798,-2.5802
0, 0.6916,1.8886, 0,2.66, 0.133,-2.527
0, 0.7182,1.9152, 0,2.66, 0.0532,-2.6068
0, 0.1596,1.862, 0,2.66, 0.0798,-2.5802
0, 0.399,2.0748, 0,2.66, 0.0798,-2.5802
0, 0.3724,2.0482, 0,2.66, 0.0532,-2.6068
0, 2.2344,1.3034, 0,2.66, 0.1862,-2.4738
0, 2.2876,1.33, 0,2.66, 0.0532,-2.6068
0, 1.862,1.463, 0,2.66, 0.1064,-2.5536
0, 1.8354,1.4896, 0,2.66, 0.1064,-2.5536
270, 1.6226,0.931, 0,2.66, 0.0532,-2.6068
296.56505, 1.596,0.9842, 3.5687645,1.1895882, 0.059479409,-5.8884614
270, 1.596,1.0374, 0,2.66, 0.0532,-2.6068
243.43495, 1.6492,1.1438, 2.3791764,1.1895882, 0.11895882,-5.828982
270, 1.6492,1.2502, 0,2.66, 0.1064,-2.5536
288.43495, 1.6226,1.33, 5.888161,0.84116587, 0.084116595,-8.327542
26.565051, 0.2926,1.5162, 3.5687645,1.1895882, 0.059479409,-5.8884614
0, 0.1596,1.5162, 0,2.66, 0.133,-2.527
341.56505, 0.0798,1.5428, 2.5234976,0.84116587, 0.084116595,-8.327542
341.56505, 0.1862,0.4256, 2.5234976,0.84116587, 0.084116595,-8.327542
0, 0.1064,0.4256, 0,2.66, 0.0798,-2.5802
11.309932, -0.0266,0.399, 10.955047,0.52166893, 0.13563393,-13.427758
0, 0.2394,0.4522, 0,2.66, 0.0266,-2.6334
333.43495, 0.1862,0.4788, 2.3791764,1.1895882, 0.059479409,-5.8884614
0, 0.1596,0.4788, 0,2.66, 0.0266,-2.6334
14.036243, 0.0532,0.4522, 8.386882,0.64514478, 0.10967462,-10.857786
0, -0.0266,0.4522, 0,2.66, 0.0798,-2.5802
351.8699, 0.0798,0.8246, 2.6332657,0.37618082, 0.18809041,-18.62095
0, 0.0266,0.8246, 0,2.66, 0.0532,-2.6068
26.565051, -0.0266,0.798, 3.5687645,1.1895882, 0.059479409,-5.8884614
173.65981, 0.2128,0.8246, 2.6437308,0.29374787, 0.24087324,-23.846452
180, 0.3458,0.8246, 0,2.66, 0.133,-2.527
188.1301, 0.532,0.8512, 16.175775,0.37618082, 0.18809041,-18.62095
180, 0.6118,0.8512, 0,2.66, 0.0798,-2.5802
258.69007, 2.5802,0.798, 2.6083447,0.52166893, 0.13563393,-13.427758
270, 2.5802,0.931, 0,2.66, 0.133,-2.527
279.46232, 2.5536,1.0906, 13.55634,0.43730131, 0.1618015,-16.018347
180, 0,1.1172, 0,2.66, 0.0266,-2.6334
270, -0.0532,1.0906, 0,2.66, 0.2128,-2.4472
90, -0.0532,0.133, 0,2.66, 0.2394,-2.4206
90, -0.0266,0.4788, 0,2.66, 0.2926,-2.3674
180, 0,0.4522, 0,2.66, 0.0266,-2.6334
333.43495, -0.0532,0.133, 2.3791764,1.1895882, 0.059479409,-5.8884614
45, -0.0532,0.3724, 1.8809041,1.8809041, 0.037618092,-3.7241901
270, -0.0266,0.4788, 0,2.66, 0.0266,-2.6334
90, -0.0266,0.7714, 0,2.66, 0.0266,-2.6334
315, -0.0532,0.8778, 1.8809041,1.8809041, 0.037618092,-3.7241901
45, -0.0532,1.0906, 1.8809041,1.8809041, 0.037618092,-3.7241901
45, 2.5004,0.0798, 1.8809041,1.8809041, 0.075236158,-3.6865719
0, 2.3674,0.0798, 0,2.66, 0.133,-2.527
348.69007, 2.2344,0.1064, 2.6083447,0.52166893, 0.13563393,-13.427758
14.036243, 2.4206,0.3192, 8.386882,0.64514478, 0.10967462,-10.857786
0, 2.3142,0.3192, 0,2.66, 0.1064,-2.5536
351.8699, 2.128,0.3458, 2.6332657,0.37618082, 0.18809041,-18.62095
350.53768, 2.3674,0.6118, 2.6238078,0.43730131, 0.1618015,-16.018347
0, 2.2344,0.6118, 0,2.66, 0.133,-2.527
14.036243, 2.128,0.5852, 8.386882,0.64514478, 0.10967462,-10.857786
345.96376, 1.33,2.3408, 2.5805791,0.64514478, 0.10967462,-10.857786
0, 1.1438,2.3408, 0,2.66, 0.1862,-2.4738
11.309932, 1.0108,2.3142, 10.955047,0.52166893, 0.13563393,-13.427758
18.434949, 2.0482,2.5004, 5.888161,0.84116587, 0.084116595,-8.327542
0, 1.8886,2.5004, 0,2.66, 0.1596,-2.5004
352.87498, 1.6758,2.527, 2.6394592,0.32993238, 0.21445606,-21.231149
0, 1.5428,2.527, 0,2.66, 0.133,-2.527
284.03624, 0.3192,2.66, 8.386882,0.64514478, 0.10967462,-10.857786
270, 0.3192,2.793, 0,2.66, 0.133,-2.527
258.69007, 0.3458,2.926, 2.6083447,0.52166893, 0.13563393,-13.427758
270, 0.931,2.926, 0,2.66, 0.0266,-2.6334
270, 0.931,2.6068, 0,2.66, 0.0532,-2.6068
63.434949, 0.9044,2.8462, 2.3791764,1.1895882, 0.059479409,-5.8884614
90, 0.9044,2.793, 0,2.66, 0.0532,-2.6068
98.130102, 0.931,2.6068, 16.175775,0.37618082, 0.18809041,-18.62095
260.53768, 1.4896,2.5536, 2.6238078,0.43730131, 0.1618015,-16.018347
270, 1.4896,2.793, 0,2.66, 0.2394,-2.4206
281.30993, 1.463,2.926, 10.955047,0.52166893, 0.13563393,-13.427758
278.1301, 0.9576,2.5802, 16.175775,0.37618082, 0.18809041,-18.62095
270, 0.9576,2.793, 0,2.66, 0.2128,-2.4472
258.69007, 0.9842,2.926, 2.6083447,0.52166893, 0.13563393,-13.427758
194.03624, 0.4788,2.9792, 8.386882,0.64514478, 0.10967462,-10.857786
180, 0.7182,2.9792, 0,2.66, 0.2394,-2.4206
161.56505, 0.798,2.9526, 2.5234976,0.84116587, 0.084116595,-8.327542
180, 0.9044,2.9526, 0,2.66, 0.1064,-2.5536
0, 2.0748,2.9526, 0,2.66, 0.0532,-2.6068
26.565051, 2.0216,2.926, 3.5687645,1.1895882, 0.059479409,-5.8884614
0, 1.8354,2.926, 0,2.66, 0.1862,-2.4738
350.53768, 1.6758,2.9526, 2.6238078,0.43730131, 0.1618015,-16.018347
0, 1.5428,2.9526, 0,2.66, 0.133,-2.527
345.96376, 1.33,2.9792, 2.5805791,0.64514478, 0.10967462,-10.857786
0, 1.1438,2.9792, 0,2.66, 0.1862,-2.4738
11.309932, 1.0108,2.9526, 10.955047,0.52166893, 0.13563393,-13.427758
90, 2.1546,2.66, 0,2.66, 0.266,-2.394
270, 1.5162,2.926, 0,2.66, 0.266,-2.394
315, 2.128,2.9526, 1.8809041,1.8809041, 0.037618092,-3.7241901
45, 1.5162,2.926, 1.8809041,1.8809041, 0.037618092,-3.7241901
315, 1.4364,2.9526, 1.8809041,1.8809041, 0.037618092,-3.7241901
45, 0.9842,2.926, 1.8809041,1.8809041, 0.037618092,-3.7241901
315, 0.9044,2.9526, 1.8809041,1.8809041, 0.037618092,-3.7241901
45, 0.3458,2.926, 1.8809041,1.8809041, 0.037618092,-3.7241901
270, 2.66,2.128, 0,2.66, 0.0266,-2.6334
270, 2.66,1.7024, 0,2.66, 0.0266,-2.6334
281.30993, 2.6334,1.8354, 10.955047,0.52166893, 0.13563393,-13.427758
270, 2.6334,1.9418, 0,2.66, 0.1064,-2.5536
260.53768, 2.66,2.1014, 2.6238078,0.43730131, 0.1618015,-16.018347
270, 2.66,1.2236, 0,2.66, 0.0266,-2.6334
296.56505, 2.6334,1.2768, 3.5687645,1.1895882, 0.059479409,-5.8884614
270, 2.6334,1.3832, 0,2.66, 0.1064,-2.5536
255.96376, 2.66,1.4896, 2.5805791,0.64514478, 0.10967462,-10.857786
270, 2.66,1.596, 0,2.66, 0.1064,-2.5536
296.56505, 0.0266,1.8354, 3.5687645,1.1895882, 0.059479409,-5.8884614
270, 0.0266,1.995, 0,2.66, 0.1596,-2.5004
258.69007, 0.0532,2.128, 2.6083447,0.52166893, 0.13563393,-13.427758
63.434949, 0.3192,0.7182, 2.3791764,1.1895882, 0.059479409,-5.8884614
90, 0.3192,0.5852, 0,2.66, 0.133,-2.527
97.125016, 0.3458,0.3724, 18.806147,0.32993238, 0.21445606,-21.231149
270, 0.8778,0.7714, 0,2.66, 0.0266,-2.6334
243.43495, 0.8512,0.399, 2.3791764,1.1895882, 0.059479409,-5.8884614
270, 0.8512,0.5054, 0,2.66, 0.1064,-2.5536
263.65981, 0.8778,0.7448, 2.6437308,0.29374787, 0.24087324,-23.846452
0, 0.8246,0.798, 0,2.66, 0.0266,-2.6334
345.96376, 0.7182,0.8246, 2.5805791,0.64514478, 0.10967462,-10.857786
0, 0.532,0.8246, 0,2.66, 0.1862,-2.4738
14.036243, 0.4256,0.798, 8.386882,0.64514478, 0.10967462,-10.857786
0, 0.3724,0.798, 0,2.66, 0.0532,-2.6068
0, 0.9842,1.1172, 0,2.66, 0.0266,-2.6334
333.43495, 0.931,1.1438, 2.3791764,1.1895882, 0.059479409,-5.8884614
0, 0.8512,1.1438, 0,2.66, 0.0798,-2.5802
0, 0.7448,1.1438, 0,2.66, 0.1064,-2.5536
26.565051, 0.6916,1.1172, 3.5687645,1.1895882, 0.059479409,-5.8884614
90, 0.6916,0.8778, 0,2.66, 0.2394,-2.4206
189.46232, 0.1596,1.1438, 13.55634,0.43730131, 0.1618015,-16.018347
180, 0.399,1.1438, 0,2.66, 0.2394,-2.4206
180, 0.5586,1.1438, 0,2.66, 0.1596,-2.5004
153.43495, 0.6118,1.1172, 2.3791764,1.1895882, 0.059479409,-5.8884614
0, 0.9576,1.1704, 0,2.66, 0.0532,-2.6068
348.69007, 0.8246,1.197, 2.6083447,0.52166893, 0.13563393,-13.427758
0, 0.7182,1.197, 0,2.66, 0.1064,-2.5536
5.7105931, 0.4522,1.1704, 24.08587,0.2646799, 0.2673267,-26.465343
341.56505, 0.931,1.3832, 2.5234976,0.84116587, 0.084116595,-8.327542
0, 0.5586,1.3832, 0,2.66, 0.3724,-2.2876
14.036243, 0.4522,1.3566, 8.386882,0.64514478, 0.10967462,-10.857786
0, 1.8886,0.3458, 0,2.66, 0.133,-2.527
5.1944289, 1.596,0.3192, 26.731585,0.24082509, 0.2938066,-29.086854
0, 1.3034,0.3192, 0,2.66, 0.2926,-2.3674
355.60129, 0.9576,0.3458, 2.652165,0.20401269, 0.34682157,-34.335336
281.30993, 0.9044,0.5054, 10.955047,0.52166893, 0.13563393,-13.427758
270, 0.9044,0.7182, 0,2.66, 0.2128,-2.4472
243.43495, 0.931,0.7714, 2.3791764,1.1895882, 0.059479409,-5.8884614
243.43495, 2.0748,0.4256, 2.3791764,1.1895882, 0.059479409,-5.8884614
270, 2.0748,0.5586, 0,2.66, 0.133,-2.527
277.12502, 2.0482,0.7714, 18.806147,0.32993238, 0.21445606,-21.231149
0, 1.8354,0.798, 0,2.66, 0.1862,-2.4738
351.8699, 1.6492,0.8246, 2.6332657,0.37618082, 0.18809041,-18.62095
0, 1.4364,0.8246, 0,2.66, 0.2128,-2.4472
6.3401918, 1.197,0.798, 21.443594,0.29374787, 0.24087324,-23.846452
0, 0.9576,0.798, 0,2.66, 0.2394,-2.4206
180, 2.3674,2.2078, 0,2.66, 0.0532,-2.6068
168.69007, 2.5004,2.1812, 2.6083447,0.52166893, 0.13563393,-13.427758
180, 2.6068,2.1812, 0,2.66, 0.1064,-2.5536
188.1301, 2.793,2.2078, 16.175775,0.37618082, 0.18809041,-18.62095
180, 2.9526,2.2078, 0,2.66, 0.1596,-2.5004
0, 2.8728,2.4738, 0,2.66, 0.0798,-2.5802
18.434949, 2.793,2.4472, 5.888161,0.84116587, 0.084116595,-8.327542
0, 2.7132,2.4472, 0,2.66, 0.0798,-2.5802
353.65981, 2.4738,2.4738, 2.6437308,0.29374787, 0.24087324,-23.846452
0, 2.3142,2.4738, 0,2.66, 0.1596,-2.5004
0, 2.7664,2.527, 0,2.66, 0.1596,-2.5004
18.434949, 2.6866,2.5004, 5.888161,0.84116587, 0.084116595,-8.327542
0, 2.5536,2.5004, 0,2.66, 0.133,-2.527
350.53768, 2.394,2.527, 2.6238078,0.43730131, 0.1618015,-16.018347
0, 2.2344,2.527, 0,2.66, 0.1596,-2.5004
333.43495, 2.8728,2.7398, 2.3791764,1.1895882, 0.059479409,-5.8884614
0, 2.8196,2.7398, 0,2.66, 0.0532,-2.6068
18.434949, 2.7398,2.7132, 5.888161,0.84116587, 0.084116595,-8.327542
0, 2.66,2.7132, 0,2.66, 0.0798,-2.5802
351.8699, 2.4738,2.7398, 2.6332657,0.37618082, 0.18809041,-18.62095
0, 2.3674,2.7398, 0,2.66, 0.1064,-2.5536
11.309932, 2.2344,2.7132, 10.955047,0.52166893, 0.13563393,-13.427758
90, 0.0532,1.4098, 0,2.66, 0.0532,-2.6068
315, 0.0266,1.2236, 1.8809041,1.8809041, 0.075236158,-3.6865719
270, 0.0266,1.3034, 0,2.66, 0.0798,-2.5802
255.96376, 0.0532,1.4098, 2.5805791,0.64514478, 0.10967462,-10.857786
270, 0.3724,1.2236, 0,2.66, 0.0266,-2.6334
243.43495, 0.399,1.2768, 2.3791764,1.1895882, 0.059479409,-5.8884614
270, 0.399,1.3832, 0,2.66, 0.1064,-2.5536
288.43495, 0.3724,1.463, 5.888161,0.84116587, 0.084116595,-8.327542
315, 2.0748,0.6916, 1.8809041,1.8809041, 0.075236158,-3.6865719
270, 2.0748,0.7714, 0,2.66, 0.0798,-2.5802
261.8699, 2.1014,0.9576, 2.6332657,0.37618082, 0.18809041,-18.62095
270, 2.1014,1.0906, 0,2.66, 0.133,-2.527
315, 2.5004,1.1438, 1.8809041,1.8809041, 0.075236158,-3.6865719
0, 2.261,1.1438, 0,2.66, 0.2394,-2.4206
11.309932, 2.128,1.1172, 10.955047,0.52166893, 0.13563393,-13.427758
270, 1.6758,0.9044, 0,2.66, 0.0266,-2.6334
270, 1.6758,1.0906, 0,2.66, 0.0266,-2.6334
296.56505, 1.6492,0.9576, 3.5687645,1.1895882, 0.059479409,-5.8884614
270, 1.6492,0.9842, 0,2.66, 0.0266,-2.6334
251.56505, 1.6758,1.064, 2.5234976,0.84116587, 0.084116595,-8.327542
270, 1.0906,0.9576, 0,2.66, 0.0798,-2.5802
284.03624, 1.064,1.064, 8.386882,0.64514478, 0.10967462,-10.857786
270, 1.064,1.197, 0,2.66, 0.133,-2.527
258.69007, 1.0906,1.33, 2.6083447,0.52166893, 0.13563393,-13.427758
0, 1.1172,0.8512, 0,2.66, 0.0532,-2.6068
206.56505, 1.2236,0.8778, 3.5687645,1.1895882, 0.059479409,-5.8884614
180, 1.3034,0.8778, 0,2.66, 0.0798,-2.5802
170.53768, 1.463,0.8512, 2.6238078,0.43730131, 0.1618015,-16.018347
180, 1.596,0.8512, 0,2.66, 0.133,-2.527
341.56505, 1.5162,1.3832, 2.5234976,0.84116587, 0.084116595,-8.327542
0, 1.3832,1.3832, 0,2.66, 0.133,-2.527
18.434949, 1.3034,1.3566, 5.888161,0.84116587, 0.084116595,-8.327542
0, 1.1172,1.3566, 0,2.66, 0.1862,-2.4738
270, 1.5162,2.2078, 0,2.66, 0.0798,-2.5802
288.43495, 1.4896,2.2876, 5.888161,0.84116587, 0.084116595,-8.327542
270, 1.4896,2.3674, 0,2.66, 0.0798,-2.5802
251.56505, 1.5162,2.4472, 2.5234976,0.84116587, 0.084116595,-8.327542
281.30993, 1.6492,1.8354, 10.955047,0.52166893, 0.13563393,-13.427758
270, 1.6492,1.8886, 0,2.66, 0.0532,-2.6068
258.69007, 1.6758,2.0216, 2.6083447,0.52166893, 0.13563393,-13.427758
296.56505, 1.596,1.8354, 3.5687645,1.1895882, 0.059479409,-5.8884614
270, 1.596,1.9152, 0,2.66, 0.0798,-2.5802
255.96376, 1.6226,2.0216, 2.5805791,0.64514478, 0.10967462,-10.857786
258.69007, 0.9576,1.9152, 2.6083447,0.52166893, 0.13563393,-13.427758
270, 0.9576,2.0482, 0,2.66, 0.133,-2.527
288.43495, 0.931,2.128, 5.888161,0.84116587, 0.084116595,-8.327542
90, 2.9526,2.66, 0,2.66, 0.0266,-2.6334
315, 2.926,2.7132, 1.8809041,1.8809041, 0.037618092,-3.7241901
270, 2.2078,2.6866, 0,2.66, 0.0266,-2.6334
45, 2.2078,2.6866, 1.8809041,1.8809041, 0.037618092,-3.7241901
90, 2.9526,2.5536, 0,2.66, 0.1064,-2.5536
225, 2.9526,2.5536, 1.8809041,1.8809041, 0.037618092,-3.7241901
90, 2.9792,2.2344, 0,2.66, 0.2128,-2.4472
315, 2.9526,2.4738, 1.8809041,1.8809041, 0.037618092,-3.7241901
225, 2.9792,2.2344, 1.8809041,1.8809041, 0.037618092,-3.7241901
18.434949, 0.6118,2.4738, 5.888161,0.84116587, 0.084116595,-8.327542
180, 0.6118,2.4738, 0,2.66, 0.2128,-2.4472
0, 0.798,2.2078, 0,2.66, 0.1064,-2.5536
352.87498, 0.5852,2.2344, 2.6394592,0.32993238, 0.21445606,-21.231149
14.036243, 0.4788,2.2078, 8.386882,0.64514478, 0.10967462,-10.857786
0, 0.399,2.2078, 0,2.66, 0.0798,-2.5802
180, 0.798,2.5004, 0,2.66, 0.1064,-2.5536
165.96376, 0.9044,2.4738, 2.5805791,0.64514478, 0.10967462,-10.857786
0, 0.7448,1.7556, 0,2.66, 0.1596,-2.5004
8.1301023, 0.5586,1.729, 16.175775,0.37618082, 0.18809041,-18.62095
0, 0.3458,1.729, 0,2.66, 0.2128,-2.4472
350.53768, 0.1862,1.7556, 2.6238078,0.43730131, 0.1618015,-16.018347
0, 0.0798,1.7556, 0,2.66, 0.1064,-2.5536
198.43495, 0.1596,2.1812, 5.888161,0.84116587, 0.084116595,-8.327542
180, 0.266,2.1812, 0,2.66, 0.1064,-2.5536
161.56505, 0.3458,2.1546, 2.5234976,0.84116587, 0.084116595,-8.327542
189.46232, 0.5054,2.1812, 13.55634,0.43730131, 0.1618015,-16.018347
180, 0.7182,2.1812, 0,2.66, 0.2128,-2.4472
171.8699, 0.9044,2.1546, 2.6332657,0.37618082, 0.18809041,-18.62095
180, 1.7822,2.0482, 0,2.66, 0.0798,-2.5802
191.30993, 1.9152,2.0748, 10.955047,0.52166893, 0.13563393,-13.427758
180, 1.9684,2.0748, 0,2.66, 0.0532,-2.6068
165.96376, 2.0748,2.0482, 2.5805791,0.64514478, 0.10967462,-10.857786
180, 2.2078,2.0482, 0,2.66, 0.133,-2.527
0, 2.1546,2.1014, 0,2.66, 0.0532,-2.6068
333.43495, 2.1014,2.128, 2.3791764,1.1895882, 0.059479409,-5.8884614
0, 2.0216,2.128, 0,2.66, 0.0798,-2.5802
14.036243, 1.9152,2.1014, 8.386882,0.64514478, 0.10967462,-10.857786
9.4623222, 1.7556,2.0748, 13.55634,0.43730131, 0.1618015,-16.018347
0, 1.6492,2.0748, 0,2.66, 0.1064,-2.5536
345.96376, 1.5428,2.1014, 2.5805791,0.64514478, 0.10967462,-10.857786
90, 2.2876,2.0216, 0,2.66, 0.1064,-2.5536
0, 2.3142,1.6758, 0,2.66, 0.0532,-2.6068
45, 2.6334,1.6492, 1.8809041,1.8809041, 0.037618092,-3.7241901
0, 2.527,1.6492, 0,2.66, 0.1064,-2.5536
350.53768, 2.3674,1.6758, 2.6238078,0.43730131, 0.1618015,-16.018347
71.565051, 2.261,1.9418, 2.5234976,0.84116587, 0.084116595,-8.327542
90, 2.261,1.8088, 0,2.66, 0.133,-2.527
104.03624, 2.2876,1.7024, 8.386882,0.64514478, 0.10967462,-10.857786
45, 2.2078,1.7024, 1.8809041,1.8809041, 0.037618092,-3.7241901
0, 2.1014,1.7024, 0,2.66, 0.1064,-2.5536
14.036243, 1.995,1.6758, 8.386882,0.64514478, 0.10967462,-10.857786
0, 1.7024,1.6758, 0,2.66, 0.2926,-2.3674
288.43495, 1.6758,1.5694, 5.888161,0.84116587, 0.084116595,-8.327542
270, 1.6758,1.596, 0,2.66, 0.0266,-2.6334
270, 1.6758,1.3034, 0,2.66, 0.1064,-2.5536
180, 1.729,1.1704, 0,2.66, 0.0266,-2.6334
0, 2.4738,1.6226, 0,2.66, 0.1596,-2.5004
188.1301, 1.9152,1.197, 16.175775,0.37618082, 0.18809041,-18.62095
180, 2.1014,1.197, 0,2.66, 0.1862,-2.4738
165.96376, 2.2078,1.1704, 2.5805791,0.64514478, 0.10967462,-10.857786
180, 2.6334,1.1704, 0,2.66, 0.4256,-2.2344
348.69007, 2.3408,1.6492, 2.6083447,0.52166893, 0.13563393,-13.427758
0, 2.1812,1.6492, 0,2.66, 0.1596,-2.5004
11.309932, 2.0482,1.6226, 10.955047,0.52166893, 0.13563393,-13.427758
0, 1.7024,1.6226, 0,2.66, 0.3458,-2.3142
251.56505, 1.7024,1.3832, 2.5234976,0.84116587, 0.084116595,-8.327542
270, 1.7024,1.4896, 0,2.66, 0.1064,-2.5536
0, 1.5162,1.7024, 0,2.66, 0.0798,-2.5802
180, 0.8246,1.4098, 0,2.66, 0.3724,-2.2876
188.1301, 1.0108,1.4364, 16.175775,0.37618082, 0.18809041,-18.62095
180, 1.1438,1.4364, 0,2.66, 0.133,-2.527
171.8699, 1.33,1.4098, 2.6332657,0.37618082, 0.18809041,-18.62095
180, 1.596,1.4098, 0,2.66, 0.266,-2.394
341.56505, 1.4364,1.729, 2.5234976,0.84116587, 0.084116595,-8.327542
0, 1.2768,1.729, 0,2.66, 0.1596,-2.5004
11.309932, 1.1438,1.7024, 10.955047,0.52166893, 0.13563393,-13.427758
0, 0.9576,1.7024, 0,2.66, 0.1862,-2.4738
14.036243, 0.8512,1.6758, 8.386882,0.64514478, 0.10967462,-10.857786
0, 0.6916,1.6758, 0,2.66, 0.1596,-2.5004
345.96376, 0.5852,1.7024, 2.5805791,0.64514478, 0.10967462,-10.857786
0, 0.4522,1.7024, 0,2.66, 0.133,-2.527
45, 2.6334,1.1704, 1.8809041,1.8809041, 0.037618092,-3.7241901
315, 2.6334,1.6226, 1.8809041,1.8809041, 0.037618092,-3.7241901
315, 2.6334,2.1546, 1.8809041,1.8809041, 0.037618092,-3.7241901
315, 2.2876,2.2344, 1.8809041,1.8809041, 0.037618092,-3.7241901
225, 1.6226,1.4364, 1.8809041,1.8809041, 0.037618092,-3.7241901
315, 1.596,1.7024, 1.8809041,1.8809041, 0.037618092,-3.7241901
225, 0.0798,1.4896, 1.8809041,1.8809041, 0.037618092,-3.7241901
315, 0.3458,1.4896, 1.8809041,1.8809041, 0.037618092,-3.7241901
45, 0.3458,1.5428, 1.8809041,1.8809041, 0.037618092,-3.7241901
315, 0.0532,1.5694, 1.8809041,1.8809041, 0.037618092,-3.7241901
225, 0.0798,1.7024, 1.8809041,1.8809041, 0.037618092,-3.7241901
315, 0.3458,1.7024, 1.8809041,1.8809041, 0.037618092,-3.7241901
315, 0.4256,1.4364, 1.8809041,1.8809041, 0.037618092,-3.7241901
45, 0.4256,1.6758, 1.8809041,1.8809041, 0.037618092,-3.7241901
45, 0.3458,1.1704, 1.8809041,1.8809041, 0.037618092,-3.7241901
225, 0.2926,0.133, 1.8809041,1.8809041, 0.037618092,-3.7241901
315, 0.266,0.399, 1.8809041,1.8809041, 0.037618092,-3.7241901
225, 0.2926,0.4788, 1.8809041,1.8809041, 0.037618092,-3.7241901
315, 0.266,0.798, 1.8809041,1.8809041, 0.037618092,-3.7241901
315, 2.2078,0.133, 1.8809041,1.8809041, 0.037618092,-3.7241901
225, 2.128,0.5852, 1.8809041,1.8809041, 0.037618092,-3.7241901
225, 1.0374,1.197, 1.8809041,1.8809041, 0.037618092,-3.7241901
315, 1.0108,1.3566, 1.8809041,1.8809041, 0.037618092,-3.7241901
315, 0.4256,1.197, 1.8809041,1.8809041, 0.037618092,-3.7241901
45, 0.4256,1.33, 1.8809041,1.8809041, 0.037618092,-3.7241901
225, 0.6384,0.8778, 1.8809041,1.8809041, 0.037618092,-3.7241901
315, 0.6118,1.1172, 1.8809041,1.8809041, 0.037618092,-3.7241901
315, 0.8512,0.798, 1.8809041,1.8809041, 0.037618092,-3.7241901
45, 0.3458,0.7714, 1.8809041,1.8809041, 0.037618092,-3.7241901
315, 0.3458,0.3724, 1.8809041,1.8809041, 0.037618092,-3.7241901
225, 2.0482,0.8778, 1.8809041,1.8809041, 0.037618092,-3.7241901
315, 2.0216,1.1172, 1.8809041,1.8809041, 0.037618092,-3.7241901
225, 1.6226,0.8778, 1.8809041,1.8809041, 0.037618092,-3.7241901
315, 1.596,1.3566, 1.8809041,1.8809041, 0.037618092,-3.7241901
45, 1.0906,1.33, 1.8809041,1.8809041, 0.037618092,-3.7241901
315, 1.0906,0.8778, 1.8809041,1.8809041, 0.037618092,-3.7241901
315, 0.6916,0.8778, 1.8809041,1.8809041, 0.037618092,-3.7241901
225, 1.0374,0.8778, 1.8809041,1.8809041, 0.037618092,-3.7241901
315, 1.0108,1.1172, 1.8809041,1.8809041, 0.037618092,-3.7241901
315, 0.931,0.3724, 1.8809041,1.8809041, 0.037618092,-3.7241901
45, 0.931,0.7714, 1.8809041,1.8809041, 0.037618092,-3.7241901
315, 2.527,0.2926, 1.8809041,1.8809041, 0.037618092,-3.7241901
45, 2.2078,0.266, 1.8809041,1.8809041, 0.037618092,-3.7241901
225, 2.0482,0.3724, 1.8809041,1.8809041, 0.037618092,-3.7241901
315, 2.0216,0.798, 1.8809041,1.8809041, 0.037618092,-3.7241901
315, 2.1014,0.3724, 1.8809041,1.8809041, 0.037618092,-3.7241901
225, 2.5536,0.3724, 1.8809041,1.8809041, 0.037618092,-3.7241901
315, 2.527,0.5852, 1.8809041,1.8809041, 0.037618092,-3.7241901
225, 2.5536,0.665, 1.8809041,1.8809041, 0.037618092,-3.7241901
45, 2.1014,1.0906, 1.8809041,1.8809041, 0.037618092,-3.7241901
315, 1.6758,0.8778, 1.8809041,1.8809041, 0.037618092,-3.7241901
45, 1.6758,1.0906, 1.8809041,1.8809041, 0.037618092,-3.7241901
315, 1.6758,1.197, 1.8809041,1.8809041, 0.037618092,-3.7241901
45, 1.6758,1.596, 1.8809041,1.8809041, 0.037618092,-3.7241901
315, 1.6758,1.7024, 1.8809041,1.8809041, 0.037618092,-3.7241901
45, 1.6758,2.0216, 1.8809041,1.8809041, 0.037618092,-3.7241901
315, 2.2078,2.0482, 1.8809041,1.8809041, 0.037618092,-3.7241901
315, 2.2876,1.7024, 1.8809041,1.8809041, 0.037618092,-3.7241901
45, 2.2876,2.128, 1.8809041,1.8809041, 0.037618092,-3.7241901
45, 2.2876,2.4472, 1.8809041,1.8809041, 0.037618092,-3.7241901
315, 2.2078,2.5536, 1.8809041,1.8809041, 0.037618092,-3.7241901
45, 2.128,2.527, 1.8809041,1.8809041, 0.037618092,-3.7241901
315, 2.2078,2.4738, 1.8809041,1.8809041, 0.037618092,-3.7241901
45, 2.2078,2.1014, 1.8809041,1.8809041, 0.037618092,-3.7241901
315, 1.5162,2.128, 1.8809041,1.8809041, 0.037618092,-3.7241901
225, 1.5428,2.4738, 1.8809041,1.8809041, 0.037618092,-3.7241901
315, 1.5162,2.5536, 1.8809041,1.8809041, 0.037618092,-3.7241901
45, 1.4364,2.3674, 1.8809041,1.8809041, 0.037618092,-3.7241901
315, 0.9842,2.394, 1.8809041,1.8809041, 0.037618092,-3.7241901
225, 0.931,2.5536, 1.8809041,1.8809041, 0.037618092,-3.7241901
315, 0.3458,2.5536, 1.8809041,1.8809041, 0.037618092,-3.7241901
315, 0.3724,2.2344, 1.8809041,1.8809041, 0.037618092,-3.7241901
45, 0.3724,2.4472, 1.8809041,1.8809041, 0.037618092,-3.7241901
315, 0.9044,2.4738, 1.8809041,1.8809041, 0.037618092,-3.7241901
45, 0.9044,2.2078, 1.8809041,1.8809041, 0.037618092,-3.7241901
315, 0.9044,2.1546, 1.8809041,1.8809041, 0.037618092,-3.7241901
45, 0.9044,1.7556, 1.8809041,1.8809041, 0.037618092,-3.7241901
315, 0.0532,1.7822, 1.8809041,1.8809041, 0.037618092,-3.7241901
45, 0.0532,2.128, 1.8809041,1.8809041, 0.037618092,-3.7241901
0, 1.4098,2.1014, 0,2.66, 0.0266,-2.6334
345.96376, 1.3034,2.128, 2.5805791,0.64514478, 0.10967462,-10.857786
0, 1.2502,2.128, 0,2.66, 0.0532,-2.6068
11.309932, 1.1172,2.1014, 10.955047,0.52166893, 0.13563393,-13.427758
0, 1.0108,2.1014, 0,2.66, 0.1064,-2.5536
315, 1.4364,2.3142, 1.8809041,1.8809041, 0.037618092,-3.7241901
45, 1.4364,2.1014, 1.8809041,1.8809041, 0.037618092,-3.7241901
315, 0.9842,2.128, 1.8809041,1.8809041, 0.037618092,-3.7241901
45, 0.9842,2.2876, 1.8809041,1.8809041, 0.037618092,-3.7241901
270, 0.9842,1.8088, 0,2.66, 0.0266,-2.6334
270, 0.9842,2.0216, 0,2.66, 0.0532,-2.6068
0, 1.5162,1.7556, 0,2.66, 0.0798,-2.5802
341.56505, 1.4364,1.7822, 2.5234976,0.84116587, 0.084116595,-8.327542
0, 1.2768,1.7822, 0,2.66, 0.1596,-2.5004
14.036243, 1.1704,1.7556, 8.386882,0.64514478, 0.10967462,-10.857786
0, 1.0108,1.7556, 0,2.66, 0.1596,-2.5004
0, 1.33,2.0482, 0,2.66, 0.266,-2.394
345.96376, 1.2236,2.0748, 2.5805791,0.64514478, 0.10967462,-10.857786
0, 1.1438,2.0748, 0,2.66, 0.0798,-2.5802
18.434949, 1.064,2.0482, 5.888161,0.84116587, 0.084116595,-8.327542
0, 1.0108,2.0482, 0,2.66, 0.0532,-2.6068
116.56505, 1.0108,1.9152, 3.5687645,1.1895882, 0.059479409,-5.8884614
90, 1.0108,1.862, 0,2.66, 0.0532,-2.6068
63.434949, 0.9842,1.8088, 2.3791764,1.1895882, 0.059479409,-5.8884614
45, 0.9842,2.0216, 1.8809041,1.8809041, 0.037618092,-3.7241901
315, 1.596,2.0482, 1.8809041,1.8809041, 0.037618092,-3.7241901
225, 1.6226,1.7822, 1.8809041,1.8809041, 0.037618092,-3.7241901
315, 0.9842,1.7822, 1.8809041,1.8809041, 0.037618092,-3.7241901
180, 0.8246,0.3458, 0,2.66, 0.4522,-2.2078
270, 0.2926,0.7714, 0,2.66, 0.2926,-2.3674
270, 0.2926,0.3724, 0,2.66, 0.2394,-2.4206
180, 0.266,0.1064, 0,2.66, 0.2926,-2.3674
270, 2.2078,0.266, 0,2.66, 0.133,-2.527
90, 2.5536,0.133, 0,2.66, 0.133,-2.527
180, 2.527,0.2926, 0,2.66, 0.2926,-2.3674
0, 2.3142,2.1546, 0,2.66, 0.3192,-2.3408
270, 2.2078,2.66, 0,2.66, 0.1064,-2.5536
270, 2.2876,2.4472, 0,2.66, 0.2128,-2.4472
270, 2.1014,0.5586, 0,2.66, 0.1862,-2.4738
90, 2.5536,0.3724, 0,2.66, 0.1862,-2.4738
0, 2.128,0.6384, 0,2.66, 0.399,-2.261
270, 1.6226,1.6758, 0,2.66, 0.2394,-2.4206
90, 0.4256,1.4364, 0,2.66, 0.2394,-2.4206
180, 0.9044,2.527, 0,2.66, 0.532,-2.128
270, 1.5162,2.66, 0,2.66, 0.1064,-2.5536
90, 2.1546,2.5536, 0,2.66, 0.1064,-2.5536
0, 1.7024,0.8512, 0,2.66, 0.3192,-2.3408
90, 2.0482,0.8778, 0,2.66, 0.2128,-2.4472
180, 2.0216,1.1172, 0,2.66, 0.3192,-2.3408
270, 0.6916,1.0906, 0,2.66, 0.2128,-2.4472
0, 0.7182,0.8512, 0,2.66, 0.2926,-2.3674
90, 1.0374,0.8778, 0,2.66, 0.2128,-2.4472
90, 0.6384,0.8778, 0,2.66, 0.2128,-2.4472
90, 0.4256,1.197, 0,2.66, 0.133,-2.527
90, 1.0374,1.197, 0,2.66, 0.133,-2.527
90, 2.2344,1.729, 0,2.66, 0.2926,-2.3674
90, 2.2344,2.128, 0,2.66, 0.3192,-2.3408
180, 2.2078,2.4738, 0,2.66, 0.665,-1.995
270, 0.9842,2.2876, 0,2.66, 0.1596,-2.5004
90, 1.463,2.128, 0,2.66, 0.1596,-2.5004
270, 0.3724,2.4472, 0,2.66, 0.2128,-2.4472
90, 0.931,2.2344, 0,2.66, 0.2128,-2.4472
0, 0.0798,1.1704, 0,2.66, 0.266,-2.394
180, 0.3458,1.4896, 0,2.66, 0.266,-2.394
270, 0.3724,1.6758, 0,2.66, 0.1064,-2.5536
90, 0.0532,1.5694, 0,2.66, 0.1064,-2.5536
0, 0.0798,1.7024, 0,2.66, 0.266,-2.394
0, 1.0108,2.3674, 0,2.66, 0.4256,-2.2344
;; (c)1997 STONE PRODUCTS CORPORATION
*CLSTN, CAROLINA LEDGESTONE
;%TYPE=MODEL
270, -0.04998,1.3328, 0,1.666, 0.3332,-1.3328
270, 1.61602,1.3328, 0,1.666, 0.3332,-1.3328
180, 0.7497,0.0833, 0,1.666, 0.03332,-1.63268
270, 0.71638,0.3332, 0,1.666, 0.3332,-1.3328
296.56505, 1.53272,0.5831, 2.2351736,0.74505786, 0.037252893,-3.6880364
270, 1.53272,0.61642, 0,1.666, 0.03332,-1.63268
288.43495, 1.51606,0.6664, 3.6878482,0.52683546, 0.052683551,-5.215671
315, 0.84966,0.73304, 1.1780399,1.1780399, 0.023560805,-2.332519
63.434949, 0.84966,0.73304, 1.4901157,0.74505786, 0.074505786,-3.6507835
270, 0.86632,0.71638, 0,1.666, 0.04998,-1.61602
270, 0.88298,0.84966, 0,1.666, 0.04998,-1.61602
270, 0.93296,0.9996, 0,1.666, 0.0833,-1.5827
296.56505, 0.833,0.94962, 2.2351736,0.74505786, 0.037252893,-3.6880364
270, 0.84966,0.9163, 0,1.666, 0.06664,-1.59936
225, 0.81634,1.4161, 1.1780399,1.1780399, 0.11780399,-2.2382758
0, 0.86632,1.4161, 0,1.666, 0.21658,-1.44942
0, 0.64974,1.4161, 0,1.666, 0.21658,-1.44942
355.91438, 0.4165,1.43276, 1.6617662,0.11869759, 0.23383425,-23.14959
0, 0.53312,1.09956, 0,1.666, 0.11662,-1.54938
5.1944289, 0.34986,1.0829, 16.742413,0.15083256, 0.18401571,-18.217556
0, 0.2499,1.0829, 0,1.666, 0.09996,-1.56604
281.30993, 0.2499,1.0829, 6.8613191,0.32672949, 0.084949673,-8.4100168
0, 0.09996,1.0829, 0,1.666, 0.14994,-1.51606
353.65981, -0.04998,1.09956, 1.6558103,0.18397893, 0.15086271,-14.935409
14.036243, 0.53312,1.1662, 5.2528366,0.40406436, 0.068690946,-6.800403
0, 0.38318,1.1662, 0,1.666, 0.14994,-1.51606
0, 0.21658,1.1662, 0,1.666, 0.1666,-1.4994
0, 0.04998,1.1662, 0,1.666, 0.1666,-1.4994
350.53768, -0.04998,1.18286, 1.6433323,0.27388872, 0.10133883,-10.032544
180, 0.0833,1.23284, 0,1.666, 0.13328,-1.53272
180, 0.14994,1.23284, 0,1.666, 0.06664,-1.59936
186.34019, 0.29988,1.2495, 13.430461,0.18397893, 0.15086271,-14.935409
185.71059, 0.46648,1.26616, 15.085361,0.1657732, 0.16743093,-16.575662
180, 0.56644,1.26616, 0,1.666, 0.09996,-1.56604
351.8699, 0.88298,1.61602, 1.6492559,0.23560799, 0.11780399,-11.662595
0, 0.59976,1.61602, 0,1.666, 0.28322,-1.38278
36.869898, 0.59976,1.61602, 2.3324,0.3332, 0.0833,-8.2467
0, 0.4998,1.61602, 0,1.666, 0.09996,-1.56604
0, 0.3332,1.61602, 0,1.666, 0.1666,-1.4994
180, 0.46648,1.51606, 0,1.666, 0.09996,-1.56604
180, 0.51646,1.51606, 0,1.666, 0.04998,-1.61602
177.13759, 0.84966,1.4994, 1.6639214,0.083196075, 0.33361623,-33.028008
180, 0.9163,1.4994, 0,1.666, 0.06664,-1.59936
188.1301, 1.03292,1.51606, 10.131143,0.23560799, 0.11780399,-11.662595
18.434949, 1.94922,1.54938, 3.6878482,0.52683546, 0.052683551,-5.215671
0, 1.69932,1.54938, 0,1.666, 0.2499,-1.4161
0, 1.5827,1.54938, 0,1.666, 0.11662,-1.54938
6.3401918, 1.43276,1.53272, 13.430461,0.18397893, 0.15086271,-14.935409
0, 1.28282,1.53272, 0,1.666, 0.14994,-1.51606
354.80557, 1.09956,1.54938, 1.6591581,0.15083256, 0.18401571,-18.217556
350.53768, 0.9996,1.56604, 1.6433323,0.27388872, 0.10133883,-10.032544
182.86241, 1.4161,1.44942, 31.697703,0.083196075, 0.33361623,-33.028008
176.63354, 1.69932,1.43276, 1.6631251,0.097830885, 0.28370957,-28.087248
180, 2.0825,1.43276, 0,1.666, 0.38318,-1.28282
0, 1.9159,1.38278, 0,1.666, 0.1666,-1.4994
0, 1.71598,1.38278, 0,1.666, 0.19992,-1.46608
6.3401918, 1.56604,1.36612, 13.430461,0.18397893, 0.15086271,-14.935409
0, 1.38278,1.36612, 0,1.666, 0.18326,-1.48274
315, 1.38278,1.36612, 1.1780399,1.1780399, 0.047121594,-2.3089582
0, 1.0829,1.36612, 0,1.666, 0.29988,-1.36612
172.87498, 0.69972,1.21618, 1.6531349,0.20664186, 0.13431722,-13.297404
186.34019, 0.84966,1.23284, 13.430461,0.18397893, 0.15086271,-14.935409
180, 1.03292,1.23284, 0,1.666, 0.18326,-1.48274
173.65981, 1.18286,1.21618, 1.6558103,0.18397893, 0.15086271,-14.935409
180, 1.39944,1.21618, 0,1.666, 0.21658,-1.44942
184.39871, 1.61602,1.23284, 20.06089,0.12777637, 0.21721983,-21.504763
183.36646, 0.93296,1.11622, 26.707833,0.097830885, 0.28370957,-28.087248
186.34019, 1.0829,1.13288, 13.430461,0.18397893, 0.15086271,-14.935409
180, 1.34946,1.13288, 0,1.666, 0.26656,-1.39944
236.30993, 1.34946,1.13288, 3.6965221,0.46206527, 0.06006848,-5.9467799
188.1301, 1.46608,1.14954, 10.131143,0.23560799, 0.11780399,-11.662595
180, 1.61602,1.14954, 0,1.666, 0.14994,-1.51606
0, 1.21618,1.0829, 0,1.666, 0.39984,-1.26616
5.7105931, 1.04958,1.06624, 15.085361,0.1657732, 0.16743093,-16.575662
0, 0.64974,1.06624, 0,1.666, 0.39984,-1.26616
0, 1.69932,0.76636, 0,1.666, 0.26656,-1.39944
353.65981, 1.54938,0.78302, 1.6558103,0.18397893, 0.15086271,-14.935409
355.23636, 1.34946,0.79968, 1.6602452,0.13835377, 0.20061297,-19.860684
0, 1.14954,0.79968, 0,1.666, 0.19992,-1.46608
36.869898, 1.14954,0.79968, 2.3324,0.3332, 0.0833,-8.2467
0, 0.88298,0.79968, 0,1.666, 0.26656,-1.39944
180, 1.21618,0.84966, 0,1.666, 0.36652,-1.29948
174.80557, 1.39944,0.833, 1.6591581,0.15083256, 0.18401571,-18.217556
180, 1.5827,0.833, 0,1.666, 0.18326,-1.48274
90, 1.5827,0.833, 0,1.666, 0.06664,-1.59936
175.23636, 1.78262,0.81634, 1.6602452,0.13835377, 0.20061297,-19.860684
180, 1.93256,0.81634, 0,1.666, 0.14994,-1.51606
0, 1.56604,0.89964, 0,1.666, 0.31654,-1.34946
355.91438, 1.3328,0.9163, 1.6617662,0.11869759, 0.23383425,-23.14959
0, 0.84966,0.9163, 0,1.666, 0.48314,-1.18286
180, 1.7493,0, 0,1.666, 0.9996,-0.6664
270, 1.7493,0.09996, 0,1.666, 0.09996,-1.56604
302.00538, 1.666,0.23324, 6.004252,0.17659565, 0.15717012,-15.559842
270, 1.666,0.3332, 0,1.666, 0.09996,-1.56604
0, 0.6664,0.3332, 0,1.666, 0.9996,-0.6664
0, 0,0.3332, 0,1.666, 0.6664,-0.9996
90, 0,0.23324, 0,1.666, 0.09996,-1.56604
122.00538, 0.0833,0.09996, 6.004252,0.17659565, 0.15717012,-15.559842
90, 0.0833,0, 0,1.666, 0.09996,-1.56604
180, 0.7497,0, 0,1.666, 0.6664,-0.9996
302.00538, 1.09956,0.56644, 6.004252,0.17659565, 0.15717012,-15.559842
270, 1.09956,0.6664, 0,1.666, 0.09996,-1.56604
0, 0.43316,0.6664, 0,1.666, 0.6664,-0.9996
90, 0.43316,0.56644, 0,1.666, 0.09996,-1.56604
122.00538, 0.51646,0.43316, 6.004252,0.17659565, 0.15717012,-15.559842
90, 0.51646,0.3332, 0,1.666, 0.09996,-1.56604
180, 1.18286,0.3332, 0,1.666, 0.6664,-0.9996
270, 1.18286,0.43316, 0,1.666, 0.09996,-1.56604
90, 1.18286,0.3332, 0,1.666, 0.09996,-1.56604
180, 2.18246,0.3332, 0,1.666, 0.9996,-0.6664
270, 2.18246,0.43316, 0,1.666, 0.09996,-1.56604
302.00538, 2.09916,0.56644, 6.004252,0.17659565, 0.15717012,-15.559842
270, 2.09916,0.6664, 0,1.666, 0.09996,-1.56604
0, 1.09956,0.6664, 0,1.666, 0.9996,-0.6664
90, 1.09956,0.56644, 0,1.666, 0.09996,-1.56604
122.00538, 1.18286,0.43316, 6.004252,0.17659565, 0.15717012,-15.559842
302.00538, 0.56644,1.23284, 6.004252,0.17659565, 0.15717012,-15.559842
270, 0.56644,1.3328, 0,1.666, 0.09996,-1.56604
0, -0.04998,1.3328, 0,1.666, 0.61642,-1.04958
180, 0.64974,0.9996, 0,1.666, 0.69972,-0.96628
270, 0.64974,1.09956, 0,1.666, 0.09996,-1.56604
90, 0.64974,0.9996, 0,1.666, 0.09996,-1.56604
180, 1.64934,0.9996, 0,1.666, 0.9996,-0.6664
0, 0.56644,1.3328, 0,1.666, 0.9996,-0.6664
90, 0.56644,1.23284, 0,1.666, 0.09996,-1.56604
122.00538, 0.64974,1.09956, 6.004252,0.17659565, 0.15717012,-15.559842
90, 1.0829,1.3328, 0,1.666, 0.09996,-1.56604
180, 2.0825,1.3328, 0,1.666, 0.9996,-0.6664
270, 2.0825,1.43276, 0,1.666, 0.09996,-1.56604
302.00538, 1.9992,1.56604, 6.004252,0.17659565, 0.15717012,-15.559842
270, 1.9992,1.666, 0,1.666, 0.09996,-1.56604
0, 0.9996,1.666, 0,1.666, 0.9996,-0.6664
90, 0.9996,1.56604, 0,1.666, 0.09996,-1.56604
122.00538, 1.0829,1.43276, 6.004252,0.17659565, 0.15717012,-15.559842
302.00538, 0.9996,1.56604, 6.004252,0.17659565, 0.15717012,-15.559842
270, 0.9996,1.666, 0,1.666, 0.09996,-1.56604
0, 0.3332,1.666, 0,1.666, 0.6664,-0.9996
90, 0.3332,1.56604, 0,1.666, 0.09996,-1.56604
122.00538, 0.4165,1.43276, 6.004252,0.17659565, 0.15717012,-15.559842
90, 0.4165,1.3328, 0,1.666, 0.09996,-1.56604
180, 1.0829,1.3328, 0,1.666, 0.6664,-0.9996
270, 1.0829,1.43276, 0,1.666, 0.09996,-1.56604
0, 0.21658,0.9996, 0,1.666, 0.6664,-0.9996
90, 0.21658,0.89964, 0,1.666, 0.09996,-1.56604
122.00538, 0.29988,0.76636, 6.004252,0.17659565, 0.15717012,-15.559842
90, 0.29988,0.6664, 0,1.666, 0.09996,-1.56604
180, 0.88298,0.6664, 0,1.666, 0.5831,-1.0829
180, 0.96628,0.6664, 0,1.666, 0.0833,-1.5827
180, 1.96588,0.6664, 0,1.666, 0.9996,-0.6664
270, 1.96588,0.76636, 0,1.666, 0.09996,-1.56604
302.00538, 1.88258,0.89964, 6.004252,0.17659565, 0.15717012,-15.559842
270, 1.88258,0.9996, 0,1.666, 0.09996,-1.56604
0, 0.88298,0.9996, 0,1.666, 0.9996,-0.6664
0, 0.73304,0.73304, 0,1.666, 0.11662,-1.54938
5.7105931, 0.56644,0.71638, 15.085361,0.1657732, 0.16743093,-16.575662
0, 0.29988,0.71638, 0,1.666, 0.26656,-1.39944
0, 0.68306,0.86632, 0,1.666, 0.1666,-1.4994
78.690068, 0.68306,0.86632, 1.6336474,0.32672949, 0.084949673,-8.4100168
0, 0.5831,0.86632, 0,1.666, 0.09996,-1.56604
4.0856168, 0.34986,0.84966, 21.721658,0.11869759, 0.23383425,-23.14959
0, 0.2499,0.84966, 0,1.666, 0.09996,-1.56604
198.43495, 0.31654,0.93296, 3.6878482,0.52683546, 0.10536709,-5.1629875
185.71059, 0.48314,0.94962, 15.085361,0.1657732, 0.16743093,-16.575662
180, 0.56644,0.94962, 0,1.666, 0.0833,-1.5827
108.43495, 0.56644,0.94962, 3.6878482,0.52683546, 0.052683551,-5.215671
180, 0.833,0.94962, 0,1.666, 0.26656,-1.39944
0, 1.96588,0.43316, 0,1.666, 0.21658,-1.44942
0, 1.7493,0.43316, 0,1.666, 0.21658,-1.44942
355.91438, 1.51606,0.44982, 1.6617662,0.11869759, 0.23383425,-23.14959
2.8624052, 1.18286,0.43316, 31.697703,0.083196075, 0.33361623,-33.028008
0, 1.78262,0.56644, 0,1.666, 0.31654,-1.34946
4.7636417, 1.5827,0.54978, 18.401051,0.13835377, 0.20061297,-19.860684
0, 1.38278,0.54978, 0,1.666, 0.19992,-1.46608
356.63354, 1.09956,0.56644, 1.6631251,0.097830885, 0.28370957,-28.087248
123.69007, 0.88298,0.43316, 2.3103263,0.46206527, 0.06006848,-5.9467799
180, 1.18286,0.43316, 0,1.666, 0.29988,-1.36612
348.69007, 1.06624,0.4998, 1.6336474,0.32672949, 0.084949673,-8.4100168
4.7636417, 0.86632,0.48314, 18.401051,0.13835377, 0.20061297,-19.860684
0, 0.48314,0.48314, 0,1.666, 0.38318,-1.28282
90, 0.79968,0.56644, 0,1.666, 0.03332,-1.63268
0, 0.43316,0.56644, 0,1.666, 0.36652,-1.29948
356.82017, 0.79968,0.59976, 1.6634349,0.092413053, 0.30034241,-29.7339
0, 0.43316,0.59976, 0,1.666, 0.36652,-1.29948
0, 0.53312,0.09996, 0,1.666, 0.18326,-1.48274
0, 0.3332,0.09996, 0,1.666, 0.19992,-1.46608
3.8140748, 0.0833,0.0833, 23.383162,0.11082067, 0.25045471,-24.795017
180, 0.71638,0.23324, 0,1.666, 0.71638,-0.94962
184.08562, 1.46608,0.14994, 21.721658,0.11869759, 0.23383425,-23.14959
180, 1.48274,0.14994, 0,1.666, 0.01666,-1.64934
174.80557, 1.666,0.13328, 1.6591581,0.15083256, 0.18401571,-18.217556
198.43495, 1.71598,0.14994, 3.6878482,0.52683546, 0.052683551,-5.215671
90, 1.04958,0.0833, 0,1.666, 0.04998,-1.61602
8.1301023, 0.93296,0.06664, 10.131143,0.23560799, 0.11780399,-11.662595
0, 0.84966,0.06664, 0,1.666, 0.0833,-1.5827
350.53768, 0.7497,0.0833, 1.6433323,0.27388872, 0.10133883,-10.032544
279.46232, 1.46608,0.3332, 8.4905501,0.27388872, 0.10133883,-10.032544
279.46232, 0.88298,0.3332, 8.4905501,0.27388872, 0.10133883,-10.032544
0, 1.06624,0.13328, 0,1.666, 0.1666,-1.4994
0, 0.93296,0.13328, 0,1.666, 0.13328,-1.53272
352.87498, 0.79968,0.14994, 1.6531349,0.20664186, 0.13431722,-13.297404
0, 0.71638,0.14994, 0,1.666, 0.0833,-1.5827
0, 1.48274,0.23324, 0,1.666, 0.18326,-1.48274
5.7105931, 1.31614,0.21658, 15.085361,0.1657732, 0.16743093,-16.575662
8.1301023, 1.19952,0.19992, 10.131143,0.23560799, 0.11780399,-11.662595
0, 1.0829,0.19992, 0,1.666, 0.11662,-1.54938
350.53768, 0.98294,0.21658, 1.6433323,0.27388872, 0.10133883,-10.032544
348.69007, 0.89964,0.23324, 1.6336474,0.32672949, 0.084949673,-8.4100168
5.1944289, 0.71638,0.21658, 16.742413,0.15083256, 0.18401571,-18.217556
;; (c)1997 STONE PRODUCTS CORPORATION
*CSTLSTN, CASTLE STONE
;%TYPE=MODEL
26.565051, 0.219945,0.9897525, 4.9181198,1.6393733, 0.081968663,-8.1148976
345.96376, 0.9897525,0.9897525, 3.5562999,0.88907498, 0.15114275,-14.963132
14.036243, 0.073315,0.953095, 11.557975,0.88907498, 0.15114275,-14.963132
0, 2.3094225,0.1099725, 0,3.66575, 0.073315,-3.592435
341.56505, 0.3299175,2.7493125, 3.4776358,1.159212, 0.11592121,-11.476198
26.565051, 0.2566025,2.712655, 4.9181198,1.6393733, 0.081968663,-8.1148976
63.434949, 0.6964925,2.8226275, 3.2787465,1.6393733, 0.081968663,-8.1148976
45, 0.659835,2.78597, 2.5920766,2.5920766, 0.05184155,-5.1323118
296.56505, 0.806465,2.712655, 4.9181198,1.6393733, 0.081968663,-8.1148976
315, 0.7698075,2.7493125, 2.5920766,2.5920766, 0.05184155,-5.1323118
315, 0.219945,2.8226275, 2.5920766,2.5920766, 0.05184155,-5.1323118
270, 0.2566025,2.78597, 0,3.66575, 0.073315,-3.592435
225, 0.2566025,2.712655, 2.5920766,2.5920766, 0.05184155,-5.1323118
14.036243, 0.513205,2.7493125, 11.557975,0.88907498, 0.15114275,-14.963132
341.56505, 0.659835,2.78597, 3.4776358,1.159212, 0.11592121,-11.476198
198.43495, 0.366575,2.49271, 8.1144835,1.159212, 0.11592121,-11.476198
165.96376, 0.513205,2.4560525, 3.5562999,0.88907498, 0.15114275,-14.963132
315, 0.7698075,2.419395, 2.5920766,2.5920766, 0.05184155,-5.1323118
270, 0.7698075,2.49271, 0,3.66575, 0.073315,-3.592435
225, 0.806465,2.5293675, 2.5920766,2.5920766, 0.05184155,-5.1323118
63.434949, 0.513205,2.4560525, 3.2787465,1.6393733, 0.081968663,-8.1148976
26.565051, 0.5498625,2.5293675, 4.9181198,1.6393733, 0.081968663,-8.1148976
225, 0.2566025,2.4560525, 2.5920766,2.5920766, 0.05184155,-5.1323118
243.43495, 0.219945,2.419395, 3.2787465,1.6393733, 0.081968663,-8.1148976
135, 0.366575,2.49271, 2.5920766,2.5920766, 0.05184155,-5.1323118
116.56505, 0.3299175,2.5293675, 4.9181198,1.6393733, 0.081968663,-8.1148976
153.43495, 0.7698075,2.419395, 3.2787465,1.6393733, 0.081968663,-8.1148976
198.43495, 0.6964925,2.4560525, 8.1144835,1.159212, 0.11592121,-11.476198
225, 3.4091475,0.43989, 2.5920766,2.5920766, 0.10368306,-5.0804702
180, 3.445805,0.43989, 0,3.66575, 0.0366575,-3.6290925
116.56505, 3.37249,0.6964925, 4.9181198,1.6393733, 0.081968663,-8.1148976
45, 3.445805,0.73315, 2.5920766,2.5920766, 0.10368306,-5.0804702
26.565051, 3.37249,0.6964925, 4.9181198,1.6393733, 0.081968663,-8.1148976
90, 3.37249,0.58652, 0,3.66575, 0.1099725,-3.5557775
135, 3.4091475,0.5498625, 2.5920766,2.5920766, 0.05184155,-5.1323118
116.56505, 3.445805,0.4765475, 4.9181198,1.6393733, 0.081968663,-8.1148976
90, 3.445805,0.43989, 0,3.66575, 0.0366575,-3.6290925
135, 3.4824625,0.4032325, 2.5920766,2.5920766, 0.05184155,-5.1323118
116.56505, 3.51912,0.3299175, 4.9181198,1.6393733, 0.081968663,-8.1148976
341.56505, 3.07923,0.1099725, 3.4776358,1.159212, 0.11592121,-11.476198
26.565051, 3.005915,0.073315, 4.9181198,1.6393733, 0.081968663,-8.1148976
63.434949, 3.445805,0.1832875, 3.2787465,1.6393733, 0.081968663,-8.1148976
45, 3.4091475,0.14663, 2.5920766,2.5920766, 0.05184155,-5.1323118
296.56505, 3.5557775,0.073315, 4.9181198,1.6393733, 0.081968663,-8.1148976
315, 3.51912,0.1099725, 2.5920766,2.5920766, 0.05184155,-5.1323118
153.43495, 3.22586,0.1832875, 3.2787465,1.6393733, 0.081968663,-8.1148976
116.56505, 3.2625175,0.1099725, 4.9181198,1.6393733, 0.081968663,-8.1148976
315, 2.9326,0.219945, 2.5920766,2.5920766, 0.05184155,-5.1323118
315, 2.9692575,0.1832875, 2.5920766,2.5920766, 0.05184155,-5.1323118
270, 3.005915,0.14663, 0,3.66575, 0.073315,-3.592435
225, 3.005915,0.073315, 2.5920766,2.5920766, 0.05184155,-5.1323118
14.036243, 3.2625175,0.1099725, 11.557975,0.88907498, 0.15114275,-14.963132
341.56505, 3.4091475,0.14663, 3.4776358,1.159212, 0.11592121,-11.476198
333.43495, 2.2361075,0.14663, 3.2787465,1.6393733, 0.081968663,-8.1148976
213.69007, 1.979505,0.073315, 5.0834805,1.0166961, 0.13217049,-13.084879
180, 2.05282,0.073315, 0,3.66575, 0.073315,-3.592435
206.56505, 2.126135,0.1099725, 4.9181198,1.6393733, 0.081968663,-8.1148976
18.434949, 2.126135,0.1099725, 8.1144835,1.159212, 0.11592121,-11.476198
333.43495, 2.05282,0.14663, 3.2787465,1.6393733, 0.081968663,-8.1148976
341.56505, 1.9428475,0.1832875, 3.4776358,1.159212, 0.11592121,-11.476198
161.56505, 2.7493125,0.0366575, 3.4776358,1.159212, 0.11592121,-11.476198
153.43495, 2.63934,0.073315, 3.2787465,1.6393733, 0.081968663,-8.1148976
198.43495, 2.566025,0.1099725, 8.1144835,1.159212, 0.11592121,-11.476198
26.565051, 2.566025,0.1099725, 4.9181198,1.6393733, 0.081968663,-8.1148976
0, 2.63934,0.14663, 0,3.66575, 0.073315,-3.592435
33.690068, 2.712655,0.14663, 5.0834805,1.0166961, 0.13217049,-13.084879
153.43495, 2.4560525,0.073315, 3.2787465,1.6393733, 0.081968663,-8.1148976
341.56505, 1.832875,0.4765475, 3.4776358,1.159212, 0.11592121,-11.476198
333.43495, 1.9428475,0.43989, 3.2787465,1.6393733, 0.081968663,-8.1148976
18.434949, 2.0161625,0.4032325, 8.1144835,1.159212, 0.11592121,-11.476198
26.565051, 2.126135,0.43989, 4.9181198,1.6393733, 0.16393733,-8.0329289
206.56505, 2.0161625,0.4032325, 4.9181198,1.6393733, 0.081968663,-8.1148976
180, 1.9428475,0.366575, 0,3.66575, 0.073315,-3.592435
213.69007, 1.8695325,0.366575, 5.0834805,1.0166961, 0.13217049,-13.084879
333.43495, 2.126135,0.43989, 3.2787465,1.6393733, 0.081968663,-8.1148976
296.56505, 2.19945,0.4032325, 4.9181198,1.6393733, 0.081968663,-8.1148976
315, 2.2361075,0.3299175, 2.5920766,2.5920766, 0.05184155,-5.1323118
0, 1.31967,1.02641, 0,3.66575, 0.073315,-3.592435
26.565051, 1.246355,0.9897525, 4.9181198,1.6393733, 0.081968663,-8.1148976
198.43495, 1.246355,0.9897525, 8.1144835,1.159212, 0.11592121,-11.476198
153.43495, 1.31967,0.953095, 3.2787465,1.6393733, 0.081968663,-8.1148976
161.56505, 1.4296425,0.9164375, 3.4776358,1.159212, 0.11592121,-11.476198
341.56505, 0.6231775,1.0630675, 3.4776358,1.159212, 0.11592121,-11.476198
333.43495, 0.73315,1.02641, 3.2787465,1.6393733, 0.081968663,-8.1148976
18.434949, 0.806465,0.9897525, 8.1144835,1.159212, 0.11592121,-11.476198
206.56505, 0.806465,0.9897525, 4.9181198,1.6393733, 0.081968663,-8.1148976
180, 0.73315,0.953095, 0,3.66575, 0.073315,-3.592435
333.43495, 0.9164375,1.02641, 3.2787465,1.6393733, 0.081968663,-8.1148976
26.565051, 0.9164375,1.02641, 4.9181198,1.6393733, 0.16393733,-8.0329289
33.690068, 0.43989,1.0630675, 5.0834805,1.0166961, 0.13217049,-13.084879
0, 0.366575,1.0630675, 0,3.66575, 0.073315,-3.592435
26.565051, 0.29326,1.02641, 4.9181198,1.6393733, 0.081968663,-8.1148976
153.43495, 0.366575,0.9897525, 3.2787465,1.6393733, 0.081968663,-8.1148976
161.56505, 0.4765475,0.953095, 3.4776358,1.159212, 0.11592121,-11.476198
333.43495, -0.29326,1.099725, 3.2787465,1.6393733, 0.081968663,-8.1148976
341.56505, -0.219945,1.0630675, 3.4776358,1.159212, 0.11592121,-11.476198
26.565051, -0.1099725,1.02641, 4.9181198,1.6393733, 0.081968663,-8.1148976
198.43495, -0.1099725,1.02641, 8.1144835,1.159212, 0.11592121,-11.476198
180, -0.219945,0.9897525, 0,3.66575, 0.0366575,-3.6290925
213.69007, -0.2566025,0.9897525, 5.0834805,1.0166961, 0.13217049,-13.084879
333.43495, -0.0366575,1.0630675, 3.2787465,1.6393733, 0.081968663,-8.1148976
296.56505, 0.0366575,1.02641, 4.9181198,1.6393733, 0.081968663,-8.1148976
14.036243, 2.4560525,3.5557775, 11.557975,0.88907498, 0.15114275,-14.963132
8.1301023, 2.8959425,3.5557775, 22.291859,0.51841535, 0.25920768,-25.661559
348.69007, 2.9692575,3.2625175, 3.5945637,0.71891273, 0.18691733,-18.504814
341.56505, 2.859285,3.299175, 3.4776358,1.159212, 0.11592121,-11.476198
206.56505, 2.8959425,3.5557775, 4.9181198,1.6393733, 0.081968663,-8.1148976
0, 3.005915,3.445805, 0,3.66575, 0.1099725,-3.5557775
14.036243, 2.859285,3.4091475, 11.557975,0.88907498, 0.15114275,-14.963132
11.309932, 2.6759975,3.37249, 15.097167,0.71891273, 0.18691733,-18.504814
333.43495, 2.5293675,3.445805, 3.2787465,1.6393733, 0.16393733,-8.0329289
315, 2.4560525,3.51912, 2.5920766,2.5920766, 0.10368306,-5.0804702
45, 2.419395,3.51912, 2.5920766,2.5920766, 0.05184155,-5.1323118
63.434949, 2.3827375,3.445805, 3.2787465,1.6393733, 0.081968663,-8.1148976
90, 2.3827375,3.3358325, 0,3.66575, 0.1099725,-3.5557775
315, 2.8226275,3.51912, 2.5920766,2.5920766, 0.05184155,-5.1323118
270, 2.859285,3.4824625, 0,3.66575, 0.073315,-3.592435
153.43495, 2.8226275,3.51912, 3.2787465,1.6393733, 0.081968663,-8.1148976
180, 2.7493125,3.5557775, 0,3.66575, 0.0366575,-3.6290925
225, 2.712655,3.5557775, 2.5920766,2.5920766, 0.10368306,-5.0804702
198.43495, 2.63934,3.4824625, 8.1144835,1.159212, 0.11592121,-11.476198
108.43495, 2.63934,3.4824625, 8.1144835,1.159212, 0.11592121,-11.476198
225, 2.6759975,3.37249, 2.5920766,2.5920766, 0.10368306,-5.0804702
194.03624, 2.6026825,3.299175, 11.557975,0.88907498, 0.15114275,-14.963132
210.96376, 0.5498625,3.1158875, 13.20209,0.62867095, 0.21374812,-21.161064
225, 0.6231775,3.1892025, 2.5920766,2.5920766, 0.10368306,-5.0804702
338.19859, 0.806465,3.0425725, 11.572116,0.68071269, 0.19740669,-19.543261
303.69007, 0.73315,3.152545, 5.0834805,1.0166961, 0.13217049,-13.084879
315, 0.9164375,3.152545, 2.5920766,2.5920766, 0.10368306,-5.0804702
225, 0.4032325,3.1892025, 2.5920766,2.5920766, 0.15552462,-5.0286288
198.43495, 0.513205,3.22586, 8.1144835,1.159212, 0.11592121,-11.476198
296.56505, 0.6964925,3.3358325, 4.9181198,1.6393733, 0.081968663,-8.1148976
270, 0.6964925,3.4091475, 0,3.66575, 0.073315,-3.592435
303.69007, 0.6231775,3.51912, 5.0834805,1.0166961, 0.13217049,-13.084879
161.56505, 0.5498625,3.299175, 3.4776358,1.159212, 0.23184237,-11.360277
123.69007, 0.6231775,3.1892025, 5.0834805,1.0166961, 0.13217049,-13.084879
161.56505, 0.73315,3.152545, 3.4776358,1.159212, 0.11592121,-11.476198
206.56505, 0.87978,3.22586, 4.9181198,1.6393733, 0.16393733,-8.0329289
270, 0.87978,3.299175, 0,3.66575, 0.073315,-3.592435
251.56505, 0.9164375,3.4091475, 3.4776358,1.159212, 0.11592121,-11.476198
225, 0.9897525,3.4824625, 2.5920766,2.5920766, 0.10368306,-5.0804702
165.96376, 0.87978,3.22586, 3.5562999,0.88907498, 0.15114275,-14.963132
165.96376, 0.73315,3.2625175, 3.5562999,0.88907498, 0.15114275,-14.963132
315, 3.3358325,3.592435, 2.5920766,2.5920766, 0.15552462,-5.0286288
296.56505, 3.445805,3.4824625, 4.9181198,1.6393733, 0.081968663,-8.1148976
284.03624, 3.4824625,3.4091475, 11.557975,0.88907498, 0.15114275,-14.963132
270, 3.51912,3.2625175, 0,3.66575, 0.29326,-3.37249
251.56505, 3.51912,2.9692575, 3.4776358,1.159212, 0.11592121,-11.476198
243.43495, 3.4824625,2.859285, 3.2787465,1.6393733, 0.16393733,-8.0329289
258.69007, 3.6290925,3.51912, 3.5945637,0.71891273, 0.18691733,-18.504814
225, 3.592435,3.3358325, 2.5920766,2.5920766, 0.10368306,-5.0804702
288.43495, 3.51912,2.9692575, 8.1144835,1.159212, 0.11592121,-11.476198
341.56505, 3.5557775,2.859285, 3.4776358,1.159212, 0.11592121,-11.476198
288.43495, 3.66575,2.8226275, 8.1144835,1.159212, 0.11592121,-11.476198
153.43495, 3.51912,3.152545, 3.2787465,1.6393733, 0.081968663,-8.1148976
225, 3.445805,3.1892025, 2.5920766,2.5920766, 0.10368306,-5.0804702
243.43495, 3.37249,3.1158875, 3.2787465,1.6393733, 0.081968663,-8.1148976
315, 3.6290925,3.152545, 2.5920766,2.5920766, 0.10368306,-5.0804702
270, 3.7024075,3.07923, 0,3.66575, 0.1099725,-3.5557775
281.30993, 3.592435,3.3358325, 15.097167,0.71891273, 0.18691733,-18.504814
270, 3.6290925,3.152545, 0,3.66575, 0.14663,-3.51912
243.43495, 3.6290925,3.005915, 3.2787465,1.6393733, 0.16393733,-8.0329289
116.56505, 0.4765475,1.2096975, 4.9181198,1.6393733, 0.081968663,-8.1148976
135, 0.43989,1.2830125, 2.5920766,2.5920766, 0.05184155,-5.1323118
90, 0.4032325,1.31967, 0,3.66575, 0.0366575,-3.6290925
116.56505, 0.4032325,1.3563275, 4.9181198,1.6393733, 0.081968663,-8.1148976
135, 0.366575,1.4296425, 2.5920766,2.5920766, 0.05184155,-5.1323118
90, 0.3299175,1.4663, 0,3.66575, 0.1099725,-3.5557775
26.565051, 0.3299175,1.5762725, 4.9181198,1.6393733, 0.081968663,-8.1148976
45, 0.4032325,1.61293, 2.5920766,2.5920766, 0.10368306,-5.0804702
116.56505, 0.3299175,1.5762725, 4.9181198,1.6393733, 0.081968663,-8.1148976
180, 0.4032325,1.31967, 0,3.66575, 0.0366575,-3.6290925
225, 0.366575,1.31967, 2.5920766,2.5920766, 0.10368306,-5.0804702
45, 0.0366575,1.5762725, 2.5920766,2.5920766, 0.10368306,-5.0804702
0, 0,1.5762725, 0,3.66575, 0.0366575,-3.6290925
296.56505, 0.073315,1.31967, 4.9181198,1.6393733, 0.081968663,-8.1148976
225, 0,1.2830125, 2.5920766,2.5920766, 0.10368306,-5.0804702
206.56505, 0.073315,1.31967, 4.9181198,1.6393733, 0.081968663,-8.1148976
270, 0.073315,1.4296425, 0,3.66575, 0.1099725,-3.5557775
315, 0.0366575,1.4663, 2.5920766,2.5920766, 0.05184155,-5.1323118
296.56505, 0,1.539615, 4.9181198,1.6393733, 0.081968663,-8.1148976
270, 0,1.5762725, 0,3.66575, 0.0366575,-3.6290925
270, 0,1.61293, 0,3.66575, 0.0366575,-3.6290925
315, -0.073315,1.686245, 2.5920766,2.5920766, 0.10368306,-5.0804702
243.43495, 2.1627925,3.005915, 3.2787465,1.6393733, 0.16393733,-8.0329289
270, 2.1627925,3.152545, 0,3.66575, 0.14663,-3.51912
281.30993, 2.126135,3.3358325, 15.097167,0.71891273, 0.18691733,-18.504814
270, 2.2361075,3.07923, 0,3.66575, 0.1099725,-3.5557775
315, 2.1627925,3.152545, 2.5920766,2.5920766, 0.10368306,-5.0804702
243.43495, 1.90619,3.1158875, 3.2787465,1.6393733, 0.081968663,-8.1148976
225, 1.979505,3.1892025, 2.5920766,2.5920766, 0.10368306,-5.0804702
153.43495, 2.05282,3.152545, 3.2787465,1.6393733, 0.081968663,-8.1148976
288.43495, 2.19945,2.8226275, 8.1144835,1.159212, 0.11592121,-11.476198
341.56505, 2.0894775,2.859285, 3.4776358,1.159212, 0.11592121,-11.476198
288.43495, 2.05282,2.9692575, 8.1144835,1.159212, 0.11592121,-11.476198
225, 2.126135,3.3358325, 2.5920766,2.5920766, 0.10368306,-5.0804702
258.69007, 2.1627925,3.51912, 3.5945637,0.71891273, 0.18691733,-18.504814
243.43495, 2.0161625,2.859285, 3.2787465,1.6393733, 0.16393733,-8.0329289
251.56505, 2.05282,2.9692575, 3.4776358,1.159212, 0.11592121,-11.476198
270, 2.05282,3.2625175, 0,3.66575, 0.29326,-3.37249
284.03624, 2.0161625,3.4091475, 11.557975,0.88907498, 0.15114275,-14.963132
296.56505, 1.979505,3.4824625, 4.9181198,1.6393733, 0.081968663,-8.1148976
315, 1.8695325,3.592435, 2.5920766,2.5920766, 0.15552462,-5.0286288
45, 1.246355,2.6759975, 2.5920766,2.5920766, 0.15552462,-5.0286288
63.434949, 1.3563275,2.78597, 3.2787465,1.6393733, 0.081968663,-8.1148976
75.963757, 1.392985,2.859285, 3.5562999,0.88907498, 0.15114275,-14.963132
90, 1.4296425,3.005915, 0,3.66575, 0.29326,-3.37249
108.43495, 1.4296425,3.299175, 8.1144835,1.159212, 0.11592121,-11.476198
116.56505, 1.392985,3.4091475, 4.9181198,1.6393733, 0.16393733,-8.0329289
101.30993, 1.539615,2.7493125, 15.097167,0.71891273, 0.18691733,-18.504814
135, 1.5029575,2.9326, 2.5920766,2.5920766, 0.10368306,-5.0804702
71.565051, 1.4296425,3.299175, 3.4776358,1.159212, 0.11592121,-11.476198
18.434949, 1.4663,3.4091475, 8.1144835,1.159212, 0.11592121,-11.476198
71.565051, 1.5762725,3.445805, 3.4776358,1.159212, 0.11592121,-11.476198
206.56505, 1.4296425,3.1158875, 4.9181198,1.6393733, 0.081968663,-8.1148976
135, 1.3563275,3.07923, 2.5920766,2.5920766, 0.10368306,-5.0804702
116.56505, 1.2830125,3.152545, 4.9181198,1.6393733, 0.081968663,-8.1148976
45, 1.539615,3.1158875, 2.5920766,2.5920766, 0.10368306,-5.0804702
90, 1.61293,3.1892025, 0,3.66575, 0.1099725,-3.5557775
78.690068, 1.5029575,2.9326, 3.5945637,0.71891273, 0.18691733,-18.504814
90, 1.539615,3.1158875, 0,3.66575, 0.14663,-3.51912
116.56505, 1.539615,3.2625175, 4.9181198,1.6393733, 0.16393733,-8.0329289
194.03624, 1.7229025,0.6964925, 11.557975,0.88907498, 0.15114275,-14.963132
225, 1.7962175,0.7698075, 2.5920766,2.5920766, 0.10368306,-5.0804702
108.43495, 1.75956,0.87978, 8.1144835,1.159212, 0.11592121,-11.476198
198.43495, 1.75956,0.87978, 8.1144835,1.159212, 0.11592121,-11.476198
225, 1.832875,0.953095, 2.5920766,2.5920766, 0.10368306,-5.0804702
180, 1.8695325,0.953095, 0,3.66575, 0.0366575,-3.6290925
153.43495, 1.9428475,0.9164375, 3.2787465,1.6393733, 0.081968663,-8.1148976
270, 1.979505,0.87978, 0,3.66575, 0.073315,-3.592435
315, 1.9428475,0.9164375, 2.5920766,2.5920766, 0.05184155,-5.1323118
18.434949, 2.126135,1.539615, 8.1144835,1.159212, 0.11592121,-11.476198
26.565051, 2.2361075,1.5762725, 4.9181198,1.6393733, 0.081968663,-8.1148976
341.56505, 2.3094225,1.61293, 3.4776358,1.159212, 0.11592121,-11.476198
333.43495, 2.419395,1.5762725, 3.2787465,1.6393733, 0.16393733,-8.0329289
153.43495, 2.3094225,1.61293, 3.2787465,1.6393733, 0.081968663,-8.1148976
180, 2.2361075,1.6495875, 0,3.66575, 0.073315,-3.592435
146.30993, 2.1627925,1.6495875, 8.1335689,1.0166961, 0.13217049,-13.084879
26.565051, 2.419395,1.5762725, 4.9181198,1.6393733, 0.081968663,-8.1148976
63.434949, 2.49271,1.61293, 3.2787465,1.6393733, 0.081968663,-8.1148976
45, 2.5293675,1.686245, 2.5920766,2.5920766, 0.05184155,-5.1323118
45, 3.1158875,2.859285, 2.5920766,2.5920766, 0.05184155,-5.1323118
63.434949, 3.07923,2.78597, 3.2787465,1.6393733, 0.081968663,-8.1148976
26.565051, 3.005915,2.7493125, 4.9181198,1.6393733, 0.081968663,-8.1148976
146.30993, 2.7493125,2.8226275, 8.1335689,1.0166961, 0.13217049,-13.084879
180, 2.8226275,2.8226275, 0,3.66575, 0.073315,-3.592435
153.43495, 2.8959425,2.78597, 3.2787465,1.6393733, 0.081968663,-8.1148976
333.43495, 3.005915,2.7493125, 3.2787465,1.6393733, 0.16393733,-8.0329289
341.56505, 2.8959425,2.78597, 3.4776358,1.159212, 0.11592121,-11.476198
26.565051, 2.8226275,2.7493125, 4.9181198,1.6393733, 0.081968663,-8.1148976
18.434949, 2.712655,2.712655, 8.1144835,1.159212, 0.11592121,-11.476198
135, 0.953095,0.806465, 2.5920766,2.5920766, 0.05184155,-5.1323118
116.56505, 0.9897525,0.73315, 4.9181198,1.6393733, 0.081968663,-8.1148976
153.43495, 1.0630675,0.6964925, 3.2787465,1.6393733, 0.081968663,-8.1148976
33.690068, 1.31967,0.7698075, 5.0834805,1.0166961, 0.13217049,-13.084879
0, 1.246355,0.7698075, 0,3.66575, 0.073315,-3.592435
26.565051, 1.17304,0.73315, 4.9181198,1.6393733, 0.081968663,-8.1148976
206.56505, 1.0630675,0.6964925, 4.9181198,1.6393733, 0.16393733,-8.0329289
198.43495, 1.17304,0.73315, 8.1144835,1.159212, 0.11592121,-11.476198
153.43495, 1.246355,0.6964925, 3.2787465,1.6393733, 0.081968663,-8.1148976
161.56505, 1.3563275,0.659835, 3.4776358,1.159212, 0.11592121,-11.476198
161.56505, 3.1158875,3.005915, 3.4776358,1.159212, 0.11592121,-11.476198
153.43495, 3.005915,3.0425725, 3.2787465,1.6393733, 0.081968663,-8.1148976
198.43495, 2.9326,3.07923, 8.1144835,1.159212, 0.11592121,-11.476198
206.56505, 2.8226275,3.0425725, 4.9181198,1.6393733, 0.16393733,-8.0329289
26.565051, 2.9326,3.07923, 4.9181198,1.6393733, 0.081968663,-8.1148976
0, 3.005915,3.1158875, 0,3.66575, 0.073315,-3.592435
33.690068, 3.07923,3.1158875, 5.0834805,1.0166961, 0.13217049,-13.084879
153.43495, 2.8226275,3.0425725, 3.2787465,1.6393733, 0.081968663,-8.1148976
116.56505, 2.7493125,3.07923, 4.9181198,1.6393733, 0.081968663,-8.1148976
135, 2.712655,3.152545, 2.5920766,2.5920766, 0.05184155,-5.1323118
315, 1.6495875,1.7962175, 2.5920766,2.5920766, 0.05184155,-5.1323118
296.56505, 1.61293,1.8695325, 4.9181198,1.6393733, 0.081968663,-8.1148976
333.43495, 1.539615,1.90619, 3.2787465,1.6393733, 0.081968663,-8.1148976
213.69007, 1.2830125,1.832875, 5.0834805,1.0166961, 0.13217049,-13.084879
180, 1.3563275,1.832875, 0,3.66575, 0.073315,-3.592435
206.56505, 1.4296425,1.8695325, 4.9181198,1.6393733, 0.081968663,-8.1148976
26.565051, 1.539615,1.90619, 4.9181198,1.6393733, 0.16393733,-8.0329289
18.434949, 1.4296425,1.8695325, 8.1144835,1.159212, 0.11592121,-11.476198
333.43495, 1.3563275,1.90619, 3.2787465,1.6393733, 0.081968663,-8.1148976
341.56505, 1.246355,1.9428475, 3.4776358,1.159212, 0.11592121,-11.476198
296.56505, 0.9164375,2.859285, 4.9181198,1.6393733, 0.081968663,-8.1148976
315, 0.953095,2.78597, 2.5920766,2.5920766, 0.05184155,-5.1323118
270, 0.9897525,2.7493125, 0,3.66575, 0.0366575,-3.6290925
296.56505, 0.9897525,2.712655, 4.9181198,1.6393733, 0.081968663,-8.1148976
315, 1.02641,2.63934, 2.5920766,2.5920766, 0.05184155,-5.1323118
270, 1.0630675,2.6026825, 0,3.66575, 0.1099725,-3.5557775
206.56505, 1.0630675,2.49271, 4.9181198,1.6393733, 0.081968663,-8.1148976
225, 0.9897525,2.4560525, 2.5920766,2.5920766, 0.10368306,-5.0804702
296.56505, 1.0630675,2.49271, 4.9181198,1.6393733, 0.081968663,-8.1148976
0, 0.9897525,2.7493125, 0,3.66575, 0.0366575,-3.6290925
45, 1.02641,2.7493125, 2.5920766,2.5920766, 0.10368306,-5.0804702
296.56505, 2.3827375,3.152545, 4.9181198,1.6393733, 0.081968663,-8.1148976
315, 2.419395,3.07923, 2.5920766,2.5920766, 0.05184155,-5.1323118
270, 2.4560525,3.0425725, 0,3.66575, 0.0366575,-3.6290925
296.56505, 2.4560525,3.005915, 4.9181198,1.6393733, 0.081968663,-8.1148976
315, 2.49271,2.9326, 2.5920766,2.5920766, 0.05184155,-5.1323118
270, 2.5293675,2.8959425, 0,3.66575, 0.1099725,-3.5557775
206.56505, 2.5293675,2.78597, 4.9181198,1.6393733, 0.081968663,-8.1148976
225, 2.4560525,2.7493125, 2.5920766,2.5920766, 0.10368306,-5.0804702
296.56505, 2.5293675,2.78597, 4.9181198,1.6393733, 0.081968663,-8.1148976
0, 2.4560525,3.0425725, 0,3.66575, 0.0366575,-3.6290925
45, 2.49271,3.0425725, 2.5920766,2.5920766, 0.10368306,-5.0804702
45, 1.90619,1.8695325, 2.5920766,2.5920766, 0.10368306,-5.0804702
0, 1.8695325,1.8695325, 0,3.66575, 0.0366575,-3.6290925
296.56505, 1.9428475,1.61293, 4.9181198,1.6393733, 0.081968663,-8.1148976
225, 1.8695325,1.5762725, 2.5920766,2.5920766, 0.10368306,-5.0804702
206.56505, 1.9428475,1.61293, 4.9181198,1.6393733, 0.081968663,-8.1148976
270, 1.9428475,1.7229025, 0,3.66575, 0.1099725,-3.5557775
315, 1.90619,1.75956, 2.5920766,2.5920766, 0.05184155,-5.1323118
296.56505, 1.8695325,1.832875, 4.9181198,1.6393733, 0.081968663,-8.1148976
270, 1.8695325,1.8695325, 0,3.66575, 0.0366575,-3.6290925
315, 1.832875,1.90619, 2.5920766,2.5920766, 0.05184155,-5.1323118
296.56505, 1.7962175,1.979505, 4.9181198,1.6393733, 0.081968663,-8.1148976
33.690068, 3.592435,1.90619, 5.0834805,1.0166961, 0.13217049,-13.084879
198.43495, 3.1158875,1.832875, 8.1144835,1.159212, 0.11592121,-11.476198
206.56505, 3.1892025,1.8695325, 4.9181198,1.6393733, 0.081968663,-8.1148976
90, 3.1892025,1.8695325, 0,3.66575, 0.0366575,-3.6290925
161.56505, 3.299175,1.832875, 3.4776358,1.159212, 0.11592121,-11.476198
180, 3.4091475,1.832875, 0,3.66575, 0.1099725,-3.5557775
198.43495, 3.51912,1.8695325, 8.1144835,1.159212, 0.11592121,-11.476198
206.56505, 3.592435,1.90619, 4.9181198,1.6393733, 0.081968663,-8.1148976
321.34019, 3.592435,1.90619, 18.319807,0.57249396, 0.23472252,-23.23753
345.96376, 3.445805,1.9428475, 3.5562999,0.88907498, 0.15114275,-14.963132
0, 3.299175,1.9428475, 0,3.66575, 0.14663,-3.51912
18.434949, 3.1892025,1.90619, 8.1144835,1.159212, 0.11592121,-11.476198
345.96376, 3.0425725,1.9428475, 3.5562999,0.88907498, 0.15114275,-14.963132
326.30993, 2.9326,2.0161625, 8.1335689,1.0166961, 0.13217049,-13.084879
315, 3.2625175,2.19945, 2.5920766,2.5920766, 0.10368306,-5.0804702
341.56505, 3.152545,2.2361075, 3.4776358,1.159212, 0.11592121,-11.476198
161.56505, 3.51912,2.19945, 3.4776358,1.159212, 0.11592121,-11.476198
180, 3.592435,2.19945, 0,3.66575, 0.073315,-3.592435
225, 3.6290925,2.2361075, 2.5920766,2.5920766, 0.05184155,-5.1323118
26.565051, 1.5762725,2.3094225, 4.9181198,1.6393733, 0.081968663,-8.1148976
0, 1.5029575,2.3094225, 0,3.66575, 0.073315,-3.592435
288.43495, 1.4663,2.419395, 8.1144835,1.159212, 0.11592121,-11.476198
206.56505, 1.539615,2.4560525, 4.9181198,1.6393733, 0.081968663,-8.1148976
161.56505, 1.6495875,2.419395, 3.4776358,1.159212, 0.11592121,-11.476198
333.43495, 1.686245,2.1627925, 3.2787465,1.6393733, 0.081968663,-8.1148976
333.43495, 1.75956,2.272765, 3.2787465,1.6393733, 0.081968663,-8.1148976
0, 1.686245,2.272765, 0,3.66575, 0.073315,-3.592435
33.690068, 1.5762725,2.19945, 5.0834805,1.0166961, 0.13217049,-13.084879
345.96376, 3.445805,2.3827375, 3.5562999,0.88907498, 0.15114275,-14.963132
326.30993, 3.3358325,2.4560525, 8.1335689,1.0166961, 0.13217049,-13.084879
333.43495, 0.7698075,2.0894775, 3.2787465,1.6393733, 0.16393733,-8.0329289
0, 0.6964925,2.0894775, 0,3.66575, 0.073315,-3.592435
14.036243, 0.5498625,2.05282, 11.557975,0.88907498, 0.15114275,-14.963132
26.565051, 0.4765475,2.0161625, 4.9181198,1.6393733, 0.081968663,-8.1148976
345.96376, 1.2830125,0.3299175, 3.5562999,0.88907498, 0.15114275,-14.963132
345.96376, 1.1363825,0.366575, 3.5562999,0.88907498, 0.15114275,-14.963132
333.43495, 3.152545,1.5029575, 3.2787465,1.6393733, 0.16393733,-8.0329289
8.1301023, 2.8959425,1.4663, 22.291859,0.51841535, 0.25920768,-25.661559
26.565051, 2.8226275,1.4296425, 4.9181198,1.6393733, 0.081968663,-8.1148976
26.565051, 1.2830125,1.31967, 4.9181198,1.6393733, 0.16393733,-8.0329289
0, 1.1363825,1.31967, 0,3.66575, 0.14663,-3.51912
348.69007, 0.953095,1.3563275, 3.5945637,0.71891273, 0.18691733,-18.504814
135, 3.7024075,2.1627925, 2.5920766,2.5920766, 0.10368306,-5.0804702
108.43495, 3.6290925,2.2361075, 8.1144835,1.159212, 0.11592121,-11.476198
90, 3.592435,2.34608, 0,3.66575, 0.073315,-3.592435
153.43495, 3.592435,2.419395, 3.2787465,1.6393733, 0.16393733,-8.0329289
198.43495, 3.445805,2.49271, 8.1144835,1.159212, 0.11592121,-11.476198
236.30993, 3.3358325,2.4560525, 8.1335689,1.0166961, 0.13217049,-13.084879
198.43495, 3.2625175,2.34608, 8.1144835,1.159212, 0.23184237,-11.360277
56.309932, 3.3358325,2.126135, 8.1335689,1.0166961, 0.13217049,-13.084879
90, 3.4091475,2.2361075, 0,3.66575, 0.073315,-3.592435
63.434949, 3.4091475,2.3094225, 3.2787465,1.6393733, 0.081968663,-8.1148976
161.56505, 3.22586,2.419395, 3.4776358,1.159212, 0.11592121,-11.476198
135, 3.1158875,2.4560525, 2.5920766,2.5920766, 0.15552462,-5.0286288
45, 3.6290925,2.49271, 2.5920766,2.5920766, 0.10368306,-5.0804702
45, 1.02641,0.1099725, 2.5920766,2.5920766, 0.10368306,-5.0804702
71.565051, 1.099725,0.1832875, 3.4776358,1.159212, 0.11592121,-11.476198
90, 1.1363825,0.29326, 0,3.66575, 0.073315,-3.592435
26.565051, 1.1363825,0.366575, 4.9181198,1.6393733, 0.16393733,-8.0329289
341.56505, 1.2830125,0.43989, 3.4776358,1.159212, 0.11592121,-11.476198
303.69007, 1.392985,0.4032325, 5.0834805,1.0166961, 0.13217049,-13.084879
341.56505, 1.4663,0.29326, 3.4776358,1.159212, 0.23184237,-11.360277
123.69007, 1.392985,0.073315, 5.0834805,1.0166961, 0.13217049,-13.084879
90, 1.31967,0.1832875, 0,3.66575, 0.073315,-3.592435
116.56505, 1.31967,0.2566025, 4.9181198,1.6393733, 0.081968663,-8.1148976
18.434949, 1.5029575,0.366575, 8.1144835,1.159212, 0.11592121,-11.476198
45, 1.61293,0.4032325, 2.5920766,2.5920766, 0.15552462,-5.0286288
135, 1.099725,0.43989, 2.5920766,2.5920766, 0.10368306,-5.0804702
90, 0.3299175,1.90619, 0,3.66575, 0.1099725,-3.5557775
63.434949, 0.3299175,2.0161625, 3.2787465,1.6393733, 0.081968663,-8.1148976
45, 0.366575,2.0894775, 2.5920766,2.5920766, 0.05184155,-5.1323118
33.690068, 0.4032325,2.126135, 5.0834805,1.0166961, 0.13217049,-13.084879
18.434949, 0.513205,2.19945, 8.1144835,1.159212, 0.11592121,-11.476198
0, 0.6231775,2.2361075, 0,3.66575, 0.14663,-3.51912
315, 0.4032325,2.0894775, 2.5920766,2.5920766, 0.10368306,-5.0804702
333.43495, 0.4765475,2.0161625, 3.2787465,1.6393733, 0.16393733,-8.0329289
11.309932, 0.6231775,1.9428475, 15.097167,0.71891273, 0.18691733,-18.504814
14.036243, 0.806465,1.979505, 11.557975,0.88907498, 0.15114275,-14.963132
0, 0.953095,2.0161625, 0,3.66575, 0.1099725,-3.5557775
225, 1.099725,2.272765, 2.5920766,2.5920766, 0.05184155,-5.1323118
198.43495, 1.0630675,2.2361075, 8.1144835,1.159212, 0.11592121,-11.476198
213.69007, 0.953095,2.19945, 5.0834805,1.0166961, 0.13217049,-13.084879
206.56505, 0.8431225,2.126135, 4.9181198,1.6393733, 0.081968663,-8.1148976
341.56505, 0.806465,1.8695325, 3.4776358,1.159212, 0.11592121,-11.476198
348.69007, 0.9164375,1.832875, 3.5945637,0.71891273, 0.18691733,-18.504814
90, 1.5029575,0.73315, 0,3.66575, 0.1099725,-3.5557775
63.434949, 1.5029575,0.8431225, 3.2787465,1.6393733, 0.081968663,-8.1148976
45, 1.539615,0.9164375, 2.5920766,2.5920766, 0.05184155,-5.1323118
33.690068, 1.5762725,0.953095, 5.0834805,1.0166961, 0.13217049,-13.084879
18.434949, 1.686245,1.02641, 8.1144835,1.159212, 0.11592121,-11.476198
0, 1.7962175,1.0630675, 0,3.66575, 0.14663,-3.51912
315, 1.5762725,0.9164375, 2.5920766,2.5920766, 0.10368306,-5.0804702
333.43495, 1.6495875,0.8431225, 3.2787465,1.6393733, 0.16393733,-8.0329289
11.309932, 1.7962175,0.7698075, 15.097167,0.71891273, 0.18691733,-18.504814
14.036243, 1.979505,0.806465, 11.557975,0.88907498, 0.15114275,-14.963132
0, 2.126135,0.8431225, 0,3.66575, 0.1099725,-3.5557775
225, 2.272765,1.099725, 2.5920766,2.5920766, 0.05184155,-5.1323118
198.43495, 2.2361075,1.0630675, 8.1144835,1.159212, 0.11592121,-11.476198
213.69007, 2.126135,1.02641, 5.0834805,1.0166961, 0.13217049,-13.084879
206.56505, 2.0161625,0.953095, 4.9181198,1.6393733, 0.081968663,-8.1148976
341.56505, 1.979505,0.6964925, 3.4776358,1.159212, 0.11592121,-11.476198
348.69007, 2.0894775,0.659835, 3.5945637,0.71891273, 0.18691733,-18.504814
26.565051, 2.63934,0.7698075, 4.9181198,1.6393733, 0.16393733,-8.0329289
326.30993, 2.78597,0.659835, 8.1335689,1.0166961, 0.13217049,-13.084879
296.56505, 2.7493125,0.73315, 4.9181198,1.6393733, 0.081968663,-8.1148976
270, 2.7493125,0.7698075, 0,3.66575, 0.0366575,-3.6290925
231.34019, 2.7493125,0.7698075, 18.319807,0.57249396, 0.23472252,-23.23753
180, 2.7493125,0.7698075, 0,3.66575, 0.1099725,-3.5557775
63.434949, 2.7493125,0.7698075, 3.2787465,1.6393733, 0.081968663,-8.1148976
135, 2.8959425,0.58652, 2.5920766,2.5920766, 0.05184155,-5.1323118
326.30993, 3.005915,0.6964925, 8.1335689,1.0166961, 0.13217049,-13.084879
111.80141, 2.9326,0.806465, 8.1685523,0.68071269, 0.19740669,-19.543261
236.30993, 2.8226275,0.4765475, 8.1335689,1.0166961, 0.13217049,-13.084879
296.56505, 2.78597,0.5498625, 4.9181198,1.6393733, 0.081968663,-8.1148976
108.43495, 2.5293675,0.806465, 8.1144835,1.159212, 0.11592121,-11.476198
161.56505, 2.63934,0.7698075, 3.4776358,1.159212, 0.11592121,-11.476198
153.43495, 2.419395,1.099725, 3.2787465,1.6393733, 0.081968663,-8.1148976
143.1301, 2.566025,0.9897525, 13.1967,0.73315, 0.1832875,-18.145463
180, 2.6026825,0.9897525, 0,3.66575, 0.0366575,-3.6290925
146.30993, 2.712655,0.9164375, 8.1335689,1.0166961, 0.13217049,-13.084879
135, 2.78597,0.8431225, 2.5920766,2.5920766, 0.10368306,-5.0804702
255.96376, 3.0425725,0.9164375, 3.5562999,0.88907498, 0.15114275,-14.963132
233.1301, 3.152545,1.0630675, 13.1967,0.73315, 0.1832875,-18.145463
243.43495, 3.1892025,1.1363825, 3.2787465,1.6393733, 0.081968663,-8.1148976
296.56505, 3.07923,0.43989, 4.9181198,1.6393733, 0.081968663,-8.1148976
315, 3.005915,0.513205, 2.5920766,2.5920766, 0.10368306,-5.0804702
326.30993, 2.8959425,0.58652, 8.1335689,1.0166961, 0.13217049,-13.084879
270, 2.6026825,0.6964925, 0,3.66575, 0.1099725,-3.5557775
243.43495, 2.63934,0.7698075, 3.2787465,1.6393733, 0.081968663,-8.1148976
165.96376, 2.9326,0.806465, 3.5562999,0.88907498, 0.15114275,-14.963132
153.43495, 3.005915,0.7698075, 3.2787465,1.6393733, 0.081968663,-8.1148976
90, 3.005915,0.6964925, 0,3.66575, 0.073315,-3.592435
45, 2.8959425,0.58652, 2.5920766,2.5920766, 0.15552462,-5.0286288
18.434949, 2.78597,0.5498625, 8.1144835,1.159212, 0.11592121,-11.476198
0, 2.6759975,0.5498625, 0,3.66575, 0.1099725,-3.5557775
333.43495, 2.6026825,0.58652, 3.2787465,1.6393733, 0.081968663,-8.1148976
45, 2.5293675,0.513205, 2.5920766,2.5920766, 0.10368306,-5.0804702
45, 2.4560525,0.43989, 2.5920766,2.5920766, 0.10368306,-5.0804702
63.434949, 2.419395,0.366575, 3.2787465,1.6393733, 0.081968663,-8.1148976
225, 2.419395,0.366575, 2.5920766,2.5920766, 0.10368306,-5.0804702
315, 3.1158875,0.366575, 2.5920766,2.5920766, 0.10368306,-5.0804702
135, 0.073315,0.7698075, 2.5920766,2.5920766, 0.10368306,-5.0804702
45, 0.7698075,0.7698075, 2.5920766,2.5920766, 0.10368306,-5.0804702
243.43495, 0.7698075,0.7698075, 3.2787465,1.6393733, 0.081968663,-8.1148976
225, 0.73315,0.6964925, 2.5920766,2.5920766, 0.10368306,-5.0804702
225, 0.659835,0.6231775, 2.5920766,2.5920766, 0.10368306,-5.0804702
153.43495, 0.58652,0.5498625, 3.2787465,1.6393733, 0.081968663,-8.1148976
180, 0.513205,0.58652, 0,3.66575, 0.1099725,-3.5557775
198.43495, 0.4032325,0.58652, 8.1144835,1.159212, 0.11592121,-11.476198
225, 0.29326,0.5498625, 2.5920766,2.5920766, 0.15552462,-5.0286288
270, 0.1832875,0.43989, 0,3.66575, 0.073315,-3.592435
333.43495, 0.1832875,0.366575, 3.2787465,1.6393733, 0.081968663,-8.1148976
345.96376, 0.2566025,0.3299175, 3.5562999,0.88907498, 0.15114275,-14.963132
26.565051, 0.4032325,0.29326, 4.9181198,1.6393733, 0.081968663,-8.1148976
26.565051, 0.4765475,0.3299175, 4.9181198,1.6393733, 0.081968663,-8.1148976
63.434949, 0.5498625,0.366575, 3.2787465,1.6393733, 0.081968663,-8.1148976
90, 0.58652,0.43989, 0,3.66575, 0.1099725,-3.5557775
146.30993, 0.29326,0.5498625, 8.1335689,1.0166961, 0.13217049,-13.084879
135, 0.1832875,0.6231775, 2.5920766,2.5920766, 0.10368306,-5.0804702
116.56505, 0.1099725,0.6964925, 4.9181198,1.6393733, 0.081968663,-8.1148976
63.434949, 0,0, 3.2787465,1.6393733, 0.081968663,-8.1148976
53.130102, 0.0366575,0.073315, 13.1967,0.73315, 0.1832875,-18.145463
75.963757, 0.14663,0.219945, 3.5562999,0.88907498, 0.15114275,-14.963132
315, 0.4032325,0.29326, 2.5920766,2.5920766, 0.10368306,-5.0804702
326.30993, 0.4765475,0.219945, 8.1335689,1.0166961, 0.13217049,-13.084879
0, 0.58652,0.14663, 0,3.66575, 0.0366575,-3.6290925
323.1301, 0.6231775,0.14663, 13.1967,0.73315, 0.1832875,-18.145463
333.43495, 0.7698075,0.0366575, 3.2787465,1.6393733, 0.081968663,-8.1148976
341.56505, 0.5498625,0.366575, 3.4776358,1.159212, 0.11592121,-11.476198
288.43495, 0.659835,0.3299175, 8.1144835,1.159212, 0.11592121,-11.476198
116.56505, 0.4032325,0.58652, 4.9181198,1.6393733, 0.081968663,-8.1148976
56.309932, 0.366575,0.659835, 8.1335689,1.0166961, 0.13217049,-13.084879
291.80141, 0.2566025,0.3299175, 8.1685523,0.68071269, 0.19740669,-19.543261
146.30993, 0.1832875,0.43989, 8.1335689,1.0166961, 0.13217049,-13.084879
315, 1.8695325,2.1627925, 2.5920766,2.5920766, 0.10368306,-5.0804702
225, 1.3563275,2.19945, 2.5920766,2.5920766, 0.15552462,-5.0286288
198.43495, 1.4663,2.2361075, 8.1144835,1.159212, 0.11592121,-11.476198
296.56505, 1.6495875,2.34608, 4.9181198,1.6393733, 0.081968663,-8.1148976
270, 1.6495875,2.419395, 0,3.66575, 0.073315,-3.592435
303.69007, 1.5762725,2.5293675, 5.0834805,1.0166961, 0.13217049,-13.084879
161.56505, 1.5029575,2.3094225, 3.4776358,1.159212, 0.23184237,-11.360277
123.69007, 1.5762725,2.19945, 5.0834805,1.0166961, 0.13217049,-13.084879
161.56505, 1.686245,2.1627925, 3.4776358,1.159212, 0.11592121,-11.476198
206.56505, 1.832875,2.2361075, 4.9181198,1.6393733, 0.16393733,-8.0329289
270, 1.832875,2.3094225, 0,3.66575, 0.073315,-3.592435
251.56505, 1.8695325,2.419395, 3.4776358,1.159212, 0.11592121,-11.476198
225, 1.9428475,2.49271, 2.5920766,2.5920766, 0.10368306,-5.0804702
348.69007, 3.2625175,1.246355, 3.5945637,0.71891273, 0.18691733,-18.504814
341.56505, 3.152545,1.2830125, 3.4776358,1.159212, 0.11592121,-11.476198
206.56505, 3.1892025,1.539615, 4.9181198,1.6393733, 0.081968663,-8.1148976
213.69007, 3.299175,1.61293, 5.0834805,1.0166961, 0.13217049,-13.084879
198.43495, 3.4091475,1.6495875, 8.1144835,1.159212, 0.11592121,-11.476198
225, 3.445805,1.686245, 2.5920766,2.5920766, 0.05184155,-5.1323118
0, 3.299175,1.4296425, 0,3.66575, 0.1099725,-3.5557775
14.036243, 3.152545,1.392985, 11.557975,0.88907498, 0.15114275,-14.963132
11.309932, 2.9692575,1.3563275, 15.097167,0.71891273, 0.18691733,-18.504814
333.43495, 2.8226275,1.4296425, 3.2787465,1.6393733, 0.16393733,-8.0329289
315, 2.7493125,1.5029575, 2.5920766,2.5920766, 0.10368306,-5.0804702
0, 2.9692575,1.6495875, 0,3.66575, 0.14663,-3.51912
18.434949, 2.859285,1.61293, 8.1144835,1.159212, 0.11592121,-11.476198
33.690068, 2.7493125,1.539615, 5.0834805,1.0166961, 0.13217049,-13.084879
45, 2.712655,1.5029575, 2.5920766,2.5920766, 0.05184155,-5.1323118
63.434949, 2.6759975,1.4296425, 3.2787465,1.6393733, 0.081968663,-8.1148976
90, 2.6759975,1.31967, 0,3.66575, 0.1099725,-3.5557775
153.43495, 2.566025,1.2096975, 3.2787465,1.6393733, 0.081968663,-8.1148976
135, 2.6026825,1.17304, 2.5920766,2.5920766, 0.05184155,-5.1323118
333.43495, 2.19945,1.246355, 3.2787465,1.6393733, 0.081968663,-8.1148976
225, 2.4560525,1.3563275, 2.5920766,2.5920766, 0.05184155,-5.1323118
198.43495, 2.566025,1.392985, 8.1144835,1.159212, 0.11592121,-11.476198
341.56505, 2.3094225,1.31967, 3.4776358,1.159212, 0.11592121,-11.476198
14.036243, 2.1627925,1.2830125, 11.557975,0.88907498, 0.15114275,-14.963132
0, 2.126135,1.2830125, 0,3.66575, 0.0366575,-3.6290925
345.96376, 1.979505,1.31967, 3.5562999,0.88907498, 0.15114275,-14.963132
225, 1.90619,1.246355, 2.5920766,2.5920766, 0.05184155,-5.1323118
270, 1.90619,1.31967, 0,3.66575, 0.073315,-3.592435
315, 1.8695325,1.3563275, 2.5920766,2.5920766, 0.05184155,-5.1323118
315, 1.832875,1.392985, 2.5920766,2.5920766, 0.05184155,-5.1323118
0, 1.2096975,1.246355, 0,3.66575, 0.1099725,-3.5557775
315, 1.1363825,1.31967, 2.5920766,2.5920766, 0.10368306,-5.0804702
26.565051, 1.17304,1.5762725, 4.9181198,1.6393733, 0.081968663,-8.1148976
45, 1.099725,1.5029575, 2.5920766,2.5920766, 0.10368306,-5.0804702
116.56505, 1.1363825,1.4296425, 4.9181198,1.6393733, 0.081968663,-8.1148976
341.56505, 1.4663,1.2830125, 3.4776358,1.159212, 0.11592121,-11.476198
288.43495, 1.4296425,1.392985, 8.1144835,1.159212, 0.11592121,-11.476198
341.56505, 1.31967,1.4296425, 3.4776358,1.159212, 0.11592121,-11.476198
45, 0.953095,1.3563275, 2.5920766,2.5920766, 0.10368306,-5.0804702
11.309932, 0.7698075,1.31967, 15.097167,0.71891273, 0.18691733,-18.504814
26.565051, 1.4296425,1.4663, 4.9181198,1.6393733, 0.16393733,-8.0329289
18.434949, 1.31967,1.4296425, 8.1144835,1.159212, 0.11592121,-11.476198
0, 1.02641,1.4296425, 0,3.66575, 0.29326,-3.37249
345.96376, 0.87978,1.4663, 3.5562999,0.88907498, 0.15114275,-14.963132
333.43495, 0.806465,1.5029575, 3.2787465,1.6393733, 0.081968663,-8.1148976
315, 0.6964925,1.61293, 2.5920766,2.5920766, 0.15552462,-5.0286288
33.690068, 2.712655,2.19945, 5.0834805,1.0166961, 0.13217049,-13.084879
248.19859, 2.63934,2.0894775, 11.572116,0.68071269, 0.19740669,-19.543261
123.69007, 2.5293675,2.419395, 5.0834805,1.0166961, 0.13217049,-13.084879
63.434949, 2.49271,2.34608, 3.2787465,1.6393733, 0.081968663,-8.1148976
251.56505, 2.2361075,2.0894775, 3.4776358,1.159212, 0.11592121,-11.476198
198.43495, 2.34608,2.126135, 8.1144835,1.159212, 0.11592121,-11.476198
206.56505, 2.126135,1.7962175, 4.9181198,1.6393733, 0.081968663,-8.1148976
216.8699, 2.272765,1.90619, 5.13205,0.73315, 0.1832875,-18.145463
180, 2.3094225,1.90619, 0,3.66575, 0.0366575,-3.6290925
213.69007, 2.419395,1.979505, 5.0834805,1.0166961, 0.13217049,-13.084879
225, 2.49271,2.05282, 2.5920766,2.5920766, 0.10368306,-5.0804702
104.03624, 2.7493125,1.979505, 11.557975,0.88907498, 0.15114275,-14.963132
126.8699, 2.859285,1.832875, 5.13205,0.73315, 0.1832875,-18.145463
116.56505, 2.8959425,1.75956, 4.9181198,1.6393733, 0.081968663,-8.1148976
45, 2.8226275,2.5293675, 2.5920766,2.5920766, 0.10368306,-5.0804702
63.434949, 2.78597,2.4560525, 3.2787465,1.6393733, 0.081968663,-8.1148976
45, 2.712655,2.3827375, 2.5920766,2.5920766, 0.10368306,-5.0804702
33.690068, 2.6026825,2.3094225, 5.0834805,1.0166961, 0.13217049,-13.084879
90, 2.3094225,2.19945, 0,3.66575, 0.1099725,-3.5557775
116.56505, 2.34608,2.126135, 4.9181198,1.6393733, 0.081968663,-8.1148976
153.43495, 2.419395,2.0894775, 3.2787465,1.6393733, 0.081968663,-8.1148976
153.43495, 2.49271,2.05282, 3.2787465,1.6393733, 0.081968663,-8.1148976
194.03624, 2.63934,2.0894775, 11.557975,0.88907498, 0.15114275,-14.963132
206.56505, 2.712655,2.126135, 4.9181198,1.6393733, 0.081968663,-8.1148976
270, 2.712655,2.19945, 0,3.66575, 0.073315,-3.592435
315, 2.6026825,2.3094225, 2.5920766,2.5920766, 0.15552462,-5.0286288
341.56505, 2.49271,2.34608, 3.4776358,1.159212, 0.11592121,-11.476198
0, 2.3827375,2.34608, 0,3.66575, 0.1099725,-3.5557775
26.565051, 2.3094225,2.3094225, 4.9181198,1.6393733, 0.081968663,-8.1148976
315, 2.2361075,2.3827375, 2.5920766,2.5920766, 0.10368306,-5.0804702
315, 2.1627925,2.4560525, 2.5920766,2.5920766, 0.10368306,-5.0804702
296.56505, 2.126135,2.5293675, 4.9181198,1.6393733, 0.081968663,-8.1148976
315, 2.05282,2.6026825, 2.5920766,2.5920766, 0.10368306,-5.0804702
180, 0.1832875,1.7229025, 0,3.66575, 0.3299175,-3.3358325
90, 0.1832875,1.17304, 0,3.66575, 0.5498625,-3.1158875
0, -0.14663,1.17304, 0,3.66575, 0.3299175,-3.3358325
270, -0.14663,1.7229025, 0,3.66575, 0.5498625,-3.1158875
180, 0.5498625,1.7229025, 0,3.66575, 0.3299175,-3.3358325
90, 0.5498625,1.17304, 0,3.66575, 0.5498625,-3.1158875
0, 0.219945,1.17304, 0,3.66575, 0.3299175,-3.3358325
270, 0.219945,1.7229025, 0,3.66575, 0.5498625,-3.1158875
180, 3.6290925,0.2566025, 0,3.66575, 0.6964925,-2.9692575
90, 3.6290925,0, 0,3.66575, 0.2566025,-3.4091475
0, 2.9326,0, 0,3.66575, 0.6964925,-2.9692575
270, 2.9326,0.2566025, 0,3.66575, 0.2566025,-3.4091475
180, 3.6290925,0.8431225, 0,3.66575, 0.4032325,-3.2625175
90, 3.6290925,0.29326, 0,3.66575, 0.5498625,-3.1158875
0, 3.22586,0.29326, 0,3.66575, 0.4032325,-3.2625175
270, 3.22586,0.8431225, 0,3.66575, 0.5498625,-3.1158875
270, 1.75956,0.2566025, 0,3.66575, 0.2566025,-3.4091475
90, 2.8959425,0, 0,3.66575, 0.2566025,-3.4091475
0, 1.75956,0, 0,3.66575, 1.1363825,-2.5293675
180, 0.8431225,0, 0,3.66575, 0.8431225,-2.8226275
270, 0.8431225,0.8431225, 0,3.66575, 0.8431225,-2.8226275
0, 0,0.8431225, 0,3.66575, 0.8431225,-2.8226275
90, 0,0, 0,3.66575, 0.8431225,-2.8226275
180, 1.7229025,0, 0,3.66575, 0.8431225,-2.8226275
270, 1.7229025,0.5498625, 0,3.66575, 0.5498625,-3.1158875
0, 0.87978,0.5498625, 0,3.66575, 0.8431225,-2.8226275
90, 0.87978,0, 0,3.66575, 0.5498625,-3.1158875
180, 1.4296425,0.58652, 0,3.66575, 0.5498625,-3.1158875
270, 1.4296425,0.8431225, 0,3.66575, 0.2566025,-3.4091475
0, 0.87978,0.8431225, 0,3.66575, 0.5498625,-3.1158875
90, 0.87978,0.58652, 0,3.66575, 0.2566025,-3.4091475
180, 1.4296425,1.1363825, 0,3.66575, 0.8431225,-2.8226275
90, 1.4296425,0.87978, 0,3.66575, 0.2566025,-3.4091475
0, 0.58652,0.87978, 0,3.66575, 0.8431225,-2.8226275
270, 0.58652,1.1363825, 0,3.66575, 0.2566025,-3.4091475
180, 2.3094225,0.58652, 0,3.66575, 0.8431225,-2.8226275
270, 2.3094225,1.1363825, 0,3.66575, 0.5498625,-3.1158875
0, 1.4663,1.1363825, 0,3.66575, 0.8431225,-2.8226275
90, 1.4663,0.58652, 0,3.66575, 0.5498625,-3.1158875
180, 1.7229025,1.17304, 0,3.66575, 1.1363825,-2.5293675
270, 1.7229025,1.7229025, 0,3.66575, 0.5498625,-3.1158875
0, 0.58652,1.7229025, 0,3.66575, 1.1363825,-2.5293675
90, 0.58652,1.17304, 0,3.66575, 0.5498625,-3.1158875
180, 2.6026825,1.4296425, 0,3.66575, 0.8431225,-2.8226275
90, 2.6026825,1.17304, 0,3.66575, 0.2566025,-3.4091475
0, 1.75956,1.17304, 0,3.66575, 0.8431225,-2.8226275
270, 1.75956,1.4296425, 0,3.66575, 0.2566025,-3.4091475
90, 1.75956,1.4663, 0,3.66575, 0.5498625,-3.1158875
180, 2.0161625,1.4663, 0,3.66575, 0.2566025,-3.4091475
270, 2.0161625,2.0161625, 0,3.66575, 0.5498625,-3.1158875
0, 1.75956,2.0161625, 0,3.66575, 0.2566025,-3.4091475
180, 2.6026825,1.4663, 0,3.66575, 0.5498625,-3.1158875
270, 2.6026825,1.7229025, 0,3.66575, 0.2566025,-3.4091475
0, 2.05282,1.7229025, 0,3.66575, 0.5498625,-3.1158875
90, 2.05282,1.4663, 0,3.66575, 0.2566025,-3.4091475
180, 3.1892025,0.29326, 0,3.66575, 0.8431225,-2.8226275
270, 3.1892025,1.1363825, 0,3.66575, 0.8431225,-2.8226275
0, 2.34608,1.1363825, 0,3.66575, 0.8431225,-2.8226275
90, 2.34608,0.29326, 0,3.66575, 0.8431225,-2.8226275
180, 2.3094225,0.29326, 0,3.66575, 0.5498625,-3.1158875
270, 2.3094225,0.5498625, 0,3.66575, 0.2566025,-3.4091475
0, 1.75956,0.5498625, 0,3.66575, 0.5498625,-3.1158875
90, 1.75956,0.29326, 0,3.66575, 0.2566025,-3.4091475
180, 2.8959425,1.75956, 0,3.66575, 0.8431225,-2.8226275
270, 2.8959425,2.6026825, 0,3.66575, 0.8431225,-2.8226275
0, 2.05282,2.6026825, 0,3.66575, 0.8431225,-2.8226275
90, 2.05282,1.75956, 0,3.66575, 0.8431225,-2.8226275
180, 1.7229025,1.75956, 0,3.66575, 0.5498625,-3.1158875
270, 1.7229025,2.0161625, 0,3.66575, 0.2566025,-3.4091475
0, 1.17304,2.0161625, 0,3.66575, 0.5498625,-3.1158875
90, 1.17304,1.75956, 0,3.66575, 0.2566025,-3.4091475
180, 1.1363825,1.75956, 0,3.66575, 0.9897525,-2.6759975
270, 1.1363825,2.3094225, 0,3.66575, 0.5498625,-3.1158875
0, 0.14663,2.3094225, 0,3.66575, 0.9897525,-2.6759975
90, 0.14663,1.75956, 0,3.66575, 0.5498625,-3.1158875
180, 2.0161625,2.05282, 0,3.66575, 0.8431225,-2.8226275
270, 2.0161625,2.6026825, 0,3.66575, 0.5498625,-3.1158875
0, 1.17304,2.6026825, 0,3.66575, 0.8431225,-2.8226275
90, 1.17304,2.05282, 0,3.66575, 0.5498625,-3.1158875
180, 3.4824625,1.17304, 0,3.66575, 0.8431225,-2.8226275
270, 3.4824625,1.7229025, 0,3.66575, 0.5498625,-3.1158875
0, 2.63934,1.7229025, 0,3.66575, 0.8431225,-2.8226275
90, 2.63934,1.17304, 0,3.66575, 0.5498625,-3.1158875
180, 3.7757225,2.0161625, 0,3.66575, 0.8431225,-2.8226275
90, 3.7757225,1.75956, 0,3.66575, 0.2566025,-3.4091475
0, 2.9326,1.75956, 0,3.66575, 0.8431225,-2.8226275
270, 2.9326,2.0161625, 0,3.66575, 0.2566025,-3.4091475
180, 3.7757225,2.05282, 0,3.66575, 0.8431225,-2.8226275
270, 3.7757225,2.6026825, 0,3.66575, 0.5498625,-3.1158875
0, 2.9326,2.6026825, 0,3.66575, 0.8431225,-2.8226275
90, 2.9326,2.05282, 0,3.66575, 0.5498625,-3.1158875
0, 1.75956,0.2566025, 0,3.66575, 1.1363825,-2.5293675
90, 0.87978,2.34608, 0,3.66575, 0.5498625,-3.1158875
180, 1.1363825,2.34608, 0,3.66575, 0.2566025,-3.4091475
270, 1.1363825,2.8959425, 0,3.66575, 0.5498625,-3.1158875
0, 0.87978,2.8959425, 0,3.66575, 0.2566025,-3.4091475
180, 0.8431225,2.6026825, 0,3.66575, 0.6964925,-2.9692575
90, 0.8431225,2.34608, 0,3.66575, 0.2566025,-3.4091475
0, 0.14663,2.34608, 0,3.66575, 0.6964925,-2.9692575
270, 0.14663,2.6026825, 0,3.66575, 0.2566025,-3.4091475
180, 0.8431225,2.8959425, 0,3.66575, 0.6964925,-2.9692575
90, 0.8431225,2.63934, 0,3.66575, 0.2566025,-3.4091475
0, 0.14663,2.63934, 0,3.66575, 0.6964925,-2.9692575
270, 0.14663,2.8959425, 0,3.66575, 0.2566025,-3.4091475
180, 3.1892025,3.22586, 0,3.66575, 0.8431225,-2.8226275
270, 3.1892025,3.6290925, 0,3.66575, 0.4032325,-3.2625175
0, 2.34608,3.6290925, 0,3.66575, 0.8431225,-2.8226275
90, 2.34608,3.22586, 0,3.66575, 0.4032325,-3.2625175
90, 2.34608,2.63934, 0,3.66575, 0.5498625,-3.1158875
180, 2.6026825,2.63934, 0,3.66575, 0.2566025,-3.4091475
270, 2.6026825,3.1892025, 0,3.66575, 0.5498625,-3.1158875
0, 2.34608,3.1892025, 0,3.66575, 0.2566025,-3.4091475
180, 3.1892025,2.9326, 0,3.66575, 0.5498625,-3.1158875
270, 3.1892025,3.1892025, 0,3.66575, 0.2566025,-3.4091475
0, 2.63934,3.1892025, 0,3.66575, 0.5498625,-3.1158875
90, 2.63934,2.9326, 0,3.66575, 0.2566025,-3.4091475
180, 3.1892025,2.63934, 0,3.66575, 0.5498625,-3.1158875
270, 3.1892025,2.8959425, 0,3.66575, 0.2566025,-3.4091475
0, 2.63934,2.8959425, 0,3.66575, 0.5498625,-3.1158875
90, 2.63934,2.63934, 0,3.66575, 0.2566025,-3.4091475
90, 3.22586,2.63934, 0,3.66575, 0.9897525,-2.6759975
180, 3.7757225,2.63934, 0,3.66575, 0.5498625,-3.1158875
270, 3.7757225,3.6290925, 0,3.66575, 0.9897525,-2.6759975
0, 3.22586,3.6290925, 0,3.66575, 0.5498625,-3.1158875
90, 1.75956,2.63934, 0,3.66575, 0.9897525,-2.6759975
180, 2.3094225,2.63934, 0,3.66575, 0.5498625,-3.1158875
270, 2.3094225,3.6290925, 0,3.66575, 0.9897525,-2.6759975
0, 1.75956,3.6290925, 0,3.66575, 0.5498625,-3.1158875
90, 1.17304,2.63934, 0,3.66575, 0.9897525,-2.6759975
180, 1.7229025,2.63934, 0,3.66575, 0.5498625,-3.1158875
270, 1.7229025,3.6290925, 0,3.66575, 0.9897525,-2.6759975
0, 1.17304,3.6290925, 0,3.66575, 0.5498625,-3.1158875
180, 1.1363825,2.9326, 0,3.66575, 0.9897525,-2.6759975
270, 1.1363825,3.6290925, 0,3.66575, 0.6964925,-2.9692575
0, 0.14663,3.6290925, 0,3.66575, 0.9897525,-2.6759975
90, 0.14663,2.9326, 0,3.66575, 0.6964925,-2.9692575
180, 0.5498625,1.1363825, 0,3.66575, 0.9897525,-2.6759975
90, 0.5498625,0.87978, 0,3.66575, 0.2566025,-3.4091475
0, -0.43989,0.87978, 0,3.66575, 0.9897525,-2.6759975
270, -0.43989,1.1363825, 0,3.66575, 0.2566025,-3.4091475
;; (c)1997 STONE PRODUCTS CORPORATION
*DFSTN, DRESSED FIELDSTONE
;%TYPE=MODEL
0, 2.54475,0.234, 0,2.925, 0.02925,-2.89575
0, 1.78425,1.43325, 0,2.925, 0.02925,-2.89575
180, 2.808,1.55025, 0,2.925, 0.02925,-2.89575
0, 2.25225,1.78425, 0,2.925, 0.02925,-2.89575
0, 2.223,1.8135, 0,2.925, 0.02925,-2.89575
0, 0.20475,2.2815, 0,2.925, 0.02925,-2.89575
0, 0.6435,2.8665, 0,2.925, 0.02925,-2.89575
0, 0.73125,2.42775, 0,2.925, 0.08775,-2.83725
0, 0.702,2.457, 0,2.925, 0.02925,-2.89575
0, 0.08775,3.07125, 0,2.925, 0.02925,-2.89575
0, 1.9305,2.72025, 0,2.925, 0.02925,-2.89575
0, 1.872,2.691, 0,2.925, 0.0585,-2.8665
0, 2.13525,3.042, 0,2.925, 0.0585,-2.8665
0, 2.574,2.6325, 0,2.925, 0.02925,-2.89575
0, 2.72025,2.223, 0,2.925, 0.02925,-2.89575
0, 1.19925,1.55025, 0,2.925, 0.02925,-2.89575
0, 0.8775,1.25775, 0,2.925, 0.02925,-2.89575
0, 0.9945,0.49725, 0,2.925, 0.02925,-2.89575
0, 1.02375,0.468, 0,2.925, 0.0585,-2.8665
0, 0.585,0.73125, 0,2.925, 0.02925,-2.89575
0, 0.468,0.6435, 0,2.925, 0.0585,-2.8665
0, 0.55575,0.96525, 0,2.925, 0.02925,-2.89575
0, 1.4625,2.54475, 0,2.925, 0.02925,-2.89575
0, 1.14075,2.808, 0,2.925, 0.0585,-2.8665
0, 1.2285,2.83725, 0,2.925, 0.0585,-2.8665
0, 1.66725,0.73125, 0,2.925, 0.117,-2.808
0, 1.5795,0.7605, 0,2.925, 0.1755,-2.7495
0, 1.872,0.38025, 0,2.925, 0.0585,-2.8665
0, 1.84275,0.351, 0,2.925, 0.0585,-2.8665
0, 1.638,1.872, 0,2.925, 0.02925,-2.89575
0, 1.95975,2.34, 0,2.925, 0.117,-2.808
0, 2.07675,2.36925, 0,2.925, 0.08775,-2.83725
0, 0.55575,1.9305, 0,2.925, 0.02925,-2.89575
0, 0.8775,2.07675, 0,2.925, 0.0585,-2.8665
0, 0.819,2.106, 0,2.925, 0.08775,-2.83725
0, 0.08775,1.872, 0,2.925, 0.0585,-2.8665
0, 0.0585,1.90125, 0,2.925, 0.0585,-2.8665
0, 2.77875,0.9945, 0,2.925, 0.08775,-2.83725
0, 2.5155,1.17, 0,2.925, 0.0585,-2.8665
345.96376, 2.574,1.19925, 2.8376668,0.70941672, 0.12060085,-11.939483
0, 2.48625,1.19925, 0,2.925, 0.08775,-2.83725
315, 1.287,0.61425, 2.0682873,2.0682873, 0.16546298,-3.9711117
319.39871, 1.08225,0.78975, 22.842777,0.3172608, 0.26967166,-26.697496
319.39871, 0.8775,0.96525, 22.842777,0.3172608, 0.26967166,-26.697496
321.34019, 0.73125,1.08225, 14.617864,0.45680825, 0.18729138,-18.541847
333.43495, 0.55575,1.17, 2.6161995,1.3080998, 0.19621497,-6.3442839
0, 0.468,1.17, 0,2.925, 0.08775,-2.83725
57.994617, 0.32175,0.936, 17.052716,0.31004939, 0.27594394,-27.318451
66.037511, 0.20475,0.67275, 22.274157,0.29698876, 0.2880791,-28.51983
90, 0.20475,0.55575, 0,2.925, 0.117,-2.808
135, 0.26325,0.49725, 2.0682873,2.0682873, 0.08273149,-4.0538432
164.0546, 0.468,0.43875, 12.053389,0.40177964, 0.21294322,-21.081378
165.96376, 0.702,0.38025, 2.8376668,0.70941672, 0.24120167,-11.818882
168.69007, 0.9945,0.32175, 2.8681985,0.57363971, 0.29829264,-14.616339
167.47119, 1.25775,0.26325, 14.911257,0.3172608, 0.26967166,-26.697496
173.65981, 1.521,0.234, 2.9071099,0.32301223, 0.26487001,-26.222132
180, 1.55025,0.234, 0,2.925, 0.02925,-2.89575
225, 1.60875,0.2925, 2.0682873,2.0682873, 0.08273149,-4.0538432
270, 1.60875,0.351, 0,2.925, 0.0585,-2.8665
326.30993, 1.521,0.4095, 6.4899923,0.81124904, 0.10546237,-10.440775
323.1301, 1.404,0.49725, 10.53,0.585, 0.14625,-14.47875
324.46232, 0.49725,1.287, 10.540755,0.34002435, 0.25161801,-24.910183
281.30993, 0.468,1.43325, 12.046434,0.57363971, 0.14914633,-14.765486
288.43495, 0.43875,1.521, 6.4747635,0.92496623, 0.092496632,-9.1571655
255.96376, 0.468,1.638, 2.8376668,0.70941672, 0.12060085,-11.939483
185.71059, 0.7605,1.66725, 26.485402,0.29104838, 0.29395887,-29.101927
180, 1.14075,1.66725, 0,2.925, 0.38025,-2.54475
180, 1.2285,1.66725, 0,2.925, 0.08775,-2.83725
161.56505, 1.31625,1.638, 2.7748987,0.92496623, 0.092496632,-9.1571655
116.56505, 1.3455,1.5795, 3.9242993,1.3080998, 0.065404989,-6.4750939
90, 1.3455,1.43325, 0,2.925, 0.14625,-2.77875
68.198591, 1.287,1.287, 9.2337007,0.54315887, 0.15751608,-15.594091
59.036243, 1.19925,1.14075, 6.5212337,0.50163338, 0.17055535,-16.884979
63.434949, 1.1115,0.96525, 2.6161995,1.3080998, 0.19621497,-6.3442839
26.565051, 1.053,0.936, 3.9242993,1.3080998, 0.065404989,-6.4750939
0, 0.9945,0.936, 0,2.925, 0.0585,-2.8665
333.43495, 0.936,0.96525, 2.6161995,1.3080998, 0.065404989,-6.4750939
321.34019, 0.78975,1.08225, 14.617864,0.45680825, 0.18729138,-18.541847
326.30993, 0.702,1.14075, 6.4899923,0.81124904, 0.10546237,-10.440775
206.56505, 1.2285,1.72575, 3.9242993,1.3080998, 0.065404989,-6.4750939
243.43495, 1.25775,1.78425, 2.6161995,1.3080998, 0.065404989,-6.4750939
278.74616, 1.19925,2.1645, 17.790691,0.22238363, 0.38472367,-38.087645
288.43495, 1.17,2.25225, 6.4747635,0.92496623, 0.092496632,-9.1571655
315, 1.1115,2.31075, 2.0682873,2.0682873, 0.08273149,-4.0538432
0, 0.9945,2.31075, 0,2.925, 0.117,-2.808
14.036243, 0.8775,2.2815, 9.2224172,0.70941672, 0.12060085,-11.939483
10.00798, 0.38025,2.19375, 32.702055,0.16944069, 0.5049333,-49.988395
21.801409, 0.234,2.13525, 6.5179064,0.54315887, 0.15751608,-15.594091
45, 0.20475,2.106, 2.0682873,2.0682873, 0.04136576,-4.0952089
107.10273, 0.32175,1.72575, 9.2471619,0.21505027, 0.39784303,-39.386458
116.56505, 0.351,1.66725, 3.9242993,1.3080998, 0.065404989,-6.4750939
180, 0.4095,1.66725, 0,2.925, 0.0585,-2.8665
189.46232, 0.585,1.6965, 14.906878,0.48086705, 0.17792082,-17.61416
194.03624, 0.702,1.72575, 9.2224172,0.70941672, 0.12060085,-11.939483
180, 0.8775,1.72575, 0,2.925, 0.1755,-2.7495
174.28941, 1.17,1.6965, 2.9104838,0.29104838, 0.29395887,-29.101927
225, 1.287,2.13525, 2.0682873,2.0682873, 0.08273149,-4.0538432
201.80141, 1.43325,2.19375, 6.5179064,0.54315887, 0.15751608,-15.594091
206.56505, 1.66725,2.31075, 3.9242993,1.3080998, 0.26161996,-6.2788789
212.47119, 1.989,2.5155, 10.543851,0.22433726, 0.38137335,-37.755961
220.60129, 2.19375,2.691, 4.1243903,0.3172608, 0.26967166,-26.697496
206.56505, 2.31075,2.7495, 3.9242993,1.3080998, 0.13080998,-6.4096889
161.56505, 2.3985,2.72025, 2.7748987,0.92496623, 0.092496632,-9.1571655
98.130102, 2.42775,2.5155, 17.787271,0.41365748, 0.20682874,-20.476045
90, 2.42775,2.34, 0,2.925, 0.1755,-2.7495
59.036243, 2.34,2.19375, 6.5212337,0.50163338, 0.17055535,-16.884979
41.185925, 2.106,1.989, 4.1274128,0.27516086, 0.31093177,-30.782245
41.633539, 1.84275,1.755, 4.1294365,0.24290803, 0.35221665,-34.869447
41.633539, 1.5795,1.521, 4.1294365,0.24290803, 0.35221665,-34.869447
18.434949, 1.49175,1.49175, 6.4747635,0.92496623, 0.092496632,-9.1571655
333.43495, 1.37475,1.55025, 2.6161995,1.3080998, 0.13080998,-6.4096889
291.80141, 1.31625,1.6965, 6.5179064,0.54315887, 0.15751608,-15.594091
281.30993, 1.287,1.84275, 12.046434,0.57363971, 0.14914633,-14.765486
284.03624, 1.25775,1.95975, 9.2224172,0.70941672, 0.12060085,-11.939483
284.03624, 1.2285,2.07675, 9.2224172,0.70941672, 0.12060085,-11.939483
270, 1.287,1.25775, 0,2.925, 0.02925,-2.89575
243.43495, 1.3455,1.37475, 2.6161995,1.3080998, 0.13080998,-6.4096889
218.65981, 1.49175,1.49175, 4.1112743,0.45680825, 0.18729138,-18.541847
198.43495, 1.5795,1.521, 6.4747635,0.92496623, 0.092496632,-9.1571655
216.8699, 1.6965,1.60875, 4.095,0.585, 0.14625,-14.47875
213.69007, 1.872,1.72575, 4.0562452,0.81124904, 0.21092476,-10.335313
180, 1.95975,1.72575, 0,2.925, 0.08775,-2.83725
135, 2.0475,1.638, 2.0682873,2.0682873, 0.12409725,-4.0124774
116.56505, 2.106,1.521, 3.9242993,1.3080998, 0.13080998,-6.4096889
78.690068, 2.07675,1.37475, 2.8681985,0.57363971, 0.14914633,-14.765486
38.659808, 1.9305,1.25775, 4.1112743,0.45680825, 0.18729138,-18.541847
8.1301023, 1.72575,1.2285, 17.787271,0.41365748, 0.20682874,-20.476045
8.1301023, 1.521,1.19925, 17.787271,0.41365748, 0.20682874,-20.476045
9.4623222, 1.3455,1.17, 14.906878,0.48086705, 0.17792082,-17.61416
315, 1.287,1.2285, 2.0682873,2.0682873, 0.08273149,-4.0538432
296.56505, 1.95975,1.78425, 3.9242993,1.3080998, 0.065404989,-6.4750939
243.43495, 1.989,1.84275, 2.6161995,1.3080998, 0.065404989,-6.4750939
233.1301, 2.07675,1.95975, 10.53,0.585, 0.14625,-14.47875
206.56505, 2.19375,2.01825, 3.9242993,1.3080998, 0.13080998,-6.4096889
180, 2.2815,2.01825, 0,2.925, 0.08775,-2.83725
150.25512, 2.48625,1.90125, 6.5304288,0.36280159, 0.23582105,-23.346283
158.19859, 2.6325,1.84275, 9.2337007,0.54315887, 0.15751608,-15.594091
153.43495, 2.8665,1.72575, 2.6161995,1.3080998, 0.26161996,-6.2788789
143.1301, 2.9835,1.638, 10.53,0.585, 0.14625,-14.47875
116.56505, 3.042,1.521, 3.9242993,1.3080998, 0.13080998,-6.4096889
63.434949, 3.01275,1.4625, 2.6161995,1.3080998, 0.065404989,-6.4750939
26.565051, 2.95425,1.43325, 3.9242993,1.3080998, 0.065404989,-6.4750939
350.53768, 2.77875,1.4625, 2.8852022,0.48086705, 0.17792082,-17.61416
344.0546, 2.574,1.521, 12.053389,0.40177964, 0.21294322,-21.081378
344.0546, 2.36925,1.5795, 12.053389,0.40177964, 0.21294322,-21.081378
343.30076, 2.07675,1.66725, 21.292478,0.28016419, 0.30537898,-30.232518
326.30993, 1.989,1.72575, 6.4899923,0.81124904, 0.10546237,-10.440775
213.69007, 2.60325,2.36925, 4.0562452,0.81124904, 0.21092476,-10.335313
198.43495, 2.691,2.3985, 6.4747635,0.92496623, 0.092496632,-9.1571655
180, 2.7495,2.3985, 0,2.925, 0.0585,-2.8665
119.74488, 2.8665,2.19375, 17.051675,0.36280159, 0.23582105,-23.346283
90, 2.8665,2.0475, 0,2.925, 0.14625,-2.77875
78.690068, 2.83725,1.90125, 2.8681985,0.57363971, 0.14914633,-14.765486
45, 2.77875,1.84275, 2.0682873,2.0682873, 0.08273149,-4.0538432
0, 2.691,1.84275, 0,2.925, 0.08775,-2.83725
338.19859, 2.54475,1.90125, 9.2337007,0.54315887, 0.15751608,-15.594091
333.43495, 2.42775,1.95975, 2.6161995,1.3080998, 0.13080998,-6.4096889
329.03624, 2.2815,2.0475, 6.5212337,0.50163338, 0.17055535,-16.884979
270, 2.2815,2.106, 0,2.925, 0.0585,-2.8665
213.69007, 2.36925,2.1645, 4.0562452,0.81124904, 0.10546237,-10.440775
236.30993, 2.42775,2.25225, 6.4899923,0.81124904, 0.10546237,-10.440775
80.537678, -0.02925,2.01825, 2.8852022,0.48086705, 0.17792082,-17.61416
74.054604, -0.08775,1.8135, 12.053389,0.40177964, 0.21294322,-21.081378
90, -0.08775,1.755, 0,2.925, 0.0585,-2.8665
153.43495, 0.02925,1.6965, 2.6161995,1.3080998, 0.13080998,-6.4096889
171.8699, 0.234,1.66725, 2.8956023,0.41365748, 0.20682874,-20.476045
206.56505, 0.2925,1.6965, 3.9242993,1.3080998, 0.065404989,-6.4750939
284.03624, 0.234,1.9305, 9.2224172,0.70941672, 0.24120167,-11.818882
291.80141, 0.1755,2.07675, 6.5179064,0.54315887, 0.15751608,-15.594091
288.43495, 0.14625,2.1645, 6.4747635,0.92496623, 0.092496632,-9.1571655
333.43495, 0.08775,2.19375, 2.6161995,1.3080998, 0.065404989,-6.4750939
0, 0,2.19375, 0,2.925, 0.08775,-2.83725
198.43495, 0.234,1.638, 6.4747635,0.92496623, 0.092496632,-9.1571655
180, 0.351,1.638, 0,2.925, 0.117,-2.808
153.43495, 0.4095,1.60875, 2.6161995,1.3080998, 0.065404989,-6.4750939
101.30993, 0.468,1.31625, 12.046434,0.57363971, 0.29829264,-14.616339
78.690068, 0.43875,1.17, 2.8681985,0.57363971, 0.14914633,-14.765486
45, 0.4095,1.14075, 2.0682873,2.0682873, 0.04136576,-4.0952089
0, 0.38025,1.14075, 0,2.925, 0.02925,-2.89575
326.30993, 0.2925,1.19925, 6.4899923,0.81124904, 0.10546237,-10.440775
306.8699, 0.20475,1.31625, 4.095,0.585, 0.14625,-14.47875
285.9454, 0.14625,1.521, 9.2409319,0.40177964, 0.21294322,-21.081378
270, 0.14625,1.60875, 0,2.925, 0.08775,-2.83725
0, 2.1645,1.5795, 0,2.925, 0.117,-2.808
63.434949, 2.13525,1.521, 2.6161995,1.3080998, 0.065404989,-6.4750939
71.565051, 2.106,1.43325, 2.7748987,0.92496623, 0.092496632,-9.1571655
68.198591, 2.0475,1.287, 9.2337007,0.54315887, 0.15751608,-15.594091
90, 2.0475,1.2285, 0,2.925, 0.0585,-2.8665
135, 2.07675,1.19925, 2.0682873,2.0682873, 0.04136576,-4.0952089
135, 2.13525,1.14075, 2.0682873,2.0682873, 0.08273149,-4.0538432
141.34019, 2.2815,1.02375, 14.617864,0.45680825, 0.18729138,-18.541847
108.43495, 2.34,0.84825, 6.4747635,0.92496623, 0.18499323,-9.0646689
135, 2.457,0.73125, 2.0682873,2.0682873, 0.16546298,-3.9711117
167.47119, 2.72025,0.67275, 14.911257,0.3172608, 0.26967166,-26.697496
168.69007, 2.8665,0.6435, 2.8681985,0.57363971, 0.14914633,-14.765486
191.30993, 3.01275,0.67275, 12.046434,0.57363971, 0.14914633,-14.765486
216.8699, 3.12975,0.7605, 4.095,0.585, 0.14625,-14.47875
248.19859, 3.18825,0.90675, 9.2337007,0.54315887, 0.15751608,-15.594091
260.53768, 3.2175,1.08225, 2.8852022,0.48086705, 0.17792082,-17.61416
270, 3.2175,1.17, 0,2.925, 0.08775,-2.83725
315, 3.1005,1.287, 2.0682873,2.0682873, 0.16546298,-3.9711117
296.56505, 3.07125,1.3455, 3.9242993,1.3080998, 0.065404989,-6.4750939
326.30993, 2.9835,1.404, 6.4899923,0.81124904, 0.10546237,-10.440775
345.96376, 2.7495,1.4625, 2.8376668,0.70941672, 0.24120167,-11.818882
347.47119, 2.48625,1.521, 14.911257,0.3172608, 0.26967166,-26.697496
344.0546, 2.2815,1.5795, 12.053389,0.40177964, 0.21294322,-21.081378
270, 1.8135,2.5155, 0,2.925, 0.08775,-2.83725
282.52881, 1.755,2.77875, 12.05591,0.3172608, 0.26967166,-26.697496
303.69007, 1.638,2.95425, 4.0562452,0.81124904, 0.21092476,-10.335313
319.39871, 1.43325,3.12975, 22.842777,0.3172608, 0.26967166,-26.697496
341.56505, 1.3455,3.159, 2.7748987,0.92496623, 0.092496632,-9.1571655
352.87498, 1.1115,3.18825, 2.9024128,0.36280159, 0.23582105,-23.346283
345.96376, 0.9945,3.2175, 2.8376668,0.70941672, 0.12060085,-11.939483
26.565051, 0.8775,3.159, 3.9242993,1.3080998, 0.13080998,-6.4096889
36.869898, 0.7605,3.07125, 4.095,0.585, 0.14625,-14.47875
71.565051, 0.73125,2.9835, 2.7748987,0.92496623, 0.092496632,-9.1571655
108.43495, 0.7605,2.89575, 6.4747635,0.92496623, 0.092496632,-9.1571655
135, 0.84825,2.808, 2.0682873,2.0682873, 0.12409725,-4.0124774
141.34019, 0.9945,2.691, 14.617864,0.45680825, 0.18729138,-18.541847
126.8699, 1.08225,2.574, 4.095,0.585, 0.14625,-14.47875
110.55605, 1.17,2.34, 15.747886,0.34234536, 0.24991212,-24.741299
116.56505, 1.19925,2.2815, 3.9242993,1.3080998, 0.065404989,-6.4750939
123.69007, 1.25775,2.19375, 4.0562452,0.81124904, 0.10546237,-10.440775
135, 1.287,2.1645, 2.0682873,2.0682873, 0.04136576,-4.0952089
198.43495, 1.4625,2.223, 6.4747635,0.92496623, 0.18499323,-9.0646689
206.56505, 1.5795,2.2815, 3.9242993,1.3080998, 0.13080998,-6.4096889
210.96376, 1.72575,2.36925, 10.534301,0.50163338, 0.17055535,-16.884979
213.69007, 1.8135,2.42775, 4.0562452,0.81124904, 0.10546237,-10.440775
278.1301, 1.8135,2.691, 17.787271,0.41365748, 0.20682874,-20.476045
284.03624, 1.78425,2.808, 9.2224172,0.70941672, 0.12060085,-11.939483
288.43495, 1.755,2.89575, 6.4747635,0.92496623, 0.092496632,-9.1571655
236.30993, 1.8135,2.9835, 6.4899923,0.81124904, 0.10546237,-10.440775
213.69007, 1.90125,3.042, 4.0562452,0.81124904, 0.10546237,-10.440775
225, 1.989,3.12975, 2.0682873,2.0682873, 0.12409725,-4.0124774
213.69007, 2.07675,3.18825, 4.0562452,0.81124904, 0.10546237,-10.440775
180, 2.25225,3.18825, 0,2.925, 0.1755,-2.7495
135, 2.31075,3.12975, 2.0682873,2.0682873, 0.08273149,-4.0538432
99.462322, 2.34,2.95425, 14.906878,0.48086705, 0.17792082,-17.61416
90, 2.34,2.8665, 0,2.925, 0.08775,-2.83725
63.434949, 2.2815,2.7495, 2.6161995,1.3080998, 0.13080998,-6.4096889
26.565051, 2.1645,2.691, 3.9242993,1.3080998, 0.13080998,-6.4096889
45, 2.0475,2.574, 2.0682873,2.0682873, 0.16546298,-3.9711117
33.690068, 1.95975,2.5155, 4.0562452,0.81124904, 0.10546237,-10.440775
26.565051, 1.90125,2.48625, 3.9242993,1.3080998, 0.065404989,-6.4750939
0, 1.84275,2.48625, 0,2.925, 0.0585,-2.8665
288.43495, 0.585,2.34, 6.4747635,0.92496623, 0.092496632,-9.1571655
308.65981, 0.468,2.48625, 4.1112743,0.45680825, 0.18729138,-18.541847
320.19443, 0.2925,2.6325, 18.725394,0.37450787, 0.22844981,-22.616531
324.46232, 0.08775,2.77875, 10.540755,0.34002435, 0.25161801,-24.910183
315, -0.08775,2.95425, 2.0682873,2.0682873, 0.24819447,-3.8883802
296.56505, -0.20475,3.18825, 3.9242993,1.3080998, 0.26161996,-6.2788789
270, -0.20475,3.276, 0,2.925, 0.08775,-2.83725
243.43495, -0.1755,3.3345, 2.6161995,1.3080998, 0.065404989,-6.4750939
191.30993, -0.02925,3.36375, 12.046434,0.57363971, 0.14914633,-14.765486
180, 0.1755,3.36375, 0,2.925, 0.20475,-2.72025
180, 0.32175,3.36375, 0,2.925, 0.14625,-2.77875
161.56505, 0.4095,3.3345, 2.7748987,0.92496623, 0.092496632,-9.1571655
129.80557, 0.55575,3.159, 4.1195866,0.37450787, 0.22844981,-22.616531
125.53768, 0.702,2.95425, 14.621047,0.34002435, 0.25161801,-24.910183
129.80557, 0.84825,2.77875, 4.1195866,0.37450787, 0.22844981,-22.616531
141.34019, 0.9945,2.66175, 14.617864,0.45680825, 0.18729138,-18.541847
123.69007, 1.053,2.574, 4.0562452,0.81124904, 0.10546237,-10.440775
108.43495, 1.08225,2.48625, 6.4747635,0.92496623, 0.092496632,-9.1571655
90, 1.08225,2.3985, 0,2.925, 0.08775,-2.83725
45, 1.02375,2.34, 2.0682873,2.0682873, 0.08273149,-4.0538432
18.434949, 0.936,2.31075, 6.4747635,0.92496623, 0.092496632,-9.1571655
11.309932, 0.78975,2.2815, 12.046434,0.57363971, 0.14914633,-14.765486
9.4623222, 0.61425,2.25225, 14.906878,0.48086705, 0.17792082,-17.61416
270, -0.14625,2.5155, 0,2.925, 0.117,-2.808
225, -0.0585,2.60325, 2.0682873,2.0682873, 0.12409725,-4.0124774
191.30993, 0.08775,2.6325, 12.046434,0.57363971, 0.14914633,-14.765486
180, 0.20475,2.6325, 0,2.925, 0.117,-2.808
153.43495, 0.32175,2.574, 2.6161995,1.3080998, 0.13080998,-6.4096889
143.1301, 0.43875,2.48625, 10.53,0.585, 0.14625,-14.47875
126.8699, 0.5265,2.36925, 4.095,0.585, 0.14625,-14.47875
108.43495, 0.55575,2.2815, 6.4747635,0.92496623, 0.092496632,-9.1571655
45, 0.5265,2.25225, 2.0682873,2.0682873, 0.04136576,-4.0952089
14.036243, 0.4095,2.223, 9.2224172,0.70941672, 0.12060085,-11.939483
14.036243, 0.2925,2.19375, 9.2224172,0.70941672, 0.12060085,-11.939483
0, 0.14625,2.19375, 0,2.925, 0.14625,-2.77875
348.69007, 0,2.223, 2.8681985,0.57363971, 0.14914633,-14.765486
333.43495, -0.0585,2.25225, 2.6161995,1.3080998, 0.065404989,-6.4750939
303.69007, -0.117,2.34, 4.0562452,0.81124904, 0.10546237,-10.440775
296.56505, -0.14625,2.3985, 3.9242993,1.3080998, 0.065404989,-6.4750939
270, 2.457,2.691, 0,2.925, 0.234,-2.691
279.46232, 2.42775,2.8665, 14.906878,0.48086705, 0.17792082,-17.61416
236.30993, 2.48625,2.95425, 6.4899923,0.81124904, 0.10546237,-10.440775
206.56505, 2.54475,2.9835, 3.9242993,1.3080998, 0.065404989,-6.4750939
171.8699, 2.7495,2.95425, 2.8956023,0.41365748, 0.20682874,-20.476045
153.43495, 2.8665,2.89575, 2.6161995,1.3080998, 0.13080998,-6.4096889
135, 2.95425,2.808, 2.0682873,2.0682873, 0.12409725,-4.0124774
116.56505, 2.9835,2.7495, 3.9242993,1.3080998, 0.065404989,-6.4750939
63.434949, 2.95425,2.691, 2.6161995,1.3080998, 0.065404989,-6.4750939
33.690068, 2.8665,2.6325, 4.0562452,0.81124904, 0.10546237,-10.440775
45, 2.77875,2.54475, 2.0682873,2.0682873, 0.12409725,-4.0124774
71.565051, 2.7495,2.457, 2.7748987,0.92496623, 0.092496632,-9.1571655
33.690068, 2.66175,2.3985, 4.0562452,0.81124904, 0.10546237,-10.440775
11.309932, 2.5155,2.36925, 12.046434,0.57363971, 0.14914633,-14.765486
303.69007, 2.457,2.457, 4.0562452,0.81124904, 0.10546237,-10.440775
270, 2.457,2.5155, 0,2.925, 0.0585,-2.8665
0, 2.5155,0.702, 0,2.925, 0.02925,-2.89575
33.690068, 2.42775,0.6435, 4.0562452,0.81124904, 0.10546237,-10.440775
29.744881, 2.223,0.5265, 17.051675,0.36280159, 0.23582105,-23.346283
63.434949, 2.1645,0.4095, 2.6161995,1.3080998, 0.13080998,-6.4096889
123.69007, 2.223,0.32175, 4.0562452,0.81124904, 0.10546237,-10.440775
153.43495, 2.2815,0.2925, 2.6161995,1.3080998, 0.065404989,-6.4750939
135, 2.36925,0.20475, 2.0682873,2.0682873, 0.12409725,-4.0124774
149.03624, 2.5155,0.117, 6.5212337,0.50163338, 0.17055535,-16.884979
161.56505, 2.60325,0.08775, 2.7748987,0.92496623, 0.092496632,-9.1571655
198.43495, 2.691,0.117, 6.4747635,0.92496623, 0.092496632,-9.1571655
251.56505, 2.72025,0.20475, 2.7748987,0.92496623, 0.092496632,-9.1571655
279.46232, 2.691,0.38025, 14.906878,0.48086705, 0.17792082,-17.61416
270, 2.691,0.49725, 0,2.925, 0.117,-2.808
284.03624, 2.66175,0.61425, 9.2224172,0.70941672, 0.12060085,-11.939483
323.1301, 2.54475,0.702, 10.53,0.585, 0.14625,-14.47875
113.19859, 1.2285,0.73125, 6.5292124,0.38407131, 0.22276136,-22.053375
130.60129, 1.404,0.5265, 4.1243903,0.3172608, 0.26967166,-26.697496
142.12502, 1.66725,0.32175, 14.62275,0.25653946, 0.3335013,-33.01663
144.46232, 1.872,0.1755, 10.540755,0.34002435, 0.25161801,-24.910183
180, 1.95975,0.1755, 0,2.925, 0.08775,-2.83725
237.99462, 2.106,0.4095, 17.052716,0.31004939, 0.27594394,-27.318451
240.25512, 2.223,0.61425, 6.5304288,0.36280159, 0.23582105,-23.346283
243.43495, 2.2815,0.73125, 2.6161995,1.3080998, 0.13080998,-6.4096889
270, 2.2815,0.96525, 0,2.925, 0.234,-2.691
303.69007, 2.223,1.053, 4.0562452,0.81124904, 0.10546237,-10.440775
321.34019, 2.07675,1.17, 14.617864,0.45680825, 0.18729138,-18.541847
326.30993, 1.989,1.2285, 6.4899923,0.81124904, 0.10546237,-10.440775
0, 1.90125,1.2285, 0,2.925, 0.08775,-2.83725
5.1944289, 1.5795,1.19925, 29.394693,0.26481707, 0.32307681,-31.984604
9.4623222, 1.404,1.17, 14.906878,0.48086705, 0.17792082,-17.61416
11.309932, 1.25775,1.14075, 12.046434,0.57363971, 0.14914633,-14.765486
45, 1.19925,1.08225, 2.0682873,2.0682873, 0.08273149,-4.0538432
63.434949, 1.17,1.02375, 2.6161995,1.3080998, 0.065404989,-6.4750939
71.565051, 1.14075,0.936, 2.7748987,0.92496623, 0.092496632,-9.1571655
;; (c)1997 STONE PRODUCTS CORPORATION
*DRFTSTN, DRIFTSTONE
;%TYPE=MODEL
90, 0.798728,2.681444, 0,2.8526, 0.114104,-2.738496
78.690068, 0.770202,2.538814, 2.7972044,0.5594409, 0.14545464,-14.400008
75.963757, 0.741676,2.42471, 2.7674285,0.69185714, 0.11761572,-11.643955
71.565051, 0.684624,2.253554, 2.706214,0.90207134, 0.18041426,-8.840299
90, 0.684624,2.196502, 0,2.8526, 0.057052,-2.795548
153.43495, 1.56893,1.4263, 2.551443,1.2757215, 0.063786076,-6.3148214
158.19859, 1.71156,1.369248, 9.0051469,0.52971453, 0.15361722,-15.208104
165.96376, 1.825664,1.340722, 2.7674285,0.69185714, 0.11761572,-11.643955
123.69007, 1.882716,1.255144, 3.9558444,0.7911689, 0.10285195,-10.182344
90, 1.882716,1.198092, 0,2.8526, 0.057052,-2.795548
75.963757, 1.85419,1.083988, 2.7674285,0.69185714, 0.11761572,-11.643955
60.255119, 1.740086,0.884306, 6.3687867,0.35382147, 0.22998397,-22.768412
59.036243, 1.654508,0.741676, 6.3598192,0.48921688, 0.16633374,-16.46704
33.690068, 1.56893,0.684624, 3.9558444,0.7911689, 0.10285195,-10.182344
281.30993, 0.71315,0.313786, 11.748259,0.5594409, 0.14545464,-14.400008
270, 0.71315,0.370838, 0,2.8526, 0.057052,-2.795548
255.96376, 0.741676,0.484942, 2.7674285,0.69185714, 0.11761572,-11.643955
255.96376, 0.770202,0.599046, 2.7674285,0.69185714, 0.11761572,-11.643955
248.19859, 0.827254,0.741676, 9.0051469,0.52971453, 0.15361722,-15.208104
255.96376, 0.85578,0.85578, 2.7674285,0.69185714, 0.11761572,-11.643955
270, 0.85578,0.941358, 0,2.8526, 0.085578,-2.767022
225, 0.884306,0.969884, 2.0170928,2.0170928, 0.040341869,-3.9938438
180, 0.941358,0.969884, 0,2.8526, 0.057052,-2.795548
153.43495, 1.055462,0.912832, 2.551443,1.2757215, 0.12757215,-6.2510354
143.1301, 1.169566,0.827254, 10.26936,0.57052, 0.14263,-14.12037
158.19859, 1.312196,0.770202, 9.0051469,0.52971453, 0.15361722,-15.208104
153.43495, 1.483352,0.684624, 2.551443,1.2757215, 0.19135823,-6.1872493
153.43495, 1.597456,0.627572, 2.551443,1.2757215, 0.12757215,-6.2510354
153.43495, 1.71156,0.57052, 2.551443,1.2757215, 0.12757215,-6.2510354
0, 2.510288,0.228208, 0,2.8526, 0.028526,-2.824074
0, 2.681444,0.399364, 0,2.8526, 0.028526,-2.824074
0, 2.481762,2.595866, 0,2.8526, 0.028526,-2.824074
0, 2.110924,2.396184, 0,2.8526, 0.028526,-2.824074
0, 2.025346,2.42471, 0,2.8526, 0.114104,-2.738496
225, 1.968294,3.109334, 2.0170928,2.0170928, 0.040341869,-3.9938438
0, 1.939768,3.109334, 0,2.8526, 0.028526,-2.824074
225, 2.196502,2.738496, 2.0170928,2.0170928, 0.040341869,-3.9938438
0, 2.167976,2.738496, 0,2.8526, 0.028526,-2.824074
0, 0.456416,0.627572, 0,2.8526, 0.057052,-2.795548
0, 0.399364,0.656098, 0,2.8526, 0.057052,-2.795548
225, 0.057052,0.912832, 2.0170928,2.0170928, 0.040341869,-3.9938438
0, 0.028526,0.912832, 0,2.8526, 0.028526,-2.824074
0, 0.256734,1.226618, 0,2.8526, 0.028526,-2.824074
225, 1.483352,0.42789, 2.0170928,2.0170928, 0.040341869,-3.9938438
0, 1.4263,0.42789, 0,2.8526, 0.057052,-2.795548
0, 0.969884,0.28526, 0,2.8526, 0.085578,-2.767022
0, 1.083988,0.57052, 0,2.8526, 0.028526,-2.824074
0, 1.083988,0.599046, 0,2.8526, 0.114104,-2.738496
0, 2.396184,0.798728, 0,2.8526, 0.028526,-2.824074
225, 1.99682,0.827254, 2.0170928,2.0170928, 0.040341869,-3.9938438
0, 1.939768,0.827254, 0,2.8526, 0.057052,-2.795548
225, 2.310606,1.14104, 2.0170928,2.0170928, 0.040341869,-3.9938438
0, 2.28208,1.14104, 0,2.8526, 0.028526,-2.824074
0, 1.112514,1.055462, 0,2.8526, 0.028526,-2.824074
0, 1.083988,1.083988, 0,2.8526, 0.028526,-2.824074
0, 1.540404,0.99841, 0,2.8526, 0.114104,-2.738496
0, 1.397774,1.255144, 0,2.8526, 0.028526,-2.824074
0, 1.85419,1.597456, 0,2.8526, 0.085578,-2.767022
0, 1.825664,1.625982, 0,2.8526, 0.057052,-2.795548
0, 1.683034,1.85419, 0,2.8526, 0.028526,-2.824074
0, 1.939768,1.939768, 0,2.8526, 0.028526,-2.824074
0, 0.656098,1.56893, 0,2.8526, 0.028526,-2.824074
198.43495, 0.770202,1.540404, 6.3144993,0.90207134, 0.090207142,-8.9305061
0, 0.627572,1.540404, 0,2.8526, 0.14263,-2.70997
225, 1.083988,1.768612, 2.0170928,2.0170928, 0.040341869,-3.9938438
0, 1.026936,1.768612, 0,2.8526, 0.057052,-2.795548
0, 1.369248,1.911242, 0,2.8526, 0.028526,-2.824074
0, 1.312196,1.939768, 0,2.8526, 0.057052,-2.795548
0, 0.399364,1.85419, 0,2.8526, 0.028526,-2.824074
0, 0.57052,1.968294, 0,2.8526, 0.028526,-2.824074
0, 1.540404,2.652918, 0,2.8526, 0.028526,-2.824074
0, 1.198092,2.453236, 0,2.8526, 0.057052,-2.795548
0, 1.14104,2.481762, 0,2.8526, 0.085578,-2.767022
206.56505, 0.228208,2.453236, 3.8271645,1.2757215, 0.063786076,-6.3148214
0, 0.14263,2.453236, 0,2.8526, 0.085578,-2.767022
0, 0.456416,2.795548, 0,2.8526, 0.028526,-2.824074
0, 0.399364,2.767022, 0,2.8526, 0.171156,-2.681444
0, 0,2.909652, 0,2.8526, 0.028526,-2.824074
0, -0.057052,2.881126, 0,2.8526, 0.085578,-2.767022
206.56505, -0.313786,1.825664, 3.8271645,1.2757215, 0.063786076,-6.3148214
0, -0.399364,1.825664, 0,2.8526, 0.085578,-2.767022
0, -0.256734,2.053872, 0,2.8526, 0.085578,-2.767022
78.690068, 0.684624,0.370838, 2.7972044,0.5594409, 0.14545464,-14.400008
63.434949, 0.656098,0.313786, 2.551443,1.2757215, 0.063786076,-6.3148214
26.565051, 0.599046,0.28526, 3.8271645,1.2757215, 0.063786076,-6.3148214
0, 0.513468,0.28526, 0,2.8526, 0.085578,-2.767022
348.69007, 0.228208,0.342312, 2.7972044,0.5594409, 0.29090926,-14.254554
338.19859, 0.085578,0.399364, 9.0051469,0.52971453, 0.15361722,-15.208104
326.30993, 0,0.456416, 6.3293511,0.7911689, 0.10285195,-10.182344
303.69007, -0.057052,0.541994, 3.9558444,0.7911689, 0.10285195,-10.182344
284.03624, -0.085578,0.656098, 8.9941426,0.69185714, 0.11761572,-11.643955
288.43495, -0.114104,0.741676, 6.3144993,0.90207134, 0.090207142,-8.9305061
270, -0.114104,0.85578, 0,2.8526, 0.114104,-2.738496
281.30993, -0.14263,0.99841, 11.748259,0.5594409, 0.14545464,-14.400008
270, -0.14263,1.169566, 0,2.8526, 0.171156,-2.681444
288.43495, -0.171156,1.255144, 6.3144993,0.90207134, 0.090207142,-8.9305061
284.03624, -0.199682,1.369248, 8.9941426,0.69185714, 0.11761572,-11.643955
270, -0.199682,1.397774, 0,2.8526, 0.028526,-2.824074
243.43495, -0.171156,1.454826, 2.551443,1.2757215, 0.063786076,-6.3148214
206.56505, -0.114104,1.483352, 3.8271645,1.2757215, 0.063786076,-6.3148214
180, -0.057052,1.483352, 0,2.8526, 0.057052,-2.795548
153.43495, 0,1.454826, 2.551443,1.2757215, 0.063786076,-6.3148214
161.56505, 0.085578,1.4263, 2.706214,0.90207134, 0.090207142,-8.9305061
180, 0.313786,1.4263, 0,2.8526, 0.228208,-2.624392
153.43495, 0.42789,1.369248, 2.551443,1.2757215, 0.12757215,-6.2510354
135, 0.513468,1.28367, 2.0170928,2.0170928, 0.12102558,-3.9131601
26.565051, 0.827254,2.8526, 3.8271645,1.2757215, 0.12757215,-6.2510354
63.434949, 0.798728,2.795548, 2.551443,1.2757215, 0.063786076,-6.3148214
45, 2.025346,1.397774, 2.0170928,2.0170928, 0.080683709,-3.9535019
45, 1.968294,1.340722, 2.0170928,2.0170928, 0.080683709,-3.9535019
0, 1.911242,1.340722, 0,2.8526, 0.057052,-2.795548
345.96376, 1.797138,1.369248, 2.7674285,0.69185714, 0.11761572,-11.643955
338.19859, 1.654508,1.4263, 9.0051469,0.52971453, 0.15361722,-15.208104
333.43495, 1.540404,1.483352, 2.551443,1.2757215, 0.12757215,-6.2510354
296.56505, 1.511878,1.540404, 3.8271645,1.2757215, 0.063786076,-6.3148214
270, 1.511878,1.625982, 0,2.8526, 0.085578,-2.767022
0, 2.053872,0.456416, 0,2.8526, 0.085578,-2.767022
90, 0.85578,0.884306, 0,2.8526, 0.057052,-2.795548
90, 0.85578,0.85578, 0,2.8526, 0.028526,-2.824074
135, 0.770202,0.14263, 2.0170928,2.0170928, 0.040341869,-3.9938438
123.69007, 0.484942,1.340722, 3.9558444,0.7911689, 0.10285195,-10.182344
135, 0.541994,1.28367, 2.0170928,2.0170928, 0.080683709,-3.9535019
153.43495, 0.599046,1.255144, 2.551443,1.2757215, 0.063786076,-6.3148214
180, 0.627572,1.255144, 0,2.8526, 0.028526,-2.824074
0, 0.941358,1.312196, 0,2.8526, 0.14263,-2.70997
90, 1.540404,1.968294, 0,2.8526, 0.14263,-2.70997
82.874984, 1.511878,1.740086, 2.8305719,0.35382147, 0.22998397,-22.768412
75.963757, 1.483352,1.625982, 2.7674285,0.69185714, 0.11761572,-11.643955
71.565051, 1.454826,1.540404, 2.706214,0.90207134, 0.090207142,-8.9305061
45, 1.397774,1.483352, 2.0170928,2.0170928, 0.080683709,-3.9535019
30.963757, 1.255144,1.397774, 10.273554,0.48921688, 0.16633374,-16.46704
26.565051, 1.198092,1.369248, 3.8271645,1.2757215, 0.063786076,-6.3148214
14.036243, 1.083988,1.340722, 8.9941426,0.69185714, 0.11761572,-11.643955
0, 0.99841,1.340722, 0,2.8526, 0.085578,-2.767022
11.309932, 0.85578,1.312196, 11.748259,0.5594409, 0.14545464,-14.400008
14.036243, 0.741676,1.28367, 8.9941426,0.69185714, 0.11761572,-11.643955
14.036243, 0.627572,1.255144, 8.9941426,0.69185714, 0.11761572,-11.643955
315, 0,2.110924, 2.0170928,2.0170928, 0.080683709,-3.9535019
290.55605, -0.085578,2.339132, 15.358093,0.33387158, 0.24372626,-24.128899
296.56505, -0.14263,2.453236, 3.8271645,1.2757215, 0.12757215,-6.2510354
270, 0.770202,2.909652, 0,2.8526, 0.199682,-2.652918
288.43495, 0.741676,2.99523, 6.3144993,0.90207134, 0.090207142,-8.9305061
315, 0.656098,3.080808, 2.0170928,2.0170928, 0.12102558,-3.9131601
338.19859, 0.513468,3.13786, 9.0051469,0.52971453, 0.15361722,-15.208104
350.53768, 0.342312,3.166386, 2.8137873,0.46896456, 0.1735169,-17.178171
0, 0.228208,3.166386, 0,2.8526, 0.114104,-2.738496
11.309932, 0.085578,3.13786, 11.748259,0.5594409, 0.14545464,-14.400008
18.434949, 0,3.109334, 6.3144993,0.90207134, 0.090207142,-8.9305061
33.690068, -0.085578,3.052282, 3.9558444,0.7911689, 0.10285195,-10.182344
45, -0.171156,2.966704, 2.0170928,2.0170928, 0.12102558,-3.9131601
71.565051, -0.199682,2.881126, 2.706214,0.90207134, 0.090207142,-8.9305061
90, -0.199682,2.767022, 0,2.8526, 0.114104,-2.738496
101.30993, -0.171156,2.624392, 11.748259,0.5594409, 0.14545464,-14.400008
99.462322, -0.14263,2.453236, 14.537901,0.46896456, 0.1735169,-17.178171
123.69007, 0.14263,1.939768, 3.9558444,0.7911689, 0.10285195,-10.182344
135, 0.199682,1.882716, 2.0170928,2.0170928, 0.080683709,-3.9535019
135, 0.342312,1.740086, 2.0170928,2.0170928, 0.20170929,-3.8324763
116.56505, 0.399364,1.625982, 3.8271645,1.2757215, 0.12757215,-6.2510354
90, 0.399364,1.56893, 0,2.8526, 0.057052,-2.795548
71.565051, 0.370838,1.483352, 2.706214,0.90207134, 0.090207142,-8.9305061
18.434949, 0.28526,1.454826, 6.3144993,0.90207134, 0.090207142,-8.9305061
0, 0.057052,1.454826, 0,2.8526, 0.228208,-2.624392
333.43495, -0.057052,1.511878, 2.551443,1.2757215, 0.12757215,-6.2510354
348.69007, -0.199682,1.540404, 2.7972044,0.5594409, 0.14545464,-14.400008
0, -0.28526,1.540404, 0,2.8526, 0.085578,-2.767022
333.43495, -0.399364,1.597456, 2.551443,1.2757215, 0.12757215,-6.2510354
333.43495, -0.456416,1.625982, 2.551443,1.2757215, 0.063786076,-6.3148214
315, -0.513468,1.683034, 2.0170928,2.0170928, 0.080683709,-3.9535019
303.69007, -0.57052,1.768612, 3.9558444,0.7911689, 0.10285195,-10.182344
270, -0.57052,1.85419, 0,2.8526, 0.085578,-2.767022
255.96376, -0.541994,1.968294, 2.7674285,0.69185714, 0.11761572,-11.643955
236.30993, -0.484942,2.053872, 6.3293511,0.7911689, 0.10285195,-10.182344
225, -0.399364,2.13945, 2.0170928,2.0170928, 0.12102558,-3.9131601
216.8699, -0.28526,2.225028, 3.99364,0.57052, 0.14263,-14.12037
198.43495, -0.199682,2.253554, 6.3144993,0.90207134, 0.090207142,-8.9305061
180, -0.114104,2.253554, 0,2.8526, 0.085578,-2.767022
153.43495, -0.057052,2.225028, 2.551443,1.2757215, 0.063786076,-6.3148214
108.43495, -0.028526,2.13945, 6.3144993,0.90207134, 0.090207142,-8.9305061
123.69007, 0.028526,2.053872, 3.9558444,0.7911689, 0.10285195,-10.182344
153.43495, 0.085578,2.025346, 2.551443,1.2757215, 0.063786076,-6.3148214
18.434949, 0.85578,1.28367, 6.3144993,0.90207134, 0.090207142,-8.9305061
45, 0.798728,1.226618, 2.0170928,2.0170928, 0.080683709,-3.9535019
90, 0.798728,1.169566, 0,2.8526, 0.057052,-2.795548
108.43495, 0.827254,1.083988, 6.3144993,0.90207134, 0.090207142,-8.9305061
135, 0.884306,1.026936, 2.0170928,2.0170928, 0.080683709,-3.9535019
63.434949, 0.656098,0.313786, 2.551443,1.2757215, 0.063786076,-6.3148214
26.565051, 0.599046,0.28526, 3.8271645,1.2757215, 0.063786076,-6.3148214
0, 0.513468,0.28526, 0,2.8526, 0.085578,-2.767022
348.69007, 0.228208,0.342312, 2.7972044,0.5594409, 0.29090926,-14.254554
338.19859, 0.085578,0.399364, 9.0051469,0.52971453, 0.15361722,-15.208104
326.30993, 0,0.456416, 6.3293511,0.7911689, 0.10285195,-10.182344
303.69007, -0.057052,0.541994, 3.9558444,0.7911689, 0.10285195,-10.182344
284.03624, -0.085578,0.656098, 8.9941426,0.69185714, 0.11761572,-11.643955
315, 2.42471,1.597456, 2.0170928,2.0170928, 0.080683709,-3.9535019
0, 2.339132,1.597456, 0,2.8526, 0.085578,-2.767022
0, 2.253554,1.597456, 0,2.8526, 0.085578,-2.767022
270, 2.681444,2.595866, 0,2.8526, 0.14263,-2.70997
279.46232, 2.652918,2.767022, 14.537901,0.46896456, 0.1735169,-17.178171
288.43495, 2.624392,2.8526, 6.3144993,0.90207134, 0.090207142,-8.9305061
323.1301, 2.510288,2.938178, 10.26936,0.57052, 0.14263,-14.12037
326.30993, 2.42471,2.99523, 6.3293511,0.7911689, 0.10285195,-10.182344
296.56505, 2.367658,3.109334, 3.8271645,1.2757215, 0.12757215,-6.2510354
284.03624, 2.339132,3.223438, 8.9941426,0.69185714, 0.11761572,-11.643955
326.30993, 2.253554,3.28049, 6.3293511,0.7911689, 0.10285195,-10.182344
345.96376, 2.13945,3.309016, 2.7674285,0.69185714, 0.11761572,-11.643955
0, 1.968294,3.309016, 0,2.8526, 0.171156,-2.681444
11.309932, 1.825664,3.28049, 11.748259,0.5594409, 0.14545464,-14.400008
26.565051, 1.768612,3.251964, 3.8271645,1.2757215, 0.063786076,-6.3148214
56.309932, 1.71156,3.166386, 6.3293511,0.7911689, 0.10285195,-10.182344
78.690068, 1.683034,3.023756, 2.7972044,0.5594409, 0.14545464,-14.400008
90, 1.683034,2.909652, 0,2.8526, 0.114104,-2.738496
108.43495, 1.71156,2.824074, 6.3144993,0.90207134, 0.090207142,-8.9305061
108.43495, 1.740086,2.738496, 6.3144993,0.90207134, 0.090207142,-8.9305061
90, 1.740086,2.652918, 0,2.8526, 0.085578,-2.767022
78.690068, 1.71156,2.510288, 2.7972044,0.5594409, 0.14545464,-14.400008
78.690068, 1.683034,2.367658, 2.7972044,0.5594409, 0.14545464,-14.400008
90, 1.683034,2.310606, 0,2.8526, 0.057052,-2.795548
116.56505, 1.71156,2.253554, 3.8271645,1.2757215, 0.063786076,-6.3148214
146.30993, 1.797138,2.196502, 6.3293511,0.7911689, 0.10285195,-10.182344
172.87498, 2.025346,2.167976, 2.8305719,0.35382147, 0.22998397,-22.768412
180, 2.196502,2.167976, 0,2.8526, 0.171156,-2.681444
180, 2.28208,2.167976, 0,2.8526, 0.085578,-2.767022
191.30993, 2.42471,2.196502, 11.748259,0.5594409, 0.14545464,-14.400008
194.03624, 2.538814,2.225028, 8.9941426,0.69185714, 0.11761572,-11.643955
206.56505, 2.595866,2.253554, 3.8271645,1.2757215, 0.063786076,-6.3148214
225, 2.652918,2.310606, 2.0170928,2.0170928, 0.080683709,-3.9535019
258.69007, 2.681444,2.453236, 2.7972044,0.5594409, 0.14545464,-14.400008
243.43495, 1.882716,1.083988, 2.551443,1.2757215, 0.12757215,-6.2510354
239.03624, 1.825664,0.969884, 6.3598192,0.48921688, 0.16633374,-16.46704
236.30993, 1.740086,0.827254, 6.3293511,0.7911689, 0.10285195,-10.182344
180, 1.56893,0.684624, 0,2.8526, 0.028526,-2.824074
153.43495, 1.540404,0.684624, 2.551443,1.2757215, 0.063786076,-6.3148214
149.03624, 1.483352,0.71315, 6.3598192,0.48921688, 0.16633374,-16.46704
158.19859, 1.340722,0.798728, 9.0051469,0.52971453, 0.15361722,-15.208104
143.1301, 1.198092,0.85578, 10.26936,0.57052, 0.14263,-14.12037
153.43495, 1.083988,0.941358, 2.551443,1.2757215, 0.12757215,-6.2510354
161.56505, 0.969884,0.99841, 2.706214,0.90207134, 0.090207142,-8.9305061
135, 0.884306,1.026936, 2.0170928,2.0170928, 0.080683709,-3.9535019
26.565051, 1.312196,1.397774, 3.8271645,1.2757215, 0.063786076,-6.3148214
18.434949, 1.369248,1.4263, 6.3144993,0.90207134, 0.090207142,-8.9305061
0, 1.454826,1.454826, 0,2.8526, 0.057052,-2.795548
333.43495, 0.684624,1.198092, 2.551443,1.2757215, 0.063786076,-6.3148214
165.96376, 0.969884,0.085578, 2.7674285,0.69185714, 0.11761572,-11.643955
161.56505, 0.85578,0.114104, 2.706214,0.90207134, 0.090207142,-8.9305061
135, 0.770202,0.14263, 2.0170928,2.0170928, 0.040341869,-3.9938438
78.690068, 0.684624,0.370838, 2.7972044,0.5594409, 0.14545464,-14.400008
71.565051, 0.71315,0.513468, 2.706214,0.90207134, 0.18041426,-8.840299
71.565051, 0.770202,0.684624, 2.706214,0.90207134, 0.18041426,-8.840299
90, 0.827254,0.85578, 0,2.8526, 0.085578,-2.767022
296.56505, 1.71156,0.57052, 3.8271645,1.2757215, 0.063786076,-6.3148214
270, 1.740086,0.513468, 0,2.8526, 0.028526,-2.824074
251.56505, 1.740086,0.484942, 2.706214,0.90207134, 0.090207142,-8.9305061
236.30993, 1.71156,0.399364, 6.3293511,0.7911689, 0.10285195,-10.182344
225, 1.654508,0.313786, 2.0170928,2.0170928, 0.12102558,-3.9131601
225, 1.56893,0.228208, 2.0170928,2.0170928, 0.080683709,-3.9535019
213.69007, 1.511878,0.171156, 3.9558444,0.7911689, 0.10285195,-10.182344
198.43495, 1.4263,0.114104, 6.3144993,0.90207134, 0.090207142,-8.9305061
180, 1.340722,0.085578, 0,2.8526, 0.114104,-2.738496
180, 1.226618,0.085578, 0,2.8526, 0.256734,-2.595866
194.03624, 2.396184,0.513468, 8.9941426,0.69185714, 0.11761572,-11.643955
191.30993, 2.28208,0.484942, 11.748259,0.5594409, 0.14545464,-14.400008
168.69007, 2.053872,0.456416, 2.7972044,0.5594409, 0.14545464,-14.400008
161.56505, 1.911242,0.484942, 2.706214,0.90207134, 0.090207142,-8.9305061
153.43495, 1.825664,0.513468, 2.551443,1.2757215, 0.063786076,-6.3148214
135, 1.768612,0.541994, 2.0170928,2.0170928, 0.080683709,-3.9535019
116.56505, 1.71156,0.599046, 3.8271645,1.2757215, 0.063786076,-6.3148214
90, 1.683034,0.656098, 0,2.8526, 0.085578,-2.767022
63.434949, 1.939768,1.169566, 2.551443,1.2757215, 0.12757215,-6.2510354
59.036243, 1.99682,1.28367, 6.3598192,0.48921688, 0.16633374,-16.46704
63.434949, 2.082398,1.4263, 2.551443,1.2757215, 0.063786076,-6.3148214
56.309932, 2.110924,1.483352, 6.3293511,0.7911689, 0.10285195,-10.182344
18.434949, 2.167976,1.56893, 6.3144993,0.90207134, 0.090207142,-8.9305061
315, 2.481762,1.540404, 2.0170928,2.0170928, 0.080683709,-3.9535019
296.56505, 2.538814,1.483352, 3.8271645,1.2757215, 0.063786076,-6.3148214
296.56505, 2.56734,1.4263, 3.8271645,1.2757215, 0.12757215,-6.2510354
284.03624, 2.624392,1.312196, 8.9941426,0.69185714, 0.11761572,-11.643955
270, 2.652918,1.198092, 0,2.8526, 0.199682,-2.652918
281.30993, 2.652918,0.99841, 11.748259,0.5594409, 0.14545464,-14.400008
284.03624, 2.681444,0.85578, 8.9941426,0.69185714, 0.11761572,-11.643955
270, 2.70997,0.741676, 0,2.8526, 0.085578,-2.767022
243.43495, 2.70997,0.656098, 2.551443,1.2757215, 0.063786076,-6.3148214
206.56505, 2.681444,0.599046, 3.8271645,1.2757215, 0.063786076,-6.3148214
191.30993, 2.624392,0.57052, 11.748259,0.5594409, 0.14545464,-14.400008
198.43495, 2.481762,0.541994, 6.3144993,0.90207134, 0.090207142,-8.9305061
281.30993, 2.367658,0.370838, 11.748259,0.5594409, 0.14545464,-14.400008
14.036243, 1.083988,1.312196, 8.9941426,0.69185714, 0.11761572,-11.643955
26.565051, 1.198092,1.340722, 3.8271645,1.2757215, 0.12757215,-6.2510354
90, 1.540404,1.99682, 0,2.8526, 0.114104,-2.738496
116.56505, 1.540404,2.110924, 3.8271645,1.2757215, 0.063786076,-6.3148214
180, 1.511878,2.167976, 0,2.8526, 0.028526,-2.824074
213.69007, 1.483352,2.167976, 3.9558444,0.7911689, 0.10285195,-10.182344
206.56505, 1.397774,2.110924, 3.8271645,1.2757215, 0.19135823,-6.1872493
206.56505, 1.226618,2.025346, 3.8271645,1.2757215, 0.19135823,-6.1872493
201.80141, 1.055462,1.939768, 6.3565743,0.52971453, 0.15361722,-15.208104
213.69007, 0.912832,1.882716, 3.9558444,0.7911689, 0.10285195,-10.182344
198.43495, 0.827254,1.825664, 6.3144993,0.90207134, 0.090207142,-8.9305061
180, 0.741676,1.797138, 0,2.8526, 0.085578,-2.767022
198.43495, 0.656098,1.797138, 6.3144993,0.90207134, 0.090207142,-8.9305061
213.69007, 0.57052,1.768612, 3.9558444,0.7911689, 0.10285195,-10.182344
243.43495, 0.484942,1.71156, 2.551443,1.2757215, 0.063786076,-6.3148214
255.96376, 0.456416,1.654508, 2.7674285,0.69185714, 0.11761572,-11.643955
270, 0.42789,1.540404, 0,2.8526, 0.114104,-2.738496
251.56505, 1.625982,2.253554, 2.706214,0.90207134, 0.090207142,-8.9305061
258.69007, 1.597456,2.167976, 2.7972044,0.5594409, 0.14545464,-14.400008
260.53768, 1.56893,2.025346, 2.8137873,0.46896456, 0.1735169,-17.178171
262.87498, 1.540404,1.85419, 2.8305719,0.35382147, 0.22998397,-22.768412
56.309932, 2.082398,1.454826, 6.3293511,0.7911689, 0.10285195,-10.182344
68.198591, 2.13945,1.540404, 9.0051469,0.52971453, 0.15361722,-15.208104
78.690068, 2.196502,1.683034, 2.7972044,0.5594409, 0.14545464,-14.400008
78.690068, 2.225028,1.825664, 2.7972044,0.5594409, 0.14545464,-14.400008
90, 2.253554,1.968294, 0,2.8526, 0.057052,-2.795548
153.43495, 2.253554,2.025346, 2.551443,1.2757215, 0.063786076,-6.3148214
165.96376, 2.196502,2.053872, 2.7674285,0.69185714, 0.11761572,-11.643955
153.43495, 2.082398,2.082398, 2.551443,1.2757215, 0.12757215,-6.2510354
165.96376, 1.968294,2.13945, 2.7674285,0.69185714, 0.11761572,-11.643955
153.43495, 1.85419,2.167976, 2.551443,1.2757215, 0.12757215,-6.2510354
153.43495, 1.740086,2.225028, 2.551443,1.2757215, 0.063786076,-6.3148214
180, 1.683034,2.253554, 0,2.8526, 0.057052,-2.795548
251.56505, 1.683034,2.481762, 2.706214,0.90207134, 0.090207142,-8.9305061
243.43495, 1.654508,2.396184, 2.551443,1.2757215, 0.12757215,-6.2510354
225, 1.597456,2.28208, 2.0170928,2.0170928, 0.080683709,-3.9535019
213.69007, 1.540404,2.225028, 3.9558444,0.7911689, 0.10285195,-10.182344
210.96376, 1.454826,2.167976, 10.273554,0.48921688, 0.16633374,-16.46704
206.56505, 1.312196,2.082398, 3.8271645,1.2757215, 0.12757215,-6.2510354
198.43495, 1.198092,2.025346, 6.3144993,0.90207134, 0.090207142,-8.9305061
198.43495, 1.112514,1.99682, 6.3144993,0.90207134, 0.090207142,-8.9305061
180, 1.026936,1.968294, 0,2.8526, 0.057052,-2.795548
161.56505, 0.969884,1.968294, 2.706214,0.90207134, 0.090207142,-8.9305061
135, 0.884306,1.99682, 2.0170928,2.0170928, 0.040341869,-3.9938438
135, 0.741676,2.110924, 2.0170928,2.0170928, 0.040341869,-3.9938438
116.56505, 0.71315,2.13945, 3.8271645,1.2757215, 0.063786076,-6.3148214
90, 0.770202,2.681444, 0,2.8526, 0.085578,-2.767022
0, 0.941358,2.909652, 0,2.8526, 0.14263,-2.70997
354.28941, 1.083988,2.909652, 2.8384431,0.28384431, 0.28668276,-28.381592
350.53768, 1.369248,2.881126, 2.8137873,0.46896456, 0.1735169,-17.178171
341.56505, 1.540404,2.8526, 2.706214,0.90207134, 0.090207142,-8.9305061
333.43495, 1.625982,2.824074, 2.551443,1.2757215, 0.063786076,-6.3148214
296.56505, 1.683034,2.795548, 3.8271645,1.2757215, 0.063786076,-6.3148214
270, 1.71156,2.738496, 0,2.8526, 0.085578,-2.767022
260.53768, 1.71156,2.652918, 2.8137873,0.46896456, 0.1735169,-17.178171
0, 0.057052,1.454826, 0,2.8526, 0.114104,-2.738496
270, 0.770202,2.767022, 0,2.8526, 0.085578,-2.767022
257.47119, 0.770202,2.681444, 14.542172,0.30940792, 0.26299671,-26.036676
180, 0.28526,1.454826, 0,2.8526, 0.171156,-2.681444
146.30993, 1.797138,2.196502, 6.3293511,0.7911689, 0.10285195,-10.182344
213.69007, 0.57052,1.768612, 3.9558444,0.7911689, 0.10285195,-10.182344
180, 0.484942,1.71156, 0,2.8526, 0.057052,-2.795548
161.56505, 0.42789,1.71156, 2.706214,0.90207134, 0.090207142,-8.9305061
135, 0.342312,1.740086, 2.0170928,2.0170928, 0.20170929,-3.8324763
116.56505, 0.199682,1.882716, 3.8271645,1.2757215, 0.063786076,-6.3148214
90, 0.171156,1.939768, 0,2.8526, 0.028526,-2.824074
26.565051, 0.171156,1.968294, 3.8271645,1.2757215, 0.063786076,-6.3148214
21.801409, 0.228208,1.99682, 6.3565743,0.52971453, 0.15361722,-15.208104
21.801409, 0.370838,2.053872, 6.3565743,0.52971453, 0.15361722,-15.208104
18.434949, 0.513468,2.110924, 6.3144993,0.90207134, 0.090207142,-8.9305061
0, 0.599046,2.13945, 0,2.8526, 0.057052,-2.795548
341.56505, 0.656098,2.13945, 2.706214,0.90207134, 0.090207142,-8.9305061
315, 0.741676,2.110924, 2.0170928,2.0170928, 0.080683709,-3.9535019
333.43495, 0.798728,2.053872, 2.551443,1.2757215, 0.063786076,-6.3148214
296.56505, 0.85578,2.025346, 3.8271645,1.2757215, 0.063786076,-6.3148214
270, 0.884306,1.968294, 0,2.8526, 0.057052,-2.795548
243.43495, 0.884306,1.911242, 2.551443,1.2757215, 0.063786076,-6.3148214
206.56505, 0.85578,1.85419, 3.8271645,1.2757215, 0.063786076,-6.3148214
198.43495, 0.798728,1.825664, 6.3144993,0.90207134, 0.090207142,-8.9305061
236.30993, 0.71315,2.42471, 6.3293511,0.7911689, 0.10285195,-10.182344
233.1301, 0.656098,2.339132, 10.26936,0.57052, 0.14263,-14.12037
225, 0.57052,2.225028, 2.0170928,2.0170928, 0.16136742,-3.8728182
201.80141, 0.456416,2.110924, 6.3565743,0.52971453, 0.15361722,-15.208104
198.43495, 0.313786,2.053872, 6.3144993,0.90207134, 0.090207142,-8.9305061
180, 0.228208,2.025346, 0,2.8526, 0.085578,-2.767022
161.56505, 0.14263,2.025346, 2.706214,0.90207134, 0.090207142,-8.9305061
116.56505, 2.367658,0.370838, 3.8271645,1.2757215, 0.063786076,-6.3148214
90, 2.339132,0.42789, 0,2.8526, 0.028526,-2.824074
45, 2.339132,0.456416, 2.0170928,2.0170928, 0.080683709,-3.9535019
0, 2.681444,0.599046, 0,2.8526, 0.057052,-2.795548
315, 2.738496,0.599046, 2.0170928,2.0170928, 0.080683709,-3.9535019
303.69007, 2.8526,0.456416, 3.9558444,0.7911689, 0.10285195,-10.182344
270, 2.909652,0.370838, 0,2.8526, 0.028526,-2.824074
243.43495, 2.909652,0.342312, 2.551443,1.2757215, 0.063786076,-6.3148214
225, 2.881126,0.28526, 2.0170928,2.0170928, 0.040341869,-3.9938438
45, 2.681444,0.114104, 2.0170928,2.0170928, 0.12102558,-3.9131601
33.690068, 2.767022,0.199682, 3.9558444,0.7911689, 0.10285195,-10.182344
303.69007, 2.396184,0.228208, 3.9558444,0.7911689, 0.10285195,-10.182344
333.43495, 2.453236,0.14263, 2.551443,1.2757215, 0.063786076,-6.3148214
341.56505, 2.510288,0.114104, 2.706214,0.90207134, 0.090207142,-8.9305061
0, 2.595866,0.085578, 0,2.8526, 0.057052,-2.795548
45, 2.652918,0.085578, 2.0170928,2.0170928, 0.040341869,-3.9938438
153.43495, 0.57052,1.255144, 2.551443,1.2757215, 0.063786076,-6.3148214
0, 0.057052,1.454826, 0,2.8526, 0.228208,-2.624392
306.8699, 0.741676,1.169566, 3.99364,0.57052, 0.14263,-14.12037
270, 0.827254,1.055462, 0,2.8526, 0.114104,-2.738496
270, 0.827254,0.941358, 0,2.8526, 0.085578,-2.767022
251.56505, 0.827254,0.85578, 2.706214,0.90207134, 0.36082854,-8.6598847
258.69007, 0.71315,0.513468, 2.7972044,0.5594409, 0.14545464,-14.400008
123.69007, 2.8526,0.456416, 3.9558444,0.7911689, 0.10285195,-10.182344
333.43495, 0.513468,1.28367, 2.551443,1.2757215, 0.2551443,-6.1234632
56.309932, 1.882716,1.083988, 6.3293511,0.7911689, 0.10285195,-10.182344
;; (c)1997 STONE PRODUCTS CORPORATION
*DSLSTN, DRYSTACK LEDGESTONE
;%TYPE=MODEL
180, 2.76507,0.53067, 0,2.793, 0.61446,-2.17854
0, 0.05586,0.41895, 0,2.793, 0.36309,-2.42991
0, 0.41895,0.2793, 0,2.793, 0.19551,-2.59749
315, 0.39102,0.30723, 1.9749492,1.9749492, 0.039498997,-3.9103995
270, 0.39102,0.33516, 0,2.793, 0.02793,-2.76507
270, 0.39102,0.39102, 0,2.793, 0.05586,-2.73714
225, 0.41895,0.41895, 1.9749492,1.9749492, 0.039498997,-3.9103995
180, 1.20099,0.41895, 0,2.793, 0.78204,-2.01096
135, 1.22892,0.39102, 1.9749492,1.9749492, 0.039498997,-3.9103995
90, 1.22892,0.36309, 0,2.793, 0.02793,-2.76507
180, 1.20099,2.01096, 0,2.793, 1.17306,-1.61994
180, 0.94962,1.45236, 0,2.793, 0.53067,-2.26233
180, 1.59201,2.70921, 0,2.793, 1.14513,-1.64787
225, 2.03889,1.20099, 1.9749492,1.9749492, 0.039498997,-3.9103995
315, 2.03889,1.20099, 1.9749492,1.9749492, 0.039498997,-3.9103995
45, 1.25685,2.20647, 1.9749492,1.9749492, 0.039498997,-3.9103995
0, 0.44688,2.20647, 0,2.793, 0.80997,-1.98303
135, 2.12268,1.81545, 1.9749492,1.9749492, 0.039498997,-3.9103995
180, 2.56956,1.81545, 0,2.793, 0.44688,-2.34612
225, 1.64787,1.78752, 1.9749492,1.9749492, 0.039498997,-3.9103995
180, 2.59749,1.78752, 0,2.793, 0.94962,-1.84338
0, 0.22344,0.16758, 0,2.793, 0.05586,-2.73714
0, 0.5586,1.73166, 0,2.793, 0.02793,-2.76507
0, 0.05586,1.87131, 0,2.793, 0.16758,-2.62542
0, -0.02793,1.92717, 0,2.793, 0.05586,-2.73714
0, 2.45784,2.31819, 0,2.793, 0.11172,-2.68128
0, 2.5137,2.34612, 0,2.793, 0.22344,-2.56956
0, 0.5586,1.00548, 0,2.793, 0.02793,-2.76507
0, 0.19551,0.94962, 0,2.793, 0.25137,-2.54163
0, -0.11172,1.00548, 0,2.793, 0.08379,-2.70921
0, 2.40198,0.25137, 0,2.793, 0.05586,-2.73714
0, 2.45784,0.22344, 0,2.793, 0.08379,-2.70921
0, 2.20647,0.39102, 0,2.793, 0.02793,-2.76507
0, 2.59749,0.44688, 0,2.793, 0.05586,-2.73714
0, 0.89376,0.53067, 0,2.793, 0.05586,-2.73714
0, 0.97755,0.72618, 0,2.793, 0.08379,-2.70921
0, 1.64787,0.44688, 0,2.793, 0.02793,-2.76507
0, 1.56408,0.41895, 0,2.793, 0.25137,-2.54163
0, 2.03889,0.64239, 0,2.793, 0.02793,-2.76507
0, 2.06682,0.67032, 0,2.793, 0.11172,-2.68128
0, 1.56408,0.69825, 0,2.793, 0.02793,-2.76507
0, 1.36857,0.72618, 0,2.793, 0.2793,-2.5137
0, 2.17854,0.94962, 0,2.793, 0.19551,-2.59749
0, 1.87131,1.06134, 0,2.793, 0.08379,-2.70921
0, 1.1172,1.28478, 0,2.793, 0.02793,-2.76507
0, 1.3965,1.34064, 0,2.793, 0.05586,-2.73714
0, 1.42443,1.36857, 0,2.793, 0.05586,-2.73714
0, 0.64239,2.65335, 0,2.793, 0.02793,-2.76507
0, 0.64239,2.48577, 0,2.793, 0.16758,-2.62542
0, 1.14513,2.59749, 0,2.793, 0.05586,-2.73714
0, 1.20099,2.62542, 0,2.793, 0.22344,-2.56956
0, 0.94962,2.06682, 0,2.793, 0.05586,-2.73714
0, 0.33516,2.12268, 0,2.793, 0.08379,-2.70921
0, 0.30723,2.15061, 0,2.793, 0.36309,-2.42991
0, 1.92717,2.01096, 0,2.793, 0.02793,-2.76507
0, 1.48029,2.06682, 0,2.793, 0.02793,-2.76507
0, 1.53615,2.03889, 0,2.793, 0.08379,-2.70921
0, 2.29026,1.61994, 0,2.793, 0.13965,-2.65335
0, 2.17854,1.64787, 0,2.793, 0.13965,-2.65335
0, 1.70373,1.59201, 0,2.793, 0.05586,-2.73714
0, 1.78752,1.73166, 0,2.793, 0.05586,-2.73714
0, 1.75959,1.75959, 0,2.793, 0.05586,-2.73714
0, 1.20099,1.53615, 0,2.793, 0.08379,-2.70921
0, 0.78204,1.56408, 0,2.793, 0.05586,-2.73714
0, 0.75411,1.53615, 0,2.793, 0.05586,-2.73714
0, 0.53067,1.59201, 0,2.793, 0.05586,-2.73714
270, 0.39102,2.98851, 0,2.793, 0.25137,-2.54163
243.43495, 0.41895,3.04437, 2.4981351,1.2490676, 0.062453379,-6.1828844
251.56505, 0.92169,2.84886, 2.6496724,0.88322417, 0.088322425,-8.743919
270, 0.92169,2.96058, 0,2.793, 0.11172,-2.68128
288.43495, 0.89376,3.04437, 6.1825691,0.88322417, 0.088322425,-8.743919
333.43495, -0.25137,0.86583, 2.4981351,1.2490676, 0.062453379,-6.1828844
296.56505, -0.2793,0.92169, 3.7472028,1.2490676, 0.062453379,-6.1828844
270, -0.2793,1.03341, 0,2.793, 0.11172,-2.68128
206.56505, -0.22344,1.06134, 3.7472028,1.2490676, 0.062453379,-6.1828844
26.565051, -0.25137,2.84886, 3.7472028,1.2490676, 0.062453379,-6.1828844
348.69007, -0.22344,2.62542, 2.7387618,0.54775237, 0.14241563,-14.099146
333.43495, -0.2793,2.65335, 2.4981351,1.2490676, 0.062453379,-6.1828844
270, -0.2793,2.82093, 0,2.793, 0.16758,-2.62542
225, -0.25137,2.84886, 1.9749492,1.9749492, 0.039498997,-3.9103995
0, -0.25137,1.08927, 0,2.793, 0.58653,-2.20647
315, -0.30723,1.14513, 1.9749492,1.9749492, 0.078997966,-3.8709005
270, -0.30723,1.31271, 0,2.793, 0.16758,-2.62542
243.43495, -0.2793,1.36857, 2.4981351,1.2490676, 0.062453379,-6.1828844
225, -0.25137,1.3965, 1.9749492,1.9749492, 0.039498997,-3.9103995
194.03624, -0.13965,1.42443, 8.8062261,0.67740201, 0.11515835,-11.400676
0, 0.94962,1.45236, 0,2.793, 0.05586,-2.73714
0, 0.19551,0.22344, 0,2.793, 0.13965,-2.65335
0, 0.05586,0.19551, 0,2.793, 0.30723,-2.48577
45, 0.05586,2.37405, 1.9749492,1.9749492, 0.078997966,-3.8709005
90, 0.05586,2.26233, 0,2.793, 0.11172,-2.68128
135, 0.08379,2.2344, 1.9749492,1.9749492, 0.039498997,-3.9103995
116.56505, 0.41895,2.34612, 3.7472028,1.2490676, 0.062453379,-6.1828844
90, 0.41895,2.29026, 0,2.793, 0.05586,-2.73714
63.434949, 0.39102,2.2344, 2.4981351,1.2490676, 0.062453379,-6.1828844
288.43495, 2.17854,2.31819, 6.1825691,0.88322417, 0.088322425,-8.743919
270, 2.17854,2.34612, 0,2.793, 0.02793,-2.76507
243.43495, 2.20647,2.40198, 2.4981351,1.2490676, 0.062453379,-6.1828844
251.56505, 2.5137,0.94962, 2.6496724,0.88322417, 0.088322425,-8.743919
270, 2.5137,1.08927, 0,2.793, 0.13965,-2.65335
296.56505, 2.48577,1.14513, 3.7472028,1.2490676, 0.062453379,-6.1828844
288.43495, 1.22892,0.94962, 6.1825691,0.88322417, 0.088322425,-8.743919
270, 1.22892,0.97755, 0,2.793, 0.02793,-2.76507
243.43495, 1.25685,1.03341, 2.4981351,1.2490676, 0.062453379,-6.1828844
243.43495, 0.78204,0.92169, 2.4981351,1.2490676, 0.062453379,-6.1828844
270, 0.78204,0.97755, 0,2.793, 0.05586,-2.73714
296.56505, 0.75411,1.03341, 3.7472028,1.2490676, 0.062453379,-6.1828844
315, 1.22892,2.34612, 1.9749492,1.9749492, 0.078997966,-3.8709005
63.434949, 0.75411,1.75959, 2.4981351,1.2490676, 0.062453379,-6.1828844
90, 0.75411,1.70373, 0,2.793, 0.05586,-2.73714
135, 0.80997,1.64787, 1.9749492,1.9749492, 0.078997966,-3.8709005
90, 2.65335,1.50822, 0,2.793, 0.25137,-2.54163
45, 2.62542,1.48029, 1.9749492,1.9749492, 0.039498997,-3.9103995
270, 2.48577,1.42443, 0,2.793, 0.19551,-2.59749
270, 2.03889,1.42443, 0,2.793, 0.22344,-2.56956
108.43495, 2.82093,0.41895, 6.1825691,0.88322417, 0.088322425,-8.743919
90, 2.82093,0.25137, 0,2.793, 0.16758,-2.62542
78.690068, 2.793,0.11172, 2.7387618,0.54775237, 0.14241563,-14.099146
278.1301, 2.09475,0.30723, 16.984563,0.39498986, 0.19749493,-19.551998
270, 2.09475,0.41895, 0,2.793, 0.11172,-2.68128
251.56505, 2.12268,0.50274, 2.6496724,0.88322417, 0.088322425,-8.743919
333.43495, 0.69825,0.53067, 2.4981351,1.2490676, 0.062453379,-6.1828844
180, 0.72618,0.41895, 0,2.793, 0.19551,-2.59749
0, 0.41895,1.61994, 0,2.793, 1.14513,-1.64787
180, 0.89376,0.2793, 0,2.793, 0.2793,-2.5137
189.46232, 1.06134,0.30723, 14.234157,0.45916638, 0.16989157,-16.819264
180, 1.20099,0.30723, 0,2.793, 0.13965,-2.65335
0, 0.97755,0.41895, 0,2.793, 0.08379,-2.70921
0, 0.58653,0.41895, 0,2.793, 0.08379,-2.70921
180, 0.11172,1.42443, 0,2.793, 0.25137,-2.54163
90, 0.39102,1.45236, 0,2.793, 0.16758,-2.62542
63.434949, 0.36309,1.3965, 2.4981351,1.2490676, 0.062453379,-6.1828844
0, 0.2793,1.3965, 0,2.793, 0.08379,-2.70921
350.53768, 0.11172,1.42443, 2.7549982,0.45916638, 0.16989157,-16.819264
0, 0.19551,1.3965, 0,2.793, 0.13965,-2.65335
350.53768, 0.02793,1.42443, 2.7549982,0.45916638, 0.16989157,-16.819264
350.53768, 2.31819,2.87679, 2.7549982,0.45916638, 0.16989157,-16.819264
0, 1.73166,2.87679, 0,2.793, 0.58653,-2.20647
26.565051, 1.6758,2.84886, 3.7472028,1.2490676, 0.062453379,-6.1828844
0, 0.94962,2.84886, 0,2.793, 0.69825,-2.09475
0, 0.80997,3.0723, 0,2.793, 0.05586,-2.73714
341.56505, 0.72618,3.10023, 2.6496724,0.88322417, 0.088322425,-8.743919
0, 0.61446,3.10023, 0,2.793, 0.11172,-2.68128
9.4623222, 0.44688,3.0723, 14.234157,0.45916638, 0.16989157,-16.819264
348.69007, 0.22344,2.87679, 2.7387618,0.54775237, 0.14241563,-14.099146
0, -0.19551,2.87679, 0,2.793, 0.41895,-2.37405
8.1301023, 0.16758,2.59749, 16.984563,0.39498986, 0.19749493,-19.551998
0, -0.08379,2.59749, 0,2.793, 0.25137,-2.54163
281.30993, 0.39102,2.54163, 11.5028,0.54775237, 0.14241563,-14.099146
270, 0.39102,2.62542, 0,2.793, 0.08379,-2.70921
243.43495, 0.41895,2.68128, 2.4981351,1.2490676, 0.062453379,-6.1828844
0, 1.31271,2.73714, 0,2.793, 0.16758,-2.62542
0, 0.61446,2.73714, 0,2.793, 0.13965,-2.65335
0, 1.53615,2.37405, 0,2.793, 0.05586,-2.73714
9.4623222, 1.36857,2.34612, 14.234157,0.45916638, 0.16989157,-16.819264
0, 0.69825,2.34612, 0,2.793, 0.67032,-2.12268
0, 0.69825,2.34612, 0,2.793, 0.19551,-2.59749
353.65981, 0.44688,2.37405, 2.7759172,0.30843526, 0.2529169,-25.038774
180, 2.56956,2.45784, 0,2.793, 0.92169,-1.87131
0, 1.64787,2.59749, 0,2.793, 0.92169,-1.87131
0, 2.12268,2.01096, 0,2.793, 0.61446,-2.17854
0, 2.12268,2.17854, 0,2.793, 0.61446,-2.17854
0, 1.73166,2.17854, 0,2.793, 0.39102,-2.40198
333.43495, 1.6758,2.20647, 2.4981351,1.2490676, 0.062453379,-6.1828844
348.69007, 2.01096,2.45784, 2.7387618,0.54775237, 0.14241563,-14.099146
14.036243, 1.6758,2.42991, 8.8062261,0.67740201, 0.11515835,-11.400676
180, 0.75411,1.48029, 0,2.793, 0.22344,-2.56956
0, 0.02793,2.17854, 0,2.793, 1.17306,-1.61994
0, 0.89376,1.98303, 0,2.793, 0.16758,-2.62542
0, 0.44688,1.64787, 0,2.793, 0.2793,-2.5137
165.96376, 0.02793,1.61994, 2.7096079,0.67740201, 0.11515835,-11.400676
180, 0.22344,1.61994, 0,2.793, 0.19551,-2.59749
187.12502, 0.44688,1.64787, 19.746454,0.346429, 0.22517887,-22.292707
0, -0.08379,1.98303, 0,2.793, 0.80997,-1.98303
0, 0.94962,0.08379, 0,2.793, 1.1172,-1.6758
0, 1.81545,0.30723, 0,2.793, 0.13965,-2.65335
0, 0.94962,0.2793, 0,2.793, 1.1172,-1.6758
296.56505, 1.22892,0.39102, 3.7472028,1.2490676, 0.062453379,-6.1828844
270, 1.22892,0.41895, 0,2.793, 0.02793,-2.76507
255.96376, 1.25685,0.53067, 2.7096079,0.67740201, 0.11515835,-11.400676
0, 1.28478,0.5586, 0,2.793, 1.03341,-1.75959
284.03624, 1.59201,0.97755, 8.8062261,0.67740201, 0.11515835,-11.400676
270, 1.59201,1.06134, 0,2.793, 0.08379,-2.70921
251.56505, 1.61994,1.14513, 2.6496724,0.88322417, 0.088322425,-8.743919
0, 1.28478,0.80997, 0,2.793, 1.03341,-1.75959
180, 2.40198,1.17306, 0,2.793, 0.33516,-2.45784
206.56505, 2.45784,1.20099, 3.7472028,1.2490676, 0.062453379,-6.1828844
315, 1.59201,1.25685, 1.9749492,1.9749492, 0.039498997,-3.9103995
270, 1.59201,1.31271, 0,2.793, 0.05586,-2.73714
243.43495, 1.61994,1.42443, 2.4981351,1.2490676, 0.062453379,-6.1828844
135, 2.03889,1.3965, 1.9749492,1.9749492, 0.078997966,-3.8709005
165.96376, 1.75959,1.17306, 2.7096079,0.67740201, 0.11515835,-11.400676
180, 2.01096,1.17306, 0,2.793, 0.25137,-2.54163
0, 1.61994,1.14513, 0,2.793, 0.86583,-1.92717
26.565051, 0.67032,0.53067, 3.7472028,1.2490676, 0.062453379,-6.1828844
0, 0.5586,0.53067, 0,2.793, 0.11172,-2.68128
0, -0.13965,0.53067, 0,2.793, 0.2793,-2.5137
353.65981, -0.39102,0.5586, 2.7759172,0.30843526, 0.2529169,-25.038774
0, -0.39102,0.80997, 0,2.793, 1.1172,-1.6758
0, -0.19551,0.8379, 0,2.793, 0.92169,-1.87131
0, -0.22344,1.06134, 0,2.793, 0.94962,-1.84338
260.53768, 1.25685,0.61446, 2.7549982,0.45916638, 0.16989157,-16.819264
270, 1.25685,0.72618, 0,2.793, 0.11172,-2.68128
288.43495, 1.22892,0.80997, 6.1825691,0.88322417, 0.088322425,-8.743919
284.03624, 0.75411,0.5586, 8.8062261,0.67740201, 0.11515835,-11.400676
270, 0.75411,0.67032, 0,2.793, 0.11172,-2.68128
258.69007, 0.78204,0.80997, 2.7387618,0.54775237, 0.14241563,-14.099146
45, 1.20099,0.86583, 1.9749492,1.9749492, 0.039498997,-3.9103995
11.309932, 1.06134,0.8379, 11.5028,0.54775237, 0.14241563,-14.099146
0, 0.92169,0.8379, 0,2.793, 0.13965,-2.65335
345.96376, 0.80997,0.86583, 2.7096079,0.67740201, 0.11515835,-11.400676
198.43495, 0.89376,1.08927, 6.1825691,0.88322417, 0.088322425,-8.743919
180, 0.97755,1.08927, 0,2.793, 0.08379,-2.70921
165.96376, 1.08927,1.06134, 2.7096079,0.67740201, 0.11515835,-11.400676
180, 1.20099,1.06134, 0,2.793, 0.11172,-2.68128
0, 0.89376,1.08927, 0,2.793, 0.02793,-2.76507
0, 0.41895,1.08927, 0,2.793, 0.50274,-2.29026
345.96376, 0.80997,1.34064, 2.7096079,0.67740201, 0.11515835,-11.400676
0, 0.5586,1.34064, 0,2.793, 0.25137,-2.54163
11.309932, 0.41895,1.31271, 11.5028,0.54775237, 0.14241563,-14.099146
296.56505, 0.36309,1.17306, 3.7472028,1.2490676, 0.062453379,-6.1828844
270, 0.36309,1.20099, 0,2.793, 0.02793,-2.76507
251.56505, 0.39102,1.28478, 2.6496724,0.88322417, 0.088322425,-8.743919
270, 0.97755,1.42443, 0,2.793, 0.33516,-2.45784
351.8699, 0.75411,1.48029, 2.7649289,0.39498986, 0.19749493,-19.551998
0, 0.61446,1.48029, 0,2.793, 0.13965,-2.65335
0, 1.48029,1.08927, 0,2.793, 0.08379,-2.70921
14.036243, 1.36857,1.06134, 8.8062261,0.67740201, 0.11515835,-11.400676
0, 1.25685,1.06134, 0,2.793, 0.11172,-2.68128
348.69007, 1.1172,1.08927, 2.7387618,0.54775237, 0.14241563,-14.099146
0, 0.97755,1.08927, 0,2.793, 0.13965,-2.65335
180, 1.56408,1.45236, 0,2.793, 0.5586,-2.2344
14.036243, 2.5137,1.45236, 8.8062261,0.67740201, 0.11515835,-11.400676
0, 1.81545,1.45236, 0,2.793, 0.69825,-2.09475
243.43495, 2.09475,1.92717, 2.4981351,1.2490676, 0.062453379,-6.1828844
270, 2.09475,2.01096, 0,2.793, 0.08379,-2.70921
281.30993, 2.06682,2.15061, 11.5028,0.54775237, 0.14241563,-14.099146
296.56505, 1.22892,1.92717, 3.7472028,1.2490676, 0.062453379,-6.1828844
270, 1.22892,2.06682, 0,2.793, 0.13965,-2.65335
251.56505, 1.25685,2.15061, 2.6496724,0.88322417, 0.088322425,-8.743919
0, 1.25685,2.15061, 0,2.793, 0.80997,-1.98303
0, 1.28478,1.84338, 0,2.793, 0.75411,-2.03889
26.565051, 2.56956,1.81545, 3.7472028,1.2490676, 0.062453379,-6.1828844
333.43495, 2.59749,1.78752, 2.4981351,1.2490676, 0.062453379,-6.1828844
90, 1.61994,1.73166, 0,2.793, 0.02793,-2.76507
75.963757, 1.59201,1.61994, 2.7096079,0.67740201, 0.11515835,-11.400676
90, 1.59201,1.45236, 0,2.793, 0.16758,-2.62542
0, 0.78204,1.81545, 0,2.793, 0.78204,-2.01096
0, 0.89376,1.84338, 0,2.793, 0.13965,-2.65335
180, 1.20099,1.84338, 0,2.793, 0.41895,-2.37405
225, 1.22892,1.87131, 1.9749492,1.9749492, 0.039498997,-3.9103995
270, 1.22892,1.9551, 0,2.793, 0.08379,-2.70921
315, 1.20099,1.98303, 1.9749492,1.9749492, 0.039498997,-3.9103995
0, 0.78204,1.98303, 0,2.793, 0.41895,-2.37405
45, 0.75411,1.9551, 1.9749492,1.9749492, 0.039498997,-3.9103995
90, 0.75411,1.87131, 0,2.793, 0.08379,-2.70921
135, 0.78204,1.84338, 1.9749492,1.9749492, 0.039498997,-3.9103995
26.565051, 1.50822,1.45236, 3.7472028,1.2490676, 0.062453379,-6.1828844
0, 1.36857,1.45236, 0,2.793, 0.13965,-2.65335
0, 0.41895,1.48029, 0,2.793, 0.11172,-2.68128
180, 1.56408,1.64787, 0,2.793, 0.75411,-2.03889
180, 2.62542,1.98303, 0,2.793, 0.50274,-2.29026
225, 1.22892,0.33516, 1.9749492,1.9749492, 0.039498997,-3.9103995
45, 0.36309,0.22344, 1.9749492,1.9749492, 0.039498997,-3.9103995
315, 0.36309,0.39102, 1.9749492,1.9749492, 0.039498997,-3.9103995
45, 0.02793,0.36309, 1.9749492,1.9749492, 0.039498997,-3.9103995
315, 0.02793,0.25137, 1.9749492,1.9749492, 0.039498997,-3.9103995
45, 0.02793,0.16758, 1.9749492,1.9749492, 0.039498997,-3.9103995
315, 0.02793,0.11172, 1.9749492,1.9749492, 0.039498997,-3.9103995
225, 0.39102,0.11172, 1.9749492,1.9749492, 0.039498997,-3.9103995
315, 0.36309,0.19551, 1.9749492,1.9749492, 0.039498997,-3.9103995
315, 0.92169,0.11172, 1.9749492,1.9749492, 0.039498997,-3.9103995
45, 0.92169,0.25137, 1.9749492,1.9749492, 0.039498997,-3.9103995
225, 2.793,0.11172, 1.9749492,1.9749492, 0.039498997,-3.9103995
315, 2.76507,0.53067, 1.9749492,1.9749492, 0.039498997,-3.9103995
45, 2.12268,0.50274, 1.9749492,1.9749492, 0.039498997,-3.9103995
315, 2.12268,0.11172, 1.9749492,1.9749492, 0.039498997,-3.9103995
225, 2.09475,0.11172, 1.9749492,1.9749492, 0.039498997,-3.9103995
315, 2.06682,0.2793, 1.9749492,1.9749492, 0.039498997,-3.9103995
225, 2.09475,0.33516, 1.9749492,1.9749492, 0.039498997,-3.9103995
315, 2.06682,0.53067, 1.9749492,1.9749492, 0.039498997,-3.9103995
315, 1.25685,0.33516, 1.9749492,1.9749492, 0.039498997,-3.9103995
45, 1.25685,0.53067, 1.9749492,1.9749492, 0.039498997,-3.9103995
45, 1.20099,0.41895, 1.9749492,1.9749492, 0.039498997,-3.9103995
315, 0.78204,0.44688, 1.9749492,1.9749492, 0.039498997,-3.9103995
225, 0.75411,0.44688, 1.9749492,1.9749492, 0.039498997,-3.9103995
315, 0.02793,0.44688, 1.9749492,1.9749492, 0.039498997,-3.9103995
45, 0.02793,0.50274, 1.9749492,1.9749492, 0.039498997,-3.9103995
135, 1.28478,0.5586, 1.9749492,1.9749492, 0.039498997,-3.9103995
225, 2.34612,0.58653, 1.9749492,1.9749492, 0.039498997,-3.9103995
315, 2.31819,0.80997, 1.9749492,1.9749492, 0.039498997,-3.9103995
45, 1.25685,0.78204, 1.9749492,1.9749492, 0.039498997,-3.9103995
315, 1.20099,0.8379, 1.9749492,1.9749492, 0.039498997,-3.9103995
315, 1.20099,1.06134, 1.9749492,1.9749492, 0.039498997,-3.9103995
45, 0.78204,1.03341, 1.9749492,1.9749492, 0.039498997,-3.9103995
315, 0.78204,0.89376, 1.9749492,1.9749492, 0.039498997,-3.9103995
45, 0.78204,0.80997, 1.9749492,1.9749492, 0.039498997,-3.9103995
225, 0.75411,0.58653, 1.9749492,1.9749492, 0.039498997,-3.9103995
315, -0.41895,0.58653, 1.9749492,1.9749492, 0.039498997,-3.9103995
225, -0.39102,0.80997, 1.9749492,1.9749492, 0.039498997,-3.9103995
315, 0.72618,0.80997, 1.9749492,1.9749492, 0.039498997,-3.9103995
225, 0.75411,0.86583, 1.9749492,1.9749492, 0.039498997,-3.9103995
315, 0.72618,1.06134, 1.9749492,1.9749492, 0.039498997,-3.9103995
225, 0.36309,1.1172, 1.9749492,1.9749492, 0.039498997,-3.9103995
315, 0.33516,1.3965, 1.9749492,1.9749492, 0.039498997,-3.9103995
45, -0.11172,1.59201, 1.9749492,1.9749492, 0.039498997,-3.9103995
315, -0.11172,1.45236, 1.9749492,1.9749492, 0.039498997,-3.9103995
45, 0.97755,1.42443, 1.9749492,1.9749492, 0.039498997,-3.9103995
45, 0.92169,1.08927, 1.9749492,1.9749492, 0.039498997,-3.9103995
315, 0.39102,1.1172, 1.9749492,1.9749492, 0.039498997,-3.9103995
45, 0.39102,1.28478, 1.9749492,1.9749492, 0.039498997,-3.9103995
315, 0.92169,1.31271, 1.9749492,1.9749492, 0.039498997,-3.9103995
225, 0.97755,1.36857, 1.9749492,1.9749492, 0.039498997,-3.9103995
315, 0.94962,1.45236, 1.9749492,1.9749492, 0.039498997,-3.9103995
315, 0.39102,1.36857, 1.9749492,1.9749492, 0.039498997,-3.9103995
45, 0.39102,1.42443, 1.9749492,1.9749492, 0.039498997,-3.9103995
315, 0.39102,1.50822, 1.9749492,1.9749492, 0.039498997,-3.9103995
45, 0.39102,1.59201, 1.9749492,1.9749492, 0.039498997,-3.9103995
315, 1.56408,1.61994, 1.9749492,1.9749492, 0.039498997,-3.9103995
225, 1.59201,1.50822, 1.9749492,1.9749492, 0.039498997,-3.9103995
315, 1.56408,1.45236, 1.9749492,1.9749492, 0.039498997,-3.9103995
45, 1.56408,1.08927, 1.9749492,1.9749492, 0.039498997,-3.9103995
45, 1.56408,0.8379, 1.9749492,1.9749492, 0.039498997,-3.9103995
315, 1.25685,0.86583, 1.9749492,1.9749492, 0.039498997,-3.9103995
45, 1.25685,1.03341, 1.9749492,1.9749492, 0.039498997,-3.9103995
315, 1.56408,1.06134, 1.9749492,1.9749492, 0.039498997,-3.9103995
135, 1.64787,0.8379, 1.9749492,1.9749492, 0.039498997,-3.9103995
225, 2.48577,0.86583, 1.9749492,1.9749492, 0.039498997,-3.9103995
315, 1.61994,1.22892, 1.9749492,1.9749492, 0.039498997,-3.9103995
45, 1.61994,1.42443, 1.9749492,1.9749492, 0.039498997,-3.9103995
45, 2.45784,1.20099, 1.9749492,1.9749492, 0.039498997,-3.9103995
45, 2.03889,1.42443, 1.9749492,1.9749492, 0.039498997,-3.9103995
315, 2.45784,1.45236, 1.9749492,1.9749492, 0.039498997,-3.9103995
135, 2.65335,1.9551, 1.9749492,1.9749492, 0.039498997,-3.9103995
45, 2.62542,1.84338, 1.9749492,1.9749492, 0.039498997,-3.9103995
225, 1.59201,1.6758, 1.9749492,1.9749492, 0.039498997,-3.9103995
315, 1.56408,1.81545, 1.9749492,1.9749492, 0.039498997,-3.9103995
135, 2.76507,2.15061, 1.9749492,1.9749492, 0.039498997,-3.9103995
45, 2.73714,2.01096, 1.9749492,1.9749492, 0.039498997,-3.9103995
315, 2.09475,2.03889, 1.9749492,1.9749492, 0.039498997,-3.9103995
45, 2.09475,2.15061, 1.9749492,1.9749492, 0.039498997,-3.9103995
45, 2.09475,1.9551, 1.9749492,1.9749492, 0.039498997,-3.9103995
225, 2.06682,1.87131, 1.9749492,1.9749492, 0.039498997,-3.9103995
315, 1.25685,1.87131, 1.9749492,1.9749492, 0.039498997,-3.9103995
225, 0.75411,1.6758, 1.9749492,1.9749492, 0.039498997,-3.9103995
315, -0.11172,1.6758, 1.9749492,1.9749492, 0.039498997,-3.9103995
45, -0.11172,1.9551, 1.9749492,1.9749492, 0.039498997,-3.9103995
315, 0.72618,1.98303, 1.9749492,1.9749492, 0.039498997,-3.9103995
225, 1.22892,2.03889, 1.9749492,1.9749492, 0.039498997,-3.9103995
315, 1.20099,2.17854, 1.9749492,1.9749492, 0.039498997,-3.9103995
315, 0,2.03889, 1.9749492,1.9749492, 0.039498997,-3.9103995
225, 0.02793,2.17854, 1.9749492,1.9749492, 0.039498997,-3.9103995
315, -0.16758,2.48577, 1.9749492,1.9749492, 0.039498997,-3.9103995
45, -0.16758,2.56956, 1.9749492,1.9749492, 0.039498997,-3.9103995
315, 0.36309,2.84886, 1.9749492,1.9749492, 0.039498997,-3.9103995
225, 0.39102,2.65335, 1.9749492,1.9749492, 0.039498997,-3.9103995
315, 0.36309,2.59749, 1.9749492,1.9749492, 0.039498997,-3.9103995
225, 0.39102,2.48577, 1.9749492,1.9749492, 0.039498997,-3.9103995
315, 0.08379,2.2344, 1.9749492,1.9749492, 0.039498997,-3.9103995
225, 0.39102,2.2344, 1.9749492,1.9749492, 0.039498997,-3.9103995
315, 0.36309,2.42991, 1.9749492,1.9749492, 0.039498997,-3.9103995
315, 0.41895,2.2344, 1.9749492,1.9749492, 0.039498997,-3.9103995
45, 0.41895,2.31819, 1.9749492,1.9749492, 0.039498997,-3.9103995
315, 1.22892,2.34612, 1.9749492,1.9749492, 0.039498997,-3.9103995
315, 1.28478,2.20647, 1.9749492,1.9749492, 0.039498997,-3.9103995
45, 1.28478,2.31819, 1.9749492,1.9749492, 0.039498997,-3.9103995
225, 1.64787,2.20647, 1.9749492,1.9749492, 0.039498997,-3.9103995
315, 1.61994,2.34612, 1.9749492,1.9749492, 0.039498997,-3.9103995
315, 1.64787,2.2344, 1.9749492,1.9749492, 0.039498997,-3.9103995
225, 2.17854,2.2344, 1.9749492,1.9749492, 0.078997966,-3.8709005
315, 2.20647,2.2344, 1.9749492,1.9749492, 0.039498997,-3.9103995
225, 2.84886,2.2344, 1.9749492,1.9749492, 0.039498997,-3.9103995
315, 2.82093,2.42991, 1.9749492,1.9749492, 0.039498997,-3.9103995
45, 2.20647,2.40198, 1.9749492,1.9749492, 0.039498997,-3.9103995
315, 2.15061,2.42991, 1.9749492,1.9749492, 0.039498997,-3.9103995
45, 1.64787,2.40198, 1.9749492,1.9749492, 0.039498997,-3.9103995
45, 1.59201,2.37405, 1.9749492,1.9749492, 0.039498997,-3.9103995
315, 0.41895,2.40198, 1.9749492,1.9749492, 0.039498997,-3.9103995
225, 0.44688,2.70921, 1.9749492,1.9749492, 0.039498997,-3.9103995
315, 1.59201,2.70921, 1.9749492,1.9749492, 0.039498997,-3.9103995
225, 1.64787,2.76507, 1.9749492,1.9749492, 0.039498997,-3.9103995
315, 0.92169,2.76507, 1.9749492,1.9749492, 0.039498997,-3.9103995
45, 0.92169,2.82093, 1.9749492,1.9749492, 0.039498997,-3.9103995
45, 0.86583,2.73714, 1.9749492,1.9749492, 0.039498997,-3.9103995
45, 0.41895,3.04437, 1.9749492,1.9749492, 0.039498997,-3.9103995
315, 0.86583,3.0723, 1.9749492,1.9749492, 0.039498997,-3.9103995
45, 2.56956,2.45784, 1.9749492,1.9749492, 0.039498997,-3.9103995
315, 1.61994,2.48577, 1.9749492,1.9749492, 0.039498997,-3.9103995
225, 1.64787,2.59749, 1.9749492,1.9749492, 0.039498997,-3.9103995
315, 2.56956,2.59749, 1.9749492,1.9749492, 0.039498997,-3.9103995
45, 2.48577,2.62542, 1.9749492,1.9749492, 0.039498997,-3.9103995
315, 1.64787,2.65335, 1.9749492,1.9749492, 0.039498997,-3.9103995
45, 1.64787,2.82093, 1.9749492,1.9749492, 0.039498997,-3.9103995
315, 2.48577,2.84886, 1.9749492,1.9749492, 0.039498997,-3.9103995
270, -0.41895,0.78204, 0,2.793, 0.19551,-2.59749
270, 0.39102,2.793, 0,2.793, 0.13965,-2.65335
270, 1.61994,2.68128, 0,2.793, 0.2793,-2.5137
270, 1.64787,2.40198, 0,2.793, 0.19551,-2.59749
90, 2.17854,2.2344, 0,2.793, 0.16758,-2.62542
0, 0.44688,2.34612, 0,2.793, 0.78204,-2.01096
90, 0.41895,2.2344, 0,2.793, 0.08379,-2.70921
0, 1.31271,2.34612, 0,2.793, 0.30723,-2.48577
270, 1.64787,2.31819, 0,2.793, 0.08379,-2.70921
90, 1.28478,2.20647, 0,2.793, 0.11172,-2.68128
270, 0.75411,1.9551, 0,2.793, 0.2793,-2.5137
270, -0.11172,1.9551, 0,2.793, 0.2793,-2.5137
270, 0,2.15061, 0,2.793, 0.11172,-2.68128
90, 2.65335,1.87131, 0,2.793, 0.08379,-2.70921
270, 2.09475,1.9551, 0,2.793, 0.11172,-2.68128
90, 2.76507,2.03889, 0,2.793, 0.11172,-2.68128
0, 2.2344,2.42991, 0,2.793, 0.5586,-2.2344
270, 2.84886,2.40198, 0,2.793, 0.16758,-2.62542
0, 0.11172,2.20647, 0,2.793, 0.25137,-2.54163
270, -0.16758,2.56956, 0,2.793, 0.08379,-2.70921
270, 1.61994,2.56956, 0,2.793, 0.08379,-2.70921
0, 1.31271,2.17854, 0,2.793, 0.30723,-2.48577
180, 0.36309,2.42991, 0,2.793, 0.25137,-2.54163
180, 2.82093,2.42991, 0,2.793, 0.02793,-2.76507
180, 2.82093,2.20647, 0,2.793, 0.02793,-2.76507
0, 0,2.45784, 0,2.793, 0.36309,-2.42991
90, 0.39102,2.48577, 0,2.793, 0.08379,-2.70921
180, 0.36309,2.59749, 0,2.793, 0.36309,-2.42991
270, 1.22892,2.15061, 0,2.793, 0.11172,-2.68128
270, 2.59749,2.56956, 0,2.793, 0.08379,-2.70921
0, -0.13965,2.59749, 0,2.793, 0.13965,-2.65335
0, -0.13965,2.45784, 0,2.793, 0.13965,-2.65335
0, 2.2344,2.20647, 0,2.793, 0.5586,-2.2344
270, 2.09475,2.15061, 0,2.793, 0.11172,-2.68128
90, 1.59201,1.50822, 0,2.793, 0.08379,-2.70921
180, 0.39102,1.61994, 0,2.793, 0.39102,-2.40198
270, 1.59201,1.78752, 0,2.793, 0.11172,-2.68128
270, 0.36309,1.36857, 0,2.793, 0.25137,-2.54163
180, 0.33516,1.08927, 0,2.793, 0.33516,-2.45784
270, 0.75411,0.78204, 0,2.793, 0.19551,-2.59749
0, 0.39102,2.73714, 0,2.793, 0.47481,-2.31819
270, 0.02793,0.36309, 0,2.793, 0.11172,-2.68128
0, 0.05586,0.08379, 0,2.793, 0.30723,-2.48577
90, 0.39102,0.11172, 0,2.793, 0.05586,-2.73714
180, 0.36309,0.39102, 0,2.793, 0.30723,-2.48577
270, 0.92169,2.793, 0,2.793, 0.02793,-2.76507
0, 0.94962,2.73714, 0,2.793, 0.67032,-2.12268
90, 1.64787,2.76507, 0,2.793, 0.02793,-2.76507
90, 0.92169,2.793, 0,2.793, 0.02793,-2.76507
270, 1.64787,2.84886, 0,2.793, 0.05586,-2.73714
270, 1.64787,2.793, 0,2.793, 0.13965,-2.65335
0, 1.6758,2.62542, 0,2.793, 0.80997,-1.98303
90, 2.5137,2.65335, 0,2.793, 0.13965,-2.65335
90, 1.64787,2.793, 0,2.793, 0.02793,-2.76507
270, 2.5137,2.82093, 0,2.793, 0.02793,-2.76507
0, 2.15061,0.08379, 0,2.793, 0.61446,-2.17854
90, 0.39102,2.793, 0,2.793, 0.02793,-2.76507
0, 0.05586,0.22344, 0,2.793, 0.30723,-2.48577
270, 0.02793,0.16758, 0,2.793, 0.05586,-2.73714
90, 0.39102,0.25137, 0,2.793, 0.11172,-2.68128
270, 0.92169,0.25137, 0,2.793, 0.13965,-2.65335
90, 2.09475,0.11172, 0,2.793, 0.13965,-2.65335
270, 0.75411,0.50274, 0,2.793, 0.05586,-2.73714
90, 0.02793,0.44688, 0,2.793, 0.05586,-2.73714
0, 0.05586,0.53067, 0,2.793, 0.64239,-2.15061
270, 1.22892,0.36309, 0,2.793, 0.02793,-2.76507
90, 0.39102,0.33516, 0,2.793, 0.02793,-2.76507
0, 1.28478,0.30723, 0,2.793, 0.78204,-2.01096
90, 2.09475,0.33516, 0,2.793, 0.16758,-2.62542
177.95459, 2.06682,0.53067, 2.7912205,0.099686443, 0.78253858,-77.47132
0, 1.28478,0.8379, 0,2.793, 0.2793,-2.5137
90, 1.59201,0.86583, 0,2.793, 0.16758,-2.62542
180, 1.56408,1.06134, 0,2.793, 0.2793,-2.5137
0, 1.64787,0.8379, 0,2.793, 0.80997,-1.98303
180, 1.98303,1.45236, 0,2.793, 0.39102,-2.40198
90, 1.22892,0.89376, 0,2.793, 0.13965,-2.65335
270, 0.78204,1.03341, 0,2.793, 0.13965,-2.65335
90, 1.25685,0.58653, 0,2.793, 0.19551,-2.59749
270, 2.34612,0.78204, 0,2.793, 0.19551,-2.59749
180, 1.20099,0.8379, 0,2.793, 0.39102,-2.40198
0, 0.80997,0.41895, 0,2.793, 0.39102,-2.40198
180, 0,1.61994, 0,2.793, 0.08379,-2.70921
270, -0.11172,1.59201, 0,2.793, 0.13965,-2.65335
90, 0.39102,1.50822, 0,2.793, 0.08379,-2.70921
90, 0.94962,1.1172, 0,2.793, 0.16758,-2.62542
270, 0.39102,1.42443, 0,2.793, 0.05586,-2.73714
0, 0.41895,1.34064, 0,2.793, 0.53067,-2.26233
90, 0.97755,1.36857, 0,2.793, 0.05586,-2.73714
270, 1.59201,1.42443, 0,2.793, 0.30723,-2.48577
;; (c)1997 STONE PRODUCTS CORPORATION
*ECSTN, EUROPEAN CASTLE STONE
;%TYPE=MODEL
270, -0.84854,2.13598, 0,2.926, 0.84854,-2.07746
270, 1.52152,2.80896, 0,2.926, 0.40964,-2.51636
270, 2.37006,2.39932, 0,2.926, 0.26334,-2.66266
270, 2.72118,0.11704, 0,2.926, 0.23408,-2.69192
0, 2.37006,0.11704, 0,2.926, 0.61446,-2.31154
90, 2.98452,-0.11704, 0,2.926, 0.46816,-2.45784
0, 2.37006,-0.11704, 0,2.926, 0.61446,-2.31154
0, 1.08262,0.1463, 0,2.926, 0.4389,-2.4871
0, 0.61446,-0.11704, 0,2.926, 0.90706,-2.01894
270, 1.08262,0.5852, 0,2.926, 0.70224,-2.22376
270, 0.61446,0.5852, 0,2.926, 0.70224,-2.22376
0, 0.32186,0.35112, 0,2.926, 0.2926,-2.6334
180, 1.52152,0.8778, 0,2.926, 0.7315,-2.1945
270, 2.0482,0.5852, 0,2.926, 0.32186,-2.60414
0, 1.52152,0.26334, 0,2.926, 0.84854,-2.07746
0, 1.52152,-0.52668, 0,2.926, 0.84854,-2.07746
270, 1.52152,0.96558, 0,2.926, 1.49226,-1.43374
0, 1.34596,0.96558, 0,2.926, 1.0241,-1.9019
180, 0.79002,1.25818, 0,2.926, 0.46816,-2.45784
180, 2.37006,0.5852, 0,2.926, 2.0482,-0.8778
180, 3.24786,0.35112, 0,2.926, 0.8778,-2.0482
270, 3.24786,1.28744, 0,2.926, 0.93632,-1.98968
270, 2.37006,1.28744, 0,2.926, 1.81412,-1.11188
270, 1.93116,1.43374, 0,2.926, 0.46816,-2.45784
270, 1.34596,1.43374, 0,2.926, 0.55594,-2.37006
270, 0.79002,1.43374, 0,2.926, 0.84854,-2.07746
270, -0.1463,2.13598, 0,2.926, 0.84854,-2.07746
180, -0.1463,1.93116, 0,2.926, 0.70224,-2.22376
180, 0.32186,1.52152, 0,2.926, 0.46816,-2.45784
270, 0.32186,2.13598, 0,2.926, 1.78486,-1.14114
180, 2.07746,1.43374, 0,2.926, 1.7556,-1.1704
0, 1.1704,1.69708, 0,2.926, 0.90706,-2.01894
270, 1.1704,2.39932, 0,2.926, 0.96558,-1.96042
270, 1.0241,2.80896, 0,2.926, 0.67298,-2.25302
270, 0.05852,2.80896, 0,2.926, 0.67298,-2.25302
90, -0.55594,2.13598, 0,2.926, 0.67298,-2.25302
270, 2.07746,2.39932, 0,2.926, 1.11188,-1.81412
0, 1.93116,1.28744, 0,2.926, 1.3167,-1.6093
0, -0.84854,1.28744, 0,2.926, 1.1704,-1.7556
0, 2.07746,2.13598, 0,2.926, 0.2926,-2.6334
0, -0.84854,2.13598, 0,2.926, 2.01894,-0.90706
0, 1.0241,2.39932, 0,2.926, 1.34596,-1.58004
0, -0.52668,2.80896, 0,2.926, 2.0482,-0.8778
;; (c)1997 STONE PRODUCTS CORPORATION
*FLDSTN, FIELDSTONE
;%TYPE=MODEL
33.690068, 3.032705,2.532465, 4.3356754,0.86713509, 0.11272755,-11.160028
9.4623222, 2.845115,2.5012, 15.933796,0.51399344, 0.19017759,-18.827579
0, 2.68879,2.5012, 0,3.1265, 0.156325,-2.970175
341.56505, 2.5012,2.56373, 2.9660583,0.98868612, 0.19773721,-9.6891239
326.30993, 2.407405,2.62626, 6.9370806,0.86713509, 0.11272755,-11.160028
306.8699, 2.31361,2.75132, 4.3771,0.6253, 0.156325,-15.476175
291.80141, 2.25108,2.907645, 6.9669177,0.58057648, 0.16836718,-16.668351
270, 2.25108,2.970175, 0,3.1265, 0.06253,-3.06397
315, 1.62578,2.25108, 2.2107693,2.2107693, 0.13264617,-4.2888926
341.56505, 1.531985,2.282345, 2.9660583,0.98868612, 0.098868622,-9.7879925
0, 1.406925,2.282345, 0,3.1265, 0.12506,-3.00144
333.43495, 2.782585,0.81289, 2.7964266,1.3982133, 0.069910666,-6.9211559
315, 2.75132,0.844155, 2.2107693,2.2107693, 0.044215401,-4.3773233
270, 2.75132,0.906685, 0,3.1265, 0.06253,-3.06397
236.30993, 2.81385,1.00048, 6.9370806,0.86713509, 0.11272755,-11.160028
236.30993, 2.87638,1.094275, 6.9370806,0.86713509, 0.11272755,-11.160028
225, 2.907645,1.12554, 2.2107693,2.2107693, 0.044215401,-4.3773233
213.69007, 3.00144,1.18807, 4.3356754,0.86713509, 0.11272755,-11.160028
213.69007, 3.095235,1.2506, 4.3356754,0.86713509, 0.11272755,-11.160028
45, 2.87638,1.281865, 2.2107693,2.2107693, 0.13264617,-4.2888926
45, 2.782585,1.18807, 2.2107693,2.2107693, 0.13264617,-4.2888926
14.036243, 2.657525,1.156805, 9.8577392,0.75828765, 0.12890891,-12.761981
333.43495, 2.970175,1.68831, 2.7964266,1.3982133, 0.069910666,-6.9211559
0, 2.845115,1.68831, 0,3.1265, 0.12506,-3.00144
11.309932, 2.68879,1.657045, 12.876299,0.61315711, 0.15942086,-15.782664
26.565051, 2.62626,1.62578, 4.1946399,1.3982133, 0.069910666,-6.9211559
56.309932, 2.56373,1.531985, 6.9370806,0.86713509, 0.11272755,-11.160028
45, 2.532465,1.50072, 2.2107693,2.2107693, 0.044215401,-4.3773233
270, 2.62626,1.06301, 0,3.1265, 0.031265,-3.095235
315, 2.56373,1.12554, 2.2107693,2.2107693, 0.08843077,-4.3331079
333.43495, 2.5012,1.156805, 2.7964266,1.3982133, 0.069910666,-6.9211559
315, 2.469935,1.18807, 2.2107693,2.2107693, 0.044215401,-4.3773233
315, 2.37614,1.281865, 2.2107693,2.2107693, 0.13264617,-4.2888926
333.43495, 2.31361,1.31313, 2.7964266,1.3982133, 0.069910666,-6.9211559
0, 2.25108,1.31313, 0,3.1265, 0.06253,-3.06397
345.96376, 2.12602,1.344395, 3.0331505,0.75828765, 0.12890891,-12.761981
345.96376, 2.00096,1.37566, 3.0331505,0.75828765, 0.12890891,-12.761981
0, 1.93843,1.37566, 0,3.1265, 0.06253,-3.06397
341.56505, 1.844635,1.406925, 2.9660583,0.98868612, 0.098868622,-9.7879925
333.43495, 1.782105,1.43819, 2.7964266,1.3982133, 0.069910666,-6.9211559
0, 1.75084,1.43819, 0,3.1265, 0.031265,-3.095235
26.565051, 1.68831,1.406925, 4.1946399,1.3982133, 0.069910666,-6.9211559
161.56505, 1.18807,0.343915, 2.9660583,0.98868612, 0.098868622,-9.7879925
180, 1.2506,0.343915, 0,3.1265, 0.06253,-3.06397
243.43495, 1.281865,0.406445, 2.7964266,1.3982133, 0.069910666,-6.9211559
270, 1.281865,0.50024, 0,3.1265, 0.093795,-3.032705
288.43495, 1.2506,0.594035, 6.9208028,0.98868612, 0.098868622,-9.7879925
315, 1.18807,0.656565, 2.2107693,2.2107693, 0.08843077,-4.3331079
135, 1.37566,1.031745, 2.2107693,2.2107693, 0.08843077,-4.3331079
108.43495, 1.406925,0.93795, 6.9208028,0.98868612, 0.098868622,-9.7879925
90, 1.406925,0.81289, 0,3.1265, 0.12506,-3.00144
45, 1.37566,0.781625, 2.2107693,2.2107693, 0.044215401,-4.3773233
33.690068, 1.281865,0.719095, 4.3356754,0.86713509, 0.11272755,-11.160028
0, 1.2506,0.719095, 0,3.1265, 0.031265,-3.095235
348.69007, 1.094275,0.75036, 3.0657855,0.61315711, 0.15942086,-15.782664
236.30993, 0.656565,0.969215, 6.9370806,0.86713509, 0.11272755,-11.160028
248.19859, 0.719095,1.12554, 9.8698001,0.58057648, 0.16836718,-16.668351
236.30993, 0.781625,1.219335, 6.9370806,0.86713509, 0.11272755,-11.160028
243.43495, 0.844155,1.344395, 2.7964266,1.3982133, 0.13982133,-6.8512452
270, 0.844155,1.469455, 0,3.1265, 0.12506,-3.00144
315, 0.719095,1.594515, 2.2107693,2.2107693, 0.17686154,-4.2446772
270, 3.282825,0.468975, 0,3.1265, 0.031265,-3.095235
315, 3.25156,0.50024, 2.2107693,2.2107693, 0.044215401,-4.3773233
341.56505, 3.157765,0.531505, 2.9660583,0.98868612, 0.098868622,-9.7879925
315, 3.1265,0.56277, 2.2107693,2.2107693, 0.044215401,-4.3773233
296.56505, 3.095235,0.6253, 4.1946399,1.3982133, 0.069910666,-6.9211559
315, 3.06397,0.656565, 2.2107693,2.2107693, 0.044215401,-4.3773233
333.43495, 2.93891,0.719095, 2.7964266,1.3982133, 0.13982133,-6.8512452
333.43495, 2.87638,0.75036, 2.7964266,1.3982133, 0.069910666,-6.9211559
341.56505, 2.782585,0.781625, 2.9660583,0.98868612, 0.098868622,-9.7879925
90, 2.532465,0.719095, 0,3.1265, 0.031265,-3.095235
90, 2.532465,0.656565, 0,3.1265, 0.06253,-3.06397
108.43495, 2.56373,0.56277, 6.9208028,0.98868612, 0.098868622,-9.7879925
90, 2.56373,0.50024, 0,3.1265, 0.06253,-3.06397
63.434949, 2.532465,0.43771, 2.7964266,1.3982133, 0.069910666,-6.9211559
90, 2.532465,0.406445, 0,3.1265, 0.031265,-3.095235
108.43495, 2.56373,0.31265, 6.9208028,0.98868612, 0.098868622,-9.7879925
270, 1.281865,0.18759, 0,3.1265, 0.06253,-3.06397
315, 1.219335,0.25012, 2.2107693,2.2107693, 0.08843077,-4.3331079
329.03624, 1.06301,0.343915, 6.9704743,0.53619034, 0.18230471,-18.048166
315, 0.969215,0.43771, 2.2107693,2.2107693, 0.13264617,-4.2888926
333.43495, 0.844155,0.50024, 2.7964266,1.3982133, 0.13982133,-6.8512452
315, 0.75036,0.594035, 2.2107693,2.2107693, 0.13264617,-4.2888926
333.43495, 0.6253,0.656565, 2.7964266,1.3982133, 0.13982133,-6.8512452
338.19859, 0.468975,0.719095, 9.8698001,0.58057648, 0.16836718,-16.668351
0, 0.406445,0.719095, 0,3.1265, 0.06253,-3.06397
18.434949, 0.31265,0.68783, 6.9208028,0.98868612, 0.098868622,-9.7879925
348.69007, 2.282345,2.157285, 3.0657855,0.61315711, 0.15942086,-15.782664
0, 2.219815,2.157285, 0,3.1265, 0.06253,-3.06397
0, 1.43819,0.531505, 0,3.1265, 0.031265,-3.095235
0, 1.469455,0.56277, 0,3.1265, 0.06253,-3.06397
0, 1.657045,0.906685, 0,3.1265, 0.031265,-3.095235
108.43495, 3.157765,2.907645, 6.9208028,0.98868612, 0.098868622,-9.7879925
90, 3.157765,2.782585, 0,3.1265, 0.12506,-3.00144
90, 3.157765,2.75132, 0,3.1265, 0.031265,-3.095235
78.690068, 3.1265,2.594995, 3.0657855,0.61315711, 0.15942086,-15.782664
315, 2.37614,2.62626, 2.2107693,2.2107693, 0.08843077,-4.3331079
315, 2.344875,2.657525, 2.2107693,2.2107693, 0.044215401,-4.3773233
251.56505, 2.282345,3.06397, 2.9660583,0.98868612, 0.098868622,-9.7879925
251.56505, 2.31361,3.157765, 2.9660583,0.98868612, 0.098868622,-9.7879925
270, 2.31361,3.31409, 0,3.1265, 0.156325,-2.970175
225, 2.344875,3.345355, 2.2107693,2.2107693, 0.044215401,-4.3773233
206.56505, 2.407405,3.37662, 4.1946399,1.3982133, 0.069910666,-6.9211559
206.56505, 2.469935,3.407885, 4.1946399,1.3982133, 0.069910666,-6.9211559
180, 2.56373,3.407885, 0,3.1265, 0.093795,-3.032705
146.30993, 2.657525,3.345355, 6.9370806,0.86713509, 0.11272755,-11.160028
123.69007, 2.720055,3.25156, 4.3356754,0.86713509, 0.11272755,-11.160028
135, 2.782585,3.18903, 2.2107693,2.2107693, 0.08843077,-4.3331079
180, 2.845115,3.18903, 0,3.1265, 0.06253,-3.06397
180, 2.907645,3.18903, 0,3.1265, 0.06253,-3.06397
206.56505, 2.970175,3.220295, 4.1946399,1.3982133, 0.069910666,-6.9211559
225, 3.00144,3.25156, 2.2107693,2.2107693, 0.044215401,-4.3773233
206.56505, 3.06397,3.282825, 4.1946399,1.3982133, 0.069910666,-6.9211559
180, 3.095235,3.282825, 0,3.1265, 0.031265,-3.095235
116.56505, 3.1265,3.220295, 4.1946399,1.3982133, 0.069910666,-6.9211559
90, 3.1265,3.00144, 0,3.1265, 0.218855,-2.907645
116.56505, 2.31361,3.282825, 4.1946399,1.3982133, 0.069910666,-6.9211559
90, 2.31361,3.220295, 0,3.1265, 0.06253,-3.06397
71.565051, 2.282345,3.1265, 2.9660583,0.98868612, 0.098868622,-9.7879925
56.309932, 2.219815,3.032705, 6.9370806,0.86713509, 0.11272755,-11.160028
45, 2.157285,2.970175, 2.2107693,2.2107693, 0.08843077,-4.3331079
14.036243, 2.032225,2.93891, 9.8577392,0.75828765, 0.12890891,-12.761981
21.801409, 1.8759,2.87638, 6.9669177,0.58057648, 0.16836718,-16.668351
21.801409, 1.719575,2.81385, 6.9669177,0.58057648, 0.16836718,-16.668351
18.434949, 1.62578,2.782585, 6.9208028,0.98868612, 0.098868622,-9.7879925
333.43495, 1.56325,2.81385, 2.7964266,1.3982133, 0.069910666,-6.9211559
315, 1.50072,2.87638, 2.2107693,2.2107693, 0.08843077,-4.3331079
288.43495, 1.469455,2.970175, 6.9208028,0.98868612, 0.098868622,-9.7879925
270, 1.469455,3.1265, 0,3.1265, 0.156325,-2.970175
270, 1.469455,3.220295, 0,3.1265, 0.093795,-3.032705
255.96376, 1.50072,3.345355, 3.0331505,0.75828765, 0.12890891,-12.761981
225, 1.594515,3.43915, 2.2107693,2.2107693, 0.13264617,-4.2888926
191.30993, 1.75084,3.470415, 12.876299,0.61315711, 0.15942086,-15.782664
194.03624, 1.8759,3.50168, 9.8577392,0.75828765, 0.12890891,-12.761981
180, 1.93843,3.50168, 0,3.1265, 0.06253,-3.06397
165.96376, 2.06349,3.470415, 3.0331505,0.75828765, 0.12890891,-12.761981
146.30993, 2.157285,3.407885, 6.9370806,0.86713509, 0.11272755,-11.160028
153.43495, 2.282345,3.345355, 2.7964266,1.3982133, 0.13982133,-6.8512452
90, 1.469455,3.1265, 0,3.1265, 0.06253,-3.06397
90, 1.469455,3.06397, 0,3.1265, 0.06253,-3.06397
71.565051, 1.43819,2.970175, 2.9660583,0.98868612, 0.098868622,-9.7879925
45, 1.37566,2.907645, 2.2107693,2.2107693, 0.08843077,-4.3331079
26.565051, 1.31313,2.87638, 4.1946399,1.3982133, 0.069910666,-6.9211559
0, 1.2506,2.87638, 0,3.1265, 0.06253,-3.06397
315, 1.219335,2.907645, 2.2107693,2.2107693, 0.044215401,-4.3773233
288.43495, 1.18807,3.00144, 6.9208028,0.98868612, 0.098868622,-9.7879925
255.96376, 1.219335,3.1265, 3.0331505,0.75828765, 0.12890891,-12.761981
243.43495, 1.281865,3.25156, 2.7964266,1.3982133, 0.13982133,-6.8512452
206.56505, 1.344395,3.282825, 4.1946399,1.3982133, 0.069910666,-6.9211559
180, 1.406925,3.282825, 0,3.1265, 0.06253,-3.06397
135, 1.43819,3.25156, 2.2107693,2.2107693, 0.044215401,-4.3773233
116.56505, 1.469455,3.18903, 4.1946399,1.3982133, 0.069910666,-6.9211559
101.30993, 2.970175,1.844635, 12.876299,0.61315711, 0.15942086,-15.782664
90, 2.970175,1.782105, 0,3.1265, 0.06253,-3.06397
63.434949, 2.93891,1.719575, 2.7964266,1.3982133, 0.069910666,-6.9211559
0, 2.845115,1.719575, 0,3.1265, 0.093795,-3.032705
0, 2.720055,1.719575, 0,3.1265, 0.12506,-3.00144
0, 2.657525,1.719575, 0,3.1265, 0.06253,-3.06397
315, 2.62626,1.75084, 2.2107693,2.2107693, 0.044215401,-4.3773233
296.56505, 2.56373,1.8759, 4.1946399,1.3982133, 0.13982133,-6.8512452
296.56505, 2.532465,1.93843, 4.1946399,1.3982133, 0.069910666,-6.9211559
296.56505, 2.5012,2.00096, 4.1946399,1.3982133, 0.069910666,-6.9211559
270, 2.5012,2.032225, 0,3.1265, 0.031265,-3.095235
243.43495, 2.532465,2.094755, 2.7964266,1.3982133, 0.069910666,-6.9211559
198.43495, 2.62626,2.12602, 6.9208028,0.98868612, 0.098868622,-9.7879925
180, 2.68879,2.12602, 0,3.1265, 0.06253,-3.06397
164.0546, 2.907645,2.06349, 12.883734,0.42945779, 0.22761264,-22.533651
116.56505, 2.93891,2.00096, 4.1946399,1.3982133, 0.069910666,-6.9211559
90, 2.68879,2.219815, 0,3.1265, 0.093795,-3.032705
63.434949, 2.657525,2.157285, 2.7964266,1.3982133, 0.069910666,-6.9211559
18.434949, 2.56373,2.12602, 6.9208028,0.98868612, 0.098868622,-9.7879925
0, 2.43867,2.12602, 0,3.1265, 0.12506,-3.00144
333.43495, 2.157285,2.18855, 2.7964266,1.3982133, 0.069910666,-6.9211559
333.43495, 2.032225,2.25108, 2.7964266,1.3982133, 0.13982133,-6.8512452
315, 1.969695,2.31361, 2.2107693,2.2107693, 0.08843077,-4.3331079
288.43495, 1.93843,2.407405, 6.9208028,0.98868612, 0.098868622,-9.7879925
236.30993, 2.00096,2.5012, 6.9370806,0.86713509, 0.11272755,-11.160028
225, 2.06349,2.56373, 2.2107693,2.2107693, 0.08843077,-4.3331079
213.69007, 2.157285,2.62626, 4.3356754,0.86713509, 0.11272755,-11.160028
225, 2.18855,2.657525, 2.2107693,2.2107693, 0.044215401,-4.3773233
206.56505, 2.25108,2.68879, 4.1946399,1.3982133, 0.069910666,-6.9211559
180, 2.31361,2.68879, 0,3.1265, 0.06253,-3.06397
135, 2.344875,2.657525, 2.2107693,2.2107693, 0.044215401,-4.3773233
135, 2.37614,2.62626, 2.2107693,2.2107693, 0.044215401,-4.3773233
135, 2.469935,2.532465, 2.2107693,2.2107693, 0.13264617,-4.2888926
153.43495, 2.594995,2.469935, 2.7964266,1.3982133, 0.13982133,-6.8512452
135, 2.657525,2.407405, 2.2107693,2.2107693, 0.08843077,-4.3331079
108.43495, 2.68879,2.31361, 6.9208028,0.98868612, 0.098868622,-9.7879925
111.80141, 2.532465,1.8759, 6.9669177,0.58057648, 0.16836718,-16.668351
123.69007, 2.594995,1.782105, 4.3356754,0.86713509, 0.11272755,-11.160028
104.03624, 2.62626,1.657045, 9.8577392,0.75828765, 0.12890891,-12.761981
56.309932, 2.56373,1.56325, 6.9370806,0.86713509, 0.11272755,-11.160028
45, 2.532465,1.531985, 2.2107693,2.2107693, 0.044215401,-4.3773233
18.434949, 2.43867,1.50072, 6.9208028,0.98868612, 0.098868622,-9.7879925
45, 2.37614,1.43819, 2.2107693,2.2107693, 0.08843077,-4.3331079
63.434949, 2.344875,1.37566, 2.7964266,1.3982133, 0.069910666,-6.9211559
18.434949, 2.25108,1.344395, 6.9208028,0.98868612, 0.098868622,-9.7879925
345.96376, 2.12602,1.37566, 3.0331505,0.75828765, 0.12890891,-12.761981
351.8699, 1.907165,1.406925, 3.0950771,0.44215388, 0.22107694,-21.886617
341.56505, 1.81337,1.43819, 2.9660583,0.98868612, 0.098868622,-9.7879925
315, 1.75084,1.50072, 2.2107693,2.2107693, 0.08843077,-4.3331079
288.43495, 1.719575,1.594515, 6.9208028,0.98868612, 0.098868622,-9.7879925
270, 1.719575,1.657045, 0,3.1265, 0.06253,-3.06397
248.19859, 1.782105,1.81337, 9.8698001,0.58057648, 0.16836718,-16.668351
270, 1.782105,1.844635, 0,3.1265, 0.031265,-3.095235
270, 1.782105,1.93843, 0,3.1265, 0.093795,-3.032705
251.56505, 1.81337,2.032225, 2.9660583,0.98868612, 0.098868622,-9.7879925
206.56505, 1.8759,2.06349, 4.1946399,1.3982133, 0.069910666,-6.9211559
198.43495, 1.969695,2.094755, 6.9208028,0.98868612, 0.098868622,-9.7879925
198.43495, 2.06349,2.12602, 6.9208028,0.98868612, 0.098868622,-9.7879925
191.30993, 2.219815,2.157285, 12.876299,0.61315711, 0.15942086,-15.782664
153.43495, 2.407405,2.094755, 2.7964266,1.3982133, 0.13982133,-6.8512452
135, 2.469935,2.032225, 2.2107693,2.2107693, 0.08843077,-4.3331079
71.565051, 1.969695,2.157285, 2.9660583,0.98868612, 0.098868622,-9.7879925
26.565051, 1.907165,2.12602, 4.1946399,1.3982133, 0.069910666,-6.9211559
26.565051, 1.844635,2.094755, 4.1946399,1.3982133, 0.069910666,-6.9211559
0, 1.782105,2.094755, 0,3.1265, 0.06253,-3.06397
315, 1.75084,2.12602, 2.2107693,2.2107693, 0.044215401,-4.3773233
296.56505, 1.719575,2.18855, 4.1946399,1.3982133, 0.069910666,-6.9211559
270, 1.719575,2.25108, 0,3.1265, 0.06253,-3.06397
225, 1.75084,2.282345, 2.2107693,2.2107693, 0.044215401,-4.3773233
225, 1.81337,2.344875, 2.2107693,2.2107693, 0.08843077,-4.3331079
180, 1.8759,2.344875, 0,3.1265, 0.06253,-3.06397
153.43495, 1.93843,2.31361, 2.7964266,1.3982133, 0.069910666,-6.9211559
135, 2.00096,2.25108, 2.2107693,2.2107693, 0.08843077,-4.3331079
63.434949, 1.844635,2.37614, 2.7964266,1.3982133, 0.13982133,-6.8512452
36.869898, 1.719575,2.282345, 4.3771,0.6253, 0.156325,-15.476175
0, 1.594515,2.282345, 0,3.1265, 0.12506,-3.00144
326.30993, 1.50072,2.344875, 6.9370806,0.86713509, 0.11272755,-11.160028
270, 1.50072,2.469935, 0,3.1265, 0.12506,-3.00144
251.56505, 1.531985,2.56373, 2.9660583,0.98868612, 0.098868622,-9.7879925
251.56505, 1.56325,2.657525, 2.9660583,0.98868612, 0.098868622,-9.7879925
225, 1.62578,2.720055, 2.2107693,2.2107693, 0.08843077,-4.3331079
213.69007, 1.719575,2.782585, 4.3356754,0.86713509, 0.11272755,-11.160028
206.56505, 1.844635,2.845115, 4.1946399,1.3982133, 0.13982133,-6.8512452
194.03624, 1.969695,2.87638, 9.8577392,0.75828765, 0.12890891,-12.761981
191.30993, 2.12602,2.907645, 12.876299,0.61315711, 0.15942086,-15.782664
180, 2.18855,2.907645, 0,3.1265, 0.06253,-3.06397
135, 2.25108,2.845115, 2.2107693,2.2107693, 0.08843077,-4.3331079
90, 2.25108,2.782585, 0,3.1265, 0.06253,-3.06397
56.309932, 2.18855,2.68879, 6.9370806,0.86713509, 0.11272755,-11.160028
45, 2.12602,2.62626, 2.2107693,2.2107693, 0.08843077,-4.3331079
33.690068, 2.032225,2.56373, 4.3356754,0.86713509, 0.11272755,-11.160028
26.565051, 1.907165,2.5012, 4.1946399,1.3982133, 0.13982133,-6.8512452
90, 1.719575,2.00096, 0,3.1265, 0.156325,-2.970175
104.03624, 1.75084,1.8759, 9.8577392,0.75828765, 0.12890891,-12.761981
90, 1.75084,1.782105, 0,3.1265, 0.093795,-3.032705
75.963757, 1.719575,1.657045, 3.0331505,0.75828765, 0.12890891,-12.761981
90, 1.719575,1.594515, 0,3.1265, 0.06253,-3.06397
26.565051, 1.657045,1.56325, 4.1946399,1.3982133, 0.069910666,-6.9211559
0, 1.531985,1.56325, 0,3.1265, 0.12506,-3.00144
14.036243, 1.406925,1.531985, 9.8577392,0.75828765, 0.12890891,-12.761981
26.565051, 1.344395,1.50072, 4.1946399,1.3982133, 0.069910666,-6.9211559
26.565051, 1.281865,1.469455, 4.1946399,1.3982133, 0.069910666,-6.9211559
26.565051, 1.219335,1.43819, 4.1946399,1.3982133, 0.069910666,-6.9211559
0, 1.18807,1.43819, 0,3.1265, 0.031265,-3.095235
315, 1.12554,1.50072, 2.2107693,2.2107693, 0.08843077,-4.3331079
303.69007, 1.06301,1.594515, 4.3356754,0.86713509, 0.11272755,-11.160028
291.80141, 1.00048,1.75084, 6.9669177,0.58057648, 0.16836718,-16.668351
270, 1.00048,1.81337, 0,3.1265, 0.06253,-3.06397
255.96376, 1.031745,1.93843, 3.0331505,0.75828765, 0.12890891,-12.761981
243.43495, 1.094275,2.06349, 2.7964266,1.3982133, 0.13982133,-6.8512452
225, 1.18807,2.157285, 2.2107693,2.2107693, 0.13264617,-4.2888926
225, 1.281865,2.25108, 2.2107693,2.2107693, 0.13264617,-4.2888926
194.03624, 1.406925,2.282345, 9.8577392,0.75828765, 0.12890891,-12.761981
135, 1.719575,2.157285, 2.2107693,2.2107693, 0.08843077,-4.3331079
90, 1.719575,2.18855, 0,3.1265, 0.06253,-3.06397
116.56505, 1.75084,2.12602, 4.1946399,1.3982133, 0.069910666,-6.9211559
135, 1.782105,2.094755, 2.2107693,2.2107693, 0.044215401,-4.3773233
180, 1.844635,2.094755, 0,3.1265, 0.06253,-3.06397
206.56505, 1.907165,2.12602, 4.1946399,1.3982133, 0.069910666,-6.9211559
206.56505, 1.969695,2.157285, 4.1946399,1.3982133, 0.069910666,-6.9211559
251.56505, 2.00096,2.25108, 2.9660583,0.98868612, 0.098868622,-9.7879925
315, 1.93843,2.31361, 2.2107693,2.2107693, 0.08843077,-4.3331079
333.43495, 1.8759,2.344875, 2.7964266,1.3982133, 0.069910666,-6.9211559
0, 1.81337,2.344875, 0,3.1265, 0.06253,-3.06397
45, 1.75084,2.282345, 2.2107693,2.2107693, 0.08843077,-4.3331079
45, 1.719575,2.25108, 2.2107693,2.2107693, 0.044215401,-4.3773233
75.963757, 1.06301,2.032225, 3.0331505,0.75828765, 0.12890891,-12.761981
63.434949, 0.969215,1.844635, 2.7964266,1.3982133, 0.209732,-6.7813345
63.434949, 0.906685,1.719575, 2.7964266,1.3982133, 0.13982133,-6.8512452
26.565051, 0.844155,1.68831, 4.1946399,1.3982133, 0.069910666,-6.9211559
45, 0.81289,1.657045, 2.2107693,2.2107693, 0.044215401,-4.3773233
18.434949, 0.719095,1.62578, 6.9208028,0.98868612, 0.098868622,-9.7879925
0, 0.656565,1.62578, 0,3.1265, 0.06253,-3.06397
333.43495, 0.594035,1.657045, 2.7964266,1.3982133, 0.069910666,-6.9211559
288.43495, 0.56277,1.75084, 6.9208028,0.98868612, 0.098868622,-9.7879925
270, 0.56277,1.907165, 0,3.1265, 0.156325,-2.970175
270, 0.56277,1.969695, 0,3.1265, 0.06253,-3.06397
258.69007, 0.594035,2.12602, 3.0657855,0.61315711, 0.15942086,-15.782664
258.69007, 0.6253,2.282345, 3.0657855,0.61315711, 0.15942086,-15.782664
225, 0.719095,2.37614, 2.2107693,2.2107693, 0.13264617,-4.2888926
198.43495, 0.81289,2.407405, 6.9208028,0.98868612, 0.098868622,-9.7879925
180, 0.87542,2.407405, 0,3.1265, 0.06253,-3.06397
165.96376, 1.00048,2.37614, 3.0331505,0.75828765, 0.12890891,-12.761981
135, 1.094275,2.282345, 2.2107693,2.2107693, 0.13264617,-4.2888926
90, 1.094275,2.157285, 0,3.1265, 0.12506,-3.00144
78.690068, 0.56277,1.969695, 3.0657855,0.61315711, 0.15942086,-15.782664
90, 0.56277,1.907165, 0,3.1265, 0.06253,-3.06397
90, 0.56277,1.81337, 0,3.1265, 0.093795,-3.032705
63.434949, 0.531505,1.75084, 2.7964266,1.3982133, 0.069910666,-6.9211559
26.565051, 0.468975,1.719575, 4.1946399,1.3982133, 0.069910666,-6.9211559
0, 0.37518,1.719575, 0,3.1265, 0.093795,-3.032705
0, 0.31265,1.719575, 0,3.1265, 0.06253,-3.06397
0, 0.25012,1.719575, 0,3.1265, 0.06253,-3.06397
26.565051, 0.18759,1.68831, 4.1946399,1.3982133, 0.069910666,-6.9211559
45, 0.156325,1.657045, 2.2107693,2.2107693, 0.044215401,-4.3773233
0, 0.06253,1.657045, 0,3.1265, 0.093795,-3.032705
333.43495, 0,1.68831, 2.7964266,1.3982133, 0.069910666,-6.9211559
296.56505, -0.031265,1.75084, 4.1946399,1.3982133, 0.069910666,-6.9211559
296.56505, -0.093795,1.8759, 4.1946399,1.3982133, 0.13982133,-6.8512452
306.8699, -0.18759,2.00096, 4.3771,0.6253, 0.156325,-15.476175
288.43495, -0.218855,2.094755, 6.9208028,0.98868612, 0.098868622,-9.7879925
270, -0.218855,2.157285, 0,3.1265, 0.06253,-3.06397
213.69007, -0.12506,2.219815, 4.3356754,0.86713509, 0.11272755,-11.160028
194.03624, 0,2.25108, 9.8577392,0.75828765, 0.12890891,-12.761981
191.30993, 0.156325,2.282345, 12.876299,0.61315711, 0.15942086,-15.782664
180, 0.281385,2.282345, 0,3.1265, 0.12506,-3.00144
180, 0.31265,2.282345, 0,3.1265, 0.031265,-3.095235
168.69007, 0.468975,2.25108, 3.0657855,0.61315711, 0.15942086,-15.782664
146.30993, 0.56277,2.18855, 6.9370806,0.86713509, 0.11272755,-11.160028
116.56505, 0.594035,2.12602, 4.1946399,1.3982133, 0.069910666,-6.9211559
90, 0.75036,2.43867, 0,3.1265, 0.093795,-3.032705
26.565051, 0.68783,2.407405, 4.1946399,1.3982133, 0.069910666,-6.9211559
45, 0.594035,2.31361, 2.2107693,2.2107693, 0.13264617,-4.2888926
0, 0.56277,2.31361, 0,3.1265, 0.031265,-3.095235
18.434949, 0.468975,2.282345, 6.9208028,0.98868612, 0.098868622,-9.7879925
0, 0.406445,2.282345, 0,3.1265, 0.06253,-3.06397
0, 0.281385,2.282345, 0,3.1265, 0.12506,-3.00144
341.56505, 0.18759,2.31361, 2.9660583,0.98868612, 0.098868622,-9.7879925
315, 0.12506,2.37614, 2.2107693,2.2107693, 0.08843077,-4.3331079
296.56505, 0.06253,2.5012, 4.1946399,1.3982133, 0.13982133,-6.8512452
296.56505, 0.031265,2.56373, 4.1946399,1.3982133, 0.069910666,-6.9211559
270, 0.031265,2.657525, 0,3.1265, 0.093795,-3.032705
270, 0.031265,2.782585, 0,3.1265, 0.12506,-3.00144
225, 0.093795,2.845115, 2.2107693,2.2107693, 0.08843077,-4.3331079
206.56505, 0.156325,2.87638, 4.1946399,1.3982133, 0.069910666,-6.9211559
165.96376, 0.281385,2.845115, 3.0331505,0.75828765, 0.12890891,-12.761981
158.19859, 0.43771,2.782585, 9.8698001,0.58057648, 0.16836718,-16.668351
161.56505, 0.531505,2.75132, 2.9660583,0.98868612, 0.098868622,-9.7879925
141.34019, 0.68783,2.62626, 15.624873,0.48827726, 0.20019367,-19.819174
123.69007, 0.75036,2.532465, 4.3356754,0.86713509, 0.11272755,-11.160028
63.434949, 1.219335,2.594995, 2.7964266,1.3982133, 0.069910666,-6.9211559
45, 1.12554,2.5012, 2.2107693,2.2107693, 0.13264617,-4.2888926
14.036243, 1.00048,2.469935, 9.8577392,0.75828765, 0.12890891,-12.761981
348.69007, 0.844155,2.5012, 3.0657855,0.61315711, 0.15942086,-15.782664
326.30993, 0.75036,2.56373, 6.9370806,0.86713509, 0.11272755,-11.160028
315, 0.6253,2.68879, 2.2107693,2.2107693, 0.17686154,-4.2446772
326.30993, 0.531505,2.75132, 6.9370806,0.86713509, 0.11272755,-11.160028
315, 0.50024,2.782585, 2.2107693,2.2107693, 0.044215401,-4.3773233
270, 0.50024,2.845115, 0,3.1265, 0.06253,-3.06397
198.43495, 0.594035,2.87638, 6.9208028,0.98868612, 0.098868622,-9.7879925
180, 0.75036,2.87638, 0,3.1265, 0.156325,-2.970175
191.30993, 0.906685,2.907645, 12.876299,0.61315711, 0.15942086,-15.782664
180, 1.06301,2.907645, 0,3.1265, 0.156325,-2.970175
165.96376, 1.18807,2.87638, 3.0331505,0.75828765, 0.12890891,-12.761981
135, 1.219335,2.845115, 2.2107693,2.2107693, 0.044215401,-4.3773233
108.43495, 1.2506,2.75132, 6.9208028,0.98868612, 0.098868622,-9.7879925
90, 1.2506,2.657525, 0,3.1265, 0.093795,-3.032705
75.963757, 1.50072,2.56373, 3.0331505,0.75828765, 0.12890891,-12.761981
80.537678, 1.469455,2.37614, 3.0839606,0.51399344, 0.19017759,-18.827579
45, 1.406925,2.31361, 2.2107693,2.2107693, 0.08843077,-4.3331079
26.565051, 1.281865,2.25108, 4.1946399,1.3982133, 0.13982133,-6.8512452
26.565051, 1.219335,2.219815, 4.1946399,1.3982133, 0.069910666,-6.9211559
0, 1.156805,2.219815, 0,3.1265, 0.06253,-3.06397
315, 1.094275,2.282345, 2.2107693,2.2107693, 0.08843077,-4.3331079
288.43495, 1.06301,2.37614, 6.9208028,0.98868612, 0.098868622,-9.7879925
270, 1.06301,2.43867, 0,3.1265, 0.06253,-3.06397
225, 1.12554,2.5012, 2.2107693,2.2107693, 0.08843077,-4.3331079
216.8699, 1.2506,2.594995, 4.3771,0.6253, 0.156325,-15.476175
251.56505, 1.281865,2.68879, 2.9660583,0.98868612, 0.098868622,-9.7879925
270, 1.281865,2.81385, 0,3.1265, 0.12506,-3.00144
225, 1.31313,2.845115, 2.2107693,2.2107693, 0.044215401,-4.3773233
206.56505, 1.37566,2.87638, 4.1946399,1.3982133, 0.069910666,-6.9211559
180, 1.43819,2.87638, 0,3.1265, 0.06253,-3.06397
153.43495, 1.50072,2.845115, 2.7964266,1.3982133, 0.069910666,-6.9211559
116.56505, 1.531985,2.782585, 4.1946399,1.3982133, 0.069910666,-6.9211559
90, 1.531985,2.68879, 0,3.1265, 0.093795,-3.032705
225, 2.970175,2.219815, 2.2107693,2.2107693, 0.08843077,-4.3331079
206.56505, 3.095235,2.282345, 4.1946399,1.3982133, 0.13982133,-6.8512452
198.43495, 3.18903,2.31361, 6.9208028,0.98868612, 0.098868622,-9.7879925
243.43495, 3.220295,2.37614, 2.7964266,1.3982133, 0.069910666,-6.9211559
296.56505, 3.18903,2.43867, 4.1946399,1.3982133, 0.069910666,-6.9211559
315, 3.1265,2.5012, 2.2107693,2.2107693, 0.08843077,-4.3331079
0, 3.032705,2.5012, 0,3.1265, 0.093795,-3.032705
14.036243, 2.907645,2.469935, 9.8577392,0.75828765, 0.12890891,-12.761981
0, 2.81385,2.469935, 0,3.1265, 0.093795,-3.032705
33.690068, 2.720055,2.407405, 4.3356754,0.86713509, 0.11272755,-11.160028
71.565051, 2.68879,2.31361, 2.9660583,0.98868612, 0.098868622,-9.7879925
90, 2.68879,2.18855, 0,3.1265, 0.12506,-3.00144
116.56505, 2.720055,2.12602, 4.1946399,1.3982133, 0.069910666,-6.9211559
180, 2.81385,2.12602, 0,3.1265, 0.093795,-3.032705
198.43495, 2.907645,2.157285, 6.9208028,0.98868612, 0.098868622,-9.7879925
56.309932, 3.220295,0.343915, 6.9370806,0.86713509, 0.11272755,-11.160028
56.309932, 3.157765,0.25012, 6.9370806,0.86713509, 0.11272755,-11.160028
36.869898, 3.032705,0.156325, 4.3771,0.6253, 0.156325,-15.476175
33.690068, 2.93891,0.093795, 4.3356754,0.86713509, 0.11272755,-11.160028
0, 2.81385,0.093795, 0,3.1265, 0.12506,-3.00144
326.30993, 2.720055,0.156325, 6.9370806,0.86713509, 0.11272755,-11.160028
315, 2.62626,0.25012, 2.2107693,2.2107693, 0.044215401,-4.3773233
315, 2.56373,0.31265, 2.2107693,2.2107693, 0.22107694,-4.2004618
288.43495, 2.532465,0.406445, 6.9208028,0.98868612, 0.098868622,-9.7879925
270, 2.532465,0.594035, 0,3.1265, 0.093795,-3.032705
288.43495, 2.5012,0.68783, 6.9208028,0.98868612, 0.098868622,-9.7879925
225, 2.56373,0.781625, 2.2107693,2.2107693, 0.044215401,-4.3773233
180, 2.62626,0.781625, 0,3.1265, 0.06253,-3.06397
180, 2.782585,0.781625, 0,3.1265, 0.156325,-2.970175
153.43495, 3.06397,0.68783, 2.7964266,1.3982133, 0.13982133,-6.8512452
161.56505, 3.25156,0.531505, 2.9660583,0.98868612, 0.098868622,-9.7879925
99.462322, 3.345355,1.00048, 15.933796,0.51399344, 0.19017759,-18.827579
108.43495, 3.37662,0.906685, 6.9208028,0.98868612, 0.098868622,-9.7879925
116.56505, 3.407885,0.844155, 4.1946399,1.3982133, 0.069910666,-6.9211559
116.56505, 3.43915,0.781625, 4.1946399,1.3982133, 0.069910666,-6.9211559
90, 3.43915,0.719095, 0,3.1265, 0.06253,-3.06397
63.434949, 3.407885,0.656565, 2.7964266,1.3982133, 0.069910666,-6.9211559
45, 3.37662,0.6253, 2.2107693,2.2107693, 0.044215401,-4.3773233
45, 3.282825,0.531505, 2.2107693,2.2107693, 0.13264617,-4.2888926
0, 3.25156,0.531505, 0,3.1265, 0.031265,-3.095235
341.56505, 3.157765,0.56277, 2.9660583,0.98868612, 0.098868622,-9.7879925
296.56505, 3.1265,0.6253, 4.1946399,1.3982133, 0.069910666,-6.9211559
315, 3.06397,0.68783, 2.2107693,2.2107693, 0.08843077,-4.3331079
333.43495, 2.93891,0.75036, 2.7964266,1.3982133, 0.13982133,-6.8512452
341.56505, 2.845115,0.781625, 2.9660583,0.98868612, 0.098868622,-9.7879925
198.43495, 3.18903,1.281865, 6.9208028,0.98868612, 0.098868622,-9.7879925
180, 3.220295,1.281865, 0,3.1265, 0.031265,-3.095235
153.43495, 3.282825,1.2506, 2.7964266,1.3982133, 0.069910666,-6.9211559
116.56505, 3.31409,1.18807, 4.1946399,1.3982133, 0.069910666,-6.9211559
71.565051, 2.970175,1.37566, 2.9660583,0.98868612, 0.098868622,-9.7879925
45, 2.845115,1.219335, 2.2107693,2.2107693, 0.044215401,-4.3773233
45, 2.81385,1.18807, 2.2107693,2.2107693, 0.044215401,-4.3773233
0, 2.56373,1.156805, 0,3.1265, 0.093795,-3.032705
326.30993, 2.469935,1.219335, 6.9370806,0.86713509, 0.11272755,-11.160028
306.8699, 2.37614,1.344395, 4.3771,0.6253, 0.156325,-15.476175
270, 2.37614,1.406925, 0,3.1265, 0.06253,-3.06397
225, 2.43867,1.469455, 2.2107693,2.2107693, 0.08843077,-4.3331079
198.43495, 2.532465,1.50072, 6.9208028,0.98868612, 0.098868622,-9.7879925
90, 3.032705,1.56325, 0,3.1265, 0.093795,-3.032705
71.565051, 3.00144,1.469455, 2.9660583,0.98868612, 0.098868622,-9.7879925
90, 1.657045,1.281865, 0,3.1265, 0.06253,-3.06397
90, 1.657045,1.219335, 0,3.1265, 0.06253,-3.06397
63.434949, 1.62578,1.156805, 2.7964266,1.3982133, 0.069910666,-6.9211559
45, 1.594515,1.12554, 2.2107693,2.2107693, 0.044215401,-4.3773233
0, 1.531985,1.12554, 0,3.1265, 0.06253,-3.06397
18.434949, 1.43819,1.094275, 6.9208028,0.98868612, 0.098868622,-9.7879925
0, 1.37566,1.094275, 0,3.1265, 0.06253,-3.06397
341.56505, 1.281865,1.12554, 2.9660583,0.98868612, 0.098868622,-9.7879925
303.69007, 1.219335,1.219335, 4.3356754,0.86713509, 0.11272755,-11.160028
270, 1.219335,1.31313, 0,3.1265, 0.093795,-3.032705
251.56505, 1.2506,1.406925, 2.9660583,0.98868612, 0.098868622,-9.7879925
225, 1.31313,1.469455, 2.2107693,2.2107693, 0.08843077,-4.3331079
198.43495, 1.406925,1.50072, 6.9208028,0.98868612, 0.098868622,-9.7879925
198.43495, 1.50072,1.531985, 6.9208028,0.98868612, 0.098868622,-9.7879925
180, 1.594515,1.531985, 0,3.1265, 0.093795,-3.032705
153.43495, 1.657045,1.50072, 2.7964266,1.3982133, 0.069910666,-6.9211559
135, 1.68831,1.469455, 2.2107693,2.2107693, 0.044215401,-4.3773233
90, 1.68831,1.43819, 0,3.1265, 0.031265,-3.095235
71.565051, 1.657045,1.344395, 2.9660583,0.98868612, 0.098868622,-9.7879925
90, 1.18807,1.281865, 0,3.1265, 0.093795,-3.032705
56.309932, 1.12554,1.18807, 6.9370806,0.86713509, 0.11272755,-11.160028
33.690068, 1.031745,1.12554, 4.3356754,0.86713509, 0.11272755,-11.160028
26.565051, 0.906685,1.06301, 4.1946399,1.3982133, 0.13982133,-6.8512452
45, 0.81289,0.969215, 2.2107693,2.2107693, 0.13264617,-4.2888926
18.434949, 0.719095,0.93795, 6.9208028,0.98868612, 0.098868622,-9.7879925
0, 0.68783,0.93795, 0,3.1265, 0.031265,-3.095235
255.96376, 0.719095,1.06301, 3.0331505,0.75828765, 0.12890891,-12.761981
240.25512, 0.844155,1.281865, 6.9803028,0.38779458, 0.2520665,-24.954582
236.30993, 0.906685,1.37566, 6.9370806,0.86713509, 0.11272755,-11.160028
198.43495, 1.00048,1.406925, 6.9208028,0.98868612, 0.098868622,-9.7879925
180, 1.156805,1.406925, 0,3.1265, 0.156325,-2.970175
135, 1.18807,1.37566, 2.2107693,2.2107693, 0.044215401,-4.3773233
108.43495, 1.094275,1.50072, 6.9208028,0.98868612, 0.098868622,-9.7879925
90, 1.094275,1.469455, 0,3.1265, 0.031265,-3.095235
45, 1.031745,1.406925, 2.2107693,2.2107693, 0.08843077,-4.3331079
0, 0.969215,1.406925, 0,3.1265, 0.06253,-3.06397
0, 0.906685,1.406925, 0,3.1265, 0.06253,-3.06397
315, 0.844155,1.469455, 2.2107693,2.2107693, 0.08843077,-4.3331079
296.56505, 0.81289,1.531985, 4.1946399,1.3982133, 0.069910666,-6.9211559
315, 0.781625,1.56325, 2.2107693,2.2107693, 0.044215401,-4.3773233
270, 0.781625,1.594515, 0,3.1265, 0.031265,-3.095235
270, 0.781625,1.62578, 0,3.1265, 0.031265,-3.095235
225, 0.81289,1.657045, 2.2107693,2.2107693, 0.044215401,-4.3773233
213.69007, 0.906685,1.719575, 4.3356754,0.86713509, 0.11272755,-11.160028
180, 0.93795,1.719575, 0,3.1265, 0.031265,-3.095235
153.43495, 1.00048,1.68831, 2.7964266,1.3982133, 0.069910666,-6.9211559
123.69007, 1.06301,1.594515, 4.3356754,0.86713509, 0.11272755,-11.160028
45, 0.468975,0.75036, 2.2107693,2.2107693, 0.17686154,-4.2446772
0, 0.406445,0.75036, 0,3.1265, 0.06253,-3.06397
333.43495, 0.343915,0.781625, 2.7964266,1.3982133, 0.069910666,-6.9211559
315, 0.281385,0.844155, 2.2107693,2.2107693, 0.08843077,-4.3331079
296.56505, 0.25012,0.906685, 4.1946399,1.3982133, 0.069910666,-6.9211559
288.43495, 0.218855,1.00048, 6.9208028,0.98868612, 0.098868622,-9.7879925
278.1301, 0.18759,1.219335, 19.012616,0.44215388, 0.22107694,-21.886617
262.87498, 0.218855,1.469455, 3.1023568,0.38779458, 0.2520665,-24.954582
270, 0.218855,1.56325, 0,3.1265, 0.093795,-3.032705
270, 0.218855,1.657045, 0,3.1265, 0.093795,-3.032705
243.43495, 0.25012,1.719575, 2.7964266,1.3982133, 0.069910666,-6.9211559
180, 0.31265,1.719575, 0,3.1265, 0.06253,-3.06397
153.43495, 0.37518,1.68831, 2.7964266,1.3982133, 0.069910666,-6.9211559
161.56505, 0.468975,1.657045, 2.9660583,0.98868612, 0.098868622,-9.7879925
180, 0.531505,1.657045, 0,3.1265, 0.06253,-3.06397
161.56505, 0.6253,1.62578, 2.9660583,0.98868612, 0.098868622,-9.7879925
161.56505, 0.719095,1.594515, 2.9660583,0.98868612, 0.098868622,-9.7879925
71.565051, 0.18759,1.43819, 2.9660583,0.98868612, 0.098868622,-9.7879925
63.434949, 0.156325,1.37566, 2.7964266,1.3982133, 0.069910666,-6.9211559
45, 0.093795,1.31313, 2.2107693,2.2107693, 0.08843077,-4.3331079
26.565051, 0.031265,1.281865, 4.1946399,1.3982133, 0.069910666,-6.9211559
0, 0,1.281865, 0,3.1265, 0.031265,-3.095235
0, -0.031265,1.281865, 0,3.1265, 0.031265,-3.095235
315, -0.06253,1.31313, 2.2107693,2.2107693, 0.044215401,-4.3773233
296.56505, -0.093795,1.37566, 4.1946399,1.3982133, 0.069910666,-6.9211559
270, -0.093795,1.43819, 0,3.1265, 0.06253,-3.06397
270, -0.093795,1.531985, 0,3.1265, 0.093795,-3.032705
225, -0.031265,1.594515, 2.2107693,2.2107693, 0.08843077,-4.3331079
206.56505, 0.031265,1.62578, 4.1946399,1.3982133, 0.069910666,-6.9211559
198.43495, 0.12506,1.657045, 6.9208028,0.98868612, 0.098868622,-9.7879925
180, 0.156325,1.657045, 0,3.1265, 0.031265,-3.095235
135, 0.18759,1.62578, 2.2107693,2.2107693, 0.044215401,-4.3773233
116.56505, 0.218855,1.56325, 4.1946399,1.3982133, 0.069910666,-6.9211559
90, 0.218855,1.531985, 0,3.1265, 0.031265,-3.095235
135, 1.06301,0.719095, 2.2107693,2.2107693, 0.08843077,-4.3331079
153.43495, 1.18807,0.656565, 2.7964266,1.3982133, 0.13982133,-6.8512452
135, 1.2506,0.594035, 2.2107693,2.2107693, 0.08843077,-4.3331079
90, 1.31313,0.43771, 0,3.1265, 0.06253,-3.06397
315, 1.00048,0.468975, 2.2107693,2.2107693, 0.13264617,-4.2888926
333.43495, 0.87542,0.531505, 2.7964266,1.3982133, 0.13982133,-6.8512452
315, 0.781625,0.6253, 2.2107693,2.2107693, 0.13264617,-4.2888926
338.19859, 0.6253,0.68783, 9.8698001,0.58057648, 0.16836718,-16.668351
333.43495, 0.56277,0.719095, 2.7964266,1.3982133, 0.069910666,-6.9211559
315, 0.531505,0.75036, 2.2107693,2.2107693, 0.044215401,-4.3773233
243.43495, 0.56277,0.81289, 2.7964266,1.3982133, 0.069910666,-6.9211559
225, 0.594035,0.844155, 2.2107693,2.2107693, 0.044215401,-4.3773233
206.56505, 0.656565,0.87542, 4.1946399,1.3982133, 0.069910666,-6.9211559
206.56505, 0.719095,0.906685, 4.1946399,1.3982133, 0.069910666,-6.9211559
180, 0.781625,0.906685, 0,3.1265, 0.06253,-3.06397
146.30993, 0.87542,0.844155, 6.9370806,0.86713509, 0.11272755,-11.160028
153.43495, 1.00048,0.781625, 2.7964266,1.3982133, 0.13982133,-6.8512452
63.434949, 1.219335,0, 2.7964266,1.3982133, 0.13982133,-6.8512452
63.434949, 1.18807,-0.06253, 2.7964266,1.3982133, 0.069910666,-6.9211559
33.690068, 1.094275,-0.12506, 4.3356754,0.86713509, 0.11272755,-11.160028
26.565051, 0.969215,-0.18759, 4.1946399,1.3982133, 0.13982133,-6.8512452
8.1301023, 0.75036,-0.218855, 19.012616,0.44215388, 0.22107694,-21.886617
0, 0.531505,-0.218855, 0,3.1265, 0.218855,-2.907645
0, 0.343915,-0.218855, 0,3.1265, 0.18759,-2.93891
350.53768, 0.156325,-0.18759, 3.0839606,0.51399344, 0.19017759,-18.827579
0, 0.06253,-0.18759, 0,3.1265, 0.093795,-3.032705
315, 0.031265,-0.156325, 2.2107693,2.2107693, 0.044215401,-4.3773233
284.03624, 0,-0.031265, 9.8577392,0.75828765, 0.12890891,-12.761981
270, 0,0, 0,3.1265, 0.031265,-3.095235
270, 0,0.12506, 0,3.1265, 0.12506,-3.00144
251.56505, 0.031265,0.218855, 2.9660583,0.98868612, 0.098868622,-9.7879925
233.1301, 0.12506,0.343915, 11.2554,0.6253, 0.156325,-15.476175
236.30993, 0.18759,0.43771, 6.9370806,0.86713509, 0.11272755,-11.160028
270, 0.18759,0.50024, 0,3.1265, 0.06253,-3.06397
236.30993, 0.25012,0.594035, 6.9370806,0.86713509, 0.11272755,-11.160028
236.30993, 0.31265,0.68783, 6.9370806,0.86713509, 0.11272755,-11.160028
90, 1.43819,0.87542, 0,3.1265, 0.06253,-3.06397
90, 1.43819,0.81289, 0,3.1265, 0.06253,-3.06397
45, 1.406925,0.781625, 2.2107693,2.2107693, 0.044215401,-4.3773233
33.690068, 1.31313,0.719095, 4.3356754,0.86713509, 0.11272755,-11.160028
333.43495, 1.031745,0.781625, 2.7964266,1.3982133, 0.069910666,-6.9211559
333.43495, 0.969215,0.81289, 2.7964266,1.3982133, 0.069910666,-6.9211559
333.43495, 0.906685,0.844155, 2.7964266,1.3982133, 0.069910666,-6.9211559
326.30993, 0.81289,0.906685, 6.9370806,0.86713509, 0.11272755,-11.160028
270, 0.81289,0.93795, 0,3.1265, 0.031265,-3.095235
270, 0.81289,0.969215, 0,3.1265, 0.031265,-3.095235
225, 0.844155,1.00048, 2.2107693,2.2107693, 0.044215401,-4.3773233
213.69007, 0.93795,1.06301, 4.3356754,0.86713509, 0.11272755,-11.160028
201.80141, 1.094275,1.12554, 6.9669177,0.58057648, 0.16836718,-16.668351
180, 1.219335,1.12554, 0,3.1265, 0.12506,-3.00144
161.56505, 1.31313,1.094275, 2.9660583,0.98868612, 0.098868622,-9.7879925
108.43495, 1.43819,0.93795, 6.9208028,0.98868612, 0.098868622,-9.7879925
225, 1.62578,0.343915, 2.2107693,2.2107693, 0.08843077,-4.3331079
206.56505, 1.68831,0.37518, 4.1946399,1.3982133, 0.069910666,-6.9211559
236.30993, 1.75084,0.468975, 6.9370806,0.86713509, 0.11272755,-11.160028
243.43495, 1.782105,0.531505, 2.7964266,1.3982133, 0.069910666,-6.9211559
251.56505, 1.81337,0.6253, 2.9660583,0.98868612, 0.098868622,-9.7879925
251.56505, 1.844635,0.719095, 2.9660583,0.98868612, 0.098868622,-9.7879925
270, 1.844635,0.844155, 0,3.1265, 0.12506,-3.00144
270, 1.844635,0.93795, 0,3.1265, 0.093795,-3.032705
288.43495, 1.81337,1.031745, 6.9208028,0.98868612, 0.098868622,-9.7879925
315, 1.75084,1.094275, 2.2107693,2.2107693, 0.08843077,-4.3331079
333.43495, 1.68831,1.12554, 2.7964266,1.3982133, 0.069910666,-6.9211559
0, 1.594515,1.12554, 0,3.1265, 0.093795,-3.032705
45, 2.532465,0.93795, 2.2107693,2.2107693, 0.13264617,-4.2888926
18.434949, 2.43867,0.906685, 6.9208028,0.98868612, 0.098868622,-9.7879925
0, 2.282345,0.906685, 0,3.1265, 0.156325,-2.970175
0, 2.18855,0.906685, 0,3.1265, 0.093795,-3.032705
333.43495, 2.06349,0.969215, 2.7964266,1.3982133, 0.13982133,-6.8512452
348.69007, 1.907165,1.00048, 3.0657855,0.61315711, 0.15942086,-15.782664
326.30993, 1.81337,1.06301, 6.9370806,0.86713509, 0.11272755,-11.160028
315, 1.719575,1.156805, 2.2107693,2.2107693, 0.13264617,-4.2888926
303.69007, 1.657045,1.2506, 4.3356754,0.86713509, 0.11272755,-11.160028
270, 1.657045,1.31313, 0,3.1265, 0.06253,-3.06397
251.56505, 1.68831,1.406925, 2.9660583,0.98868612, 0.098868622,-9.7879925
206.56505, 1.75084,1.43819, 4.1946399,1.3982133, 0.069910666,-6.9211559
296.56505, 2.469935,0.844155, 4.1946399,1.3982133, 0.069910666,-6.9211559
315, 2.43867,0.87542, 2.2107693,2.2107693, 0.044215401,-4.3773233
0, 2.282345,0.87542, 0,3.1265, 0.156325,-2.970175
0, 2.18855,0.87542, 0,3.1265, 0.093795,-3.032705
333.43495, 2.06349,0.93795, 2.7964266,1.3982133, 0.13982133,-6.8512452
333.43495, 2.00096,0.969215, 2.7964266,1.3982133, 0.069910666,-6.9211559
0, 1.93843,0.969215, 0,3.1265, 0.06253,-3.06397
45, 1.907165,0.93795, 2.2107693,2.2107693, 0.044215401,-4.3773233
63.434949, 1.8759,0.87542, 2.7964266,1.3982133, 0.069910666,-6.9211559
90, 1.8759,0.781625, 0,3.1265, 0.093795,-3.032705
75.963757, 1.844635,0.656565, 3.0331505,0.75828765, 0.12890891,-12.761981
71.565051, 1.81337,0.56277, 2.9660583,0.98868612, 0.098868622,-9.7879925
90, 1.81337,0.531505, 0,3.1265, 0.031265,-3.095235
108.43495, 1.844635,0.43771, 6.9208028,0.98868612, 0.098868622,-9.7879925
135, 1.8759,0.406445, 2.2107693,2.2107693, 0.044215401,-4.3773233
161.56505, 1.969695,0.37518, 2.9660583,0.98868612, 0.098868622,-9.7879925
165.96376, 2.094755,0.343915, 3.0331505,0.75828765, 0.12890891,-12.761981
45, 1.50072,0.218855, 2.2107693,2.2107693, 0.08843077,-4.3331079
26.565051, 1.43819,0.18759, 4.1946399,1.3982133, 0.069910666,-6.9211559
0, 1.37566,0.18759, 0,3.1265, 0.06253,-3.06397
333.43495, 1.31313,0.218855, 2.7964266,1.3982133, 0.069910666,-6.9211559
315, 1.281865,0.25012, 2.2107693,2.2107693, 0.044215401,-4.3773233
270, 1.281865,0.31265, 0,3.1265, 0.06253,-3.06397
251.56505, 1.31313,0.406445, 2.9660583,0.98868612, 0.098868622,-9.7879925
270, 1.31313,0.43771, 0,3.1265, 0.031265,-3.095235
270, 1.31313,0.50024, 0,3.1265, 0.06253,-3.06397
288.43495, 1.281865,0.594035, 6.9208028,0.98868612, 0.098868622,-9.7879925
270, 1.281865,0.656565, 0,3.1265, 0.06253,-3.06397
243.43495, 1.31313,0.719095, 2.7964266,1.3982133, 0.069910666,-6.9211559
213.69007, 1.406925,0.781625, 4.3356754,0.86713509, 0.11272755,-11.160028
225, 1.43819,0.81289, 2.2107693,2.2107693, 0.044215401,-4.3773233
270, 1.43819,0.87542, 0,3.1265, 0.06253,-3.06397
270, 1.43819,0.93795, 0,3.1265, 0.06253,-3.06397
288.43495, 1.406925,1.031745, 6.9208028,0.98868612, 0.098868622,-9.7879925
270, 1.406925,1.06301, 0,3.1265, 0.031265,-3.095235
206.56505, 1.469455,1.094275, 4.1946399,1.3982133, 0.069910666,-6.9211559
206.56505, 1.531985,1.12554, 4.1946399,1.3982133, 0.069910666,-6.9211559
180, 1.594515,1.12554, 0,3.1265, 0.06253,-3.06397
225, 2.720055,0.87542, 2.2107693,2.2107693, 0.044215401,-4.3773233
225, 2.68879,0.844155, 2.2107693,2.2107693, 0.044215401,-4.3773233
180, 2.657525,0.81289, 0,3.1265, 0.06253,-3.06397
116.56505, 2.594995,0.81289, 4.1946399,1.3982133, 0.069910666,-6.9211559
71.565051, 2.56373,0.87542, 2.9660583,0.98868612, 0.098868622,-9.7879925
56.309932, 2.594995,0.969215, 6.9370806,0.86713509, 0.11272755,-11.160028
36.869898, 2.657525,1.06301, 4.3771,0.6253, 0.156325,-15.476175
45, 2.782585,1.156805, 2.2107693,2.2107693, 0.08843077,-4.3331079
45, 2.845115,1.219335, 2.2107693,2.2107693, 0.13264617,-4.2888926
0, 2.93891,1.31313, 0,3.1265, 0.093795,-3.032705
315, 3.032705,1.31313, 2.2107693,2.2107693, 0.044215401,-4.3773233
270, 3.06397,1.281865, 0,3.1265, 0.031265,-3.095235
206.56505, 3.06397,1.2506, 4.1946399,1.3982133, 0.069910666,-6.9211559
216.8699, 3.00144,1.219335, 4.3771,0.6253, 0.156325,-15.476175
236.30993, 2.87638,1.12554, 6.9370806,0.86713509, 0.11272755,-11.160028
236.30993, 2.81385,1.031745, 6.9370806,0.86713509, 0.11272755,-11.160028
243.43495, 2.75132,0.93795, 2.7964266,1.3982133, 0.069910666,-6.9211559
345.96376, 2.12602,1.37566, 3.0331505,0.75828765, 0.12890891,-12.761981
255.96376, 2.532465,0.50024, 3.0331505,0.75828765, 0.12890891,-12.761981
236.30993, 2.5012,0.37518, 6.9370806,0.86713509, 0.11272755,-11.160028
194.03624, 2.43867,0.281385, 9.8577392,0.75828765, 0.12890891,-12.761981
180, 2.31361,0.25012, 0,3.1265, 0.031265,-3.095235
153.43495, 2.282345,0.25012, 2.7964266,1.3982133, 0.069910666,-6.9211559
161.56505, 2.219815,0.281385, 2.9660583,0.98868612, 0.098868622,-9.7879925
135, 2.12602,0.31265, 2.2107693,2.2107693, 0.044215401,-4.3773233
165.96376, 2.094755,0.343915, 3.0331505,0.75828765, 0.12890891,-12.761981
90, 2.5012,0.68783, 0,3.1265, 0.093795,-3.032705
270, 2.62626,1.06301, 0,3.1265, 0.031265,-3.095235
0, 1.81337,1.18807, 0,3.1265, 0.093795,-3.032705
0, 1.8759,1.156805, 0,3.1265, 0.06253,-3.06397
0, 1.8759,0.531505, 0,3.1265, 0.06253,-3.06397
0, 0.656565,0.156325, 0,3.1265, 0.18759,-2.93891
0, 0.56277,0.12506, 0,3.1265, 0.093795,-3.032705
0, 0.56277,-0.093795, 0,3.1265, 0.06253,-3.06397
0, 0.343915,0.468975, 0,3.1265, 0.031265,-3.095235
0, 1.06301,1.031745, 0,3.1265, 0.031265,-3.095235
0, 1.2506,0.844155, 0,3.1265, 0.031265,-3.095235
0, 2.18855,2.5012, 0,3.1265, 0.06253,-3.06397
0, 2.219815,2.469935, 0,3.1265, 0.06253,-3.06397
0, 0.56277,1.406925, 0,3.1265, 0.031265,-3.095235
0, -0.06253,2.00096, 0,3.1265, 0.156325,-2.970175
0, 0.06253,1.969695, 0,3.1265, 0.031265,-3.095235
0, 0.468975,2.12602, 0,3.1265, 0.031265,-3.095235
0, 2.93891,3.095235, 0,3.1265, 0.031265,-3.095235
0, 2.43867,3.25156, 0,3.1265, 0.031265,-3.095235
0, 2.845115,2.75132, 0,3.1265, 0.093795,-3.032705
0, 2.81385,2.720055, 0,3.1265, 0.031265,-3.095235
0, 1.469455,2.094755, 0,3.1265, 0.031265,-3.095235
0, 1.2506,1.75084, 0,3.1265, 0.093795,-3.032705
0, 1.31313,1.719575, 0,3.1265, 0.031265,-3.095235
0, 1.2506,2.37614, 0,3.1265, 0.031265,-3.095235
;; (c)1997 STONE PRODUCTS CORPORATION
*LMSTN, LIMESTONE
;%TYPE=MODEL
0, 1.531968,1.5958, 0,3.1916, 0.095748,-3.095852
0, 1.563884,1.563884, 0,3.1916, 0.191496,-3.000104
0, 2.297952,1.659632, 0,3.1916, 0.031916,-3.159684
0, 3.127768,0.382992, 0,3.1916, 0.031916,-3.159684
0, 2.71286,0.510656, 0,3.1916, 0.063832,-3.127768
0, 2.776692,0.542572, 0,3.1916, 0.063832,-3.127768
0, 0.351076,0.063832, 0,3.1916, 0.063832,-3.127768
0, 1.787296,0.861732, 0,3.1916, 0.127664,-3.063936
0, 2.71286,2.776692, 0,3.1916, 0.031916,-3.159684
180, 3.415012,2.680944, 0,3.1916, 0.095748,-3.095852
180, 3.446928,2.71286, 0,3.1916, 0.031916,-3.159684
0, 2.904356,3.03202, 0,3.1916, 0.031916,-3.159684
0, 0.829816,2.776692, 0,3.1916, 0.063832,-3.127768
0, 0.7979,2.808608, 0,3.1916, 0.063832,-3.127768
0, 1.212808,2.968188, 0,3.1916, 0.031916,-3.159684
0, -0.127664,1.531968, 0,3.1916, 0.031916,-3.159684
0, 0.351076,1.691548, 0,3.1916, 0.031916,-3.159684
0, 2.744776,1.180892, 0,3.1916, 0.063832,-3.127768
0, 2.617112,1.212808, 0,3.1916, 0.15958,-3.03202
0, 1.372388,0.542572, 0,3.1916, 0.031916,-3.159684
0, 1.5958,0.510656, 0,3.1916, 0.063832,-3.127768
0, 0.542572,0.765984, 0,3.1916, 0.127664,-3.063936
0, 0.510656,0.7979, 0,3.1916, 0.031916,-3.159684
0, 1.053228,1.244724, 0,3.1916, 0.031916,-3.159684
0, 2.361784,1.978792, 0,3.1916, 0.095748,-3.095852
0, 2.425616,2.010708, 0,3.1916, 0.15958,-3.03202
0, 1.43622,1.883044, 0,3.1916, 0.031916,-3.159684
0, 1.085144,2.07454, 0,3.1916, 0.063832,-3.127768
0, 0.989396,2.106456, 0,3.1916, 0.127664,-3.063936
315, -0.223412,2.266036, 2.256802,2.256802, 0.045136054,-4.468468
270, -0.223412,2.425616, 0,3.1916, 0.15958,-3.03202
225, -0.191496,2.457532, 2.256802,2.256802, 0.045136054,-4.468468
270, 1.819212,2.170288, 0,3.1916, 0.382992,-2.808608
63.434949, 0.542572,-0.255328, 2.8546538,1.4273269, 0.071366346,-7.0652682
0, 0,-0.255328, 0,3.1916, 0.542572,-2.649028
315, -0.031916,-0.223412, 2.256802,2.256802, 0.045136054,-4.468468
315, -0.223412,1.946876, 2.256802,2.256802, 0.045136054,-4.468468
270, -0.223412,2.042624, 0,3.1916, 0.095748,-3.095852
225, -0.191496,2.07454, 2.256802,2.256802, 0.045136054,-4.468468
45, 3.734172,2.489448, 2.256802,2.256802, 0.045136054,-4.468468
315, 3.734172,2.904356, 2.256802,2.256802, 0.045136054,-4.468468
315, 1.053228,0.989396, 2.256802,2.256802, 0.045136054,-4.468468
45, 0.223412,0.95748, 2.256802,2.256802, 0.045136054,-4.468468
135, 0.574488,0.223412, 2.256802,2.256802, 0.045136054,-4.468468
225, 0,0.255328, 2.256802,2.256802, 0.045136054,-4.468468
315, 0.223412,0.31916, 2.256802,2.256802, 0.045136054,-4.468468
45, 0.223412,0.446824, 2.256802,2.256802, 0.045136054,-4.468468
315, 0.223412,0.542572, 2.256802,2.256802, 0.045136054,-4.468468
45, 1.053228,0.510656, 2.256802,2.256802, 0.045136054,-4.468468
135, 1.085144,0.446824, 2.256802,2.256802, 0.045136054,-4.468468
45, 1.053228,0.287244, 2.256802,2.256802, 0.045136054,-4.468468
45, 0.606404,0.223412, 2.256802,2.256802, 0.045136054,-4.468468
135, 0.63832,-0.127664, 2.256802,2.256802, 0.045136054,-4.468468
225, 1.085144,-0.095748, 2.256802,2.256802, 0.045136054,-4.468468
135, 1.085144,0.223412, 2.256802,2.256802, 0.045136054,-4.468468
45, 1.11706,0.095748, 2.256802,2.256802, 0.045136054,-4.468468
135, 1.148976,-0.127664, 2.256802,2.256802, 0.045136054,-4.468468
225, 1.372388,-0.095748, 2.256802,2.256802, 0.045136054,-4.468468
315, 1.340472,0.127664, 2.256802,2.256802, 0.045136054,-4.468468
225, 3.127768,0.031916, 2.256802,2.256802, 0.045136054,-4.468468
315, 2.042624,0.031916, 2.256802,2.256802, 0.045136054,-4.468468
315, 1.404304,0.031916, 2.256802,2.256802, 0.045136054,-4.468468
225, 2.010708,0.031916, 2.256802,2.256802, 0.045136054,-4.468468
45, 3.35118,0.287244, 2.256802,2.256802, 0.045136054,-4.468468
315, 3.095852,0.255328, 2.256802,2.256802, 0.045136054,-4.468468
45, 2.042624,0.223412, 2.256802,2.256802, 0.045136054,-4.468468
315, 2.042624,0.31916, 2.256802,2.256802, 0.045136054,-4.468468
45, 1.978792,0.351076, 2.256802,2.256802, 0.045136054,-4.468468
315, 1.978792,0.31916, 2.256802,2.256802, 0.045136054,-4.468468
45, 1.404304,0.287244, 2.256802,2.256802, 0.045136054,-4.468468
135, 1.372388,0.287244, 2.256802,2.256802, 0.045136054,-4.468468
45, 1.340472,0.15958, 2.256802,2.256802, 0.045136054,-4.468468
315, 1.11706,0.191496, 2.256802,2.256802, 0.045136054,-4.468468
45, 1.11706,0.287244, 2.256802,2.256802, 0.045136054,-4.468468
315, 1.11706,0.382992, 2.256802,2.256802, 0.045136054,-4.468468
45, 1.11706,0.63832, 2.256802,2.256802, 0.045136054,-4.468468
315, 1.11706,0.734068, 2.256802,2.256802, 0.045136054,-4.468468
45, 1.11706,0.95748, 2.256802,2.256802, 0.045136054,-4.468468
45, 2.425616,0.95748, 2.256802,2.256802, 0.045136054,-4.468468
135, 2.3937,0.95748, 2.256802,2.256802, 0.045136054,-4.468468
315, 1.978792,0.670236, 2.256802,2.256802, 0.045136054,-4.468468
315, 3.35118,0.670236, 2.256802,2.256802, 0.045136054,-4.468468
45, 2.042624,0.63832, 2.256802,2.256802, 0.045136054,-4.468468
225, 2.3937,0.734068, 2.256802,2.256802, 0.045136054,-4.468468
315, 2.425616,0.734068, 2.256802,2.256802, 0.045136054,-4.468468
225, 3.383096,0.734068, 2.256802,2.256802, 0.045136054,-4.468468
315, 3.35118,0.989396, 2.256802,2.256802, 0.045136054,-4.468468
225, 3.638424,1.053228, 2.256802,2.256802, 0.045136054,-4.468468
315, 3.606508,1.404304, 2.256802,2.256802, 0.045136054,-4.468468
45, 2.904356,1.43622, 2.256802,2.256802, 0.045136054,-4.468468
315, 2.585196,1.468136, 2.256802,2.256802, 0.045136054,-4.468468
45, 2.521364,1.43622, 2.256802,2.256802, 0.045136054,-4.468468
45, 2.425616,1.372388, 2.256802,2.256802, 0.045136054,-4.468468
315, 2.425616,1.053228, 2.256802,2.256802, 0.045136054,-4.468468
225, 2.3937,1.053228, 2.256802,2.256802, 0.045136054,-4.468468
315, 2.361784,1.148976, 2.256802,2.256802, 0.045136054,-4.468468
225, 2.3937,1.212808, 2.256802,2.256802, 0.045136054,-4.468468
135, 2.3937,1.372388, 2.256802,2.256802, 0.045136054,-4.468468
315, 0.47874,1.053228, 2.256802,2.256802, 0.045136054,-4.468468
225, 1.468136,1.053228, 2.256802,2.256802, 0.045136054,-4.468468
315, 1.500052,1.053228, 2.256802,2.256802, 0.045136054,-4.468468
225, 1.531968,1.148976, 2.256802,2.256802, 0.045136054,-4.468468
315, 1.500052,1.212808, 2.256802,2.256802, 0.045136054,-4.468468
45, 1.500052,1.372388, 2.256802,2.256802, 0.045136054,-4.468468
315, 1.43622,1.404304, 2.256802,2.256802, 0.045136054,-4.468468
45, 0.47874,1.372388, 2.256802,2.256802, 0.045136054,-4.468468
315, 0.893648,1.468136, 2.256802,2.256802, 0.045136054,-4.468468
45, 0.829816,1.43622, 2.256802,2.256802, 0.045136054,-4.468468
315, -0.223412,1.468136, 2.256802,2.256802, 0.045136054,-4.468468
45, -0.223412,1.851128, 2.256802,2.256802, 0.045136054,-4.468468
315, 0.223412,2.138372, 2.256802,2.256802, 0.045136054,-4.468468
45, 0.223412,2.170288, 2.256802,2.256802, 0.045136054,-4.468468
225, 0.191496,2.138372, 2.256802,2.256802, 0.045136054,-4.468468
315, 0.15958,2.202204, 2.256802,2.256802, 0.045136054,-4.468468
315, -0.223412,2.138372, 2.256802,2.256802, 0.045136054,-4.468468
225, -0.191496,2.202204, 2.256802,2.256802, 0.045136054,-4.468468
225, 0.925564,1.723464, 2.256802,2.256802, 0.045136054,-4.468468
135, 2.55328,1.691548, 2.256802,2.256802, 0.045136054,-4.468468
225, 2.617112,1.723464, 2.256802,2.256802, 0.045136054,-4.468468
315, 2.904356,1.723464, 2.256802,2.256802, 0.045136054,-4.468468
225, 2.936272,1.787296, 2.256802,2.256802, 0.045136054,-4.468468
315, 1.819212,1.787296, 2.256802,2.256802, 0.045136054,-4.468468
225, 1.787296,1.787296, 2.256802,2.256802, 0.045136054,-4.468468
315, 0.829816,1.883044, 2.256802,2.256802, 0.045136054,-4.468468
315, 0.893648,1.787296, 2.256802,2.256802, 0.045136054,-4.468468
45, 0.893648,2.170288, 2.256802,2.256802, 0.045136054,-4.468468
45, 0.829816,1.91496, 2.256802,2.256802, 0.045136054,-4.468468
315, 0.829816,2.07454, 2.256802,2.256802, 0.045136054,-4.468468
225, 0.861732,2.138372, 2.256802,2.256802, 0.045136054,-4.468468
315, 0.829816,2.202204, 2.256802,2.256802, 0.045136054,-4.468468
225, 0.574488,2.266036, 2.256802,2.256802, 0.045136054,-4.468468
315, 0.542572,2.457532, 2.256802,2.256802, 0.045136054,-4.468468
45, 1.085144,2.23412, 2.256802,2.256802, 0.045136054,-4.468468
315, 0.606404,2.266036, 2.256802,2.256802, 0.045136054,-4.468468
45, 0.606404,2.521364, 2.256802,2.256802, 0.045136054,-4.468468
315, 1.085144,2.55328, 2.256802,2.256802, 0.045136054,-4.468468
45, 1.148976,2.521364, 2.256802,2.256802, 0.045136054,-4.468468
135, 1.180892,2.23412, 2.256802,2.256802, 0.045136054,-4.468468
135, 1.787296,2.170288, 2.256802,2.256802, 0.045136054,-4.468468
45, 1.819212,2.170288, 2.256802,2.256802, 0.045136054,-4.468468
315, 2.904356,2.202204, 2.256802,2.256802, 0.045136054,-4.468468
45, 2.904356,2.23412, 2.256802,2.256802, 0.045136054,-4.468468
315, 1.91496,2.266036, 2.256802,2.256802, 0.045136054,-4.468468
225, 1.883044,2.266036, 2.256802,2.256802, 0.045136054,-4.468468
135, 1.883044,2.521364, 2.256802,2.256802, 0.045136054,-4.468468
45, 1.91496,2.425616, 2.256802,2.256802, 0.045136054,-4.468468
135, 2.457532,2.489448, 2.256802,2.256802, 0.045136054,-4.468468
315, 2.904356,2.457532, 2.256802,2.256802, 0.045136054,-4.468468
225, 2.457532,2.904356, 2.256802,2.256802, 0.045136054,-4.468468
135, 3.127768,3.127768, 2.256802,2.256802, 0.045136054,-4.468468
45, 3.095852,2.936272, 2.256802,2.256802, 0.045136054,-4.468468
315, 2.425616,2.968188, 2.256802,2.256802, 0.045136054,-4.468468
45, 2.425616,3.127768, 2.256802,2.256802, 0.045136054,-4.468468
135, 2.3937,3.127768, 2.256802,2.256802, 0.045136054,-4.468468
45, 2.361784,2.840524, 2.256802,2.256802, 0.045136054,-4.468468
135, 1.946876,2.489448, 2.256802,2.256802, 0.045136054,-4.468468
225, 2.3937,2.521364, 2.256802,2.256802, 0.045136054,-4.468468
315, 2.361784,2.808608, 2.256802,2.256802, 0.045136054,-4.468468
45, 1.91496,2.776692, 2.256802,2.256802, 0.045136054,-4.468468
135, 1.43622,2.585196, 2.256802,2.256802, 0.045136054,-4.468468
225, 1.883044,2.617112, 2.256802,2.256802, 0.045136054,-4.468468
315, 1.851128,2.808608, 2.256802,2.256802, 0.045136054,-4.468468
45, 1.404304,2.776692, 2.256802,2.256802, 0.045136054,-4.468468
315, 1.404304,2.87244, 2.256802,2.256802, 0.045136054,-4.468468
45, 1.404304,3.127768, 2.256802,2.256802, 0.045136054,-4.468468
135, 1.372388,3.000104, 2.256802,2.256802, 0.045136054,-4.468468
45, 1.340472,2.585196, 2.256802,2.256802, 0.045136054,-4.468468
315, 0.606404,2.617112, 2.256802,2.256802, 0.045136054,-4.468468
225, 0.63832,3.03202, 2.256802,2.256802, 0.045136054,-4.468468
180, 2.904356,1.75538, 0,3.1916, 1.053228,-2.138372
270, 2.936272,2.170288, 0,3.1916, 0.382992,-2.808608
0, 1.851128,2.202204, 0,3.1916, 1.053228,-2.138372
0, 0.925564,2.202204, 0,3.1916, 0.829816,-2.361784
90, 0.893648,1.787296, 0,3.1916, 0.382992,-2.808608
180, 1.75538,1.75538, 0,3.1916, 0.829816,-2.361784
270, 1.787296,2.170288, 0,3.1916, 0.382992,-2.808608
180, 2.521364,1.723464, 0,3.1916, 1.5958,-1.5958
90, 2.55328,1.468136, 0,3.1916, 0.223412,-2.968188
0, 0.925564,1.43622, 0,3.1916, 1.5958,-1.5958
270, 0.893648,1.691548, 0,3.1916, 0.223412,-2.968188
0, 0.510656,1.404304, 0,3.1916, 0.925564,-2.266036
90, 0.47874,1.053228, 0,3.1916, 0.31916,-2.87244
180, 1.43622,1.021312, 0,3.1916, 0.925564,-2.266036
270, 1.468136,1.372388, 0,3.1916, 0.31916,-2.87244
180, 2.361784,1.148976, 0,3.1916, 0.829816,-2.361784
90, 2.3937,1.053228, 0,3.1916, 0.063832,-3.127768
0, 1.531968,1.021312, 0,3.1916, 0.829816,-2.361784
270, 1.500052,1.11706, 0,3.1916, 0.063832,-3.127768
0, 1.148976,0.989396, 0,3.1916, 1.212808,-1.978792
90, 1.11706,0.734068, 0,3.1916, 0.223412,-2.968188
180, 2.361784,0.702152, 0,3.1916, 1.212808,-1.978792
270, 2.3937,0.95748, 0,3.1916, 0.223412,-2.968188
0, 0.255328,0.989396, 0,3.1916, 0.7979,-2.3937
90, 0.223412,0.542572, 0,3.1916, 0.414908,-2.776692
180, 1.053228,0.510656, 0,3.1916, 0.7979,-2.3937
270, 1.085144,0.95748, 0,3.1916, 0.414908,-2.776692
180, 1.053228,0.47874, 0,3.1916, 0.7979,-2.3937
90, 1.085144,0.31916, 0,3.1916, 0.127664,-3.063936
0, 0.255328,0.287244, 0,3.1916, 0.7979,-2.3937
270, 0.223412,0.446824, 0,3.1916, 0.127664,-3.063936
180, 1.978792,0.670236, 0,3.1916, 0.829816,-2.361784
90, 2.010708,0.382992, 0,3.1916, 0.255328,-2.936272
0, 1.148976,0.351076, 0,3.1916, 0.829816,-2.361784
270, 1.11706,0.63832, 0,3.1916, 0.255328,-2.936272
180, 2.904356,2.457532, 0,3.1916, 0.95748,-2.23412
90, 2.936272,2.266036, 0,3.1916, 0.15958,-3.03202
0, 1.946876,2.23412, 0,3.1916, 0.95748,-2.23412
270, 1.91496,2.425616, 0,3.1916, 0.15958,-3.03202
0, 1.946876,2.808608, 0,3.1916, 0.414908,-2.776692
90, 1.91496,2.521364, 0,3.1916, 0.255328,-2.936272
180, 2.361784,2.489448, 0,3.1916, 0.414908,-2.776692
270, 2.3937,2.776692, 0,3.1916, 0.255328,-2.936272
0, 1.43622,2.808608, 0,3.1916, 0.414908,-2.776692
90, 1.404304,2.617112, 0,3.1916, 0.15958,-3.03202
180, 1.851128,2.585196, 0,3.1916, 0.414908,-2.776692
270, 1.883044,2.776692, 0,3.1916, 0.15958,-3.03202
0, 1.180892,2.55328, 0,3.1916, 0.670236,-2.521364
90, 1.148976,2.266036, 0,3.1916, 0.255328,-2.936272
180, 1.851128,2.23412, 0,3.1916, 0.670236,-2.521364
270, 1.883044,2.521364, 0,3.1916, 0.255328,-2.936272
0, 0.255328,2.202204, 0,3.1916, 0.574488,-2.617112
90, 0.223412,2.138372, 0,3.1916, 0.031916,-3.159684
180, 0.829816,2.106456, 0,3.1916, 0.574488,-2.617112
270, 0.861732,2.170288, 0,3.1916, 0.031916,-3.159684
0, 0.63832,2.585196, 0,3.1916, 0.702152,-2.489448
270, 0.606404,3.000104, 0,3.1916, 0.382992,-2.808608
180, 1.340472,3.03202, 0,3.1916, 0.702152,-2.489448
90, 1.372388,2.617112, 0,3.1916, 0.382992,-2.808608
180, 2.361784,2.840524, 0,3.1916, 0.925564,-2.266036
270, 2.3937,3.127768, 0,3.1916, 0.255328,-2.936272
0, 1.43622,3.159684, 0,3.1916, 0.925564,-2.266036
90, 1.404304,2.87244, 0,3.1916, 0.255328,-2.936272
180, 1.340472,0.31916, 0,3.1916, 0.191496,-3.000104
90, 1.372388,0.191496, 0,3.1916, 0.095748,-3.095852
0, 1.148976,0.15958, 0,3.1916, 0.191496,-3.000104
270, 1.11706,0.287244, 0,3.1916, 0.095748,-3.095852
180, 1.340472,0.127664, 0,3.1916, 0.191496,-3.000104
90, 1.372388,-0.095748, 0,3.1916, 0.191496,-3.000104
0, 1.148976,-0.127664, 0,3.1916, 0.191496,-3.000104
270, 1.11706,0.095748, 0,3.1916, 0.191496,-3.000104
180, 1.978792,0.31916, 0,3.1916, 0.542572,-2.649028
90, 2.010708,0.031916, 0,3.1916, 0.255328,-2.936272
0, 1.43622,0, 0,3.1916, 0.542572,-2.649028
270, 1.404304,0.287244, 0,3.1916, 0.255328,-2.936272
180, 3.095852,2.936272, 0,3.1916, 0.63832,-2.55328
270, 3.127768,3.127768, 0,3.1916, 0.15958,-3.03202
0, 2.457532,3.159684, 0,3.1916, 0.63832,-2.55328
90, 2.425616,2.968188, 0,3.1916, 0.15958,-3.03202
0, -0.191496,1.883044, 0,3.1916, 1.021312,-2.170288
90, -0.223412,1.468136, 0,3.1916, 0.382992,-2.808608
180, 0.829816,1.43622, 0,3.1916, 1.021312,-2.170288
270, 0.861732,1.851128, 0,3.1916, 0.382992,-2.808608
0, -0.191496,2.202204, 0,3.1916, 0.351076,-2.840524
90, -0.223412,2.138372, 0,3.1916, 0.031916,-3.159684
180, 0.15958,2.106456, 0,3.1916, 0.351076,-2.840524
270, 0.191496,2.170288, 0,3.1916, 0.031916,-3.159684
180, 3.734172,2.489448, 0,3.1916, 1.27664,-1.91496
270, 3.766088,2.87244, 0,3.1916, 0.351076,-2.840524
0, 2.457532,2.904356, 0,3.1916, 1.27664,-1.91496
90, 2.425616,2.521364, 0,3.1916, 0.351076,-2.840524
180, 1.085144,2.55328, 0,3.1916, 0.446824,-2.744776
90, 1.11706,2.266036, 0,3.1916, 0.255328,-2.936272
0, 0.63832,2.23412, 0,3.1916, 0.446824,-2.744776
270, 0.606404,2.521364, 0,3.1916, 0.255328,-2.936272
180, 0.542572,2.457532, 0,3.1916, 0.734068,-2.457532
90, 0.574488,2.266036, 0,3.1916, 0.15958,-3.03202
0, -0.191496,2.23412, 0,3.1916, 0.734068,-2.457532
0, -0.191496,2.07454, 0,3.1916, 1.021312,-2.170288
180, 0.829816,1.91496, 0,3.1916, 1.021312,-2.170288
270, 0.861732,2.042624, 0,3.1916, 0.095748,-3.095852
180, 2.904356,1.723464, 0,3.1916, 0.287244,-2.904356
90, 2.936272,1.468136, 0,3.1916, 0.223412,-2.968188
0, 2.617112,1.43622, 0,3.1916, 0.287244,-2.904356
270, 2.585196,1.691548, 0,3.1916, 0.223412,-2.968188
0, 2.457532,1.404304, 0,3.1916, 1.148976,-2.042624
90, 2.425616,1.053228, 0,3.1916, 0.31916,-2.87244
180, 3.606508,1.021312, 0,3.1916, 1.148976,-2.042624
270, 3.638424,1.372388, 0,3.1916, 0.31916,-2.87244
0, 1.531968,1.404304, 0,3.1916, 0.829816,-2.361784
90, 1.500052,1.212808, 0,3.1916, 0.15958,-3.03202
180, 2.361784,1.180892, 0,3.1916, 0.829816,-2.361784
270, 2.3937,1.372388, 0,3.1916, 0.15958,-3.03202
180, 3.35118,0.670236, 0,3.1916, 1.27664,-1.91496
90, 3.383096,0.31916, 0,3.1916, 0.31916,-2.87244
0, 2.07454,0.287244, 0,3.1916, 1.27664,-1.91496
270, 2.042624,0.63832, 0,3.1916, 0.31916,-2.87244
0, 2.457532,0.989396, 0,3.1916, 0.893648,-2.297952
90, 2.425616,0.734068, 0,3.1916, 0.223412,-2.968188
180, 3.35118,0.702152, 0,3.1916, 0.893648,-2.297952
270, 3.383096,0.95748, 0,3.1916, 0.223412,-2.968188
180, 0.542572,0.255328, 0,3.1916, 0.542572,-2.649028
90, 0.574488,-0.191496, 0,3.1916, 0.414908,-2.776692
270, -0.031916,0.223412, 0,3.1916, 0.446824,-2.744776
0, 0.63832,-0.127664, 0,3.1916, 0.414908,-2.776692
270, 0.606404,0.223412, 0,3.1916, 0.31916,-2.87244
180, 1.053228,0.255328, 0,3.1916, 0.414908,-2.776692
90, 1.085144,-0.095748, 0,3.1916, 0.31916,-2.87244
180, 3.095852,0.255328, 0,3.1916, 1.021312,-2.170288
90, 3.127768,0.031916, 0,3.1916, 0.191496,-3.000104
0, 2.07454,0, 0,3.1916, 1.021312,-2.170288
270, 2.042624,0.223412, 0,3.1916, 0.191496,-3.000104
;; (c)1997 STONE PRODUCTS CORPORATION
*PFLSTN, PRO-FIT LEDGESTONE
;%TYPE=MODEL
270, 0.833,0.4998, 0,1.666, 0.0833,-1.5827
90, 0.833,0.4998, 0,1.666, 0.03332,-1.63268
180, 0.9163,0.4998, 0,1.666, 0.0833,-1.5827
0, 0.6664,0.4165, 0,1.666, 0.43316,-1.23284
90, 0.9163,0.4998, 0,1.666, 0.03332,-1.63268
180, 1.09956,0.4998, 0,1.666, 0.18326,-1.48274
270, 0.6664,0.4165, 0,1.666, 0.01666,-1.64934
270, 0.78302,0.39984, 0,1.666, 0.06664,-1.59936
0, 0.43316,0.39984, 0,1.666, 0.34986,-1.31614
180, 0.6664,0, 0,1.666, 0.6664,-0.9996
270, 0.6664,0.3332, 0,1.666, 0.3332,-1.3328
0, 0,0.3332, 0,1.666, 0.6664,-0.9996
90, 0,0, 0,1.666, 0.3332,-1.3328
180, 1.666,0, 0,1.666, 0.9996,-0.6664
270, 1.666,0.3332, 0,1.666, 0.3332,-1.3328
0, 0.6664,0.3332, 0,1.666, 0.9996,-0.6664
90, 0.6664,0, 0,1.666, 0.3332,-1.3328
180, 1.09956,0.3332, 0,1.666, 0.6664,-0.9996
270, 1.09956,0.6664, 0,1.666, 0.3332,-1.3328
0, 0.43316,0.6664, 0,1.666, 0.6664,-0.9996
90, 0.43316,0.3332, 0,1.666, 0.3332,-1.3328
180, 2.09916,0.3332, 0,1.666, 0.9996,-0.6664
270, 2.09916,0.6664, 0,1.666, 0.3332,-1.3328
0, 1.09956,0.6664, 0,1.666, 0.9996,-0.6664
90, 1.09956,0.3332, 0,1.666, 0.3332,-1.3328
180, 1.88258,0.6664, 0,1.666, 0.9996,-0.6664
270, 1.88258,0.9996, 0,1.666, 0.3332,-1.3328
0, 0.88298,0.9996, 0,1.666, 0.9996,-0.6664
90, 0.88298,0.6664, 0,1.666, 0.3332,-1.3328
180, 0.88298,0.6664, 0,1.666, 0.6664,-0.9996
270, 0.88298,0.9996, 0,1.666, 0.3332,-1.3328
0, 0.21658,0.9996, 0,1.666, 0.6664,-0.9996
90, 0.21658,0.6664, 0,1.666, 0.3332,-1.3328
180, 1.56604,0.9996, 0,1.666, 0.9996,-0.6664
270, 1.56604,1.3328, 0,1.666, 0.3332,-1.3328
0, 0.56644,1.3328, 0,1.666, 0.9996,-0.6664
90, 0.56644,0.9996, 0,1.666, 0.3332,-1.3328
180, 0.56644,0.9996, 0,1.666, 0.6664,-0.9996
270, 0.56644,1.3328, 0,1.666, 0.3332,-1.3328
0, -0.09996,1.3328, 0,1.666, 0.6664,-0.9996
90, -0.09996,0.9996, 0,1.666, 0.3332,-1.3328
180, 1.9992,1.3328, 0,1.666, 0.9996,-0.6664
270, 1.9992,1.666, 0,1.666, 0.3332,-1.3328
0, 0.9996,1.666, 0,1.666, 0.9996,-0.6664
90, 0.9996,1.3328, 0,1.666, 0.3332,-1.3328
180, 0.9996,1.3328, 0,1.666, 0.6664,-0.9996
270, 0.9996,1.666, 0,1.666, 0.3332,-1.3328
0, 0.3332,1.666, 0,1.666, 0.6664,-0.9996
90, 0.3332,1.3328, 0,1.666, 0.3332,-1.3328
0, 1.18286,0.09996, 0,1.666, 0.48314,-1.18286
0, 1.44942,0.2499, 0,1.666, 0.21658,-1.44942
63.434949, 1.43276,0.21658, 1.4901157,0.74505786, 0.037252893,-3.6880364
0, 1.18286,0.21658, 0,1.666, 0.2499,-1.4161
0, 0.88298,0.1666, 0,1.666, 0.29988,-1.36612
270, 0.88298,0.21658, 0,1.666, 0.04998,-1.61602
270, 1.18286,0.21658, 0,1.666, 0.21658,-1.44942
60.255119, 1.18286,0.21658, 3.7195536,0.20664186, 0.13431722,-13.297404
0, 0.6664,0.21658, 0,1.666, 0.51646,-1.14954
0, 0.29988,0.13328, 0,1.666, 0.36652,-1.29948
90, 0.29988,0.0833, 0,1.666, 0.13328,-1.53272
0, 0,0.0833, 0,1.666, 0.29988,-1.36612
0, 0,0.21658, 0,1.666, 0.6664,-0.9996
90, 0.34986,0.29988, 0,1.666, 0.03332,-1.63268
180, 0.6664,0.29988, 0,1.666, 0.31654,-1.34946
255.96376, 1.4161,1.39944, 1.6162574,0.40406436, 0.068690946,-6.800403
225, 1.46608,1.44942, 1.1780399,1.1780399, 0.070682399,-2.2853974
71.565051, 1.666,1.51606, 1.5805064,0.52683546, 0.052683551,-5.215671
0, 1.666,1.51606, 0,1.666, 0.3332,-1.3328
243.43495, 1.666,1.51606, 1.4901157,0.74505786, 0.074505786,-3.6507835
0, 0.9996,1.44942, 0,1.666, 0.9996,-0.6664
90, 1.44942,1.53272, 0,1.666, 0.03332,-1.63268
0, 0.9996,1.53272, 0,1.666, 0.44982,-1.21618
296.56505, 1.28282,1.666, 2.2351736,0.74505786, 0.11175868,-3.6135306
0, 1.53272,1.56604, 0,1.666, 0.46648,-1.19952
0, 0.9996,1.56604, 0,1.666, 0.53312,-1.13288
0, 1.7493,0.54978, 0,1.666, 0.34986,-1.31614
270, 1.7493,0.5831, 0,1.666, 0.03332,-1.63268
0, 1.36612,0.5831, 0,1.666, 0.73304,-0.93296
239.03624, 1.36612,0.5831, 3.7143164,0.28571665, 0.09714366,-9.6172222
90, 1.36612,0.5831, 0,1.666, 0.0833,-1.5827
0, 1.09956,0.5831, 0,1.666, 0.26656,-1.39944
270, 1.4994,0.36652, 0,1.666, 0.03332,-1.63268
270, 1.4994,0.38318, 0,1.666, 0.01666,-1.64934
296.56505, 1.48274,0.4165, 2.2351736,0.74505786, 0.037252893,-3.6880364
315, 1.46608,0.43316, 1.1780399,1.1780399, 0.023560805,-2.332519
296.56505, 1.44942,0.46648, 2.2351736,0.74505786, 0.037252893,-3.6880364
270, 1.44942,0.4998, 0,1.666, 0.03332,-1.63268
180, 1.43276,0.4998, 0,1.666, 0.3332,-1.3328
180, 2.09916,0.4998, 0,1.666, 0.6664,-0.9996
0, 1.43276,0.79968, 0,1.666, 0.44982,-1.21618
291.03751, 1.39944,0.88298, 8.9708872,0.11961184, 0.23204694,-22.972648
289.98311, 1.09956,0.84966, 14.233599,0.14233599, 0.1950003,-19.30503
180, 1.21618,0.84966, 0,1.666, 0.3332,-1.3328
296.56505, 1.19952,0.88298, 2.2351736,0.74505786, 0.037252893,-3.6880364
0, 1.43276,0.88298, 0,1.666, 0.44982,-1.21618
66.801409, 1.43276,0.88298, 8.9690172,0.21875651, 0.12687878,-12.560999
0, 0.88298,0.88298, 0,1.666, 0.54978,-1.11622
270, 0.98294,1.19952, 0,1.666, 0.04998,-1.61602
288.43495, 0.96628,1.2495, 3.6878482,0.52683546, 0.052683551,-5.215671
288.43495, 0.94962,1.29948, 3.6878482,0.52683546, 0.052683551,-5.215671
270, 0.94962,1.3328, 0,1.666, 0.03332,-1.63268
180, 1.34946,1.14954, 0,1.666, 0.78302,-0.88298
279.46232, 1.36612,1.09956, 8.4905501,0.27388872, 0.10133883,-10.032544
0, 1.36612,1.09956, 0,1.666, 0.19992,-1.46608
288.43495, 1.34946,1.14954, 3.6878482,0.52683546, 0.052683551,-5.215671
180, 1.56604,1.14954, 0,1.666, 0.21658,-1.44942
0, 0.1666,1.04958, 0,1.666, 0.39984,-1.26616
251.56505, 0.18326,1.09956, 1.5805064,0.52683546, 0.10536709,-5.1629875
66.801409, 0.18326,1.09956, 8.9690172,0.21875651, 0.12687878,-12.560999
0, -0.09996,1.09956, 0,1.666, 0.28322,-1.38278
180, 0.09996,1.21618, 0,1.666, 0.19992,-1.46608
0, 0.09996,1.21618, 0,1.666, 0.46648,-1.19952
270, 0.09996,1.2495, 0,1.666, 0.03332,-1.63268
90, 0.09996,1.2495, 0,1.666, 0.0833,-1.5827
180, 0.56644,1.2495, 0,1.666, 0.46648,-1.19952
270, 0.7497,1.53272, 0,1.666, 0.03332,-1.63268
251.56505, 0.76636,1.5827, 1.5805064,0.52683546, 0.052683551,-5.215671
270, 0.76636,1.59936, 0,1.666, 0.01666,-1.64934
296.56505, 0.7497,1.63268, 2.2351736,0.74505786, 0.037252893,-3.6880364
243.43495, 0.76636,1.666, 1.4901157,0.74505786, 0.037252893,-3.6880364
0, 0.54978,1.4994, 0,1.666, 0.44982,-1.21618
180, 0.54978,1.4994, 0,1.666, 0.21658,-1.44942
56.309932, 0.51646,1.44942, 3.6965221,0.46206527, 0.06006848,-5.9467799
270, 0.51646,1.44942, 0,1.666, 0.11662,-1.54938
0, 0.3332,1.44942, 0,1.666, 0.18326,-1.48274
288.43495, 0.64974,0.46648, 3.6878482,0.52683546, 0.052683551,-5.215671
315, 0.61642,0.4998, 1.1780399,1.1780399, 0.047121594,-2.3089582
90, 0.61642,0.4998, 0,1.666, 0.03332,-1.63268
0, 0.43316,0.4998, 0,1.666, 0.18326,-1.48274
180, 0.833,0.53312, 0,1.666, 0.39984,-1.26616
90, 0.833,0.53312, 0,1.666, 0.13328,-1.53272
180, 1.09956,0.53312, 0,1.666, 0.26656,-1.39944
0, 0.71638,0.76636, 0,1.666, 0.1666,-1.4994
288.43495, 0.71638,0.71638, 3.6878482,0.52683546, 0.052683551,-5.215671
270, 0.71638,0.76636, 0,1.666, 0.04998,-1.61602
243.43495, 0.73304,0.79968, 1.4901157,0.74505786, 0.037252893,-3.6880364
291.80141, 0.69972,0.88298, 3.7124212,0.30936844, 0.089716849,-8.8819677
0, 0.4998,0.88298, 0,1.666, 0.38318,-1.28282
90, 0.4998,0.88298, 0,1.666, 0.11662,-1.54938
0, 0.21658,0.88298, 0,1.666, 0.28322,-1.38278
;; (c)1997 STONE PRODUCTS CORPORATION
*RVRRCK, RIVER ROCK
;%TYPE=MODEL
212.00538, -0.167958,0.419895, 10.088657,0.29672521, 0.26408543,-26.144458
213.69007, 0,0.531867, 3.8819306,0.77638613, 0.2018604,-9.8911593
198.43495, 0.083979,0.55986, 6.1965148,0.8852164, 0.088521648,-8.7636421
180, 0.195951,0.55986, 0,2.7993, 0.111972,-2.687328
161.56505, 0.27993,0.531867, 2.6556491,0.8852164, 0.088521648,-8.7636421
333.43495, 0.307923,2.547363, 2.50377,1.251885, 0.1251885,-6.1342366
296.56505, 0.27993,2.603349, 3.7556551,1.251885, 0.062594252,-6.1968308
270, 0.27993,2.743314, 0,2.7993, 0.139965,-2.659335
186.34019, 0.307923,0.923769, 22.566561,0.30913098, 0.25348739,-25.095253
296.56505, 0.923769,2.659335, 3.7556551,1.251885, 0.062594252,-6.1968308
303.69007, 0.867783,2.743314, 3.8819306,0.77638613, 0.10093019,-9.9920895
229.39871, 1.315671,1.511622, 21.861124,0.30362671, 0.25808269,-25.550188
243.43495, 1.39965,1.67958, 2.50377,1.251885, 0.18778275,-6.0716424
213.69007, 2.379405,1.371657, 3.8819306,0.77638613, 0.10093019,-9.9920895
33.690068, 1.539615,0.587853, 3.8819306,0.77638613, 0.10093019,-9.9920895
0, 1.483629,0.587853, 0,2.7993, 0.055986,-2.743314
333.43495, 1.427643,0.615846, 2.50377,1.251885, 0.062594252,-6.1968308
284.03624, 1.39965,0.727818, 8.8260897,0.67892999, 0.11541811,-11.426391
270, 1.39965,0.783804, 0,2.7993, 0.055986,-2.743314
243.43495, 1.39965,0.83979, 2.50377,1.251885, 0.062594252,-6.1968308
135, 1.39965,0.867783, 1.979404,1.979404, 0.039588093,-3.9192199
90, 1.39965,0.83979, 0,2.7993, 0.027993,-2.771307
18.434949, 2.407398,2.127468, 6.1965148,0.8852164, 0.17704326,-8.6751205
6.3401918, 2.575356,2.183454, 22.566561,0.30913098, 0.25348739,-25.095253
180, 2.463384,1.511622, 0,2.7993, 0.167958,-2.631342
197.35402, 2.911272,1.651587, 8.8505887,0.16699224, 0.46924819,-46.455571
198.43495, 2.995251,1.67958, 6.1965148,0.8852164, 0.088521648,-8.7636421
213.69007, 3.07923,1.735566, 3.8819306,0.77638613, 0.10093019,-9.9920895
251.56505, 3.107223,1.819545, 2.6556491,0.8852164, 0.088521648,-8.7636421
243.43495, 3.135216,1.875531, 2.50377,1.251885, 0.062594252,-6.1968308
270, 3.135216,1.931517, 0,2.7993, 0.055986,-2.743314
293.19859, 3.051237,2.127468, 6.2486237,0.36756609, 0.21318833,-21.105645
315, 2.967258,2.211447, 1.979404,1.979404, 0.11876425,-3.8400437
0, 2.827293,2.211447, 0,2.7993, 0.139965,-2.659335
341.56505, 2.211447,1.539615, 2.6556491,0.8852164, 0.088521648,-8.7636421
303.69007, 2.155461,1.623594, 3.8819306,0.77638613, 0.10093019,-9.9920895
279.46232, 2.127468,1.791552, 14.266265,0.46020209, 0.17027478,-16.857202
270, 2.127468,1.95951, 0,2.7993, 0.167958,-2.631342
239.03624, 2.211447,2.099475, 6.2409879,0.480076, 0.16322584,-16.159358
188.1301, 2.407398,2.127468, 17.022874,0.39588082, 0.19794041,-19.5961
116.56505, 0.335916,2.043489, 3.7556551,1.251885, 0.062594252,-6.1968308
135, 0.391902,1.987503, 1.979404,1.979404, 0.079176157,-3.8796318
168.69007, 0.531867,1.95951, 2.7449395,0.54898791, 0.14273687,-14.130949
191.30993, 0.671832,1.987503, 11.528746,0.54898791, 0.14273687,-14.130949
194.03624, 0.783804,2.015496, 8.8260897,0.67892999, 0.11541811,-11.426391
236.30993, 0.83979,2.099475, 6.211089,0.77638613, 0.10093019,-9.9920895
236.30993, 0.895776,2.183454, 6.211089,0.77638613, 0.10093019,-9.9920895
270, 0.895776,2.267433, 0,2.7993, 0.083979,-2.715321
291.80141, 0.83979,2.407398, 6.2378035,0.51981696, 0.15074692,-14.923945
116.56505, 0.867783,1.819545, 3.7556551,1.251885, 0.1251885,-6.1342366
168.69007, 1.007748,1.791552, 2.7449395,0.54898791, 0.14273687,-14.130949
194.03624, 1.11972,1.819545, 8.8260897,0.67892999, 0.11541811,-11.426391
225, 1.203699,1.903524, 1.979404,1.979404, 0.11876425,-3.8400437
251.56505, 1.231692,1.987503, 2.6556491,0.8852164, 0.088521648,-8.7636421
296.56505, 1.175706,2.099475, 3.7556551,1.251885, 0.1251885,-6.1342366
315, 1.11972,2.155461, 1.979404,1.979404, 0.079176157,-3.8796318
326.30993, 1.035741,2.211447, 6.211089,0.77638613, 0.10093019,-9.9920895
0, 0.979755,2.211447, 0,2.7993, 0.055986,-2.743314
33.690068, 0.895776,2.155461, 3.8819306,0.77638613, 0.10093019,-9.9920895
71.565051, 0.867783,2.071482, 2.6556491,0.8852164, 0.088521648,-8.7636421
63.434949, 0.83979,2.015496, 2.50377,1.251885, 0.062594252,-6.1968308
71.565051, 0.811797,1.931517, 2.6556491,0.8852164, 0.088521648,-8.7636421
104.03624, 0.811797,1.819545, 8.8260897,0.67892999, 0.11541811,-11.426391
45, 0.755811,1.763559, 1.979404,1.979404, 0.079176157,-3.8796318
18.434949, 0.671832,1.735566, 6.1965148,0.8852164, 0.088521648,-8.7636421
0, 0.531867,1.735566, 0,2.7993, 0.139965,-2.659335
14.036243, 0.419895,1.707573, 8.8260897,0.67892999, 0.11541811,-11.426391
341.56505, 0.335916,1.735566, 2.6556491,0.8852164, 0.088521648,-8.7636421
270, 0.335916,1.819545, 0,2.7993, 0.083979,-2.715321
225, 0.419895,1.903524, 1.979404,1.979404, 0.11876425,-3.8400437
198.43495, 0.587853,1.95951, 6.1965148,0.8852164, 0.17704326,-8.6751205
180, 0.727818,1.95951, 0,2.7993, 0.139965,-2.659335
153.43495, 0.783804,1.931517, 2.50377,1.251885, 0.062594252,-6.1968308
206.56505, 1.847538,1.483629, 3.7556551,1.251885, 0.062594252,-6.1968308
146.30993, 1.931517,1.427643, 6.211089,0.77638613, 0.10093019,-9.9920895
119.74488, 2.043489,1.231692, 16.31889,0.34721042, 0.22568679,-22.342992
95.710593, 2.071482,0.951762, 25.34721,0.27854076, 0.28132618,-27.85129
90, 2.071482,0.923769, 0,2.7993, 0.027993,-2.771307
63.434949, 2.043489,0.867783, 2.50377,1.251885, 0.062594252,-6.1968308
26.565051, 1.987503,0.83979, 3.7556551,1.251885, 0.062594252,-6.1968308
0, 1.903524,0.83979, 0,2.7993, 0.083979,-2.715321
0, 1.875531,0.83979, 0,2.7993, 0.027993,-2.771307
0, 1.819545,0.83979, 0,2.7993, 0.055986,-2.743314
326.30993, 1.735566,0.895776, 6.211089,0.77638613, 0.10093019,-9.9920895
333.43495, 1.67958,0.923769, 2.50377,1.251885, 0.062594252,-6.1968308
284.03624, 1.651587,1.035741, 8.8260897,0.67892999, 0.11541811,-11.426391
270, 1.651587,1.091727, 0,2.7993, 0.055986,-2.743314
270, 1.651587,1.175706, 0,2.7993, 0.083979,-2.715321
258.69007, 1.67958,1.315671, 2.7449395,0.54898791, 0.14273687,-14.130949
231.34019, 1.791552,1.455636, 13.989671,0.43717721, 0.17924264,-17.745023
270, 2.379405,1.39965, 0,2.7993, 0.027993,-2.771307
270, 2.379405,1.427643, 0,2.7993, 0.027993,-2.771307
326.30993, 2.295426,1.483629, 6.211089,0.77638613, 0.10093019,-9.9920895
333.43495, 2.127468,1.567608, 2.50377,1.251885, 0.18778275,-6.0716424
0, 1.987503,1.567608, 0,2.7993, 0.139965,-2.659335
63.434949, 1.95951,1.511622, 2.50377,1.251885, 0.062594252,-6.1968308
90, 1.95951,1.39965, 0,2.7993, 0.111972,-2.687328
135, 2.043489,1.315671, 1.979404,1.979404, 0.11876425,-3.8400437
161.56505, 2.127468,1.287678, 2.6556491,0.8852164, 0.088521648,-8.7636421
180, 2.211447,1.287678, 0,2.7993, 0.083979,-2.715321
198.43495, 2.295426,1.315671, 6.1965148,0.8852164, 0.088521648,-8.7636421
351.8699, 1.203699,2.827293, 2.7711656,0.39588082, 0.39588082,-19.39816
14.036243, 1.091727,2.7993, 8.8260897,0.67892999, 0.11541811,-11.426391
53.130102, 1.007748,2.687328, 10.07748,0.55986, 0.139965,-13.856535
95.194429, 1.035741,2.379405, 28.131475,0.25343672, 0.30919279,-30.610087
101.30993, 1.063734,2.23944, 11.528746,0.54898791, 0.14273687,-14.130949
143.1301, 1.175706,2.155461, 10.07748,0.55986, 0.139965,-13.856535
161.56505, 1.259685,2.127468, 2.6556491,0.8852164, 0.088521648,-8.7636421
198.43495, 1.343664,2.155461, 6.1965148,0.8852164, 0.088521648,-8.7636421
225, 1.483629,2.295426, 1.979404,1.979404, 0.19794041,-3.7608675
228.81407, 1.67958,2.51937, 25.806927,0.263336, 0.29756968,-29.459397
251.56505, 1.707573,2.603349, 2.6556491,0.8852164, 0.088521648,-8.7636421
270, 1.707573,2.631342, 0,2.7993, 0.027993,-2.771307
288.43495, 1.67958,2.715321, 6.1965148,0.8852164, 0.088521648,-8.7636421
326.30993, 1.595601,2.771307, 6.211089,0.77638613, 0.10093019,-9.9920895
90, 0.307923,2.099475, 0,2.7993, 0.195951,-2.603349
338.19859, 0.699825,2.463384, 8.8368884,0.51981696, 0.15074692,-14.923945
0, 0.531867,2.463384, 0,2.7993, 0.167958,-2.631342
30.963757, 0.391902,2.379405, 10.081596,0.480076, 0.16322584,-16.159358
45, 0.307923,2.295426, 1.979404,1.979404, 0.11876425,-3.8400437
90, -0.139965,1.203699, 0,2.7993, 0.195951,-2.603349
116.56505, -0.055986,1.035741, 3.7556551,1.251885, 0.18778275,-6.0716424
153.43495, 0.111972,0.951762, 2.50377,1.251885, 0.18778275,-6.0716424
180, 0.251937,0.951762, 0,2.7993, 0.139965,-2.659335
218.65981, 0.391902,1.063734, 3.9345949,0.43717721, 0.17924264,-17.745023
231.34019, 0.503874,1.203699, 13.989671,0.43717721, 0.17924264,-17.745023
213.69007, 0.671832,1.315671, 3.8819306,0.77638613, 0.2018604,-9.8911593
239.03624, 0.755811,1.455636, 6.2409879,0.480076, 0.16322584,-16.159358
270, 0.755811,1.511622, 0,2.7993, 0.055986,-2.743314
270, 0.755811,1.595601, 0,2.7993, 0.083979,-2.715321
315, 0.671832,1.67958, 1.979404,1.979404, 0.11876425,-3.8400437
350.53768, 0.503874,1.707573, 2.7612125,0.46020209, 0.17027478,-16.857202
14.036243, 0.27993,1.651587, 8.8260897,0.67892999, 0.23083618,-11.310973
18.434949, 0.027993,1.567608, 6.1965148,0.8852164, 0.26556491,-8.5865989
45, -0.055986,1.483629, 1.979404,1.979404, 0.11876425,-3.8400437
45, -0.139965,1.39965, 1.979404,1.979404, 0.11876425,-3.8400437
108.43495, 0.475881,0.783804, 6.1965148,0.8852164, 0.17704326,-8.6751205
126.8699, 0.55986,0.671832, 3.91902,0.55986, 0.139965,-13.856535
146.30993, 0.643839,0.615846, 6.211089,0.77638613, 0.10093019,-9.9920895
161.56505, 0.727818,0.587853, 2.6556491,0.8852164, 0.088521648,-8.7636421
135, 0.811797,0.503874, 1.979404,1.979404, 0.11876425,-3.8400437
161.56505, 0.895776,0.475881, 2.6556491,0.8852164, 0.088521648,-8.7636421
180, 0.979755,0.475881, 0,2.7993, 0.083979,-2.715321
206.56505, 1.035741,0.503874, 3.7556551,1.251885, 0.062594252,-6.1968308
206.56505, 1.147713,0.55986, 3.7556551,1.251885, 0.1251885,-6.1342366
189.46232, 1.315671,0.587853, 14.266265,0.46020209, 0.17027478,-16.857202
243.43495, 1.371657,0.699825, 2.50377,1.251885, 0.1251885,-6.1342366
270, 1.371657,0.727818, 0,2.7993, 0.027993,-2.771307
270, 1.371657,0.783804, 0,2.7993, 0.055986,-2.743314
326.30993, 1.287678,0.951762, 6.211089,0.77638613, 0.10093019,-9.9920895
327.99462, 1.063734,1.091727, 16.319887,0.29672521, 0.26408543,-26.144458
329.03624, 0.923769,1.175706, 6.2409879,0.480076, 0.16322584,-16.159358
341.56505, 0.755811,1.231692, 2.6556491,0.8852164, 0.17704326,-8.6751205
0, 0.643839,1.231692, 0,2.7993, 0.111972,-2.687328
33.690068, 0.55986,1.175706, 3.8819306,0.77638613, 0.10093019,-9.9920895
53.130102, 0.475881,1.063734, 10.07748,0.55986, 0.139965,-13.856535
63.434949, 0.419895,0.951762, 2.50377,1.251885, 0.1251885,-6.1342366
225, 1.707573,0.727818, 1.979404,1.979404, 0.11876425,-3.8400437
236.30993, 1.763559,0.811797, 6.211089,0.77638613, 0.10093019,-9.9920895
270, 1.763559,0.83979, 0,2.7993, 0.027993,-2.771307
315, 1.707573,0.895776, 1.979404,1.979404, 0.079176157,-3.8796318
333.43495, 1.595601,0.951762, 2.50377,1.251885, 0.1251885,-6.1342366
18.434949, 1.427643,0.895776, 6.1965148,0.8852164, 0.17704326,-8.6751205
75.963757, 1.39965,0.783804, 2.7157198,0.67892999, 0.11541811,-11.426391
71.565051, 0.139965,0.251937, 2.6556491,0.8852164, 0.088521648,-8.7636421
135, 0.195951,0.195951, 1.979404,1.979404, 0.079176157,-3.8796318
146.30993, 0.27993,0.139965, 6.211089,0.77638613, 0.10093019,-9.9920895
153.43495, 0.391902,0.083979, 2.50377,1.251885, 0.1251885,-6.1342366
180, 0.419895,0.083979, 0,2.7993, 0.027993,-2.771307
161.56505, 0.503874,0.055986, 2.6556491,0.8852164, 0.088521648,-8.7636421
180, 0.615846,0.055986, 0,2.7993, 0.111972,-2.687328
198.43495, 0.699825,0.083979, 6.1965148,0.8852164, 0.088521648,-8.7636421
210.96376, 0.83979,0.167958, 10.081596,0.480076, 0.16322584,-16.159358
206.56505, 0.895776,0.195951, 3.7556551,1.251885, 0.062594252,-6.1968308
251.56505, 0.923769,0.27993, 2.6556491,0.8852164, 0.088521648,-8.7636421
303.69007, 0.867783,0.363909, 3.8819306,0.77638613, 0.10093019,-9.9920895
306.8699, 0.783804,0.475881, 3.91902,0.55986, 0.139965,-13.856535
323.1301, 0.671832,0.55986, 10.07748,0.55986, 0.139965,-13.856535
345.96376, 0.55986,0.587853, 2.7157198,0.67892999, 0.11541811,-11.426391
18.434949, 0.475881,0.55986, 6.1965148,0.8852164, 0.088521648,-8.7636421
30.963757, 0.335916,0.475881, 10.081596,0.480076, 0.16322584,-16.159358
39.805571, 0.167958,0.335916, 3.94255,0.35841364, 0.21863233,-21.644599
135, 1.007748,0.083979, 1.979404,1.979404, 0.039588093,-3.9192199
153.43495, 1.063734,0.055986, 2.50377,1.251885, 0.062594252,-6.1968308
191.30993, 1.203699,0.083979, 11.528746,0.54898791, 0.14273687,-14.130949
165.96376, 1.315671,0.055986, 2.7157198,0.67892999, 0.11541811,-11.426391
175.23636, 1.651587,0.027993, 2.7896306,0.23246921, 0.33708036,-33.370955
206.56505, 1.707573,0.055986, 3.7556551,1.251885, 0.062594252,-6.1968308
225, 1.763559,0.111972, 1.979404,1.979404, 0.079176157,-3.8796318
270, 1.763559,0.251937, 0,2.7993, 0.139965,-2.659335
270, 1.763559,0.335916, 0,2.7993, 0.083979,-2.715321
308.65981, 1.651587,0.475881, 3.9345949,0.43717721, 0.17924264,-17.745023
338.19859, 1.511622,0.531867, 8.8368884,0.51981696, 0.15074692,-14.923945
348.69007, 1.371657,0.55986, 2.7449395,0.54898791, 0.14273687,-14.130949
18.434949, 1.11972,0.475881, 6.1965148,0.8852164, 0.26556491,-8.5865989
36.869898, 1.007748,0.391902, 3.91902,0.55986, 0.139965,-13.856535
68.198591, 0.951762,0.251937, 8.8368884,0.51981696, 0.15074692,-14.923945
101.30993, 0.979755,0.111972, 11.528746,0.54898791, 0.14273687,-14.130949
348.69007, 0.727818,2.771307, 2.7449395,0.54898791, 0.14273687,-14.130949
354.80557, 0.419895,2.7993, 2.7878038,0.25343672, 0.30919279,-30.610087
0, 0.335916,2.7993, 0,2.7993, 0.083979,-2.715321
45, 0.27993,2.743314, 1.979404,1.979404, 0.079176157,-3.8796318
180, 0.503874,2.491377, 0,2.7993, 0.083979,-2.715321
188.1301, 0.699825,2.51937, 17.022874,0.39588082, 0.19794041,-19.5961
172.87498, 0.923769,2.491377, 2.7776834,0.34721042, 0.22568679,-22.342992
225, 0.951762,2.51937, 1.979404,1.979404, 0.039588093,-3.9192199
270, 0.951762,2.603349, 0,2.7993, 0.083979,-2.715321
161.56505, 1.847538,2.687328, 2.6556491,0.8852164, 0.088521648,-8.7636421
180, 1.95951,2.687328, 0,2.7993, 0.111972,-2.687328
198.43495, 2.043489,2.715321, 6.1965148,0.8852164, 0.088521648,-8.7636421
170.53768, 2.211447,2.687328, 2.7612125,0.46020209, 0.17027478,-16.857202
213.69007, 2.295426,2.743314, 3.8819306,0.77638613, 0.10093019,-9.9920895
270, 2.295426,2.771307, 0,2.7993, 0.027993,-2.771307
296.56505, 2.267433,2.827293, 3.7556551,1.251885, 0.062594252,-6.1968308
341.56505, 2.099475,2.883279, 2.6556491,0.8852164, 0.17704326,-8.6751205
341.56505, 1.931517,2.939265, 2.6556491,0.8852164, 0.17704326,-8.6751205
14.036243, 1.819545,2.911272, 8.8260897,0.67892999, 0.11541811,-11.426391
45, 1.735566,2.827293, 1.979404,1.979404, 0.11876425,-3.8400437
104.03624, 1.763559,2.715321, 8.8260897,0.67892999, 0.11541811,-11.426391
0, -0.419895,0.27993, 0,2.7993, 0.027993,-2.771307
315, -0.475881,0.335916, 1.979404,1.979404, 0.079176157,-3.8796318
274.76364, -0.503874,0.671832, 30.918406,0.23246921, 0.33708036,-33.370955
255.96376, -0.475881,0.783804, 2.7157198,0.67892999, 0.11541811,-11.426391
225, -0.419895,0.83979, 1.979404,1.979404, 0.079176157,-3.8796318
198.43495, -0.167958,0.923769, 6.1965148,0.8852164, 0.26556491,-8.5865989
180, -0.139965,0.923769, 0,2.7993, 0.027993,-2.771307
171.8699, 0.055986,0.895776, 2.7711656,0.39588082, 0.19794041,-19.5961
146.30993, 0.391902,0.867783, 6.211089,0.77638613, 0.10093019,-9.9920895
108.43495, 0.447888,0.699825, 6.1965148,0.8852164, 0.17704326,-8.6751205
90, 0.447888,0.671832, 0,2.7993, 0.027993,-2.771307
71.565051, 0.419895,0.587853, 2.6556491,0.8852164, 0.088521648,-8.7636421
26.565051, 0.363909,0.55986, 3.7556551,1.251885, 0.062594252,-6.1968308
18.434949, 0.27993,0.531867, 6.1965148,0.8852164, 0.088521648,-8.7636421
126.8699, 1.791552,0.335916, 3.91902,0.55986, 0.139965,-13.856535
123.69007, 1.847538,0.251937, 3.8819306,0.77638613, 0.10093019,-9.9920895
149.03624, 1.987503,0.167958, 6.2409879,0.480076, 0.16322584,-16.159358
168.69007, 2.127468,0.139965, 2.7449395,0.54898791, 0.14273687,-14.130949
213.69007, 2.211447,0.195951, 3.8819306,0.77638613, 0.10093019,-9.9920895
251.56505, 2.23944,0.27993, 2.6556491,0.8852164, 0.088521648,-8.7636421
270, 2.23944,0.307923, 0,2.7993, 0.027993,-2.771307
279.46232, 2.211447,0.475881, 14.266265,0.46020209, 0.17027478,-16.857202
243.43495, 2.23944,0.531867, 2.50377,1.251885, 0.062594252,-6.1968308
270, 2.23944,0.55986, 0,2.7993, 0.027993,-2.771307
296.56505, 2.155461,0.727818, 3.7556551,1.251885, 0.18778275,-6.0716424
329.03624, 2.015496,0.811797, 6.2409879,0.480076, 0.16322584,-16.159358
8.1301023, 1.819545,0.783804, 17.022874,0.39588082, 0.19794041,-19.5961
45, 1.707573,0.671832, 1.979404,1.979404, 0.15835231,-3.8004556
45, 1.651587,0.615846, 1.979404,1.979404, 0.079176157,-3.8796318
90, 1.651587,0.531867, 0,2.7993, 0.083979,-2.715321
123.69007, 1.707573,0.447888, 3.8819306,0.77638613, 0.10093019,-9.9920895
101.30993, 2.127468,0.951762, 11.528746,0.54898791, 0.14273687,-14.130949
108.43495, 2.155461,0.867783, 6.1965148,0.8852164, 0.088521648,-8.7636421
135, 2.183454,0.83979, 1.979404,1.979404, 0.039588093,-3.9192199
180, 2.267433,0.83979, 0,2.7993, 0.083979,-2.715321
213.69007, 2.351412,0.895776, 3.8819306,0.77638613, 0.10093019,-9.9920895
187.12502, 2.575356,0.923769, 19.790995,0.34721042, 0.22568679,-22.342992
236.30993, 2.631342,1.007748, 6.211089,0.77638613, 0.10093019,-9.9920895
270, 2.631342,1.035741, 0,2.7993, 0.027993,-2.771307
288.43495, 2.603349,1.11972, 6.1965148,0.8852164, 0.088521648,-8.7636421
285.9454, 2.547363,1.315671, 8.8438088,0.38451342, 0.20379212,-20.175419
315, 2.491377,1.371657, 1.979404,1.979404, 0.079176157,-3.8796318
18.434949, 2.407398,1.343664, 6.1965148,0.8852164, 0.088521648,-8.7636421
29.744881, 2.211447,1.231692, 16.31889,0.34721042, 0.22568679,-22.342992
18.434949, 2.127468,1.203699, 6.1965148,0.8852164, 0.088521648,-8.7636421
75.963757, 2.099475,1.091727, 2.7157198,0.67892999, 0.11541811,-11.426391
180, 1.287678,1.819545, 0,2.7993, 0.083979,-2.715321
180, 1.343664,1.819545, 0,2.7993, 0.055986,-2.743314
135, 1.39965,1.763559, 1.979404,1.979404, 0.079176157,-3.8796318
90, 1.39965,1.67958, 0,2.7993, 0.083979,-2.715321
26.565051, 0.979755,1.231692, 3.7556551,1.251885, 0.18778275,-6.0716424
341.56505, 0.895776,1.259685, 2.6556491,0.8852164, 0.088521648,-8.7636421
300.96376, 0.811797,1.39965, 10.081596,0.480076, 0.16322584,-16.159358
71.565051, 1.343664,1.483629, 2.6556491,0.8852164, 0.088521648,-8.7636421
90, 1.343664,1.343664, 0,2.7993, 0.139965,-2.659335
123.69007, 1.39965,1.259685, 3.8819306,0.77638613, 0.10093019,-9.9920895
153.43495, 1.511622,1.203699, 2.50377,1.251885, 0.1251885,-6.1342366
198.43495, 1.595601,1.231692, 6.1965148,0.8852164, 0.088521648,-8.7636421
243.43495, 1.623594,1.287678, 2.50377,1.251885, 0.062594252,-6.1968308
255.96376, 1.651587,1.39965, 2.7157198,0.67892999, 0.11541811,-11.426391
251.56505, 1.67958,1.483629, 2.6556491,0.8852164, 0.088521648,-8.7636421
291.80141, 1.623594,1.623594, 6.2378035,0.51981696, 0.15074692,-14.923945
323.1301, 1.511622,1.707573, 10.07748,0.55986, 0.139965,-13.856535
18.434949, 1.427643,1.67958, 6.1965148,0.8852164, 0.088521648,-8.7636421
63.434949, 1.371657,1.567608, 2.50377,1.251885, 0.1251885,-6.1342366
135, 1.147713,1.063734, 1.979404,1.979404, 0.11876425,-3.8400437
149.03624, 1.287678,0.979755, 6.2409879,0.480076, 0.16322584,-16.159358
146.30993, 1.371657,0.923769, 6.211089,0.77638613, 0.10093019,-9.9920895
180, 1.427643,0.923769, 0,2.7993, 0.055986,-2.743314
210.96376, 1.567608,1.007748, 10.081596,0.480076, 0.16322584,-16.159358
243.43495, 1.595601,1.063734, 2.50377,1.251885, 0.062594252,-6.1968308
303.69007, 1.539615,1.147713, 3.8819306,0.77638613, 0.10093019,-9.9920895
321.34019, 1.39965,1.259685, 13.989671,0.43717721, 0.17924264,-17.745023
345.96376, 1.287678,1.287678, 2.7157198,0.67892999, 0.11541811,-11.426391
11.309932, 1.147713,1.259685, 11.528746,0.54898791, 0.14273687,-14.130949
26.565051, 1.091727,1.231692, 3.7556551,1.251885, 0.062594252,-6.1968308
71.565051, 1.063734,1.147713, 2.6556491,0.8852164, 0.088521648,-8.7636421
15.945396, 1.007748,1.763559, 8.8438088,0.38451342, 0.20379212,-20.175419
29.744881, 0.811797,1.651587, 16.31889,0.34721042, 0.22568679,-22.342992
63.434949, 0.783804,1.595601, 2.50377,1.251885, 0.062594252,-6.1968308
90, 0.783804,1.511622, 0,2.7993, 0.083979,-2.715321
104.03624, 0.811797,1.39965, 8.8260897,0.67892999, 0.11541811,-11.426391
120.96376, 0.895776,1.259685, 10.081596,0.480076, 0.16322584,-16.159358
153.43495, 2.463384,2.743314, 2.50377,1.251885, 0.062594252,-6.1968308
180, 2.51937,2.743314, 0,2.7993, 0.055986,-2.743314
209.74488, 2.715321,2.855286, 16.31889,0.34721042, 0.22568679,-22.342992
225, 2.827293,2.967258, 1.979404,1.979404, 0.15835231,-3.8004556
239.03624, 2.911272,3.107223, 6.2409879,0.480076, 0.16322584,-16.159358
239.03624, 2.995251,3.247188, 6.2409879,0.480076, 0.16322584,-16.159358
270, 2.995251,3.275181, 0,2.7993, 0.027993,-2.771307
333.43495, 2.939265,3.303174, 2.50377,1.251885, 0.062594252,-6.1968308
0, 2.855286,3.303174, 0,2.7993, 0.083979,-2.715321
45, 2.771307,3.219195, 1.979404,1.979404, 0.11876425,-3.8400437
26.565051, 2.435391,3.051237, 3.7556551,1.251885, 0.37556551,-5.8838596
30.963757, 2.295426,2.967258, 10.081596,0.480076, 0.16322584,-16.159358
90, 2.295426,2.911272, 0,2.7993, 0.055986,-2.743314
128.65981, 2.407398,2.771307, 3.9345949,0.43717721, 0.17924264,-17.745023
255.96376, 2.099475,1.847538, 2.7157198,0.67892999, 0.11541811,-11.426391
281.30993, 2.071482,1.987503, 11.528746,0.54898791, 0.14273687,-14.130949
309.80557, 1.931517,2.155461, 3.94255,0.35841364, 0.21863233,-21.644599
329.03624, 1.791552,2.23944, 6.2409879,0.480076, 0.16322584,-16.159358
345.96376, 1.67958,2.267433, 2.7157198,0.67892999, 0.11541811,-11.426391
0, 1.567608,2.267433, 0,2.7993, 0.111972,-2.687328
26.565051, 1.455636,2.211447, 3.7556551,1.251885, 0.1251885,-6.1342366
45, 1.371657,2.127468, 1.979404,1.979404, 0.11876425,-3.8400437
53.130102, 1.287678,2.015496, 10.07748,0.55986, 0.139965,-13.856535
90, 1.287678,1.931517, 0,2.7993, 0.083979,-2.715321
135, 1.371657,1.847538, 1.979404,1.979404, 0.11876425,-3.8400437
144.46232, 1.567608,1.707573, 10.087772,0.32541201, 0.24080488,-23.839684
135, 1.707573,1.567608, 1.979404,1.979404, 0.19794041,-3.7608675
153.43495, 1.819545,1.511622, 2.50377,1.251885, 0.1251885,-6.1342366
206.56505, 1.931517,1.567608, 3.7556551,1.251885, 0.1251885,-6.1342366
230.19443, 2.071482,1.735566, 17.920681,0.35841364, 0.21863233,-21.644599
66.801409, 1.707573,2.407398, 15.07021,0.36756609, 0.21318833,-21.105645
90, 1.707573,2.323419, 0,2.7993, 0.083979,-2.715321
153.43495, 1.763559,2.295426, 2.50377,1.251885, 0.062594252,-6.1968308
153.43495, 1.875531,2.23944, 2.50377,1.251885, 0.1251885,-6.1342366
149.03624, 2.015496,2.155461, 6.2409879,0.480076, 0.16322584,-16.159358
180, 2.155461,2.155461, 0,2.7993, 0.139965,-2.659335
180, 2.323419,2.155461, 0,2.7993, 0.167958,-2.631342
213.69007, 2.407398,2.211447, 3.8819306,0.77638613, 0.10093019,-9.9920895
243.43495, 2.463384,2.323419, 2.50377,1.251885, 0.1251885,-6.1342366
277.12502, 2.435391,2.547363, 19.790995,0.34721042, 0.22568679,-22.342992
315, 2.379405,2.603349, 1.979404,1.979404, 0.079176157,-3.8796318
341.56505, 2.295426,2.631342, 2.6556491,0.8852164, 0.088521648,-8.7636421
352.87498, 2.071482,2.659335, 2.7776834,0.34721042, 0.22568679,-22.342992
0, 1.931517,2.659335, 0,2.7993, 0.139965,-2.659335
21.801409, 1.791552,2.603349, 6.2378035,0.51981696, 0.15074692,-14.923945
90, 3.051237,2.463384, 0,2.7993, 0.111972,-2.687328
90, 3.051237,2.351412, 0,2.7993, 0.111972,-2.687328
56.309932, 2.995251,2.267433, 6.211089,0.77638613, 0.10093019,-9.9920895
18.434949, 2.911272,2.23944, 6.1965148,0.8852164, 0.088521648,-8.7636421
0, 2.631342,2.23944, 0,2.7993, 0.27993,-2.51937
341.56505, 2.547363,2.267433, 2.6556491,0.8852164, 0.088521648,-8.7636421
296.56505, 2.51937,2.323419, 3.7556551,1.251885, 0.062594252,-6.1968308
278.1301, 2.491377,2.51937, 17.022874,0.39588082, 0.19794041,-19.5961
270, 2.491377,2.547363, 0,2.7993, 0.027993,-2.771307
251.56505, 2.51937,2.631342, 2.6556491,0.8852164, 0.088521648,-8.7636421
225, 2.603349,2.715321, 1.979404,1.979404, 0.11876425,-3.8400437
218.65981, 2.743314,2.827293, 3.9345949,0.43717721, 0.17924264,-17.745023
225, 2.827293,2.911272, 1.979404,1.979404, 0.11876425,-3.8400437
206.56505, 2.883279,2.939265, 3.7556551,1.251885, 0.062594252,-6.1968308
180, 2.939265,2.939265, 0,2.7993, 0.055986,-2.743314
123.69007, 2.995251,2.855286, 3.8819306,0.77638613, 0.10093019,-9.9920895
108.43495, 3.023244,2.771307, 6.1965148,0.8852164, 0.088521648,-8.7636421
98.130102, 3.051237,2.575356, 17.022874,0.39588082, 0.19794041,-19.5961
;; (c)1997 STONE PRODUCTS CORPORATION
*SLSTN, SOUTHERN LEDGESTONE
;%TYPE=MODEL
354.80557, 1.4098,2.3408, 2.6490759,0.24082509, 0.2938066,-29.086854
4.3987054, 1.064,2.3142, 32.029992,0.20401269, 0.34682157,-34.335336
355.91438, 0.6916,2.3408, 2.6532401,0.18951715, 0.3733488,-36.96153
0, 0.6118,2.3408, 0,2.66, 0.0798,-2.5802
5.1944289, 0.3192,2.3142, 26.731585,0.24082509, 0.2938066,-29.086854
180, 0.6916,2.6068, 0,2.66, 0.3724,-2.2876
161.56505, 0.7714,2.5802, 2.5234976,0.84116587, 0.084116595,-8.327542
180, 0.9842,2.5802, 0,2.66, 0.2128,-2.4472
188.1301, 1.1704,2.6068, 16.175775,0.37618082, 0.18809041,-18.62095
180, 1.5162,2.6068, 0,2.66, 0.3458,-2.3142
184.76364, 1.8354,2.6334, 29.37983,0.22090098, 0.32030643,-31.710335
174.80557, 1.8354,1.33, 2.6490759,0.24082509, 0.2938066,-29.086854
180, 2.0216,1.33, 0,2.66, 0.1862,-2.4738
184.08562, 2.394,1.3566, 34.681639,0.18951715, 0.3733488,-36.96153
180, 2.5802,1.3566, 0,2.66, 0.1862,-2.4738
0, 2.3674,0.8778, 0,2.66, 0.133,-2.527
351.8699, 2.1812,0.9044, 2.6332657,0.37618082, 0.18809041,-18.62095
0, 1.9684,0.9044, 0,2.66, 0.2128,-2.4472
18.434949, 1.8088,0.8512, 5.888161,0.84116587, 0.16823316,-8.2434254
0, 1.596,0.8512, 0,2.66, 0.2128,-2.4472
355.60129, 1.2502,0.8778, 2.652165,0.20401269, 0.34682157,-34.335336
0, 1.0374,0.8778, 0,2.66, 0.2128,-2.4472
18.434949, 0.9576,0.8512, 5.888161,0.84116587, 0.084116595,-8.327542
0, 0.7448,0.8512, 0,2.66, 0.2128,-2.4472
348.69007, 0.6118,0.8778, 2.6083447,0.52166893, 0.13563393,-13.427758
0, 0.5054,0.8778, 0,2.66, 0.1064,-2.5536
0, 2.0482,0.6118, 0,2.66, 0.4522,-2.2078
1.5074358, 1.0374,0.5852, 98.455914,0.069975769, 1.0111499,-100.10384
0, 0.8778,0.5852, 0,2.66, 0.1596,-2.5004
4.3987054, 0.532,0.5586, 32.029992,0.20401269, 0.34682157,-34.335336
296.56505, 1.0108,1.0374, 3.5687645,1.1895882, 0.059479409,-5.8884614
251.56505, 1.0374,1.1172, 2.5234976,0.84116587, 0.084116595,-8.327542
261.8699, 1.862,2.527, 2.6332657,0.37618082, 0.18809041,-18.62095
270, 1.862,2.6068, 0,2.66, 0.0798,-2.5802
284.03624, 0.266,2.4472, 8.386882,0.64514478, 0.10967462,-10.857786
270, 0.266,2.5004, 0,2.66, 0.0532,-2.6068
251.56505, 0.2926,2.5802, 2.5234976,0.84116587, 0.084116595,-8.327542
270, 3.1122,0.9576, 0,2.66, 0.0532,-2.6068
251.56505, 3.1388,1.0374, 2.5234976,0.84116587, 0.084116595,-8.327542
270, 3.1388,1.1172, 0,2.66, 0.0798,-2.5802
296.56505, 3.1122,1.1704, 3.5687645,1.1895882, 0.059479409,-5.8884614
270, 1.0108,1.2236, 0,2.66, 0.0798,-2.5802
255.96376, 1.0374,1.33, 2.5805791,0.64514478, 0.10967462,-10.857786
296.56505, 1.0108,1.3832, 3.5687645,1.1895882, 0.059479409,-5.8884614
270, 0.4788,1.1438, 0,2.66, 0.0266,-2.6334
270, 0.4788,1.463, 0,2.66, 0.2128,-2.4472
243.43495, 0.5054,1.197, 2.3791764,1.1895882, 0.059479409,-5.8884614
270, 0.5054,1.2502, 0,2.66, 0.0532,-2.6068
288.43495, 0.4788,1.33, 5.888161,0.84116587, 0.084116595,-8.327542
270, 1.0374,1.4896, 0,2.66, 0.1064,-2.5536
236.30993, 1.0906,1.5694, 5.9020101,0.73775127, 0.095907657,-9.4948587
270, 1.0906,1.596, 0,2.66, 0.0266,-2.6334
288.43495, 1.064,1.6758, 5.888161,0.84116587, 0.084116595,-8.327542
270, 1.064,1.7024, 0,2.66, 0.0266,-2.6334
180, 0.532,1.4098, 0,2.66, 0.0266,-2.6334
0, 0.798,1.4098, 0,2.66, 0.1862,-2.4738
26.565051, 0.7448,1.3832, 3.5687645,1.1895882, 0.059479409,-5.8884614
0, 0.6384,1.3832, 0,2.66, 0.1064,-2.5536
345.96376, 0.532,1.4098, 2.5805791,0.64514478, 0.10967462,-10.857786
0, 2.527,1.6226, 0,2.66, 0.0532,-2.6068
345.96376, 2.4206,1.6492, 2.5805791,0.64514478, 0.10967462,-10.857786
0, 2.2876,1.6492, 0,2.66, 0.133,-2.527
18.434949, 2.2078,1.6226, 5.888161,0.84116587, 0.084116595,-8.327542
0, 2.0748,1.6226, 0,2.66, 0.133,-2.527
243.43495, 2.0482,1.463, 2.3791764,1.1895882, 0.059479409,-5.8884614
270, 2.0482,1.5162, 0,2.66, 0.0532,-2.6068
288.43495, 2.0216,1.596, 5.888161,0.84116587, 0.084116595,-8.327542
270, 2.0216,1.6758, 0,2.66, 0.0798,-2.5802
255.96376, 2.0482,1.7822, 2.5805791,0.64514478, 0.10967462,-10.857786
270, 2.0482,1.8088, 0,2.66, 0.0266,-2.6334
270, 0.5054,0.7182, 0,2.66, 0.1064,-2.5536
296.56505, 0.4788,0.7714, 3.5687645,1.1895882, 0.059479409,-5.8884614
270, 0.4788,0.8512, 0,2.66, 0.0798,-2.5802
255.96376, 2.5536,0.7448, 2.5805791,0.64514478, 0.10967462,-10.857786
270, 2.5536,0.7714, 0,2.66, 0.0266,-2.6334
288.43495, 2.527,0.8512, 5.888161,0.84116587, 0.084116595,-8.327542
0, 2.3408,2.4738, 0,2.66, 0.133,-2.527
0, 1.9684,2.3408, 0,2.66, 0.0532,-2.6068
0, 2.0482,1.0108, 0,2.66, 0.0266,-2.6334
0, 2.0748,0.9842, 0,2.66, 0.133,-2.527
0, 2.7664,1.0906, 0,2.66, 0.1862,-2.4738
0, 2.3408,0.133, 0,2.66, 0.0532,-2.6068
0, 1.9152,0.1064, 0,2.66, 0.133,-2.527
0, 1.8088,0.133, 0,2.66, 0.1596,-2.5004
0, 0.2926,0.2394, 0,2.66, 0.0266,-2.6334
0, 0.1064,0.266, 0,2.66, 0.1862,-2.4738
0, 1.9152,0.7182, 0,2.66, 0.0532,-2.6068
0, 0.7448,0.7448, 0,2.66, 0.0798,-2.5802
0, 0.6118,0.7714, 0,2.66, 0.1862,-2.4738
0, 2.261,1.3034, 0,2.66, 0.133,-2.527
0, 1.2768,1.2502, 0,2.66, 0.1596,-2.5004
0, 0.133,1.596, 0,2.66, 0.0266,-2.6334
0, 1.2768,1.4896, 0,2.66, 0.0798,-2.5802
0, 1.6758,1.6492, 0,2.66, 0.133,-2.527
0, 1.6226,1.6758, 0,2.66, 0.133,-2.527
0, 2.1546,1.9418, 0,2.66, 0.2394,-2.4206
0, 0.5852,2.4738, 0,2.66, 0.1596,-2.5004
0, 1.3832,2.5004, 0,2.66, 0.0798,-2.5802
0, 1.463,2.527, 0,2.66, 0.2394,-2.4206
0, 0.931,2.0482, 0,2.66, 0.1596,-2.5004
0, 0.266,2.0748, 0,2.66, 0.1862,-2.4738
0, 0.2394,2.1014, 0,2.66, 0.1862,-2.4738
146.30993, 0.399,-0.0532, 5.9020101,0.73775127, 0.095907657,-9.4948587
180, 0.532,-0.0532, 0,2.66, 0.133,-2.527
185.19443, 0.8246,-0.0266, 26.731585,0.24082509, 0.2938066,-29.086854
315, -0.133,0.0266, 1.8809041,1.8809041, 0.037618092,-3.7241901
270, -0.133,0.1596, 0,2.66, 0.133,-2.527
225, -0.1064,0.1862, 1.8809041,1.8809041, 0.037618092,-3.7241901
225, 0.8512,0, 1.8809041,1.8809041, 0.037618092,-3.7241901
315, 0.8246,0.1862, 1.8809041,1.8809041, 0.037618092,-3.7241901
315, -0.0798,0.2128, 1.8809041,1.8809041, 0.037618092,-3.7241901
45, -0.1064,0.3192, 1.8809041,1.8809041, 0.037618092,-3.7241901
225, 0.8512,0.2394, 1.8809041,1.8809041, 0.037618092,-3.7241901
251.56505, 0.8778,0.3192, 2.5234976,0.84116587, 0.084116595,-8.327542
315, 0.8512,0.3458, 1.8809041,1.8809041, 0.037618092,-3.7241901
270, 1.33,0.3192, 0,2.66, 0.0266,-2.6334
45, 0.9044,0.3192, 1.8809041,1.8809041, 0.037618092,-3.7241901
135, 0.931,0.2926, 1.8809041,1.8809041, 0.037618092,-3.7241901
175.91438, 1.3034,0.266, 2.6532401,0.18951715, 0.3733488,-36.96153
225, 1.33,0.2926, 1.8809041,1.8809041, 0.037618092,-3.7241901
315, 1.3034,0.3458, 1.8809041,1.8809041, 0.037618092,-3.7241901
90, 0.8778,0.0266, 0,2.66, 0.2394,-2.4206
135, 0.9044,0, 1.8809041,1.8809041, 0.037618092,-3.7241901
176.42367, 1.33,-0.0266, 2.6548199,0.16592625, 0.42643045,-42.216614
225, 1.3566,0, 1.8809041,1.8809041, 0.037618092,-3.7241901
270, 1.3566,0.0266, 0,2.66, 0.0266,-2.6334
278.1301, 1.33,0.2128, 16.175775,0.37618082, 0.18809041,-18.62095
315, 1.3034,0.2394, 1.8809041,1.8809041, 0.037618092,-3.7241901
352.40536, 0.9044,0.2926, 21.444885,0.17577775, 0.40253104,-39.850573
45, 0.8778,0.266, 1.8809041,1.8809041, 0.037618092,-3.7241901
315, 1.3832,0.0266, 1.8809041,1.8809041, 0.037618092,-3.7241901
225, 2.527,0.0532, 1.8809041,1.8809041, 0.037618092,-3.7241901
270, 2.527,0.1862, 0,2.66, 0.133,-2.527
315, 2.5004,0.2128, 1.8809041,1.8809041, 0.037618092,-3.7241901
357.70939, 1.3832,0.2394, 2.6578745,0.10631499, 0.66553179,-65.887647
45, 1.3566,0.2128, 1.8809041,1.8809041, 0.037618092,-3.7241901
225, 2.527,0.266, 1.8809041,1.8809041, 0.037618092,-3.7241901
243.43495, 2.5536,0.3192, 2.3791764,1.1895882, 0.059479409,-5.8884614
270, 2.5536,0.3458, 0,2.66, 0.0266,-2.6334
315, 2.527,0.3724, 1.8809041,1.8809041, 0.037618092,-3.7241901
315, 1.3566,0.2926, 1.8809041,1.8809041, 0.037618092,-3.7241901
45, 1.3566,0.3458, 1.8809041,1.8809041, 0.037618092,-3.7241901
135, 2.6334,0.5852, 1.8809041,1.8809041, 0.037618092,-3.7241901
45, 2.6068,0.5054, 1.8809041,1.8809041, 0.037618092,-3.7241901
225, 2.6068,0.4256, 1.8809041,1.8809041, 0.037618092,-3.7241901
315, 2.5802,0.5054, 1.8809041,1.8809041, 0.037618092,-3.7241901
45, 2.2344,0.4788, 1.8809041,1.8809041, 0.037618092,-3.7241901
135, 2.261,0.399, 1.8809041,1.8809041, 0.037618092,-3.7241901
225, 2.2078,0.4256, 1.8809041,1.8809041, 0.037618092,-3.7241901
270, 2.2078,0.4788, 0,2.66, 0.0532,-2.6068
315, 2.1812,0.5054, 1.8809041,1.8809041, 0.037618092,-3.7241901
341.56505, 2.1014,0.532, 2.5234976,0.84116587, 0.084116595,-8.327542
315, 1.064,0.399, 1.8809041,1.8809041, 0.037618092,-3.7241901
270, 1.064,0.532, 0,2.66, 0.133,-2.527
1.5911403, 1.0906,0.5586, 93.137964,0.073860406, 0.95796937,-94.838968
45, 1.064,0.532, 1.8809041,1.8809041, 0.037618092,-3.7241901
225, 1.0374,0.399, 1.8809041,1.8809041, 0.037618092,-3.7241901
251.56505, 1.064,0.4788, 2.5234976,0.84116587, 0.084116595,-8.327542
315, 1.0374,0.5586, 1.8809041,1.8809041, 0.037618092,-3.7241901
315, -0.0532,0.3724, 1.8809041,1.8809041, 0.037618092,-3.7241901
270, -0.0532,0.399, 0,2.66, 0.0266,-2.6334
248.19859, 0,0.532, 8.3971432,0.4939496, 0.14324539,-14.181293
225, 0.0266,0.5586, 1.8809041,1.8809041, 0.037618092,-3.7241901
225, 2.527,0.6384, 1.8809041,1.8809041, 0.037618092,-3.7241901
315, 2.5004,0.8778, 1.8809041,1.8809041, 0.037618092,-3.7241901
180, 0.9576,0.8778, 0,2.66, 0.4522,-2.2078
315, 0.5054,0.5852, 1.8809041,1.8809041, 0.037618092,-3.7241901
270, 0.5054,0.6118, 0,2.66, 0.0266,-2.6334
225, 0.5054,0.8778, 1.8809041,1.8809041, 0.037618092,-3.7241901
270, -0.1064,0.8512, 0,2.66, 0.1862,-2.4738
135, -0.0798,0.6384, 1.8809041,1.8809041, 0.037618092,-3.7241901
180, 0,0.6384, 0,2.66, 0.0798,-2.5802
135, 0.0532,0.5852, 1.8809041,1.8809041, 0.075236158,-3.6865719
176.42367, 0.4788,0.5586, 2.6548199,0.16592625, 0.42643045,-42.216614
225, 0.5054,0.5852, 1.8809041,1.8809041, 0.037618092,-3.7241901
270, 0.5054,0.6118, 0,2.66, 0.0266,-2.6334
284.03624, 0.4522,0.8246, 8.386882,0.64514478, 0.21934921,-10.748112
315, 0.4256,0.8512, 1.8809041,1.8809041, 0.037618092,-3.7241901
356.98721, -0.0798,0.8778, 2.6563235,0.13980649, 0.50609953,-50.103852
45, -0.1064,0.8512, 1.8809041,1.8809041, 0.037618092,-3.7241901
270, 1.8354,0.9576, 0,2.66, 0.0266,-2.6334
225, 1.8354,0.931, 1.8809041,1.8809041, 0.037618092,-3.7241901
315, 1.8088,0.9842, 1.8809041,1.8809041, 0.037618092,-3.7241901
315, 1.862,0.931, 1.8809041,1.8809041, 0.037618092,-3.7241901
262.87498, 1.8886,1.1438, 2.6394592,0.32993238, 0.21445606,-21.231149
180, 2.3142,0.9044, 0,2.66, 0.4256,-2.2344
175.60129, 2.66,0.8778, 2.652165,0.20401269, 0.34682157,-34.335336
180, 3.0856,0.8778, 0,2.66, 0.4256,-2.2344
225, 3.1122,0.9044, 1.8809041,1.8809041, 0.037618092,-3.7241901
315, 3.0856,1.197, 1.8809041,1.8809041, 0.037618092,-3.7241901
1.6846843, 2.1812,1.1704, 87.820259,0.078201473, 0.9047911,-89.574318
0, 1.9152,1.1704, 0,2.66, 0.266,-2.394
45, 1.8886,1.1438, 1.8809041,1.8809041, 0.037618092,-3.7241901
270, 0.4788,1.064, 0,2.66, 0.1596,-2.5004
0, 0.5054,1.0906, 0,2.66, 0.4788,-2.1812
315, 0.4788,0.9044, 1.8809041,1.8809041, 0.037618092,-3.7241901
225, 0.5054,1.0906, 1.8809041,1.8809041, 0.037618092,-3.7241901
315, 0.9842,1.0906, 1.8809041,1.8809041, 0.037618092,-3.7241901
135, 0.5054,1.0906, 1.8809041,1.8809041, 0.037618092,-3.7241901
183.17983, 0.9842,1.1172, 45.297927,0.14755025, 0.47953831,-47.474294
225, 1.0108,1.1438, 1.8809041,1.8809041, 0.037618092,-3.7241901
315, 0.9842,1.4098, 1.8809041,1.8809041, 0.037618092,-3.7241901
45, 0.4788,1.3832, 1.8809041,1.8809041, 0.037618092,-3.7241901
185.71059, 0.4522,1.2236, 24.08587,0.2646799, 0.2673267,-26.465343
225, 0.4788,1.2502, 1.8809041,1.8809041, 0.037618092,-3.7241901
225, 0,1.3832, 1.8809041,1.8809041, 0.037618092,-3.7241901
194.03624, 0.2128,1.4364, 8.386882,0.64514478, 0.21934921,-10.748112
192.52881, 0.4522,1.4896, 10.963665,0.28851751, 0.24523987,-24.278748
135, 0.4788,1.463, 1.8809041,1.8809041, 0.037618092,-3.7241901
0, 0.5586,1.5162, 0,2.66, 0.1596,-2.5004
315, 0.5054,1.4364, 1.8809041,1.8809041, 0.037618092,-3.7241901
243.43495, 0.532,1.4896, 2.3791764,1.1895882, 0.059479409,-5.8884614
225, 0.5586,1.5162, 1.8809041,1.8809041, 0.037618092,-3.7241901
180, 1.0108,1.5694, 0,2.66, 0.2394,-2.4206
225, 1.0108,1.4364, 1.8809041,1.8809041, 0.037618092,-3.7241901
255.96376, 1.0374,1.5428, 2.5805791,0.64514478, 0.10967462,-10.857786
315, 1.0108,1.5694, 1.8809041,1.8809041, 0.037618092,-3.7241901
0, 1.8088,2.0748, 0,2.66, 0.5054,-2.1546
18.434949, 1.729,2.0482, 5.888161,0.84116587, 0.084116595,-8.327542
3.1798301, 1.064,0.9576, 45.297927,0.14755025, 0.47953831,-47.474294
315, 1.0374,0.9842, 1.8809041,1.8809041, 0.037618092,-3.7241901
225, 1.862,1.0108, 1.8809041,1.8809041, 0.037618092,-3.7241901
315, 1.8354,1.1704, 1.8809041,1.8809041, 0.037618092,-3.7241901
45, 1.0374,1.1172, 1.8809041,1.8809041, 0.037618092,-3.7241901
315, 1.0374,1.197, 1.8809041,1.8809041, 0.037618092,-3.7241901
243.43495, 1.064,1.3566, 2.3791764,1.1895882, 0.059479409,-5.8884614
182.72631, 2.6068,1.197, 53.266308,0.1265233, 0.55923297,-55.364064
225, 2.6334,1.2236, 1.8809041,1.8809041, 0.037618092,-3.7241901
284.03624, 2.6068,1.33, 8.386882,0.64514478, 0.10967462,-10.857786
315, 2.5802,1.3566, 1.8809041,1.8809041, 0.037618092,-3.7241901
135, 2.0748,1.3566, 1.8809041,1.8809041, 0.037618092,-3.7241901
225, 2.6334,1.4098, 1.8809041,1.8809041, 0.037618092,-3.7241901
278.1301, 2.6068,1.596, 16.175775,0.37618082, 0.18809041,-18.62095
315, 2.5802,1.6226, 1.8809041,1.8809041, 0.037618092,-3.7241901
45, 2.0482,1.596, 1.8809041,1.8809041, 0.037618092,-3.7241901
225, 2.66,1.8886, 1.8809041,1.8809041, 0.037618092,-3.7241901
270, 2.66,1.9152, 0,2.66, 0.0266,-2.6334
284.03624, 2.6334,2.0216, 8.386882,0.64514478, 0.10967462,-10.857786
315, 2.6068,2.0482, 1.8809041,1.8809041, 0.037618092,-3.7241901
354.80557, 2.128,2.0748, 2.6490759,0.24082509, 0.2938066,-29.086854
0, 1.862,2.0748, 0,2.66, 0.266,-2.394
18.434949, 1.7822,2.0482, 5.888161,0.84116587, 0.084116595,-8.327542
0, 1.596,2.0482, 0,2.66, 0.1862,-2.4738
8.1301023, 1.4098,2.0216, 16.175775,0.37618082, 0.18809041,-18.62095
45, 1.3832,1.995, 1.8809041,1.8809041, 0.037618092,-3.7241901
78.690068, 1.3566,1.862, 2.6083447,0.52166893, 0.13563393,-13.427758
135, 1.3832,1.8354, 1.8809041,1.8809041, 0.037618092,-3.7241901
255.96376, 2.6334,1.7822, 2.5805791,0.64514478, 0.10967462,-10.857786
270, 2.6334,1.8088, 0,2.66, 0.0266,-2.6334
270, 2.0482,1.8088, 0,2.66, 0.133,-2.527
225, 2.6068,1.6758, 1.8809041,1.8809041, 0.037618092,-3.7241901
315, 2.6068,1.8354, 1.8809041,1.8809041, 0.037618092,-3.7241901
315, 2.0482,1.6758, 1.8809041,1.8809041, 0.037618092,-3.7241901
225, 2.0748,1.8354, 1.8809041,1.8809041, 0.037618092,-3.7241901
184.08562, 1.995,1.3832, 34.681639,0.18951715, 0.3733488,-36.96153
225, 2.0216,1.4098, 1.8809041,1.8809041, 0.037618092,-3.7241901
315, 2.0216,1.8354, 1.8809041,1.8809041, 0.037618092,-3.7241901
315, 1.0374,1.3832, 1.8809041,1.8809041, 0.037618092,-3.7241901
45, 1.064,1.7024, 1.8809041,1.8809041, 0.037618092,-3.7241901
45, 0.6384,1.6758, 1.8809041,1.8809041, 0.037618092,-3.7241901
75.963757, 0.6118,1.5694, 2.5805791,0.64514478, 0.10967462,-10.857786
135, 0.6384,1.5428, 1.8809041,1.8809041, 0.037618092,-3.7241901
225, 1.0374,1.596, 1.8809041,1.8809041, 0.037618092,-3.7241901
255.96376, 1.064,1.7024, 2.5805791,0.64514478, 0.10967462,-10.857786
315, 1.0374,1.729, 1.8809041,1.8809041, 0.037618092,-3.7241901
315, 0.6384,1.7556, 1.8809041,1.8809041, 0.037618092,-3.7241901
258.69007, 0.665,1.8886, 2.6083447,0.52166893, 0.13563393,-13.427758
315, 1.33,1.9152, 1.8809041,1.8809041, 0.037618092,-3.7241901
0, 0.6916,1.9152, 0,2.66, 0.6384,-2.0216
45, 0.665,1.8886, 1.8809041,1.8809041, 0.037618092,-3.7241901
0, 0.3458,1.8886, 0,2.66, 0.266,-2.394
5.1944289, 0.0532,1.862, 26.731585,0.24082509, 0.2938066,-29.086854
45, 0.0266,1.8354, 1.8809041,1.8809041, 0.037618092,-3.7241901
75.963757, -0.0266,1.6226, 2.5805791,0.64514478, 0.21934921,-10.748112
90, -0.0266,1.596, 0,2.66, 0.0266,-2.6334
99.462322, 0,1.4364, 13.55634,0.43730131, 0.1618015,-16.018347
135, 0.0266,1.4098, 1.8809041,1.8809041, 0.037618092,-3.7241901
180, 0.0532,1.4098, 0,2.66, 0.0266,-2.6334
194.74356, 0.5586,1.5428, 41.294083,0.13539044, 0.52260709,-51.738101
225, 0.5852,1.5694, 1.8809041,1.8809041, 0.037618092,-3.7241901
259.69515, 0.6384,1.862, 16.178399,0.23791764, 0.29739704,-29.442307
315, 0.6118,1.8886, 1.8809041,1.8809041, 0.037618092,-3.7241901
0, 0.931,2.2078, 0,2.66, 0.8246,-1.8354
351.8699, 0.0532,1.9152, 2.6332657,0.37618082, 0.18809041,-18.62095
180, 0.399,2.1812, 0,2.66, 0.3724,-2.2876
181.7357, 1.2768,2.2078, 85.161515,0.080569086, 0.87820294,-86.942091
135, 1.3034,2.1812, 1.8809041,1.8809041, 0.037618092,-3.7241901
116.56505, 1.33,2.128, 3.5687645,1.1895882, 0.059479409,-5.8884614
104.03624, 1.3566,2.0216, 8.386882,0.64514478, 0.10967462,-10.857786
90, 1.3566,1.9418, 0,2.66, 0.0798,-2.5802
45, 1.33,1.9152, 1.8809041,1.8809041, 0.037618092,-3.7241901
0, 0.6118,1.9152, 0,2.66, 0.7182,-1.9418
8.1301023, 0.4256,1.8886, 16.175775,0.37618082, 0.18809041,-18.62095
0, 0.2394,1.8886, 0,2.66, 0.1862,-2.4738
315, 0.0266,1.9418, 1.8809041,1.8809041, 0.037618092,-3.7241901
277.12502, 0,2.1546, 18.806147,0.32993238, 0.21445606,-21.231149
225, 0.0266,2.1812, 1.8809041,1.8809041, 0.037618092,-3.7241901
180, 1.6758,2.1812, 0,2.66, 0.3192,-2.3408
189.46232, 1.8354,2.2078, 13.55634,0.43730131, 0.1618015,-16.018347
180, 2.0216,2.2078, 0,2.66, 0.1862,-2.4738
183.01279, 2.527,2.2344, 47.953629,0.13980649, 0.50609953,-50.103852
180, 2.6334,2.2344, 0,2.66, 0.1064,-2.5536
270, 2.66,2.2078, 0,2.66, 0.133,-2.527
45, 2.6334,2.0482, 1.8809041,1.8809041, 0.037618092,-3.7241901
0, 2.4472,2.0482, 0,2.66, 0.1862,-2.4738
348.69007, 2.3142,2.0748, 2.6083447,0.52166893, 0.13563393,-13.427758
0, 1.7024,2.0482, 0,2.66, 0.0266,-2.6334
333.43495, 1.6492,2.0748, 2.3791764,1.1895882, 0.059479409,-5.8884614
11.309932, 1.3832,2.0216, 10.955047,0.52166893, 0.27126784,-13.292124
315, 1.3566,2.0482, 1.8809041,1.8809041, 0.037618092,-3.7241901
288.43495, 1.33,2.128, 5.888161,0.84116587, 0.084116595,-8.327542
270, 1.33,2.1546, 0,2.66, 0.0266,-2.6334
225, 1.3566,2.1812, 1.8809041,1.8809041, 0.037618092,-3.7241901
135, 2.66,2.2078, 1.8809041,1.8809041, 0.037618092,-3.7241901
225, 2.926,2.3408, 1.8809041,1.8809041, 0.037618092,-3.7241901
270, 2.926,2.3674, 0,2.66, 0.0266,-2.6334
275.71059, 2.8994,2.6334, 24.08587,0.2646799, 0.2673267,-26.465343
315, 2.8728,2.66, 1.8809041,1.8809041, 0.037618092,-3.7241901
56.309932, 1.8088,2.261, 5.9020101,0.73775127, 0.095907657,-9.4948587
90, 1.8088,2.2344, 0,2.66, 0.0266,-2.6334
264.80557, 1.8886,2.6334, 2.6490759,0.24082509, 0.2938066,-29.086854
315, 1.8088,2.2344, 1.8809041,1.8809041, 0.037618092,-3.7241901
45, 1.8886,2.6334, 1.8809041,1.8809041, 0.037618092,-3.7241901
225, 1.8354,2.3408, 1.8809041,1.8809041, 0.037618092,-3.7241901
315, 1.8354,2.6334, 1.8809041,1.8809041, 0.037618092,-3.7241901
270, 0.9044,2.2876, 0,2.66, 0.0532,-2.6068
315, 1.7556,2.3142, 1.8809041,1.8809041, 0.037618092,-3.7241901
45, 1.7556,2.2078, 1.8809041,1.8809041, 0.037618092,-3.7241901
315, 0.9044,2.2344, 1.8809041,1.8809041, 0.037618092,-3.7241901
45, 0.9044,2.2876, 1.8809041,1.8809041, 0.037618092,-3.7241901
2.1210964, 0.1596,2.2876, 69.211065,0.098451016, 0.71869242,-71.15055
45, 0.8778,2.2078, 1.8809041,1.8809041, 0.037618092,-3.7241901
2.0454085, 0.133,2.1812, 71.869179,0.09493947, 0.74527484,-73.78221
315, 0.1064,2.2078, 1.8809041,1.8809041, 0.037618092,-3.7241901
243.43495, 0.133,2.261, 2.3791764,1.1895882, 0.059479409,-5.8884614
225, 0.1596,2.2876, 1.8809041,1.8809041, 0.037618092,-3.7241901
135, 0.9044,2.2876, 1.8809041,1.8809041, 0.037618092,-3.7241901
315, 0.2926,2.3408, 1.8809041,1.8809041, 0.037618092,-3.7241901
45, 0.2926,2.5802, 1.8809041,1.8809041, 0.037618092,-3.7241901
0, 0.931,2.3142, 0,2.66, 0.8778,-1.7822
90, 0.8512,0, 0,2.66, 0.1596,-2.5004
183.36646, 0.8246,0.1862, 42.642758,0.15620057, 0.45298167,-44.845186
176.82017, 0.3724,0.1596, 2.6559045,0.14755025, 0.47953831,-47.474294
0, -0.1064,0, 0,2.66, 0.4256,-2.2344
0, 2.0482,0.2128, 0,2.66, 0.4522,-2.2078
181.39718, 2.5004,0.0266, 106.43322,0.064858753, 1.0909243,-108.00151
98.130102, 1.3832,0.0266, 16.175775,0.37618082, 0.18809041,-18.62095
1.2188752, 1.3832,1.8354, 122.3889,0.056582935, 1.2504829,-123.79781
180, 2.6334,2.0482, 0,2.66, 0.2128,-2.4472
153.43495, 1.7024,2.0482, 2.3791764,1.1895882, 0.059479409,-5.8884614
183.46823, 2.7132,2.261, 42.642968,0.08045843, 0.87941066,-87.061654
0, 1.9152,2.66, 0,2.66, 0.9576,-1.7024
180, 2.8994,2.3142, 0,2.66, 0.1064,-2.5536
213.69007, 2.793,2.3142, 3.6887563,0.73775127, 0.095907657,-9.4948587
180, 0.1862,1.197, 0,2.66, 0.1862,-2.4738
99.462322, 0,1.197, 13.55634,0.43730131, 0.1618015,-16.018347
0, -0.0798,0.3458, 0,2.66, 0.5054,-2.1546
0, 0.4256,0.3458, 0,2.66, 0.4256,-2.2344
183.01279, 0.8246,0.2128, 47.953629,0.13980649, 0.50609953,-50.103852
180, 0.3192,0.1862, 0,2.66, 0.3724,-2.2876
104.03624, -0.0798,0.2128, 8.386882,0.64514478, 0.10967462,-10.857786
0, 0.0266,0.5586, 0,2.66, 0.399,-2.261
0, 0.4256,0.5586, 0,2.66, 0.3458,-2.3142
0, 0.7714,0.5586, 0,2.66, 0.266,-2.394
182.38594, 1.0108,0.3724, 61.237698,0.11073724, 0.63895392,-63.256439
180, 0.3724,0.3458, 0,2.66, 0.399,-2.261
182.86241, 2.6068,1.3832, 50.609777,0.13283407, 0.53266457,-52.733794
90, 2.0482,1.3832, 0,2.66, 0.2128,-2.4472
0, 2.0748,1.8354, 0,2.66, 0.532,-2.128
180, 2.5802,1.6492, 0,2.66, 0.5054,-2.1546
168.69007, 2.4472,2.0482, 2.6083447,0.52166893, 0.13563393,-13.427758
153.43495, 1.7024,2.0482, 2.3791764,1.1895882, 0.059479409,-5.8884614
180, 1.3034,0.3458, 0,2.66, 0.3724,-2.2876
0, 1.3832,0.3724, 0,2.66, 1.1438,-1.5162
180, 2.5004,0.2394, 0,2.66, 0.5054,-2.1546
177.51045, 1.995,0.2394, 2.6574894,0.11554301, 0.61237799,-60.625421
90, 1.3566,0.2926, 0,2.66, 0.0532,-2.6068
2.8624052, 2.0748,0.5852, 50.609777,0.13283407, 0.53266457,-52.733794
270, 2.6334,0.5852, 0,2.66, 0.0532,-2.6068
180, 2.6068,0.5054, 0,2.66, 0.399,-2.261
161.56505, 2.2078,0.5054, 2.5234976,0.84116587, 0.084116595,-8.327542
135, 2.128,0.532, 1.8809041,1.8809041, 0.075236158,-3.6865719
270, 2.2344,0.4788, 0,2.66, 0.0532,-2.6068
0, 2.261,0.399, 0,2.66, 0.3192,-2.3408
90, 2.6068,0.4256, 0,2.66, 0.0532,-2.6068
180, 2.6068,0.5054, 0,2.66, 0.3724,-2.2876
270, 1.0108,1.064, 0,2.66, 0.1064,-2.5536
225, 1.0108,0.9576, 1.8809041,1.8809041, 0.11285425,-3.6489538
0, 0.9044,2.3142, 0,2.66, 0.8512,-1.8088
270, 1.7822,2.2876, 0,2.66, 0.0532,-2.6068
3.8140748, 0.665,1.7024, 37.334459,0.17694057, 0.39988567,-39.588683
206.56505, 0.7714,1.5694, 3.5687645,1.1895882, 0.059479409,-5.8884614
180, 0.7182,1.5428, 0,2.66, 0.0798,-2.5802
26.565051, 0.7182,1.5162, 3.5687645,1.1895882, 0.11895882,-5.828982
1.397181, 1.0906,0.3724, 106.43322,0.064858753, 1.0909243,-108.00151
135, 2.1014,0.532, 1.8809041,1.8809041, 0.075236158,-3.6865719
0, 1.5428,0.9842, 0,2.66, 0.2926,-2.3674
181.78991, 1.8088,0.9044, 82.50285,0.083084435, 0.85161552,-84.309937
36.869898, 0.9576,0.8778, 3.724,0.532, 0.133,-13.167
1.974934, 1.064,1.1438, 74.527429,0.091669665, 0.77185848,-76.41399
270, 1.862,1.1438, 0,2.66, 0.133,-2.527
0, 1.064,1.3566, 0,2.66, 0.5586,-2.1014
180, 1.995,1.1704, 0,2.66, 0.931,-1.729
90, 1.0374,1.197, 0,2.66, 0.1064,-2.5536
0, 0.665,1.729, 0,2.66, 0.5852,-2.0748
36.869898, 1.2502,1.729, 3.724,0.532, 0.133,-13.167
90, 1.3566,1.8088, 0,2.66, 0.0798,-2.5802
180, 2.0216,1.8354, 0,2.66, 0.6118,-2.0482
218.65981, 1.4098,1.8354, 3.7387998,0.4154222, 0.1703231,-16.861987
180, 1.2768,1.729, 0,2.66, 0.2128,-2.4472
;; (c)1997 STONE PRODUCTS CORPORATION
*SPLTFC, SPLIT FACE
;%TYPE=MODEL
194.03624, 2.3142,2.5802, 8.3868819,0.64514478, 0.10967462,-10.857786
0, 2.1812,2.5802, 0,2.66, 0.133,-2.527
0, 1.8088,2.3674, 0,2.66, 0.0266,-2.6334
0, 1.8088,2.3408, 0,2.66, 0.0798,-2.5802
0, 2.0216,2.7398, 0,2.66, 0.0532,-2.6068
0, 1.9418,2.7664, 0,2.66, 0.1064,-2.5536
206.56505, 2.4738,2.9526, 3.5687645,1.1895882, 0.059479409,-5.8884614
0, 2.394,2.9526, 0,2.66, 0.0798,-2.5802
116.56505, 1.6758,2.1812, 3.5687645,1.1895882, 0.059479409,-5.8884614
135, 1.729,2.128, 1.880904,1.880904, 0.075236158,-3.6865719
161.56505, 1.8088,2.1014, 2.5234976,0.84116587, 0.084116595,-8.327542
90, 0.8512,2.2344, 0,2.66, 0.0532,-2.6068
116.56505, 0.8778,2.1812, 3.5687645,1.1895882, 0.059479409,-5.8884614
153.43495, 0.931,2.1546, 2.3791763,1.1895882, 0.059479409,-5.8884614
164.0546, 1.3832,2.128, 10.961373,0.36537909, 0.19365093,-19.171441
161.56505, 1.463,2.1014, 2.5234976,0.84116587, 0.084116595,-8.327542
180, 1.5162,2.1014, 0,2.66, 0.0532,-2.6068
206.56505, 1.5694,2.128, 3.5687645,1.1895882, 0.059479409,-5.8884614
243.43495, 1.596,2.1812, 2.3791763,1.1895882, 0.059479409,-5.8884614
270, 1.596,2.261, 0,2.66, 0.0798,-2.5802
277.12502, 1.5694,2.4738, 18.806146,0.32993238, 0.21445606,-21.23115
71.565051, 2.2876,1.1172, 2.5234976,0.84116587, 0.16823316,-8.2434254
56.309932, 2.1812,0.9576, 5.9020101,0.73775127, 0.19181534,-9.3989511
21.801409, 2.0482,0.9044, 5.9273952,0.4939496, 0.14324539,-14.181293
9.4623222, 1.8886,0.8778, 13.556341,0.43730131, 0.1618015,-16.018347
341.56505, 1.729,0.931, 2.5234976,0.84116587, 0.16823316,-8.2434254
326.30993, 1.6492,0.9842, 5.9020101,0.73775127, 0.095907657,-9.4948587
315, 1.5694,1.064, 1.880904,1.880904, 0.11285425,-3.6489538
300.96376, 1.4896,1.197, 9.579911,0.45618625, 0.15510332,-15.355229
279.46232, 1.463,1.3566, 13.556341,0.43730131, 0.1618015,-16.018347
260.53768, 1.4896,1.5162, 2.6238078,0.43730131, 0.1618015,-16.018347
233.1301, 1.5694,1.6226, 9.576,0.532, 0.133,-13.167
206.56505, 1.729,1.7024, 3.5687645,1.1895882, 0.17843823,-5.7695026
180, 1.9152,1.7024, 0,2.66, 0.1862,-2.4738
161.56505, 2.0748,1.6492, 2.5234976,0.84116587, 0.16823316,-8.2434254
141.34019, 2.2078,1.5428, 13.293511,0.4154222, 0.1703231,-16.861987
126.8699, 2.2876,1.4364, 3.724,0.532, 0.133,-13.167
108.43495, 2.3408,1.2768, 5.888161,0.84116587, 0.16823316,-8.2434254
141.34019, 1.729,0.9044, 13.293511,0.4154222, 0.1703231,-16.861987
135, 1.862,0.7714, 1.880904,1.880904, 0.18809041,-3.5737177
123.69007, 1.9152,0.6916, 3.6887563,0.73775127, 0.095907657,-9.4948587
99.462322, 1.9418,0.532, 13.556341,0.43730131, 0.1618015,-16.018347
78.690068, 1.9152,0.399, 2.6083446,0.52166893, 0.13563393,-13.427758
30.963757, 1.7822,0.3192, 9.579911,0.45618625, 0.15510332,-15.355229
11.309932, 1.6492,0.2926, 10.955047,0.52166893, 0.13563393,-13.427758
0, 1.5694,0.2926, 0,2.66, 0.0798,-2.5802
345.96376, 1.463,0.3192, 2.5805791,0.64514478, 0.10967462,-10.857786
338.19859, 1.33,0.3724, 8.3971432,0.4939496, 0.14324539,-14.181293
315, 1.2768,0.4256, 1.880904,1.880904, 0.075236158,-3.6865719
296.56505, 1.2236,0.532, 3.5687645,1.1895882, 0.11895882,-5.828982
270, 1.2236,0.6384, 0,2.66, 0.1064,-2.5536
251.56505, 1.2502,0.7182, 2.5234976,0.84116587, 0.084116595,-8.327542
270, 1.2502,0.7714, 0,2.66, 0.0532,-2.6068
296.56505, 1.2236,0.8246, 3.5687645,1.1895882, 0.059479409,-5.8884614
270, 1.2236,0.9044, 0,2.66, 0.0798,-2.5802
243.43495, 1.2768,1.0108, 2.3791763,1.1895882, 0.11895882,-5.828982
206.56505, 1.3832,1.064, 3.5687645,1.1895882, 0.11895882,-5.828982
180, 1.4896,1.064, 0,2.66, 0.1064,-2.5536
153.43495, 1.596,1.0108, 2.3791763,1.1895882, 0.11895882,-5.828982
71.565051, 0.798,2.0748, 2.5234976,0.84116587, 0.084116595,-8.327542
45, 0.7448,2.0216, 1.880904,1.880904, 0.075236158,-3.6865719
71.565051, 0.7182,1.9418, 2.5234976,0.84116587, 0.084116595,-8.327542
71.565051, 0.6916,1.862, 2.5234976,0.84116587, 0.084116595,-8.327542
26.565051, 0.6384,1.8354, 3.5687645,1.1895882, 0.059479409,-5.8884614
333.43495, 0.5852,1.862, 2.3791763,1.1895882, 0.059479409,-5.8884614
306.8699, 0.5054,1.9684, 3.724,0.532, 0.133,-13.167
323.1301, 0.399,2.0482, 9.576,0.532, 0.133,-13.167
315, 0.3192,2.128, 1.880904,1.880904, 0.11285425,-3.6489538
315, 0.2394,2.2078, 1.880904,1.880904, 0.11285425,-3.6489538
303.69007, 0.1862,2.2876, 3.6887563,0.73775127, 0.095907657,-9.4948587
270, 0.1862,2.3408, 0,2.66, 0.0532,-2.6068
225, 0.2128,2.3674, 1.880904,1.880904, 0.037618092,-3.72419
180, 0.266,2.3674, 0,2.66, 0.0532,-2.6068
206.56505, 0.3192,2.394, 3.5687645,1.1895882, 0.059479409,-5.8884614
180, 0.3724,2.394, 0,2.66, 0.0532,-2.6068
161.56505, 0.4522,2.3674, 2.5234976,0.84116587, 0.084116595,-8.327542
180, 0.5586,2.3674, 0,2.66, 0.1064,-2.5536
198.43495, 0.6384,2.394, 5.888161,0.84116587, 0.084116595,-8.327542
206.56505, 0.6916,2.4206, 3.5687645,1.1895882, 0.059479409,-5.8884614
180, 0.7714,2.4206, 0,2.66, 0.0798,-2.5802
116.56505, 0.798,2.3674, 3.5687645,1.1895882, 0.059479409,-5.8884614
104.03624, 0.8246,2.261, 8.3868819,0.64514478, 0.10967462,-10.857786
90, 0.8246,2.1546, 0,2.66, 0.1064,-2.5536
116.56505, 2.0482,1.8354, 3.5687645,1.1895882, 0.11895882,-5.828982
90, 2.0482,1.7822, 0,2.66, 0.0532,-2.6068
26.565051, 1.995,1.7556, 3.5687645,1.1895882, 0.059479409,-5.8884614
11.309932, 1.862,1.729, 10.955047,0.52166893, 0.13563393,-13.427758
8.1301023, 1.6758,1.7024, 16.175775,0.37618082, 0.18809041,-18.62095
18.434949, 1.596,1.6758, 5.888161,0.84116587, 0.084116595,-8.327542
45, 1.5428,1.6226, 1.880904,1.880904, 0.075236158,-3.6865719
45, 1.463,1.5428, 1.880904,1.880904, 0.11285425,-3.6489538
11.309932, 1.33,1.5162, 10.955047,0.52166893, 0.13563393,-13.427758
0, 1.197,1.5162, 0,2.66, 0.133,-2.527
345.96376, 1.0906,1.5428, 2.5805791,0.64514478, 0.10967462,-10.857786
345.96376, 0.9842,1.5694, 2.5805791,0.64514478, 0.10967462,-10.857786
341.56505, 0.9044,1.596, 2.5234976,0.84116587, 0.084116595,-8.327542
326.30993, 0.8246,1.6492, 5.9020101,0.73775127, 0.095907657,-9.4948587
315, 0.7714,1.7024, 1.880904,1.880904, 0.075236158,-3.6865719
315, 0.7448,1.729, 1.880904,1.880904, 0.037618092,-3.72419
284.03624, 0.7182,1.8354, 8.3868819,0.64514478, 0.10967462,-10.857786
255.96376, 0.7448,1.9418, 2.5805791,0.64514478, 0.10967462,-10.857786
233.1301, 0.8246,2.0482, 9.576,0.532, 0.133,-13.167
206.56505, 0.931,2.1014, 3.5687645,1.1895882, 0.11895882,-5.828982
191.30993, 1.064,2.128, 10.955047,0.52166893, 0.13563393,-13.427758
180, 1.197,2.128, 0,2.66, 0.133,-2.527
161.56505, 1.3566,2.0748, 2.5234976,0.84116587, 0.16823316,-8.2434254
165.96376, 1.463,2.0482, 2.5805791,0.64514478, 0.10967462,-10.857786
180, 1.5694,2.0482, 0,2.66, 0.1064,-2.5536
198.43495, 1.6492,2.0748, 5.888161,0.84116587, 0.084116595,-8.327542
180, 1.7556,2.0748, 0,2.66, 0.1064,-2.5536
158.19859, 1.8886,2.0216, 8.3971432,0.4939496, 0.14324539,-14.181293
143.1301, 1.995,1.9418, 9.576,0.532, 0.133,-13.167
135, 3.059,2.0216, 1.880904,1.880904, 0.075236158,-3.6865719
135, 3.1388,1.9418, 1.880904,1.880904, 0.11285425,-3.6489538
135, 3.192,1.8886, 1.880904,1.880904, 0.075236158,-3.6865719
90, 3.192,1.8354, 0,2.66, 0.0532,-2.6068
45, 3.1654,1.8088, 1.880904,1.880904, 0.037618092,-3.72419
14.036243, 3.059,1.7822, 8.3868819,0.64514478, 0.10967462,-10.857786
0, 2.9792,1.7822, 0,2.66, 0.0798,-2.5802
0, 2.926,1.7822, 0,2.66, 0.0532,-2.6068
341.56505, 2.8462,1.8088, 2.5234976,0.84116587, 0.084116595,-8.327542
0, 2.8196,1.8088, 0,2.66, 0.0266,-2.6334
341.56505, 2.7398,1.8354, 2.5234976,0.84116587, 0.084116595,-8.327542
0, 2.6334,1.8354, 0,2.66, 0.1064,-2.5536
11.309932, 2.5004,1.8088, 10.955047,0.52166893, 0.13563393,-13.427758
33.690068, 2.4206,1.7556, 3.6887563,0.73775127, 0.095907657,-9.4948587
18.434949, 2.3408,1.729, 5.888161,0.84116587, 0.084116595,-8.327542
0, 2.2078,1.729, 0,2.66, 0.133,-2.527
341.56505, 2.128,1.7556, 2.5234976,0.84116587, 0.084116595,-8.327542
303.69007, 2.0748,1.8354, 3.6887563,0.73775127, 0.095907657,-9.4948587
288.43495, 2.0482,1.9152, 5.888161,0.84116587, 0.084116595,-8.327542
270, 2.0482,2.0216, 0,2.66, 0.1064,-2.5536
251.56505, 2.0748,2.1014, 2.5234976,0.84116587, 0.084116595,-8.327542
225, 2.1546,2.1812, 1.880904,1.880904, 0.11285425,-3.6489538
209.74488, 2.3408,2.2876, 15.506823,0.32993238, 0.21445606,-21.23115
220.60129, 2.527,2.4472, 3.7507276,0.28851751, 0.24523987,-24.278748
225, 2.5802,2.5004, 1.880904,1.880904, 0.075236158,-3.6865719
206.56505, 2.6334,2.527, 3.5687645,1.1895882, 0.059479409,-5.8884614
165.96376, 2.7398,2.5004, 2.5805791,0.64514478, 0.10967462,-10.857786
123.69007, 2.793,2.4206, 3.6887563,0.73775127, 0.095907657,-9.4948587
101.30993, 2.8196,2.2876, 10.955047,0.52166893, 0.13563393,-13.427758
108.43495, 2.8462,2.2078, 5.888161,0.84116587, 0.084116595,-8.327542
135, 2.8994,2.1546, 1.880904,1.880904, 0.075236158,-3.6865719
143.1301, 3.0058,2.0748, 9.576,0.532, 0.133,-13.167
45, 2.5004,2.5004, 1.880904,1.880904, 0.22570847,-3.5360996
38.659808, 2.3674,2.394, 3.7387999,0.4154222, 0.1703231,-16.861987
38.659808, 2.2344,2.2876, 3.7387999,0.4154222, 0.1703231,-16.861987
38.659808, 2.1014,2.1812, 3.7387999,0.4154222, 0.1703231,-16.861987
26.565051, 1.9418,2.1014, 3.5687645,1.1895882, 0.17843823,-5.7695026
0, 1.8088,2.1014, 0,2.66, 0.133,-2.527
281.30993, 1.6226,2.3674, 10.955047,0.52166893, 0.13563393,-13.427758
270, 1.6226,2.5536, 0,2.66, 0.1862,-2.4738
270, 1.6226,2.6866, 0,2.66, 0.133,-2.527
251.56505, 1.6758,2.8462, 2.5234976,0.84116587, 0.16823316,-8.2434254
225, 1.7556,2.926, 1.880904,1.880904, 0.11285425,-3.6489538
209.74488, 1.9418,3.0324, 15.506823,0.32993238, 0.21445606,-21.23115
201.80141, 2.0748,3.0856, 5.9273952,0.4939496, 0.14324539,-14.181293
191.30993, 2.2078,3.1122, 10.955047,0.52166893, 0.13563393,-13.427758
187.12502, 2.4206,3.1388, 18.806146,0.32993238, 0.21445606,-21.23115
180, 2.5536,3.1388, 0,2.66, 0.133,-2.527
158.19859, 2.6866,3.0856, 8.3971432,0.4939496, 0.14324539,-14.181293
135, 2.7664,3.0058, 1.880904,1.880904, 0.11285425,-3.6489538
104.03624, 2.793,2.8994, 8.3868819,0.64514478, 0.10967462,-10.857786
75.963757, 2.7664,2.793, 2.5805791,0.64514478, 0.10967462,-10.857786
51.340192, 2.66,2.66, 13.293511,0.4154222, 0.1703231,-16.861987
90, 1.5694,2.4738, 0,2.66, 0.1862,-2.4738
0, 1.0906,2.1812, 0,2.66, 0.1064,-2.5536
9.4623222, 0.931,2.1546, 13.556341,0.43730131, 0.1618015,-16.018347
278.1301, 0.8246,2.4738, 16.175775,0.37618082, 0.18809041,-18.62095
261.8699, 0.8512,2.66, 2.6332656,0.37618082, 0.18809041,-18.62095
270, 0.8512,2.7664, 0,2.66, 0.1064,-2.5536
296.56505, 0.8246,2.8196, 3.5687645,1.1895882, 0.059479409,-5.8884614
270, 0.8246,2.8728, 0,2.66, 0.0532,-2.6068
225, 0.8778,2.926, 1.880904,1.880904, 0.075236158,-3.6865719
201.80141, 1.0108,2.9792, 5.9273952,0.4939496, 0.14324539,-14.181293
188.1301, 1.197,3.0058, 16.175775,0.37618082, 0.18809041,-18.62095
171.8699, 1.3832,2.9792, 2.6332656,0.37618082, 0.18809041,-18.62095
153.43495, 1.5428,2.8994, 2.3791763,1.1895882, 0.17843823,-5.7695026
135, 1.596,2.8462, 1.880904,1.880904, 0.075236158,-3.6865719
90, 1.596,2.793, 0,2.66, 0.0532,-2.6068
78.690068, 1.5694,2.66, 2.6083446,0.52166893, 0.13563393,-13.427758
206.56505, 2.4738,0.532, 3.5687645,1.1895882, 0.059479409,-5.8884614
270, 2.4738,0.6118, 0,2.66, 0.0798,-2.5802
296.56505, 2.4472,0.665, 3.5687645,1.1895882, 0.059479409,-5.8884614
306.8699, 2.3674,0.7714, 3.724,0.532, 0.133,-13.167
296.56505, 2.3142,0.8778, 3.5687645,1.1895882, 0.11895882,-5.828982
341.56505, 2.2344,0.9044, 2.5234976,0.84116587, 0.084116595,-8.327542
0, 2.1546,0.9044, 0,2.66, 0.0798,-2.5802
26.565051, 2.0482,0.8512, 3.5687645,1.1895882, 0.11895882,-5.828982
45, 1.995,0.798, 1.880904,1.880904, 0.075236158,-3.6865719
63.434949, 1.9684,0.7448, 2.3791763,1.1895882, 0.059479409,-5.8884614
90, 1.9684,0.665, 0,2.66, 0.0798,-2.5802
101.30993, 1.995,0.532, 10.955047,0.52166893, 0.13563393,-13.427758
116.56505, 2.0216,0.4788, 3.5687645,1.1895882, 0.059479409,-5.8884614
153.43495, 2.0748,0.4522, 2.3791763,1.1895882, 0.059479409,-5.8884614
180, 2.1014,0.4522, 0,2.66, 0.0266,-2.6334
198.43495, 2.1812,0.4788, 5.888161,0.84116587, 0.084116595,-8.327542
188.1301, 2.3674,0.5054, 16.175775,0.37618082, 0.18809041,-18.62095
180, 2.4206,0.5054, 0,2.66, 0.0532,-2.6068
45, 0.4256,0.6916, 1.880904,1.880904, 0.30094463,-3.4608634
45, 0.3458,0.6118, 1.880904,1.880904, 0.11285425,-3.6489538
45, 0.266,0.532, 1.880904,1.880904, 0.11285425,-3.6489538
33.690068, 0.1862,0.4788, 3.6887563,0.73775127, 0.095907657,-9.4948587
26.565051, 0.133,0.4522, 3.5687645,1.1895882, 0.059479409,-5.8884614
0, 0.0798,0.4522, 0,2.66, 0.0532,-2.6068
333.43495, 0.0266,0.4788, 2.3791763,1.1895882, 0.059479409,-5.8884614
323.1301, -0.0798,0.5586, 9.576,0.532, 0.133,-13.167
308.65981, -0.1862,0.6916, 3.7387999,0.4154222, 0.1703231,-16.861987
303.69007, -0.2926,0.8512, 3.6887563,0.73775127, 0.19181534,-9.3989511
288.43495, -0.3458,1.0108, 5.888161,0.84116587, 0.16823316,-8.2434254
270, -0.3458,1.1172, 0,2.66, 0.1064,-2.5536
243.43495, -0.2926,1.2236, 2.3791763,1.1895882, 0.11895882,-5.828982
216.8699, -0.1862,1.3034, 3.724,0.532, 0.133,-13.167
188.1301, 0,1.33, 16.175775,0.37618082, 0.18809041,-18.62095
171.8699, 0.1862,1.3034, 2.6332656,0.37618082, 0.18809041,-18.62095
161.56505, 0.3458,1.2502, 2.5234976,0.84116587, 0.16823316,-8.2434254
158.19859, 0.4788,1.197, 8.3971432,0.4939496, 0.14324539,-14.181293
149.03624, 0.6118,1.1172, 5.9304211,0.45618625, 0.15510332,-15.355229
135, 0.665,1.064, 1.880904,1.880904, 0.075236158,-3.6865719
135, 0.6916,1.0374, 1.880904,1.880904, 0.037618092,-3.72419
90, 0.6916,0.9842, 0,2.66, 0.0532,-2.6068
56.309932, 0.6384,0.9044, 5.9020101,0.73775127, 0.095907657,-9.4948587
71.565051, 0.1596,0.2128, 2.5234976,0.84116587, 0.084116595,-8.327542
78.690068, 0.133,0.0798, 2.6083446,0.52166893, 0.13563393,-13.427758
90, 0.133,0, 0,2.66, 0.0798,-2.5802
104.03624, 0.1596,-0.1064, 8.3868819,0.64514478, 0.10967462,-10.857786
116.56505, 0.1862,-0.1596, 3.5687645,1.1895882, 0.059479409,-5.8884614
108.43495, 0.2128,-0.2394, 5.888161,0.84116587, 0.084116595,-8.327542
180, 0.266,-0.2394, 0,2.66, 0.0532,-2.6068
206.56505, 0.3192,-0.2128, 3.5687645,1.1895882, 0.059479409,-5.8884614
180, 0.3724,-0.2128, 0,2.66, 0.0532,-2.6068
161.56505, 0.4522,-0.2394, 2.5234976,0.84116587, 0.084116595,-8.327542
180, 0.5586,-0.2394, 0,2.66, 0.1064,-2.5536
213.69007, 0.6384,-0.1862, 3.6887563,0.73775127, 0.095907657,-9.4948587
216.8699, 0.7448,-0.1064, 3.724,0.532, 0.133,-13.167
236.30993, 0.798,-0.0266, 5.9020101,0.73775127, 0.095907657,-9.4948587
270, 0.798,0.0798, 0,2.66, 0.1064,-2.5536
279.46232, 0.7714,0.2394, 13.556341,0.43730131, 0.1618015,-16.018347
270, 0.7714,0.2926, 0,2.66, 0.0532,-2.6068
284.03624, 0.7448,0.399, 8.3868819,0.64514478, 0.10967462,-10.857786
296.56505, 0.6916,0.5054, 3.5687645,1.1895882, 0.11895882,-5.828982
315, 0.6384,0.5586, 1.880904,1.880904, 0.075236158,-3.6865719
348.69007, 0.5054,0.5852, 2.6083446,0.52166893, 0.13563393,-13.427758
0, 0.399,0.5852, 0,2.66, 0.1064,-2.5536
26.565051, 0.3458,0.5586, 3.5687645,1.1895882, 0.059479409,-5.8884614
45, 0.266,0.4788, 1.880904,1.880904, 0.11285425,-3.6489538
63.434949, 0.2128,0.3724, 2.3791763,1.1895882, 0.11895882,-5.828982
71.565051, 0.1862,0.2926, 2.5234976,0.84116587, 0.084116595,-8.327542
90, 1.4364,1.1704, 0,2.66, 0.0532,-2.6068
63.434949, 1.4098,1.1172, 2.3791763,1.1895882, 0.059479409,-5.8884614
33.690068, 1.33,1.064, 3.6887563,0.73775127, 0.095907657,-9.4948587
18.434949, 1.1704,1.0108, 5.888161,0.84116587, 0.16823316,-8.2434254
0, 1.064,1.0108, 0,2.66, 0.1064,-2.5536
348.69007, 0.931,1.0374, 2.6083446,0.52166893, 0.13563393,-13.427758
341.56505, 0.8512,1.064, 2.5234976,0.84116587, 0.084116595,-8.327542
303.69007, 0.798,1.1438, 3.6887563,0.73775127, 0.095907657,-9.4948587
270, 0.798,1.2502, 0,2.66, 0.1064,-2.5536
270, 0.798,1.3832, 0,2.66, 0.133,-2.527
243.43495, 0.8512,1.4896, 2.3791763,1.1895882, 0.11895882,-5.828982
225, 0.8778,1.5162, 1.880904,1.880904, 0.037618092,-3.72419
194.03624, 0.9842,1.5428, 8.3868819,0.64514478, 0.10967462,-10.857786
165.96376, 1.0906,1.5162, 2.5805791,0.64514478, 0.10967462,-10.857786
161.56505, 1.1704,1.4896, 2.5234976,0.84116587, 0.084116595,-8.327542
180, 1.2502,1.4896, 0,2.66, 0.0798,-2.5802
180, 1.3566,1.4896, 0,2.66, 0.1064,-2.5536
135, 1.4098,1.4364, 1.880904,1.880904, 0.075236158,-3.6865719
90, 1.4098,1.3566, 0,2.66, 0.0798,-2.5802
90, 1.4098,1.3566, 0,2.66, 0.0798,-2.5802
101.30993, 1.4364,1.2236, 10.955047,0.52166893, 0.13563393,-13.427758
90, 0.7448,1.33, 0,2.66, 0.0532,-2.6068
90, 0.7448,1.2768, 0,2.66, 0.0532,-2.6068
45, 0.6916,1.2236, 1.880904,1.880904, 0.075236158,-3.6865719
26.565051, 0.6384,1.197, 3.5687645,1.1895882, 0.059479409,-5.8884614
0, 0.5852,1.197, 0,2.66, 0.0532,-2.6068
333.43495, 0.4788,1.2502, 2.3791763,1.1895882, 0.11895882,-5.828982
338.19859, 0.3458,1.3034, 8.3971432,0.4939496, 0.14324539,-14.181293
341.56505, 0.1862,1.3566, 2.5234976,0.84116587, 0.16823316,-8.2434254
353.65981, -0.0532,1.3832, 2.6437307,0.29374787, 0.24087324,-23.846451
288.43495, -0.3458,1.5428, 5.888161,0.84116587, 0.084116595,-8.327542
270, -0.3458,1.596, 0,2.66, 0.0532,-2.6068
236.30993, -0.2926,1.6758, 5.9020101,0.73775127, 0.095907657,-9.4948587
206.56505, -0.2394,1.7024, 3.5687645,1.1895882, 0.059479409,-5.8884614
206.56505, -0.1862,1.729, 3.5687645,1.1895882, 0.059479409,-5.8884614
206.56505, -0.133,1.7556, 3.5687645,1.1895882, 0.059479409,-5.8884614
198.43495, -0.0532,1.7822, 5.888161,0.84116587, 0.084116595,-8.327542
180, 0.0532,1.7822, 0,2.66, 0.1064,-2.5536
165.96376, 0.1596,1.7556, 2.5805791,0.64514478, 0.10967462,-10.857786
180, 0.1862,1.7556, 0,2.66, 0.0266,-2.6334
153.43495, 0.2394,1.729, 2.3791763,1.1895882, 0.059479409,-5.8884614
180, 0.3458,1.729, 0,2.66, 0.1064,-2.5536
180, 0.4256,1.729, 0,2.66, 0.0798,-2.5802
198.43495, 0.5054,1.7556, 5.888161,0.84116587, 0.084116595,-8.327542
180, 0.6118,1.7556, 0,2.66, 0.1064,-2.5536
161.56505, 0.6916,1.729, 2.5234976,0.84116587, 0.084116595,-8.327542
153.43495, 0.7448,1.7024, 2.3791763,1.1895882, 0.059479409,-5.8884614
135, 0.7714,1.6758, 1.880904,1.880904, 0.037618092,-3.72419
123.69007, 0.8246,1.596, 3.6887563,0.73775127, 0.095907657,-9.4948587
90, 0.8246,1.5694, 0,2.66, 0.0266,-2.6334
63.434949, 0.798,1.5162, 2.3791763,1.1895882, 0.059479409,-5.8884614
68.198591, 0.7448,1.3832, 8.3971432,0.4939496, 0.14324539,-14.181293
0, -0.1596,1.3832, 0,2.66, 0.1064,-2.5536
345.96376, -0.266,1.4098, 2.5805791,0.64514478, 0.10967462,-10.857786
315, -0.3192,1.463, 1.880904,1.880904, 0.075236158,-3.6865719
0, 0.532,0.3724, 0,2.66, 0.0798,-2.5802
0, 0.5054,0.399, 0,2.66, 0.0266,-2.6334
303.69007, 1.1172,0.9044, 3.6887563,0.73775127, 0.095907657,-9.4948587
326.30993, 1.0374,0.9576, 5.9020101,0.73775127, 0.095907657,-9.4948587
341.56505, 0.9576,0.9842, 2.5234976,0.84116587, 0.084116595,-8.327542
0, 0.8246,0.9842, 0,2.66, 0.133,-2.527
18.434949, 0.7448,0.9576, 5.888161,0.84116587, 0.084116595,-8.327542
33.690068, 0.665,0.9044, 3.6887563,0.73775127, 0.095907657,-9.4948587
225, 1.1438,0.4788, 1.880904,1.880904, 0.075236158,-3.6865719
243.43495, 1.1704,0.532, 2.3791763,1.1895882, 0.059479409,-5.8884614
255.96376, 1.197,0.6384, 2.5805791,0.64514478, 0.10967462,-10.857786
270, 1.197,0.7448, 0,2.66, 0.1064,-2.5536
288.43495, 1.1704,0.8246, 5.888161,0.84116587, 0.084116595,-8.327542
45, 1.0906,0.4256, 1.880904,1.880904, 0.075236158,-3.6865719
26.565051, 1.0374,0.399, 3.5687645,1.1895882, 0.059479409,-5.8884614
11.309932, 0.9044,0.3724, 10.955047,0.52166893, 0.13563393,-13.427758
0, 0.8246,0.3724, 0,2.66, 0.0798,-2.5802
333.43495, 0.7714,0.399, 2.3791763,1.1895882, 0.059479409,-5.8884614
296.56505, 0.7448,0.4522, 3.5687645,1.1895882, 0.059479409,-5.8884614
296.56505, 0.7182,0.5054, 3.5687645,1.1895882, 0.059479409,-5.8884614
315, 0.665,0.5586, 1.880904,1.880904, 0.075236158,-3.6865719
323.1301, 0.5586,0.6384, 9.576,0.532, 0.133,-13.167
288.43495, 0.532,0.7182, 5.888161,0.84116587, 0.084116595,-8.327542
251.56505, 0.5586,0.798, 2.5234976,0.84116587, 0.084116595,-8.327542
225, 0.665,0.9044, 1.880904,1.880904, 0.15047232,-3.6113358
18.434949, 0.266,0.133, 5.888161,0.84116587, 0.084116595,-8.327542
213.69007, 0.3458,0.1596, 3.6887563,0.73775127, 0.095907657,-9.4948587
18.434949, 0.3192,0.1064, 5.888161,0.84116587, 0.084116595,-8.327542
225, 0.399,0.133, 1.880904,1.880904, 0.075236158,-3.6865719
18.434949, 0.4788,-0.0798, 5.888161,0.84116587, 0.084116595,-8.327542
225, 0.5586,-0.0266, 1.880904,1.880904, 0.037618092,-3.72419
0, -0.1064,1.6492, 0,2.66, 0.0798,-2.5802
198.43495, -0.0266,1.6492, 5.888161,0.84116587, 0.084116595,-8.327542
0, -0.0266,1.596, 0,2.66, 0.0532,-2.6068
225, 0.0266,1.596, 1.880904,1.880904, 0.075236158,-3.6865719
225, -0.1064,1.5162, 1.880904,1.880904, 0.037618092,-3.72419
0, -0.133,1.4896, 0,2.66, 0.0266,-2.6334
18.434949, 0.4788,1.5428, 5.888161,0.84116587, 0.084116595,-8.327542
225, 0.5586,1.5694, 1.880904,1.880904, 0.075236158,-3.6865719
26.565051, 0.532,1.4896, 3.5687645,1.1895882, 0.059479409,-5.8884614
243.43495, 0.5852,1.5162, 2.3791763,1.1895882, 0.059479409,-5.8884614
11.309932, 1.0906,1.8886, 10.955047,0.52166893, 0.13563393,-13.427758
213.69007, 1.2236,1.9152, 3.6887563,0.73775127, 0.095907657,-9.4948587
9.4623222, 1.2236,1.8354, 13.556341,0.43730131, 0.1618015,-16.018347
198.43495, 1.3832,1.862, 5.888161,0.84116587, 0.084116595,-8.327542
11.309932, 1.4098,1.8088, 10.955047,0.52166893, 0.13563393,-13.427758
14.036243, 1.4364,0.7448, 8.3868819,0.64514478, 0.10967462,-10.857786
206.56505, 1.5428,0.7714, 3.5687645,1.1895882, 0.11895882,-5.828982
0, 1.5428,0.7182, 0,2.66, 0.0798,-2.5802
0, 1.5162,0.6384, 0,2.66, 0.0532,-2.6068
0, 1.5428,0.6118, 0,2.66, 0.0532,-2.6068
;; (c)1997 STONE PRODUCTS CORPORATION
*SPLTQRRD, SPLIT QUARRIED
;%TYPE=MODEL
260.53768, -0.65702,2.2477, 3.4109502,0.56849171, 0.21034194,-20.823851
315, -0.6916,2.28228, 2.4451752,2.4451752, 0.04890352,-4.841447
315, 0.72618,0.3458, 2.4451752,2.4451752, 0.04890352,-4.841447
333.43495, 0.65702,0.38038, 3.0929292,1.5464646, 0.077323231,-7.6549998
315, 0.58786,0.44954, 2.4451752,2.4451752, 0.097807006,-4.7925435
303.69007, 0.5187,0.55328, 4.7953832,0.95907665, 0.12467995,-12.343316
315, 0.48412,0.58786, 2.4451752,2.4451752, 0.04890352,-4.841447
0, 0.44954,0.58786, 0,3.458, 0.03458,-3.42342
296.56505, 1.34862,0.3458, 4.6393939,1.5464646, 0.077323231,-7.6549998
288.43495, 1.31404,0.44954, 7.6546093,1.0935156, 0.10935157,-10.825805
315, 1.27946,0.48412, 2.4451752,2.4451752, 0.04890352,-4.841447
0, 1.24488,0.48412, 0,3.458, 0.03458,-3.42342
26.565051, 1.10656,0.41496, 4.6393939,1.5464646, 0.15464646,-7.5776766
225, -1.97106,2.9393, 2.4451752,2.4451752, 0.04890352,-4.841447
180, -1.9019,2.9393, 0,3.458, 0.06916,-3.38884
135, -1.83274,2.87014, 2.4451752,2.4451752, 0.097807006,-4.7925435
135, -1.76358,2.80098, 2.4451752,2.4451752, 0.097807006,-4.7925435
56.309932, -1.34862,2.17854, 7.6726131,0.95907665, 0.12467995,-12.343316
90, -1.34862,2.10938, 0,3.458, 0.06916,-3.38884
63.434949, -1.3832,2.04022, 3.0929292,1.5464646, 0.077323231,-7.6549998
18.434949, -1.48694,2.00564, 7.6546093,1.0935156, 0.10935157,-10.825805
281.30993, -1.52152,2.17854, 14.241562,0.67816961, 0.17632411,-17.456085
288.43495, -1.5561,2.28228, 7.6546093,1.0935156, 0.10935157,-10.825805
315, -1.65984,2.38602, 2.4451752,2.4451752, 0.14671053,-4.74364
315, -1.79816,2.52434, 2.4451752,2.4451752, 0.19561401,-4.6947365
323.1301, -1.93648,2.62808, 12.4488,0.6916, 0.1729,-17.1171
315, -2.00564,2.69724, 2.4451752,2.4451752, 0.097807006,-4.7925435
270, -2.00564,2.7664, 0,3.458, 0.06916,-3.38884
315, -2.0748,2.83556, 2.4451752,2.4451752, 0.097807006,-4.7925435
225, -2.00564,2.90472, 2.4451752,2.4451752, 0.097807006,-4.7925435
270, -1.27946,2.38602, 0,3.458, 0.10374,-3.35426
270, -1.27946,2.48976, 0,3.458, 0.10374,-3.35426
315, -1.34862,2.55892, 2.4451752,2.4451752, 0.097807006,-4.7925435
315, -1.41778,2.62808, 2.4451752,2.4451752, 0.097807006,-4.7925435
315, -1.45236,2.66266, 2.4451752,2.4451752, 0.04890352,-4.841447
341.56505, -1.5561,2.69724, 3.2805469,1.0935156, 0.10935157,-10.825805
341.56505, -1.65984,2.73182, 3.2805469,1.0935156, 0.10935157,-10.825805
326.30993, -1.76358,2.80098, 7.6726131,0.95907665, 0.12467995,-12.343316
308.65981, -1.34862,2.5935, 4.8604398,0.54004886, 0.22142003,-21.920584
315, -1.41778,2.66266, 2.4451752,2.4451752, 0.097807006,-4.7925435
338.19859, -1.59068,2.73182, 10.916286,0.64213449, 0.18621901,-18.435681
326.30993, -1.69442,2.80098, 7.6726131,0.95907665, 0.12467995,-12.343316
326.30993, -1.79816,2.87014, 7.6726131,0.95907665, 0.12467995,-12.343316
161.56505, -0.55328,1.31404, 3.2805469,1.0935156, 0.10935157,-10.825805
167.47119, -0.24206,1.24488, 17.62842,0.37507277, 0.31881183,-31.562373
180, -0.06916,1.24488, 0,3.458, 0.1729,-3.2851
165.96376, 0.20748,1.17572, 3.3547528,0.83868821, 0.28515398,-13.972545
171.8699, 0.44954,1.14114, 3.4232453,0.48903506, 0.24451753,-24.207235
180, 0.76076,1.14114, 0,3.458, 0.31122,-3.14678
180, 0.82992,1.14114, 0,3.458, 0.06916,-3.38884
243.43495, 0.8645,1.2103, 3.0929292,1.5464646, 0.077323231,-7.6549998
270, 0.8645,1.27946, 0,3.458, 0.06916,-3.38884
270, 0.8645,1.34862, 0,3.458, 0.06916,-3.38884
303.69007, 0.79534,1.45236, 4.7953832,0.95907665, 0.12467995,-12.343316
321.34019, 0.62244,1.59068, 17.281564,0.54004886, 0.22142003,-21.920584
321.34019, 0.44954,1.729, 17.281564,0.54004886, 0.22142003,-21.920584
315, 0.31122,1.86732, 2.4451752,2.4451752, 0.19561401,-4.6947365
306.8699, 0.20748,2.00564, 4.8412,0.6916, 0.1729,-17.1171
333.43495, 0.13832,2.04022, 3.0929292,1.5464646, 0.077323231,-7.6549998
350.53768, -0.06916,2.0748, 3.4109502,0.56849171, 0.21034194,-20.823851
341.56505, -0.38038,2.17854, 3.2805469,1.0935156, 0.32805469,-10.607101
338.19859, -0.55328,2.2477, 10.916286,0.64213449, 0.18621901,-18.435681
0, -0.58786,2.2477, 0,3.458, 0.03458,-3.42342
45, -0.62244,2.21312, 2.4451752,2.4451752, 0.04890352,-4.841447
80.537678, -0.6916,1.79816, 3.4109502,0.56849171, 0.42068385,-20.613509
84.805571, -0.72618,1.41778, 3.4437987,0.31307262, 0.38194858,-37.81291
90, -0.72618,1.3832, 0,3.458, 0.03458,-3.42342
153.43495, -0.65702,1.34862, 3.0929292,1.5464646, 0.077323231,-7.6549998
0, -0.82992,1.31404, 0,3.458, 0.06916,-3.38884
326.30993, -0.93366,1.3832, 7.6726131,0.95907665, 0.12467995,-12.343316
308.65981, -1.07198,1.5561, 4.8604398,0.54004886, 0.22142003,-21.920584
296.56505, -1.17572,1.76358, 4.6393939,1.5464646, 0.23196969,-7.5003534
296.56505, -1.27946,1.97106, 4.6393939,1.5464646, 0.23196969,-7.5003534
284.03624, -1.31404,2.10938, 10.902947,0.83868821, 0.14257701,-14.115122
270, -1.31404,2.21312, 0,3.458, 0.10374,-3.35426
225, -1.27946,2.2477, 2.4451752,2.4451752, 0.04890352,-4.841447
195.9454, -1.0374,2.31686, 10.924835,0.47499282, 0.2517462,-24.922874
194.03624, -0.89908,2.35144, 10.902947,0.83868821, 0.14257701,-14.115122
165.96376, -0.76076,2.31686, 3.3547528,0.83868821, 0.14257701,-14.115122
153.43495, -0.6916,2.28228, 3.0929292,1.5464646, 0.077323231,-7.6549998
84.805571, -0.72618,1.65984, 3.4437987,0.31307262, 0.38194858,-37.81291
84.289407, -0.76076,1.31404, 3.4408386,0.34408386, 0.34752471,-34.404945
90, -0.72618,1.27946, 0,3.458, 0.06916,-3.38884
108.43495, -0.6916,1.17572, 7.6546093,1.0935156, 0.10935157,-10.825805
111.80141, -0.62244,1.00282, 7.7056138,0.64213449, 0.18621901,-18.435681
153.43495, -0.55328,0.96824, 3.0929292,1.5464646, 0.077323231,-7.6549998
180, -0.44954,0.96824, 0,3.458, 0.10374,-3.35426
161.56505, -0.3458,0.93366, 3.2805469,1.0935156, 0.10935157,-10.825805
149.03624, -0.1729,0.82992, 7.7095474,0.59304212, 0.20163432,-19.961797
143.1301, -0.03458,0.72618, 12.4488,0.6916, 0.1729,-17.1171
168.69007, 0.13832,0.6916, 3.390848,0.67816961, 0.17632411,-17.456085
168.69007, 0.31122,0.65702, 3.390848,0.67816961, 0.17632411,-17.456085
180, 0.41496,0.65702, 0,3.458, 0.10374,-3.35426
281.30993, 0.38038,0.82992, 14.241562,0.67816961, 0.17632411,-17.456085
284.03624, 0.3458,0.96824, 10.902947,0.83868821, 0.14257701,-14.115122
288.43495, 0.31122,1.07198, 7.6546093,1.0935156, 0.10935157,-10.825805
326.30993, 0.20748,1.14114, 7.6726131,0.95907665, 0.12467995,-12.343316
341.56505, 0.10374,1.17572, 3.2805469,1.0935156, 0.10935157,-10.825805
348.69007, -0.06916,1.2103, 3.390848,0.67816961, 0.17632411,-17.456085
0, -0.20748,1.2103, 0,3.458, 0.13832,-3.31968
345.96376, -0.3458,1.24488, 3.3547528,0.83868821, 0.14257701,-14.115122
345.96376, -0.62244,1.31404, 3.3547528,0.83868821, 0.28515398,-13.972545
341.56505, -0.72618,1.34862, 3.2805469,1.0935156, 0.10935157,-10.825805
104.03624, 0.38038,0.93366, 10.902947,0.83868821, 0.14257701,-14.115122
104.03624, 0.41496,0.79534, 10.902947,0.83868821, 0.14257701,-14.115122
116.56505, 0.48412,0.65702, 4.6393939,1.5464646, 0.15464646,-7.5776766
126.8699, 0.58786,0.5187, 4.8412,0.6916, 0.1729,-17.1171
135, 0.6916,0.41496, 2.4451752,2.4451752, 0.14671053,-4.74364
161.56505, 0.79534,0.38038, 3.2805469,1.0935156, 0.10935157,-10.825805
180, 0.89908,0.38038, 0,3.458, 0.10374,-3.35426
194.03624, 1.0374,0.41496, 10.902947,0.83868821, 0.14257701,-14.115122
198.43495, 1.14114,0.44954, 7.6546093,1.0935156, 0.10935157,-10.825805
206.56505, 1.2103,0.48412, 4.6393939,1.5464646, 0.077323231,-7.6549998
270, 1.2103,0.5187, 0,3.458, 0.03458,-3.42342
333.43495, 1.14114,0.55328, 3.0929292,1.5464646, 0.077323231,-7.6549998
315, 1.07198,0.62244, 2.4451752,2.4451752, 0.097807006,-4.7925435
306.8699, 0.96824,0.76076, 4.8412,0.6916, 0.1729,-17.1171
296.56505, 0.8645,0.96824, 4.6393939,1.5464646, 0.23196969,-7.5003534
288.43495, 0.82992,1.07198, 7.6546093,1.0935156, 0.10935157,-10.825805
315, 0.79534,1.10656, 2.4451752,2.4451752, 0.04890352,-4.841447
0, 0.48412,1.10656, 0,3.458, 0.31122,-3.14678
14.036243, 0.3458,1.07198, 10.902947,0.83868821, 0.14257701,-14.115122
180, 1.34862,0.55328, 0,3.458, 0.10374,-3.35426
198.43495, 1.45236,0.58786, 7.6546093,1.0935156, 0.10935157,-10.825805
206.56505, 1.52152,0.62244, 4.6393939,1.5464646, 0.077323231,-7.6549998
260.53768, 1.5561,0.82992, 3.4109502,0.56849171, 0.21034194,-20.823851
270, 1.5561,1.0374, 0,3.458, 0.20748,-3.25052
278.1301, 1.52152,1.27946, 21.028507,0.48903506, 0.24451753,-24.207235
291.80141, 1.45236,1.45236, 7.7056138,0.64213449, 0.18621901,-18.435681
315, 1.3832,1.52152, 2.4451752,2.4451752, 0.097807006,-4.7925435
0, 1.34862,1.52152, 0,3.458, 0.03458,-3.42342
45, 1.31404,1.48694, 2.4451752,2.4451752, 0.04890352,-4.841447
36.869898, 1.17572,1.3832, 4.8412,0.6916, 0.1729,-17.1171
26.565051, 1.0374,1.31404, 4.6393939,1.5464646, 0.15464646,-7.5776766
14.036243, 0.89908,1.27946, 10.902947,0.83868821, 0.14257701,-14.115122
75.963757, 0.8645,1.14114, 3.3547528,0.83868821, 0.14257701,-14.115122
90, 0.8645,1.07198, 0,3.458, 0.06916,-3.38884
111.80141, 0.93366,0.89908, 7.7056138,0.64213449, 0.18621901,-18.435681
116.56505, 1.00282,0.76076, 4.6393939,1.5464646, 0.15464646,-7.5776766
123.69007, 1.07198,0.65702, 4.7953832,0.95907665, 0.12467995,-12.343316
135, 1.14114,0.58786, 2.4451752,2.4451752, 0.097807006,-4.7925435
161.56505, 1.24488,0.55328, 3.2805469,1.0935156, 0.10935157,-10.825805
116.56505, 0.65702,1.62526, 4.6393939,1.5464646, 0.077323231,-7.6549998
135, 0.76076,1.52152, 2.4451752,2.4451752, 0.14671053,-4.74364
135, 0.8645,1.41778, 2.4451752,2.4451752, 0.14671053,-4.74364
161.56505, 0.96824,1.3832, 3.2805469,1.0935156, 0.10935157,-10.825805
180, 1.07198,1.3832, 0,3.458, 0.10374,-3.35426
198.43495, 1.17572,1.41778, 7.6546093,1.0935156, 0.10935157,-10.825805
225, 1.24488,1.48694, 2.4451752,2.4451752, 0.097807006,-4.7925435
233.1301, 1.34862,1.62526, 12.4488,0.6916, 0.1729,-17.1171
251.56505, 1.3832,1.729, 3.2805469,1.0935156, 0.10935157,-10.825805
264.28941, 1.41778,2.0748, 3.4408386,0.34408386, 0.34752471,-34.404945
270, 1.41778,2.62808, 0,3.458, 0.55328,-2.90472
284.03624, 1.3832,2.7664, 10.902947,0.83868821, 0.14257701,-14.115122
315, 1.34862,2.80098, 2.4451752,2.4451752, 0.04890352,-4.841447
0, 1.31404,2.80098, 0,3.458, 0.03458,-3.42342
26.565051, 1.17572,2.73182, 4.6393939,1.5464646, 0.15464646,-7.5776766
33.690068, 1.07198,2.66266, 4.7953832,0.95907665, 0.12467995,-12.343316
53.130102, 0.96824,2.52434, 12.4488,0.6916, 0.1729,-17.1171
71.565051, 0.89908,2.31686, 3.2805469,1.0935156, 0.21870311,-10.716453
74.054604, 0.82992,2.0748, 14.249785,0.47499282, 0.2517462,-24.922874
63.434949, 0.76076,1.93648, 3.0929292,1.5464646, 0.15464646,-7.5776766
56.309932, 0.6916,1.83274, 7.6726131,0.95907665, 0.12467995,-12.343316
63.434949, 0.62244,1.69442, 3.0929292,1.5464646, 0.15464646,-7.5776766
260.53768, -0.79534,2.55892, 3.4109502,0.56849171, 0.21034194,-20.823851
249.44395, -0.6916,2.83556, 10.927664,0.4047283, 0.29545166,-29.249713
254.0546, -0.62244,3.07762, 14.249785,0.47499282, 0.2517462,-24.922874
260.53768, -0.58786,3.2851, 3.4109502,0.56849171, 0.21034194,-20.823851
225, -0.55328,3.31968, 2.4451752,2.4451752, 0.04890352,-4.841447
180, -0.5187,3.31968, 0,3.458, 0.03458,-3.42342
180, -0.38038,3.31968, 0,3.458, 0.13832,-3.31968
165.96376, -0.24206,3.2851, 3.3547528,0.83868821, 0.14257701,-14.115122
135, -0.20748,3.25052, 2.4451752,2.4451752, 0.04890352,-4.841447
108.43495, -0.1729,3.14678, 7.6546093,1.0935156, 0.10935157,-10.825805
135, -0.10374,3.07762, 2.4451752,2.4451752, 0.097807006,-4.7925435
116.56505, -0.06916,3.00846, 4.6393939,1.5464646, 0.077323231,-7.6549998
104.03624, -0.03458,2.87014, 10.902947,0.83868821, 0.14257701,-14.115122
113.19859, 0.06916,2.62808, 7.71898,0.45405763, 0.26335343,-26.07199
104.03624, 0.13832,2.35144, 10.902947,0.83868821, 0.28515398,-13.972545
101.30993, 0.1729,2.17854, 14.241562,0.67816961, 0.17632411,-17.456085
90, 0.1729,2.10938, 0,3.458, 0.06916,-3.38884
45, 0.13832,2.0748, 2.4451752,2.4451752, 0.04890352,-4.841447
0, 0.06916,2.0748, 0,3.458, 0.06916,-3.38884
345.96376, -0.06916,2.10938, 3.3547528,0.83868821, 0.14257701,-14.115122
345.96376, -0.20748,2.14396, 3.3547528,0.83868821, 0.14257701,-14.115122
339.44395, -0.48412,2.2477, 10.927664,0.4047283, 0.29545166,-29.249713
345.96376, -0.62244,2.28228, 3.3547528,0.83868821, 0.14257701,-14.115122
341.56505, -0.72618,2.31686, 3.2805469,1.0935156, 0.10935157,-10.825805
341.56505, -0.82992,2.35144, 3.2805469,1.0935156, 0.10935157,-10.825805
63.434949, -1.27946,1.59068, 3.0929292,1.5464646, 0.15464646,-7.5776766
75.963757, -1.31404,1.45236, 3.3547528,0.83868821, 0.14257701,-14.115122
90, -1.31404,1.31404, 0,3.458, 0.13832,-3.31968
90, -1.31404,1.17572, 0,3.458, 0.13832,-3.31968
153.43495, -1.10656,1.07198, 3.0929292,1.5464646, 0.23196969,-7.5003534
156.80141, -0.8645,0.96824, 18.616363,0.45405763, 0.26335343,-26.07199
161.56505, -0.76076,0.93366, 3.2805469,1.0935156, 0.10935157,-10.825805
161.56505, -0.65702,0.89908, 3.2805469,1.0935156, 0.10935157,-10.825805
180, -0.62244,0.89908, 0,3.458, 0.03458,-3.42342
288.43495, -0.65702,1.00282, 7.6546093,1.0935156, 0.10935157,-10.825805
296.56505, -0.6916,1.07198, 4.6393939,1.5464646, 0.077323231,-7.6549998
288.43495, -0.72618,1.17572, 7.6546093,1.0935156, 0.10935157,-10.825805
315, -0.76076,1.2103, 2.4451752,2.4451752, 0.04890352,-4.841447
333.43495, -0.82992,1.24488, 3.0929292,1.5464646, 0.077323231,-7.6549998
315, -0.93366,1.34862, 2.4451752,2.4451752, 0.14671053,-4.74364
315, -1.0374,1.45236, 2.4451752,2.4451752, 0.14671053,-4.74364
303.69007, -1.10656,1.5561, 4.7953832,0.95907665, 0.12467995,-12.343316
315, -1.17572,1.62526, 2.4451752,2.4451752, 0.097807006,-4.7925435
288.43495, -1.2103,1.729, 7.6546093,1.0935156, 0.10935157,-10.825805
171.8699, 1.69442,2.00564, 3.4232453,0.48903506, 0.24451753,-24.207235
180, 1.9019,2.00564, 0,3.458, 0.20748,-3.25052
284.03624, 1.86732,2.14396, 10.902947,0.83868821, 0.14257701,-14.115122
288.43495, 1.83274,2.2477, 7.6546093,1.0935156, 0.10935157,-10.825805
303.69007, 1.76358,2.35144, 4.7953832,0.95907665, 0.12467995,-12.343316
315, 1.62526,2.48976, 2.4451752,2.4451752, 0.19561401,-4.6947365
315, 1.52152,2.5935, 2.4451752,2.4451752, 0.14671053,-4.74364
333.43495, 1.45236,2.62808, 3.0929292,1.5464646, 0.077323231,-7.6549998
90, 1.45236,2.45518, 0,3.458, 0.1729,-3.2851
90, 1.45236,2.28228, 0,3.458, 0.1729,-3.2851
90, 1.45236,2.14396, 0,3.458, 0.13832,-3.31968
90, 1.45236,2.04022, 0,3.458, 0.10374,-3.35426
26.565051, 0.55328,1.76358, 4.6393939,1.5464646, 0.077323231,-7.6549998
0, 0.48412,1.76358, 0,3.458, 0.06916,-3.38884
323.1301, 0.3458,1.86732, 12.4488,0.6916, 0.1729,-17.1171
303.69007, 0.27664,1.97106, 4.7953832,0.95907665, 0.12467995,-12.343316
296.56505, 0.20748,2.10938, 4.6393939,1.5464646, 0.15464646,-7.5776766
279.46232, 0.1729,2.31686, 17.623243,0.56849171, 0.21034194,-20.823851
279.46232, 0.13832,2.52434, 17.623243,0.56849171, 0.21034194,-20.823851
270, 0.13832,2.69724, 0,3.458, 0.1729,-3.2851
243.43495, 0.1729,2.7664, 3.0929292,1.5464646, 0.077323231,-7.6549998
206.56505, 0.31122,2.83556, 4.6393939,1.5464646, 0.15464646,-7.5776766
218.65981, 0.48412,2.97388, 4.8604398,0.54004886, 0.22142003,-21.920584
213.69007, 0.58786,3.04304, 4.7953832,0.95907665, 0.12467995,-12.343316
180, 0.62244,3.04304, 0,3.458, 0.03458,-3.42342
126.8699, 0.72618,2.90472, 4.8412,0.6916, 0.1729,-17.1171
116.56505, 0.79534,2.7664, 4.6393939,1.5464646, 0.15464646,-7.5776766
108.43495, 0.8645,2.55892, 7.6546093,1.0935156, 0.21870311,-10.716453
104.03624, 0.89908,2.4206, 10.902947,0.83868821, 0.14257701,-14.115122
78.690068, 0.8645,2.2477, 3.390848,0.67816961, 0.17632411,-17.456085
63.434949, 0.79534,2.10938, 3.0929292,1.5464646, 0.15464646,-7.5776766
68.198591, 0.72618,1.93648, 10.916286,0.64213449, 0.18621901,-18.435681
53.130102, 0.62244,1.79816, 12.4488,0.6916, 0.1729,-17.1171
233.1301, 0.72618,1.93648, 12.4488,0.6916, 0.1729,-17.1171
243.43495, -0.1729,-0.06916, 3.0929292,1.5464646, 0.077323231,-7.6549998
198.43495, -0.06916,-0.03458, 7.6546093,1.0935156, 0.10935157,-10.825805
180, 0.06916,-0.03458, 0,3.458, 0.13832,-3.31968
146.30993, 0.1729,-0.10374, 7.6726131,0.95907665, 0.12467995,-12.343316
135, 0.24206,-0.1729, 2.4451752,2.4451752, 0.097807006,-4.7925435
111.80141, 0.31122,-0.3458, 7.7056138,0.64213449, 0.18621901,-18.435681
101.30993, 0.3458,-0.5187, 14.241562,0.67816961, 0.17632411,-17.456085
45, 0.31122,-0.55328, 2.4451752,2.4451752, 0.04890352,-4.841447
33.690068, 0.20748,-0.62244, 4.7953832,0.95907665, 0.12467995,-12.343316
26.565051, 0.13832,-0.65702, 4.6393939,1.5464646, 0.077323231,-7.6549998
0, 0.06916,-0.65702, 0,3.458, 0.06916,-3.38884
315, 0.03458,-0.62244, 2.4451752,2.4451752, 0.04890352,-4.841447
303.69007, -0.03458,-0.5187, 4.7953832,0.95907665, 0.12467995,-12.343316
281.30993, -0.06916,-0.3458, 14.241562,0.67816961, 0.17632411,-17.456085
303.69007, -0.13832,-0.24206, 4.7953832,0.95907665, 0.12467995,-12.343316
303.69007, -0.20748,-0.13832, 4.7953832,0.95907665, 0.12467995,-12.343316
90, 0.44954,0.3458, 0,3.458, 0.24206,-3.21594
78.690068, 0.41496,0.1729, 3.390848,0.67816961, 0.17632411,-17.456085
71.565051, 0.3458,-0.03458, 3.2805469,1.0935156, 0.21870311,-10.716453
63.434949, 0.27664,-0.1729, 3.0929292,1.5464646, 0.15464646,-7.5776766
90, 0.27664,-0.27664, 0,3.458, 0.10374,-3.35426
116.56505, 0.3458,-0.41496, 4.6393939,1.5464646, 0.15464646,-7.5776766
116.56505, 0.38038,-0.48412, 4.6393939,1.5464646, 0.077323231,-7.6549998
180, 0.44954,-0.48412, 0,3.458, 0.06916,-3.38884
213.69007, 0.55328,-0.41496, 4.7953832,0.95907665, 0.12467995,-12.343316
231.34019, 0.6916,-0.24206, 17.281564,0.54004886, 0.22142003,-21.920584
255.96376, 0.72618,-0.10374, 3.3547528,0.83868821, 0.14257701,-14.115122
263.65981, 0.76076,0.20748, 3.4368499,0.38187223, 0.31313521,-31.000387
270, 0.76076,0.31122, 0,3.458, 0.10374,-3.35426
56.309932, -0.79534,0.62244, 7.6726131,0.95907665, 0.12467995,-12.343316
90, -0.79534,0.48412, 0,3.458, 0.13832,-3.31968
104.03624, -0.76076,0.3458, 10.902947,0.83868821, 0.14257701,-14.115122
116.56505, -0.6916,0.20748, 4.6393939,1.5464646, 0.15464646,-7.5776766
135, -0.55328,0.06916, 2.4451752,2.4451752, 0.19561401,-4.6947365
161.56505, -0.44954,0.03458, 3.2805469,1.0935156, 0.10935157,-10.825805
135, -0.3458,-0.06916, 2.4451752,2.4451752, 0.14671053,-4.74364
153.43495, -0.27664,-0.10374, 3.0929292,1.5464646, 0.077323231,-7.6549998
180, -0.24206,-0.10374, 0,3.458, 0.03458,-3.42342
206.56505, -0.10374,-0.03458, 4.6393939,1.5464646, 0.15464646,-7.5776766
180, 0.03458,-0.03458, 0,3.458, 0.13832,-3.31968
180, 0.10374,-0.03458, 0,3.458, 0.06916,-3.38884
153.43495, 0.24206,-0.10374, 3.0929292,1.5464646, 0.15464646,-7.5776766
180, 0.27664,-0.10374, 0,3.458, 0.03458,-3.42342
243.43495, 0.3458,0.03458, 3.0929292,1.5464646, 0.15464646,-7.5776766
251.56505, 0.38038,0.13832, 3.2805469,1.0935156, 0.10935157,-10.825805
262.87498, 0.41496,0.41496, 3.4312969,0.4289121, 0.27879288,-27.600494
270, 0.41496,0.55328, 0,3.458, 0.13832,-3.31968
270, 0.41496,0.58786, 0,3.458, 0.03458,-3.42342
341.56505, 0.31122,0.62244, 3.2805469,1.0935156, 0.10935157,-10.825805
348.69007, 0.13832,0.65702, 3.390848,0.67816961, 0.17632411,-17.456085
348.69007, -0.03458,0.6916, 3.390848,0.67816961, 0.17632411,-17.456085
326.30993, -0.13832,0.76076, 7.6726131,0.95907665, 0.12467995,-12.343316
323.1301, -0.27664,0.8645, 12.4488,0.6916, 0.1729,-17.1171
333.43495, -0.3458,0.89908, 3.0929292,1.5464646, 0.077323231,-7.6549998
345.96376, -0.48412,0.93366, 3.3547528,0.83868821, 0.14257701,-14.115122
0, -0.55328,0.93366, 0,3.458, 0.06916,-3.38884
45, -0.58786,0.89908, 2.4451752,2.4451752, 0.04890352,-4.841447
45, -0.62244,0.8645, 2.4451752,2.4451752, 0.04890352,-4.841447
45, -0.65702,0.82992, 2.4451752,2.4451752, 0.04890352,-4.841447
56.309932, -0.72618,0.72618, 7.6726131,0.95907665, 0.12467995,-12.343316
90, 1.45236,1.83274, 0,3.458, 0.1729,-3.2851
74.054604, 1.3832,1.59068, 14.249785,0.47499282, 0.2517462,-24.922874
123.69007, 1.45236,1.48694, 4.7953832,0.95907665, 0.12467995,-12.343316
116.56505, 1.5561,1.27946, 4.6393939,1.5464646, 0.23196969,-7.5003534
101.30993, 1.59068,1.10656, 14.241562,0.67816961, 0.17632411,-17.456085
90, 1.59068,0.93366, 0,3.458, 0.1729,-3.2851
153.43495, 1.65984,0.89908, 3.0929292,1.5464646, 0.077323231,-7.6549998
180, 1.76358,0.89908, 0,3.458, 0.10374,-3.35426
201.80141, 1.93648,0.96824, 7.7056138,0.64213449, 0.18621901,-18.435681
225, 2.04022,1.07198, 2.4451752,2.4451752, 0.14671053,-4.74364
236.30993, 2.10938,1.17572, 7.6726131,0.95907665, 0.12467995,-12.343316
270, 2.10938,1.45236, 0,3.458, 0.27664,-3.18136
255.96376, 2.14396,1.59068, 3.3547528,0.83868821, 0.14257701,-14.115122
243.43495, 2.21312,1.729, 3.0929292,1.5464646, 0.15464646,-7.5776766
270, 2.21312,1.79816, 0,3.458, 0.06916,-3.38884
288.43495, 2.17854,1.9019, 7.6546093,1.0935156, 0.10935157,-10.825805
288.43495, 2.14396,2.00564, 7.6546093,1.0935156, 0.10935157,-10.825805
9.4623222, 1.93648,1.97106, 17.623243,0.56849171, 0.21034194,-20.823851
0, 1.79816,1.97106, 0,3.458, 0.13832,-3.31968
0, 1.62526,1.97106, 0,3.458, 0.1729,-3.2851
348.69007, 1.45236,2.00564, 3.390848,0.67816961, 0.17632411,-17.456085
206.56505, 1.27946,-0.65702, 4.6393939,1.5464646, 0.15464646,-7.5776766
213.69007, 1.3832,-0.58786, 4.7953832,0.95907665, 0.12467995,-12.343316
236.30993, 1.45236,-0.48412, 7.6726131,0.95907665, 0.12467995,-12.343316
249.44395, 1.5561,-0.20748, 10.927664,0.4047283, 0.29545166,-29.249713
270, 1.5561,-0.06916, 0,3.458, 0.13832,-3.31968
284.03624, 1.52152,0.06916, 10.902947,0.83868821, 0.14257701,-14.115122
303.69007, 1.3832,0.27664, 4.7953832,0.95907665, 0.24935994,-12.218636
18.434949, 0.89908,0.3458, 7.6546093,1.0935156, 0.21870311,-10.716453
26.565051, 0.82992,0.31122, 4.6393939,1.5464646, 0.077323231,-7.6549998
63.434949, 0.79534,0.24206, 3.0929292,1.5464646, 0.077323231,-7.6549998
82.874984, 0.76076,-0.03458, 3.4312969,0.4289121, 0.27879288,-27.600494
80.537678, 0.72618,-0.24206, 3.4109502,0.56849171, 0.21034194,-20.823851
75.963757, 0.6916,-0.38038, 3.3547528,0.83868821, 0.14257701,-14.115122
108.43495, 0.72618,-0.48412, 7.6546093,1.0935156, 0.10935157,-10.825805
108.43495, 0.76076,-0.58786, 7.6546093,1.0935156, 0.10935157,-10.825805
123.69007, 0.82992,-0.6916, 4.7953832,0.95907665, 0.12467995,-12.343316
116.56505, 0.89908,-0.82992, 4.6393939,1.5464646, 0.15464646,-7.5776766
180, 0.96824,-0.82992, 0,3.458, 0.06916,-3.38884
206.56505, 1.0374,-0.79534, 4.6393939,1.5464646, 0.077323231,-7.6549998
213.69007, 1.14114,-0.72618, 4.7953832,0.95907665, 0.12467995,-12.343316
194.03624, 2.00564,0.03458, 10.902947,0.83868821, 0.28515398,-13.972545
180, 2.17854,0.03458, 0,3.458, 0.1729,-3.2851
201.80141, 2.35144,0.10374, 7.7056138,0.64213449, 0.18621901,-18.435681
201.80141, 2.52434,0.1729, 7.7056138,0.64213449, 0.18621901,-18.435681
213.69007, 2.62808,0.24206, 4.7953832,0.95907665, 0.12467995,-12.343316
243.43495, 2.66266,0.31122, 3.0929292,1.5464646, 0.077323231,-7.6549998
270, 2.66266,0.38038, 0,3.458, 0.06916,-3.38884
284.03624, 2.62808,0.5187, 10.902947,0.83868821, 0.14257701,-14.115122
270, 2.62808,0.62244, 0,3.458, 0.10374,-3.35426
248.19859, 2.69724,0.79534, 10.916286,0.64213449, 0.18621901,-18.435681
270, 2.69724,0.8645, 0,3.458, 0.06916,-3.38884
315, 2.62808,0.93366, 2.4451752,2.4451752, 0.097807006,-4.7925435
345.96376, 2.48976,0.96824, 3.3547528,0.83868821, 0.14257701,-14.115122
338.19859, 2.31686,1.0374, 10.916286,0.64213449, 0.18621901,-18.435681
341.56505, 2.21312,1.07198, 3.2805469,1.0935156, 0.10935157,-10.825805
0, 2.10938,1.07198, 0,3.458, 0.10374,-3.35426
33.690068, 2.00564,1.00282, 4.7953832,0.95907665, 0.12467995,-12.343316
36.869898, 1.86732,0.89908, 4.8412,0.6916, 0.1729,-17.1171
18.434949, 1.65984,0.82992, 7.6546093,1.0935156, 0.21870311,-10.716453
45, 1.59068,0.76076, 2.4451752,2.4451752, 0.097807006,-4.7925435
71.565051, 1.5561,0.65702, 3.2805469,1.0935156, 0.10935157,-10.825805
45, 1.45236,0.55328, 2.4451752,2.4451752, 0.14671053,-4.74364
26.565051, 1.3832,0.5187, 4.6393939,1.5464646, 0.077323231,-7.6549998
90, 1.3832,0.41496, 0,3.458, 0.10374,-3.35426
90, 1.3832,0.3458, 0,3.458, 0.06916,-3.38884
116.56505, 1.45236,0.20748, 4.6393939,1.5464646, 0.15464646,-7.5776766
126.8699, 1.5561,0.06916, 4.8412,0.6916, 0.1729,-17.1171
116.56505, 1.59068,0, 4.6393939,1.5464646, 0.077323231,-7.6549998
161.56505, 1.69442,-0.03458, 3.2805469,1.0935156, 0.10935157,-10.825805
180, 1.729,-0.03458, 0,3.458, 0.03458,-3.42342
315, -1.86732,2.9393, 2.4451752,2.4451752, 0.097807006,-4.7925435
284.03624, -1.9019,3.07762, 10.902947,0.83868821, 0.14257701,-14.115122
258.69007, -1.86732,3.25052, 3.390848,0.67816961, 0.17632411,-17.456085
243.43495, -1.83274,3.31968, 3.0929292,1.5464646, 0.077323231,-7.6549998
225, -1.76358,3.38884, 2.4451752,2.4451752, 0.097807006,-4.7925435
189.46232, -1.5561,3.42342, 17.623243,0.56849171, 0.21034194,-20.823851
198.43495, -1.45236,3.458, 7.6546093,1.0935156, 0.10935157,-10.825805
180, -1.31404,3.458, 0,3.458, 0.13832,-3.31968
198.43495, -1.10656,3.52716, 7.6546093,1.0935156, 0.21870311,-10.716453
201.80141, -0.93366,3.59632, 7.7056138,0.64213449, 0.18621901,-18.435681
180, -0.76076,3.59632, 0,3.458, 0.1729,-3.2851
165.96376, -0.62244,3.56174, 3.3547528,0.83868821, 0.14257701,-14.115122
135, -0.55328,3.49258, 2.4451752,2.4451752, 0.097807006,-4.7925435
90, -0.55328,3.38884, 0,3.458, 0.10374,-3.35426
75.963757, -0.58786,3.25052, 3.3547528,0.83868821, 0.14257701,-14.115122
75.963757, -0.62244,3.1122, 3.3547528,0.83868821, 0.14257701,-14.115122
75.963757, -0.65702,2.97388, 3.3547528,0.83868821, 0.14257701,-14.115122
71.565051, -0.6916,2.87014, 3.2805469,1.0935156, 0.10935157,-10.825805
74.054604, -0.76076,2.62808, 14.249785,0.47499282, 0.2517462,-24.922874
45, -0.82992,2.55892, 2.4451752,2.4451752, 0.097807006,-4.7925435
78.690068, -0.8645,2.38602, 3.390848,0.67816961, 0.17632411,-17.456085
26.565051, -0.93366,2.35144, 4.6393939,1.5464646, 0.077323231,-7.6549998
0, -1.07198,2.35144, 0,3.458, 0.13832,-3.31968
333.43495, -1.14114,2.38602, 3.0929292,1.5464646, 0.077323231,-7.6549998
333.43495, -1.2103,2.4206, 3.0929292,1.5464646, 0.077323231,-7.6549998
;; (c)1997 STONE PRODUCTS CORPORATION
*SL-DF, Southern Ledgestone with 20% Dressed Fieldstone
;%TYPE=MODEL
180, 0.7448,0.8512, 0,2.66, 0.2394,-2.4206
0, 0.5054,1.3034, 0,2.66, 0.1596,-2.5004
0, 0.4788,1.197, 0,2.66, 0.3192,-2.3408
0, 0.4522,1.4098, 0,2.66, 0.399,-2.261
172.87498, 0.7448,1.0374, 2.6394592,0.32993238, 0.21445606,-21.23115
174.80557, 0.798,1.0108, 2.6490759,0.24082509, 0.2938066,-29.086854
2.1210964, 0.5852,0.4788, 69.211065,0.098451016, 0.71869242,-71.15055
5.1944289, 0.4788,2.7132, 26.731584,0.24082509, 0.2938066,-29.086854
0, 0.6118,2.6334, 0,2.66, 0.2128,-2.4472
0, 0.5054,2.4738, 0,2.66, 0.133,-2.527
194.03624, 0.6384,2.2876, 8.3868819,0.64514478, 0.21934921,-10.748112
0, 0.532,1.9418, 0,2.66, 0.1862,-2.4738
185.71059, 0.8778,2.0748, 24.08587,0.2646799, 0.2673267,-26.465342
194.74356, 0.9842,2.394, 41.294083,0.13539044, 0.52260709,-51.738101
0, 0.6118,2.394, 0,2.66, 0.1064,-2.5536
1.7357046, -0.0266,2.0216, 85.161514,0.080569086, 0.87820294,-86.942091
180, 0.8512,1.729, 0,2.66, 0.4256,-2.2344
176.42367, 0.9044,1.4364, 2.6548199,0.16592625, 0.42643045,-42.216614
356.98721, 0.3458,1.729, 2.6563234,0.13980649, 0.50609953,-50.103852
351.8699, 0.5054,0.1064, 2.6332656,0.37618082, 0.18809041,-18.62095
3.1798301, 0.5586,0.3724, 45.297927,0.14755025, 0.47953831,-47.474294
180, 0.8512,0.3724, 0,2.66, 0.3724,-2.2876
277.12502, 0.4522,0.3458, 18.806146,0.32993238, 0.21445606,-21.23115
315, 0.4788,0.133, 1.880904,1.880904, 0.037618092,-3.72419
45, 0.5586,0.4522, 1.880904,1.880904, 0.037618092,-3.72419
315, 0.532,0.399, 1.880904,1.880904, 0.037618092,-3.72419
225, 0.4788,0.3724, 1.880904,1.880904, 0.037618092,-3.72419
243.43495, 0.5586,0.4522, 2.3791763,1.1895882, 0.059479409,-5.8884614
59.036243, 0.2926,2.5536, 5.9304211,0.45618625, 0.15510332,-15.355229
261.8699, 0.4256,2.7398, 2.6332656,0.37618082, 0.18809041,-18.62095
75.963757, 0.399,2.4738, 2.5805791,0.64514478, 0.21934921,-10.748112
59.036243, -0.0798,2.527, 5.9304211,0.45618625, 0.15510332,-15.355229
81.869898, -0.3458,2.4738, 2.6332656,0.37618082, 0.18809041,-18.62095
270, 0.3192,1.7024, 0,2.66, 0.0798,-2.5802
45, 0,1.33, 1.880904,1.880904, 0.037618092,-3.72419
135, 0.0266,1.2502, 1.880904,1.880904, 0.037618092,-3.72419
180, 0.3724,1.3566, 0,2.66, 0.399,-2.261
180, 0.3724,1.3566, 0,2.66, 0.3724,-2.2876
2.8624052, -0.1596,1.4364, 50.609777,0.13283407, 0.53266457,-52.733794
161.56505, -0.0266,1.3566, 2.5234976,0.84116587, 0.084116595,-8.327542
135, -0.1064,1.3832, 1.880904,1.880904, 0.075236158,-3.6865719
270, 0,1.33, 0,2.66, 0.0532,-2.6068
161.56505, 0.4788,1.197, 2.5234976,0.84116587, 0.084116595,-8.327542
45, 0.5054,1.1704, 1.880904,1.880904, 0.037618092,-3.72419
225, 0.5054,1.0374, 1.880904,1.880904, 0.037618092,-3.72419
104.03624, 0.532,1.064, 8.3868819,0.64514478, 0.10967462,-10.857786
315, 0.4788,0.8778, 1.880904,1.880904, 0.037618092,-3.72419
270, 0.4788,1.0108, 0,2.66, 0.133,-2.527
0, 0.0266,1.2502, 0,2.66, 0.3192,-2.3408
135, 0.3458,1.5162, 1.880904,1.880904, 0.037618092,-3.72419
270, 0.3192,1.6226, 0,2.66, 0.0798,-2.5802
45, 0.4256,1.3832, 1.880904,1.880904, 0.037618092,-3.72419
71.565051, 0.399,1.3034, 2.5234976,0.84116587, 0.084116595,-8.327542
270, 0.399,1.4364, 0,2.66, 0.0532,-2.6068
225, 0.4522,1.4098, 1.880904,1.880904, 0.037618092,-3.72419
45, 0.3724,1.3566, 1.880904,1.880904, 0.037618092,-3.72419
135, 0.399,1.4364, 1.880904,1.880904, 0.037618092,-3.72419
315, 0.3458,1.3566, 1.880904,1.880904, 0.037618092,-3.72419
225, 0.3724,1.2768, 1.880904,1.880904, 0.037618092,-3.72419
90, 0.399,1.2236, 0,2.66, 0.0798,-2.5802
90, 0.3724,1.2768, 0,2.66, 0.0532,-2.6068
180, 0.4256,1.5162, 0,2.66, 0.0798,-2.5802
135, 0.4788,1.463, 1.880904,1.880904, 0.075236158,-3.6865719
180, 0.1064,2.2078, 0,2.66, 0.399,-2.261
180, 0.0798,1.7556, 0,2.66, 0.4256,-2.2344
0, -0.3192,2.0216, 0,2.66, 0.266,-2.394
262.87498, -0.3458,1.995, 2.6394592,0.32993238, 0.21445606,-21.23115
45, -0.3458,1.995, 1.880904,1.880904, 0.037618092,-3.72419
315, -0.3724,1.7822, 1.880904,1.880904, 0.037618092,-3.72419
0, -0.1862,1.862, 0,2.66, 0.0266,-2.6334
0, -0.1596,1.8354, 0,2.66, 0.133,-2.527
135, -0.2926,2.2078, 1.880904,1.880904, 0.037618092,-3.72419
284.03624, -0.3458,2.3408, 8.3868819,0.64514478, 0.10967462,-10.857786
90, -0.3458,2.3408, 0,2.66, 0.133,-2.527
59.036243, -0.1596,2.4738, 5.9304211,0.45618625, 0.15510332,-15.355229
240.25512, -0.0266,2.5004, 5.9387831,0.32993238, 0.21445606,-21.23115
99.462322, 0.4256,2.0482, 13.556341,0.43730131, 0.1618015,-16.018347
45, 0.3192,1.7024, 1.880904,1.880904, 0.037618092,-3.72419
175.60129, 0.4256,1.729, 2.6521649,0.20401269, 0.34682157,-34.335335
180, 0.6118,2.0482, 0,2.66, 0.1862,-2.4738
185.71059, 0.3724,2.2344, 24.08587,0.2646799, 0.2673267,-26.465342
59.036243, 0.0798,2.2876, 5.9304211,0.45618625, 0.15510332,-15.355229
56.309932, 0.2128,2.527, 5.9020101,0.73775127, 0.095907657,-9.4948587
225, 0.4256,2.2344, 1.880904,1.880904, 0.037618092,-3.72419
225, 0.399,2.261, 1.880904,1.880904, 0.037618092,-3.72419
135, 0.4522,2.261, 1.880904,1.880904, 0.037618092,-3.72419
99.462322, 0.4256,2.2876, 13.556341,0.43730131, 0.1618015,-16.018347
180, 0.4788,2.261, 0,2.66, 0.0266,-2.6334
270, 0.399,2.5536, 0,2.66, 0.2926,-2.3674
0, 0,2.8196, 0,2.66, 0.0798,-2.5802
56.309932, -0.3192,2.66, 5.9020101,0.73775127, 0.095907657,-9.4948587
9.4623222, -0.1596,2.793, 13.556341,0.43730131, 0.1618015,-16.018347
33.690068, -0.266,2.7398, 3.6887563,0.73775127, 0.095907657,-9.4948587
0, 0.266,2.8994, 0,2.66, 0.1064,-2.5536
240.25512, 0.2926,2.8196, 5.9387831,0.32993238, 0.21445606,-21.23115
23.198591, 0.0798,2.8196, 5.9376769,0.3492751, 0.20257956,-20.055377
333.43495, 0.3724,2.8994, 2.3791763,1.1895882, 0.059479409,-5.8884614
45, 0.4522,2.6866, 1.880904,1.880904, 0.037618092,-3.72419
270, 0.4256,2.8728, 0,2.66, 0.133,-2.527
90, 3.325,0.6916, 0,2.66, 0.133,-2.527
270, 2.2876,0.798, 0,2.66, 0.0798,-2.5802
90, 2.3142,0.6916, 0,2.66, 0.1064,-2.5536
251.56505, 0.7448,0.7714, 2.5234976,0.84116587, 0.084116595,-8.327542
213.69007, 3.2186,0.5054, 3.6887563,0.73775127, 0.095907657,-9.4948587
0, 3.0856,0.5852, 0,2.66, 0.1064,-2.5536
180, 3.2718,0.665, 0,2.66, 0.798,-1.862
0, 1.3566,0.5054, 0,2.66, 0.8778,-1.7822
0, 1.8886,0.7182, 0,2.66, 0.2394,-2.4206
354.80557, 1.8354,0.532, 2.6490759,0.24082509, 0.2938066,-29.086854
8.1301023, 1.8354,0.2128, 16.175775,0.37618082, 0.18809041,-18.62095
7.1250164, 1.8088,0.2128, 18.806146,0.32993238, 0.21445606,-21.23115
0, 1.3566,0.399, 0,2.66, 0.8246,-1.8354
180, 2.1014,0.3724, 0,2.66, 0.3192,-2.3408
180, 2.1014,0.133, 0,2.66, 0.266,-2.394
355.91438, 1.1172,0.532, 2.6532401,0.18951715, 0.3733488,-36.96153
0, 1.0374,0.399, 0,2.66, 0.266,-2.394
0, 1.0374,0.1064, 0,2.66, 0.7182,-1.9418
182.29061, 1.7024,0.399, 63.895304,0.10631499, 0.66553179,-65.887647
0, 1.1172,0.1064, 0,2.66, 0.6384,-2.0216
9.4623222, 0.8778,0.0798, 13.556341,0.43730131, 0.1618015,-16.018347
0, 0.6916,0.0798, 0,2.66, 0.1862,-2.4738
0, 0.7182,0.266, 0,2.66, 0.1862,-2.4738
5.7105931, 0.7714,0.5054, 24.08587,0.2646799, 0.2673267,-26.465342
180, 1.0374,0.3724, 0,2.66, 0.1862,-2.4738
270, 0.7182,0.6916, 0,2.66, 0.0532,-2.6068
284.03624, 0.7182,0.6384, 8.3868819,0.64514478, 0.10967462,-10.857786
315, 0.7448,0.532, 1.880904,1.880904, 0.037618092,-3.72419
0, 0.6916,0.2926, 0,2.66, 0.1862,-2.4738
0, 1.0374,0.532, 0,2.66, 0.0798,-2.5802
0, 1.0374,0.665, 0,2.66, 0.133,-2.527
288.43495, 1.7556,0.3192, 5.888161,0.84116587, 0.084116595,-8.327542
104.03624, 1.7822,0.2128, 8.3868819,0.64514478, 0.10967462,-10.857786
0, 1.3566,0.2394, 0,2.66, 0.1596,-2.5004
90, 1.7822,0.133, 0,2.66, 0.0798,-2.5802
90, 1.8088,0.1596, 0,2.66, 0.0266,-2.6334
315, 1.7822,0.2394, 1.880904,1.880904, 0.037618092,-3.72419
45, 1.8088,0.1862, 1.880904,1.880904, 0.037618092,-3.72419
135, 1.8354,0.133, 1.880904,1.880904, 0.037618092,-3.72419
45, 1.7556,0.1064, 1.880904,1.880904, 0.037618092,-3.72419
4.3987054, 1.4896,0.5054, 32.029992,0.20401269, 0.34682157,-34.335335
135, 1.33,0.4788, 1.880904,1.880904, 0.037618092,-3.72419
45, 1.33,0.4788, 1.880904,1.880904, 0.037618092,-3.72419
270, 1.33,0.4788, 0,2.66, 0.0532,-2.6068
45, 1.3034,0.399, 1.880904,1.880904, 0.037618092,-3.72419
315, 1.33,0.4256, 1.880904,1.880904, 0.037618092,-3.72419
0, 1.8088,0.6916, 0,2.66, 0.0798,-2.5802
135, 1.729,0.3724, 1.880904,1.880904, 0.037618092,-3.72419
225, 1.7822,0.3724, 1.880904,1.880904, 0.037618092,-3.72419
270, 1.7556,0.3458, 0,2.66, 0.0266,-2.6334
116.56505, 1.7556,0.3192, 3.5687645,1.1895882, 0.059479409,-5.8884614
0, 2.4472,0.5586, 0,2.66, 0.2128,-2.4472
194.03624, 2.5536,0.1596, 8.3868819,0.64514478, 0.10967462,-10.857786
180, 2.8728,0.2394, 0,2.66, 0.6384,-2.0216
0, 2.4472,0.399, 0,2.66, 0.6118,-2.0482
180, 2.3408,0.133, 0,2.66, 0.2394,-2.4206
0, 2.0216,0.2394, 0,2.66, 0.2128,-2.4472
0, 2.2876,0.1862, 0,2.66, 0.133,-2.527
180, 2.4472,0.133, 0,2.66, 0.1064,-2.5536
189.46232, 2.261,0.399, 13.556341,0.43730131, 0.1618015,-16.018347
270, 2.2078,0.4788, 0,2.66, 0.0532,-2.6068
315, 2.1812,0.5054, 1.880904,1.880904, 0.037618092,-3.72419
45, 2.1812,0.399, 1.880904,1.880904, 0.037618092,-3.72419
0, 2.394,0.532, 0,2.66, 0.0532,-2.6068
225, 2.3408,0.6384, 1.880904,1.880904, 0.075236158,-3.6865719
270, 2.2876,0.5852, 0,2.66, 0.0532,-2.6068
153.43495, 2.3674,0.665, 2.3791763,1.1895882, 0.059479409,-5.8884614
90, 2.2344,0.4256, 0,2.66, 0.0266,-2.6334
225, 2.261,0.532, 1.880904,1.880904, 0.037618092,-3.72419
56.309932, 2.2344,0.4522, 5.9020101,0.73775127, 0.095907657,-9.4948587
261.8699, 2.2876,0.7182, 2.6332656,0.37618082, 0.18809041,-18.62095
191.30993, 2.4738,0.665, 10.955047,0.52166893, 0.13563393,-13.427758
180, 2.4738,0.665, 0,2.66, 0.1064,-2.5536
180, 2.4472,0.399, 0,2.66, 0.1862,-2.4738
180, 2.3142,0.3192, 0,2.66, 0.0798,-2.5802
315, 2.2344,0.4256, 1.880904,1.880904, 0.037618092,-3.72419
270, 3.0856,0.3724, 0,2.66, 0.1064,-2.5536
225, 2.8462,0.2394, 1.880904,1.880904, 0.037618092,-3.72419
201.80141, 2.8196,0.2128, 5.9273952,0.4939496, 0.14324539,-14.181293
135, 2.6068,0.1596, 1.880904,1.880904, 0.037618092,-3.72419
225, 2.5802,0.1862, 1.880904,1.880904, 0.037618092,-3.72419
270, 2.5802,0.2394, 0,2.66, 0.0532,-2.6068
180, 2.6866,0.1596, 0,2.66, 0.0798,-2.5802
45, 3.059,0.2394, 1.880904,1.880904, 0.037618092,-3.72419
0, 2.926,0.2394, 0,2.66, 0.1064,-2.5536
0, 2.8728,0.2394, 0,2.66, 0.1862,-2.4738
0, 2.7664,0.665, 0,2.66, 0.133,-2.527
180, 2.926,0.4788, 0,2.66, 0.2128,-2.4472
180, 2.9526,0.3192, 0,2.66, 0.1596,-2.5004
0, 2.9526,0.7448, 0,2.66, 0.1862,-2.4738
225, 3.1388,0.4522, 1.880904,1.880904, 0.037618092,-3.72419
315, 3.059,0.399, 1.880904,1.880904, 0.037618092,-3.72419
198.43495, 3.1122,0.4256, 5.888161,0.84116587, 0.084116595,-8.327542
270, 3.3516,0.5586, 0,2.66, 0.0266,-2.6334
90, 3.3516,0.532, 0,2.66, 0.0798,-2.5802
180, 3.325,0.5054, 0,2.66, 0.1064,-2.5536
0, 3.2718,0.665, 0,2.66, 0.0266,-2.6334
45, 3.2984,0.665, 1.880904,1.880904, 0.037618092,-3.72419
225, 3.3516,0.532, 1.880904,1.880904, 0.037618092,-3.72419
146.30993, 3.3516,0.6118, 5.9020101,0.73775127, 0.095907657,-9.4948587
0, 2.3408,0.8512, 0,2.66, 0.9576,-1.7024
260.53768, 1.064,2.7132, 2.6238078,0.43730131, 0.1618015,-16.018347
251.56505, 2.3408,2.6866, 2.5234976,0.84116587, 0.084116595,-8.327542
36.869898, 1.6758,2.5802, 3.724,0.532, 0.133,-13.167
270, 1.7822,2.66, 0,2.66, 0.0532,-2.6068
258.69007, 1.0906,2.7398, 2.6083446,0.52166893, 0.13563393,-13.427758
2.385944, 1.8354,1.4098, 61.237699,0.11073724, 0.63895392,-63.256439
116.56505, 1.9152,1.2502, 3.5687645,1.1895882, 0.11895882,-5.828982
277.59464, 1.862,1.33, 18.808219,0.17577775, 0.40253104,-39.850573
0, 1.8886,1.3566, 0,2.66, 0.1064,-2.5536
296.56505, 1.8886,1.1438, 3.5687645,1.1895882, 0.11895882,-5.828982
225, 1.9152,1.2236, 1.880904,1.880904, 0.037618092,-3.72419
63.434949, 1.8886,0.8246, 2.3791763,1.1895882, 0.059479409,-5.8884614
180, 1.9418,0.798, 0,2.66, 0.3458,-2.3142
355.60129, 1.6758,1.729, 2.6521649,0.20401269, 0.34682157,-34.335335
3.1798301, 1.4896,1.8088, 45.297927,0.14755025, 0.47953831,-47.474294
355.23636, 1.7822,2.4206, 2.6508117,0.22090098, 0.32030643,-31.710335
0, 1.7822,2.4206, 0,2.66, 0.3192,-2.3408
0, 1.4896,2.2078, 0,2.66, 0.5586,-2.1014
180, 2.4738,2.0216, 0,2.66, 0.9842,-1.6758
1.974934, 1.4896,1.995, 74.527428,0.091669665, 0.77185848,-76.41399
180, 2.261,2.5802, 0,2.66, 0.5586,-2.1014
0, 1.8088,2.5802, 0,2.66, 0.4788,-2.1812
181.78991, 2.2344,1.7556, 82.50285,0.083084435, 0.85161552,-84.309937
1.3322198, 1.3034,1.4364, 111.75165,0.06184375, 1.1441093,-113.26682
315, 0.8512,1.7024, 1.880904,1.880904, 0.037618092,-3.72419
270, 0.9044,1.7024, 0,2.66, 0.0798,-2.5802
243.43495, 1.33,1.4098, 2.3791763,1.1895882, 0.17843823,-5.7695026
0, 1.197,1.4098, 0,2.66, 0.133,-2.527
315, 1.2502,1.197, 1.880904,1.880904, 0.037618092,-3.72419
315, 1.2502,1.0374, 1.880904,1.880904, 0.037618092,-3.72419
251.56505, 1.2768,1.1704, 2.5234976,0.84116587, 0.084116595,-8.327542
225, 1.2768,0.8512, 1.880904,1.880904, 0.037618092,-3.72419
180, 1.4098,0.7714, 0,2.66, 0.2128,-2.4472
4.3987054, 0.9576,1.4098, 32.029992,0.20401269, 0.34682157,-34.335335
183.57633, 1.2236,1.2236, 39.988224,0.16592625, 0.42643045,-42.216614
0, 0.798,1.197, 0,2.66, 0.2394,-2.4206
186.34019, 1.0374,1.0374, 21.443594,0.29374787, 0.24087324,-23.846451
185.19443, 1.0374,1.064, 26.731584,0.24082509, 0.2938066,-29.086854
180, 0.9576,0.798, 0,2.66, 0.133,-2.527
180, 1.0374,0.798, 0,2.66, 0.266,-2.394
0, 0.6916,1.1172, 0,2.66, 0.1862,-2.4738
0, 0.7182,1.0906, 0,2.66, 0.0266,-2.6334
146.30993, 0.8246,0.798, 5.9020101,0.73775127, 0.095907657,-9.4948587
45, 0.7448,0.7714, 1.880904,1.880904, 0.037618092,-3.72419
225, 1.2502,1.0906, 1.880904,1.880904, 0.037618092,-3.72419
180, 1.0374,0.798, 0,2.66, 0.0798,-2.5802
180, 1.1172,0.798, 0,2.66, 0.0798,-2.5802
161.56505, 1.197,0.7714, 2.5234976,0.84116587, 0.084116595,-8.327542
187.12502, 1.2502,0.8246, 18.806146,0.32993238, 0.21445606,-21.23115
0, 1.0374,1.197, 0,2.66, 0.2128,-2.4472
180, 1.2236,1.064, 0,2.66, 0.1862,-2.4738
180, 1.2502,1.0374, 0,2.66, 0.2128,-2.4472
0, 0.8512,1.4098, 0,2.66, 0.1862,-2.4738
0, 0.8246,1.3566, 0,2.66, 0.2128,-2.4472
315, 0.931,1.4364, 1.880904,1.880904, 0.037618092,-3.72419
270, 0.931,1.4896, 0,2.66, 0.0266,-2.6334
225, 0.931,1.463, 1.880904,1.880904, 0.037618092,-3.72419
281.30993, 0.9044,1.6226, 10.955047,0.52166893, 0.13563393,-13.427758
296.56505, 0.8778,1.6758, 3.5687645,1.1895882, 0.059479409,-5.8884614
296.56505, 0.9044,1.6226, 3.5687645,1.1895882, 0.059479409,-5.8884614
270, 0.931,1.5694, 0,2.66, 0.133,-2.527
225, 1.2502,1.2502, 1.880904,1.880904, 0.037618092,-3.72419
0, 1.0374,1.4098, 0,2.66, 0.1596,-2.5004
0, 1.1704,1.6226, 0,2.66, 0.0798,-2.5802
236.30993, 1.463,1.2502, 5.9020101,0.73775127, 0.19181534,-9.3989511
56.309932, 1.6492,1.1704, 5.9020101,0.73775127, 0.095907657,-9.4948587
90, 1.2768,0.8246, 0,2.66, 0.4256,-2.2344
56.309932, 1.5428,0.931, 5.9020101,0.73775127, 0.095907657,-9.4948587
188.1301, 1.596,0.798, 16.175775,0.37618082, 0.18809041,-18.62095
0, 1.3034,0.798, 0,2.66, 0.532,-2.128
56.309932, 1.5428,1.0108, 5.9020101,0.73775127, 0.095907657,-9.4948587
90, 1.2768,0.8512, 0,2.66, 0.1596,-2.5004
270, 1.2768,0.9044, 0,2.66, 0.0798,-2.5802
315, 1.2768,0.8246, 1.880904,1.880904, 0.037618092,-3.72419
270, 1.8886,1.197, 0,2.66, 0.0532,-2.6068
26.565051, 1.8354,0.798, 3.5687645,1.1895882, 0.059479409,-5.8884614
56.309932, 1.7556,0.9044, 5.9020101,0.73775127, 0.095907657,-9.4948587
236.30993, 1.8088,1.1438, 5.9020101,0.73775127, 0.19181534,-9.3989511
5.1944289, 1.3566,1.4098, 26.731584,0.24082509, 0.2938066,-29.086854
0, 1.4896,1.5428, 0,2.66, 0.2926,-2.3674
56.309932, 1.3034,1.33, 5.9020101,0.73775127, 0.095907657,-9.4948587
71.565051, 1.2768,1.2502, 2.5234976,0.84116587, 0.084116595,-8.327542
236.30993, 1.463,1.3034, 5.9020101,0.73775127, 0.095907657,-9.4948587
236.30993, 1.7556,1.3832, 5.9020101,0.73775127, 0.19181534,-9.3989511
116.56505, 1.862,1.3566, 3.5687645,1.1895882, 0.059479409,-5.8884614
288.43495, 1.8354,1.4098, 5.888161,0.84116587, 0.084116595,-8.327542
351.8699, 1.6492,1.4364, 2.6332656,0.37618082, 0.18809041,-18.62095
0, 1.7024,1.596, 0,2.66, 0.133,-2.527
0, 1.2236,2.5004, 0,2.66, 0.0532,-2.6068
180, 1.4364,2.4206, 0,2.66, 0.2394,-2.4206
0, 1.2236,2.261, 0,2.66, 0.1862,-2.4738
0, 1.0906,2.5802, 0,2.66, 0.5852,-2.0748
3.8140748, 1.0906,2.5536, 37.33446,0.17694057, 0.39988567,-39.588683
0, 1.1704,1.7024, 0,2.66, 0.2128,-2.4472
0, 0.931,1.729, 0,2.66, 0.4256,-2.2344
239.03624, 1.33,1.9684, 5.9304211,0.45618625, 0.15510332,-15.355229
270, 0.9044,2.3142, 0,2.66, 0.2128,-2.4472
78.690068, 0.9044,2.0748, 2.6083446,0.52166893, 0.13563393,-13.427758
315, 0.8512,2.0482, 1.880904,1.880904, 0.037618092,-3.72419
225, 0.9044,2.1014, 1.880904,1.880904, 0.037618092,-3.72419
296.56505, 0.8778,2.0216, 3.5687645,1.1895882, 0.059479409,-5.8884614
270, 0.8778,1.8088, 0,2.66, 0.0532,-2.6068
225, 0.8778,1.7556, 1.880904,1.880904, 0.037618092,-3.72419
251.56505, 0.9044,1.8886, 2.5234976,0.84116587, 0.084116595,-8.327542
270, 0.9044,1.9684, 0,2.66, 0.0798,-2.5802
225, 0.931,1.729, 1.880904,1.880904, 0.037618092,-3.72419
315, 0.9044,1.7556, 1.880904,1.880904, 0.037618092,-3.72419
270, 0.9044,2.0748, 0,2.66, 0.3192,-2.3408
236.30993, 1.064,1.862, 5.9020101,0.73775127, 0.095907657,-9.4948587
236.30993, 1.0108,2.0482, 5.9020101,0.73775127, 0.095907657,-9.4948587
239.03624, 1.197,2.128, 5.9304211,0.45618625, 0.15510332,-15.355229
236.30993, 1.1704,2.0216, 5.9020101,0.73775127, 0.095907657,-9.4948587
348.69007, 1.0374,1.729, 2.6083446,0.52166893, 0.13563393,-13.427758
45, 0.931,2.2078, 1.880904,1.880904, 0.037618092,-3.72419
243.43495, 0.9576,2.3408, 2.3791763,1.1895882, 0.059479409,-5.8884614
315, 0.931,2.2876, 1.880904,1.880904, 0.037618092,-3.72419
0, 0.7714,2.527, 0,2.66, 0.0266,-2.6334
0, 0.7448,2.6068, 0,2.66, 0.1596,-2.5004
135, 0.9044,2.3142, 1.880904,1.880904, 0.037618092,-3.72419
192.52881, 0.8778,2.3408, 10.963665,0.28851751, 0.24523987,-24.278748
225, 1.0108,2.4206, 1.880904,1.880904, 0.037618092,-3.72419
258.69007, 1.0374,2.5536, 2.6083446,0.52166893, 0.13563393,-13.427758
26.565051, 1.1704,2.2344, 3.5687645,1.1895882, 0.059479409,-5.8884614
45, 1.064,2.527, 1.880904,1.880904, 0.037618092,-3.72419
315, 1.064,2.6068, 1.880904,1.880904, 0.037618092,-3.72419
180, 1.1438,2.394, 0,2.66, 0.0798,-2.5802
0, 0.9842,2.3674, 0,2.66, 0.0532,-2.6068
0, 1.0374,2.3674, 0,2.66, 0.1064,-2.5536
135, 1.064,2.394, 1.880904,1.880904, 0.037618092,-3.72419
225, 0.9842,2.3674, 1.880904,1.880904, 0.037618092,-3.72419
345.96376, 0.9576,2.261, 2.5805791,0.64514478, 0.10967462,-10.857786
75.963757, 1.0374,2.4206, 2.5805791,0.64514478, 0.10967462,-10.857786
26.565051, 1.1438,2.3674, 3.5687645,1.1895882, 0.11895882,-5.828982
206.56505, 1.197,2.4206, 3.5687645,1.1895882, 0.059479409,-5.8884614
0, 1.064,2.2344, 0,2.66, 0.1064,-2.5536
0, 0.9576,2.2344, 0,2.66, 0.2128,-2.4472
255.96376, 1.463,2.1812, 2.5805791,0.64514478, 0.10967462,-10.857786
90, 1.463,2.0482, 0,2.66, 0.1064,-2.5536
63.434949, 1.3034,2.1014, 2.3791763,1.1895882, 0.11895882,-5.828982
0, 1.463,1.729, 0,2.66, 0.2128,-2.4472
0, 1.5694,1.7822, 0,2.66, 0.1596,-2.5004
45, 1.463,1.9684, 1.880904,1.880904, 0.037618092,-3.72419
315, 1.463,2.0482, 1.880904,1.880904, 0.037618092,-3.72419
296.56505, 1.4364,1.8886, 3.5687645,1.1895882, 0.059479409,-5.8884614
315, 1.463,1.8354, 1.880904,1.880904, 0.037618092,-3.72419
18.434949, 1.3832,1.7024, 5.888161,0.84116587, 0.084116595,-8.327542
225, 1.4364,1.8088, 1.880904,1.880904, 0.11285425,-3.6489538
36.869898, 1.3832,1.729, 3.724,0.532, 0.133,-13.167
251.56505, 1.463,1.9684, 2.5234976,0.84116587, 0.084116595,-8.327542
270, 1.4364,2.0748, 0,2.66, 0.266,-2.394
0, 1.7024,2.1014, 0,2.66, 0.1596,-2.5004
180, 1.7024,2.5802, 0,2.66, 0.2128,-2.4472
0, 1.5162,2.4206, 0,2.66, 0.266,-2.394
270, 1.4896,2.5536, 0,2.66, 0.0266,-2.6334
315, 1.463,2.5802, 1.880904,1.880904, 0.037618092,-3.72419
45, 1.4896,2.5536, 1.880904,1.880904, 0.037618092,-3.72419
270, 1.5162,2.4472, 0,2.66, 0.0266,-2.6334
315, 1.4364,2.4206, 1.880904,1.880904, 0.037618092,-3.72419
225, 1.463,2.4472, 1.880904,1.880904, 0.037618092,-3.72419
236.30993, 1.5162,2.4206, 5.9020101,0.73775127, 0.095907657,-9.4948587
315, 1.4098,2.261, 1.880904,1.880904, 0.037618092,-3.72419
225, 1.4364,2.2876, 1.880904,1.880904, 0.037618092,-3.72419
315, 1.463,2.2344, 1.880904,1.880904, 0.037618092,-3.72419
270, 1.463,2.3408, 0,2.66, 0.1064,-2.5536
255.96376, 1.463,2.394, 2.5805791,0.64514478, 0.10967462,-10.857786
180, 1.3832,2.3408, 0,2.66, 0.0532,-2.6068
243.43495, 1.4896,2.2078, 2.3791763,1.1895882, 0.059479409,-5.8884614
296.56505, 1.4364,2.2344, 3.5687645,1.1895882, 0.059479409,-5.8884614
255.96376, 1.4896,2.5536, 2.5805791,0.64514478, 0.10967462,-10.857786
288.43495, 1.4896,2.527, 5.888161,0.84116587, 0.084116595,-8.327542
315, 1.7822,2.6068, 1.880904,1.880904, 0.037618092,-3.72419
0, 1.7024,2.3408, 0,2.66, 0.0798,-2.5802
0, 1.8088,2.3142, 0,2.66, 0.0532,-2.6068
288.43495, 2.9526,1.7024, 5.888161,0.84116587, 0.084116595,-8.327542
341.56505, 2.527,1.3832, 2.5234976,0.84116587, 0.084116595,-8.327542
0, 2.4472,0.798, 0,2.66, 0.1596,-2.5004
0, 1.995,0.8512, 0,2.66, 1.1172,-1.5428
180, 2.9792,1.2236, 0,2.66, 1.064,-1.596
2.29061, 1.9418,1.2236, 63.895304,0.10631499, 0.66553179,-65.887647
0, 2.4472,1.463, 0,2.66, 0.4788,-2.1812
56.309932, 2.2078,1.0906, 5.9020101,0.73775127, 0.095907657,-9.4948587
184.76364, 2.261,0.8246, 29.37983,0.22090098, 0.32030643,-31.710335
270, 1.9152,0.931, 0,2.66, 0.0532,-2.6068
239.03624, 2.128,1.1704, 5.9304211,0.45618625, 0.15510332,-15.355229
59.036243, 2.128,1.0108, 5.9304211,0.45618625, 0.15510332,-15.355229
236.30993, 2.1014,1.064, 5.9020101,0.73775127, 0.095907657,-9.4948587
288.43495, 1.9418,0.9576, 5.888161,0.84116587, 0.084116595,-8.327542
315, 1.9684,0.8778, 1.880904,1.880904, 0.037618092,-3.72419
270, 1.9418,1.0374, 0,2.66, 0.0798,-2.5802
236.30993, 2.5004,1.0374, 5.9020101,0.73775127, 0.095907657,-9.4948587
239.03624, 2.527,1.1438, 5.9304211,0.45618625, 0.15510332,-15.355229
315, 2.261,0.8246, 1.880904,1.880904, 0.037618092,-3.72419
45, 2.3142,0.798, 1.880904,1.880904, 0.037618092,-3.72419
11.309932, 2.3408,0.8246, 10.955047,0.52166893, 0.13563393,-13.427758
56.309932, 2.3408,0.931, 5.9020101,0.73775127, 0.095907657,-9.4948587
135, 1.9418,1.2236, 1.880904,1.880904, 0.037618092,-3.72419
135, 2.527,1.3832, 1.880904,1.880904, 0.075236158,-3.6865719
180, 2.3674,1.33, 0,2.66, 0.0532,-2.6068
0, 2.3408,1.596, 0,2.66, 0.0532,-2.6068
168.69007, 3.1122,1.197, 2.6083446,0.52166893, 0.13563393,-13.427758
239.03624, 2.8994,1.0374, 5.9304211,0.45618625, 0.15510332,-15.355229
59.036243, 2.66,0.9842, 5.9304211,0.45618625, 0.15510332,-15.355229
56.309932, 2.7398,1.064, 5.9020101,0.73775127, 0.095907657,-9.4948587
0, 2.5802,0.7714, 0,2.66, 0.0798,-2.5802
239.03624, 3.059,1.0906, 5.9304211,0.45618625, 0.15510332,-15.355229
56.309932, 2.8462,0.8778, 5.9020101,0.73775127, 0.095907657,-9.4948587
135, 3.1388,1.1704, 1.880904,1.880904, 0.037618092,-3.72419
45, 3.1122,0.8512, 1.880904,1.880904, 0.037618092,-3.72419
270, 3.1388,1.0108, 0,2.66, 0.133,-2.527
90, 3.1388,0.8778, 0,2.66, 0.2926,-2.3674
315, 2.6068,1.3566, 1.880904,1.880904, 0.037618092,-3.72419
225, 2.6334,1.2768, 1.880904,1.880904, 0.037618092,-3.72419
270, 2.6334,1.33, 0,2.66, 0.0532,-2.6068
270, 2.9792,1.6226, 0,2.66, 0.0532,-2.6068
225, 2.9526,1.4896, 1.880904,1.880904, 0.037618092,-3.72419
71.565051, 2.9526,1.4896, 2.5234976,0.84116587, 0.084116595,-8.327542
184.08562, 2.8196,2.2078, 34.681639,0.18951715, 0.3733488,-36.96153
182.72631, 3.0324,2.0482, 53.266308,0.1265233, 0.55923297,-55.364064
0, 2.394,1.7556, 0,2.66, 0.2128,-2.4472
0, 1.9684,1.8354, 0,2.66, 0.2926,-2.3674
0, 2.0216,1.7024, 0,2.66, 0.2128,-2.4472
0, 2.0482,1.9152, 0,2.66, 0.1064,-2.5536
0, 1.9418,1.9418, 0,2.66, 0.133,-2.527
315, 2.261,2.0216, 1.880904,1.880904, 0.037618092,-3.72419
270, 2.261,1.8088, 0,2.66, 0.0266,-2.6334
225, 2.2876,1.862, 1.880904,1.880904, 0.037618092,-3.72419
225, 2.261,1.7822, 1.880904,1.880904, 0.037618092,-3.72419
315, 2.2344,1.8354, 1.880904,1.880904, 0.037618092,-3.72419
18.434949, 2.2344,1.7024, 5.888161,0.84116587, 0.16823316,-8.2434254
270, 2.2876,1.995, 0,2.66, 0.133,-2.527
0, 2.1014,2.5004, 0,2.66, 0.133,-2.527
0, 2.1014,2.394, 0,2.66, 0.1862,-2.4738
180, 2.2876,2.2078, 0,2.66, 0.2394,-2.4206
0, 2.1014,2.4206, 0,2.66, 0.1862,-2.4738
174.80557, 2.261,2.1812, 2.6490759,0.24082509, 0.2938066,-29.086854
0, 2.0482,2.527, 0,2.66, 0.133,-2.527
135, 2.3142,2.527, 1.880904,1.880904, 0.075236158,-3.6865719
45, 2.2876,2.5802, 1.880904,1.880904, 0.037618092,-3.72419
296.56505, 2.2876,2.394, 3.5687645,1.1895882, 0.059479409,-5.8884614
45, 2.2876,2.4206, 1.880904,1.880904, 0.037618092,-3.72419
243.43495, 2.3142,2.261, 2.3791763,1.1895882, 0.059479409,-5.8884614
270, 2.3142,2.3408, 0,2.66, 0.0798,-2.5802
180, 2.4472,2.1812, 0,2.66, 0.1862,-2.4738
90, 2.3142,2.4472, 0,2.66, 0.0798,-2.5802
284.03624, 3.0324,2.1812, 8.3868819,0.64514478, 0.10967462,-10.857786
0, 2.793,1.729, 0,2.66, 0.133,-2.527
351.8699, 2.6068,1.7556, 2.6332656,0.37618082, 0.18809041,-18.62095
225, 3.059,2.0748, 1.880904,1.880904, 0.037618092,-3.72419
315, 2.926,1.729, 1.880904,1.880904, 0.037618092,-3.72419
180, 3.0058,2.2078, 0,2.66, 0.1862,-2.4738
0, 2.6866,2.1546, 0,2.66, 0.133,-2.527
315, 3.0058,2.2078, 1.880904,1.880904, 0.037618092,-3.72419
180, 2.1014,2.793, 0,2.66, 0.266,-2.394
0, 1.1172,2.7664, 0,2.66, 0.6384,-2.0216
0, 0.7714,2.7398, 0,2.66, 0.266,-2.394
315, 1.0374,2.7398, 1.880904,1.880904, 0.037618092,-3.72419
45, 1.0906,2.7398, 1.880904,1.880904, 0.037618092,-3.72419
90, 1.7822,2.66, 0,2.66, 0.0798,-2.5802
315, 1.7556,2.7664, 1.880904,1.880904, 0.037618092,-3.72419
243.43495, 1.8088,2.7664, 2.3791763,1.1895882, 0.059479409,-5.8884614
225, 1.8354,2.793, 1.880904,1.880904, 0.037618092,-3.72419
180, 2.3408,2.793, 0,2.66, 0.2394,-2.4206
0, 1.9152,2.7132, 0,2.66, 0.0532,-2.6068
45, 2.3408,2.6866, 1.880904,1.880904, 0.037618092,-3.72419
90, 2.3674,2.7132, 0,2.66, 0.0266,-2.6334
116.56505, 2.3674,2.7398, 3.5687645,1.1895882, 0.059479409,-5.8884614
315, 3.2984,0.8512, 1.880904,1.880904, 0.037618092,-3.72419
135, 3.325,0.8246, 1.880904,1.880904, 0.037618092,-3.72419
;; (c)1997 STONE PRODUCTS CORPORATION
*SSTNWSB, STREAM STONE WITH SKIMMER BLEND
;%TYPE=MODEL
90, 0.29925,2.1546, 0,2.9925, 0.029925,-2.962575
45, 0.269325,2.124675, 2.1160171,2.1160171, 0.042320354,-4.1897137
26.565051, 0.209475,2.09475, 4.0148601,1.3382867, 0.066914335,-6.6245191
0, 0.149625,2.09475, 0,2.9925, 0.05985,-2.93265
296.56505, 0.1197,2.1546, 4.0148601,1.3382867, 0.066914335,-6.6245191
243.43495, 0.149625,2.21445, 2.6765734,1.3382867, 0.066914335,-6.6245191
206.56505, 0.209475,2.244375, 4.0148601,1.3382867, 0.066914335,-6.6245191
180, 0.269325,2.244375, 0,2.9925, 0.05985,-2.93265
135, 0.29925,2.21445, 2.1160171,2.1160171, 0.042320354,-4.1897137
0, 2.57355,2.09475, 0,2.9925, 0.089775,-2.902725
315, 2.543625,2.124675, 2.1160171,2.1160171, 0.042320354,-4.1897137
270, 2.543625,2.1546, 0,2.9925, 0.029925,-2.962575
225, 2.57355,2.184525, 2.1160171,2.1160171, 0.042320354,-4.1897137
225, 2.603475,2.21445, 2.1160171,2.1160171, 0.042320354,-4.1897137
153.43495, 2.663325,2.184525, 2.6765734,1.3382867, 0.066914335,-6.6245191
135, 2.69325,2.1546, 2.1160171,2.1160171, 0.042320354,-4.1897137
63.434949, 2.663325,2.09475, 2.6765734,1.3382867, 0.066914335,-6.6245191
135, 1.61595,2.304225, 2.1160171,2.1160171, 0.042320354,-4.1897137
180, 1.645875,2.304225, 0,2.9925, 0.029925,-2.962575
161.56505, 1.73565,2.2743, 2.8389347,0.9463116, 0.094631169,-9.3684848
225, 1.765575,2.304225, 2.1160171,2.1160171, 0.042320354,-4.1897137
270, 1.765575,2.364075, 0,2.9925, 0.05985,-2.93265
333.43495, 1.705725,2.394, 2.6765734,1.3382867, 0.066914335,-6.6245191
0, 1.61595,2.394, 0,2.9925, 0.089775,-2.902725
45, 1.586025,2.364075, 2.1160171,2.1160171, 0.042320354,-4.1897137
0, 2.842875,1.765575, 0,2.9925, 0.1197,-2.8728
180, 2.81295,1.586025, 0,2.9925, 0.05985,-2.93265
180, 2.93265,1.197, 0,2.9925, 0.029925,-2.962575
26.565051, 2.93265,1.197, 4.0148601,1.3382867, 0.066914335,-6.6245191
296.56505, 0.1197,2.394, 4.0148601,1.3382867, 0.066914335,-6.6245191
270, 0.1197,2.45385, 0,2.9925, 0.05985,-2.93265
63.434949, 0.089775,2.394, 2.6765734,1.3382867, 0.066914335,-6.6245191
26.565051, 1.9152,2.8728, 4.0148601,1.3382867, 0.066914335,-6.6245191
168.69007, 1.765575,2.842875, 2.9343876,0.58687754, 0.15258817,-15.106228
26.565051, 2.45385,2.6334, 4.0148601,1.3382867, 0.066914335,-6.6245191
26.565051, 2.5137,2.663325, 4.0148601,1.3382867, 0.066914335,-6.6245191
26.565051, 2.57355,2.69325, 4.0148601,1.3382867, 0.066914335,-6.6245191
0, 2.6334,2.723175, 0,2.9925, 0.05985,-2.93265
315, 2.69325,2.723175, 2.1160171,2.1160171, 0.042320354,-4.1897137
270, 2.723175,2.69325, 0,2.9925, 0.05985,-2.93265
243.43495, 2.723175,2.6334, 2.6765734,1.3382867, 0.066914335,-6.6245191
225, 2.69325,2.57355, 2.1160171,2.1160171, 0.042320354,-4.1897137
194.03624, 2.663325,2.543625, 9.4352421,0.72578788, 0.12338395,-12.21501
161.56505, 2.543625,2.5137, 2.8389347,0.9463116, 0.094631169,-9.3684848
135, 2.45385,2.543625, 2.1160171,2.1160171, 0.042320354,-4.1897137
90, 2.423925,2.57355, 0,2.9925, 0.029925,-2.962575
45, 2.423925,2.603475, 2.1160171,2.1160171, 0.042320354,-4.1897137
165.96376, 1.705725,1.645875, 2.9031514,0.72578788, 0.12338395,-12.21501
18.434949, 2.184525,0.987525, 6.6241811,0.9463116, 0.094631169,-9.3684848
0, 2.2743,1.01745, 0,2.9925, 0.089775,-2.902725
341.56505, 2.364075,1.01745, 2.8389347,0.9463116, 0.094631169,-9.3684848
341.56505, 2.45385,0.987525, 2.8389347,0.9463116, 0.094631169,-9.3684848
296.56505, 2.543625,0.9576, 4.0148601,1.3382867, 0.066914335,-6.6245191
270, 2.57355,0.89775, 0,2.9925, 0.1197,-2.8728
225, 2.57355,0.77805, 2.1160171,2.1160171, 0.042320354,-4.1897137
206.56505, 2.543625,0.748125, 4.0148601,1.3382867, 0.066914335,-6.6245191
180, 2.483775,0.7182, 0,2.9925, 0.2394,-2.7531
153.43495, 2.244375,0.7182, 2.6765734,1.3382867, 0.066914335,-6.6245191
135, 2.184525,0.748125, 2.1160171,2.1160171, 0.084640679,-4.1473934
116.56505, 2.124675,0.807975, 4.0148601,1.3382867, 0.066914335,-6.6245191
90, 2.09475,0.867825, 0,2.9925, 0.029925,-2.962575
63.434949, 2.09475,0.89775, 2.6765734,1.3382867, 0.066914335,-6.6245191
26.565051, 2.124675,0.9576, 4.0148601,1.3382867, 0.066914335,-6.6245191
45, 0.05985,1.406475, 2.1160171,2.1160171, 0.084640679,-4.1473934
0, 0.1197,1.466325, 0,2.9925, 0.05985,-2.93265
0, 0.17955,1.466325, 0,2.9925, 0.089775,-2.902725
315, 0.269325,1.466325, 2.1160171,2.1160171, 0.084640679,-4.1473934
270, 0.329175,1.406475, 0,2.9925, 0.05985,-2.93265
225, 0.329175,1.346625, 2.1160171,2.1160171, 0.084640679,-4.1473934
206.56505, 0.269325,1.286775, 4.0148601,1.3382867, 0.066914335,-6.6245191
180, 0.209475,1.25685, 0,2.9925, 0.1197,-2.8728
153.43495, 0.089775,1.25685, 2.6765734,1.3382867, 0.066914335,-6.6245191
206.56505, 2.783025,1.4364, 4.0148601,1.3382867, 0.066914335,-6.6245191
270, 2.723175,1.406475, 0,2.9925, 0.05985,-2.93265
315, 2.723175,1.346625, 2.1160171,2.1160171, 0.042320354,-4.1897137
333.43495, 2.7531,1.3167, 2.6765734,1.3382867, 0.066914335,-6.6245191
315, 2.81295,1.286775, 2.1160171,2.1160171, 0.042320354,-4.1897137
315, 2.842875,1.25685, 2.1160171,2.1160171, 0.084640679,-4.1473934
45, 0,1.226925, 2.1160171,2.1160171, 0.042320354,-4.1897137
90, 0.029925,1.25685, 0,2.9925, 0.05985,-2.93265
63.434949, 0.029925,1.3167, 2.6765734,1.3382867, 0.066914335,-6.6245191
90, 0.05985,1.37655, 0,2.9925, 0.029925,-2.962575
135, 0.05985,1.406475, 2.1160171,2.1160171, 0.042320354,-4.1897137
180, 0.029925,1.4364, 0,2.9925, 0.029925,-2.962575
180, 2.9925,1.4364, 0,2.9925, 0.1197,-2.8728
0, 2.962575,1.61595, 0,2.9925, 0.029925,-2.962575
0, 0,1.61595, 0,2.9925, 0.149625,-2.842875
26.565051, 0.149625,1.61595, 4.0148601,1.3382867, 0.066914335,-6.6245191
90, 0.209475,1.645875, 0,2.9925, 0.029925,-2.962575
90, 0.209475,1.6758, 0,2.9925, 0.029925,-2.962575
135, 0.209475,1.705725, 2.1160171,2.1160171, 0.042320354,-4.1897137
153.43495, 0.17955,1.73565, 2.6765734,1.3382867, 0.066914335,-6.6245191
180, 0.1197,1.765575, 0,2.9925, 0.1197,-2.8728
180, 2.9925,1.765575, 0,2.9925, 0.029925,-2.962575
194.03624, 2.962575,1.765575, 9.4352421,0.72578788, 0.12338395,-12.21501
206.56505, 2.842875,1.73565, 4.0148601,1.3382867, 0.066914335,-6.6245191
270, 2.783025,1.705725, 0,2.9925, 0.029925,-2.962575
270, 2.783025,1.6758, 0,2.9925, 0.029925,-2.962575
315, 2.783025,1.645875, 2.1160171,2.1160171, 0.042320354,-4.1897137
0, 2.81295,1.61595, 0,2.9925, 0.05985,-2.93265
0, 2.8728,1.61595, 0,2.9925, 0.089775,-2.902725
194.03624, 0.269325,1.49625, 9.4352421,0.72578788, 0.12338395,-12.21501
180, 0.149625,1.466325, 0,2.9925, 0.149625,-2.842875
194.03624, 2.9925,1.466325, 9.4352421,0.72578788, 0.12338395,-12.21501
180, 2.8728,1.4364, 0,2.9925, 0.089775,-2.902725
153.43495, 2.783025,1.4364, 2.6765734,1.3382867, 0.066914335,-6.6245191
135, 2.723175,1.466325, 2.1160171,2.1160171, 0.042320354,-4.1897137
90, 2.69325,1.49625, 0,2.9925, 0.029925,-2.962575
90, 2.69325,1.526175, 0,2.9925, 0.029925,-2.962575
11.309932, 2.81295,1.586025, 12.324428,0.58687754, 0.15258817,-15.106228
0, 2.962575,1.61595, 0,2.9925, 0.029925,-2.962575
0, 0,1.61595, 0,2.9925, 0.089775,-2.902725
0, 0.089775,1.61595, 0,2.9925, 0.1197,-2.8728
333.43495, 0.209475,1.61595, 2.6765734,1.3382867, 0.066914335,-6.6245191
315, 0.269325,1.586025, 2.1160171,2.1160171, 0.042320354,-4.1897137
270, 0.29925,1.5561, 0,2.9925, 0.029925,-2.962575
225, 0.29925,1.526175, 2.1160171,2.1160171, 0.042320354,-4.1897137
333.43495, 0.2394,1.9152, 2.6765734,1.3382867, 0.066914335,-6.6245191
315, 0.29925,1.885275, 2.1160171,2.1160171, 0.042320354,-4.1897137
296.56505, 0.329175,1.85535, 4.0148601,1.3382867, 0.066914335,-6.6245191
270, 0.3591,1.7955, 0,2.9925, 0.05985,-2.93265
225, 0.3591,1.73565, 2.1160171,2.1160171, 0.042320354,-4.1897137
180, 0.329175,1.705725, 0,2.9925, 0.05985,-2.93265
161.56505, 0.269325,1.705725, 2.8389347,0.9463116, 0.094631169,-9.3684848
146.30993, 0.17955,1.73565, 6.6397614,0.82997018, 0.10789611,-10.681716
90, 0.089775,1.7955, 0,2.9925, 0.029925,-2.962575
90, 0.089775,1.825425, 0,2.9925, 0.05985,-2.93265
45, 0.089775,1.885275, 2.1160171,2.1160171, 0.084640679,-4.1473934
0, 0.209475,2.09475, 0,2.9925, 0.1197,-2.8728
345.96376, 0.329175,2.09475, 2.9031514,0.72578788, 0.12338395,-12.21501
326.30993, 0.448875,2.064825, 6.6397614,0.82997018, 0.10789611,-10.681716
270, 0.53865,2.004975, 0,2.9925, 0.05985,-2.93265
225, 0.53865,1.945125, 2.1160171,2.1160171, 0.042320354,-4.1897137
198.43495, 0.508725,1.9152, 6.6241811,0.9463116, 0.094631169,-9.3684848
180, 0.41895,1.885275, 0,2.9925, 0.089775,-2.902725
161.56505, 0.329175,1.885275, 2.8389347,0.9463116, 0.094631169,-9.3684848
161.56505, 0.2394,1.9152, 2.8389347,0.9463116, 0.094631169,-9.3684848
135, 0.149625,1.945125, 2.1160171,2.1160171, 0.042320354,-4.1897137
71.565051, 0.1197,1.97505, 2.8389347,0.9463116, 0.094631169,-9.3684848
26.565051, 0.149625,2.064825, 4.0148601,1.3382867, 0.066914335,-6.6245191
26.565051, 1.73565,0.05985, 4.0148601,1.3382867, 0.066914335,-6.6245191
18.434949, 1.7955,0.089775, 6.6241811,0.9463116, 0.094631169,-9.3684848
0, 1.885275,0.1197, 0,2.9925, 0.089775,-2.902725
345.96376, 1.97505,0.1197, 2.9031514,0.72578788, 0.12338395,-12.21501
315, 2.09475,0.089775, 2.1160171,2.1160171, 0.042320354,-4.1897137
270, 2.124675,0.05985, 0,2.9925, 0.029925,-2.962575
225, 2.124675,0.029925, 2.1160171,2.1160171, 0.042320354,-4.1897137
198.43495, 2.09475,2.9925, 6.6241811,0.9463116, 0.094631169,-9.3684848
180, 2.004975,2.962575, 0,2.9925, 0.089775,-2.902725
165.96376, 1.9152,2.962575, 2.9031514,0.72578788, 0.12338395,-12.21501
153.43495, 1.7955,0, 2.6765734,1.3382867, 0.066914335,-6.6245191
90, 1.73565,0.029925, 0,2.9925, 0.029925,-2.962575
270, 1.466325,0.1197, 0,2.9925, 0.029925,-2.962575
315, 1.466325,0.089775, 2.1160171,2.1160171, 0.084640679,-4.1473934
333.43495, 1.526175,0.029925, 2.6765734,1.3382867, 0.066914335,-6.6245191
26.565051, 1.645875,0, 4.0148601,1.3382867, 0.066914335,-6.6245191
45, 1.705725,0.029925, 2.1160171,2.1160171, 0.042320354,-4.1897137
90, 1.73565,0.05985, 0,2.9925, 0.029925,-2.962575
135, 1.73565,0.089775, 2.1160171,2.1160171, 0.042320354,-4.1897137
153.43495, 1.705725,0.1197, 2.6765734,1.3382867, 0.066914335,-6.6245191
180, 1.6758,0.149625, 0,2.9925, 0.1197,-2.8728
198.43495, 1.5561,0.149625, 6.6241811,0.9463116, 0.094631169,-9.3684848
180, 1.466325,0.1197, 0,2.9925, 0.05985,-2.93265
153.43495, 1.406475,0.1197, 2.6765734,1.3382867, 0.066914335,-6.6245191
161.56505, 1.346625,0.149625, 2.8389347,0.9463116, 0.094631169,-9.3684848
116.56505, 1.25685,0.17955, 4.0148601,1.3382867, 0.066914335,-6.6245191
90, 1.226925,0.2394, 0,2.9925, 0.05985,-2.93265
45, 1.226925,0.29925, 2.1160171,2.1160171, 0.084640679,-4.1473934
0, 1.286775,0.3591, 0,2.9925, 0.05985,-2.93265
9.4623222, 1.346625,0.3591, 15.250883,0.49196398, 0.18202669,-18.020641
0, 1.526175,0.389025, 0,2.9925, 0.089775,-2.902725
341.56505, 1.61595,0.389025, 2.8389347,0.9463116, 0.094631169,-9.3684848
333.43495, 1.705725,0.3591, 2.6765734,1.3382867, 0.066914335,-6.6245191
296.56505, 1.765575,0.329175, 4.0148601,1.3382867, 0.066914335,-6.6245191
270, 1.7955,0.269325, 0,2.9925, 0.029925,-2.962575
243.43495, 1.7955,0.2394, 2.6765734,1.3382867, 0.066914335,-6.6245191
198.43495, 1.765575,0.17955, 6.6241811,0.9463116, 0.094631169,-9.3684848
180, 0.927675,0.41895, 0,2.9925, 0.089775,-2.902725
165.96376, 0.8379,0.41895, 2.9031514,0.72578788, 0.12338395,-12.21501
135, 0.7182,0.448875, 2.1160171,2.1160171, 0.042320354,-4.1897137
90, 0.688275,0.4788, 0,2.9925, 0.029925,-2.962575
63.434949, 0.688275,0.508725, 2.6765734,1.3382867, 0.066914335,-6.6245191
45, 0.7182,0.568575, 2.1160171,2.1160171, 0.084640679,-4.1473934
26.565051, 0.77805,0.628425, 4.0148601,1.3382867, 0.066914335,-6.6245191
0, 0.8379,0.65835, 0,2.9925, 0.05985,-2.93265
315, 0.89775,0.65835, 2.1160171,2.1160171, 0.084640679,-4.1473934
288.43495, 0.9576,0.5985, 6.6241811,0.9463116, 0.094631169,-9.3684848
270, 0.987525,0.508725, 0,2.9925, 0.05985,-2.93265
206.56505, 0.987525,0.448875, 4.0148601,1.3382867, 0.066914335,-6.6245191
135, 0.987525,1.167075, 2.1160171,2.1160171, 0.042320354,-4.1897137
90, 0.9576,1.197, 0,2.9925, 0.029925,-2.962575
63.434949, 0.9576,1.226925, 2.6765734,1.3382867, 0.066914335,-6.6245191
63.434949, 0.987525,1.286775, 2.6765734,1.3382867, 0.066914335,-6.6245191
26.565051, 1.01745,1.346625, 4.0148601,1.3382867, 0.066914335,-6.6245191
341.56505, 1.0773,1.37655, 2.8389347,0.9463116, 0.094631169,-9.3684848
315, 1.167075,1.346625, 2.1160171,2.1160171, 0.084640679,-4.1473934
270, 1.226925,1.286775, 0,2.9925, 0.05985,-2.93265
213.69007, 1.226925,1.226925, 4.1498508,0.82997018, 0.10789611,-10.681716
206.56505, 1.13715,1.167075, 4.0148601,1.3382867, 0.066914335,-6.6245191
116.56505, 0.568575,1.0773, 4.0148601,1.3382867, 0.066914335,-6.6245191
135, 0.53865,1.13715, 2.1160171,2.1160171, 0.042320354,-4.1897137
180, 0.508725,1.167075, 0,2.9925, 0.05985,-2.93265
206.56505, 0.448875,1.167075, 4.0148601,1.3382867, 0.066914335,-6.6245191
243.43495, 0.389025,1.13715, 2.6765734,1.3382867, 0.066914335,-6.6245191
270, 0.3591,1.0773, 0,2.9925, 0.05985,-2.93265
315, 0.3591,1.01745, 2.1160171,2.1160171, 0.042320354,-4.1897137
333.43495, 0.389025,0.987525, 2.6765734,1.3382867, 0.066914335,-6.6245191
0, 0.448875,0.9576, 0,2.9925, 0.05985,-2.93265
45, 0.508725,0.9576, 2.1160171,2.1160171, 0.042320354,-4.1897137
153.43495, 0.628425,0.89775, 2.6765734,1.3382867, 0.066914335,-6.6245191
116.56505, 0.568575,0.927675, 4.0148601,1.3382867, 0.066914335,-6.6245191
71.565051, 0.53865,0.987525, 2.8389347,0.9463116, 0.094631169,-9.3684848
45, 0.568575,1.0773, 2.1160171,2.1160171, 0.084640679,-4.1473934
0, 0.628425,1.13715, 0,2.9925, 0.1197,-2.8728
315, 0.748125,1.13715, 2.1160171,2.1160171, 0.084640679,-4.1473934
243.43495, 0.807975,1.0773, 2.6765734,1.3382867, 0.066914335,-6.6245191
225, 0.77805,1.01745, 2.1160171,2.1160171, 0.084640679,-4.1473934
213.69007, 0.7182,0.9576, 4.1498508,0.82997018, 0.10789611,-10.681716
146.30993, 0.807975,0.688275, 6.6397614,0.82997018, 0.10789611,-10.681716
108.43495, 0.7182,0.748125, 6.6241811,0.9463116, 0.094631169,-9.3684848
71.565051, 0.688275,0.8379, 2.8389347,0.9463116, 0.094631169,-9.3684848
56.309932, 0.7182,0.927675, 6.6397614,0.82997018, 0.10789611,-10.681716
56.309932, 0.77805,1.01745, 6.6397614,0.82997018, 0.10789611,-10.681716
26.565051, 0.8379,1.107225, 4.0148601,1.3382867, 0.066914335,-6.6245191
18.434949, 0.89775,1.13715, 6.6241811,0.9463116, 0.094631169,-9.3684848
341.56505, 0.987525,1.167075, 2.8389347,0.9463116, 0.094631169,-9.3684848
303.69007, 1.0773,1.13715, 4.1498508,0.82997018, 0.10789611,-10.681716
270, 1.13715,1.047375, 0,2.9925, 0.089775,-2.902725
243.43495, 1.13715,0.9576, 2.6765734,1.3382867, 0.066914335,-6.6245191
231.34019, 1.107225,0.89775, 14.9552,0.46734998, 0.19161349,-18.969735
213.69007, 0.987525,0.748125, 4.1498508,0.82997018, 0.10789611,-10.681716
180, 0.89775,0.688275, 0,2.9925, 0.05985,-2.93265
180, 0.8379,0.688275, 0,2.9925, 0.029925,-2.962575
0, 0.867825,1.4364, 0,2.9925, 0.05985,-2.93265
333.43495, 0.927675,1.4364, 2.6765734,1.3382867, 0.066914335,-6.6245191
296.56505, 0.987525,1.406475, 4.0148601,1.3382867, 0.066914335,-6.6245191
243.43495, 1.01745,1.346625, 2.6765734,1.3382867, 0.066914335,-6.6245191
236.30993, 0.987525,1.286775, 6.6397614,0.82997018, 0.10789611,-10.681716
213.69007, 0.927675,1.197, 4.1498508,0.82997018, 0.10789611,-10.681716
180, 0.8379,1.13715, 0,2.9925, 0.1197,-2.8728
180, 0.7182,1.13715, 0,2.9925, 0.089775,-2.902725
161.56505, 0.628425,1.13715, 2.8389347,0.9463116, 0.094631169,-9.3684848
180, 0.53865,1.167075, 0,2.9925, 0.1197,-2.8728
161.56505, 0.41895,1.167075, 2.8389347,0.9463116, 0.094631169,-9.3684848
135, 0.329175,1.197, 2.1160171,2.1160171, 0.042320354,-4.1897137
90, 0.29925,1.226925, 0,2.9925, 0.05985,-2.93265
63.434949, 0.29925,1.286775, 2.6765734,1.3382867, 0.066914335,-6.6245191
26.565051, 0.329175,1.346625, 4.0148601,1.3382867, 0.066914335,-6.6245191
8.1301023, 0.389025,1.37655, 18.197746,0.42320342, 0.21160171,-20.948569
0, 0.5985,1.406475, 0,2.9925, 0.089775,-2.902725
9.4623222, 0.688275,1.406475, 15.250883,0.49196398, 0.18202669,-18.020641
338.19859, 1.645875,1.286775, 9.4467861,0.5556933, 0.16115106,-15.953955
315, 1.7955,1.226925, 2.1160171,2.1160171, 0.042320354,-4.1897137
270, 1.825425,1.197, 0,2.9925, 0.029925,-2.962575
206.56505, 1.825425,1.167075, 4.0148601,1.3382867, 0.066914335,-6.6245191
206.56505, 1.765575,1.13715, 4.0148601,1.3382867, 0.066914335,-6.6245191
191.30993, 1.705725,1.107225, 12.324428,0.58687754, 0.15258817,-15.106228
194.03624, 1.5561,1.0773, 9.4352421,0.72578788, 0.12338395,-12.21501
191.30993, 1.4364,1.047375, 12.324428,0.58687754, 0.15258817,-15.106228
180, 1.286775,1.01745, 0,2.9925, 0.089775,-2.902725
153.43495, 1.197,1.01745, 2.6765734,1.3382867, 0.066914335,-6.6245191
116.56505, 1.13715,1.047375, 4.0148601,1.3382867, 0.066914335,-6.6245191
90, 1.107225,1.107225, 0,2.9925, 0.029925,-2.962575
33.690068, 1.107225,1.13715, 4.1498508,0.82997018, 0.10789611,-10.681716
33.690068, 1.197,1.197, 4.1498508,0.82997018, 0.10789611,-10.681716
26.565051, 1.286775,1.25685, 4.0148601,1.3382867, 0.066914335,-6.6245191
9.4623222, 1.346625,1.286775, 15.250883,0.49196398, 0.18202669,-18.020641
345.96376, 1.526175,1.3167, 2.9031514,0.72578788, 0.12338395,-12.21501
180, 2.09475,0.927675, 0,2.9925, 0.029925,-2.962575
153.43495, 2.064825,0.927675, 2.6765734,1.3382867, 0.066914335,-6.6245191
161.56505, 2.004975,0.9576, 2.8389347,0.9463116, 0.094631169,-9.3684848
180, 1.9152,0.987525, 0,2.9925, 0.05985,-2.93265
180, 1.85535,0.987525, 0,2.9925, 0.05985,-2.93265
153.43495, 1.7955,0.987525, 2.6765734,1.3382867, 0.066914335,-6.6245191
90, 1.73565,1.01745, 0,2.9925, 0.089775,-2.902725
45, 1.73565,1.107225, 2.1160171,2.1160171, 0.042320354,-4.1897137
0, 1.765575,1.13715, 0,2.9925, 0.089775,-2.902725
345.96376, 1.85535,1.13715, 2.9031514,0.72578788, 0.12338395,-12.21501
333.43495, 1.97505,1.107225, 2.6765734,1.3382867, 0.13382867,-6.5576048
315, 2.09475,1.047375, 2.1160171,2.1160171, 0.042320354,-4.1897137
270, 2.124675,1.01745, 0,2.9925, 0.05985,-2.93265
225, 2.124675,0.9576, 2.1160171,2.1160171, 0.042320354,-4.1897137
165.96376, 2.064825,0.53865, 2.9031514,0.72578788, 0.12338395,-12.21501
180, 1.945125,0.568575, 0,2.9925, 0.05985,-2.93265
116.56505, 1.885275,0.568575, 4.0148601,1.3382867, 0.066914335,-6.6245191
90, 1.85535,0.628425, 0,2.9925, 0.209475,-2.783025
108.43495, 1.85535,0.8379, 6.6241811,0.9463116, 0.094631169,-9.3684848
63.434949, 1.825425,0.927675, 2.6765734,1.3382867, 0.066914335,-6.6245191
0, 1.85535,0.987525, 0,2.9925, 0.05985,-2.93265
341.56505, 1.9152,0.987525, 2.8389347,0.9463116, 0.094631169,-9.3684848
315, 2.004975,0.9576, 2.1160171,2.1160171, 0.12696103,-4.1050731
284.03624, 2.09475,0.867825, 9.4352421,0.72578788, 0.12338395,-12.21501
296.56505, 2.124675,0.748125, 4.0148601,1.3382867, 0.066914335,-6.6245191
270, 2.1546,0.688275, 0,2.9925, 0.05985,-2.93265
243.43495, 2.1546,0.628425, 2.6765734,1.3382867, 0.066914335,-6.6245191
206.56505, 2.124675,0.568575, 4.0148601,1.3382867, 0.066914335,-6.6245191
270, 2.81295,0.89775, 0,2.9925, 0.089775,-2.902725
243.43495, 2.81295,0.807975, 2.6765734,1.3382867, 0.066914335,-6.6245191
206.56505, 2.783025,0.748125, 4.0148601,1.3382867, 0.066914335,-6.6245191
180, 2.723175,0.7182, 0,2.9925, 0.05985,-2.93265
153.43495, 2.663325,0.7182, 2.6765734,1.3382867, 0.066914335,-6.6245191
135, 2.603475,0.748125, 2.1160171,2.1160171, 0.042320354,-4.1897137
90, 2.57355,0.77805, 0,2.9925, 0.05985,-2.93265
71.565051, 2.57355,0.8379, 2.8389347,0.9463116, 0.094631169,-9.3684848
45, 2.603475,0.927675, 2.1160171,2.1160171, 0.042320354,-4.1897137
18.434949, 2.6334,0.9576, 6.6241811,0.9463116, 0.094631169,-9.3684848
333.43495, 2.723175,0.987525, 2.6765734,1.3382867, 0.066914335,-6.6245191
296.56505, 2.783025,0.9576, 4.0148601,1.3382867, 0.066914335,-6.6245191
63.434949, 2.394,1.107225, 2.6765734,1.3382867, 0.066914335,-6.6245191
45, 2.423925,1.167075, 2.1160171,2.1160171, 0.042320354,-4.1897137
21.801409, 2.45385,1.197, 6.6683196,0.5556933, 0.16115106,-15.953955
18.434949, 2.603475,1.25685, 6.6241811,0.9463116, 0.094631169,-9.3684848
0, 2.69325,1.286775, 0,2.9925, 0.089775,-2.902725
333.43495, 2.783025,1.286775, 2.6765734,1.3382867, 0.066914335,-6.6245191
296.56505, 2.842875,1.25685, 4.0148601,1.3382867, 0.066914335,-6.6245191
270, 2.8728,1.197, 0,2.9925, 0.05985,-2.93265
243.43495, 2.8728,1.13715, 2.6765734,1.3382867, 0.066914335,-6.6245191
225, 2.842875,1.0773, 2.1160171,2.1160171, 0.042320354,-4.1897137
213.69007, 2.81295,1.047375, 4.1498508,0.82997018, 0.10789611,-10.681716
194.03624, 2.723175,0.987525, 9.4352421,0.72578788, 0.12338395,-12.21501
180, 2.603475,0.9576, 0,2.9925, 0.05985,-2.93265
153.43495, 2.543625,0.9576, 2.6765734,1.3382867, 0.13382867,-6.5576048
116.56505, 2.423925,1.01745, 4.0148601,1.3382867, 0.066914335,-6.6245191
90, 2.394,1.0773, 0,2.9925, 0.029925,-2.962575
180, 2.962575,0.389025, 0,2.9925, 0.089775,-2.902725
135, 2.8728,0.389025, 2.1160171,2.1160171, 0.084640679,-4.1473934
90, 2.81295,0.448875, 0,2.9925, 0.089775,-2.902725
45, 2.81295,0.53865, 2.1160171,2.1160171, 0.084640679,-4.1473934
18.434949, 2.8728,0.5985, 6.6241811,0.9463116, 0.094631169,-9.3684848
0, 2.962575,0.628425, 0,2.9925, 0.029925,-2.962575
0, 0,0.628425, 0,2.9925, 0.05985,-2.93265
341.56505, 0.05985,0.628425, 2.8389347,0.9463116, 0.094631169,-9.3684848
315, 0.149625,0.5985, 2.1160171,2.1160171, 0.084640679,-4.1473934
296.56505, 0.209475,0.53865, 4.0148601,1.3382867, 0.066914335,-6.6245191
225, 0.2394,0.4788, 2.1160171,2.1160171, 0.084640679,-4.1473934
194.03624, 0.17955,0.41895, 9.4352421,0.72578788, 0.12338395,-12.21501
180, 0.05985,0.389025, 0,2.9925, 0.05985,-2.93265
180, 2.9925,0.389025, 0,2.9925, 0.029925,-2.962575
135, 2.7531,0.17955, 2.1160171,2.1160171, 0.042320354,-4.1897137
135, 2.723175,0.209475, 2.1160171,2.1160171, 0.042320354,-4.1897137
135, 2.69325,0.2394, 2.1160171,2.1160171, 0.042320354,-4.1897137
116.56505, 2.663325,0.269325, 4.0148601,1.3382867, 0.066914335,-6.6245191
90, 2.6334,0.329175, 0,2.9925, 0.05985,-2.93265
45, 2.6334,0.389025, 2.1160171,2.1160171, 0.084640679,-4.1473934
0, 2.69325,0.448875, 0,2.9925, 0.1197,-2.8728
315, 2.81295,0.448875, 2.1160171,2.1160171, 0.084640679,-4.1473934
0, 2.8728,0.389025, 0,2.9925, 0.089775,-2.902725
333.43495, 0,0.389025, 2.6765734,1.3382867, 0.066914335,-6.6245191
0, 2.962575,0.389025, 0,2.9925, 0.029925,-2.962575
270, 0.05985,0.3591, 0,2.9925, 0.05985,-2.93265
243.43495, 0.05985,0.29925, 2.6765734,1.3382867, 0.066914335,-6.6245191
180, 0.029925,0.2394, 0,2.9925, 0.029925,-2.962575
180, 2.9925,0.2394, 0,2.9925, 0.029925,-2.962575
198.43495, 2.962575,0.2394, 6.6241811,0.9463116, 0.094631169,-9.3684848
206.56505, 2.8728,0.209475, 4.0148601,1.3382867, 0.066914335,-6.6245191
180, 2.81295,0.17955, 0,2.9925, 0.05985,-2.93265
33.690068, 2.244375,0.269325, 4.1498508,0.82997018, 0.10789611,-10.681716
0, 2.33415,0.329175, 0,2.9925, 0.05985,-2.93265
341.56505, 2.394,0.329175, 2.8389347,0.9463116, 0.094631169,-9.3684848
0, 2.483775,0.29925, 0,2.9925, 0.089775,-2.902725
333.43495, 2.57355,0.29925, 2.6765734,1.3382867, 0.066914335,-6.6245191
326.30993, 2.6334,0.269325, 6.6397614,0.82997018, 0.10789611,-10.681716
315, 2.723175,0.209475, 2.1160171,2.1160171, 0.042320354,-4.1897137
270, 2.7531,0.17955, 0,2.9925, 0.05985,-2.93265
243.43495, 2.7531,0.1197, 2.6765734,1.3382867, 0.066914335,-6.6245191
206.56505, 2.723175,0.05985, 4.0148601,1.3382867, 0.066914335,-6.6245191
161.56505, 2.663325,0.029925, 2.8389347,0.9463116, 0.094631169,-9.3684848
153.43495, 2.57355,0.05985, 2.6765734,1.3382867, 0.066914335,-6.6245191
161.56505, 2.5137,0.089775, 2.8389347,0.9463116, 0.094631169,-9.3684848
180, 2.423925,0.1197, 0,2.9925, 0.089775,-2.902725
146.30993, 2.33415,0.1197, 6.6397614,0.82997018, 0.10789611,-10.681716
90, 2.244375,0.17955, 0,2.9925, 0.089775,-2.902725
18.434949, 2.004975,0.1197, 6.6241811,0.9463116, 0.094631169,-9.3684848
0, 2.09475,0.149625, 0,2.9925, 0.05985,-2.93265
45, 2.1546,0.149625, 2.1160171,2.1160171, 0.084640679,-4.1473934
63.434949, 2.21445,0.209475, 2.6765734,1.3382867, 0.066914335,-6.6245191
90, 2.244375,0.269325, 0,2.9925, 0.029925,-2.962575
108.43495, 2.244375,0.29925, 6.6241811,0.9463116, 0.094631169,-9.3684848
135, 2.21445,0.389025, 2.1160171,2.1160171, 0.12696103,-4.1050731
135, 2.124675,0.4788, 2.1160171,2.1160171, 0.084640679,-4.1473934
165.96376, 2.064825,0.53865, 2.9031514,0.72578788, 0.12338395,-12.21501
180, 1.945125,0.568575, 0,2.9925, 0.05985,-2.93265
225, 1.885275,0.568575, 2.1160171,2.1160171, 0.084640679,-4.1473934
243.43495, 1.825425,0.508725, 2.6765734,1.3382867, 0.066914335,-6.6245191
270, 1.7955,0.448875, 0,2.9925, 0.089775,-2.902725
270, 1.7955,0.3591, 0,2.9925, 0.1197,-2.8728
288.43495, 1.7955,0.2394, 6.6241811,0.9463116, 0.094631169,-9.3684848
333.43495, 1.825425,0.149625, 2.6765734,1.3382867, 0.066914335,-6.6245191
0, 1.885275,0.1197, 0,2.9925, 0.1197,-2.8728
251.56505, 0.3591,0.269325, 2.8389347,0.9463116, 0.094631169,-9.3684848
180, 0.329175,0.17955, 0,2.9925, 0.05985,-2.93265
161.56505, 0.269325,0.17955, 2.8389347,0.9463116, 0.094631169,-9.3684848
153.43495, 0.17955,0.209475, 2.6765734,1.3382867, 0.066914335,-6.6245191
135, 0.1197,0.2394, 2.1160171,2.1160171, 0.042320354,-4.1897137
116.56505, 0.089775,0.269325, 4.0148601,1.3382867, 0.066914335,-6.6245191
63.434949, 0.05985,0.329175, 2.6765734,1.3382867, 0.066914335,-6.6245191
26.565051, 0.089775,0.389025, 4.0148601,1.3382867, 0.066914335,-6.6245191
0, 0.149625,0.41895, 0,2.9925, 0.05985,-2.93265
333.43495, 0.209475,0.41895, 2.6765734,1.3382867, 0.13382867,-6.5576048
288.43495, 0.329175,0.3591, 6.6241811,0.9463116, 0.094631169,-9.3684848
75.963757, 0.3591,0.2394, 2.9031514,0.72578788, 0.12338395,-12.21501
63.434949, 0.389025,0.3591, 2.6765734,1.3382867, 0.066914335,-6.6245191
14.036243, 0.41895,0.41895, 9.4352421,0.72578788, 0.12338395,-12.21501
341.56505, 0.53865,0.448875, 2.8389347,0.9463116, 0.094631169,-9.3684848
296.56505, 0.628425,0.41895, 4.0148601,1.3382867, 0.066914335,-6.6245191
281.30993, 0.65835,0.3591, 12.324428,0.58687754, 0.15258817,-15.106228
281.30993, 0.688275,0.209475, 12.324428,0.58687754, 0.15258817,-15.106228
270, 0.7182,0.05985, 0,2.9925, 0.05985,-2.93265
270, 0.7182,2.9925, 0,2.9925, 0.05985,-2.93265
243.43495, 0.7182,2.93265, 2.6765734,1.3382867, 0.066914335,-6.6245191
198.43495, 0.688275,2.8728, 6.6241811,0.9463116, 0.094631169,-9.3684848
180, 0.5985,2.842875, 0,2.9925, 0.17955,-2.81295
161.56505, 0.41895,2.842875, 2.8389347,0.9463116, 0.094631169,-9.3684848
116.56505, 0.329175,2.8728, 4.0148601,1.3382867, 0.066914335,-6.6245191
90, 0.29925,2.93265, 0,2.9925, 0.05985,-2.93265
75.963757, 0.29925,0, 2.9031514,0.72578788, 0.12338395,-12.21501
75.963757, 0.329175,0.1197, 2.9031514,0.72578788, 0.12338395,-12.21501
26.565051, 2.8728,0.17955, 4.0148601,1.3382867, 0.13382867,-6.5576048
0, 0,0.2394, 0,2.9925, 0.05985,-2.93265
341.56505, 0.05985,0.2394, 2.8389347,0.9463116, 0.094631169,-9.3684848
341.56505, 0.149625,0.209475, 2.8389347,0.9463116, 0.094631169,-9.3684848
315, 0.2394,0.17955, 2.1160171,2.1160171, 0.084640679,-4.1473934
270, 0.29925,0.1197, 0,2.9925, 0.089775,-2.902725
270, 0.29925,0.029925, 0,2.9925, 0.029925,-2.962575
270, 0.29925,2.9925, 0,2.9925, 0.089775,-2.902725
258.69007, 0.29925,2.902725, 2.9343876,0.58687754, 0.15258817,-15.106228
198.43495, 0.269325,2.7531, 6.6241811,0.9463116, 0.094631169,-9.3684848
180, 0.17955,2.723175, 0,2.9925, 0.149625,-2.842875
180, 0.029925,2.723175, 0,2.9925, 0.029925,-2.962575
206.56505, 2.9925,2.723175, 4.0148601,1.3382867, 0.066914335,-6.6245191
180, 2.93265,2.69325, 0,2.9925, 0.05985,-2.93265
146.30993, 2.8728,2.69325, 6.6397614,0.82997018, 0.10789611,-10.681716
116.56505, 2.783025,2.7531, 4.0148601,1.3382867, 0.066914335,-6.6245191
108.43495, 2.7531,2.81295, 6.6241811,0.9463116, 0.094631169,-9.3684848
90, 2.723175,2.902725, 0,2.9925, 0.05985,-2.93265
71.565051, 2.7531,0, 2.8389347,0.9463116, 0.094631169,-9.3684848
45, 2.723175,2.962575, 2.1160171,2.1160171, 0.042320354,-4.1897137
45, 2.783025,0.089775, 2.1160171,2.1160171, 0.12696103,-4.1050731
165.96376, 1.765575,1.25685, 2.9031514,0.72578788, 0.12338395,-12.21501
161.56505, 1.645875,1.286775, 2.8389347,0.9463116, 0.094631169,-9.3684848
116.56505, 1.5561,1.3167, 4.0148601,1.3382867, 0.066914335,-6.6245191
45, 1.526175,1.37655, 2.1160171,2.1160171, 0.084640679,-4.1473934
345.96376, 1.586025,1.4364, 2.9031514,0.72578788, 0.12338395,-12.21501
333.43495, 1.705725,1.406475, 2.6765734,1.3382867, 0.13382867,-6.5576048
270, 1.825425,1.346625, 0,2.9925, 0.05985,-2.93265
206.56505, 1.825425,1.286775, 4.0148601,1.3382867, 0.066914335,-6.6245191
165.96376, 1.705725,1.406475, 2.9031514,0.72578788, 0.12338395,-12.21501
90, 1.586025,1.4364, 0,2.9925, 0.05985,-2.93265
45, 1.586025,1.49625, 2.1160171,2.1160171, 0.042320354,-4.1897137
18.434949, 1.61595,1.526175, 6.6241811,0.9463116, 0.094631169,-9.3684848
345.96376, 1.705725,1.5561, 2.9031514,0.72578788, 0.12338395,-12.21501
345.96376, 1.825425,1.526175, 2.9031514,0.72578788, 0.12338395,-12.21501
270, 1.945125,1.49625, 0,2.9925, 0.05985,-2.93265
213.69007, 1.945125,1.4364, 4.1498508,0.82997018, 0.10789611,-10.681716
168.69007, 1.85535,1.37655, 2.9343876,0.58687754, 0.15258817,-15.106228
11.309932, 1.73565,1.61595, 12.324428,0.58687754, 0.15258817,-15.106228
0, 1.885275,1.645875, 0,2.9925, 0.149625,-2.842875
341.56505, 2.0349,1.645875, 2.8389347,0.9463116, 0.094631169,-9.3684848
270, 2.124675,1.61595, 0,2.9925, 0.05985,-2.93265
206.56505, 2.124675,1.5561, 4.0148601,1.3382867, 0.13382867,-6.5576048
180, 2.004975,1.49625, 0,2.9925, 0.05985,-2.93265
165.96376, 1.945125,1.49625, 2.9031514,0.72578788, 0.12338395,-12.21501
161.56505, 1.825425,1.526175, 2.8389347,0.9463116, 0.094631169,-9.3684848
90, 1.73565,1.5561, 0,2.9925, 0.029925,-2.962575
90, 1.73565,1.586025, 0,2.9925, 0.029925,-2.962575
243.43495, 1.49625,1.6758, 2.6765734,1.3382867, 0.066914335,-6.6245191
315, 1.466325,1.61595, 2.1160171,2.1160171, 0.084640679,-4.1473934
341.56505, 1.526175,1.5561, 2.8389347,0.9463116, 0.094631169,-9.3684848
18.434949, 1.61595,1.526175, 6.6241811,0.9463116, 0.094631169,-9.3684848
45, 1.705725,1.5561, 2.1160171,2.1160171, 0.042320354,-4.1897137
116.56505, 1.73565,1.586025, 4.0148601,1.3382867, 0.066914335,-6.6245191
45, 1.226925,1.825425, 2.1160171,2.1160171, 0.084640679,-4.1473934
18.434949, 1.286775,1.885275, 6.6241811,0.9463116, 0.094631169,-9.3684848
354.80557, 1.37655,1.9152, 2.9802104,0.27092824, 0.33053242,-32.722711
350.53768, 1.705725,1.885275, 2.9517838,0.49196398, 0.18202669,-18.020641
341.56505, 1.885275,1.85535, 2.8389347,0.9463116, 0.094631169,-9.3684848
315, 1.97505,1.825425, 2.1160171,2.1160171, 0.042320354,-4.1897137
270, 2.004975,1.7955, 0,2.9925, 0.089775,-2.902725
225, 2.004975,1.705725, 2.1160171,2.1160171, 0.042320354,-4.1897137
198.43495, 1.97505,1.6758, 6.6241811,0.9463116, 0.094631169,-9.3684848
180, 1.885275,1.645875, 0,2.9925, 0.149625,-2.842875
168.69007, 1.73565,1.645875, 2.9343876,0.58687754, 0.15258817,-15.106228
180, 1.586025,1.6758, 0,2.9925, 0.17955,-2.81295
165.96376, 1.406475,1.6758, 2.9031514,0.72578788, 0.12338395,-12.21501
135, 1.286775,1.705725, 2.1160171,2.1160171, 0.084640679,-4.1473934
153.43495, 2.184525,1.85535, 2.6765734,1.3382867, 0.066914335,-6.6245191
198.43495, 2.124675,1.885275, 6.6241811,0.9463116, 0.094631169,-9.3684848
243.43495, 2.0349,1.85535, 2.6765734,1.3382867, 0.066914335,-6.6245191
270, 2.004975,1.7955, 0,2.9925, 0.05985,-2.93265
288.43495, 2.004975,1.73565, 6.6241811,0.9463116, 0.094631169,-9.3684848
341.56505, 2.0349,1.645875, 2.8389347,0.9463116, 0.094631169,-9.3684848
26.565051, 2.124675,1.61595, 4.0148601,1.3382867, 0.066914335,-6.6245191
45, 2.184525,1.645875, 2.1160171,2.1160171, 0.084640679,-4.1473934
90, 2.244375,1.705725, 0,2.9925, 0.05985,-2.93265
123.69007, 2.244375,1.765575, 4.1498508,0.82997018, 0.10789611,-10.681716
180, 0.807975,1.61595, 0,2.9925, 0.029925,-2.962575
135, 0.77805,1.61595, 2.1160171,2.1160171, 0.084640679,-4.1473934
116.56505, 0.7182,1.6758, 4.0148601,1.3382867, 0.066914335,-6.6245191
71.565051, 0.688275,1.73565, 2.8389347,0.9463116, 0.094631169,-9.3684848
56.309932, 0.7182,1.825425, 6.6397614,0.82997018, 0.10789611,-10.681716
11.309932, 0.77805,1.9152, 12.324428,0.58687754, 0.15258817,-15.106228
333.43495, 0.927675,1.945125, 2.6765734,1.3382867, 0.13382867,-6.5576048
0, 1.047375,1.885275, 0,2.9925, 0.089775,-2.902725
326.30993, 1.13715,1.885275, 6.6397614,0.82997018, 0.10789611,-10.681716
270, 1.226925,1.825425, 0,2.9925, 0.05985,-2.93265
225, 1.226925,1.765575, 2.1160171,2.1160171, 0.084640679,-4.1473934
18.434949, 0.628425,1.7955, 6.6241811,0.9463116, 0.094631169,-9.3684848
90, 0.7182,1.825425, 0,2.9925, 0.029925,-2.962575
116.56505, 0.7182,1.85535, 4.0148601,1.3382867, 0.066914335,-6.6245191
180, 0.688275,1.9152, 0,2.9925, 0.1197,-2.8728
191.30993, 0.568575,1.9152, 12.324428,0.58687754, 0.15258817,-15.106228
225, 0.41895,1.885275, 2.1160171,2.1160171, 0.042320354,-4.1897137
270, 0.389025,1.85535, 0,2.9925, 0.029925,-2.962575
315, 0.389025,1.825425, 2.1160171,2.1160171, 0.042320354,-4.1897137
281.30993, 0.688275,1.73565, 12.324428,0.58687754, 0.15258817,-15.106228
270, 0.7182,1.586025, 0,2.9925, 0.089775,-2.902725
236.30993, 0.7182,1.49625, 6.6397614,0.82997018, 0.10789611,-10.681716
180, 0.65835,1.406475, 0,2.9925, 0.1197,-2.8728
180, 0.53865,1.406475, 0,2.9925, 0.149625,-2.842875
153.43495, 0.389025,1.406475, 2.6765734,1.3382867, 0.066914335,-6.6245191
108.43495, 0.329175,1.4364, 6.6241811,0.9463116, 0.094631169,-9.3684848
90, 0.29925,1.526175, 0,2.9925, 0.089775,-2.902725
71.565051, 0.29925,1.61595, 2.8389347,0.9463116, 0.094631169,-9.3684848
45, 0.329175,1.705725, 2.1160171,2.1160171, 0.12696103,-4.1050731
0, 0.41895,1.7955, 0,2.9925, 0.209475,-2.783025
315, 0.628425,1.7955, 2.1160171,2.1160171, 0.084640679,-4.1473934
26.565051, 1.13715,0.17955, 4.0148601,1.3382867, 0.066914335,-6.6245191
45, 1.197,0.209475, 2.1160171,2.1160171, 0.042320354,-4.1897137
90, 1.226925,0.2394, 0,2.9925, 0.05985,-2.93265
116.56505, 1.226925,0.29925, 4.0148601,1.3382867, 0.066914335,-6.6245191
161.56505, 1.197,0.3591, 2.8389347,0.9463116, 0.094631169,-9.3684848
161.56505, 1.107225,0.389025, 2.8389347,0.9463116, 0.094631169,-9.3684848
180, 1.01745,0.41895, 0,2.9925, 0.1197,-2.8728
194.03624, 0.89775,0.41895, 9.4352421,0.72578788, 0.12338395,-12.21501
236.30993, 0.77805,0.389025, 6.6397614,0.82997018, 0.10789611,-10.681716
251.56505, 0.7182,0.29925, 2.8389347,0.9463116, 0.094631169,-9.3684848
288.43495, 0.688275,0.209475, 6.6241811,0.9463116, 0.094631169,-9.3684848
333.43495, 0.7182,0.1197, 2.6765734,1.3382867, 0.066914335,-6.6245191
11.309932, 0.77805,0.089775, 12.324428,0.58687754, 0.15258817,-15.106228
191.30993, 1.466325,2.783025, 12.324428,0.58687754, 0.15258817,-15.106228
161.56505, 1.3167,2.7531, 2.8389347,0.9463116, 0.094631169,-9.3684848
146.30993, 1.226925,2.783025, 6.6397614,0.82997018, 0.10789611,-10.681716
161.56505, 1.13715,2.842875, 2.8389347,0.9463116, 0.094631169,-9.3684848
171.8699, 1.047375,2.8728, 2.9624239,0.42320342, 0.21160171,-20.948569
161.56505, 0.8379,2.902725, 2.8389347,0.9463116, 0.094631169,-9.3684848
116.56505, 0.748125,2.93265, 4.0148601,1.3382867, 0.066914335,-6.6245191
63.434949, 0.7182,0, 2.6765734,1.3382867, 0.066914335,-6.6245191
26.565051, 0.748125,0.05985, 4.0148601,1.3382867, 0.066914335,-6.6245191
14.036243, 0.807975,0.089775, 9.4352421,0.72578788, 0.12338395,-12.21501
18.434949, 0.927675,0.1197, 6.6241811,0.9463116, 0.094631169,-9.3684848
14.036243, 1.01745,0.149625, 9.4352421,0.72578788, 0.12338395,-12.21501
0, 1.13715,0.17955, 0,2.9925, 0.089775,-2.902725
345.96376, 1.226925,0.17955, 2.9031514,0.72578788, 0.12338395,-12.21501
333.43495, 1.346625,0.149625, 2.6765734,1.3382867, 0.13382867,-6.5576048
315, 1.466325,0.089775, 2.1160171,2.1160171, 0.12696103,-4.1050731
270, 1.5561,2.9925, 0,2.9925, 0.05985,-2.93265
255.96376, 1.5561,2.93265, 2.9031514,0.72578788, 0.12338395,-12.21501
206.56505, 1.526175,2.81295, 4.0148601,1.3382867, 0.066914335,-6.6245191
0, 0.089775,1.25685, 0,2.9925, 0.1197,-2.8728
341.56505, 0.209475,1.25685, 2.8389347,0.9463116, 0.094631169,-9.3684848
315, 0.29925,1.226925, 2.1160171,2.1160171, 0.084640679,-4.1473934
270, 0.3591,1.167075, 0,2.9925, 0.05985,-2.93265
258.69007, 0.3591,1.107225, 2.9343876,0.58687754, 0.15258817,-15.106228
236.30993, 0.329175,0.9576, 6.6397614,0.82997018, 0.10789611,-10.681716
225, 0.269325,0.867825, 2.1160171,2.1160171, 0.12696103,-4.1050731
225, 0.17955,0.77805, 2.1160171,2.1160171, 0.12696103,-4.1050731
180, 2.9925,0.628425, 0,2.9925, 0.029925,-2.962575
213.69007, 0.089775,0.688275, 4.1498508,0.82997018, 0.10789611,-10.681716
180, 2.962575,0.628425, 0,2.9925, 0.05985,-2.93265
153.43495, 2.902725,0.628425, 2.6765734,1.3382867, 0.066914335,-6.6245191
101.30993, 2.842875,0.65835, 12.324428,0.58687754, 0.15258817,-15.106228
90, 2.81295,0.807975, 0,2.9925, 0.1197,-2.8728
75.963757, 2.81295,0.927675, 2.9031514,0.72578788, 0.12338395,-12.21501
71.565051, 2.842875,1.047375, 2.8389347,0.9463116, 0.094631169,-9.3684848
36.869898, 2.8728,1.13715, 4.1895,0.5985, 0.149625,-14.812875
18.434949, 0,1.226925, 6.6241811,0.9463116, 0.094631169,-9.3684848
213.69007, 2.783025,0.508725, 4.1498508,0.82997018, 0.10789611,-10.681716
206.56505, 2.69325,0.448875, 4.0148601,1.3382867, 0.066914335,-6.6245191
225, 2.6334,0.41895, 2.1160171,2.1160171, 0.084640679,-4.1473934
206.56505, 2.57355,0.3591, 4.0148601,1.3382867, 0.066914335,-6.6245191
180, 2.5137,0.329175, 0,2.9925, 0.05985,-2.93265
180, 2.45385,0.329175, 0,2.9925, 0.149625,-2.842875
146.30993, 2.304225,0.329175, 6.6397614,0.82997018, 0.10789611,-10.681716
116.56505, 2.21445,0.389025, 4.0148601,1.3382867, 0.066914335,-6.6245191
108.43495, 2.184525,0.448875, 6.6241811,0.9463116, 0.094631169,-9.3684848
90, 2.1546,0.53865, 0,2.9925, 0.089775,-2.902725
63.434949, 2.1546,0.628425, 2.6765734,1.3382867, 0.066914335,-6.6245191
26.565051, 2.184525,0.688275, 4.0148601,1.3382867, 0.066914335,-6.6245191
0, 2.244375,0.7182, 0,2.9925, 0.269325,-2.723175
352.87498, 2.5137,0.7182, 2.9693915,0.37117393, 0.24126306,-23.885043
341.56505, 2.7531,0.688275, 2.8389347,0.9463116, 0.094631169,-9.3684848
270, 2.842875,0.65835, 0,2.9925, 0.05985,-2.93265
243.43495, 2.842875,0.5985, 2.6765734,1.3382867, 0.066914335,-6.6245191
225, 2.81295,0.53865, 2.1160171,2.1160171, 0.042320354,-4.1897137
194.03624, 1.4364,1.3167, 9.4352421,0.72578788, 0.12338395,-12.21501
180, 1.3167,1.286775, 0,2.9925, 0.05985,-2.93265
146.30993, 1.25685,1.286775, 6.6397614,0.82997018, 0.10789611,-10.681716
146.30993, 1.167075,1.346625, 6.6397614,0.82997018, 0.10789611,-10.681716
161.56505, 1.0773,1.406475, 2.8389347,0.9463116, 0.094631169,-9.3684848
180, 0.987525,1.4364, 0,2.9925, 0.1197,-2.8728
161.56505, 0.867825,1.4364, 2.8389347,0.9463116, 0.094631169,-9.3684848
135, 0.77805,1.466325, 2.1160171,2.1160171, 0.042320354,-4.1897137
90, 0.748125,1.49625, 0,2.9925, 0.05985,-2.93265
45, 0.748125,1.5561, 2.1160171,2.1160171, 0.084640679,-4.1473934
18.434949, 0.807975,1.61595, 6.6241811,0.9463116, 0.094631169,-9.3684848
21.801409, 0.89775,1.645875, 6.6683196,0.5556933, 0.16115106,-15.953955
0, 1.047375,1.705725, 0,2.9925, 0.149625,-2.842875
348.69007, 1.197,1.705725, 2.9343876,0.58687754, 0.15258817,-15.106228
333.43495, 1.346625,1.6758, 2.6765734,1.3382867, 0.13382867,-6.5576048
315, 1.466325,1.61595, 2.1160171,2.1160171, 0.084640679,-4.1473934
296.56505, 1.526175,1.5561, 4.0148601,1.3382867, 0.066914335,-6.6245191
270, 1.5561,1.49625, 0,2.9925, 0.089775,-2.902725
225, 1.5561,1.406475, 2.1160171,2.1160171, 0.084640679,-4.1473934
206.56505, 1.49625,1.346625, 4.0148601,1.3382867, 0.066914335,-6.6245191
194.03624, 0.53865,0.448875, 9.4352421,0.72578788, 0.12338395,-12.21501
180, 0.41895,0.41895, 0,2.9925, 0.05985,-2.93265
153.43495, 0.3591,0.41895, 2.6765734,1.3382867, 0.066914335,-6.6245191
135, 0.29925,0.448875, 2.1160171,2.1160171, 0.084640679,-4.1473934
135, 0.2394,0.508725, 2.1160171,2.1160171, 0.084640679,-4.1473934
116.56505, 0.17955,0.568575, 4.0148601,1.3382867, 0.066914335,-6.6245191
90, 0.149625,0.628425, 0,2.9925, 0.05985,-2.93265
71.565051, 0.149625,0.688275, 2.8389347,0.9463116, 0.094631169,-9.3684848
45, 0.17955,0.77805, 2.1160171,2.1160171, 0.12696103,-4.1050731
33.690068, 0.269325,0.867825, 4.1498508,0.82997018, 0.10789611,-10.681716
14.036243, 0.3591,0.927675, 9.4352421,0.72578788, 0.12338395,-12.21501
341.56505, 0.4788,0.9576, 2.8389347,0.9463116, 0.094631169,-9.3684848
333.43495, 0.568575,0.927675, 2.6765734,1.3382867, 0.066914335,-6.6245191
315, 0.628425,0.89775, 2.1160171,2.1160171, 0.084640679,-4.1473934
288.43495, 0.688275,0.8379, 6.6241811,0.9463116, 0.094631169,-9.3684848
288.43495, 0.7182,0.748125, 6.6241811,0.9463116, 0.094631169,-9.3684848
71.565051, 0.7182,0.568575, 2.8389347,0.9463116, 0.094631169,-9.3684848
225, 0.77805,0.628425, 2.1160171,2.1160171, 0.084640679,-4.1473934
213.69007, 0.7182,0.568575, 4.1498508,0.82997018, 0.10789611,-10.681716
213.69007, 0.628425,0.508725, 4.1498508,0.82997018, 0.10789611,-10.681716
206.56505, 2.663325,1.286775, 4.0148601,1.3382867, 0.066914335,-6.6245191
201.80141, 2.603475,1.25685, 6.6683196,0.5556933, 0.16115106,-15.953955
225, 2.45385,1.197, 2.1160171,2.1160171, 0.042320354,-4.1897137
243.43495, 2.423925,1.167075, 2.6765734,1.3382867, 0.066914335,-6.6245191
225, 2.394,1.107225, 2.1160171,2.1160171, 0.042320354,-4.1897137
206.56505, 2.364075,1.0773, 4.0148601,1.3382867, 0.066914335,-6.6245191
198.43495, 2.304225,1.047375, 6.6241811,0.9463116, 0.094631169,-9.3684848
180, 2.21445,1.01745, 0,2.9925, 0.05985,-2.93265
153.43495, 2.1546,1.01745, 2.6765734,1.3382867, 0.13382867,-6.5576048
153.43495, 2.0349,1.0773, 2.6765734,1.3382867, 0.13382867,-6.5576048
135, 1.9152,1.13715, 2.1160171,2.1160171, 0.084640679,-4.1473934
116.56505, 1.85535,1.197, 4.0148601,1.3382867, 0.066914335,-6.6245191
90, 1.825425,1.25685, 0,2.9925, 0.05985,-2.93265
63.434949, 1.825425,1.3167, 2.6765734,1.3382867, 0.066914335,-6.6245191
26.565051, 1.85535,1.37655, 4.0148601,1.3382867, 0.13382867,-6.5576048
33.690068, 1.97505,1.4364, 4.1498508,0.82997018, 0.10789611,-10.681716
45, 2.064825,1.49625, 2.1160171,2.1160171, 0.084640679,-4.1473934
56.309932, 2.124675,1.5561, 6.6397614,0.82997018, 0.10789611,-10.681716
18.434949, 2.184525,1.645875, 6.6241811,0.9463116, 0.094631169,-9.3684848
0, 2.2743,1.6758, 0,2.9925, 0.1197,-2.8728
338.19859, 2.394,1.6758, 9.4467861,0.5556933, 0.16115106,-15.953955
315, 2.543625,1.61595, 2.1160171,2.1160171, 0.084640679,-4.1473934
315, 2.603475,1.5561, 2.1160171,2.1160171, 0.084640679,-4.1473934
296.56505, 2.663325,1.49625, 4.0148601,1.3382867, 0.066914335,-6.6245191
270, 2.69325,1.4364, 0,2.9925, 0.089775,-2.902725
243.43495, 2.69325,1.346625, 2.6765734,1.3382867, 0.066914335,-6.6245191
180, 1.346625,0.3591, 0,2.9925, 0.089775,-2.902725
168.69007, 1.25685,0.3591, 2.9343876,0.58687754, 0.15258817,-15.106228
146.30993, 1.107225,0.389025, 6.6397614,0.82997018, 0.10789611,-10.681716
108.43495, 1.01745,0.448875, 6.6241811,0.9463116, 0.094631169,-9.3684848
108.43495, 0.987525,0.53865, 6.6241811,0.9463116, 0.094631169,-9.3684848
75.963757, 0.9576,0.628425, 2.9031514,0.72578788, 0.12338395,-12.21501
51.340192, 0.987525,0.748125, 14.9552,0.46734998, 0.19161349,-18.969735
29.744881, 1.107225,0.89775, 17.445175,0.37117393, 0.24126306,-23.885043
6.3401918, 1.3167,1.01745, 24.124043,0.33046635, 0.27098239,-26.827257
348.69007, 1.586025,1.047375, 2.9343876,0.58687754, 0.15258817,-15.106228
315, 1.73565,1.01745, 2.1160171,2.1160171, 0.12696103,-4.1050731
288.43495, 1.825425,0.927675, 6.6241811,0.9463116, 0.094631169,-9.3684848
270, 1.85535,0.8379, 0,2.9925, 0.17955,-2.81295
251.56505, 1.85535,0.65835, 2.8389347,0.9463116, 0.18926231,-9.2738535
206.56505, 1.7955,0.4788, 4.0148601,1.3382867, 0.13382867,-6.5576048
191.30993, 1.6758,0.41895, 12.324428,0.58687754, 0.15258817,-15.106228
189.46232, 1.526175,0.389025, 15.250883,0.49196398, 0.18202669,-18.020641
341.56505, 0.17955,2.543625, 2.8389347,0.9463116, 0.094631169,-9.3684848
315, 0.269325,2.5137, 2.1160171,2.1160171, 0.084640679,-4.1473934
270, 0.329175,2.45385, 0,2.9925, 0.05985,-2.93265
251.56505, 0.329175,2.394, 2.8389347,0.9463116, 0.094631169,-9.3684848
225, 0.29925,2.304225, 2.1160171,2.1160171, 0.042320354,-4.1897137
180, 0.269325,2.2743, 0,2.9925, 0.05985,-2.93265
135, 0.209475,2.2743, 2.1160171,2.1160171, 0.084640679,-4.1473934
56.309932, 0.1197,2.45385, 6.6397614,0.82997018, 0.10789611,-10.681716
0, 0.568575,2.543625, 0,2.9925, 0.1197,-2.8728
9.4623222, 0.688275,2.543625, 15.250883,0.49196398, 0.18202669,-18.020641
0, 0.867825,2.57355, 0,2.9925, 0.1197,-2.8728
326.30993, 0.987525,2.57355, 6.6397614,0.82997018, 0.10789611,-10.681716
300.96376, 1.0773,2.5137, 10.7774,0.51320953, 0.17449124,-17.274632
270, 1.167075,2.364075, 0,2.9925, 0.1197,-2.8728
236.30993, 1.167075,2.244375, 6.6397614,0.82997018, 0.10789611,-10.681716
251.56505, 1.107225,2.1546, 2.8389347,0.9463116, 0.094631169,-9.3684848
213.69007, 1.0773,2.064825, 4.1498508,0.82997018, 0.10789611,-10.681716
198.43495, 0.987525,2.004975, 6.6241811,0.9463116, 0.094631169,-9.3684848
191.30993, 0.89775,1.97505, 12.324428,0.58687754, 0.15258817,-15.106228
180, 0.748125,1.945125, 0,2.9925, 0.149625,-2.842875
135, 0.5985,1.945125, 2.1160171,2.1160171, 0.084640679,-4.1473934
146.30993, 0.53865,2.004975, 6.6397614,0.82997018, 0.10789611,-10.681716
161.56505, 0.448875,2.064825, 2.8389347,0.9463116, 0.094631169,-9.3684848
123.69007, 0.3591,2.09475, 4.1498508,0.82997018, 0.10789611,-10.681716
90, 0.29925,2.184525, 0,2.9925, 0.05985,-2.93265
78.690068, 0.29925,2.244375, 2.9343876,0.58687754, 0.15258817,-15.106228
56.309932, 0.329175,2.394, 6.6397614,0.82997018, 0.10789611,-10.681716
45, 0.389025,2.483775, 2.1160171,2.1160171, 0.042320354,-4.1897137
26.565051, 0.41895,2.5137, 4.0148601,1.3382867, 0.066914335,-6.6245191
0, 0.4788,2.543625, 0,2.9925, 0.089775,-2.902725
326.30993, 0.329175,2.663325, 6.6397614,0.82997018, 0.10789611,-10.681716
333.43495, 0.41895,2.603475, 2.6765734,1.3382867, 0.066914335,-6.6245191
270, 0.4788,2.57355, 0,2.9925, 0.029925,-2.962575
206.56505, 0.4788,2.543625, 4.0148601,1.3382867, 0.066914335,-6.6245191
180, 0.41895,2.5137, 0,2.9925, 0.1197,-2.8728
165.96376, 0.29925,2.5137, 2.9031514,0.72578788, 0.12338395,-12.21501
135, 0.17955,2.543625, 2.1160171,2.1160171, 0.042320354,-4.1897137
116.56505, 0.149625,2.57355, 4.0148601,1.3382867, 0.066914335,-6.6245191
63.434949, 0.1197,2.6334, 2.6765734,1.3382867, 0.066914335,-6.6245191
26.565051, 0.149625,2.69325, 4.0148601,1.3382867, 0.066914335,-6.6245191
0, 0.209475,2.723175, 0,2.9925, 0.05985,-2.93265
315, 0.269325,2.723175, 2.1160171,2.1160171, 0.084640679,-4.1473934
236.30993, 0.987525,2.7531, 6.6397614,0.82997018, 0.10789611,-10.681716
225, 0.927675,2.663325, 2.1160171,2.1160171, 0.12696103,-4.1050731
191.30993, 0.8379,2.57355, 12.324428,0.58687754, 0.15258817,-15.106228
180, 0.688275,2.543625, 0,2.9925, 0.1197,-2.8728
158.19859, 0.568575,2.543625, 9.4467861,0.5556933, 0.16115106,-15.953955
146.30993, 0.41895,2.603475, 6.6397614,0.82997018, 0.10789611,-10.681716
116.56505, 0.329175,2.663325, 4.0148601,1.3382867, 0.066914335,-6.6245191
90, 0.29925,2.723175, 0,2.9925, 0.05985,-2.93265
45, 0.29925,2.783025, 2.1160171,2.1160171, 0.084640679,-4.1473934
0, 0.3591,2.842875, 0,2.9925, 0.2394,-2.7531
15.945396, 0.5985,2.842875, 9.4541842,0.41105148, 0.21785729,-21.567872
0, 0.807975,2.902725, 0,2.9925, 0.1197,-2.8728
326.30993, 0.927675,2.902725, 6.6397614,0.82997018, 0.10789611,-10.681716
251.56505, 1.01745,2.842875, 2.8389347,0.9463116, 0.094631169,-9.3684848
243.43495, 1.406475,1.97505, 2.6765734,1.3382867, 0.066914335,-6.6245191
180, 1.37655,1.9152, 0,2.9925, 0.1197,-2.8728
194.03624, 1.25685,1.9152, 9.4352421,0.72578788, 0.12338395,-12.21501
180, 1.13715,1.885275, 0,2.9925, 0.089775,-2.902725
135, 1.047375,1.885275, 2.1160171,2.1160171, 0.084640679,-4.1473934
90, 0.987525,1.945125, 0,2.9925, 0.05985,-2.93265
18.434949, 0.987525,2.004975, 6.6241811,0.9463116, 0.094631169,-9.3684848
14.036243, 1.0773,2.0349, 9.4352421,0.72578788, 0.12338395,-12.21501
0, 1.197,2.064825, 0,2.9925, 0.1197,-2.8728
326.30993, 1.3167,2.064825, 6.6397614,0.82997018, 0.10789611,-10.681716
270, 1.645875,2.004975, 0,2.9925, 0.05985,-2.93265
206.56505, 1.645875,1.945125, 4.0148601,1.3382867, 0.066914335,-6.6245191
180, 1.586025,1.9152, 0,2.9925, 0.089775,-2.902725
153.43495, 1.49625,1.9152, 2.6765734,1.3382867, 0.066914335,-6.6245191
135, 1.4364,1.945125, 2.1160171,2.1160171, 0.042320354,-4.1897137
90, 1.406475,1.97505, 0,2.9925, 0.05985,-2.93265
26.565051, 1.406475,2.0349, 4.0148601,1.3382867, 0.066914335,-6.6245191
0, 1.466325,2.064825, 0,2.9925, 0.1197,-2.8728
333.43495, 1.586025,2.064825, 2.6765734,1.3382867, 0.066914335,-6.6245191
180, 1.97505,1.85535, 0,2.9925, 0.089775,-2.902725
165.96376, 1.885275,1.85535, 2.9031514,0.72578788, 0.12338395,-12.21501
146.30993, 1.765575,1.885275, 6.6397614,0.82997018, 0.10789611,-10.681716
116.56505, 1.6758,1.945125, 4.0148601,1.3382867, 0.066914335,-6.6245191
90, 1.645875,2.004975, 0,2.9925, 0.05985,-2.93265
33.690068, 1.645875,2.064825, 4.1498508,0.82997018, 0.10789611,-10.681716
18.434949, 1.73565,2.124675, 6.6241811,0.9463116, 0.094631169,-9.3684848
0, 1.825425,2.1546, 0,2.9925, 0.1197,-2.8728
350.53768, 1.945125,2.1546, 2.9517838,0.49196398, 0.18202669,-18.020641
296.56505, 2.124675,2.124675, 4.0148601,1.3382867, 0.066914335,-6.6245191
270, 2.1546,2.064825, 0,2.9925, 0.1197,-2.8728
243.43495, 2.1546,1.945125, 2.6765734,1.3382867, 0.066914335,-6.6245191
198.43495, 2.124675,1.885275, 6.6241811,0.9463116, 0.094631169,-9.3684848
180, 2.0349,1.85535, 0,2.9925, 0.05985,-2.93265
180, 1.5561,2.064825, 0,2.9925, 0.269325,-2.723175
165.96376, 1.286775,2.064825, 2.9031514,0.72578788, 0.12338395,-12.21501
135, 1.167075,2.09475, 2.1160171,2.1160171, 0.042320354,-4.1897137
90, 1.13715,2.124675, 0,2.9925, 0.05985,-2.93265
63.434949, 1.13715,2.184525, 2.6765734,1.3382867, 0.066914335,-6.6245191
18.434949, 1.167075,2.244375, 6.6241811,0.9463116, 0.094631169,-9.3684848
11.309932, 1.25685,2.2743, 12.324428,0.58687754, 0.15258817,-15.106228
0, 1.406475,2.304225, 0,2.9925, 0.1197,-2.8728
0, 1.526175,2.304225, 0,2.9925, 0.1197,-2.8728
333.43495, 1.645875,2.304225, 2.6765734,1.3382867, 0.13382867,-6.5576048
296.56505, 1.765575,2.244375, 4.0148601,1.3382867, 0.066914335,-6.6245191
270, 1.7955,2.184525, 0,2.9925, 0.029925,-2.962575
206.56505, 1.7955,2.1546, 4.0148601,1.3382867, 0.066914335,-6.6245191
206.56505, 1.73565,2.124675, 4.0148601,1.3382867, 0.066914335,-6.6245191
206.56505, 1.6758,2.09475, 4.0148601,1.3382867, 0.066914335,-6.6245191
180, 1.61595,2.064825, 0,2.9925, 0.05985,-2.93265
63.434949, 0.9576,2.69325, 2.6765734,1.3382867, 0.066914335,-6.6245191
45, 0.987525,2.7531, 2.1160171,2.1160171, 0.084640679,-4.1473934
0, 1.047375,2.81295, 0,2.9925, 0.089775,-2.902725
341.56505, 1.13715,2.81295, 2.8389347,0.9463116, 0.094631169,-9.3684848
270, 1.226925,2.783025, 0,2.9925, 0.05985,-2.93265
243.43495, 1.226925,2.723175, 2.6765734,1.3382867, 0.066914335,-6.6245191
213.69007, 1.197,2.663325, 4.1498508,0.82997018, 0.10789611,-10.681716
180, 1.107225,2.603475, 0,2.9925, 0.05985,-2.93265
161.56505, 1.047375,2.603475, 2.8389347,0.9463116, 0.094631169,-9.3684848
90, 0.9576,2.6334, 0,2.9925, 0.05985,-2.93265
90, 1.5561,2.45385, 0,2.9925, 0.05985,-2.93265
26.565051, 1.5561,2.5137, 4.0148601,1.3382867, 0.066914335,-6.6245191
11.309932, 1.61595,2.543625, 12.324428,0.58687754, 0.15258817,-15.106228
315, 1.765575,2.57355, 2.1160171,2.1160171, 0.084640679,-4.1473934
251.56505, 1.825425,2.5137, 2.8389347,0.9463116, 0.094631169,-9.3684848
206.56505, 1.7955,2.423925, 4.0148601,1.3382867, 0.066914335,-6.6245191
180, 1.73565,2.394, 0,2.9925, 0.089775,-2.902725
146.30993, 1.645875,2.394, 6.6397614,0.82997018, 0.10789611,-10.681716
26.565051, 1.25685,2.483775, 4.0148601,1.3382867, 0.066914335,-6.6245191
0, 1.3167,2.5137, 0,2.9925, 0.1197,-2.8728
333.43495, 1.4364,2.5137, 2.6765734,1.3382867, 0.13382867,-6.5576048
296.56505, 1.5561,2.45385, 4.0148601,1.3382867, 0.066914335,-6.6245191
270, 1.586025,2.394, 0,2.9925, 0.05985,-2.93265
206.56505, 1.586025,2.33415, 4.0148601,1.3382867, 0.066914335,-6.6245191
180, 1.526175,2.304225, 0,2.9925, 0.1197,-2.8728
191.30993, 1.406475,2.304225, 12.324428,0.58687754, 0.15258817,-15.106228
153.43495, 1.25685,2.2743, 2.6765734,1.3382867, 0.066914335,-6.6245191
90, 1.197,2.304225, 0,2.9925, 0.05985,-2.93265
63.434949, 1.197,2.364075, 2.6765734,1.3382867, 0.066914335,-6.6245191
63.434949, 1.226925,2.423925, 2.6765734,1.3382867, 0.066914335,-6.6245191
21.801409, 1.25685,2.69325, 6.6683196,0.5556933, 0.16115106,-15.953955
0, 1.406475,2.7531, 0,2.9925, 0.149625,-2.842875
348.69007, 1.5561,2.7531, 2.9343876,0.58687754, 0.15258817,-15.106228
341.56505, 1.705725,2.723175, 2.8389347,0.9463116, 0.094631169,-9.3684848
296.56505, 1.7955,2.69325, 4.0148601,1.3382867, 0.066914335,-6.6245191
270, 1.825425,2.6334, 0,2.9925, 0.029925,-2.962575
198.43495, 1.825425,2.603475, 6.6241811,0.9463116, 0.094631169,-9.3684848
191.30993, 1.73565,2.57355, 12.324428,0.58687754, 0.15258817,-15.106228
191.30993, 1.586025,2.543625, 12.324428,0.58687754, 0.15258817,-15.106228
180, 1.4364,2.5137, 0,2.9925, 0.1197,-2.8728
206.56505, 1.3167,2.5137, 4.0148601,1.3382867, 0.066914335,-6.6245191
180, 1.25685,2.483775, 0,2.9925, 0.089775,-2.902725
153.43495, 1.167075,2.483775, 2.6765734,1.3382867, 0.066914335,-6.6245191
90, 1.107225,2.5137, 0,2.9925, 0.05985,-2.93265
45, 1.107225,2.57355, 2.1160171,2.1160171, 0.12696103,-4.1050731
26.565051, 1.197,2.663325, 4.0148601,1.3382867, 0.066914335,-6.6245191
18.434949, 1.9152,2.603475, 6.6241811,0.9463116, 0.094631169,-9.3684848
341.56505, 2.004975,2.6334, 2.8389347,0.9463116, 0.18926231,-9.2738535
315, 2.184525,2.57355, 2.1160171,2.1160171, 0.12696103,-4.1050731
303.69007, 2.2743,2.483775, 4.1498508,0.82997018, 0.10789611,-10.681716
270, 2.33415,2.394, 0,2.9925, 0.1197,-2.8728
270, 2.33415,2.2743, 0,2.9925, 0.05985,-2.93265
225, 2.33415,2.21445, 2.1160171,2.1160171, 0.042320354,-4.1897137
225, 2.304225,2.184525, 2.1160171,2.1160171, 0.084640679,-4.1473934
180, 2.244375,2.124675, 0,2.9925, 0.05985,-2.93265
170.53768, 2.184525,2.124675, 2.9517838,0.49196398, 0.18202669,-18.020641
170.53768, 2.004975,2.1546, 2.9517838,0.49196398, 0.18202669,-18.020641
135, 1.825425,2.184525, 2.1160171,2.1160171, 0.084640679,-4.1473934
90, 1.765575,2.244375, 0,2.9925, 0.089775,-2.902725
68.198591, 1.765575,2.33415, 9.4467861,0.5556933, 0.16115106,-15.953955
53.130102, 1.825425,2.483775, 10.773,0.5985, 0.149625,-14.812875
104.03624, 2.184525,1.85535, 9.4352421,0.72578788, 0.12338395,-12.21501
71.565051, 2.1546,1.97505, 2.8389347,0.9463116, 0.094631169,-9.3684848
45, 2.184525,2.064825, 2.1160171,2.1160171, 0.084640679,-4.1473934
33.690068, 2.244375,2.124675, 4.1498508,0.82997018, 0.10789611,-10.681716
0, 2.33415,2.184525, 0,2.9925, 0.1197,-2.8728
326.30993, 2.45385,2.184525, 6.6397614,0.82997018, 0.10789611,-10.681716
315, 2.543625,2.124675, 2.1160171,2.1160171, 0.16928136,-4.0627527
300.96376, 2.663325,2.004975, 10.7774,0.51320953, 0.17449124,-17.274632
284.03624, 2.7531,1.85535, 9.4352421,0.72578788, 0.12338395,-12.21501
270, 2.783025,1.73565, 0,2.9925, 0.089775,-2.902725
243.43495, 2.783025,1.645875, 2.6765734,1.3382867, 0.066914335,-6.6245191
206.56505, 2.7531,1.586025, 4.0148601,1.3382867, 0.066914335,-6.6245191
180, 2.69325,1.5561, 0,2.9925, 0.089775,-2.902725
135, 2.603475,1.5561, 2.1160171,2.1160171, 0.084640679,-4.1473934
146.30993, 2.543625,1.61595, 6.6397614,0.82997018, 0.10789611,-10.681716
165.96376, 2.45385,1.6758, 2.9031514,0.72578788, 0.12338395,-12.21501
153.43495, 2.33415,1.705725, 2.6765734,1.3382867, 0.066914335,-6.6245191
126.8699, 2.2743,1.73565, 4.1895,0.5985, 0.149625,-14.812875
71.565051, 2.663325,2.064825, 2.8389347,0.9463116, 0.094631169,-9.3684848
26.565051, 2.69325,2.1546, 4.0148601,1.3382867, 0.066914335,-6.6245191
18.434949, 2.7531,2.184525, 6.6241811,0.9463116, 0.094631169,-9.3684848
0, 2.842875,2.21445, 0,2.9925, 0.05985,-2.93265
333.43495, 2.902725,2.21445, 2.6765734,1.3382867, 0.066914335,-6.6245191
0, 2.962575,2.184525, 0,2.9925, 0.029925,-2.962575
333.43495, 0,2.184525, 2.6765734,1.3382867, 0.13382867,-6.5576048
296.56505, 0.1197,2.124675, 4.0148601,1.3382867, 0.066914335,-6.6245191
251.56505, 0.149625,2.064825, 2.8389347,0.9463116, 0.094631169,-9.3684848
251.56505, 0.1197,1.97505, 2.8389347,0.9463116, 0.094631169,-9.3684848
243.43495, 0.089775,1.885275, 2.6765734,1.3382867, 0.066914335,-6.6245191
206.56505, 0.05985,1.825425, 4.0148601,1.3382867, 0.066914335,-6.6245191
225, 2.9925,1.7955, 2.1160171,2.1160171, 0.042320354,-4.1897137
135, 2.842875,1.765575, 2.1160171,2.1160171, 0.084640679,-4.1473934
123.69007, 2.783025,1.825425, 4.1498508,0.82997018, 0.10789611,-10.681716
116.56505, 2.723175,1.9152, 4.0148601,1.3382867, 0.066914335,-6.6245191
108.43495, 2.69325,1.97505, 6.6241811,0.9463116, 0.094631169,-9.3684848
153.43495, 2.45385,2.184525, 2.6765734,1.3382867, 0.066914335,-6.6245191
123.69007, 2.394,2.21445, 4.1498508,0.82997018, 0.10789611,-10.681716
90, 2.33415,2.304225, 0,2.9925, 0.05985,-2.93265
45, 2.33415,2.364075, 2.1160171,2.1160171, 0.042320354,-4.1897137
26.565051, 2.364075,2.394, 4.0148601,1.3382867, 0.066914335,-6.6245191
345.96376, 2.423925,2.423925, 2.9031514,0.72578788, 0.12338395,-12.21501
315, 2.543625,2.394, 2.1160171,2.1160171, 0.084640679,-4.1473934
270, 2.603475,2.33415, 0,2.9925, 0.089775,-2.902725
243.43495, 2.603475,2.244375, 2.6765734,1.3382867, 0.066914335,-6.6245191
206.56505, 2.57355,2.184525, 4.0148601,1.3382867, 0.066914335,-6.6245191
153.43495, 2.5137,2.1546, 2.6765734,1.3382867, 0.066914335,-6.6245191
198.43495, 0.149625,2.21445, 6.6241811,0.9463116, 0.094631169,-9.3684848
180, 0.05985,2.184525, 0,2.9925, 0.05985,-2.93265
180, 2.9925,2.184525, 0,2.9925, 0.029925,-2.962575
153.43495, 2.962575,2.184525, 2.6765734,1.3382867, 0.066914335,-6.6245191
180, 2.902725,2.21445, 0,2.9925, 0.05985,-2.93265
198.43495, 2.842875,2.21445, 6.6241811,0.9463116, 0.094631169,-9.3684848
180, 2.7531,2.184525, 0,2.9925, 0.089775,-2.902725
135, 2.663325,2.184525, 2.1160171,2.1160171, 0.042320354,-4.1897137
135, 2.6334,2.21445, 2.1160171,2.1160171, 0.042320354,-4.1897137
90, 2.603475,2.244375, 0,2.9925, 0.029925,-2.962575
45, 2.603475,2.2743, 2.1160171,2.1160171, 0.084640679,-4.1473934
26.565051, 2.663325,2.33415, 4.0148601,1.3382867, 0.066914335,-6.6245191
14.036243, 2.723175,2.364075, 9.4352421,0.72578788, 0.12338395,-12.21501
0, 2.842875,2.394, 0,2.9925, 0.089775,-2.902725
333.43495, 2.93265,2.394, 2.6765734,1.3382867, 0.066914335,-6.6245191
0, 0,2.364075, 0,2.9925, 0.029925,-2.962575
0, 0.029925,2.364075, 0,2.9925, 0.029925,-2.962575
341.56505, 0.05985,2.364075, 2.8389347,0.9463116, 0.094631169,-9.3684848
315, 0.149625,2.33415, 2.1160171,2.1160171, 0.042320354,-4.1897137
270, 0.17955,2.304225, 0,2.9925, 0.05985,-2.93265
225, 0.17955,2.244375, 2.1160171,2.1160171, 0.042320354,-4.1897137
161.56505, 2.842875,2.394, 2.8389347,0.9463116, 0.094631169,-9.3684848
135, 2.7531,2.423925, 2.1160171,2.1160171, 0.042320354,-4.1897137
116.56505, 2.723175,2.45385, 4.0148601,1.3382867, 0.066914335,-6.6245191
90, 2.69325,2.5137, 0,2.9925, 0.05985,-2.93265
63.434949, 2.69325,2.57355, 2.6765734,1.3382867, 0.066914335,-6.6245191
33.690068, 2.723175,2.6334, 4.1498508,0.82997018, 0.10789611,-10.681716
0, 2.81295,2.69325, 0,2.9925, 0.1197,-2.8728
333.43495, 2.93265,2.69325, 2.6765734,1.3382867, 0.066914335,-6.6245191
0, 0,2.663325, 0,2.9925, 0.029925,-2.962575
326.30993, 0.029925,2.663325, 6.6397614,0.82997018, 0.10789611,-10.681716
296.56505, 0.1197,2.603475, 4.0148601,1.3382867, 0.066914335,-6.6245191
251.56505, 0.149625,2.543625, 2.8389347,0.9463116, 0.094631169,-9.3684848
225, 0.089775,2.394, 2.1160171,2.1160171, 0.042320354,-4.1897137
180, 0.05985,2.364075, 0,2.9925, 0.029925,-2.962575
153.43495, 2.9925,2.364075, 2.6765734,1.3382867, 0.066914335,-6.6245191
180, 0.029925,2.364075, 0,2.9925, 0.029925,-2.962575
180, 2.93265,2.394, 0,2.9925, 0.089775,-2.902725
90, 2.304225,2.45385, 0,2.9925, 0.029925,-2.962575
45, 2.304225,2.483775, 2.1160171,2.1160171, 0.042320354,-4.1897137
18.434949, 2.33415,2.5137, 6.6241811,0.9463116, 0.094631169,-9.3684848
345.96376, 2.423925,2.543625, 2.9031514,0.72578788, 0.12338395,-12.21501
0, 2.543625,2.5137, 0,2.9925, 0.149625,-2.842875
296.56505, 2.69325,2.5137, 4.0148601,1.3382867, 0.066914335,-6.6245191
270, 2.723175,2.45385, 0,2.9925, 0.029925,-2.962575
225, 2.723175,2.423925, 2.1160171,2.1160171, 0.042320354,-4.1897137
180, 2.69325,2.394, 0,2.9925, 0.149625,-2.842875
165.96376, 2.543625,2.394, 2.9031514,0.72578788, 0.12338395,-12.21501
206.56505, 2.423925,2.423925, 4.0148601,1.3382867, 0.066914335,-6.6245191
135, 2.364075,2.394, 2.1160171,2.1160171, 0.042320354,-4.1897137
135, 2.33415,2.423925, 2.1160171,2.1160171, 0.042320354,-4.1897137
180, 1.61595,2.8728, 0,2.9925, 0.029925,-2.962575
225, 1.586025,2.8728, 2.1160171,2.1160171, 0.042320354,-4.1897137
270, 1.5561,2.842875, 0,2.9925, 0.029925,-2.962575
270, 1.5561,2.81295, 0,2.9925, 0.029925,-2.962575
315, 1.5561,2.783025, 2.1160171,2.1160171, 0.042320354,-4.1897137
0, 1.586025,2.7531, 0,2.9925, 0.029925,-2.962575
0, 1.61595,2.7531, 0,2.9925, 0.029925,-2.962575
333.43495, 1.645875,2.7531, 2.6765734,1.3382867, 0.066914335,-6.6245191
0, 1.705725,2.723175, 0,2.9925, 0.029925,-2.962575
0, 1.73565,2.723175, 0,2.9925, 0.029925,-2.962575
45, 1.765575,2.723175, 2.1160171,2.1160171, 0.042320354,-4.1897137
63.434949, 1.7955,2.7531, 2.6765734,1.3382867, 0.066914335,-6.6245191
135, 1.825425,2.81295, 2.1160171,2.1160171, 0.042320354,-4.1897137
180, 1.7955,2.842875, 0,2.9925, 0.029925,-2.962575
90, 1.97505,2.902725, 0,2.9925, 0.029925,-2.962575
135, 1.97505,2.93265, 2.1160171,2.1160171, 0.042320354,-4.1897137
165.96376, 1.945125,2.962575, 2.9031514,0.72578788, 0.12338395,-12.21501
225, 1.61595,2.9925, 2.1160171,2.1160171, 0.042320354,-4.1897137
270, 1.586025,2.962575, 0,2.9925, 0.029925,-2.962575
270, 1.586025,2.93265, 0,2.9925, 0.029925,-2.962575
315, 1.586025,2.902725, 2.1160171,2.1160171, 0.042320354,-4.1897137
0, 1.61595,2.8728, 0,2.9925, 0.089775,-2.902725
341.56505, 1.705725,2.8728, 2.8389347,0.9463116, 0.094631169,-9.3684848
0, 1.7955,2.842875, 0,2.9925, 0.05985,-2.93265
26.565051, 1.85535,2.842875, 4.0148601,1.3382867, 0.066914335,-6.6245191
45, 2.663325,2.7531, 2.1160171,2.1160171, 0.042320354,-4.1897137
206.56505, 2.663325,2.7531, 4.0148601,1.3382867, 0.066914335,-6.6245191
206.56505, 2.603475,2.723175, 4.0148601,1.3382867, 0.066914335,-6.6245191
206.56505, 2.543625,2.69325, 4.0148601,1.3382867, 0.066914335,-6.6245191
206.56505, 2.483775,2.663325, 4.0148601,1.3382867, 0.066914335,-6.6245191
243.43495, 2.423925,2.6334, 2.6765734,1.3382867, 0.066914335,-6.6245191
225, 2.394,2.57355, 2.1160171,2.1160171, 0.042320354,-4.1897137
225, 2.364075,2.543625, 2.1160171,2.1160171, 0.042320354,-4.1897137
180, 2.33415,2.5137, 0,2.9925, 0.05985,-2.93265
135, 2.2743,2.5137, 2.1160171,2.1160171, 0.042320354,-4.1897137
153.43495, 2.244375,2.543625, 2.6765734,1.3382867, 0.066914335,-6.6245191
161.56505, 2.184525,2.57355, 2.8389347,0.9463116, 0.094631169,-9.3684848
161.56505, 2.09475,2.603475, 2.8389347,0.9463116, 0.094631169,-9.3684848
198.43495, 2.004975,2.6334, 6.6241811,0.9463116, 0.094631169,-9.3684848
153.43495, 1.9152,2.603475, 2.6765734,1.3382867, 0.066914335,-6.6245191
135, 1.85535,2.6334, 2.1160171,2.1160171, 0.042320354,-4.1897137
116.56505, 1.825425,2.663325, 4.0148601,1.3382867, 0.066914335,-6.6245191
90, 1.7955,2.723175, 0,2.9925, 0.029925,-2.962575
63.434949, 1.7955,2.7531, 2.6765734,1.3382867, 0.066914335,-6.6245191
45, 1.825425,2.81295, 2.1160171,2.1160171, 0.042320354,-4.1897137
18.434949, 1.85535,2.842875, 6.6241811,0.9463116, 0.094631169,-9.3684848
26.565051, 1.945125,2.8728, 4.0148601,1.3382867, 0.066914335,-6.6245191
33.690068, 2.004975,2.902725, 4.1498508,0.82997018, 0.10789611,-10.681716
45, 2.09475,2.962575, 2.1160171,2.1160171, 0.042320354,-4.1897137
63.434949, 2.124675,0, 2.6765734,1.3382867, 0.066914335,-6.6245191
45, 2.1546,0.05985, 2.1160171,2.1160171, 0.042320354,-4.1897137
26.565051, 2.184525,0.089775, 4.0148601,1.3382867, 0.066914335,-6.6245191
26.565051, 2.244375,0.1197, 4.0148601,1.3382867, 0.066914335,-6.6245191
345.96376, 2.304225,0.149625, 2.9031514,0.72578788, 0.12338395,-12.21501
341.56505, 2.423925,0.1197, 2.8389347,0.9463116, 0.094631169,-9.3684848
326.30993, 2.5137,0.089775, 6.6397614,0.82997018, 0.10789611,-10.681716
315, 2.603475,0.029925, 2.1160171,2.1160171, 0.042320354,-4.1897137
315, 2.6334,2.9925, 2.1160171,2.1160171, 0.042320354,-4.1897137
296.56505, 2.663325,2.962575, 4.0148601,1.3382867, 0.066914335,-6.6245191
270, 2.69325,2.902725, 0,2.9925, 0.05985,-2.93265
270, 2.69325,2.842875, 0,2.9925, 0.05985,-2.93265
;; (c)1997 STONE PRODUCTS CORPORATION
*STSSTN, STANDARD STREAM STONE
;%TYPE=MODEL
306.8699, 0.5332,1.49296, 3.7324,0.5332, 0.1333,-13.1967
333.43495, 0.47988,1.51962, 2.3845429,1.1922715, 0.059613573,-5.9017437
345.96376, 0.37324,1.54628, 2.5863999,0.64659999, 0.10992201,-10.882278
206.56505, 0.42656,0.69316, 3.5768143,1.1922715, 0.059613573,-5.9017437
206.56505, 0.5332,0.74648, 3.5768143,1.1922715, 0.11922715,-5.8421301
225, 0.58652,0.7998, 1.8851467,1.8851467, 0.075405864,-3.6948875
270, 0.58652,0.85312, 0,2.666, 0.05332,-2.61268
288.43495, 0.55986,0.9331, 5.9014426,0.84306323, 0.084306331,-8.3463259
315, 0.50654,0.98642, 1.8851467,1.8851467, 0.075405864,-3.6948875
348.69007, 0.37324,1.01308, 2.6142281,0.52284563, 0.13593987,-13.458046
116.56505, 0.6665,1.27968, 3.5768143,1.1922715, 0.11922715,-5.8421301
90, 0.6665,1.1997, 0,2.666, 0.07998,-2.58602
63.434949, 0.61318,1.09306, 2.3845429,1.1922715, 0.11922715,-5.8421301
26.565051, 0.50654,1.03974, 3.5768143,1.1922715, 0.11922715,-5.8421301
11.309932, 0.37324,1.01308, 10.979758,0.52284563, 0.13593987,-13.458046
0, 0.21328,1.01308, 0,2.666, 0.15996,-2.50604
26.565051, 0.74648,1.27968, 3.5768143,1.1922715, 0.11922715,-5.8421301
45, 0.69316,1.22636, 1.8851467,1.8851467, 0.075405864,-3.6948875
63.434949, 0.63984,1.11972, 2.3845429,1.1922715, 0.11922715,-5.8421301
75.963757, 0.61318,1.01308, 2.5863999,0.64659999, 0.10992201,-10.882278
90, 0.61318,0.90644, 0,2.666, 0.10664,-2.55936
104.03624, 0.63984,0.7998, 8.4057997,0.64659999, 0.10992201,-10.882278
135, 0.69316,0.74648, 1.8851467,1.8851467, 0.075405864,-3.6948875
153.43495, 0.7998,0.69316, 2.3845429,1.1922715, 0.11922715,-5.8421301
288.43495, 1.11972,1.78622, 5.9014426,0.84306323, 0.084306331,-8.3463259
296.56505, 1.09306,1.83954, 3.5768143,1.1922715, 0.059613573,-5.9017437
315, 1.0664,1.8662, 1.8851467,1.8851467, 0.037702945,-3.7325904
0, 1.03974,1.8662, 0,2.666, 0.02666,-2.63934
18.434949, 0.95976,1.83954, 5.9014426,0.84306323, 0.084306331,-8.3463259
26.565051, 0.90644,1.81288, 3.5768143,1.1922715, 0.059613573,-5.9017437
71.565051, 0.87978,1.7329, 2.5291897,0.84306323, 0.084306331,-8.3463259
90, 0.87978,1.5996, 0,2.666, 0.1333,-2.5327
135, 0.47988,1.78622, 1.8851467,1.8851467, 0.037702945,-3.7325904
123.69007, 0.5332,1.70624, 3.6970768,0.73941537, 0.09612399,-9.5162757
90, 0.5332,1.65292, 0,2.666, 0.05332,-2.61268
63.434949, 0.50654,1.5996, 2.3845429,1.1922715, 0.059613573,-5.9017437
18.434949, 0.42656,1.57294, 5.9014426,0.84306323, 0.084306331,-8.3463259
0, 0.29326,1.57294, 0,2.666, 0.1333,-2.5327
326.30993, 0.21328,1.62626, 5.9153229,0.73941537, 0.09612399,-9.5162757
0, 0.21328,1.54628, 0,2.666, 0.15996,-2.50604
14.036243, 0.10664,1.51962, 8.4057997,0.64659999, 0.10992201,-10.882278
30.963757, -0.02666,1.43964, 9.6015198,0.45721524, 0.15545318,-15.389865
45, -0.10664,1.35966, 1.8851467,1.8851467, 0.11310881,-3.6571846
71.565051, -0.1333,1.27968, 2.5291897,0.84306323, 0.084306331,-8.3463259
90, -0.1333,1.1997, 0,2.666, 0.07998,-2.58602
108.43495, -0.10664,1.11972, 5.9014426,0.84306323, 0.084306331,-8.3463259
108.43495, -0.07998,1.03974, 5.9014426,0.84306323, 0.084306331,-8.3463259
165.96376, 0.02666,1.01308, 2.5863999,0.64659999, 0.10992201,-10.882278
180, 0.21328,1.01308, 0,2.666, 0.18662,-2.47938
303.69007, 1.22636,2.55936, 3.6970768,0.73941537, 0.09612399,-9.5162757
326.30993, 1.14638,2.61268, 5.9153229,0.73941537, 0.09612399,-9.5162757
0, 1.0664,2.61268, 0,2.666, 0.07998,-2.58602
14.036243, 0.95976,2.58602, 8.4057997,0.64659999, 0.10992201,-10.882278
33.690068, 0.87978,2.5327, 3.6970768,0.73941537, 0.09612399,-9.5162757
56.309932, 0.82646,2.45272, 5.9153229,0.73941537, 0.09612399,-9.5162757
75.963757, 0.7998,2.34608, 2.5863999,0.64659999, 0.10992201,-10.882278
104.03624, 0.82646,2.23944, 8.4057997,0.64659999, 0.10992201,-10.882278
135, 0.85312,2.21278, 1.8851467,1.8851467, 0.037702945,-3.7325904
168.69007, 0.98642,2.18612, 2.6142281,0.52284563, 0.13593987,-13.458046
161.56505, 0.6665,2.2661, 2.5291897,0.84306323, 0.084306331,-8.3463259
180, 0.71982,2.2661, 0,2.666, 0.05332,-2.61268
206.56505, 0.77314,2.29276, 3.5768143,1.1922715, 0.059613573,-5.9017437
243.43495, 0.7998,2.34608, 2.3845429,1.1922715, 0.059613573,-5.9017437
161.56505, 0.77314,2.87928, 2.5291897,0.84306323, 0.084306331,-8.3463259
123.69007, 0.82646,2.7993, 3.6970768,0.73941537, 0.09612399,-9.5162757
101.30993, 0.85312,2.666, 10.979758,0.52284563, 0.13593987,-13.458046
90, 0.85312,2.5327, 0,2.666, 0.1333,-2.5327
71.565051, 0.82646,2.45272, 2.5291897,0.84306323, 0.084306331,-8.3463259
14.036243, 0.87978,2.85262, 8.4057997,0.64659999, 0.10992201,-10.882278
63.434949, 0.85312,2.7993, 2.3845429,1.1922715, 0.059613573,-5.9017437
90, 0.85312,2.69266, 0,2.666, 0.10664,-2.55936
135, 0.90644,2.63934, 1.8851467,1.8851467, 0.075405864,-3.6948875
165.96376, 1.01308,2.61268, 2.5863999,0.64659999, 0.10992201,-10.882278
180, 1.14638,2.61268, 0,2.666, 0.1333,-2.5327
206.56505, 1.1997,2.63934, 3.5768143,1.1922715, 0.059613573,-5.9017437
243.43495, 1.22636,2.69266, 2.3845429,1.1922715, 0.059613573,-5.9017437
270, 1.22636,2.74598, 0,2.666, 0.05332,-2.61268
315, 1.14638,2.82596, 1.8851467,1.8851467, 0.11310881,-3.6571846
341.56505, 0.98642,2.87928, 2.5291897,0.84306323, 0.16861264,-8.2620196
270, 1.30634,2.3994, 0,2.666, 0.05332,-2.61268
288.43495, 1.27968,2.47938, 5.9014426,0.84306323, 0.084306331,-8.3463259
26.565051, 0.58652,2.85262, 3.5768143,1.1922715, 0.11922715,-5.8421301
45, 0.5332,2.7993, 1.8851467,1.8851467, 0.075405864,-3.6948875
78.690068, 0.50654,2.666, 2.6142281,0.52284563, 0.13593987,-13.458046
90, 0.50654,2.5327, 0,2.666, 0.1333,-2.5327
90, 0.50654,2.45272, 0,2.666, 0.07998,-2.58602
108.43495, 0.5332,2.37274, 5.9014426,0.84306323, 0.084306331,-8.3463259
123.69007, 0.58652,2.29276, 3.6970768,0.73941537, 0.09612399,-9.5162757
168.69007, 0.98642,2.18612, 2.6142281,0.52284563, 0.13593987,-13.458046
180, 1.09306,2.18612, 0,2.666, 0.10664,-2.55936
198.43495, 1.17304,2.21278, 5.9014426,0.84306323, 0.084306331,-8.3463259
225, 1.25302,2.29276, 1.8851467,1.8851467, 0.11310881,-3.6571846
225, 1.30634,2.34608, 1.8851467,1.8851467, 0.075405864,-3.6948875
168.69007, 0.63984,1.81288, 2.6142281,0.52284563, 0.13593987,-13.458046
180, 0.74648,1.81288, 0,2.666, 0.10664,-2.55936
188.1301, 0.9331,1.83954, 16.212261,0.37702935, 0.18851467,-18.662952
225, 1.01308,1.91952, 1.8851467,1.8851467, 0.11310881,-3.6571846
270, 1.01308,1.9995, 0,2.666, 0.07998,-2.58602
288.43495, 0.98642,2.07948, 5.9014426,0.84306323, 0.084306331,-8.3463259
315, 0.87978,2.18612, 1.8851467,1.8851467, 0.15081173,-3.6194816
341.56505, 0.7998,2.21278, 2.5291897,0.84306323, 0.084306331,-8.3463259
345.96376, 0.69316,2.23944, 2.5863999,0.64659999, 0.10992201,-10.882278
0, 0.58652,2.23944, 0,2.666, 0.10664,-2.55936
18.434949, 0.50654,2.21278, 5.9014426,0.84306323, 0.084306331,-8.3463259
33.690068, 0.42656,2.15946, 3.6970768,0.73941537, 0.09612399,-9.5162757
45, 0.37324,2.10614, 1.8851467,1.8851467, 0.075405864,-3.6948875
90, 0.37324,1.9995, 0,2.666, 0.10664,-2.55936
108.43495, 0.3999,1.91952, 5.9014426,0.84306323, 0.084306331,-8.3463259
116.56505, 0.42656,1.8662, 3.5768143,1.1922715, 0.059613573,-5.9017437
161.56505, 0.50654,1.83954, 2.5291897,0.84306323, 0.084306331,-8.3463259
291.80141, 1.27968,0.5332, 5.9407653,0.49506378, 0.1435685,-14.213281
270, 1.27968,0.63984, 0,2.666, 0.10664,-2.55936
251.56505, 1.30634,0.71982, 2.5291897,0.84306323, 0.084306331,-8.3463259
213.69007, 1.38632,0.77314, 3.6970768,0.73941537, 0.09612399,-9.5162757
198.43495, 1.4663,0.7998, 5.9014426,0.84306323, 0.084306331,-8.3463259
180, 1.5996,0.7998, 0,2.666, 0.1333,-2.5327
153.43495, 1.70624,0.74648, 2.3845429,1.1922715, 0.11922715,-5.8421301
135, 1.75956,0.69316, 1.8851467,1.8851467, 0.075405864,-3.6948875
135, 1.83954,0.61318, 1.8851467,1.8851467, 0.11310881,-3.6571846
104.03624, 1.8662,0.50654, 8.4057997,0.64659999, 0.10992201,-10.882278
90, 1.8662,0.3999, 0,2.666, 0.10664,-2.55936
63.434949, 1.81288,0.29326, 2.3845429,1.1922715, 0.11922715,-5.8421301
14.036243, 1.70624,0.2666, 8.4057997,0.64659999, 0.10992201,-10.882278
0, 1.57294,0.2666, 0,2.666, 0.1333,-2.5327
348.69007, 1.43964,0.29326, 2.6142281,0.52284563, 0.13593987,-13.458046
326.30993, 1.35966,0.34658, 5.9153229,0.73941537, 0.09612399,-9.5162757
296.56505, 1.333,0.3999, 3.5768143,1.1922715, 0.059613573,-5.9017437
45, 1.14638,1.8662, 1.8851467,1.8851467, 0.037702945,-3.7325904
0, 1.09306,1.8662, 0,2.666, 0.05332,-2.61268
315, 1.03974,1.91952, 1.8851467,1.8851467, 0.075405864,-3.6948875
281.30993, 1.01308,2.05282, 10.979758,0.52284563, 0.13593987,-13.458046
0, 1.0664,2.15946, 0,2.666, 0.07998,-2.58602
45, 1.01308,2.10614, 1.8851467,1.8851467, 0.075405864,-3.6948875
90, 1.01308,2.05282, 0,2.666, 0.05332,-2.61268
135, 0.5332,2.31942, 1.8851467,1.8851467, 0.075405864,-3.6948875
90, 0.5332,2.2661, 0,2.666, 0.05332,-2.61268
63.434949, 0.50654,2.21278, 2.3845429,1.1922715, 0.059613573,-5.9017437
18.434949, 0.42656,2.18612, 5.9014426,0.84306323, 0.084306331,-8.3463259
0, 0.34658,2.18612, 0,2.666, 0.07998,-2.58602
0, 2.07948,1.333, 0,2.666, 0.02666,-2.63934
333.43495, 2.02616,1.35966, 2.3845429,1.1922715, 0.059613573,-5.9017437
333.43495, 1.97284,1.38632, 2.3845429,1.1922715, 0.059613573,-5.9017437
296.56505, 1.94618,1.43964, 3.5768143,1.1922715, 0.059613573,-5.9017437
270, 1.94618,1.49296, 0,2.666, 0.05332,-2.61268
251.56505, 1.97284,1.57294, 2.5291897,0.84306323, 0.084306331,-8.3463259
225, 1.9995,1.5996, 1.8851467,1.8851467, 0.037702945,-3.7325904
180, 2.02616,1.5996, 0,2.666, 0.02666,-2.63934
45, 1.97284,1.70624, 1.8851467,1.8851467, 0.075405864,-3.6948875
0, 1.91952,1.70624, 0,2.666, 0.05332,-2.61268
341.56505, 1.65292,1.78622, 2.5291897,0.84306323, 0.084306331,-8.3463259
315, 1.5996,1.83954, 1.8851467,1.8851467, 0.075405864,-3.6948875
270, 1.5996,1.89286, 0,2.666, 0.05332,-2.61268
243.43495, 1.62626,1.94618, 2.3845429,1.1922715, 0.059613573,-5.9017437
153.43495, 1.41298,1.91952, 2.3845429,1.1922715, 0.059613573,-5.9017437
146.30993, 1.49296,1.8662, 5.9153229,0.73941537, 0.09612399,-9.5162757
90, 1.49296,1.81288, 0,2.666, 0.05332,-2.61268
63.434949, 1.4663,1.75956, 2.3845429,1.1922715, 0.059613573,-5.9017437
45, 1.43964,1.7329, 1.8851467,1.8851467, 0.037702945,-3.7325904
18.434949, 1.22636,1.65292, 5.9014426,0.84306323, 0.084306331,-8.3463259
333.43495, 1.17304,1.67958, 2.3845429,1.1922715, 0.059613573,-5.9017437
296.56505, 1.14638,1.7329, 3.5768143,1.1922715, 0.059613573,-5.9017437
180, 1.11972,1.30634, 0,2.666, 0.05332,-2.61268
206.56505, 1.17304,1.333, 3.5768143,1.1922715, 0.059613573,-5.9017437
251.56505, 1.1997,1.41298, 2.5291897,0.84306323, 0.084306331,-8.3463259
270, 1.1997,1.51962, 0,2.666, 0.10664,-2.55936
116.56505, 1.67958,1.09306, 3.5768143,1.1922715, 0.059613573,-5.9017437
104.03624, 1.70624,0.98642, 8.4057997,0.64659999, 0.10992201,-10.882278
90, 1.70624,0.90644, 0,2.666, 0.07998,-2.58602
45, 1.65292,0.85312, 1.8851467,1.8851467, 0.075405864,-3.6948875
18.434949, 1.57294,0.82646, 5.9014426,0.84306323, 0.084306331,-8.3463259
0, 1.4663,0.82646, 0,2.666, 0.10664,-2.55936
333.43495, 1.41298,0.85312, 2.3845429,1.1922715, 0.059613573,-5.9017437
0, 1.94618,0.5332, 0,2.666, 0.02666,-2.63934
26.565051, 1.89286,0.50654, 3.5768143,1.1922715, 0.059613573,-5.9017437
63.434949, 1.8662,0.45322, 2.3845429,1.1922715, 0.059613573,-5.9017437
90, 1.8662,0.3999, 0,2.666, 0.05332,-2.61268
90, 1.8662,0.31992, 0,2.666, 0.07998,-2.58602
116.56505, 1.89286,0.2666, 3.5768143,1.1922715, 0.059613573,-5.9017437
123.69007, 1.41298,0.2666, 3.6970768,0.73941537, 0.09612399,-9.5162757
90, 1.41298,0.23994, 0,2.666, 0.02666,-2.63934
168.69007, 1.41298,1.1997, 2.6142281,0.52284563, 0.13593987,-13.458046
189.46232, 1.57294,1.22636, 13.586919,0.43828771, 0.16216646,-16.054478
198.43495, 1.7329,1.27968, 5.9014426,0.84306323, 0.16861264,-8.2620196
210.96376, 1.8662,1.35966, 9.6015198,0.45721524, 0.15545318,-15.389865
233.1301, 1.94618,1.4663, 9.5976,0.5332, 0.1333,-13.1967
270, 1.94618,1.62626, 0,2.666, 0.15996,-2.50604
288.43495, 1.91952,1.70624, 5.9014426,0.84306323, 0.084306331,-8.3463259
333.43495, 1.81288,1.75956, 2.3845429,1.1922715, 0.11922715,-5.8421301
0, 1.62626,1.75956, 0,2.666, 0.18662,-2.47938
8.1301023, 1.43964,1.7329, 16.212261,0.37702935, 0.18851467,-18.662952
21.801409, 1.30634,1.67958, 5.9407653,0.49506378, 0.1435685,-14.213281
45, 1.22636,1.5996, 1.8851467,1.8851467, 0.11310881,-3.6571846
78.690068, 1.1997,1.4663, 2.6142281,0.52284563, 0.13593987,-13.458046
90, 1.1997,1.35966, 0,2.666, 0.10664,-2.55936
108.43495, 1.22636,1.27968, 5.9014426,0.84306323, 0.084306331,-8.3463259
135, 1.27968,1.22636, 1.8851467,1.8851467, 0.075405864,-3.6948875
180, 0.9331,1.333, 0,2.666, 0.07998,-2.58602
167.47119, 1.17304,1.27968, 13.59091,0.2891683, 0.24579304,-24.333512
143.1301, 1.27968,1.1997, 9.5976,0.5332, 0.1333,-13.1967
135, 1.30634,1.17304, 1.8851467,1.8851467, 0.037702945,-3.7325904
111.80141, 1.35966,1.03974, 5.9407653,0.49506378, 0.1435685,-14.213281
90, 1.35966,0.9331, 0,2.666, 0.10664,-2.55936
90, 1.35966,0.82646, 0,2.666, 0.10664,-2.55936
71.565051, 1.333,0.74648, 2.5291897,0.84306323, 0.084306331,-8.3463259
33.690068, 1.25302,0.69316, 3.6970768,0.73941537, 0.09612399,-9.5162757
14.036243, 1.14638,0.6665, 8.4057997,0.64659999, 0.10992201,-10.882278
0, 1.01308,0.6665, 0,2.666, 0.1333,-2.5327
352.87498, 0.7998,0.69316, 2.6454128,0.33067659, 0.2149398,-21.279039
270, 2.45272,1.78622, 0,2.666, 0.07998,-2.58602
288.43495, 2.42606,1.8662, 5.9014426,0.84306323, 0.084306331,-8.3463259
303.69007, 2.37274,1.94618, 3.6970768,0.73941537, 0.09612399,-9.5162757
315, 2.31942,1.9995, 1.8851467,1.8851467, 0.075405864,-3.6948875
0, 2.21278,1.9995, 0,2.666, 0.10664,-2.55936
14.036243, 2.10614,1.97284, 8.4057997,0.64659999, 0.10992201,-10.882278
56.309932, 2.05282,1.89286, 5.9153229,0.73941537, 0.09612399,-9.5162757
75.963757, 2.02616,1.78622, 2.5863999,0.64659999, 0.10992201,-10.882278
270, 2.02616,1.89286, 0,2.666, 0.07998,-2.58602
284.03624, 1.9995,1.9995, 8.4057997,0.64659999, 0.10992201,-10.882278
303.69007, 1.94618,2.07948, 3.6970768,0.73941537, 0.09612399,-9.5162757
333.43495, 1.89286,2.10614, 2.3845429,1.1922715, 0.059613573,-5.9017437
0, 1.81288,2.10614, 0,2.666, 0.07998,-2.58602
18.434949, 1.7329,2.07948, 5.9014426,0.84306323, 0.084306331,-8.3463259
45, 1.67958,2.02616, 1.8851467,1.8851467, 0.075405864,-3.6948875
236.30993, 1.7329,2.1328, 5.9153229,0.73941537, 0.09612399,-9.5162757
270, 1.7329,2.21278, 0,2.666, 0.07998,-2.58602
270, 1.7329,2.2661, 0,2.666, 0.05332,-2.61268
303.69007, 1.67958,2.34608, 3.6970768,0.73941537, 0.09612399,-9.5162757
333.43495, 1.62626,2.37274, 2.3845429,1.1922715, 0.059613573,-5.9017437
0, 1.51962,2.37274, 0,2.666, 0.10664,-2.55936
14.036243, 1.41298,2.34608, 8.4057997,0.64659999, 0.10992201,-10.882278
210.96376, 1.89286,2.58602, 9.6015198,0.45721524, 0.15545318,-15.389865
201.80141, 2.02616,2.63934, 5.9407653,0.49506378, 0.1435685,-14.213281
180, 2.10614,2.63934, 0,2.666, 0.07998,-2.58602
173.65981, 2.34608,2.61268, 2.649694,0.29441046, 0.24141656,-23.90024
161.56505, 2.42606,2.58602, 2.5291897,0.84306323, 0.084306331,-8.3463259
116.56505, 2.47938,2.47938, 3.5768143,1.1922715, 0.11922715,-5.8421301
111.80141, 2.5327,2.34608, 5.9407653,0.49506378, 0.1435685,-14.213281
104.03624, 2.55936,2.23944, 8.4057997,0.64659999, 0.10992201,-10.882278
90, 2.55936,2.15946, 0,2.666, 0.07998,-2.58602
45, 2.45272,2.05282, 1.8851467,1.8851467, 0.15081173,-3.6194816
0, 2.31942,2.05282, 0,2.666, 0.1333,-2.5327
352.87498, 2.10614,2.07948, 2.6454128,0.33067659, 0.2149398,-21.279039
344.0546, 1.91952,2.1328, 10.986098,0.36620325, 0.19408773,-19.214685
321.34019, 1.78622,2.23944, 13.323496,0.41635924, 0.17070729,-16.900022
296.56505, 1.7329,2.34608, 3.5768143,1.1922715, 0.11922715,-5.8421301
270, 1.7329,2.42606, 0,2.666, 0.07998,-2.58602
251.56505, 1.75956,2.50604, 2.5291897,0.84306323, 0.084306331,-8.3463259
116.56505, 0.63984,1.38632, 3.5768143,1.1922715, 0.11922715,-5.8421301
146.30993, 0.71982,1.333, 5.9153229,0.73941537, 0.09612399,-9.5162757
180, 0.7998,1.333, 0,2.666, 0.07998,-2.58602
198.43495, 0.87978,1.35966, 5.9014426,0.84306323, 0.084306331,-8.3463259
243.43495, 0.90644,1.41298, 2.3845429,1.1922715, 0.059613573,-5.9017437
281.30993, 0.87978,1.54628, 10.979758,0.52284563, 0.13593987,-13.458046
296.56505, 1.11972,0.21328, 3.5768143,1.1922715, 0.059613573,-5.9017437
315, 1.0664,0.2666, 1.8851467,1.8851467, 0.075405864,-3.6948875
333.43495, 1.01308,0.29326, 2.3845429,1.1922715, 0.059613573,-5.9017437
315, 0.98642,0.31992, 1.8851467,1.8851467, 0.037702945,-3.7325904
288.43495, 1.17304,1.5996, 5.9014426,0.84306323, 0.084306331,-8.3463259
284.03624, 1.14638,1.70624, 8.4057997,0.64659999, 0.10992201,-10.882278
90, 0.87978,1.5996, 0,2.666, 0.10664,-2.55936
101.30993, 0.90644,1.4663, 10.979758,0.52284563, 0.13593987,-13.458046
123.69007, 0.95976,1.38632, 3.6970768,0.73941537, 0.09612399,-9.5162757
135, 1.01308,1.333, 1.8851467,1.8851467, 0.075405864,-3.6948875
153.43495, 1.0664,1.30634, 2.3845429,1.1922715, 0.059613573,-5.9017437
270, 0.9331,0.55986, 0,2.666, 0.10664,-2.55936
270, 0.9331,0.61318, 0,2.666, 0.05332,-2.61268
315, 0.87978,0.6665, 1.8851467,1.8851467, 0.075405864,-3.6948875
341.56505, 0.7998,0.69316, 2.5291897,0.84306323, 0.084306331,-8.3463259
18.434949, 0.71982,0.6665, 5.9014426,0.84306323, 0.084306331,-8.3463259
26.565051, 0.6665,0.63984, 3.5768143,1.1922715, 0.059613573,-5.9017437
63.434949, 0.63984,0.58652, 2.3845429,1.1922715, 0.059613573,-5.9017437
90, 0.63984,0.55986, 0,2.666, 0.02666,-2.63934
101.30993, 0.6665,0.42656, 10.979758,0.52284563, 0.13593987,-13.458046
90, 0.6665,0.31992, 0,2.666, 0.10664,-2.55936
116.56505, 0.69316,0.2666, 3.5768143,1.1922715, 0.059613573,-5.9017437
165.96376, 0.7998,0.23994, 2.5863999,0.64659999, 0.10992201,-10.882278
180, 0.85312,0.23994, 0,2.666, 0.05332,-2.61268
213.69007, 0.9331,0.29326, 3.6970768,0.73941537, 0.09612399,-9.5162757
225, 0.95976,0.31992, 1.8851467,1.8851467, 0.037702945,-3.7325904
270, 0.95976,0.37324, 0,2.666, 0.05332,-2.61268
288.43495, 0.9331,0.45322, 5.9014426,0.84306323, 0.084306331,-8.3463259
270, 0.47988,2.77264, 0,2.666, 0.1333,-2.5327
315, 0.45322,2.7993, 1.8851467,1.8851467, 0.037702945,-3.7325904
0, 0.42656,2.7993, 0,2.666, 0.02666,-2.63934
26.565051, 0.37324,2.77264, 3.5768143,1.1922715, 0.059613573,-5.9017437
45, 0.34658,2.74598, 1.8851467,1.8851467, 0.037702945,-3.7325904
71.565051, 0.31992,2.666, 2.5291897,0.84306323, 0.084306331,-8.3463259
90, 0.2666,2.47938, 0,2.666, 0.05332,-2.61268
116.56505, 0.29326,2.42606, 3.5768143,1.1922715, 0.059613573,-5.9017437
153.43495, 0.34658,2.3994, 2.3845429,1.1922715, 0.059613573,-5.9017437
180, 0.37324,2.3994, 0,2.666, 0.02666,-2.63934
198.43495, 0.45322,2.42606, 5.9014426,0.84306323, 0.084306331,-8.3463259
243.43495, 0.47988,2.47938, 2.3845429,1.1922715, 0.059613573,-5.9017437
251.56505, 0.50654,2.55936, 2.5291897,0.84306323, 0.084306331,-8.3463259
288.43495, 0.47988,2.63934, 5.9014426,0.84306323, 0.084306331,-8.3463259
71.565051, 0.29326,2.58602, 2.5291897,0.84306323, 0.084306331,-8.3463259
180, 0.1333,2.42606, 0,2.666, 0.15996,-2.50604
198.43495, 0.21328,2.45272, 5.9014426,0.84306323, 0.084306331,-8.3463259
236.30993, 0.2666,2.5327, 5.9153229,0.73941537, 0.09612399,-9.5162757
243.43495, 0.29326,2.58602, 2.3845429,1.1922715, 0.059613573,-5.9017437
255.96376, 0.31992,2.69266, 2.5863999,0.64659999, 0.10992201,-10.882278
270, 0.31992,2.74598, 0,2.666, 0.05332,-2.61268
303.69007, 0.2666,2.82596, 3.6970768,0.73941537, 0.09612399,-9.5162757
326.30993, 0.18662,2.87928, 5.9153229,0.73941537, 0.09612399,-9.5162757
341.56505, 1.78622,1.03974, 2.5291897,0.84306323, 0.084306331,-8.3463259
333.43495, 1.7329,1.0664, 2.3845429,1.1922715, 0.059613573,-5.9017437
71.565051, 2.1328,0.31992, 2.5291897,0.84306323, 0.084306331,-8.3463259
63.434949, 2.10614,0.2666, 2.3845429,1.1922715, 0.059613573,-5.9017437
45, 2.07948,0.23994, 1.8851467,1.8851467, 0.037702945,-3.7325904
0, 2.05282,0.23994, 0,2.666, 0.02666,-2.63934
0, 2.02616,0.23994, 0,2.666, 0.02666,-2.63934
333.43495, 1.97284,0.2666, 2.3845429,1.1922715, 0.059613573,-5.9017437
0, 1.89286,0.2666, 0,2.666, 0.07998,-2.58602
153.43495, 2.02616,0.50654, 2.3845429,1.1922715, 0.059613573,-5.9017437
180, 2.05282,0.50654, 0,2.666, 0.02666,-2.63934
146.30993, 2.1328,0.45322, 5.9153229,0.73941537, 0.09612399,-9.5162757
116.56505, 2.15946,0.3999, 3.5768143,1.1922715, 0.059613573,-5.9017437
251.56505, 1.1997,1.97284, 2.5291897,0.84306323, 0.084306331,-8.3463259
270, 1.1997,2.07948, 0,2.666, 0.10664,-2.55936
303.69007, 1.14638,2.15946, 3.6970768,0.73941537, 0.09612399,-9.5162757
180, 1.9995,1.01308, 0,2.666, 0.1333,-2.5327
191.30993, 2.1328,1.03974, 10.979758,0.52284563, 0.13593987,-13.458046
216.8699, 2.23944,1.11972, 3.7324,0.5332, 0.1333,-13.1967
270, 2.23944,1.1997, 0,2.666, 0.07998,-2.58602
303.69007, 2.18612,1.27968, 3.6970768,0.73941537, 0.09612399,-9.5162757
338.19859, 2.05282,1.333, 8.4160841,0.49506378, 0.1435685,-14.213281
0, 1.91952,1.333, 0,2.666, 0.1333,-2.5327
14.036243, 1.81288,1.30634, 8.4057997,0.64659999, 0.10992201,-10.882278
33.690068, 1.7329,1.25302, 3.6970768,0.73941537, 0.09612399,-9.5162757
71.565051, 1.70624,1.17304, 2.5291897,0.84306323, 0.084306331,-8.3463259
90, 1.70624,1.11972, 0,2.666, 0.05332,-2.61268
116.56505, 1.7329,1.0664, 3.5768143,1.1922715, 0.059613573,-5.9017437
180, 0.37324,0.15996, 0,2.666, 0.02666,-2.63934
180, 0.3999,0.15996, 0,2.666, 0.02666,-2.63934
194.03624, 0.50654,0.18662, 8.4057997,0.64659999, 0.10992201,-10.882278
213.69007, 0.58652,0.23994, 3.6970768,0.73941537, 0.09612399,-9.5162757
243.43495, 0.63984,0.34658, 2.3845429,1.1922715, 0.11922715,-5.8421301
270, 0.63984,0.50654, 0,2.666, 0.15996,-2.50604
281.30993, 0.61318,0.63984, 10.979758,0.52284563, 0.13593987,-13.458046
315, 0.55986,0.69316, 1.8851467,1.8851467, 0.075405864,-3.6948875
0, 0.45322,0.69316, 0,2.666, 0.10664,-2.55936
21.801409, 0.31992,0.63984, 5.9407653,0.49506378, 0.1435685,-14.213281
53.130102, 0.23994,0.5332, 9.5976,0.5332, 0.1333,-13.1967
75.963757, 0.21328,0.42656, 2.5863999,0.64659999, 0.10992201,-10.882278
104.03624, 0.23994,0.31992, 8.4057997,0.64659999, 0.10992201,-10.882278
108.43495, 0.2666,0.23994, 5.9014426,0.84306323, 0.084306331,-8.3463259
135, 0.34658,0.15996, 1.8851467,1.8851467, 0.11310881,-3.6571846
206.56505, 2.15946,1.35966, 3.5768143,1.1922715, 0.059613573,-5.9017437
243.43495, 2.18612,1.41298, 2.3845429,1.1922715, 0.059613573,-5.9017437
284.03624, 2.15946,1.51962, 8.4057997,0.64659999, 0.10992201,-10.882278
315, 2.10614,1.57294, 1.8851467,1.8851467, 0.075405864,-3.6948875
341.56505, 2.02616,1.5996, 2.5291897,0.84306323, 0.084306331,-8.3463259
180, 1.43964,2.37274, 0,2.666, 0.02666,-2.63934
180, 1.4663,2.37274, 0,2.666, 0.02666,-2.63934
194.03624, 1.57294,2.3994, 8.4057997,0.64659999, 0.10992201,-10.882278
213.69007, 1.65292,2.45272, 3.6970768,0.73941537, 0.09612399,-9.5162757
243.43495, 1.70624,2.55936, 2.3845429,1.1922715, 0.11922715,-5.8421301
270, 1.70624,2.71932, 0,2.666, 0.15996,-2.50604
281.30993, 1.67958,2.85262, 10.979758,0.52284563, 0.13593987,-13.458046
315, 1.62626,2.90594, 1.8851467,1.8851467, 0.075405864,-3.6948875
0, 1.51962,2.90594, 0,2.666, 0.10664,-2.55936
21.801409, 1.38632,2.85262, 5.9407653,0.49506378, 0.1435685,-14.213281
53.130102, 1.30634,2.74598, 9.5976,0.5332, 0.1333,-13.1967
75.963757, 1.27968,2.63934, 2.5863999,0.64659999, 0.10992201,-10.882278
104.03624, 1.30634,2.5327, 8.4057997,0.64659999, 0.10992201,-10.882278
108.43495, 1.333,2.45272, 5.9014426,0.84306323, 0.084306331,-8.3463259
135, 1.41298,2.37274, 1.8851467,1.8851467, 0.11310881,-3.6571846
180, 0.07998,0.63984, 0,2.666, 0.02666,-2.63934
153.43495, 0.1333,0.61318, 2.3845429,1.1922715, 0.059613573,-5.9017437
135, 0.18662,0.55986, 1.8851467,1.8851467, 0.075405864,-3.6948875
90, 0.18662,0.50654, 0,2.666, 0.05332,-2.61268
108.43495, 0.21328,0.42656, 5.9014426,0.84306323, 0.084306331,-8.3463259
90, 0.21328,0.31992, 0,2.666, 0.10664,-2.55936
63.434949, 0.18662,0.2666, 2.3845429,1.1922715, 0.059613573,-5.9017437
18.434949, 0.10664,0.23994, 5.9014426,0.84306323, 0.084306331,-8.3463259
0, 0,0.23994, 0,2.666, 0.10664,-2.55936
0, -0.05332,0.23994, 0,2.666, 0.05332,-2.61268
341.56505, -0.1333,0.2666, 2.5291897,0.84306323, 0.084306331,-8.3463259
315, -0.18662,0.31992, 1.8851467,1.8851467, 0.075405864,-3.6948875
243.43495, -0.15996,0.37324, 2.3845429,1.1922715, 0.059613573,-5.9017437
270, -0.15996,0.47988, 0,2.666, 0.10664,-2.55936
225, -0.10664,0.5332, 1.8851467,1.8851467, 0.075405864,-3.6948875
216.8699, 0,0.61318, 3.7324,0.5332, 0.1333,-13.1967
206.56505, 0.05332,0.63984, 3.5768143,1.1922715, 0.059613573,-5.9017437
341.56505, 1.57294,1.17304, 2.5291897,0.84306323, 0.084306331,-8.3463259
0, 1.4663,1.17304, 0,2.666, 0.10664,-2.55936
26.565051, 1.41298,1.14638, 3.5768143,1.1922715, 0.059613573,-5.9017437
63.434949, 1.38632,1.09306, 2.3845429,1.1922715, 0.059613573,-5.9017437
90, 1.38632,0.9331, 0,2.666, 0.15996,-2.50604
108.43495, 1.41298,0.85312, 5.9014426,0.84306323, 0.084306331,-8.3463259
284.03624, 0.9331,0.50654, 8.4057997,0.64659999, 0.10992201,-10.882278
251.56505, 0.95976,0.58652, 2.5291897,0.84306323, 0.084306331,-8.3463259
243.43495, 0.98642,0.63984, 2.3845429,1.1922715, 0.059613573,-5.9017437
194.03624, 1.09306,0.6665, 8.4057997,0.64659999, 0.10992201,-10.882278
180, 1.1997,0.6665, 0,2.666, 0.10664,-2.55936
135, 1.25302,0.61318, 1.8851467,1.8851467, 0.075405864,-3.6948875
108.43495, 1.27968,0.5332, 5.9014426,0.84306323, 0.084306331,-8.3463259
108.43495, 0.98642,0.31992, 5.9014426,0.84306323, 0.084306331,-8.3463259
165.96376, 1.25302,0.1333, 2.5863999,0.64659999, 0.10992201,-10.882278
194.03624, 1.35966,0.15996, 8.4057997,0.64659999, 0.10992201,-10.882278
236.30993, 1.41298,0.23994, 5.9153229,0.73941537, 0.09612399,-9.5162757
213.69007, 1.30634,1.94618, 3.6970768,0.73941537, 0.09612399,-9.5162757
180, 1.35966,1.94618, 0,2.666, 0.05332,-2.61268
270, 1.14638,1.78622, 0,2.666, 0.05332,-2.61268
243.43495, 1.17304,1.83954, 2.3845429,1.1922715, 0.059613573,-5.9017437
225, 1.22636,1.89286, 1.8851467,1.8851467, 0.075405864,-3.6948875
291.80141, 0.5332,1.62626, 5.9407653,0.49506378, 0.1435685,-14.213281
270, 0.5332,1.7329, 0,2.666, 0.10664,-2.55936
225, 0.58652,1.78622, 1.8851467,1.8851467, 0.075405864,-3.6948875
206.56505, 0.63984,1.81288, 3.5768143,1.1922715, 0.059613573,-5.9017437
180, 0.71982,1.81288, 0,2.666, 0.07998,-2.58602
161.56505, 0.7998,1.78622, 2.5291897,0.84306323, 0.084306331,-8.3463259
135, 0.82646,1.75956, 1.8851467,1.8851467, 0.037702945,-3.7325904
104.03624, 0.85312,1.65292, 8.4057997,0.64659999, 0.10992201,-10.882278
104.03624, 0.87978,1.54628, 8.4057997,0.64659999, 0.10992201,-10.882278
284.03624, -0.02666,0.82646, 8.4057997,0.64659999, 0.10992201,-10.882278
255.96376, 0,0.9331, 2.5863999,0.64659999, 0.10992201,-10.882278
225, 0.05332,0.98642, 1.8851467,1.8851467, 0.075405864,-3.6948875
194.03624, 0.15996,1.01308, 8.4057997,0.64659999, 0.10992201,-10.882278
180, 0.31992,1.01308, 0,2.666, 0.15996,-2.50604
14.036243, 0.2666,0.63984, 8.4057997,0.64659999, 0.10992201,-10.882278
0, 0.15996,0.63984, 0,2.666, 0.10664,-2.55936
341.56505, 0.07998,0.6665, 2.5291897,0.84306323, 0.084306331,-8.3463259
326.30993, 0,0.71982, 5.9153229,0.73941537, 0.09612399,-9.5162757
225, 1.30634,2.31942, 1.8851467,1.8851467, 0.11310881,-3.6571846
194.03624, 1.41298,2.34608, 8.4057997,0.64659999, 0.10992201,-10.882278
56.309932, 1.62626,1.97284, 5.9153229,0.73941537, 0.09612399,-9.5162757
33.690068, 1.54628,1.91952, 3.6970768,0.73941537, 0.09612399,-9.5162757
0, 1.4663,1.91952, 0,2.666, 0.07998,-2.58602
341.56505, 1.38632,1.94618, 2.5291897,0.84306323, 0.084306331,-8.3463259
341.56505, 1.30634,1.97284, 2.5291897,0.84306323, 0.084306331,-8.3463259
326.30993, 1.22636,2.02616, 5.9153229,0.73941537, 0.09612399,-9.5162757
284.03624, 1.1997,2.1328, 8.4057997,0.64659999, 0.10992201,-10.882278
255.96376, 1.22636,2.23944, 2.5863999,0.64659999, 0.10992201,-10.882278
243.43495, 2.02616,0.02666, 2.3845429,1.1922715, 0.059613573,-5.9017437
251.56505, 2.05282,0.10664, 2.5291897,0.84306323, 0.084306331,-8.3463259
270, 2.05282,0.15996, 0,2.666, 0.05332,-2.61268
315, 1.9995,0.21328, 1.8851467,1.8851467, 0.075405864,-3.6948875
333.43495, 1.94618,0.23994, 2.3845429,1.1922715, 0.059613573,-5.9017437
0, 1.89286,0.23994, 0,2.666, 0.05332,-2.61268
26.565051, 1.83954,0.21328, 3.5768143,1.1922715, 0.059613573,-5.9017437
45, 1.81288,0.18662, 1.8851467,1.8851467, 0.037702945,-3.7325904
26.565051, 1.75956,0.15996, 3.5768143,1.1922715, 0.059613573,-5.9017437
56.309932, 1.70624,0.07998, 5.9153229,0.73941537, 0.09612399,-9.5162757
90, 1.70624,0.02666, 0,2.666, 0.05332,-2.61268
108.43495, 1.7329,-0.05332, 5.9014426,0.84306323, 0.084306331,-8.3463259
165.96376, 1.83954,-0.07998, 2.5863999,0.64659999, 0.10992201,-10.882278
180, 1.89286,-0.07998, 0,2.666, 0.05332,-2.61268
206.56505, 1.94618,-0.05332, 3.5768143,1.1922715, 0.059613573,-5.9017437
206.56505, 1.9995,-0.02666, 3.5768143,1.1922715, 0.059613573,-5.9017437
243.43495, 1.65292,1.9995, 2.3845429,1.1922715, 0.059613573,-5.9017437
225, 1.67958,2.02616, 1.8851467,1.8851467, 0.037702945,-3.7325904
90, 2.02616,1.7329, 0,2.666, 0.07998,-2.58602
333.43495, -0.1333,2.47938, 2.3845429,1.1922715, 0.11922715,-5.8421301
296.56505, -0.18662,2.58602, 3.5768143,1.1922715, 0.11922715,-5.8421301
288.43495, -0.21328,2.666, 5.9014426,0.84306323, 0.084306331,-8.3463259
270, -0.21328,2.74598, 0,2.666, 0.07998,-2.58602
251.56505, -0.18662,2.82596, 2.5291897,0.84306323, 0.084306331,-8.3463259
225, -0.1333,2.87928, 1.8851467,1.8851467, 0.075405864,-3.6948875
194.03624, -0.02666,2.90594, 8.4057997,0.64659999, 0.10992201,-10.882278
180, 0.07998,2.90594, 0,2.666, 0.10664,-2.55936
165.96376, 0.18662,2.87928, 2.5863999,0.64659999, 0.10992201,-10.882278
243.43495, 2.07948,0.15996, 2.3845429,1.1922715, 0.059613573,-5.9017437
251.56505, 2.10614,0.23994, 2.5291897,0.84306323, 0.084306331,-8.3463259
251.56505, 2.15946,0.3999, 2.5291897,0.84306323, 0.16861264,-8.2620196
225, 2.23944,0.47988, 1.8851467,1.8851467, 0.11310881,-3.6571846
206.56505, 2.29276,0.50654, 3.5768143,1.1922715, 0.059613573,-5.9017437
180, 2.37274,0.50654, 0,2.666, 0.07998,-2.58602
146.30993, 2.45272,0.45322, 5.9153229,0.73941537, 0.09612399,-9.5162757
116.56505, 2.47938,0.3999, 3.5768143,1.1922715, 0.059613573,-5.9017437
90, 2.47938,0.29326, 0,2.666, 0.10664,-2.55936
71.565051, 2.45272,0.21328, 2.5291897,0.84306323, 0.084306331,-8.3463259
71.565051, 2.42606,0.1333, 2.5291897,0.84306323, 0.084306331,-8.3463259
71.565051, 2.3994,0.05332, 2.5291897,0.84306323, 0.084306331,-8.3463259
45, 2.34608,0, 1.8851467,1.8851467, 0.075405864,-3.6948875
14.036243, 2.23944,-0.02666, 8.4057997,0.64659999, 0.10992201,-10.882278
0, 2.15946,-0.02666, 0,2.666, 0.07998,-2.58602
341.56505, 2.07948,0, 2.5291897,0.84306323, 0.084306331,-8.3463259
296.56505, 2.05282,0.05332, 3.5768143,1.1922715, 0.059613573,-5.9017437
270, 2.05282,0.10664, 0,2.666, 0.05332,-2.61268
99.462322, 2.31942,0.58652, 13.586919,0.43828771, 0.16216646,-16.054478
116.56505, 2.34608,0.5332, 3.5768143,1.1922715, 0.059613573,-5.9017437
161.56505, 2.42606,0.50654, 2.5291897,0.84306323, 0.084306331,-8.3463259
180, 2.47938,0.50654, 0,2.666, 0.05332,-2.61268
206.56505, 2.5327,0.5332, 3.5768143,1.1922715, 0.059613573,-5.9017437
213.69007, 2.61268,0.58652, 3.6970768,0.73941537, 0.09612399,-9.5162757
225, 2.666,0.63984, 1.8851467,1.8851467, 0.075405864,-3.6948875
270, 2.666,0.6665, 0,2.666, 0.02666,-2.63934
270, 2.666,0.69316, 0,2.666, 0.02666,-2.63934
281.30993, 2.63934,0.82646, 10.979758,0.52284563, 0.13593987,-13.458046
270, 2.63934,0.9331, 0,2.666, 0.10664,-2.55936
315, 2.58602,0.98642, 1.8851467,1.8851467, 0.075405864,-3.6948875
333.43495, 2.5327,1.01308, 2.3845429,1.1922715, 0.059613573,-5.9017437
0, 2.47938,1.01308, 0,2.666, 0.05332,-2.61268
18.434949, 2.3994,0.98642, 5.9014426,0.84306323, 0.084306331,-8.3463259
26.565051, 2.34608,0.95976, 3.5768143,1.1922715, 0.059613573,-5.9017437
45, 2.29276,0.90644, 1.8851467,1.8851467, 0.075405864,-3.6948875
90, 2.29276,0.82646, 0,2.666, 0.07998,-2.58602
296.56505, 2.29276,0.61318, 3.5768143,1.1922715, 0.059613573,-5.9017437
0, 2.23944,0.61318, 0,2.666, 0.05332,-2.61268
26.565051, 2.1328,0.55986, 3.5768143,1.1922715, 0.11922715,-5.8421301
63.434949, 2.10614,0.50654, 2.3845429,1.1922715, 0.059613573,-5.9017437
90, 2.10614,0.47988, 0,2.666, 0.02666,-2.63934
153.43495, 2.15946,0.45322, 2.3845429,1.1922715, 0.059613573,-5.9017437
180, 2.18612,0.45322, 0,2.666, 0.02666,-2.63934
206.56505, 2.23944,0.47988, 3.5768143,1.1922715, 0.059613573,-5.9017437
206.56505, 2.29276,0.50654, 3.5768143,1.1922715, 0.059613573,-5.9017437
243.43495, 2.31942,0.55986, 2.3845429,1.1922715, 0.059613573,-5.9017437
56.309932, 2.45272,1.70624, 5.9153229,0.73941537, 0.09612399,-9.5162757
90, 2.45272,1.5996, 0,2.666, 0.10664,-2.55936
104.03624, 2.47938,1.49296, 8.4057997,0.64659999, 0.10992201,-10.882278
135, 2.5327,1.43964, 1.8851467,1.8851467, 0.075405864,-3.6948875
180, 2.61268,1.43964, 0,2.666, 0.07998,-2.58602
206.56505, 2.71932,1.49296, 3.5768143,1.1922715, 0.11922715,-5.8421301
236.30993, 2.77264,1.57294, 5.9153229,0.73941537, 0.09612399,-9.5162757
255.96376, 2.7993,1.67958, 2.5863999,0.64659999, 0.10992201,-10.882278
270, 2.7993,1.75956, 0,2.666, 0.07998,-2.58602
296.56505, 2.77264,1.81288, 3.5768143,1.1922715, 0.059613573,-5.9017437
345.96376, 2.666,1.83954, 2.5863999,0.64659999, 0.10992201,-10.882278
14.036243, 2.55936,1.81288, 8.4057997,0.64659999, 0.10992201,-10.882278
26.565051, 2.50604,1.78622, 3.5768143,1.1922715, 0.059613573,-5.9017437
341.56505, 2.34608,1.62626, 2.5291897,0.84306323, 0.084306331,-8.3463259
18.434949, 2.2661,1.5996, 5.9014426,0.84306323, 0.084306331,-8.3463259
45, 2.21278,1.54628, 1.8851467,1.8851467, 0.075405864,-3.6948875
71.565051, 2.18612,1.4663, 2.5291897,0.84306323, 0.084306331,-8.3463259
104.03624, 2.21278,1.35966, 8.4057997,0.64659999, 0.10992201,-10.882278
108.43495, 2.23944,1.27968, 5.9014426,0.84306323, 0.084306331,-8.3463259
108.43495, 2.2661,1.1997, 5.9014426,0.84306323, 0.084306331,-8.3463259
135, 2.31942,1.14638, 1.8851467,1.8851467, 0.075405864,-3.6948875
180, 2.3994,1.14638, 0,2.666, 0.07998,-2.58602
206.56505, 2.45272,1.17304, 3.5768143,1.1922715, 0.059613573,-5.9017437
236.30993, 2.50604,1.25302, 5.9153229,0.73941537, 0.09612399,-9.5162757
270, 2.50604,1.35966, 0,2.666, 0.10664,-2.55936
270, 2.50604,1.43964, 0,2.666, 0.07998,-2.58602
296.56505, 2.47938,1.49296, 3.5768143,1.1922715, 0.059613573,-5.9017437
296.56505, 2.42606,1.5996, 3.5768143,1.1922715, 0.11922715,-5.8421301
90, 2.02616,1.67958, 0,2.666, 0.10664,-2.55936
116.56505, 2.05282,1.62626, 3.5768143,1.1922715, 0.059613573,-5.9017437
135, 2.07948,1.5996, 1.8851467,1.8851467, 0.037702945,-3.7325904
180, 2.18612,1.5996, 0,2.666, 0.10664,-2.55936
180, 2.23944,1.5996, 0,2.666, 0.05332,-2.61268
198.43495, 2.31942,1.62626, 5.9014426,0.84306323, 0.084306331,-8.3463259
198.43495, 2.3994,1.65292, 5.9014426,0.84306323, 0.084306331,-8.3463259
225, 2.45272,1.70624, 1.8851467,1.8851467, 0.075405864,-3.6948875
315, 2.50604,2.02616, 1.8851467,1.8851467, 0.075405864,-3.6948875
0, 2.47938,2.02616, 0,2.666, 0.02666,-2.63934
33.690068, 2.3994,1.97284, 3.6970768,0.73941537, 0.09612399,-9.5162757
90, 2.3994,1.91952, 0,2.666, 0.05332,-2.61268
123.69007, 2.45272,1.83954, 3.6970768,0.73941537, 0.09612399,-9.5162757
153.43495, 2.50604,1.81288, 2.3845429,1.1922715, 0.059613573,-5.9017437
180, 2.55936,1.81288, 0,2.666, 0.05332,-2.61268
225, 2.61268,1.8662, 1.8851467,1.8851467, 0.075405864,-3.6948875
270, 2.61268,1.89286, 0,2.666, 0.02666,-2.63934
303.69007, 2.55936,1.97284, 3.6970768,0.73941537, 0.09612399,-9.5162757
180, 0.42656,2.3994, 0,2.666, 0.02666,-2.63934
153.43495, 0.47988,2.37274, 2.3845429,1.1922715, 0.059613573,-5.9017437
315, 0.2666,2.2661, 1.8851467,1.8851467, 0.11310881,-3.6571846
270, 0.2666,2.31942, 0,2.666, 0.05332,-2.61268
225, 0.31992,2.37274, 1.8851467,1.8851467, 0.075405864,-3.6948875
198.43495, 0.3999,2.3994, 5.9014426,0.84306323, 0.084306331,-8.3463259
45, 0.23994,2.2661, 1.8851467,1.8851467, 0.037702945,-3.7325904
0, 0.07998,2.2661, 0,2.666, 0.15996,-2.50604
18.434949, 0,2.23944, 5.9014426,0.84306323, 0.084306331,-8.3463259
0, -0.05332,2.23944, 0,2.666, 0.05332,-2.61268
333.43495, -0.10664,2.2661, 2.3845429,1.1922715, 0.059613573,-5.9017437
270, -0.10664,2.31942, 0,2.666, 0.05332,-2.61268
243.43495, -0.07998,2.37274, 2.3845429,1.1922715, 0.059613573,-5.9017437
206.56505, -0.02666,2.3994, 3.5768143,1.1922715, 0.059613573,-5.9017437
180, 0.05332,2.3994, 0,2.666, 0.07998,-2.58602
180, 0.15996,2.3994, 0,2.666, 0.10664,-2.55936
153.43495, 0.21328,2.37274, 2.3845429,1.1922715, 0.059613573,-5.9017437
135, 0.2666,2.31942, 1.8851467,1.8851467, 0.075405864,-3.6948875
180, 0.1333,1.83954, 0,2.666, 0.07998,-2.58602
198.43495, 0.21328,1.8662, 5.9014426,0.84306323, 0.084306331,-8.3463259
216.8699, 0.31992,1.94618, 3.7324,0.5332, 0.1333,-13.1967
236.30993, 0.37324,2.02616, 5.9153229,0.73941537, 0.09612399,-9.5162757
270, 0.37324,2.1328, 0,2.666, 0.10664,-2.55936
296.56505, 0.34658,2.18612, 3.5768143,1.1922715, 0.059613573,-5.9017437
323.1301, 0.23994,2.2661, 9.5976,0.5332, 0.1333,-13.1967
0, 0.07998,2.2661, 0,2.666, 0.15996,-2.50604
26.565051, -0.02666,2.21278, 3.5768143,1.1922715, 0.11922715,-5.8421301
56.309932, -0.07998,2.1328, 5.9153229,0.73941537, 0.09612399,-9.5162757
75.963757, -0.10664,2.02616, 2.5863999,0.64659999, 0.10992201,-10.882278
108.43495, -0.07998,1.94618, 5.9014426,0.84306323, 0.084306331,-8.3463259
116.56505, -0.05332,1.89286, 3.5768143,1.1922715, 0.059613573,-5.9017437
153.43495, 0.05332,1.83954, 2.3845429,1.1922715, 0.11922715,-5.8421301
303.69007, 0.15996,1.70624, 3.6970768,0.73941537, 0.09612399,-9.5162757
270, 0.15996,1.78622, 0,2.666, 0.07998,-2.58602
225, 0.21328,1.83954, 1.8851467,1.8851467, 0.075405864,-3.6948875
198.43495, 0.29326,1.8662, 5.9014426,0.84306323, 0.084306331,-8.3463259
180, 0.34658,1.8662, 0,2.666, 0.05332,-2.61268
153.43495, 0.45322,1.81288, 2.3845429,1.1922715, 0.11922715,-5.8421301
198.43495, 2.34608,1.14638, 5.9014426,0.84306323, 0.084306331,-8.3463259
180, 2.42606,1.14638, 0,2.666, 0.07998,-2.58602
153.43495, 2.47938,1.11972, 2.3845429,1.1922715, 0.059613573,-5.9017437
135, 2.50604,1.09306, 1.8851467,1.8851467, 0.037702945,-3.7325904
90, 2.50604,1.03974, 0,2.666, 0.05332,-2.61268
45, 2.47938,1.01308, 1.8851467,1.8851467, 0.037702945,-3.7325904
14.036243, 2.37274,0.98642, 8.4057997,0.64659999, 0.10992201,-10.882278
33.690068, 2.29276,0.9331, 3.6970768,0.73941537, 0.09612399,-9.5162757
0, 2.2661,0.9331, 0,2.666, 0.02666,-2.63934
333.43495, 2.21278,0.95976, 2.3845429,1.1922715, 0.059613573,-5.9017437
333.43495, 2.15946,0.98642, 2.3845429,1.1922715, 0.059613573,-5.9017437
270, 2.15946,1.01308, 0,2.666, 0.02666,-2.63934
243.43495, 2.18612,1.0664, 2.3845429,1.1922715, 0.059613573,-5.9017437
213.69007, 2.2661,1.11972, 3.6970768,0.73941537, 0.09612399,-9.5162757
168.69007, 2.18612,0.95976, 2.6142281,0.52284563, 0.13593987,-13.458046
146.30993, 2.2661,0.90644, 5.9153229,0.73941537, 0.09612399,-9.5162757
108.43495, 2.29276,0.82646, 5.9014426,0.84306323, 0.084306331,-8.3463259
90, 2.29276,0.74648, 0,2.666, 0.07998,-2.58602
63.434949, 2.2661,0.69316, 2.3845429,1.1922715, 0.059613573,-5.9017437
56.309932, 2.21278,0.61318, 5.9153229,0.73941537, 0.09612399,-9.5162757
26.565051, 2.10614,0.55986, 3.5768143,1.1922715, 0.11922715,-5.8421301
0, 1.9995,0.55986, 0,2.666, 0.10664,-2.55936
338.19859, 1.8662,0.61318, 8.4160841,0.49506378, 0.1435685,-14.213281
315, 1.81288,0.6665, 1.8851467,1.8851467, 0.075405864,-3.6948875
315, 1.75956,0.71982, 1.8851467,1.8851467, 0.075405864,-3.6948875
284.03624, 1.7329,0.82646, 8.4057997,0.64659999, 0.10992201,-10.882278
251.56505, 1.75956,0.90644, 2.5291897,0.84306323, 0.084306331,-8.3463259
225, 1.81288,0.95976, 1.8851467,1.8851467, 0.075405864,-3.6948875
198.43495, 1.89286,0.98642, 5.9014426,0.84306323, 0.084306331,-8.3463259
180, 1.97284,0.98642, 0,2.666, 0.07998,-2.58602
0, 1.97284,0.98642, 0,2.666, 0.07998,-2.58602
180, 1.67958,0.2666, 0,2.666, 0.10664,-2.55936
;; (c)1997 STONE PRODUCTS CORPORATION
*WTRWSH, WATER WASH
;%TYPE=MODEL
146.30993, 1.3832,-0.5852, 5.9020101,0.73775127, 0.095907657,-9.4948587
296.56505, 2.527,2.3408, 3.5687645,1.1895882, 0.059479409,-5.8884614
315, 2.4472,2.4206, 1.8809041,1.8809041, 0.11285425,-3.6489538
326.30993, 2.3674,2.4738, 5.9020101,0.73775127, 0.095907657,-9.4948587
198.43495, 1.463,-0.5586, 5.888161,0.84116587, 0.084116595,-8.327542
203.96249, 1.7024,-0.4522, 5.9418057,0.27008209, 0.26197962,-25.935982
165.96376, 0.0266,1.2768, 2.5805791,0.64514478, 0.21934921,-10.748112
172.87498, 0.2394,1.2502, 2.6394592,0.32993238, 0.21445606,-21.231149
180, 0.3192,1.2502, 0,2.66, 0.0798,-2.5802
198.43495, 0.399,1.2768, 5.888161,0.84116587, 0.084116595,-8.327542
251.56505, 0.4256,1.3566, 2.5234976,0.84116587, 0.084116595,-8.327542
258.69007, 0.4522,1.4896, 2.6083447,0.52166893, 0.13563393,-13.427758
255.96376, 0.4788,1.596, 2.5805791,0.64514478, 0.10967462,-10.857786
243.43495, 0.532,1.7024, 2.3791764,1.1895882, 0.11895882,-5.828982
258.69007, 0.5586,1.8354, 2.6083447,0.52166893, 0.13563393,-13.427758
296.56505, 0.532,1.8886, 3.5687645,1.1895882, 0.059479409,-5.8884614
326.30993, 0.4522,1.9418, 5.9020101,0.73775127, 0.095907657,-9.4948587
323.1301, 0.3458,2.0216, 9.576,0.532, 0.133,-13.167
323.1301, 0.2394,2.1014, 9.576,0.532, 0.133,-13.167
315, 0.1596,2.1812, 1.8809041,1.8809041, 0.11285425,-3.6489538
333.43495, 0.0532,2.2344, 2.3791764,1.1895882, 0.11895882,-5.828982
0, 0,2.2344, 0,2.66, 0.0532,-2.6068
45, -0.0532,2.1812, 1.8809041,1.8809041, 0.075236158,-3.6865719
63.434949, -0.1064,2.0748, 2.3791764,1.1895882, 0.11895882,-5.828982
90, -0.1064,1.9684, 0,2.66, 0.1064,-2.5536
71.565051, -0.1596,1.8088, 2.5234976,0.84116587, 0.16823316,-8.2434254
80.537678, -0.1862,1.6492, 2.6238078,0.43730131, 0.1618015,-16.018347
68.198591, -0.2394,1.5162, 8.3971432,0.4939496, 0.14324539,-14.181293
90, -0.2394,1.3832, 0,2.66, 0.133,-2.527
135, -0.1862,1.33, 1.8809041,1.8809041, 0.075236158,-3.6865719
296.56505, 0.9576,1.2236, 3.5687645,1.1895882, 0.059479409,-5.8884614
315, 0.9044,1.2768, 1.8809041,1.8809041, 0.075236158,-3.6865719
351.8699, 0.7182,1.3034, 2.6332657,0.37618082, 0.18809041,-18.62095
0, 0.6118,1.3034, 0,2.66, 0.1064,-2.5536
18.434949, 0.4522,1.2502, 5.888161,0.84116587, 0.16823316,-8.2434254
14.036243, 0.3458,1.2236, 8.386882,0.64514478, 0.10967462,-10.857786
14.036243, 1.4896,1.5428, 8.386882,0.64514478, 0.10967462,-10.857786
6.3401918, 1.2502,1.5162, 21.443594,0.29374787, 0.24087324,-23.846452
18.434949, 1.0906,1.463, 5.888161,0.84116587, 0.16823316,-8.2434254
33.690068, 1.0108,1.4098, 3.6887563,0.73775127, 0.095907657,-9.4948587
33.690068, 0.931,1.3566, 3.6887563,0.73775127, 0.095907657,-9.4948587
18.434949, 0.8512,1.33, 5.888161,0.84116587, 0.084116595,-8.327542
348.69007, 0.7182,1.3566, 2.6083447,0.52166893, 0.13563393,-13.427758
345.96376, 0.6118,1.3832, 2.5805791,0.64514478, 0.10967462,-10.857786
326.30993, 0.532,1.4364, 5.9020101,0.73775127, 0.095907657,-9.4948587
288.43495, 0.5054,1.5162, 5.888161,0.84116587, 0.084116595,-8.327542
270, 0.5054,1.6226, 0,2.66, 0.1064,-2.5536
180, 0.3458,1.2236, 0,2.66, 0.2128,-2.4472
146.30993, 0.133,0.7182, 5.9020101,0.73775127, 0.095907657,-9.4948587
143.1301, 0.2394,0.6384, 9.576,0.532, 0.133,-13.167
71.565051, 1.1438,-0.1064, 2.5234976,0.84116587, 0.084116595,-8.327542
90, 1.1438,-0.133, 0,2.66, 0.0266,-2.6334
104.03624, 1.1704,-0.2394, 8.386882,0.64514478, 0.10967462,-10.857786
123.69007, 1.2236,-0.3192, 3.6887563,0.73775127, 0.095907657,-9.4948587
104.03624, 1.2502,-0.4256, 8.386882,0.64514478, 0.10967462,-10.857786
116.56505, 1.2768,-0.4788, 3.5687645,1.1895882, 0.059479409,-5.8884614
116.56505, 1.3034,-0.532, 3.5687645,1.1895882, 0.059479409,-5.8884614
236.30993, 1.7556,-0.3724, 5.9020101,0.73775127, 0.095907657,-9.4948587
248.19859, 1.8088,-0.2394, 8.3971432,0.4939496, 0.14324539,-14.181293
225, 1.8886,-0.1596, 1.8809041,1.8809041, 0.11285425,-3.6489538
236.30993, 1.9418,-0.0798, 5.9020101,0.73775127, 0.095907657,-9.4948587
248.19859, 1.995,0.0532, 8.3971432,0.4939496, 0.14324539,-14.181293
270, 1.995,0.133, 0,2.66, 0.0798,-2.5802
284.03624, 1.9684,0.2394, 8.386882,0.64514478, 0.10967462,-10.857786
281.30993, 1.9418,0.3724, 10.955047,0.52166893, 0.13563393,-13.427758
279.46232, 1.9152,0.532, 13.55634,0.43730131, 0.1618015,-16.018347
270, 1.9152,0.6384, 0,2.66, 0.1064,-2.5536
296.56505, 1.8886,0.6916, 3.5687645,1.1895882, 0.059479409,-5.8884614
315, 1.8354,0.7448, 1.8809041,1.8809041, 0.075236158,-3.6865719
341.56505, 1.7556,0.7714, 2.5234976,0.84116587, 0.084116595,-8.327542
345.96376, 1.6492,0.798, 2.5805791,0.64514478, 0.10967462,-10.857786
0, 1.5694,0.798, 0,2.66, 0.0798,-2.5802
18.434949, 1.4896,0.7714, 5.888161,0.84116587, 0.084116595,-8.327542
68.198591, 1.4364,0.6384, 8.3971432,0.4939496, 0.14324539,-14.181293
75.963757, 1.4098,0.532, 2.5805791,0.64514478, 0.10967462,-10.857786
75.963757, 1.3832,0.4256, 2.5805791,0.64514478, 0.10967462,-10.857786
68.198591, 1.33,0.2926, 8.3971432,0.4939496, 0.14324539,-14.181293
63.434949, 1.2768,0.1862, 2.3791764,1.1895882, 0.11895882,-5.828982
56.309932, 1.2236,0.1064, 5.9020101,0.73775127, 0.095907657,-9.4948587
68.198591, 1.1704,-0.0266, 8.3971432,0.4939496, 0.14324539,-14.181293
270, 0.5852,0.2926, 0,2.66, 0.133,-2.527
236.30993, 0.6384,0.3724, 5.9020101,0.73775127, 0.095907657,-9.4948587
206.56505, 0.7448,0.4256, 3.5687645,1.1895882, 0.11895882,-5.828982
216.8699, 0.8512,0.5054, 3.724,0.532, 0.133,-13.167
236.30993, 0.9044,0.5852, 5.9020101,0.73775127, 0.095907657,-9.4948587
251.56505, 0.931,0.665, 2.5234976,0.84116587, 0.084116595,-8.327542
233.1301, 1.0108,0.7714, 9.576,0.532, 0.133,-13.167
213.69007, 1.0906,0.8246, 3.6887563,0.73775127, 0.095907657,-9.4948587
180, 1.2236,0.8246, 0,2.66, 0.133,-2.527
146.30993, 1.3034,0.7714, 5.9020101,0.73775127, 0.095907657,-9.4948587
123.69007, 1.3566,0.6916, 3.6887563,0.73775127, 0.095907657,-9.4948587
104.03624, 1.3832,0.5852, 8.386882,0.64514478, 0.10967462,-10.857786
75.963757, 1.33,0.3724, 2.5805791,0.64514478, 0.21934921,-10.748112
66.801409, 1.2502,0.1862, 14.32028,0.3492751, 0.20257956,-20.055377
56.309932, 1.1438,0.0266, 5.9020101,0.73775127, 0.19181534,-9.3989511
26.565051, 1.0906,0, 3.5687645,1.1895882, 0.059479409,-5.8884614
0, 0.9576,0, 0,2.66, 0.133,-2.527
348.69007, 0.8246,0.0266, 2.6083447,0.52166893, 0.13563393,-13.427758
348.69007, 0.6916,0.0532, 2.6083447,0.52166893, 0.13563393,-13.427758
326.30993, 0.6118,0.1064, 5.9020101,0.73775127, 0.095907657,-9.4948587
296.56505, 0.5852,0.1596, 3.5687645,1.1895882, 0.059479409,-5.8884614
68.198591, 0.9044,0.665, 8.3971432,0.4939496, 0.14324539,-14.181293
63.434949, 0.8512,0.5586, 2.3791764,1.1895882, 0.11895882,-5.828982
36.869898, 0.7448,0.4788, 3.724,0.532, 0.133,-13.167
14.036243, 0.6384,0.4522, 8.386882,0.64514478, 0.10967462,-10.857786
0, 0.532,0.4522, 0,2.66, 0.1064,-2.5536
341.56505, 0.4522,0.4788, 2.5234976,0.84116587, 0.084116595,-8.327542
323.1301, 0.3458,0.5586, 9.576,0.532, 0.133,-13.167
323.1301, 0.2394,0.6384, 9.576,0.532, 0.133,-13.167
296.56505, 0.0266,0.8246, 3.5687645,1.1895882, 0.059479409,-5.8884614
270, 0.0266,0.931, 0,2.66, 0.1064,-2.5536
255.96376, 0.0532,1.0374, 2.5805791,0.64514478, 0.10967462,-10.857786
270, 0.0532,1.1172, 0,2.66, 0.0798,-2.5802
251.56505, 0.0798,1.197, 2.5234976,0.84116587, 0.084116595,-8.327542
206.56505, 0.133,1.2236, 3.5687645,1.1895882, 0.059479409,-5.8884614
284.03624, 1.9418,0.5054, 8.386882,0.64514478, 0.10967462,-10.857786
270, 1.9418,0.7182, 0,2.66, 0.2128,-2.4472
233.1301, 2.0216,0.8246, 9.576,0.532, 0.133,-13.167
206.56505, 2.0748,0.8512, 3.5687645,1.1895882, 0.059479409,-5.8884614
180, 2.1812,0.8512, 0,2.66, 0.1064,-2.5536
165.96376, 2.2876,0.8246, 2.5805791,0.64514478, 0.10967462,-10.857786
159.44395, 2.5004,0.7448, 8.4058951,0.31132946, 0.22727051,-22.499779
165.96376, 2.6068,0.7182, 2.5805791,0.64514478, 0.10967462,-10.857786
171.8699, 2.793,0.6916, 2.6332657,0.37618082, 0.18809041,-18.62095
143.1301, 2.8994,0.6118, 9.576,0.532, 0.133,-13.167
141.34019, 3.0324,0.5054, 13.293511,0.4154222, 0.1703231,-16.861987
135, 3.1654,0.3724, 1.8809041,1.8809041, 0.18809041,-3.5737177
111.80141, 3.2186,0.2394, 5.9273952,0.4939496, 0.14324539,-14.181293
90, 3.2186,0.0798, 0,2.66, 0.1596,-2.5004
71.565051, 3.192,0, 2.5234976,0.84116587, 0.084116595,-8.327542
36.869898, 3.0856,-0.0798, 3.724,0.532, 0.133,-13.167
26.565051, 2.9792,-0.133, 3.5687645,1.1895882, 0.11895882,-5.828982
18.434949, 2.8994,-0.1596, 5.888161,0.84116587, 0.084116595,-8.327542
11.309932, 2.7664,-0.1862, 10.955047,0.52166893, 0.13563393,-13.427758
26.565051, 2.66,-0.2394, 3.5687645,1.1895882, 0.11895882,-5.828982
0, 2.5802,-0.2394, 0,2.66, 0.0798,-2.5802
338.19859, 2.4472,-0.1862, 8.3971432,0.4939496, 0.14324539,-14.181293
341.56505, 2.2876,-0.133, 2.5234976,0.84116587, 0.16823316,-8.2434254
338.19859, 2.1546,-0.0798, 8.3971432,0.4939496, 0.14324539,-14.181293
315, 2.1014,-0.0266, 1.8809041,1.8809041, 0.075236158,-3.6865719
315, 2.0482,0.0266, 1.8809041,1.8809041, 0.075236158,-3.6865719
296.56505, 2.0216,0.0798, 3.5687645,1.1895882, 0.059479409,-5.8884614
281.30993, 1.995,0.2128, 10.955047,0.52166893, 0.13563393,-13.427758
278.1301, 1.9684,0.399, 16.175775,0.37618082, 0.18809041,-18.62095
270, 1.9418,1.064, 0,2.66, 0.0532,-2.6068
236.30993, 1.995,1.1438, 5.9020101,0.73775127, 0.095907657,-9.4948587
198.43495, 2.0748,1.1704, 5.888161,0.84116587, 0.084116595,-8.327542
194.03624, 2.1812,1.197, 8.386882,0.64514478, 0.10967462,-10.857786
213.69007, 2.261,1.2502, 3.6887563,0.73775127, 0.095907657,-9.4948587
213.69007, 2.3408,1.3034, 3.6887563,0.73775127, 0.095907657,-9.4948587
180, 2.5004,1.3034, 0,2.66, 0.1596,-2.5004
165.96376, 2.6068,1.2768, 2.5805791,0.64514478, 0.10967462,-10.857786
135, 2.66,1.2236, 1.8809041,1.8809041, 0.075236158,-3.6865719
101.30993, 2.6866,1.0906, 10.955047,0.52166893, 0.13563393,-13.427758
71.565051, 2.66,1.0108, 2.5234976,0.84116587, 0.084116595,-8.327542
56.309932, 2.6068,0.931, 5.9020101,0.73775127, 0.095907657,-9.4948587
56.309932, 2.5536,0.8512, 5.9020101,0.73775127, 0.095907657,-9.4948587
14.036243, 2.4472,0.8246, 8.386882,0.64514478, 0.10967462,-10.857786
0, 2.3408,0.8246, 0,2.66, 0.1064,-2.5536
345.96376, 2.2344,0.8512, 2.5805791,0.64514478, 0.10967462,-10.857786
345.96376, 2.128,0.8778, 2.5805791,0.64514478, 0.10967462,-10.857786
345.96376, 2.0216,0.9044, 2.5805791,0.64514478, 0.10967462,-10.857786
315, 1.9684,0.9576, 1.8809041,1.8809041, 0.075236158,-3.6865719
296.56505, 1.9418,1.0108, 3.5687645,1.1895882, 0.059479409,-5.8884614
251.56505, 2.5004,1.8354, 2.5234976,0.84116587, 0.084116595,-8.327542
260.53768, 2.527,1.995, 2.6238078,0.43730131, 0.1618015,-16.018347
270, 2.527,2.1014, 0,2.66, 0.1064,-2.5536
261.8699, 2.5536,2.2876, 2.6332657,0.37618082, 0.18809041,-18.62095
341.56505, 2.2078,2.527, 2.5234976,0.84116587, 0.16823316,-8.2434254
333.43495, 2.1014,2.5802, 2.3791764,1.1895882, 0.11895882,-5.828982
0, 2.0216,2.5802, 0,2.66, 0.0798,-2.5802
33.690068, 1.9418,2.527, 3.6887563,0.73775127, 0.095907657,-9.4948587
45, 1.8886,2.4738, 1.8809041,1.8809041, 0.075236158,-3.6865719
53.130102, 1.8088,2.3674, 9.576,0.532, 0.133,-13.167
63.434949, 1.7556,2.261, 2.3791764,1.1895882, 0.11895882,-5.828982
56.309932, 1.7024,2.1812, 5.9020101,0.73775127, 0.095907657,-9.4948587
21.801409, 1.5694,2.128, 5.9273952,0.4939496, 0.14324539,-14.181293
75.963757, 0.7182,2.261, 2.5805791,0.64514478, 0.21934921,-10.748112
78.690068, 0.6916,2.128, 2.6083447,0.52166893, 0.13563393,-13.427758
71.565051, 0.665,2.0482, 2.5234976,0.84116587, 0.084116595,-8.327542
71.565051, 0.6384,1.9684, 2.5234976,0.84116587, 0.084116595,-8.327542
45, 0.6118,1.9418, 1.8809041,1.8809041, 0.037618092,-3.7241901
0, 0.5586,1.9418, 0,2.66, 0.0532,-2.6068
333.43495, 0.4522,1.995, 2.3791764,1.1895882, 0.11895882,-5.828982
321.34019, 0.3192,2.1014, 13.293511,0.4154222, 0.1703231,-16.861987
315, 0.1596,2.261, 1.8809041,1.8809041, 0.22570847,-3.5360996
288.43495, 0.133,2.3408, 5.888161,0.84116587, 0.084116595,-8.327542
255.96376, 0.1596,2.4472, 2.5805791,0.64514478, 0.10967462,-10.857786
201.80141, 0.2926,2.5004, 5.9273952,0.4939496, 0.14324539,-14.181293
194.03624, 0.399,2.527, 8.386882,0.64514478, 0.10967462,-10.857786
218.65981, 0.532,2.6334, 3.7387998,0.4154222, 0.1703231,-16.861987
198.43495, 0.6118,2.66, 5.888161,0.84116587, 0.084116595,-8.327542
165.96376, 0.7182,2.6334, 2.5805791,0.64514478, 0.10967462,-10.857786
123.69007, 0.7714,2.5536, 3.6887563,0.73775127, 0.095907657,-9.4948587
90, 0.7714,2.4738, 0,2.66, 0.0798,-2.5802
26.565051, 2.0748,1.4364, 3.5687645,1.1895882, 0.29739704,-5.6505438
26.565051, 2.3408,1.596, 3.5687645,1.1895882, 0.059479409,-5.8884614
315, 1.4364,1.9418, 1.8809041,1.8809041, 0.075236158,-3.6865719
45, 2.394,1.6226, 1.8809041,1.8809041, 0.075236158,-3.6865719
296.56505, 1.4098,1.995, 3.5687645,1.1895882, 0.059479409,-5.8884614
243.43495, 1.4364,2.0482, 2.3791764,1.1895882, 0.059479409,-5.8884614
210.96376, 1.5694,2.128, 9.579911,0.45618625, 0.15510332,-15.355229
71.565051, 2.4472,1.6758, 2.5234976,0.84116587, 0.084116595,-8.327542
29.744881, 2.1546,1.4896, 15.506822,0.32993238, 0.21445606,-21.231149
14.036243, 2.0482,1.463, 8.386882,0.64514478, 0.10967462,-10.857786
0, 1.9418,1.463, 0,2.66, 0.1064,-2.5536
345.96376, 1.8354,1.4896, 2.5805791,0.64514478, 0.10967462,-10.857786
333.43495, 1.7822,1.5162, 2.3791764,1.1895882, 0.059479409,-5.8884614
315, 1.6758,1.6226, 1.8809041,1.8809041, 0.15047232,-3.6113357
296.56505, 1.6492,1.6758, 3.5687645,1.1895882, 0.059479409,-5.8884614
303.69007, 1.596,1.7556, 3.6887563,0.73775127, 0.095907657,-9.4948587
308.65981, 1.4896,1.8886, 3.7387998,0.4154222, 0.1703231,-16.861987
236.30993, 0.6118,1.7822, 5.9020101,0.73775127, 0.19181534,-9.3989511
248.19859, 0.665,1.9152, 8.3971432,0.4939496, 0.14324539,-14.181293
260.53768, 0.6916,2.0748, 2.6238078,0.43730131, 0.1618015,-16.018347
258.69007, 0.7448,2.3408, 2.6083447,0.52166893, 0.27126784,-13.292124
248.19859, 0.798,2.4738, 8.3971432,0.4939496, 0.14324539,-14.181293
255.96376, 0.8246,2.5802, 2.5805791,0.64514478, 0.10967462,-10.857786
225, 0.8778,2.6334, 1.8809041,1.8809041, 0.075236158,-3.6865719
180, 1.0108,2.6334, 0,2.66, 0.133,-2.527
135, 1.064,2.5802, 1.8809041,1.8809041, 0.075236158,-3.6865719
123.69007, 1.1172,2.5004, 3.6887563,0.73775127, 0.095907657,-9.4948587
111.80141, 1.1704,2.3674, 5.9273952,0.4939496, 0.14324539,-14.181293
110.55605, 1.2502,2.1546, 14.321155,0.31132946, 0.22727051,-22.499779
129.80557, 1.3832,1.995, 3.7463592,0.3405781, 0.20775265,-20.567511
126.8699, 1.463,1.8886, 3.724,0.532, 0.133,-13.167
129.80557, 1.596,1.729, 3.7463592,0.3405781, 0.20775265,-20.567511
108.43495, 1.6226,1.6492, 5.888161,0.84116587, 0.084116595,-8.327542
90, 1.6226,1.596, 0,2.66, 0.0532,-2.6068
45, 1.596,1.5694, 1.8809041,1.8809041, 0.037618092,-3.7241901
14.036243, 1.4896,1.5428, 8.386882,0.64514478, 0.10967462,-10.857786
248.19859, 1.0108,0.931, 8.3971432,0.4939496, 0.14324539,-14.181293
255.96376, 1.0374,1.0374, 2.5805791,0.64514478, 0.10967462,-10.857786
270, 1.0374,1.0906, 0,2.66, 0.0532,-2.6068
303.69007, 0.9842,1.1704, 3.6887563,0.73775127, 0.095907657,-9.4948587
243.43495, 1.0374,1.3832, 2.3791764,1.1895882, 0.059479409,-5.8884614
225, 1.1172,1.463, 1.8809041,1.8809041, 0.11285425,-3.6489538
194.03624, 1.2236,1.4896, 8.386882,0.64514478, 0.10967462,-10.857786
189.46232, 1.3832,1.5162, 13.55634,0.43730131, 0.1618015,-16.018347
180, 1.5694,1.5162, 0,2.66, 0.1862,-2.4738
180, 1.6492,1.5162, 0,2.66, 0.0798,-2.5802
168.69007, 1.7822,1.4896, 2.6083447,0.52166893, 0.13563393,-13.427758
153.43495, 1.8886,1.4364, 2.3791764,1.1895882, 0.11895882,-5.828982
123.69007, 1.9418,1.3566, 3.6887563,0.73775127, 0.095907657,-9.4948587
108.43495, 1.9684,1.2768, 5.888161,0.84116587, 0.084116595,-8.327542
90, 1.0108,1.2502, 0,2.66, 0.0798,-2.5802
101.30993, 1.0374,1.1172, 10.955047,0.52166893, 0.13563393,-13.427758
111.80141, 1.0906,0.9842, 5.9273952,0.4939496, 0.14324539,-14.181293
135, 1.1704,0.9044, 1.8809041,1.8809041, 0.11285425,-3.6489538
153.43495, 1.2768,0.8512, 2.3791764,1.1895882, 0.11895882,-5.828982
172.87498, 1.4896,0.8246, 2.6394592,0.32993238, 0.21445606,-21.231149
187.12502, 1.7024,0.8512, 18.806147,0.32993238, 0.21445606,-21.231149
206.56505, 1.8088,0.9044, 3.5687645,1.1895882, 0.11895882,-5.828982
225, 1.8886,0.9842, 1.8809041,1.8809041, 0.11285425,-3.6489538
243.43495, 1.9418,1.0906, 2.3791764,1.1895882, 0.11895882,-5.828982
255.96376, 1.9684,1.197, 2.5805791,0.64514478, 0.10967462,-10.857786
270, 1.9684,1.2768, 0,2.66, 0.0798,-2.5802
288.43495, 1.9418,1.3566, 5.888161,0.84116587, 0.084116595,-8.327542
26.565051, 2.1546,1.2236, 3.5687645,1.1895882, 0.11895882,-5.828982
11.309932, 2.0216,1.197, 10.955047,0.52166893, 0.13563393,-13.427758
153.43495, 2.394,1.5428, 2.3791764,1.1895882, 0.059479409,-5.8884614
90, 2.394,1.4896, 0,2.66, 0.0532,-2.6068
90, 2.394,1.3832, 0,2.66, 0.1064,-2.5536
45, 2.3408,1.33, 1.8809041,1.8809041, 0.075236158,-3.6865719
33.690068, 2.261,1.2768, 3.6887563,0.73775127, 0.095907657,-9.4948587
18.434949, 1.995,1.4098, 5.888161,0.84116587, 0.084116595,-8.327542
63.434949, 1.9684,1.3566, 2.3791764,1.1895882, 0.059479409,-5.8884614
90, 1.9684,1.3034, 0,2.66, 0.0532,-2.6068
108.43495, 1.995,1.2236, 5.888161,0.84116587, 0.084116595,-8.327542
135, 2.0216,1.197, 1.8809041,1.8809041, 0.037618092,-3.7241901
191.30993, 2.1546,1.2236, 10.955047,0.52166893, 0.13563393,-13.427758
;; (c)1997 STONE PRODUCTS CORPORATION
*WELSTN, WEATHER EDGE LEDGESTONE
;%TYPE=MODEL
45, -0.02992,2.90224, 2.1156635,2.1156635, 0.042313283,-4.1890137
0, 0.8976,0.35904, 0,2.992, 0.17952,-2.81248
354.28941, 0.5984,0.38896, 2.9771513,0.29771513, 0.30069229,-29.768536
116.56505, 2.51328,1.16688, 4.0141892,1.3380631, 0.066903155,-6.6234122
90, 1.73536,-0.02992, 0,2.992, 0.32912,-2.66288
135, 1.76528,-0.05984, 2.1156635,2.1156635, 0.042313283,-4.1890137
0, 0.02992,1.61568, 0,2.992, 0.35904,-2.63296
8.1301023, -0.17952,1.58576, 18.194706,0.42313271, 0.21156635,-20.945069
180, 2.90224,-0.05984, 0,2.992, 0.02992,-2.96208
225, 2.93216,-0.02992, 2.1156635,2.1156635, 0.042313283,-4.1890137
270, 2.93216,0.08976, 0,2.992, 0.11968,-2.87232
270, 2.93216,0.17952, 0,2.992, 0.08976,-2.90224
284.03624, 2.90224,0.2992, 9.4336657,0.7256666, 0.12336333,-12.212969
315, 2.87232,0.32912, 2.1156635,2.1156635, 0.042313283,-4.1890137
185.71059, 0.2992,0.35904, 27.092077,0.29771513, 0.30069229,-29.768536
0, 0.2992,0.35904, 0,2.992, 0.32912,-2.66288
315, -0.02992,0.02992, 2.1156635,2.1156635, 0.042313283,-4.1890137
270, -0.02992,0.2992, 0,2.992, 0.26928,-2.72272
225, 0,0.32912, 2.1156635,2.1156635, 0.042313283,-4.1890137
45, -0.02992,2.33376, 2.1156635,2.1156635, 0.042313283,-4.1890137
90, -0.02992,2.27392, 0,2.992, 0.05984,-2.93216
135, 0,2.244, 2.1156635,2.1156635, 0.042313283,-4.1890137
0, 0.17952,2.93216, 0,2.992, 1.46608,-1.52592
315, 1.31648,0.41888, 2.1156635,2.1156635, 0.042313283,-4.1890137
225, 1.3464,0.92752, 2.1156635,2.1156635, 0.042313283,-4.1890137
180, 1.22672,0.62832, 0,2.992, 0.08976,-2.90224
135, 1.25664,0.5984, 2.1156635,2.1156635, 0.042313283,-4.1890137
90, 1.25664,0.56848, 0,2.992, 0.02992,-2.96208
0, 0.86768,0.62832, 0,2.992, 0.26928,-2.72272
6.3401918, 0.5984,0.5984, 24.120012,0.33041114, 0.27093712,-26.822775
243.43495, 0.62832,1.22672, 2.6761262,1.3380631, 0.066903155,-6.6234122
180, 1.0472,1.22672, 0,2.992, 0.41888,-2.57312
0, -0.26928,1.22672, 0,2.992, 0.71808,-2.27392
0, 1.13696,0.65824, 0,2.992, 0.08976,-2.90224
355.60129, 0.748,0.68816, 2.983187,0.22947593, 0.39010908,-38.620798
0, 0.17952,0.68816, 0,2.992, 0.56848,-2.42352
1.7357046, -0.80784,0.65824, 95.790696,0.090625077, 0.98781323,-97.79351
0, -0.56848,0.92752, 0,2.992, 0.56848,-2.42352
90, 1.07712,1.97472, 0,2.992, 0.17952,-2.81248
90, 3.11168,1.97472, 0,2.992, 0.17952,-2.81248
90, 1.67552,0.02992, 0,2.992, 0.26928,-2.72272
180, 2.87232,-0.05984, 0,2.992, 1.10704,-1.88496
90, 1.73536,2.66288, 0,2.992, 0.17952,-2.81248
90, 1.73536,2.27392, 0,2.992, 0.26928,-2.72272
270, 1.01728,2.33376, 0,2.992, 0.05984,-2.93216
90, 1.67552,2.27392, 0,2.992, 0.05984,-2.93216
0, 1.10704,2.244, 0,2.992, 0.53856,-2.45344
270, 1.07712,2.33376, 0,2.992, 0.05984,-2.93216
90, 2.00464,1.97472, 0,2.992, 0.17952,-2.81248
270, 2.06448,2.15424, 0,2.992, 0.17952,-2.81248
270, 3.50064,0.56848, 0,2.992, 0.17952,-2.81248
90, 2.06448,0.41888, 0,2.992, 0.1496,-2.8424
270, 1.25664,0.8976, 0,2.992, 0.20944,-2.78256
90, -0.8976,0.68816, 0,2.992, 0.20944,-2.78256
90, 1.25664,0.41888, 0,2.992, 0.1496,-2.8424
270, 0.56848,0.56848, 0,2.992, 0.1496,-2.8424
270, 0.53856,1.16688, 0,2.992, 0.1496,-2.8424
90, -0.41888,1.01728, 0,2.992, 0.1496,-2.8424
270, -0.41888,1.55584, 0,2.992, 0.26928,-2.72272
90, 1.73536,1.67552, 0,2.992, 0.17952,-2.81248
270, 3.11168,1.85504, 0,2.992, 0.17952,-2.81248
0, 2.12432,1.22672, 0,2.992, 0.35904,-2.63296
180, 2.45344,0.98736, 0,2.992, 0.32912,-2.66288
90, 1.496,1.28656, 0,2.992, 0.23936,-2.75264
180, 2.45344,1.25664, 0,2.992, 0.92752,-2.06448
270, 2.48336,1.52592, 0,2.992, 0.23936,-2.75264
90, 1.67552,1.61568, 0,2.992, 0.23936,-2.75264
0, 1.10704,1.58576, 0,2.992, 0.2992,-2.6928
90, 1.43616,1.28656, 0,2.992, 0.20944,-2.78256
0, 1.10704,1.25664, 0,2.992, 0.23936,-2.75264
270, 1.07712,1.496, 0,2.992, 0.20944,-2.78256
90, 2.03456,1.01728, 0,2.992, 0.1496,-2.8424
270, 0.5984,1.16688, 0,2.992, 0.1496,-2.8424
45, 0.17952,2.15424, 2.1156635,2.1156635, 0.042313283,-4.1890137
315, 0.17952,1.67552, 2.1156635,2.1156635, 0.042313283,-4.1890137
135, 1.01728,2.15424, 2.1156635,2.1156635, 0.042313283,-4.1890137
225, 1.01728,1.67552, 2.1156635,2.1156635, 0.042313283,-4.1890137
45, 1.07712,1.85504, 2.1156635,2.1156635, 0.042313283,-4.1890137
315, 1.07712,1.61568, 2.1156635,2.1156635, 0.042313283,-4.1890137
315, 1.6456,1.88496, 2.1156635,2.1156635, 0.042313283,-4.1890137
186.34019, 1.67552,1.61568, 24.120012,0.33041114, 0.27093712,-26.822775
315, 1.40624,1.52592, 2.1156635,2.1156635, 0.042313283,-4.1890137
198.43495, 1.43616,1.28656, 6.6230743,0.94615349, 0.094615358,-9.3669194
315, 1.07712,1.28656, 2.1156635,2.1156635, 0.042313283,-4.1890137
45, 1.07712,1.496, 2.1156635,2.1156635, 0.042313283,-4.1890137
315, 0.98736,1.58576, 2.1156635,2.1156635, 0.042313283,-4.1890137
225, 1.01728,1.28656, 2.1156635,2.1156635, 0.042313283,-4.1890137
45, -0.41888,1.55584, 2.1156635,2.1156635, 0.042313283,-4.1890137
315, -0.41888,1.28656, 2.1156635,2.1156635, 0.042313283,-4.1890137
45, 3.08176,1.6456, 2.1156635,2.1156635, 0.042313283,-4.1890137
315, 3.08176,1.88496, 2.1156635,2.1156635, 0.042313283,-4.1890137
45, 1.73536,1.85504, 2.1156635,2.1156635, 0.042313283,-4.1890137
315, 1.73536,1.67552, 2.1156635,2.1156635, 0.042313283,-4.1890137
45, 1.496,1.52592, 2.1156635,2.1156635, 0.042313283,-4.1890137
315, 2.45344,1.55584, 2.1156635,2.1156635, 0.042313283,-4.1890137
225, 2.48336,1.28656, 2.1156635,2.1156635, 0.042313283,-4.1890137
315, 1.496,1.28656, 2.1156635,2.1156635, 0.042313283,-4.1890137
45, 2.0944,1.1968, 2.1156635,2.1156635, 0.042313283,-4.1890137
315, 2.0944,1.01728, 2.1156635,2.1156635, 0.042313283,-4.1890137
45, 2.45344,0.98736, 2.1156635,2.1156635, 0.042313283,-4.1890137
45, -0.41888,1.16688, 2.1156635,2.1156635, 0.042313283,-4.1890137
315, 0.50864,1.1968, 2.1156635,2.1156635, 0.042313283,-4.1890137
225, 0.53856,1.01728, 2.1156635,2.1156635, 0.042313283,-4.1890137
270, -0.41888,1.01728, 0,2.992, 0.02992,-2.96208
315, 0.5984,1.01728, 2.1156635,2.1156635, 0.042313283,-4.1890137
315, 2.00464,1.1968, 2.1156635,2.1156635, 0.042313283,-4.1890137
225, 2.03456,1.01728, 2.1156635,2.1156635, 0.042313283,-4.1890137
315, 1.22672,0.92752, 2.1156635,2.1156635, 0.042313283,-4.1890137
225, 1.25664,0.68816, 2.1156635,2.1156635, 0.042313283,-4.1890137
45, -0.8976,0.8976, 2.1156635,2.1156635, 0.042313283,-4.1890137
315, -0.8976,0.68816, 2.1156635,2.1156635, 0.042313283,-4.1890137
315, 1.97472,0.92752, 2.1156635,2.1156635, 0.042313283,-4.1890137
45, 1.97472,0.38896, 2.1156635,2.1156635, 0.042313283,-4.1890137
45, 2.06448,0.56848, 2.1156635,2.1156635, 0.042313283,-4.1890137
315, 2.06448,0.41888, 2.1156635,2.1156635, 0.042313283,-4.1890137
315, 3.47072,0.5984, 2.1156635,2.1156635, 0.042313283,-4.1890137
225, 3.50064,0.38896, 2.1156635,2.1156635, 0.042313283,-4.1890137
45, 0.56848,0.56848, 2.1156635,2.1156635, 0.042313283,-4.1890137
315, 0.56848,0.41888, 2.1156635,2.1156635, 0.042313283,-4.1890137
225, 1.25664,0.41888, 2.1156635,2.1156635, 0.042313283,-4.1890137
315, 1.6456,0.32912, 2.1156635,2.1156635, 0.042313283,-4.1890137
225, 1.67552,0.02992, 2.1156635,2.1156635, 0.042313283,-4.1890137
45, 1.73536,0.2992, 2.1156635,2.1156635, 0.042313283,-4.1890137
45, 1.73536,2.8424, 2.1156635,2.1156635, 0.042313283,-4.1890137
315, 1.73536,2.66288, 2.1156635,2.1156635, 0.042313283,-4.1890137
315, 2.87232,2.87232, 2.1156635,2.1156635, 0.042313283,-4.1890137
45, 2.87232,2.63296, 2.1156635,2.1156635, 0.042313283,-4.1890137
315, -0.02992,2.48336, 2.1156635,2.1156635, 0.042313283,-4.1890137
315, 1.6456,2.93216, 2.1156635,2.1156635, 0.042313283,-4.1890137
225, 1.67552,2.48336, 2.1156635,2.1156635, 0.042313283,-4.1890137
315, 1.6456,2.36368, 2.1156635,2.1156635, 0.042313283,-4.1890137
225, 1.67552,2.27392, 2.1156635,2.1156635, 0.042313283,-4.1890137
45, 1.07712,2.33376, 2.1156635,2.1156635, 0.042313283,-4.1890137
315, 1.07712,2.27392, 2.1156635,2.1156635, 0.042313283,-4.1890137
315, 0.98736,2.36368, 2.1156635,2.1156635, 0.042313283,-4.1890137
225, 1.01728,2.27392, 2.1156635,2.1156635, 0.042313283,-4.1890137
45, 1.73536,2.5432, 2.1156635,2.1156635, 0.042313283,-4.1890137
315, 1.73536,2.27392, 2.1156635,2.1156635, 0.042313283,-4.1890137
225, 2.0944,2.18416, 2.1156635,2.1156635, 0.042313283,-4.1890137
315, 2.06448,1.97472, 2.1156635,2.1156635, 0.042313283,-4.1890137
225, 3.11168,1.97472, 2.1156635,2.1156635, 0.042313283,-4.1890137
315, 3.08176,2.18416, 2.1156635,2.1156635, 0.042313283,-4.1890137
45, 1.07712,2.15424, 2.1156635,2.1156635, 0.042313283,-4.1890137
315, 1.07712,1.97472, 2.1156635,2.1156635, 0.042313283,-4.1890137
315, 1.97472,2.18416, 2.1156635,2.1156635, 0.042313283,-4.1890137
225, 2.00464,1.97472, 2.1156635,2.1156635, 0.042313283,-4.1890137
225, 2.90224,2.27392, 2.1156635,2.1156635, 0.042313283,-4.1890137
90, -0.02992,2.48336, 0,2.992, 0.41888,-2.57312
0, 0,2.93216, 0,2.992, 0.17952,-2.81248
0, 1.58576,2.93216, 0,2.992, 0.05984,-2.93216
180, 1.6456,2.45344, 0,2.992, 0.08976,-2.90224
170.53768, 1.55584,2.45344, 2.9512906,0.49188178, 0.18199627,-18.017629
180, 1.37632,2.48336, 0,2.992, 0.41888,-2.57312
188.1301, 0.95744,2.48336, 18.194706,0.42313271, 0.21156635,-20.945069
180, 0.748,2.45344, 0,2.992, 0.748,-2.244
270, 1.67552,2.90224, 0,2.992, 0.08976,-2.90224
251.56505, 1.67552,2.81248, 2.8384604,0.94615349, 0.094615358,-9.3669194
270, 1.6456,2.72272, 0,2.992, 0.05984,-2.93216
288.43495, 1.6456,2.66288, 6.6230743,0.94615349, 0.094615358,-9.3669194
270, 1.67552,2.57312, 0,2.992, 0.08976,-2.90224
0, 0,0, 0,2.992, 1.6456,-1.3464
353.65981, 0.62832,0.35904, 2.9737001,0.33041114, 0.27093712,-26.822775
0, 0.8976,0.32912, 0,2.992, 0.17952,-2.81248
0, 1.07712,0.32912, 0,2.992, 0.56848,-2.42352
0, 0.53856,2.36368, 0,2.992, 0.08976,-2.90224
0, 0,2.36368, 0,2.992, 0.98736,-2.00464
0, 0,2.244, 0,2.992, 0.4488,-2.5432
18.434949, 0.4488,2.244, 6.6230743,0.94615349, 0.094615358,-9.3669194
0, 0.53856,2.27392, 0,2.992, 0.23936,-2.75264
341.56505, 0.77792,2.27392, 2.8384604,0.94615349, 0.094615358,-9.3669194
0, 0.86768,2.244, 0,2.992, 0.11968,-2.87232
0, 1.10704,2.36368, 0,2.992, 0.53856,-2.45344
0, 1.10704,2.18416, 0,2.992, 0.1496,-2.8424
18.434949, 1.25664,2.18416, 6.6230743,0.94615349, 0.094615358,-9.3669194
0, 1.3464,2.21408, 0,2.992, 0.11968,-2.87232
356.63354, 1.46608,2.21408, 2.9868369,0.17569628, 0.50951923,-50.442405
270, 2.90224,2.8424, 0,2.992, 0.17952,-2.81248
296.56505, 2.90224,2.5432, 4.0141892,1.3380631, 0.066903155,-6.6234122
270, 2.93216,2.48336, 0,2.992, 0.11968,-2.87232
251.56505, 2.93216,2.36368, 2.8384604,0.94615349, 0.094615358,-9.3669194
0, 1.76528,2.244, 0,2.992, 0.26928,-2.72272
18.434949, 2.03456,2.244, 6.6230743,0.94615349, 0.094615358,-9.3669194
0, 2.12432,2.27392, 0,2.992, 0.35904,-2.63296
341.56505, 2.48336,2.27392, 2.8384604,0.94615349, 0.094615358,-9.3669194
0, 2.57312,2.244, 0,2.992, 0.2992,-2.6928
0, 1.76528,2.57312, 0,2.992, 0.71808,-2.27392
345.96376, 2.48336,2.57312, 2.9026664,0.7256666, 0.12336333,-12.212969
0, 2.60304,2.5432, 0,2.992, 0.2992,-2.6928
0, -0.86768,0.65824, 0,2.992, 0.08976,-2.90224
0, 0.17952,0.68816, 0,2.992, 0.17952,-2.81248
0, 1.16688,0.65824, 0,2.992, 0.05984,-2.93216
0, -0.86768,0.92752, 0,2.992, 0.32912,-2.66288
0, 0,0.92752, 0,2.992, 1.22672,-1.76528
0, 0.20944,1.6456, 0,2.992, 0.77792,-2.21408
0, 0.20944,2.18416, 0,2.992, 0.77792,-2.21408
270, 1.01728,2.15424, 0,2.992, 0.47872,-2.51328
251.56505, 0.17952,2.15424, 2.8384604,0.94615349, 0.094615358,-9.3669194
270, 0.1496,2.06448, 0,2.992, 0.23936,-2.75264
281.30993, 0.1496,1.82512, 12.322369,0.58677949, 0.15256268,-15.103704
0, -0.38896,1.58576, 0,2.992, 0.23936,-2.75264
348.69007, 0.38896,1.61568, 2.9338974,0.58677949, 0.15256268,-15.103704
0, 0.53856,1.58576, 0,2.992, 0.4488,-2.5432
0, -0.38896,1.25664, 0,2.992, 0.83776,-2.15424
11.309932, 0.4488,1.25664, 12.322369,0.58677949, 0.15256268,-15.103704
0, 0.5984,1.28656, 0,2.992, 0.1496,-2.8424
348.69007, 0.748,1.28656, 2.9338974,0.58677949, 0.15256268,-15.103704
0, 0.8976,1.25664, 0,2.992, 0.08976,-2.90224
14.036243, -0.38896,1.1968, 9.4336657,0.7256666, 0.12336333,-12.212969
333.43495, 0.4488,1.22672, 2.6761262,1.3380631, 0.066903155,-6.6234122
0, -0.41888,0.98736, 0,2.992, 0.92752,-2.06448
0, 1.0472,1.22672, 0,2.992, 0.62832,-2.36368
351.8699, 1.67552,1.22672, 2.9619289,0.42313271, 0.21156635,-20.945069
0, 1.88496,1.1968, 0,2.992, 0.11968,-2.87232
0, 0.62832,0.98736, 0,2.992, 0.1496,-2.8424
345.96376, 0.77792,0.98736, 2.9026664,0.7256666, 0.12336333,-12.212969
0, 0.8976,0.95744, 0,2.992, 0.20944,-2.78256
18.434949, 1.10704,0.95744, 6.6230743,0.94615349, 0.094615358,-9.3669194
0, 1.1968,0.98736, 0,2.992, 0.80784,-2.18416
284.03624, 2.00464,0.8976, 9.4336657,0.7256666, 0.12336333,-12.212969
270, 2.03456,0.77792, 0,2.992, 0.11968,-2.87232
260.53768, 2.03456,0.65824, 2.9512906,0.49188178, 0.18199627,-18.017629
270, 2.00464,0.47872, 0,2.992, 0.05984,-2.93216
90, 1.31648,0.41888, 0,2.992, 0.47872,-2.51328
0, 1.76528,0.32912, 0,2.992, 1.10704,-1.88496
0, 2.0944,0.38896, 0,2.992, 0.17952,-2.81248
345.96376, 2.27392,0.38896, 2.9026664,0.7256666, 0.12336333,-12.212969
0, 2.3936,0.35904, 0,2.992, 1.07712,-1.91488
5.7105931, 2.0944,0.5984, 27.092077,0.29771513, 0.30069229,-29.768536
0, 2.3936,0.62832, 0,2.992, 0.748,-2.244
348.69007, 3.1416,0.62832, 2.9338974,0.58677949, 0.15256268,-15.103704
0, 3.2912,0.5984, 0,2.992, 0.17952,-2.81248
191.30993, 1.22672,0.38896, 12.322369,0.58677949, 0.15256268,-15.103704
18.434949, 1.76528,2.87232, 6.6230743,0.94615349, 0.094615358,-9.3669194
0, 1.85504,2.90224, 0,2.992, 0.11968,-2.87232
355.60129, 1.97472,2.90224, 2.983187,0.22947593, 0.39010908,-38.620798
0, 2.36368,2.87232, 0,2.992, 0.50864,-2.48336
180, 2.87232,2.63296, 0,2.992, 0.20944,-2.78256
206.56505, 2.66288,2.63296, 4.0141892,1.3380631, 0.066903155,-6.6234122
180, 2.60304,2.60304, 0,2.992, 0.32912,-2.66288
161.56505, 2.27392,2.60304, 2.8384604,0.94615349, 0.094615358,-9.3669194
180, 2.18416,2.63296, 0,2.992, 0.41888,-2.57312
180, 3.08176,1.6456, 0,2.992, 0.47872,-2.51328
198.43495, 2.60304,1.6456, 6.6230743,0.94615349, 0.094615358,-9.3669194
180, 2.51328,1.61568, 0,2.992, 0.38896,-2.60304
161.56505, 2.12432,1.61568, 2.8384604,0.94615349, 0.094615358,-9.3669194
180, 2.03456,1.6456, 0,2.992, 0.26928,-2.72272
0, 1.52592,1.55584, 0,2.992, 0.08976,-2.90224
351.8699, 1.61568,1.55584, 2.9619289,0.42313271, 0.21156635,-20.945069
0, 1.82512,1.52592, 0,2.992, 0.32912,-2.66288
14.036243, 2.15424,1.52592, 9.4336657,0.7256666, 0.12336333,-12.212969
0, 2.27392,1.55584, 0,2.992, 0.17952,-2.81248
270, 2.0944,1.1968, 0,2.992, 0.17952,-2.81248
270, 2.51328,1.16688, 0,2.992, 0.11968,-2.87232
225, 2.51328,1.0472, 2.1156635,2.1156635, 0.042313283,-4.1890137
0, 2.0944,2.18416, 0,2.992, 0.32912,-2.66288
351.8699, 2.42352,2.18416, 2.9619289,0.42313271, 0.21156635,-20.945069
0, 2.63296,2.15424, 0,2.992, 0.1496,-2.8424
9.4623222, 2.78256,2.15424, 15.248335,0.49188178, 0.18199627,-18.017629
0, 2.96208,2.18416, 0,2.992, 0.11968,-2.87232
0, 2.0944,1.9448, 0,2.992, 0.98736,-2.00464
0, 1.76528,1.88496, 0,2.992, 0.26928,-2.72272
341.56505, 2.03456,1.88496, 2.8384604,0.94615349, 0.094615358,-9.3669194
0, 2.12432,1.85504, 0,2.992, 0.08976,-2.90224
18.434949, 2.21408,1.85504, 6.6230743,0.94615349, 0.094615358,-9.3669194
0, 2.30384,1.88496, 0,2.992, 0.38896,-2.60304
350.53768, 2.6928,1.88496, 2.9512906,0.49188178, 0.18199627,-18.017629
0, 2.87232,1.85504, 0,2.992, 0.05984,-2.93216
26.565051, 2.93216,1.85504, 4.0141892,1.3380631, 0.066903155,-6.6234122
0, 2.992,1.88496, 0,2.992, 0.08976,-2.90224
0, 1.3464,0.92752, 0,2.992, 0.62832,-2.36368
180, 1.97472,0.38896, 0,2.992, 0.62832,-2.36368
260.53768, 1.07712,1.85504, 2.9512906,0.49188178, 0.18199627,-18.017629
296.56505, 1.0472,1.67552, 4.0141892,1.3380631, 0.066903155,-6.6234122
270, 1.01728,1.55584, 0,2.992, 0.26928,-2.72272
0, 1.10704,1.52592, 0,2.992, 0.08976,-2.90224
0, 1.10704,1.52592, 0,2.992, 0.2992,-2.6928
0, 1.10704,1.88496, 0,2.992, 0.53856,-2.45344
0, 1.10704,1.9448, 0,2.992, 0.86768,-2.12432
0, 2.48336,0.1496, 0,2.992, 0.23936,-2.75264
0, 2.45344,0.11968, 0,2.992, 0.1496,-2.8424
0, -0.53856,0.80784, 0,2.992, 0.2992,-2.6928
0, 0.62832,0.80784, 0,2.992, 0.02992,-2.96208
0, 0.80784,0.748, 0,2.992, 0.17952,-2.81248
0, -0.08976,1.496, 0,2.992, 0.11968,-2.87232
0, 0,1.46608, 0,2.992, 0.08976,-2.90224
0, 0.71808,1.37632, 0,2.992, 0.02992,-2.96208
0, 0.38896,0.26928, 0,2.992, 0.20944,-2.78256
0, 0.47872,0.23936, 0,2.992, 0.1496,-2.8424
0, 1.1968,0.1496, 0,2.992, 0.20944,-2.78256
0, 0.77792,2.78256, 0,2.992, 0.1496,-2.8424
0, 0.83776,2.75264, 0,2.992, 0.02992,-2.96208
0, 0.2992,2.60304, 0,2.992, 0.02992,-2.96208
0, 1.25664,2.63296, 0,2.992, 0.11968,-2.87232
0, 1.97472,2.75264, 0,2.992, 0.20944,-2.78256
0, 2.21408,2.42352, 0,2.992, 0.1496,-2.8424
0, 2.33376,2.3936, 0,2.992, 0.02992,-2.96208
0, 1.58576,1.43616, 0,2.992, 0.02992,-2.96208
0, 0.41888,2.03456, 0,2.992, 0.11968,-2.87232
0, 0.47872,2.00464, 0,2.992, 0.08976,-2.90224
0, 2.45344,1.76528, 0,2.992, 0.11968,-2.87232
0, 1.76528,0.53856, 0,2.992, 0.08976,-2.90224
0, 1.7952,0.56848, 0,2.992, 0.11968,-2.87232
0, 1.73536,0.80784, 0,2.992, 0.02992,-2.96208
;; (c)1997 STONE PRODUCTS CORPORATION
*USDBRK, USED BRICK
;%TYPE=MODEL
0, 1.60765,1.628, 0,2.035, 0.02035,-2.01465
0, 1.5873,1.64835, 0,2.035, 0.06105,-1.97395
0, 0.14245,0.407, 0,2.035, 0.0407,-1.9943
0, 0.22385,0.42735, 0,2.035, 0.02035,-2.01465
0, 0.02035,1.4245, 0,2.035, 0.02035,-2.01465
0, -0.02035,1.44485, 0,2.035, 0.06105,-1.97395
0, -0.14245,0.8547, 0,2.035, 0.02035,-2.01465
0, 0.0407,0.87505, 0,2.035, 0.06105,-1.97395
0, 1.81115,0.10175, 0,2.035, 0.02035,-2.01465
0, 0.3663,0.1628, 0,2.035, 0.0407,-1.9943
0, 0.10175,0.10175, 0,2.035, 0.0407,-1.9943
0, 0.8547,0.30525, 0,2.035, 0.02035,-2.01465
0, 0.59015,0.38665, 0,2.035, 0.02035,-2.01465
0, 1.5466,0.407, 0,2.035, 0.02035,-2.01465
0, 1.3431,0.3663, 0,2.035, 0.0407,-1.9943
0, 0.87505,0.10175, 0,2.035, 0.14245,-1.89255
0, 0.814,0.1221, 0,2.035, 0.0814,-1.9536
0, 1.48555,0.63085, 0,2.035, 0.02035,-2.01465
0, 1.5059,0.6105, 0,2.035, 0.0407,-1.9943
0, 0.4884,0.63085, 0,2.035, 0.02035,-2.01465
0, 0.3256,0.63085, 0,2.035, 0.02035,-2.01465
0, 0.3663,0.6512, 0,2.035, 0.14245,-1.89255
0, 0.6919,0.8954, 0,2.035, 0.02035,-2.01465
0, 0.71225,0.91575, 0,2.035, 0.0407,-1.9943
0, 0.4884,1.9129, 0,2.035, 0.0407,-1.9943
0, 0.22385,1.1396, 0,2.035, 0.06105,-1.97395
0, 1.7094,1.11925, 0,2.035, 0.0407,-1.9943
0, 1.68905,1.1396, 0,2.035, 0.0407,-1.9943
0, 1.44485,1.20065, 0,2.035, 0.0407,-1.9943
0, 1.0989,1.0582, 0,2.035, 0.0407,-1.9943
0, 0.71225,1.3838, 0,2.035, 0.0407,-1.9943
0, 0.75295,1.40415, 0,2.035, 0.06105,-1.97395
0, 0.407,1.64835, 0,2.035, 0.0407,-1.9943
0, 1.221,1.89255, 0,2.035, 0.10175,-1.93325
0, 1.15995,1.9129, 0,2.035, 0.14245,-1.89255
341.56505, 1.1396,0.2849, 1.9305705,0.64352351, 0.064352357,-6.3708827
0, 1.03785,0.2849, 0,2.035, 0.10175,-1.93325
243.43495, 0.99715,0.30525, 1.8201593,0.91007968, 0.045503984,-4.5048944
8.1301023, 0.34595,0.4477, 12.375076,0.28779247, 0.14389623,-14.245727
284.03624, -0.3256,0.34595, 6.41628,0.49356001, 0.083905207,-8.3066147
90, -0.30525,0.95645, 0,2.035, 0.02035,-2.01465
75.963757, -0.3256,0.87505, 1.97424,0.49356001, 0.083905207,-8.3066147
225, 1.3838,0.2035, 1.4389623,1.4389623, 0.028779255,-2.8491454
11.309932, 1.4652,0.2035, 8.381023,0.39909634, 0.10376506,-10.27274
0, 1.3838,0.2035, 0,2.035, 0.0814,-1.9536
333.43495, 0.67155,0.02035, 1.8201593,0.91007968, 0.045503984,-4.5048944
206.56505, 1.3024,0.02035, 2.730239,0.91007968, 0.045503984,-4.5048944
251.56505, 1.32275,0.0814, 1.9305705,0.64352351, 0.064352357,-6.3708827
180, 0.46805,0.7733, 0,2.035, 0.1221,-1.9129
350.53768, 0.83435,0.79365, 2.0073116,0.33455194, 0.12378423,-12.254638
0, 0.6512,0.79365, 0,2.035, 0.18315,-1.85185
6.3401918, 0.46805,0.7733, 16.405155,0.22472816, 0.18427708,-18.243432
78.690068, 1.97395,1.0175, 1.9954817,0.39909634, 0.10376506,-10.27274
45, 1.36345,1.221, 1.4389623,1.4389623, 0.028779255,-2.8491454
170.53768, 1.28205,0.71225, 2.0073116,0.33455194, 0.12378423,-12.254638
180, 1.32275,0.71225, 0,2.035, 0.0407,-1.9943
353.65981, -0.3256,1.3024, 2.0225534,0.22472816, 0.18427708,-18.243432
78.690068, 1.36345,0.63085, 1.9954817,0.39909634, 0.10376506,-10.27274
188.1301, 0.54945,1.03785, 12.375076,0.28779247, 0.14389623,-14.245727
180, 0.63085,1.03785, 0,2.035, 0.0814,-1.9536
225, 0.71225,0.7326, 1.4389623,1.4389623, 0.057558489,-2.8203661
315, 1.628,1.48555, 1.4389623,1.4389623, 0.057558489,-2.8203661
315, 0.9768,0.9768, 1.4389623,1.4389623, 0.028779255,-2.8491454
315, 1.97395,0.7326, 1.4389623,1.4389623, 0.028779255,-2.8491454
45, 1.64835,0.26455, 1.4389623,1.4389623, 0.028779255,-2.8491454
315, 1.3024,0.22385, 1.4389623,1.4389623, 0.028779255,-2.8491454
45, 0.2849,0.7733, 1.4389623,1.4389623, 0.028779255,-2.8491454
315, 1.03785,0.79365, 1.4389623,1.4389623, 0.028779255,-2.8491454
225, 0.6919,1.24135, 1.4389623,1.4389623, 0.028779255,-2.8491454
0, 1.85185,1.7501, 0,2.035, 0.14245,-1.89255
11.309932, 1.7501,1.72975, 8.381023,0.39909634, 0.10376506,-10.27274
348.69007, 1.64835,1.7501, 1.9954817,0.39909634, 0.10376506,-10.27274
315, 1.03785,1.81115, 1.4389623,1.4389623, 0.028779255,-2.8491454
198.43495, 1.32275,1.5466, 4.5046645,0.64352351, 0.064352357,-6.3708827
315, 0.67155,1.56695, 1.4389623,1.4389623, 0.057558489,-2.8203661
315, 0.9768,1.9943, 1.4389623,1.4389623, 0.028779255,-2.8491454
194.03624, 0.30525,1.81115, 6.41628,0.49356001, 0.083905207,-8.3066147
63.434949, -0.3256,1.9536, 1.8201593,0.91007968, 0.045503984,-4.5048944
180, 0.63085,0, 0,2.035, 0.63085,-1.40415
270, 0.63085,0.22385, 0,2.035, 0.22385,-1.81115
0, 0,0.22385, 0,2.035, 0.63085,-1.40415
90, 0,0, 0,2.035, 0.22385,-1.81115
180, 1.9943,0, 0,2.035, 0.63085,-1.40415
270, 1.9943,0.22385, 0,2.035, 0.22385,-1.81115
0, 1.56695,0.22385, 0,2.035, 0.42735,-1.60765
90, 1.36345,0, 0,2.035, 0.18315,-1.85185
180, 1.2617,0, 0,2.035, 0.54945,-1.48555
270, 1.32275,0.2035, 0,2.035, 0.1221,-1.9129
0, 0.67155,0.22385, 0,2.035, 0.63085,-1.40415
90, 0.67155,0.02035, 0,2.035, 0.2035,-1.8315
180, 0.30525,0.26455, 0,2.035, 0.6105,-1.4245
270, 0.30525,0.46805, 0,2.035, 0.2035,-1.8315
0, -0.3256,0.46805, 0,2.035, 0.63085,-1.40415
90, -0.3256,0.34595, 0,2.035, 0.1221,-1.9129
180, 1.64835,0.26455, 0,2.035, 0.4477,-1.5873
270, 1.6687,0.46805, 0,2.035, 0.18315,-1.85185
0, 1.03785,0.46805, 0,2.035, 0.63085,-1.40415
90, 1.03785,0.2849, 0,2.035, 0.18315,-1.85185
180, 0.9768,0.26455, 0,2.035, 0.63085,-1.40415
270, 0.99715,0.46805, 0,2.035, 0.1628,-1.8722
0, 0.4884,0.46805, 0,2.035, 0.50875,-1.52625
90, 0.34595,0.26455, 0,2.035, 0.18315,-1.85185
180, 0.99715,0.7733, 0,2.035, 0.0407,-1.9943
270, 0.99715,0.95645, 0,2.035, 0.18315,-1.85185
0, 0.34595,0.9768, 0,2.035, 0.63085,-1.40415
90, 0.34595,0.7733, 0,2.035, 0.2035,-1.8315
180, 1.6687,0.7733, 0,2.035, 0.6105,-1.4245
270, 1.6687,0.9768, 0,2.035, 0.2035,-1.8315
0, 1.03785,0.9768, 0,2.035, 0.63085,-1.40415
90, 1.03785,0.79365, 0,2.035, 0.18315,-1.85185
180, 0.2849,0.7733, 0,2.035, 0.6105,-1.4245
270, 0.30525,0.9768, 0,2.035, 0.18315,-1.85185
0, -0.30525,0.9768, 0,2.035, 0.6105,-1.4245
90, -0.3256,0.7733, 0,2.035, 0.10175,-1.93325
180, 1.32275,0.50875, 0,2.035, 0.6512,-1.3838
270, 1.32275,0.71225, 0,2.035, 0.2035,-1.8315
0, 0.71225,0.7326, 0,2.035, 0.4477,-1.5873
90, 0.67155,0.50875, 0,2.035, 0.18315,-1.85185
180, 1.9943,0.50875, 0,2.035, 0.63085,-1.40415
270, 1.9943,0.71225, 0,2.035, 0.2035,-1.8315
0, 1.3838,0.7326, 0,2.035, 0.59015,-1.44485
90, 1.36345,0.50875, 0,2.035, 0.1221,-1.9129
180, 0.63085,0.50875, 0,2.035, 0.63085,-1.40415
270, 0.63085,0.7326, 0,2.035, 0.22385,-1.81115
0, 0,0.7326, 0,2.035, 0.63085,-1.40415
90, 0,0.50875, 0,2.035, 0.22385,-1.81115
180, 0.63085,1.52625, 0,2.035, 0.63085,-1.40415
270, 0.63085,1.7501, 0,2.035, 0.22385,-1.81115
0, 0,1.7501, 0,2.035, 0.63085,-1.40415
90, 0,1.52625, 0,2.035, 0.22385,-1.81115
180, 1.9943,1.52625, 0,2.035, 0.63085,-1.40415
270, 1.9943,1.7501, 0,2.035, 0.22385,-1.81115
0, 1.36345,1.7501, 0,2.035, 0.2849,-1.7501
90, 1.36345,1.52625, 0,2.035, 0.22385,-1.81115
180, 1.2617,1.52625, 0,2.035, 0.54945,-1.48555
270, 1.32275,1.7501, 0,2.035, 0.2035,-1.8315
0, 0.67155,1.7501, 0,2.035, 0.6512,-1.3838
90, 0.67155,1.56695, 0,2.035, 0.18315,-1.85185
180, 0.22385,1.7908, 0,2.035, 0.54945,-1.48555
270, 0.30525,1.9943, 0,2.035, 0.18315,-1.85185
0, -0.30525,1.9943, 0,2.035, 0.6105,-1.4245
90, -0.3256,1.7908, 0,2.035, 0.1628,-1.8722
180, 1.6687,1.7908, 0,2.035, 0.6105,-1.4245
270, 1.6687,1.9943, 0,2.035, 0.2035,-1.8315
0, 1.03785,1.9943, 0,2.035, 0.63085,-1.40415
90, 1.03785,1.81115, 0,2.035, 0.18315,-1.85185
180, 0.99715,1.7908, 0,2.035, 0.6512,-1.3838
270, 0.99715,1.97395, 0,2.035, 0.18315,-1.85185
0, 0.34595,1.9943, 0,2.035, 0.63085,-1.40415
90, 0.34595,1.7908, 0,2.035, 0.2035,-1.8315
180, 0.99715,1.28205, 0,2.035, 0.6512,-1.3838
270, 0.99715,1.48555, 0,2.035, 0.2035,-1.8315
0, 0.34595,1.48555, 0,2.035, 0.6512,-1.3838
90, 0.34595,1.28205, 0,2.035, 0.2035,-1.8315
180, 1.6687,1.28205, 0,2.035, 0.63085,-1.40415
270, 1.6687,1.44485, 0,2.035, 0.1628,-1.8722
0, 1.03785,1.48555, 0,2.035, 0.59015,-1.44485
90, 1.03785,1.28205, 0,2.035, 0.2035,-1.8315
180, 0.30525,1.28205, 0,2.035, 0.4477,-1.5873
270, 0.30525,1.48555, 0,2.035, 0.2035,-1.8315
0, -0.3256,1.48555, 0,2.035, 0.63085,-1.40415
90, -0.3256,1.3024, 0,2.035, 0.18315,-1.85185
180, 1.32275,1.0175, 0,2.035, 0.6512,-1.3838
270, 1.32275,1.24135, 0,2.035, 0.22385,-1.81115
0, 0.6919,1.24135, 0,2.035, 0.63085,-1.40415
90, 0.67155,1.0175, 0,2.035, 0.2035,-1.8315
180, 1.97395,1.0175, 0,2.035, 0.6105,-1.4245
270, 1.9943,1.24135, 0,2.035, 0.1221,-1.9129
0, 1.3838,1.24135, 0,2.035, 0.6105,-1.4245
90, 1.36345,1.0175, 0,2.035, 0.2035,-1.8315
180, 0.407,1.0175, 0,2.035, 0.407,-1.628
270, 0.63085,1.24135, 0,2.035, 0.2035,-1.8315
0, 0,1.24135, 0,2.035, 0.63085,-1.40415
90, 0,1.0175, 0,2.035, 0.22385,-1.81115
